/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class Toolkit {
    static void getUnsigned8(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] + 128);
        }
    }

    static void getByteSwapped(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byte by = byArray[n3];
            byArray[n3] = byArray[n3 + 1];
            byArray[n3 + 1] = by;
            n3 += 2;
        }
    }

    static float linearToDB(float f) {
        float f2 = (float)(Math.log((double)f == 0.0 ? 1.0E-4 : (double)f) / Math.log(10.0) * 20.0);
        return f2;
    }

    static float dBToLinear(float f) {
        float f2 = (float)Math.pow(10.0, (double)f / 20.0);
        return f2;
    }

    static long align(long l, int n) {
        if (n <= 1) {
            return l;
        }
        return l - l % (long)n;
    }

    static int align(int n, int n2) {
        if (n2 <= 1) {
            return n;
        }
        return n - n % n2;
    }

    static long millis2bytes(AudioFormat audioFormat, long l) {
        long l2 = (long)((float)l * audioFormat.getFrameRate() / 1000.0f * (float)audioFormat.getFrameSize());
        return Toolkit.align(l2, audioFormat.getFrameSize());
    }

    static long bytes2millis(AudioFormat audioFormat, long l) {
        return (long)((float)l / audioFormat.getFrameRate() * 1000.0f / (float)audioFormat.getFrameSize());
    }

    static long micros2bytes(AudioFormat audioFormat, long l) {
        long l2 = (long)((float)l * audioFormat.getFrameRate() / 1000000.0f * (float)audioFormat.getFrameSize());
        return Toolkit.align(l2, audioFormat.getFrameSize());
    }

    static long bytes2micros(AudioFormat audioFormat, long l) {
        return (long)((float)l / audioFormat.getFrameRate() * 1000000.0f / (float)audioFormat.getFrameSize());
    }

    static long micros2frames(AudioFormat audioFormat, long l) {
        return (long)((float)l * audioFormat.getFrameRate() / 1000000.0f);
    }

    static long frames2micros(AudioFormat audioFormat, long l) {
        return (long)((float)l / audioFormat.getFrameRate() * 1000000.0f);
    }

    public static AudioInputStream getPCMConvertedAudioInputStream(AudioInputStream audioInputStream) {
        block2: {
            AudioFormat audioFormat = audioInputStream.getFormat();
            if (audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || audioFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) break block2;
            try {
                AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), Platform.isBigEndian());
                audioInputStream = AudioSystem.getAudioInputStream(audioFormat2, audioInputStream);
            }
            catch (Exception exception) {
                audioInputStream = null;
            }
        }
        return audioInputStream;
    }
}

