/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private Stack markByteStack = new Stack();
    private Stack markBitStack = new Stack();
    private boolean isClosed = false;
    private static final int BYTE_BUF_LENGTH = 8192;
    private byte[] byteBuf = new byte[8192];
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;

    protected final void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public abstract int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (iIOByteBuffer == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] byArray = new byte[n];
        n = this.read(byArray, 0, n);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n);
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((n2 << 8) + (n << 0));
        }
        return (short)((n << 8) + (n2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFFFFFFFFFL;
    }

    public long readLong() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return ((long)n << 32) + ((long)n2 & 0xFFFFFFFFL);
        }
        return ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        boolean bl = false;
        block4: while (!bl) {
            n = this.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    long l = this.getStreamPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l);
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        String string;
        this.bitOffset = 0;
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
        }
        catch (IOException iOException) {
            this.setByteOrder(byteOrder);
            throw iOException;
        }
        this.setByteOrder(byteOrder);
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void readFully(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = this.read(var1_1, var2_2, var3_3);
            if (var4_4 == -1) {
                throw new EOFException();
            }
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public void readFully(short[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, var4_4 * 2);
            this.toShorts(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void readFully(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, var4_4 * 2);
            this.toChars(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void readFully(int[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, var4_4 * 4);
            this.toInts(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void readFully(long[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, var4_4 * 8);
            this.toLongs(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void readFully(float[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, var4_4 * 4);
            this.toFloats(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void readFully(double[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var2_2 >= 0 && var3_3 >= 0 && var2_2 + var3_3 <= var1_1.length && var2_2 + var3_3 >= 0) ** GOTO lbl8
        throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
lbl-1000:
        // 1 sources

        {
            var4_4 = Math.min(var3_3, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, var4_4 * 8);
            this.toDoubles(this.byteBuf, var1_1, var2_2, var4_4);
            var2_2 += var4_4;
            var3_3 -= var4_4;
lbl8:
            // 2 sources

            ** while (var3_3 > 0)
        }
lbl9:
        // 1 sources

    }

    private void toShorts(byte[] byArray, short[] sArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                sArray[n + n4] = (short)(by << 8 | n5);
                n3 += 2;
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                byte by = byArray[n3 + 1];
                int n7 = byArray[n3] & 0xFF;
                sArray[n + n6] = (short)(by << 8 | n7);
                n3 += 2;
                ++n6;
            }
        }
    }

    private void toChars(byte[] byArray, char[] cArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                cArray[n + n4] = (char)(by << 8 | n5);
                n3 += 2;
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                byte by = byArray[n3 + 1];
                int n7 = byArray[n3] & 0xFF;
                cArray[n + n6] = (char)(by << 8 | n7);
                n3 += 2;
                ++n6;
            }
        }
    }

    private void toInts(byte[] byArray, int[] nArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                int n6 = byArray[n3 + 2] & 0xFF;
                int n7 = byArray[n3 + 3] & 0xFF;
                nArray[n + n4] = by << 24 | n5 << 16 | n6 << 8 | n7;
                n3 += 4;
                ++n4;
            }
        } else {
            int n8 = 0;
            while (n8 < n2) {
                byte by = byArray[n3 + 3];
                int n9 = byArray[n3 + 2] & 0xFF;
                int n10 = byArray[n3 + 1] & 0xFF;
                int n11 = byArray[n3] & 0xFF;
                nArray[n + n8] = by << 24 | n9 << 16 | n10 << 8 | n11;
                n3 += 4;
                ++n8;
            }
        }
    }

    private void toLongs(byte[] byArray, long[] lArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                int n6 = byArray[n3 + 2] & 0xFF;
                int n7 = byArray[n3 + 3] & 0xFF;
                byte by2 = byArray[n3 + 4];
                int n8 = byArray[n3 + 5] & 0xFF;
                int n9 = byArray[n3 + 6] & 0xFF;
                int n10 = byArray[n3 + 7] & 0xFF;
                int n11 = by << 24 | n5 << 16 | n6 << 8 | n7;
                int n12 = by2 << 24 | n8 << 16 | n9 << 8 | n10;
                lArray[n + n4] = (long)n11 << 32 | (long)n12 & 0xFFFFFFFFL;
                n3 += 8;
                ++n4;
            }
        } else {
            int n13 = 0;
            while (n13 < n2) {
                byte by = byArray[n3 + 7];
                int n14 = byArray[n3 + 6] & 0xFF;
                int n15 = byArray[n3 + 5] & 0xFF;
                int n16 = byArray[n3 + 4] & 0xFF;
                byte by3 = byArray[n3 + 3];
                int n17 = byArray[n3 + 2] & 0xFF;
                int n18 = byArray[n3 + 1] & 0xFF;
                int n19 = byArray[n3] & 0xFF;
                int n20 = by << 24 | n14 << 16 | n15 << 8 | n16;
                int n21 = by3 << 24 | n17 << 16 | n18 << 8 | n19;
                lArray[n + n13] = (long)n20 << 32 | (long)n21 & 0xFFFFFFFFL;
                n3 += 8;
                ++n13;
            }
        }
    }

    private void toFloats(byte[] byArray, float[] fArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                int n6 = byArray[n3 + 2] & 0xFF;
                int n7 = byArray[n3 + 3] & 0xFF;
                int n8 = by << 24 | n5 << 16 | n6 << 8 | n7;
                fArray[n + n4] = Float.intBitsToFloat(n8);
                n3 += 4;
                ++n4;
            }
        } else {
            int n9 = 0;
            while (n9 < n2) {
                byte by = byArray[n3 + 3];
                int n10 = byArray[n3 + 2] & 0xFF;
                int n11 = byArray[n3 + 1] & 0xFF;
                int n12 = byArray[n3 + 0] & 0xFF;
                int n13 = by << 24 | n10 << 16 | n11 << 8 | n12;
                fArray[n + n9] = Float.intBitsToFloat(n13);
                n3 += 4;
                ++n9;
            }
        }
    }

    private void toDoubles(byte[] byArray, double[] dArray, int n, int n2) {
        int n3 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int n4 = 0;
            while (n4 < n2) {
                byte by = byArray[n3];
                int n5 = byArray[n3 + 1] & 0xFF;
                int n6 = byArray[n3 + 2] & 0xFF;
                int n7 = byArray[n3 + 3] & 0xFF;
                byte by2 = byArray[n3 + 4];
                int n8 = byArray[n3 + 5] & 0xFF;
                int n9 = byArray[n3 + 6] & 0xFF;
                int n10 = byArray[n3 + 7] & 0xFF;
                int n11 = by << 24 | n5 << 16 | n6 << 8 | n7;
                int n12 = by2 << 24 | n8 << 16 | n9 << 8 | n10;
                long l = (long)n11 << 32 | (long)n12 & 0xFFFFFFFFL;
                dArray[n + n4] = Double.longBitsToDouble(l);
                n3 += 8;
                ++n4;
            }
        } else {
            int n13 = 0;
            while (n13 < n2) {
                byte by = byArray[n3 + 7];
                int n14 = byArray[n3 + 6] & 0xFF;
                int n15 = byArray[n3 + 5] & 0xFF;
                int n16 = byArray[n3 + 4] & 0xFF;
                byte by3 = byArray[n3 + 3];
                int n17 = byArray[n3 + 2] & 0xFF;
                int n18 = byArray[n3 + 1] & 0xFF;
                int n19 = byArray[n3] & 0xFF;
                int n20 = by << 24 | n14 << 16 | n15 << 8 | n16;
                int n21 = by3 << 24 | n17 << 16 | n18 << 8 | n19;
                long l = (long)n20 << 32 | (long)n21 & 0xFFFFFFFFL;
                dArray[n + n13] = Double.longBitsToDouble(l);
                n3 += 8;
                ++n13;
            }
        }
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public void setBitOffset(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = n;
    }

    public int readBit() throws IOException {
        this.checkClosed();
        int n = this.bitOffset + 1 & 7;
        int n2 = this.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n != 0) {
            this.seek(this.getStreamPosition() - 1L);
            n2 >>= 8 - n;
        }
        this.bitOffset = n;
        return n2 & 1;
    }

    public long readBits(int n) throws IOException {
        this.checkClosed();
        if (n < 0 || n > 64) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 0L;
        }
        int n2 = n + this.bitOffset;
        int n3 = this.bitOffset + n & 7;
        long l = 0L;
        while (n2 > 0) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            l <<= 8;
            l |= (long)n4;
            n2 -= 8;
        }
        if (n3 != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = n3;
        l >>>= -n2;
        return l &= -1L >>> 64 - n;
    }

    public long length() {
        return -1L;
    }

    public int skipBytes(int n) throws IOException {
        long l = this.getStreamPosition();
        this.seek(l + (long)n);
        return (int)(this.getStreamPosition() - l);
    }

    public long skipBytes(long l) throws IOException {
        long l2 = this.getStreamPosition();
        this.seek(l2 + l);
        return this.getStreamPosition() - l2;
    }

    public void seek(long l) throws IOException {
        this.checkClosed();
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = l;
        this.bitOffset = 0;
    }

    public void mark() {
        try {
            this.markByteStack.push(new Long(this.getStreamPosition()));
            this.markBitStack.push(new Integer(this.getBitOffset()));
        }
        catch (IOException iOException) {}
    }

    public void reset() throws IOException {
        if (this.markByteStack.empty()) {
            return;
        }
        long l = (Long)this.markByteStack.pop();
        if (l < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(l);
        int n = (Integer)this.markBitStack.pop();
        this.setBitOffset(n);
    }

    public void flushBefore(long l) throws IOException {
        if (l < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (l > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = l;
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

