/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.NumberFormatter;
import javax.swing.text.TextAction;

public class JFormattedTextField
extends JTextField {
    private static final String uiClassID = "FormattedTextFieldUI";
    private static final Action[] defaultActions = new Action[]{new CommitAction(), new CancelAction()};
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private AbstractFormatterFactory factory;
    private AbstractFormatter format;
    private Object value;
    private boolean editValid;
    private int focusLostBehavior;
    private boolean edited;
    private DocumentListener documentListener;
    private Object mask;
    private ActionMap textFormatterActionMap;
    private boolean composedTextExists = false;
    private FocusLostHandler focusLostHandler;
    static /* synthetic */ Class class$javax$swing$text$DocumentFilter;

    public JFormattedTextField() {
        this.enableEvents(4L);
        this.setFocusLostBehavior(1);
    }

    public JFormattedTextField(Object object) {
        this();
        this.setValue(object);
    }

    public JFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format));
    }

    public JFormattedTextField(AbstractFormatter abstractFormatter) {
        this(new DefaultFormatterFactory(abstractFormatter));
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory) {
        this();
        this.setFormatterFactory(abstractFormatterFactory);
    }

    public JFormattedTextField(AbstractFormatterFactory abstractFormatterFactory, Object object) {
        this(object);
        this.setFormatterFactory(abstractFormatterFactory);
    }

    public void setFocusLostBehavior(int n) {
        if (n != 0 && n != 1 && n != 3 && n != 2) {
            throw new IllegalArgumentException("setFocusLostBehavior must be one of: JFormattedTextField.COMMIT, JFormattedTextField.COMMIT_OR_REVERT, JFormattedTextField.PERSIST or JFormattedTextField.REVERT");
        }
        this.focusLostBehavior = n;
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public void setFormatterFactory(AbstractFormatterFactory abstractFormatterFactory) {
        AbstractFormatterFactory abstractFormatterFactory2 = this.factory;
        this.factory = abstractFormatterFactory;
        this.firePropertyChange("formatterFactory", abstractFormatterFactory2, abstractFormatterFactory);
        this.setValue(this.getValue(), true);
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.factory;
    }

    protected void setFormatter(AbstractFormatter abstractFormatter) {
        AbstractFormatter abstractFormatter2 = this.format;
        if (abstractFormatter2 != null) {
            abstractFormatter2.uninstall();
        }
        this.setEditValid(true);
        this.format = abstractFormatter;
        if (abstractFormatter != null) {
            abstractFormatter.install(this);
        }
        this.setEdited(false);
        this.firePropertyChange("textFormatter", abstractFormatter2, abstractFormatter);
    }

    public AbstractFormatter getFormatter() {
        return this.format;
    }

    public void setValue(Object object) {
        if (object != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(object));
        }
        this.setValue(object, true);
    }

    public Object getValue() {
        return this.value;
    }

    public void commitEdit() throws ParseException {
        AbstractFormatter abstractFormatter = this.getFormatter();
        if (abstractFormatter != null) {
            this.setValue(abstractFormatter.stringToValue(this.getText()), false);
        }
    }

    private void setEditValid(boolean bl) {
        if (bl != this.editValid) {
            this.editValid = bl;
            this.firePropertyChange("editValid", (Object)(!bl ? 1 : 0), (Object)bl);
        }
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n = inputMethodEvent.getCommittedCharacterCount();
        if (attributedCharacterIterator != null) {
            int n2 = attributedCharacterIterator.getBeginIndex();
            int n3 = attributedCharacterIterator.getEndIndex();
            this.composedTextExists = n3 - n2 > n;
        } else {
            this.composedTextExists = false;
        }
        super.processInputMethodEvent(inputMethodEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.isTemporary()) {
            return;
        }
        if (this.isEdited() && focusEvent.getID() == 1005) {
            InputContext inputContext = this.getInputContext();
            if (this.focusLostHandler == null) {
                this.focusLostHandler = new FocusLostHandler();
            }
            if (inputContext != null && this.composedTextExists) {
                inputContext.endComposition();
                EventQueue.invokeLater(this.focusLostHandler);
            } else {
                this.focusLostHandler.run();
            }
        } else if (!this.isEdited()) {
            this.setValue(this.getValue(), true);
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setDocument(Document document) {
        if (this.documentListener != null && this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.documentListener);
        }
        super.setDocument(document);
        if (this.documentListener == null) {
            this.documentListener = new DocumentHandler();
        }
        document.addDocumentListener(this.documentListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void setFormatterActions(Action[] actionArray) {
        if (actionArray == null) {
            if (this.textFormatterActionMap != null) {
                this.textFormatterActionMap.clear();
            }
        } else {
            Object object;
            if (this.textFormatterActionMap == null) {
                Object object2 = this.getActionMap();
                this.textFormatterActionMap = new ActionMap();
                while (object2 != null) {
                    object = ((ActionMap)object2).getParent();
                    if (object instanceof UIResource || object == null) {
                        ((ActionMap)object2).setParent(this.textFormatterActionMap);
                        this.textFormatterActionMap.setParent((ActionMap)object);
                        break;
                    }
                    object2 = object;
                }
            }
            int n = actionArray.length - 1;
            while (n >= 0) {
                object = actionArray[n].getValue("Name");
                if (object != null) {
                    this.textFormatterActionMap.put(object, actionArray[n]);
                }
                --n;
            }
        }
    }

    private void setValue(Object object, boolean bl) {
        Object object2 = this.value;
        this.value = object;
        if (bl) {
            AbstractFormatterFactory abstractFormatterFactory = this.getFormatterFactory();
            AbstractFormatter abstractFormatter = abstractFormatterFactory != null ? abstractFormatterFactory.getFormatter(this) : null;
            this.setFormatter(abstractFormatter);
        } else {
            this.setEditValid(true);
        }
        this.setEdited(false);
        this.firePropertyChange("value", object2, object);
    }

    private void setEdited(boolean bl) {
        this.edited = bl;
    }

    private boolean isEdited() {
        return this.edited;
    }

    private AbstractFormatterFactory getDefaultFormatterFactory(Object object) {
        if (object instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)object));
        }
        if (object instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)object));
        }
        if (object instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)object));
        }
        if (object instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (object instanceof Number) {
            NumberFormatter numberFormatter = new NumberFormatter();
            NumberFormatter numberFormatter2 = new NumberFormatter(new DecimalFormat("#.#"));
            return new DefaultFormatterFactory(numberFormatter, numberFormatter, numberFormatter2);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DocumentHandler
    implements DocumentListener,
    Serializable {
        private DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            JFormattedTextField.this.setEdited(true);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            JFormattedTextField.this.setEdited(true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private static class CancelAction
    extends TextAction {
        public CancelAction() {
            super("reset-field-edit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                JFormattedTextField jFormattedTextField = (JFormattedTextField)jTextComponent;
                jFormattedTextField.setValue(jFormattedTextField.getValue());
            }
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            return jTextComponent instanceof JFormattedTextField;
        }
    }

    static class CommitAction
    extends JTextField.NotifyAction {
        CommitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)jTextComponent).commitEdit();
                }
                catch (ParseException parseException) {
                    return;
                }
            }
            super.actionPerformed(actionEvent);
        }

        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getFocusedComponent();
            if (jTextComponent instanceof JFormattedTextField) {
                return true;
            }
            return super.isEnabled();
        }
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private JFormattedTextField ftf;

        public void install(JFormattedTextField jFormattedTextField) {
            if (this.ftf != null) {
                this.uninstall();
            }
            this.ftf = jFormattedTextField;
            if (jFormattedTextField != null) {
                try {
                    jFormattedTextField.setText(this.valueToString(jFormattedTextField.getValue()));
                }
                catch (ParseException parseException) {
                    jFormattedTextField.setText("");
                    this.setEditValid(false);
                }
                this.installDocumentFilter(this.getDocumentFilter());
                jFormattedTextField.setNavigationFilter(this.getNavigationFilter());
                jFormattedTextField.setFormatterActions(this.getActions());
            }
        }

        public void uninstall() {
            if (this.ftf != null) {
                this.installDocumentFilter(null);
                this.ftf.setNavigationFilter(null);
                this.ftf.setFormatterActions(null);
            }
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;

        protected JFormattedTextField getFormattedTextField() {
            return this.ftf;
        }

        protected void invalidEdit() {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                jFormattedTextField.invalidEdit();
            }
        }

        protected void setEditValid(boolean bl) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                jFormattedTextField.setEditValid(bl);
            }
        }

        protected Action[] getActions() {
            return null;
        }

        protected DocumentFilter getDocumentFilter() {
            return null;
        }

        protected NavigationFilter getNavigationFilter() {
            return null;
        }

        protected Object clone() throws CloneNotSupportedException {
            AbstractFormatter abstractFormatter = (AbstractFormatter)super.clone();
            abstractFormatter.ftf = null;
            return abstractFormatter;
        }

        private void installDocumentFilter(DocumentFilter documentFilter) {
            JFormattedTextField jFormattedTextField = this.getFormattedTextField();
            if (jFormattedTextField != null) {
                Document document = jFormattedTextField.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).setDocumentFilter(documentFilter);
                }
                document.putProperty(class$javax$swing$text$DocumentFilter == null ? (class$javax$swing$text$DocumentFilter = JFormattedTextField.class$("javax.swing.text.DocumentFilter")) : class$javax$swing$text$DocumentFilter, null);
            }
        }
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }

    private class FocusLostHandler
    implements Runnable,
    Serializable {
        private FocusLostHandler() {
        }

        public void run() {
            int n = JFormattedTextField.this.getFocusLostBehavior();
            if (n == 0 || n == 1) {
                try {
                    JFormattedTextField.this.commitEdit();
                    JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true);
                }
                catch (ParseException parseException) {
                    if (n == 1) {
                        JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true);
                    }
                }
            } else if (n == 2) {
                JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true);
            }
        }
    }
}

