/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;
import sun.awt.shell.ShellFolder;

public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private JFileChooser filechooser = null;
    private Vector fileCache = new Vector(50);
    private LoadFilesThread loadThread = null;
    private Vector files = null;
    private Vector directories = null;
    private int fetchID = 0;

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.filechooser = jFileChooser;
        this.validateFileCache();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged" || string == "fileViewChanged" || string == "fileFilterChanged" || string == "FileHidingChanged" || string == "fileSelectionChanged") {
            this.validateFileCache();
        }
    }

    public void invalidateFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDirectories() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.directories != null) {
                return this.directories;
            }
            Vector vector2 = this.getFiles();
            return this.directories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFiles() {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (this.files != null) {
                return this.files;
            }
            this.files = new Vector();
            this.directories = new Vector();
            this.directories.addElement(this.filechooser.getFileSystemView().createFileObject(this.filechooser.getCurrentDirectory(), ".."));
            int n = 0;
            while (n < this.getSize()) {
                File file = (File)this.fileCache.get(n);
                if (this.filechooser.isTraversable(file)) {
                    this.directories.add(file);
                } else {
                    this.files.add(file);
                }
                ++n;
            }
            return this.files;
        }
    }

    public void validateFileCache() {
        File file = this.filechooser.getCurrentDirectory();
        if (file == null) {
            return;
        }
        if (this.loadThread != null) {
            this.loadThread.interrupt();
        }
        ++this.fetchID;
        this.loadThread = new LoadFilesThread(file, this.fetchID);
        this.loadThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameFile(File file, File file2) {
        Vector vector = this.fileCache;
        synchronized (vector) {
            if (file.renameTo(file2)) {
                this.validateFileCache();
                return true;
            }
            return false;
        }
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public int getSize() {
        return this.fileCache.size();
    }

    public boolean contains(Object object) {
        return this.fileCache.contains(object);
    }

    public int indexOf(Object object) {
        return this.fileCache.indexOf(object);
    }

    public Object getElementAt(int n) {
        return this.fileCache.get(n);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    protected void sort(Vector vector) {
        ShellFolder.sortFiles(vector);
    }

    protected boolean lt(File file, File file2) {
        int n = file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
        if (n != 0) {
            return n < 0;
        }
        return file.getName().compareTo(file2.getName()) < 0;
    }

    class DoChangeContents
    implements Runnable {
        private List addFiles;
        private List remFiles;
        private boolean doFire = true;
        private int fid;
        private int addStart = 0;
        private int remStart = 0;
        private int change;

        public DoChangeContents(List list, int n, List list2, int n2, int n3) {
            this.addFiles = list;
            this.addStart = n;
            this.remFiles = list2;
            this.remStart = n2;
            this.fid = n3;
        }

        synchronized void cancel() {
            this.doFire = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (BasicDirectoryModel.this.fetchID == this.fid && this.doFire) {
                int n = this.remFiles == null ? 0 : this.remFiles.size();
                int n2 = this.addFiles == null ? 0 : this.addFiles.size();
                Vector vector = BasicDirectoryModel.this.fileCache;
                synchronized (vector) {
                    if (n > 0) {
                        BasicDirectoryModel.this.fileCache.removeAll(this.remFiles);
                    }
                    if (n2 > 0) {
                        BasicDirectoryModel.this.fileCache.addAll(this.addStart, this.addFiles);
                    }
                    BasicDirectoryModel.this.files = null;
                    BasicDirectoryModel.this.directories = null;
                }
                if (n > 0 && n2 == 0) {
                    BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.remStart, this.remStart + n - 1);
                } else if (n2 > 0 && n == 0 && BasicDirectoryModel.this.fileCache.size() > n2) {
                    BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addStart, this.addStart + n2 - 1);
                }
                BasicDirectoryModel.this.fireContentsChanged();
            }
        }
    }

    class LoadFilesThread
    extends Thread {
        File currentDirectory;
        int fid;
        Vector runnables;

        public LoadFilesThread(File file, int n) {
            super("Basic L&F File Loading Thread");
            this.currentDirectory = null;
            this.runnables = new Vector(10);
            this.currentDirectory = file;
            this.fid = n;
        }

        private void invokeLater(Runnable runnable) {
            this.runnables.addElement(runnable);
            SwingUtilities.invokeLater(runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n;
            Serializable serializable;
            File[] fileArray;
            FileSystemView fileSystemView;
            FileSystemView fileSystemView2 = fileSystemView = BasicDirectoryModel.this.filechooser.getFileSystemView();
            synchronized (fileSystemView2) {
                fileArray = fileSystemView.getFiles(this.currentDirectory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            }
            Vector<File> vector = new Vector<File>();
            if (this.isInterrupted()) {
                return;
            }
            int n2 = 0;
            while (n2 < fileArray.length) {
                if (BasicDirectoryModel.this.filechooser.accept(fileArray[n2])) {
                    vector.addElement(fileArray[n2]);
                }
                ++n2;
            }
            if (this.isInterrupted()) {
                return;
            }
            BasicDirectoryModel.this.sort(vector);
            Vector<Serializable> vector2 = new Vector<Serializable>(50);
            Vector<Serializable> vector3 = new Vector<Serializable>();
            int n3 = 0;
            while (n3 < vector.size()) {
                serializable = (File)vector.elementAt(n3);
                n = BasicDirectoryModel.this.filechooser.isTraversable((File)serializable);
                if (n != 0) {
                    vector2.addElement(serializable);
                } else if (n == 0 && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    vector3.addElement(serializable);
                }
                if (this.isInterrupted()) {
                    return;
                }
                ++n3;
            }
            serializable = new Vector(vector2);
            ((Vector)serializable).addAll(vector3);
            n = ((Vector)serializable).size();
            int n4 = BasicDirectoryModel.this.fileCache.size();
            if (n > n4) {
                int n5 = n4;
                int n6 = n;
                int n7 = 0;
                block5: while (n7 < n4) {
                    if (!((Vector)serializable).get(n7).equals(BasicDirectoryModel.this.fileCache.get(n7))) {
                        n5 = n7;
                        int n8 = n7;
                        while (n8 < n) {
                            if (((Vector)serializable).get(n8).equals(BasicDirectoryModel.this.fileCache.get(n7))) {
                                n6 = n8;
                                break block5;
                            }
                            ++n8;
                        }
                        break;
                    }
                    ++n7;
                }
                if (n5 >= 0 && n6 > n5 && ((Vector)serializable).subList(n6, n).equals(BasicDirectoryModel.this.fileCache.subList(n5, n4))) {
                    this.invokeLater(new DoChangeContents(((Vector)serializable).subList(n5, n6), n5, null, 0, this.fid));
                    serializable = null;
                }
            } else if (n < n4) {
                int n9 = -1;
                int n10 = -1;
                int n11 = 0;
                while (n11 < n) {
                    if (!((Vector)serializable).get(n11).equals(BasicDirectoryModel.this.fileCache.get(n11))) {
                        n9 = n11;
                        n10 = n11 + n4 - n;
                        break;
                    }
                    ++n11;
                }
                if (n9 >= 0 && n10 > n9 && BasicDirectoryModel.this.fileCache.subList(n10, n4).equals(((Vector)serializable).subList(n9, n))) {
                    this.invokeLater(new DoChangeContents(null, 0, new Vector(BasicDirectoryModel.this.fileCache.subList(n9, n10)), n9, this.fid));
                    serializable = null;
                }
            }
            if (serializable != null && !BasicDirectoryModel.this.fileCache.equals(serializable)) {
                this.invokeLater(new DoChangeContents((List)((Object)serializable), 0, BasicDirectoryModel.this.fileCache, 0, this.fid));
            }
            if (this.isInterrupted()) {
                this.cancelRunnables(this.runnables);
            }
        }

        public void cancelRunnables(Vector vector) {
            int n = 0;
            while (n < vector.size()) {
                ((DoChangeContents)vector.elementAt(n)).cancel();
                ++n;
            }
        }
    }
}

