/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    protected int layoutSpan = Short.MAX_VALUE;
    protected View layoutPool;
    protected FlowStrategy strategy = new FlowStrategy();

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        if (this.getAxis() == 1) {
            return 0;
        }
        return 1;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return 0;
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
        }
        this.layoutPool.setParent(this);
        this.strategy.insertUpdate(this, null, null);
    }

    protected int getViewIndexAtPosition(int n) {
        if (n >= this.getStartOffset() && n < this.getEndOffset()) {
            int n2 = this.getViewCount() - 1;
            while (n2 >= 0) {
                View view = this.getView(n2);
                if (n >= view.getStartOffset() && n < view.getEndOffset()) {
                    return n2;
                }
                --n2;
            }
        }
        return -1;
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        int n4 = n3 == 0 ? n : n2;
        if (this.layoutSpan != n4) {
            this.layoutChanged(n3);
            this.layoutChanged(this.getAxis());
            this.layoutSpan = n4;
        }
        if (!this.isLayoutValid(n3)) {
            int n5 = this.getAxis();
            int n6 = n5 == 0 ? this.getWidth() : this.getHeight();
            this.strategy.layout(this);
            int n7 = (int)this.getPreferredSpan(n5);
            if (n6 != n7) {
                Container container;
                View view = this.getParent();
                if (view != null) {
                    view.preferenceChanged(this, n5 == 0, n5 == 1);
                }
                if ((container = this.getContainer()) != null) {
                    container.repaint();
                }
            }
        }
        super.layout(n, n2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        float f = this.layoutPool.getPreferredSpan(n);
        float f2 = this.layoutPool.getMinimumSpan(n);
        sizeRequirements.minimum = (int)f2;
        sizeRequirements.preferred = Math.max(sizeRequirements.minimum, (int)f);
        sizeRequirements.maximum = Short.MAX_VALUE;
        sizeRequirements.alignment = 0.5f;
        return sizeRequirements;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    static class LogicalView
    extends CompositeView {
        LogicalView(Element element) {
            super(element);
        }

        protected int getViewIndexAtPosition(int n) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                return 0;
            }
            return super.getViewIndexAtPosition(n);
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            if (element.isLeaf()) {
                LabelView labelView = new LabelView(element);
                this.append(labelView);
            } else {
                super.loadChildren(viewFactory);
            }
        }

        public AttributeSet getAttributes() {
            View view = this.getParent();
            return view != null ? view.getAttributes() : null;
        }

        public float getPreferredSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                f2 += view.getPreferredSpan(n);
                if (view.getBreakWeight(n, 0.0f, 32767.0f) >= 3000) {
                    f = Math.max(f, f2);
                    f2 = 0.0f;
                }
                ++n3;
            }
            f = Math.max(f, f2);
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = false;
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                if (view.getBreakWeight(n, 0.0f, 32767.0f) == 0) {
                    f2 += view.getPreferredSpan(n);
                    bl = true;
                } else if (bl) {
                    f = Math.max(f2, f);
                    bl = false;
                    f2 = 0.0f;
                }
                ++n3;
            }
            f = Math.max(f, f2);
            return f;
        }

        protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            view.setParent(this);
            super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        protected boolean isBefore(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected boolean isAfter(int n, int n2, Rectangle rectangle) {
            return false;
        }

        protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
            return null;
        }

        protected void childAllocation(int n, Rectangle rectangle) {
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            }
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            }
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            if (rectangle != null) {
                flowView.setSize(rectangle.width, rectangle.height);
                Container container = flowView.getContainer();
                if (container != null) {
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                flowView.layoutChanged(0);
                flowView.layoutChanged(1);
            }
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            int n = flowView.getStartOffset();
            int n2 = flowView.getEndOffset();
            View view = this.getLogicalView(flowView);
            int n3 = view.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                View view2 = view.getView(n4);
                view2.setParent(view);
                ++n4;
            }
            flowView.removeAll();
            int n5 = 0;
            while (n < n2) {
                View view3 = flowView.createRow();
                flowView.append(view3);
                int n6 = this.layoutRow(flowView, n5, n);
                if (view3.getViewCount() == 0) {
                    view3.append(this.createView(flowView, n, Integer.MAX_VALUE, n5));
                    n6 = view3.getEndOffset();
                }
                if (n6 <= n) {
                    throw new StateInvariantError("infinite loop in formatting");
                }
                n = n6;
                ++n5;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            View view;
            View view2 = flowView.getView(n);
            int n3 = flowView.getFlowStart(n);
            int n4 = flowView.getFlowSpan(n);
            int n5 = flowView.getEndOffset();
            TabExpander tabExpander = flowView instanceof TabExpander ? (TabExpander)((Object)flowView) : null;
            int n6 = n3;
            int n7 = n4;
            n6 = n3;
            int n8 = flowView.getFlowAxis();
            boolean bl = false;
            while (n2 < n5 && n4 > 0) {
                view = this.createView(flowView, n2, n4, n);
                if (view == null) break;
                int n9 = n8 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(n8);
                if (view.getBreakWeight(n8, n2, n4) >= 3000) {
                    int n10 = view2.getViewCount();
                    if (n10 > 0) {
                        n9 = (view = view.breakView(n8, n2, n3, n4)) != null ? (n8 == 0 && view instanceof TabableView ? (int)((TabableView)((Object)view)).getTabbedSpan(n3, tabExpander) : (int)view.getPreferredSpan(n8)) : 0;
                    }
                    bl = true;
                }
                n4 -= n9;
                n3 += n9;
                if (view != null) {
                    view2.append(view);
                    n2 = view.getEndOffset();
                }
                if (bl) break;
            }
            if (n4 < 0) {
                this.adjustRow(flowView, n, n7, n6);
            } else if (view2.getViewCount() == 0) {
                view = this.createView(flowView, n2, Integer.MAX_VALUE, n);
                view2.append(view);
            }
            return view2.getEndOffset();
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view;
            int n5 = flowView.getFlowAxis();
            View view2 = flowView.getView(n);
            int n6 = view2.getViewCount();
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = -1;
            boolean bl = false;
            int n11 = 0;
            while (n11 < n6) {
                view = view2.getView(n11);
                int n12 = view.getBreakWeight(n5, n3 + n7, n4 = n2 - n7);
                if (n12 >= n8 && n12 > 0) {
                    n8 = n12;
                    n10 = n11;
                    n9 = n7;
                    if (n12 >= 3000) break;
                }
                n7 = (int)((float)n7 + view.getPreferredSpan(n5));
                ++n11;
            }
            if (n10 < 0) {
                return;
            }
            n4 = n2 - n9;
            view = view2.getView(n10);
            view = view.breakView(n5, view.getStartOffset(), n3 + n9, n4);
            View[] viewArray = new View[]{view};
            View view3 = this.getLogicalView(flowView);
            int n13 = n10;
            while (n13 < n6) {
                View view4 = view2.getView(n13);
                if (this.contains(view3, view4)) {
                    view4.setParent(view3);
                } else if (view4.getViewCount() > 0) {
                    this.recursiveReparent(view4, view3);
                }
                ++n13;
            }
            view2.replace(n10, n6 - n10, viewArray);
        }

        private void recursiveReparent(View view, View view2) {
            int n = view.getViewCount();
            int n2 = 0;
            while (n2 < n) {
                View view3 = view.getView(n2);
                if (this.contains(view2, view3)) {
                    view3.setParent(view2);
                } else {
                    this.recursiveReparent(view3, view2);
                }
                ++n2;
            }
        }

        private boolean contains(View view, View view2) {
            int n = view.getViewCount();
            int n2 = 0;
            while (n2 < n) {
                if (view.getView(n2) == view2) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            View view2 = view.getView(n4 = view.getViewIndex(n, Position.Bias.Forward));
            if (n == view2.getStartOffset()) {
                return view2;
            }
            view2 = view2.createFragment(n, view2.getEndOffset());
            return view2;
        }
    }
}

