/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import sun.java2d.loops.PixelWriter;

abstract class XorPixelWriter
extends PixelWriter {
    protected ColorModel dstCM;

    XorPixelWriter() {
    }

    public void writePixel(int n, int n2) {
        Object object = this.dstRast.getDataElements(n, n2, null);
        this.xorPixel(object);
        this.dstRast.setDataElements(n, n2, object);
    }

    protected abstract void xorPixel(Object var1);

    public static class DoubleData
    extends XorPixelWriter {
        long[] xorData;

        DoubleData(Object object, Object object2) {
            double[] dArray = (double[])object;
            double[] dArray2 = (double[])object2;
            this.xorData = new long[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                this.xorData[n] = Double.doubleToLongBits(dArray[n]) ^ Double.doubleToLongBits(dArray2[n]);
                ++n;
            }
        }

        protected void xorPixel(Object object) {
            double[] dArray = (double[])object;
            int n = 0;
            while (n < dArray.length) {
                long l = Double.doubleToLongBits(dArray[n]) ^ this.xorData[n];
                dArray[n] = Double.longBitsToDouble(l);
                ++n;
            }
        }
    }

    public static class FloatData
    extends XorPixelWriter {
        int[] xorData;

        FloatData(Object object, Object object2) {
            float[] fArray = (float[])object;
            float[] fArray2 = (float[])object2;
            this.xorData = new int[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                this.xorData[n] = Float.floatToIntBits(fArray[n]) ^ Float.floatToIntBits(fArray2[n]);
                ++n;
            }
        }

        protected void xorPixel(Object object) {
            float[] fArray = (float[])object;
            int n = 0;
            while (n < fArray.length) {
                int n2 = Float.floatToIntBits(fArray[n]) ^ this.xorData[n];
                fArray[n] = Float.intBitsToFloat(n2);
                ++n;
            }
        }
    }

    public static class IntData
    extends XorPixelWriter {
        int[] xorData;

        IntData(Object object, Object object2) {
            this.xorData = (int[])object;
            this.xorPixel(object2);
            this.xorData = (int[])object2;
        }

        protected void xorPixel(Object object) {
            int[] nArray = (int[])object;
            int n = 0;
            while (n < nArray.length) {
                int n2 = n;
                nArray[n2] = nArray[n2] ^ this.xorData[n];
                ++n;
            }
        }
    }

    public static class ShortData
    extends XorPixelWriter {
        short[] xorData;

        ShortData(Object object, Object object2) {
            this.xorData = (short[])object;
            this.xorPixel(object2);
            this.xorData = (short[])object2;
        }

        protected void xorPixel(Object object) {
            short[] sArray = (short[])object;
            int n = 0;
            while (n < sArray.length) {
                int n2 = n;
                sArray[n2] = (short)(sArray[n2] ^ this.xorData[n]);
                ++n;
            }
        }
    }

    public static class ByteData
    extends XorPixelWriter {
        byte[] xorData;

        ByteData(Object object, Object object2) {
            this.xorData = (byte[])object;
            this.xorPixel(object2);
            this.xorData = (byte[])object2;
        }

        protected void xorPixel(Object object) {
            byte[] byArray = (byte[])object;
            int n = 0;
            while (n < byArray.length) {
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] ^ this.xorData[n]);
                ++n;
            }
        }
    }
}

