/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.image.ByteInterleavedRaster;
import sun.print.PSPrinterJob;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

class PSPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;

    PSPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n, boolean bl) {
        super(graphics2D, printerJob, printable, pageFormat, n, bl);
    }

    public Graphics create() {
        return new PSPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void fill(Shape shape, Color color) {
        this.deviceFill(shape.getPathIterator(new AffineTransform()), color);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        PSPrinterJob pSPrinterJob;
        boolean bl = false;
        boolean bl2 = this.getFont().getTransform().isIdentity();
        if (!PSPrinterJob.shapeTextProp && bl2 && (pSPrinterJob = (PSPrinterJob)this.getPrinterJob()).setFont(this.getFont())) {
            try {
                pSPrinterJob.setColor((Color)this.getPaint());
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Expected a Color instance");
            }
            pSPrinterJob.setTransform(this.getTransform());
            pSPrinterJob.setClip(this.getClip());
            bl = pSPrinterJob.textOut(this, string, f, f2);
        }
        if (!bl) {
            super.drawString(string, f, f2);
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        boolean bl = n3 <= 0 || n4 <= 0 ? false : this.drawImage(image, n, n2, n3, n4, color, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        boolean bl = n5 <= 0 || n6 <= 0 ? false : this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n5, n6, imageObserver);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        if (n9 <= 0 || n10 <= 0) {
            return false;
        }
        float f = (float)(n3 - n) / (float)n9;
        float f2 = (float)(n4 - n2) / (float)n10;
        AffineTransform affineTransform = new AffineTransform(f, 0.0f, 0.0f, f2, (float)n - (float)n5 * f, (float)n2 - (float)n6 * f2);
        return this.drawImageToPS(image, affineTransform, null, color, n5, n6, n9, n10, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        boolean bl = n <= 0 || n2 <= 0 ? false : this.drawImageToPS(image, affineTransform, null, null, 0, 0, n, n2, false);
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n3 <= 0 || n4 <= 0) {
            boolean bl = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2);
            boolean bl = this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n3, n4, false);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToPS(bufferedImage, affineTransform, null, null, 0, 0, n, n2, false);
    }

    private boolean drawBitmaskImage(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        Image image2;
        ColorModel colorModel;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            image2 = (sun.awt.image.Image)image;
            bufferedImage = image2.getBufferedImage();
            if (bufferedImage == null) {
                return true;
            }
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            bufferedImage = ((VolatileImage)image).getSnapshot();
            colorModel = bufferedImage.getColorModel();
        } else {
            return false;
        }
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (bufferedImageOp != null) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        image2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n9 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n9 >= 0) {
            byArray[n9] = 0;
        }
        int n10 = writableRaster.getWidth();
        int n11 = writableRaster.getHeight();
        if (n > n10 || n2 > n11) {
            return false;
        }
        if (n + n3 > n10) {
            n8 = n10;
            n7 = n8 - n;
        } else {
            n8 = n + n3;
            n7 = n3;
        }
        if (n2 + n4 > n11) {
            n6 = n11;
            n5 = n6 - n2;
        } else {
            n6 = n2 + n4;
            n5 = n4;
        }
        int[] nArray = new int[n7];
        int n12 = n2;
        while (n12 < n6) {
            int n13 = -1;
            writableRaster.getPixels(n, n12, n7, 1, nArray);
            int n14 = n;
            while (n14 < n8) {
                if (byArray[nArray[n14 - n]] == 0) {
                    if (n13 >= 0) {
                        image2 = bufferedImage.getSubimage(n13, n12, n14 - n13, 1);
                        affineTransform.translate(n13, n12);
                        this.drawImageToPS(image2, affineTransform, bufferedImageOp, color, 0, 0, n14 - n13, 1, true);
                        affineTransform.translate(-n13, -n12);
                        n13 = -1;
                    }
                } else if (n13 < 0) {
                    n13 = n14;
                }
                ++n14;
            }
            if (n13 >= 0) {
                image2 = bufferedImage.getSubimage(n13, n12, n8 - n13, 1);
                affineTransform.translate(n13, n12);
                this.drawImageToPS(image2, affineTransform, bufferedImageOp, color, 0, 0, n8 - n13, 1, true);
                affineTransform.translate(-n13, -n12);
            }
            ++n12;
        }
        return true;
    }

    private boolean drawImageToPS(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n, int n2, int n3, int n4, boolean bl) {
        Object object;
        if (image instanceof sun.awt.image.Image && ((sun.awt.image.Image)(object = (sun.awt.image.Image)image)).getBufferedImage() == null) {
            return false;
        }
        object = (PSPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d = float_.distance(float_3);
        double d2 = float_2.distance(float_3);
        if (d != 0.0 && d2 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d, dArray[1] / d2, dArray[2] / d, dArray[3] / d2, dArray[4] / d, dArray[5] / d2);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n, n2, n3, n4);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n5 = (int)rectangle2D.getWidth();
            int n6 = (int)rectangle2D.getHeight();
            if (n5 > 0 && n6 > 0) {
                boolean bl2 = true;
                if (!bl && this.hasTransparentPixels(image)) {
                    bl2 = false;
                    if (this.isBitmaskTransparency(image)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(image, affineTransform, bufferedImageOp, color, n, n2, n3, n4)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl2 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl2 = true;
                    }
                } else {
                    color = null;
                }
                if ((n + n3 > image.getWidth(null) || n2 + n4 > image.getHeight(null)) && this.canDoRedraws()) {
                    bl2 = false;
                }
                if (!bl2) {
                    ((RasterPrinterJob)object).saveState(this.getTransform(), this.getClip(), rectangle2D, d, d2, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(image, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, color, null);
                Shape shape2 = this.getClip();
                Shape shape3 = this.getTransform().createTransformedShape(shape2);
                AffineTransform affineTransform4 = AffineTransform.getScaleInstance(d, d2);
                Shape shape4 = affineTransform4.createTransformedShape(shape);
                Area area = new Area(shape4);
                Area area2 = new Area(shape3);
                area.intersect(area2);
                ((PSPrinterJob)object).setClip(area);
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
                ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
                ((PSPrinterJob)object).drawImageBGR(byteInterleavedRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
                ((PSPrinterJob)object).setClip(this.getTransform().createTransformedShape(shape2));
                graphics2D.dispose();
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d, double d2, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, pSPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f = (float)(pSPrinterJob.getXRes() / d);
        float f2 = (float)(pSPrinterJob.getYRes() / d2);
        proxyGraphics2D.scale(f / 72.0f, f2 / 72.0f);
        proxyGraphics2D.translate(-pSPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / pSPrinterJob.getXRes() * 72.0, -pSPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / pSPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n);
        graphics2D.dispose();
        Shape shape = this.getClip();
        pSPrinterJob.setClip(this.getTransform().createTransformedShape(shape));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d), (float)(rectangle2D.getY() * d2), (float)(rectangle2D.getWidth() * d), (float)(rectangle2D.getHeight() * d2));
        ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)bufferedImage.getRaster();
        pSPrinterJob.drawImageBGR(byteInterleavedRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    private boolean hasTransparentPixels(Image image) {
        Object object;
        ColorModel colorModel;
        boolean bl = true;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            object = (sun.awt.image.Image)image;
            bufferedImage = ((sun.awt.image.Image)object).getBufferedImage();
            if (bufferedImage == null) {
                return false;
            }
            colorModel = ((sun.awt.image.Image)object).getColorModel();
        } else {
            if (image instanceof VolatileImage) {
                return false;
            }
            colorModel = null;
        }
        boolean bl2 = colorModel == null ? true : (bl = colorModel.getTransparency() != 1);
        if (bl && bufferedImage != null && bufferedImage.getType() == 2) {
            object = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (object instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)object).getData();
                int n = bufferedImage.getMinX();
                int n2 = bufferedImage.getMinY();
                int n3 = bufferedImage.getWidth();
                int n4 = bufferedImage.getHeight();
                int n5 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl3 = false;
                int n6 = n2;
                while (n6 < n2 + n4) {
                    int n7 = n2 * n5;
                    int n8 = n;
                    while (n8 < n + n3) {
                        if ((nArray[n7 + n8] & 0xFF000000) != -16777216) {
                            bl3 = true;
                            break;
                        }
                        ++n8;
                    }
                    if (bl3) break;
                    ++n6;
                }
                if (!bl3) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean isBitmaskTransparency(Image image) {
        ColorModel colorModel = null;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof sun.awt.image.Image) {
            sun.awt.image.Image image2 = (sun.awt.image.Image)image;
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            return false;
        }
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        pSPrinterJob.setTransform(this.getTransform());
        pSPrinterJob.setClip(this.getClip());
        pSPrinterJob.setColor(color);
        this.convertToPSPath(pathIterator);
        pSPrinterJob.fillPath();
    }

    protected void deviceFrameRect(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceDrawLine(int n, int n2, int n3, int n4, Color color) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    protected void deviceFillRect(int n, int n2, int n3, int n4, Color color) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4));
    }

    protected void deviceClip(PathIterator pathIterator) {
    }

    private void convertToPSPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        PSPrinterJob pSPrinterJob = (PSPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        pSPrinterJob.setFillMode(n);
        pSPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    pSPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    pSPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    float f = pSPrinterJob.getPenX();
                    float f2 = pSPrinterJob.getPenY();
                    float f3 = f + (fArray[0] - f) * 2.0f / 3.0f;
                    float f4 = f2 + (fArray[1] - f2) * 2.0f / 3.0f;
                    float f5 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f6 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    pSPrinterJob.bezierTo(f3, f4, f5, f6, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    pSPrinterJob.bezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    pSPrinterJob.closeSubpath();
                }
            }
            pathIterator.next();
        }
        if (n == 1 && pSPrinterJob.getFillMode() == 2) {
            pSPrinterJob.setFillMode(1);
        }
    }
}

