/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class Translator
extends AccessibleContext
implements Accessible,
AccessibleComponent {
    protected Object source;

    protected static Class getTranslatorClass(Class c) {
        Class<?> t = null;
        if (c == null) {
            return null;
        }
        try {
            t = Class.forName("com.sun.java.accessibility.util." + c.getName() + "Translator");
            return t;
        }
        catch (Exception e) {
            return Translator.getTranslatorClass(c.getSuperclass());
        }
    }

    public static Accessible getAccessible(Object o) {
        Accessible a = null;
        if (o == null) {
            return null;
        }
        if (o instanceof Accessible) {
            a = (Accessible)o;
        } else {
            Class translatorClass = Translator.getTranslatorClass(o.getClass());
            if (translatorClass != null) {
                try {
                    Translator t = (Translator)translatorClass.newInstance();
                    t.setSource(o);
                    a = t;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (a == null) {
            a = new Translator(o);
        }
        return a;
    }

    public Translator() {
    }

    public Translator(Object o) {
        this.source = o;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object o) {
        this.source = o;
    }

    public boolean equals(Object o) {
        return this.source.equals(o);
    }

    public AccessibleContext getAccessibleContext() {
        return this;
    }

    public String getAccessibleName() {
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).getLabel();
        }
        if (this.source instanceof Component) {
            return ((Component)this.source).getName();
        }
        return null;
    }

    public void setAccessibleName(String s) {
        if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setLabel(s);
        } else if (this.source instanceof Component) {
            ((Component)this.source).setName(s);
        }
    }

    public String getAccessibleDescription() {
        return null;
    }

    public void setAccessibleDescription(String s) {
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.UNKNOWN;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = new AccessibleStateSet();
        if (this.source instanceof Component) {
            Component c = (Component)this.source;
            Container p = c.getParent();
            while (p != null) {
                if (p instanceof Window && ((Window)p).getFocusOwner() == c) {
                    states.add(AccessibleState.FOCUSED);
                }
                p = p.getParent();
            }
        }
        if (this.isEnabled()) {
            states.add(AccessibleState.ENABLED);
        }
        if (this.isFocusTraversable()) {
            states.add(AccessibleState.FOCUSABLE);
        }
        if (this.source instanceof MenuItem) {
            states.add(AccessibleState.FOCUSABLE);
        }
        return states;
    }

    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        if (this.source instanceof Component) {
            return Translator.getAccessible(((Component)this.source).getParent());
        }
        return null;
    }

    public int getAccessibleIndexInParent() {
        Container parent;
        if (this.source instanceof Component && (parent = ((Component)this.source).getParent()) != null) {
            Component[] ca = parent.getComponents();
            int i = 0;
            while (i < ca.length) {
                if (this.source.equals(ca[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int getAccessibleChildrenCount() {
        if (this.source instanceof Container) {
            Component[] children = ((Container)this.source).getComponents();
            int count = 0;
            int i = 0;
            while (i < children.length) {
                Accessible a = Translator.getAccessible(children[i]);
                if (a != null) {
                    ++count;
                }
                ++i;
            }
            return count;
        }
        return 0;
    }

    public Accessible getAccessibleChild(int i) {
        if (this.source instanceof Container) {
            Component[] children = ((Container)this.source).getComponents();
            int count = 0;
            int j = 0;
            while (j < children.length) {
                Accessible a = Translator.getAccessible(children[j]);
                if (a != null) {
                    if (count == i) {
                        AccessibleContext ac = a.getAccessibleContext();
                        if (ac != null) {
                            ac.setAccessibleParent(this);
                        }
                        return a;
                    }
                    ++count;
                }
                ++j;
            }
        }
        return null;
    }

    public Locale getLocale() throws IllegalComponentStateException {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocale();
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    public Color getBackground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBackground();
        }
        return null;
    }

    public void setBackground(Color c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBackground(c);
        }
    }

    public Color getForeground() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getForeground();
        }
        return null;
    }

    public void setForeground(Color c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setForeground(c);
        }
    }

    public Cursor getCursor() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getCursor();
        }
        return null;
    }

    public void setCursor(Cursor c) {
        if (this.source instanceof Component) {
            ((Component)this.source).setCursor(c);
        }
    }

    public Font getFont() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFont();
        }
        if (this.source instanceof MenuComponent) {
            return ((MenuComponent)this.source).getFont();
        }
        return null;
    }

    public void setFont(Font f) {
        if (this.source instanceof Component) {
            ((Component)this.source).setFont(f);
        } else if (this.source instanceof MenuComponent) {
            ((MenuComponent)this.source).setFont(f);
        }
    }

    public FontMetrics getFontMetrics(Font f) {
        if (this.source instanceof Component) {
            return ((Component)this.source).getFontMetrics(f);
        }
        return null;
    }

    public boolean isEnabled() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isEnabled();
        }
        if (this.source instanceof MenuItem) {
            return ((MenuItem)this.source).isEnabled();
        }
        return true;
    }

    public void setEnabled(boolean b) {
        if (this.source instanceof Component) {
            ((Component)this.source).setEnabled(b);
        } else if (this.source instanceof MenuItem) {
            ((MenuItem)this.source).setEnabled(b);
        }
    }

    public boolean isVisible() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isVisible();
        }
        return false;
    }

    public void setVisible(boolean b) {
        if (this.source instanceof Component) {
            ((Component)this.source).setVisible(b);
        }
    }

    public boolean isShowing() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isShowing();
        }
        return false;
    }

    public boolean contains(Point p) {
        if (this.source instanceof Component) {
            return ((Component)this.source).contains(p);
        }
        return false;
    }

    public Point getLocationOnScreen() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocationOnScreen();
        }
        return null;
    }

    public Point getLocation() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getLocation();
        }
        return null;
    }

    public void setLocation(Point p) {
        if (this.source instanceof Component) {
            ((Component)this.source).setLocation(p);
        }
    }

    public Rectangle getBounds() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getBounds();
        }
        return null;
    }

    public void setBounds(Rectangle r) {
        if (this.source instanceof Component) {
            ((Component)this.source).setBounds(r);
        }
    }

    public Dimension getSize() {
        if (this.source instanceof Component) {
            return ((Component)this.source).getSize();
        }
        return null;
    }

    public void setSize(Dimension d) {
        if (this.source instanceof Component) {
            ((Component)this.source).setSize(d);
        }
    }

    public Accessible getAccessibleAt(Point p) {
        Component c;
        if (this.source instanceof Component && (c = ((Component)this.source).getComponentAt(p)) != null) {
            return Translator.getAccessible(c);
        }
        return null;
    }

    public boolean isFocusTraversable() {
        if (this.source instanceof Component) {
            return ((Component)this.source).isFocusTraversable();
        }
        return false;
    }

    public void requestFocus() {
        if (this.source instanceof Component) {
            ((Component)this.source).requestFocus();
        }
    }

    public synchronized void addFocusListener(FocusListener l) {
        if (this.source instanceof Component) {
            ((Component)this.source).addFocusListener(l);
        }
    }

    public synchronized void removeFocusListener(FocusListener l) {
        if (this.source instanceof Component) {
            ((Component)this.source).removeFocusListener(l);
        }
    }
}

