/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bidiTools.bdlayout;

import com.ibm.bidiTools.bdlayout.ArabicOptionSet;
import com.ibm.bidiTools.bdlayout.BidiFlag;
import com.ibm.bidiTools.bdlayout.BidiFlagSet;
import com.ibm.bidiTools.bdlayout.BidiText;
import com.ibm.bidiTools.bdlayout.BidiTransform;
import com.ibm.bidiTools.bdlayout.Mlog;
import java.nio.CharBuffer;
import java.util.StringTokenizer;

public class BidiConvert {
    static final char[] DEFAULT_U = new char[]{'I', 'L', 'Y', 'N', 'N', 'U', 'A', 'A', 'A', 'A'};
    static final char[] DEFAULT_S = new char[]{'V', 'L', 'N', 'S', 'N', 'U', 'A', 'A', 'A', 'A'};
    static final char DEFCHAR = '-';
    private String lastEncoding;
    private String lastBidiParms;
    private boolean lastMatching;
    private BidiFlagSet bfs_U;
    private BidiFlagSet bfs_S;

    private String getPart(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",)");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (!string3.startsWith(string2)) continue;
            return string3.substring(2);
        }
        return "";
    }

    private char[] getChars(String string, String string2, char[] cArray) {
        int n;
        String string3 = this.getPart(string, string2);
        int n2 = string3.length();
        if (n2 > (n = cArray.length)) {
            n2 = n;
        }
        char[] cArray2 = new char[n];
        string3.getChars(0, n2, cArray2, 0);
        int n3 = 0;
        while (n3 < n) {
            if (n3 >= n2 || '-' == cArray2[n3]) {
                cArray2[n3] = cArray[n3];
            }
            ++n3;
        }
        return cArray2;
    }

    private boolean isMatchingEncoding(String string, String string2) {
        if (string == this.lastEncoding && string2 == this.lastBidiParms) {
            return this.lastMatching;
        }
        this.lastEncoding = string;
        this.lastBidiParms = string2;
        this.bfs_U = null;
        this.bfs_S = null;
        String string3 = this.getPart(string2, "C(");
        if (string3.equals("")) {
            this.lastMatching = true;
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.equals(string)) continue;
            this.lastMatching = true;
            return true;
        }
        this.lastMatching = false;
        return false;
    }

    private boolean isFlagRtl(String string) {
        BidiFlag bidiFlag;
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(this.getChars(string, "U(", DEFAULT_U));
        }
        if (BidiFlag.ORIENTATION_RTL == (bidiFlag = this.bfs_U.getOrientation())) {
            return true;
        }
        if (BidiFlag.ORIENTATION_CONTEXT_RTL == bidiFlag) {
            return true;
        }
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(this.getChars(string, "S(", DEFAULT_S));
        }
        if (BidiFlag.ORIENTATION_RTL == (bidiFlag = this.bfs_S.getOrientation())) {
            return true;
        }
        return BidiFlag.ORIENTATION_CONTEXT_RTL == bidiFlag;
    }

    private boolean isBidiData(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = cArray[n3];
            if (c >= '\u0590' && c <= '\u07bf') {
                return true;
            }
            if (c >= '\ufb1d' && c <= '\ufdff') {
                return true;
            }
            if (c >= '\ufe70' && c <= '\ufefc') {
                return true;
            }
            if (c == '\u200f') {
                return true;
            }
            if (c == '\u202b' || c == '\u202e') {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean isBidiEnv(String string, String string2) {
        if (string2.equals("Cp850")) {
            return false;
        }
        Mlog.putLine("isBidiEnv " + string + " encoding=" + string2);
        if (string == null) {
            return Mlog.logReturn(false);
        }
        if (string.equals("NO")) {
            return Mlog.logReturn(false);
        }
        if (!this.isMatchingEncoding(string2, string)) {
            return Mlog.logReturn(false);
        }
        return Mlog.logReturn(true);
    }

    public boolean isBidiData(char[] cArray, int n, int n2, String string, String string2) {
        if (!this.isBidiEnv(string, string2)) {
            return false;
        }
        Mlog.putLine("isBidiData_char[]  inStart=" + n + "  inEnd=" + n2);
        Mlog.putHexLine(cArray, n, n2, true);
        if (n2 <= n) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(string)) {
            return Mlog.logReturn(true);
        }
        return Mlog.logReturn(this.isBidiData(cArray, n, n2));
    }

    public boolean isBidiData(String string, String string2, String string3) {
        if (!this.isBidiEnv(string2, string3)) {
            return false;
        }
        Mlog.putLine("isBidiData_String");
        Mlog.putHexLine(string, true);
        if (string.length() <= 0) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(string2)) {
            return Mlog.logReturn(true);
        }
        char[] cArray = string.toCharArray();
        return Mlog.logReturn(this.isBidiData(cArray, 0, cArray.length));
    }

    public boolean isBidiData(CharBuffer charBuffer, boolean bl, String string, String string2) {
        if (!this.isBidiEnv(string, string2)) {
            return false;
        }
        Mlog.putLine("isBidiData_CharBuffer  UseBuffer=" + bl + "  position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
        Mlog.putHexLine(charBuffer.toString(), true);
        if (!charBuffer.hasRemaining()) {
            return Mlog.logReturn(false);
        }
        if (this.isFlagRtl(string)) {
            return Mlog.logReturn(true);
        }
        if (charBuffer.hasArray() && !bl) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset();
            boolean bl2 = this.isBidiData(cArray, n + charBuffer.position(), n + charBuffer.limit());
            return Mlog.logReturn(bl2);
        }
        int n = charBuffer.position();
        char[] cArray = new char[1];
        boolean bl3 = false;
        while (charBuffer.hasRemaining()) {
            cArray[0] = charBuffer.get();
            if (!this.isBidiData(cArray, 0, 1)) continue;
            bl3 = true;
            break;
        }
        charBuffer.position(n);
        return Mlog.logReturn(bl3);
    }

    private char[] subchars(char[] cArray, int n, int n2) {
        int n3 = n2 - n;
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n, cArray2, 0, n3);
        return cArray2;
    }

    private char[] toUnicode(char[] cArray, int n, int n2, String string) {
        char[] cArray2 = this.getChars(string, "U(", DEFAULT_U);
        char[] cArray3 = this.getChars(string, "S(", DEFAULT_S);
        BidiTransform bidiTransform = new BidiTransform();
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(cArray2);
        }
        bidiTransform.flags = this.bfs_U;
        bidiTransform.roundTrip = 'R' == cArray2[5];
        bidiTransform.options = new ArabicOptionSet(cArray2);
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(cArray3);
        }
        BidiText bidiText = new BidiText(this.bfs_S);
        bidiText.setCharsRef(cArray, n, n2 - n);
        BidiText bidiText2 = bidiText.transform(bidiTransform);
        return bidiText2.data;
    }

    public char[] toUnicode(char[] cArray, int n, int n2, String string, String string2) {
        Mlog.printStackTrace("toUnicode_char[]");
        Mlog.putLine("toUnicode_char[]  inStart=" + n + "  inEnd=" + n2);
        Mlog.putHexLine(cArray, n, n2, true);
        if (!this.isBidiEnv(string, string2)) {
            return Mlog.logReturn(this.subchars(cArray, n, n2));
        }
        return Mlog.logReturn(this.toUnicode(cArray, n, n2, string));
    }

    public String toUnicode(String string, String string2, String string3) {
        Mlog.printStackTrace("toUnicode_String");
        Mlog.putLine("toUnicode_String input:");
        Mlog.putHexLine(string, true);
        if (!this.isBidiEnv(string2, string3)) {
            return Mlog.logReturn(string);
        }
        return new String(Mlog.logReturn(this.toUnicode(string.toCharArray(), 0, string.length(), string2)));
    }

    public CharBuffer toUnicode(CharBuffer charBuffer, boolean bl, String string, String string2) {
        Mlog.printStackTrace("toUnicode_CharBuffer");
        Mlog.putLine("toUnicode_CharBuffer  UseBuffer=" + bl + "  position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
        Mlog.putHexLine(charBuffer.toString(), true);
        if (!this.isBidiEnv(string, string2)) {
            return Mlog.logReturn(charBuffer);
        }
        if (charBuffer.hasArray() && !bl) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset();
            cArray = this.toUnicode(cArray, n + charBuffer.position(), n + charBuffer.limit(), string);
            Mlog.putLine("after array: position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
            return Mlog.logReturn(CharBuffer.wrap(cArray));
        }
        int n = charBuffer.position();
        char[] cArray = new char[charBuffer.remaining()];
        charBuffer.get(cArray);
        charBuffer.position(n);
        cArray = this.toUnicode(cArray, 0, cArray.length, string);
        Mlog.putLine("after buffer: position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
        return Mlog.logReturn(CharBuffer.wrap(cArray));
    }

    private char[] toSbcs(char[] cArray, int n, int n2, String string) {
        char[] cArray2 = this.getChars(string, "U(", DEFAULT_U);
        char[] cArray3 = this.getChars(string, "S(", DEFAULT_S);
        BidiTransform bidiTransform = new BidiTransform();
        if (null == this.bfs_S) {
            this.bfs_S = new BidiFlagSet(cArray3);
        }
        bidiTransform.flags = this.bfs_S;
        bidiTransform.roundTrip = 'R' == cArray3[5];
        bidiTransform.options = new ArabicOptionSet(cArray3);
        if (null == this.bfs_U) {
            this.bfs_U = new BidiFlagSet(cArray2);
        }
        BidiText bidiText = new BidiText(this.bfs_U);
        bidiText.setCharsRef(cArray, n, n2 - n);
        BidiText bidiText2 = bidiText.transform(bidiTransform);
        return bidiText2.data;
    }

    public char[] toSbcs(char[] cArray, int n, int n2, String string, String string2) {
        Mlog.printStackTrace("toSbcs_char[]");
        Mlog.putLine("toSbcs_char[]  inStart=" + n + "  inEnd=" + n2);
        Mlog.putHexLine(cArray, n, n2, true);
        if (!this.isBidiEnv(string, string2)) {
            return Mlog.logReturn(this.subchars(cArray, n, n2));
        }
        return Mlog.logReturn(this.toSbcs(cArray, n, n2, string));
    }

    public String toSbcs(String string, String string2, String string3) {
        Mlog.printStackTrace("toSbcs_String input:");
        Mlog.putHexLine(string, true);
        if (!this.isBidiEnv(string2, string3)) {
            return Mlog.logReturn(string);
        }
        return Mlog.logReturn(new String(this.toSbcs(string.toCharArray(), 0, string.length(), string2)));
    }

    public CharBuffer toSbcs(CharBuffer charBuffer, boolean bl, String string, String string2) {
        Mlog.printStackTrace("toSbcs_CharBuffer");
        Mlog.putLine("toSbcs_CharBuffer  UseBuffer=" + bl + "  position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
        Mlog.putHexLine(charBuffer.toString(), true);
        if (!this.isBidiEnv(string, string2)) {
            return Mlog.logReturn(charBuffer);
        }
        if (charBuffer.hasArray() && !bl) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset();
            cArray = this.toSbcs(cArray, n + charBuffer.position(), n + charBuffer.limit(), string);
            Mlog.putLine("after array: position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
            return Mlog.logReturn(CharBuffer.wrap(cArray));
        }
        int n = charBuffer.position();
        char[] cArray = new char[charBuffer.remaining()];
        charBuffer.get(cArray);
        charBuffer.position(n);
        cArray = this.toSbcs(cArray, 0, cArray.length, string);
        Mlog.putLine("after buffer: position=" + charBuffer.position() + "  limit=" + charBuffer.limit());
        return Mlog.logReturn(CharBuffer.wrap(cArray));
    }
}

