/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.Utility;
import java.util.ArrayList;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public final class INSUtil {
    public static final String corbanamePrefix = "corbaname:";
    public static final String corbalocPrefix = "corbaloc:";
    public static final int defaultPort = 2809;
    private static final String className = "INSUtil";
    private static final String ncFieldSeparator = ".";
    private static final String ncArraySeparator = "/";
    private static final String charsToEscape = "\\/.";
    private static final String RFC2396 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/:?@&=+$,-_.!~*'()";
    private static final String thisClassName = "com.ibm.CORBA.iiop.INSUtil";

    private INSUtil() {
    }

    public static String decode2936(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '%') {
                int n;
                if (i + 2 >= stringBuffer.length()) {
                    throw new BAD_PARAM("incomplete key_string escape sequence", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                try {
                    n = Utility.hexOf(stringBuffer.charAt(i + 1)) * 16 + Utility.hexOf(stringBuffer.charAt(i + 2));
                }
                catch (DATA_CONVERSION dATA_CONVERSION) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, className, "decode2936:127", dATA_CONVERSION.toString());
                    }
                    throw new BAD_PARAM("Bad hex digit", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                stringBuffer.setCharAt(i, (char)n);
                stringBuffer.delete(i + 1, i + 3);
                continue;
            }
            if (RFC2396.indexOf(c) != -1) continue;
            throw new BAD_PARAM("invalid key_string character '" + c + "'", 1330446346, CompletionStatus.COMPLETED_NO);
        }
        return stringBuffer.toString();
    }

    public static String encode2936(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (RFC2396.indexOf(c) != -1) continue;
            stringBuffer.setCharAt(i, '%');
            char[] cArray = Integer.toHexString(c).toCharArray();
            if (cArray.length == 2) {
                stringBuffer.insert(i + 1, cArray);
            } else if (cArray.length == 1) {
                stringBuffer.insert(i + 1, '0');
                stringBuffer.insert(i + 2, cArray[0]);
            } else {
                throw new BAD_PARAM("invalid character '" + c + "' in \"" + string + "\"", 1330446346, CompletionStatus.COMPLETED_NO);
            }
            i += 2;
        }
        return stringBuffer.toString();
    }

    private static String unescapedStringOf(String string) throws InvalidName {
        if (string == null || string.length() == 0 || string.indexOf(92) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '\\') continue;
            if (i + 1 == stringBuffer.length()) {
                throw new InvalidName(string);
            }
            if (charsToEscape.indexOf(stringBuffer.charAt(i + 1)) == -1) continue;
            stringBuffer.deleteCharAt(i);
        }
        return stringBuffer.toString();
    }

    private static String escapedStringOf(String string) {
        if (string == null || string.length() == 0 || string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.indexOf(46) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (charsToEscape.indexOf(stringBuffer.charAt(i)) == -1) continue;
            stringBuffer.insert(i, '\\');
            ++i;
        }
        return stringBuffer.toString();
    }

    private static int firstOccurrence(String string, char c) {
        int n = string.indexOf(c);
        boolean bl = false;
        while (n != -1 && !bl) {
            bl = true;
            for (int i = n - 1; i >= 0 && string.charAt(i) == '\\'; --i) {
                bl = !bl;
            }
            if (bl) continue;
            n = string.indexOf(c, n + 1);
        }
        return n;
    }

    public static String nameToString(NameComponent[] nameComponentArray) {
        if (nameComponentArray.length == 0) {
            return null;
        }
        String string = INSUtil.nameComponentToString(nameComponentArray[0]);
        for (int i = 1; i < nameComponentArray.length; ++i) {
            string = string + ncArraySeparator + INSUtil.nameComponentToString(nameComponentArray[i]);
        }
        return string;
    }

    private static String nameComponentToString(NameComponent nameComponent) {
        boolean bl;
        boolean bl2 = nameComponent.id != null && nameComponent.id.length() > 0;
        boolean bl3 = bl = nameComponent.kind != null && nameComponent.kind.length() > 0;
        if (!bl2 && !bl) {
            return ncFieldSeparator;
        }
        if (!bl) {
            return INSUtil.escapedStringOf(nameComponent.id);
        }
        if (!bl2) {
            return ncFieldSeparator + INSUtil.escapedStringOf(nameComponent.kind);
        }
        return INSUtil.escapedStringOf(nameComponent.id) + ncFieldSeparator + INSUtil.escapedStringOf(nameComponent.kind);
    }

    public static NameComponent[] stringToName(String string) throws InvalidName {
        ArrayList<NameComponent> arrayList = new ArrayList<NameComponent>();
        while (string.length() > 0) {
            int n = INSUtil.firstOccurrence(string, '/');
            if (n == -1) {
                arrayList.add(INSUtil.stringToNameComponent(string));
                string = "";
                continue;
            }
            arrayList.add(INSUtil.stringToNameComponent(string.substring(0, n)));
            string = string.substring(n + 1);
        }
        NameComponent[] nameComponentArray = new NameComponent[arrayList.size()];
        return (NameComponent[])arrayList.toArray((java.lang.Object[])nameComponentArray);
    }

    private static NameComponent stringToNameComponent(String string) throws InvalidName {
        String string2;
        String string3;
        if (string == null || string.length() == 0) {
            throw new InvalidName("null or empty NameComponent");
        }
        int n = INSUtil.firstOccurrence(string, '.');
        if (n > 0 && n + 1 == string.length()) {
            throw new InvalidName(string + ": missing kind");
        }
        if (n == -1) {
            string3 = new String(string);
            string2 = new String("");
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (INSUtil.firstOccurrence(string2, '.') != -1) {
                throw new InvalidName(string + ": cannot parse kind");
            }
        }
        return new NameComponent(INSUtil.unescapedStringOf(string3), INSUtil.unescapedStringOf(string2));
    }

    public static String encodeCorbaname(String string, String string2) throws InvalidName, InvalidAddress {
        if (string == null || string.length() == 0) {
            throw new InvalidAddress("null or empty");
        }
        String string3 = new String(corbanamePrefix);
        int n = string.indexOf(47);
        if (n == 0) {
            throw new InvalidAddress(string);
        }
        if (n == -1 || n + 1 == string.length()) {
            string3 = string3 + string;
        } else {
            try {
                string3 = string3 + string.substring(0, n + 1) + INSUtil.encode2936(string.substring(n + 1));
            }
            catch (BAD_PARAM bAD_PARAM) {
                ORBRas.orbTrcLogger.exception(4104L, className, "encodeCorbaname:421", (Exception)((java.lang.Object)bAD_PARAM));
                throw new InvalidAddress(string);
            }
        }
        if (string2 != null && string2.length() != 0) {
            try {
                string3 = string3 + "#" + INSUtil.encode2936(string2);
            }
            catch (BAD_PARAM bAD_PARAM) {
                ORBRas.orbTrcLogger.exception(4104L, className, "encodeCorbaname:436", (Exception)((java.lang.Object)bAD_PARAM));
                throw new InvalidName(string2);
            }
        }
        return string3;
    }

    public static final Object resolveStr(String string, Object object) {
        NamingContextExt namingContextExt;
        if (!object._is_a(NamingContextHelper.id())) {
            throw new BAD_PARAM("located object is not a NameService", 1330446345, CompletionStatus.COMPLETED_NO);
        }
        if (string == null || string.length() == 0) {
            return object;
        }
        try {
            namingContextExt = NamingContextExtHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("located object does not support INS", 1330446345, CompletionStatus.COMPLETED_NO);
            bAD_PARAM.initCause((Throwable)exception);
            throw bAD_PARAM;
        }
        try {
            return namingContextExt.resolve_str(string);
        }
        catch (CannotProceed cannotProceed) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "resolveStr:494", (Exception)((java.lang.Object)cannotProceed));
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string + ": " + cannotProceed.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
            bAD_PARAM.initCause((Throwable)cannotProceed);
            throw bAD_PARAM;
        }
        catch (InvalidName invalidName) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "resolveStr:503", (Exception)((java.lang.Object)invalidName));
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string + ": " + invalidName.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
            bAD_PARAM.initCause((Throwable)invalidName);
            throw bAD_PARAM;
        }
        catch (NotFound notFound) {
            ORBRas.orbTrcLogger.exception(4104L, thisClassName, "resolveStr:512", (Exception)((java.lang.Object)notFound));
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string + ": " + notFound.toString(), 1330446346, CompletionStatus.COMPLETED_NO);
            bAD_PARAM.initCause((Throwable)notFound);
            throw bAD_PARAM;
        }
    }
}

