/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.rmi.iiop.CancelRequestMessage;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.LocateReplyMessage;
import com.ibm.rmi.iiop.LocateRequestMessage;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class Message
implements com.ibm.CORBA.iiop.Message {
    protected static final boolean debug = false;
    static final int defaultBufferSize = 1024;
    static final int GIOPBigEndian = 0;
    static final int GIOPLittleEndian = 1;
    static final int FragHdrLength = 4;
    static final int GIOPBigMagic = 1195986768;
    static final int GIOPLittleMagic = 1347373383;
    public static final int KeyAddr = 0;
    public static final int ProfileAddr = 1;
    public static final int ReferenceAddr = 2;
    public static final byte HighestGIOPMajor = 1;
    public static final byte HighestGIOPMinor = 2;
    private int magic;
    private byte byteOrder;
    private byte flags;
    private boolean fragToFollow;
    private byte type;
    private int size;
    private byte GIOPMajor;
    private byte GIOPMinor;
    private boolean isPreGIOP12;
    private boolean requestCancelled;
    private boolean hdrWritten = false;
    protected int requestId;

    public Message(byte by, byte by2) {
        this.GIOPMajor = by;
        this.GIOPMinor = by2;
        if (by == 1 && by2 <= 1) {
            this.isPreGIOP12 = true;
        }
    }

    public boolean preGIOP12() {
        return this.isPreGIOP12;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void setRequestId(int n) {
        this.requestId = n;
    }

    public final int getType() {
        return this.type;
    }

    protected void setCancelRequest() {
        this.requestCancelled = true;
    }

    protected boolean getCancelRequest() {
        return this.requestCancelled;
    }

    protected void setType(int n) {
        this.type = (byte)n;
    }

    public void setType(int n, byte[] byArray) {
        byArray[7] = (byte)n;
        this.type = (byte)n;
    }

    protected void setHeaderWritten(boolean bl) {
        this.hdrWritten = bl;
    }

    protected boolean headerWritten() {
        return this.hdrWritten;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isFragmentToFollow() {
        return this.fragToFollow;
    }

    public boolean isLittleEndian() {
        return this.byteOrder == 1;
    }

    byte getByteOrder() {
        return this.byteOrder;
    }

    public byte getGIOPMajor() {
        return this.GIOPMajor;
    }

    public byte getGIOPMinor() {
        return this.GIOPMinor;
    }

    public void setSize(byte[] byArray, int n) {
        this.setSize(byArray, n, 0);
    }

    public void setSize(byte[] byArray, int n, int n2) {
        this.size = n;
        int n3 = n - 12;
        if (this.byteOrder == 0) {
            byArray[n2 + 8] = (byte)(n3 >>> 24 & 0xFF);
            byArray[n2 + 9] = (byte)(n3 >>> 16 & 0xFF);
            byArray[n2 + 10] = (byte)(n3 >>> 8 & 0xFF);
            byArray[n2 + 11] = (byte)(n3 >>> 0 & 0xFF);
        } else {
            byArray[n2 + 8] = (byte)(n3 >>> 0 & 0xFF);
            byArray[n2 + 9] = (byte)(n3 >>> 8 & 0xFF);
            byArray[n2 + 10] = (byte)(n3 >>> 16 & 0xFF);
            byArray[n2 + 11] = (byte)(n3 >>> 24 & 0xFF);
        }
    }

    public void setFragmentToFollow(byte[] byArray, boolean bl) {
        byArray[6] = bl ? (byte)(byArray[6] | 2) : (byte)(byArray[6] & 0xFD);
        this.fragToFollow = bl;
    }

    public static Message createMessage(byte[] byArray, int n) throws SystemException, IOException, GIOPVersionException {
        int n2;
        int n3;
        int n4;
        int n5;
        Message message;
        if (byArray.length < 12) {
            throw new GIOPVersionException("0x" + Utility.bytesToHexString(byArray));
        }
        int n6 = byArray[n + 0] << 24 & 0xFF000000 | byArray[n + 1] << 16 & 0xFF0000 | byArray[n + 2] << 8 & 0xFF00 | byArray[n + 3] << 0 & 0xFF;
        if (n6 != 1195986768 && n6 != 1347373383) {
            throw new GIOPVersionException("0x" + Integer.toHexString(n6));
        }
        if (byArray[n + 4] != 1 || byArray[n + 4] == 1 && byArray[n + 5] > 2) {
            throw new GIOPVersionException(byArray[n + 4] + "." + byArray[n + 5]);
        }
        switch (byArray[n + 7]) {
            case 0: {
                message = new RequestMessage(byArray[n + 4], byArray[n + 5]);
                break;
            }
            case 3: {
                message = new LocateRequestMessage(byArray[n + 4], byArray[n + 5]);
                break;
            }
            case 2: {
                message = new CancelRequestMessage(byArray[n + 4], byArray[n + 5]);
                break;
            }
            case 1: {
                message = new ReplyMessage(byArray[n + 4], byArray[n + 5]);
                break;
            }
            case 4: {
                message = new LocateReplyMessage(byArray[n + 4], byArray[n + 5]);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                message = new Message(byArray[n + 4], byArray[n + 5]);
                break;
            }
            default: {
                throw new INTERNAL("Bad GIOP request:" + byArray[n + 7], 1229125003, CompletionStatus.COMPLETED_NO);
            }
        }
        message.magic = n6;
        message.flags = byArray[n + 6];
        message.byteOrder = (byte)(message.flags & 1);
        message.fragToFollow = (message.flags & 2) == 2;
        message.type = byArray[n + 7];
        if (message.byteOrder == 0) {
            n5 = byArray[n + 8] << 24 & 0xFF000000;
            n4 = byArray[n + 9] << 16 & 0xFF0000;
            n3 = byArray[n + 10] << 8 & 0xFF00;
            n2 = byArray[n + 11] << 0 & 0xFF;
        } else {
            n5 = byArray[n + 11] << 24 & 0xFF000000;
            n4 = byArray[n + 10] << 16 & 0xFF0000;
            n3 = byArray[n + 9] << 8 & 0xFF00;
            n2 = byArray[n + 8] << 0 & 0xFF;
        }
        message.size = (n5 | n4 | n3 | n2) + 12;
        return message;
    }

    public static void readFully(java.io.InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (int i = 0; i < n2; i += n3) {
            n3 = 0;
            int n4 = 0;
            while (true) {
                try {
                    n3 = inputStream.read(byArray, n + i, n2 - i);
                }
                catch (IOException iOException) {
                    if (n4++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n3 >= 0) continue;
            throw new IOException();
        }
    }

    public void write(OutputStream outputStream) throws SystemException {
        outputStream.write_long(1195986768);
        outputStream.write_octet(this.GIOPMajor);
        outputStream.write_octet(this.GIOPMinor);
        outputStream.write_boolean(false);
        outputStream.write_octet(this.type);
        outputStream.write_long(0);
    }

    public void read(InputStream inputStream) throws SystemException {
    }

    public String getTypeName() {
        String string;
        switch (this.type) {
            case 3: {
                string = "GIOPLocateRequest";
                break;
            }
            case 0: {
                string = "GIOPRequest";
                break;
            }
            case 1: {
                string = "GIOPReply";
                break;
            }
            case 4: {
                string = "GIOPLocateReply";
                break;
            }
            case 2: {
                string = "GIOPCancelRequest";
                break;
            }
            case 5: {
                string = "GIOPCloseConnection";
                break;
            }
            case 6: {
                string = "GIOPMessageError";
                break;
            }
            case 7: {
                string = "GIOPFragment";
                break;
            }
            default: {
                string = "UNKNOWN MESSAGE TYPE";
            }
        }
        return string;
    }
}

