/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestUtils;
import com.sun.security.sasl.preview.RealmCallback;
import com.sun.security.sasl.preview.RealmChoiceCallback;
import com.sun.security.sasl.preview.SaslClient;
import com.sun.security.sasl.preview.SaslException;
import com.sun.security.sasl.util.SaslImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

final class DigestMD5
extends DigestUtils
implements SaslClient {
    private boolean isStepTwoCompleted = false;
    private static final int MAX_CHALLENGE_LENGTH = 2048;
    private static final int MAX_RESPONSE_LENGTH = 4096;
    private CallbackHandler cbh;
    private String userName;
    private String authzIdStr;
    private byte[] authzId;
    private String selectedQopStr;
    private byte selectedQop;
    private String authRealm;
    private List realmChoices;
    private String digestUri;
    private char[] passwd;
    private byte[] nonce;
    private String negotiatedStrength;
    private boolean useUTF8 = false;
    private byte[] c_nonce;
    private static final String[] DIRECTIVE_KEY = new String[]{"realm", "qop", "algorithm", "nonce", "maxbuf", "charset", "cipher", "rspauth", "stale"};
    private final byte[][] challengeVal = new byte[DIRECTIVE_KEY.length][];
    private static final int REALM = 0;
    private static final int QOP = 1;
    private static final int ALGORITHM = 2;
    private static final int NONCE = 3;
    private static final int MAXBUF = 4;
    private static final int CHARSET = 5;
    private static final int CIPHER = 6;
    private static final int RESPONSE_AUTH = 7;
    private static final int STALE = 8;
    private int nonceCount = 0;
    private static final String[] JCE_CIPHER_NAME = new String[]{"Cipher.DESede", "Cipher.RC4", "Cipher.DES"};
    private static final byte DES_3_STRENGTH = 4;
    private static final byte RC4_STRENGTH = 4;
    private static final byte DES_STRENGTH = 2;
    private static final byte RC4_56_STRENGTH = 2;
    private static final byte RC4_40_STRENGTH = 1;
    private static final byte UNSET = 0;
    protected static final byte[] CIPHER_MASKS = new byte[]{4, 4, 2, 2, 1};
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int RAW_CNONCE_SIZE = 30;
    private static final int ENCODED_CNONCE_SIZE = 40;

    DigestMD5(String string, String string2, Map map, CallbackHandler callbackHandler) throws SaslException {
        super(map);
        if (string != null) {
            this.authzIdStr = string;
            try {
                this.authzId = string.getBytes("UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding authzId value into UTF-8", unsupportedEncodingException);
            }
        }
        this.digestUri = string2;
        this.cbh = callbackHandler;
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (byArray.length > 2048) {
            throw new SaslException("DIGEST-MD5: Invalid digest-challenge length. Got:  " + byArray.length + " Expected < " + 2048);
        }
        this.extractChallenge(byArray);
        if (!this.isStepTwoCompleted) {
            try {
                this.checkDigestChallenge();
                this.checkQopSupport();
                this.isStepTwoCompleted = true;
                return this.generateDigestResponse();
            }
            catch (SaslException saslException) {
                throw saslException;
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: Error generating digest response-value", iOException);
            }
        }
        this.verifyResponseValue(this.challengeVal[7]);
        this.completed = true;
        if (this.integrity && this.privacy) {
            this.secCtx = new DigestUtils.DigestPrivacy();
        } else if (this.integrity) {
            this.secCtx = new DigestUtils.DigestIntegrity();
        }
        return null;
    }

    private void extractChallenge(byte[] byArray) throws SaslException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(10);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = DigestMD5.skipLws(byArray, 0);
        while (n < byArray.length) {
            byte by = byArray[n];
            if (bl) {
                if (by == 44) {
                    if (byteArrayOutputStream.size() != 0) {
                        throw new SaslException("Directive key contains a ',':" + byteArrayOutputStream);
                    }
                    n = DigestMD5.skipLws(byArray, n + 1);
                    continue;
                }
                if (by == 61) {
                    if (byteArrayOutputStream.size() == 0) {
                        throw new SaslException("Empty directive key");
                    }
                    bl = false;
                    if ((n = DigestMD5.skipLws(byArray, n + 1)) < byArray.length) {
                        if (byArray[n] != 34) continue;
                        bl2 = true;
                        ++n;
                        continue;
                    }
                    throw new SaslException("Valueless directive found: " + byteArrayOutputStream.toString());
                }
                if (DigestMD5.isLws(by)) {
                    if ((n = DigestMD5.skipLws(byArray, n + 1)) < byArray.length) {
                        if (byArray[n] == 61) continue;
                        throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                    }
                    throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                }
                byteArrayOutputStream.write(by);
                ++n;
                continue;
            }
            if (bl2) {
                if (by == 92) {
                    if (++n < byArray.length) {
                        byteArrayOutputStream2.write(byArray[n]);
                        ++n;
                        continue;
                    }
                    throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
                }
                if (by == 34) {
                    ++n;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                byteArrayOutputStream2.write(by);
                ++n;
                continue;
            }
            if (DigestMD5.isLws(by) || by == 44) {
                this.extractDirective(byteArrayOutputStream.toString(), byteArrayOutputStream2.toByteArray());
                byteArrayOutputStream.reset();
                byteArrayOutputStream2.reset();
                bl = true;
                bl3 = false;
                bl2 = false;
                n = DigestMD5.skipLws(byArray, n + 1);
                continue;
            }
            if (bl3) {
                throw new SaslException("Expecting comma or linear whitespace after quoted string: \"" + byteArrayOutputStream2.toString() + "\"");
            }
            byteArrayOutputStream2.write(by);
            ++n;
        }
        if (bl2) {
            throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
        }
        if (byteArrayOutputStream.size() > 0) {
            this.extractDirective(byteArrayOutputStream.toString(), byteArrayOutputStream2.toByteArray());
        }
    }

    private static boolean isLws(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static int skipLws(byte[] byArray, int n) {
        int n2 = n;
        while (n2 < byArray.length) {
            if (!DigestMD5.isLws(byArray[n2])) {
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private void extractDirective(String string, byte[] byArray) throws SaslException {
        int n = 0;
        while (n < DIRECTIVE_KEY.length) {
            if (string.equalsIgnoreCase(DIRECTIVE_KEY[n])) {
                if (this.challengeVal[n] == null) {
                    this.challengeVal[n] = byArray;
                    break;
                }
                if (n == 0) {
                    if (this.realmChoices == null) {
                        this.realmChoices = new ArrayList(3);
                        this.realmChoices.add(this.challengeVal[n]);
                    }
                    this.realmChoices.add(byArray);
                    break;
                }
                if (n == 1) {
                    int n2 = this.challengeVal[n].length;
                    byte[] byArray2 = new byte[n2 + 1 + byArray.length];
                    System.arraycopy(this.challengeVal[n], 0, byArray2, 0, n2);
                    byArray2[n2] = 44;
                    System.arraycopy(byArray, 0, byArray2, n2 + 1, byArray.length);
                    this.challengeVal[n] = byArray2;
                    break;
                }
                throw new SaslException("DIGEST-MD5: server sent more than one " + string + " directive: " + new String(byArray));
            }
            ++n;
        }
    }

    private void checkDigestChallenge() throws SaslException, UnsupportedEncodingException {
        if (this.challengeVal[5] != null) {
            if (!"UTF-8".equalsIgnoreCase(new String(this.challengeVal[5], this.encoding))) {
                throw new SaslException("DIGEST-MD5: digest-challenge format violation. Unrecognised charset value: " + new String(this.challengeVal[5]));
            }
            this.encoding = "UTF8";
            this.useUTF8 = true;
        }
        if (this.challengeVal[2] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: algorithm directive missing");
        }
        if (!"md5-sess".equalsIgnoreCase(new String(this.challengeVal[2], this.encoding))) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation. Invalid value for 'algorithm' directive: " + this.challengeVal[2]);
        }
        if (this.challengeVal[3] == null) {
            throw new SaslException("DIGEST-MD5: Digest-challenge format violation: nonce directive missing");
        }
        this.nonce = this.challengeVal[3];
        ++this.nonceCount;
        try {
            String[] stringArray = null;
            if (this.challengeVal[0] != null) {
                if (this.realmChoices == null) {
                    stringArray = new String[]{new String(this.challengeVal[0], this.encoding)};
                } else {
                    stringArray = new String[this.realmChoices.size()];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = new String((byte[])this.realmChoices.get(n), this.encoding);
                        ++n;
                    }
                }
            }
            NameCallback nameCallback = this.authzIdStr == null ? new NameCallback("DIGEST-MD5 authentication ID: ") : new NameCallback("DIGEST-MD5 authentication ID: ", this.authzIdStr);
            PasswordCallback passwordCallback = new PasswordCallback("DIGEST-MD5 password: ", false);
            if (stringArray == null) {
                RealmCallback realmCallback = new RealmCallback("DIGEST-MD5 realm: ");
                this.cbh.handle(new Callback[]{realmCallback, nameCallback, passwordCallback});
                this.authRealm = realmCallback.getText();
                if (this.authRealm == null) {
                    this.authRealm = "";
                }
            } else {
                RealmChoiceCallback realmChoiceCallback = new RealmChoiceCallback("DIGEST-MD5 realm: ", stringArray, 0, false);
                this.cbh.handle(new Callback[]{realmChoiceCallback, nameCallback, passwordCallback});
                this.authRealm = stringArray[realmChoiceCallback.getSelectedIndexes()[0]];
            }
            this.passwd = passwordCallback.getPassword();
            passwordCallback.clearPassword();
            this.userName = nameCallback.getName();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire realm, authentication ID or password", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new SaslException("DIGEST-MD5: Error acquiring realm, authentication ID or password", iOException);
        }
        if (this.userName == null || this.passwd == null) {
            throw new SaslException("DIGEST-MD5: authentication ID and password must be specified");
        }
        int n = this.challengeVal[4] == null ? 65536 : Integer.parseInt(new String(this.challengeVal[4], this.encoding));
        this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n : Math.min(this.sendMaxBufSize, n);
    }

    private void checkQopSupport() throws IOException {
        if (this.challengeVal[1] == null) {
            this.selectedQopStr = "auth";
            this.selectedQop = 1;
        } else {
            String string = new String(this.challengeVal[1], this.encoding);
            String[] stringArray = new String[3];
            byte[] byArray = this.parseQop(string, stringArray, true);
            byte by = SaslImpl.combineMasks(byArray);
            byte by2 = SaslImpl.findPreferredMask(by, this.qop);
            switch (by2) {
                case 0: {
                    throw new SaslException("DIGEST-MD5: No common protection layer between client and server");
                }
                case 1: {
                    this.selectedQopStr = stringArray[2];
                    break;
                }
                case 2: {
                    this.selectedQopStr = stringArray[1];
                    this.integrity = true;
                    break;
                }
                case 4: {
                    this.selectedQopStr = stringArray[0];
                    this.integrity = true;
                    this.privacy = true;
                    this.checkStrengthSupport();
                }
            }
            if (this.integrity && this.privacy) {
                this.rawSendSize = this.sendMaxBufSize - 26;
            } else if (this.integrity) {
                this.rawSendSize = this.sendMaxBufSize - 16;
            }
        }
    }

    private void checkStrengthSupport() throws IOException {
        if (this.challengeVal[6] == null) {
            throw new SaslException("DIGEST-MD5: server did not specify cipher to use for 'auth-conf'");
        }
        String string = new String(this.challengeVal[6], this.encoding);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n");
        int n = stringTokenizer.countTokens();
        String string2 = null;
        byte[] byArray = new byte[]{0, 0, 0, 0, 0};
        String[] stringArray = new String[byArray.length];
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            int n3 = 0;
            while (n3 < DigestUtils.CIPHER_TOKENS.length) {
                if (string2.equalsIgnoreCase(DigestUtils.CIPHER_TOKENS[n3])) {
                    int n4 = n3;
                    byArray[n4] = (byte)(byArray[n4] | CIPHER_MASKS[n3]);
                    stringArray[n3] = string2;
                }
                ++n3;
            }
            ++n2;
        }
        Provider[] providerArray = Security.getProviders();
        byte[] byArray2 = new byte[byArray.length];
        int n5 = 0;
        while (n5 < providerArray.length) {
            Set<Object> set = providerArray[n5].keySet();
            if (set.contains(JCE_CIPHER_NAME[0])) {
                byArray2[0] = (byte)(byArray2[0] | CIPHER_MASKS[0]);
            }
            if (set.contains(JCE_CIPHER_NAME[2])) {
                byArray2[2] = (byte)(byArray2[2] | CIPHER_MASKS[2]);
            }
            if (set.contains(JCE_CIPHER_NAME[1])) {
                byArray2[1] = (byte)(byArray2[1] | CIPHER_MASKS[1]);
                byArray2[3] = (byte)(byArray2[3] | CIPHER_MASKS[3]);
                byArray2[4] = (byte)(byArray2[4] | CIPHER_MASKS[4]);
            }
            ++n5;
        }
        byte by = 0;
        int n6 = 0;
        while (n6 < byArray.length) {
            int n7 = n6;
            byArray[n7] = (byte)(byArray[n7] & byArray2[n6]);
            by = (byte)(by | byArray[n6]);
            ++n6;
        }
        if (by == 0) {
            throw new SaslException("DIGEST-MD5: Client supports none of these cipher suites: " + string);
        }
        this.cipherSuite = this.findCipherAndStrength(byArray, stringArray);
        if (this.cipherSuite == null) {
            throw new SaslException("DIGEST-MD5: Unable to negotiate a strength level for 'auth-conf'");
        }
    }

    private String findCipherAndStrength(byte[] byArray, String[] stringArray) {
        int n = 0;
        while (n < this.strength.length) {
            byte by = this.strength[n];
            if (by != 0) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    if (by == byArray[n2] && (this.specifiedCipher == null || this.specifiedCipher.equals(stringArray[n2]))) {
                        switch (by) {
                            case 4: {
                                this.negotiatedStrength = "high";
                                break;
                            }
                            case 2: {
                                this.negotiatedStrength = "medium";
                                break;
                            }
                            case 1: {
                                this.negotiatedStrength = "low";
                            }
                        }
                        return stringArray[n2];
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    private byte[] generateDigestResponse() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.useUTF8) {
            byteArrayOutputStream.write("charset=".getBytes(this.encoding));
            byteArrayOutputStream.write(this.challengeVal[5]);
            byteArrayOutputStream.write(44);
        }
        byteArrayOutputStream.write(("username=\"" + DigestMD5.quotedStringValue(this.userName) + "\",").getBytes(this.encoding));
        byteArrayOutputStream.write(("realm=\"" + DigestMD5.quotedStringValue(this.authRealm) + "\",").getBytes(this.encoding));
        byteArrayOutputStream.write("nonce=\"".getBytes(this.encoding));
        DigestMD5.writeQuotedStringValue(byteArrayOutputStream, this.nonce);
        byteArrayOutputStream.write(34);
        byteArrayOutputStream.write(44);
        byteArrayOutputStream.write(("nc=" + this.nonceCountToHex() + ",").getBytes(this.encoding));
        this.c_nonce = DigestMD5.generateCNONCE();
        byteArrayOutputStream.write("cnonce=\"".getBytes(this.encoding));
        DigestMD5.writeQuotedStringValue(byteArrayOutputStream, this.c_nonce);
        byteArrayOutputStream.write("\",".getBytes(this.encoding));
        byteArrayOutputStream.write(("digest-uri=\"" + this.digestUri + "\",").getBytes(this.encoding));
        byteArrayOutputStream.write("maxbuf=".getBytes(this.encoding));
        byteArrayOutputStream.write(String.valueOf(this.recvMaxBufSize).getBytes(this.encoding));
        byteArrayOutputStream.write(",".getBytes(this.encoding));
        try {
            byteArrayOutputStream.write("response=".getBytes(this.encoding));
            byteArrayOutputStream.write(this.generateResponseValue("AUTHENTICATE"));
            byteArrayOutputStream.write(",".getBytes(this.encoding));
        }
        catch (Exception exception) {
            throw new SaslException("DIGEST-MD5: Error generating response value", exception);
        }
        byteArrayOutputStream.write(("qop=" + this.selectedQopStr).getBytes(this.encoding));
        if (this.cipherSuite != null) {
            byteArrayOutputStream.write((",cipher=\"" + this.cipherSuite + "\"").getBytes(this.encoding));
        }
        if (this.authzId != null) {
            byteArrayOutputStream.write(",authzid=\"".getBytes(this.encoding));
            DigestMD5.writeQuotedStringValue(byteArrayOutputStream, this.authzId);
            byteArrayOutputStream.write("\"".getBytes(this.encoding));
        }
        if (byteArrayOutputStream.size() > 4096) {
            throw new SaslException("DIGEST-MD5: digest-response size too large. Length: " + byteArrayOutputStream.size());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] generateResponseValue(String string) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byteArrayOutputStream2.write((string + ":" + this.digestUri).getBytes(this.encoding));
        if (this.selectedQopStr.equals("auth-conf") || this.selectedQopStr.equals("auth-int")) {
            byteArrayOutputStream2.write(":00000000000000000000000000000000".getBytes(this.encoding));
        }
        messageDigest.update(byteArrayOutputStream2.toByteArray());
        byte[] byArray2 = messageDigest.digest();
        byArray = this.binaryToHex(byArray2);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        byte[] byArray3 = ":".getBytes(this.encoding);
        byteArrayOutputStream3.write(this.stringToByte_8859_1(this.userName));
        byteArrayOutputStream3.write(byArray3);
        byteArrayOutputStream3.write(this.stringToByte_8859_1(this.authRealm));
        byteArrayOutputStream3.write(byArray3);
        byteArrayOutputStream3.write(this.stringToByte_8859_1(new String(this.passwd)));
        messageDigest.update(byteArrayOutputStream3.toByteArray());
        byArray2 = messageDigest.digest();
        ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
        byteArrayOutputStream4.write(byArray2);
        byteArrayOutputStream4.write(byArray3);
        byteArrayOutputStream4.write(this.nonce);
        byteArrayOutputStream4.write(byArray3);
        byteArrayOutputStream4.write(this.c_nonce);
        if (this.authzId != null) {
            byteArrayOutputStream4.write(byArray3);
            byteArrayOutputStream4.write(this.authzId);
        }
        messageDigest.update(byteArrayOutputStream4.toByteArray());
        byArray2 = messageDigest.digest();
        this.H_A1 = byArray2;
        byte[] byArray4 = this.binaryToHex(byArray2);
        byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray4);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(this.nonce);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(this.nonceCountToHex().getBytes(this.encoding));
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(this.c_nonce);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(this.selectedQopStr.getBytes(this.encoding));
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray);
        messageDigest.update(byteArrayOutputStream.toByteArray());
        byArray2 = messageDigest.digest();
        return this.binaryToHex(byArray2);
    }

    private static final byte[] generateCNONCE() {
        Random random = new Random();
        byte[] byArray = new byte[30];
        random.nextBytes(byArray);
        byte[] byArray2 = new byte[40];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            byte by2 = byArray[n2 + 1];
            byte by3 = byArray[n2 + 2];
            byArray2[n++] = (byte)pem_array[by >>> 2 & 0x3F];
            byArray2[n++] = (byte)pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            byArray2[n++] = (byte)pem_array[(by2 << 2 & 0x3C) + (by3 >>> 6 & 3)];
            byArray2[n++] = (byte)pem_array[by3 & 0x3F];
            n2 += 3;
        }
        return byArray2;
    }

    private String nonceCountToHex() {
        String string = Integer.toHexString(this.nonceCount);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < 8) {
            int n = 0;
            while (n < 8 - string.length()) {
                stringBuffer.append("0");
                ++n;
            }
        }
        return new String(stringBuffer + string);
    }

    private byte[] binaryToHex(byte[] byArray) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray[n] & 0xFF));
            } else {
                stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            }
            ++n;
        }
        return stringBuffer.toString().getBytes(this.encoding);
    }

    private byte[] stringToByte_8859_1(String string) throws SaslException {
        char[] cArray = string.toCharArray();
        try {
            if (this.useUTF8) {
                int n = 0;
                while (n < cArray.length) {
                    if (cArray[n] > '\u00ff') {
                        return string.getBytes("UTF8");
                    }
                    ++n;
                }
            }
            return string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("cannot encode string in UTF8 or 8859-1 (Latin-1)", unsupportedEncodingException);
        }
    }

    public String getNegotiatedProperty(String string) throws SaslException {
        if (this.completed) {
            if (string.equals("javax.security.sasl.strength")) {
                return this.negotiatedStrength;
            }
            return super.getNegotiatedProperty(string);
        }
        throw new SaslException("Not completed");
    }

    private static boolean needEscape(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (DigestMD5.needEscape(string.charAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean needEscape(char c) {
        return c == '\"' || c == '\\' || c == '\u007f' || c >= '\u0000' && c <= '\u001f' && c != '\r' && c != '\t' && c != '\n';
    }

    private static String quotedStringValue(String string) {
        if (DigestMD5.needEscape(string)) {
            int n = string.length();
            char[] cArray = new char[n + n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = string.charAt(n3);
                if (DigestMD5.needEscape(c)) {
                    cArray[n2++] = 92;
                }
                cArray[n2++] = c;
                ++n3;
            }
            return new String(cArray, 0, n2);
        }
        return string;
    }

    private static void writeQuotedStringValue(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (DigestMD5.needEscape((char)by)) {
                byteArrayOutputStream.write(92);
            }
            byteArrayOutputStream.write(by);
            ++n2;
        }
    }

    private void verifyResponseValue(byte[] byArray) throws SaslException {
        if (byArray == null) {
            throw new SaslException("DIGEST-MD5: Authenication failed. Expecting 'rspauth' authentication success message");
        }
        try {
            byte[] byArray2 = this.generateResponseValue("");
            if (!Arrays.equals(byArray2, byArray)) {
                throw new SaslException("Server's rspauth value does not match what client expects");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("Problem generating response-value for verification", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new SaslException("Problem generating response-value for verification", iOException);
        }
    }
}

