/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.awt;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMAWTUtil;
import com.ibm.gsk.ikeyman.awt.KMButton;
import com.ibm.gsk.ikeyman.awt.KMFilenameFilter;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.KMHorizontalButtonPanel;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class KeyFileDialog
extends JDialog
implements IkeymanConstants,
ActionListener,
ItemListener {
    public static final int TRANSFER_KEY = 1;
    public static final int TRANSFER_KEY_EXPORT = 2;
    public static final int TRANSFER_KEY_IMPORT = 4;
    public static final int EXTRACT_DATA = 8;
    public static String[] DEFAULT_EXPORT_DATA_TYPES = new String[]{Ikeyman.getNLSResString("GUI_LABEL_DATA_TYPE_BASE64"), Ikeyman.getNLSResString("GUI_LABEL_DATA_TYPE_DER")};
    private int taskType = 1;
    private boolean isExportAllowed = true;
    private int transferType = 4;
    private JRadioButton exportRButton;
    private JRadioButton importRButton;
    private ButtonGroup buttonGroup;
    private KMButton okButton;
    private KMButton cancelButton;
    private KMButton helpButton;
    private KMButton browseButton;
    private JLabel typeLabel;
    private JComboBox typeChoice;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JLabel dirNameLabel;
    private JTextField dirNameField;
    private KeyStoreManager keyDb;
    private String currWorkingDirName;
    private int mode;
    private String browserFileName;
    private String browserDirName;
    private JDialog diagInstance;
    private int KeyStoreIndex;
    private int keyDbType = 0;
    private String fileName;
    private String dirName;
    private int fileTypeSelected;
    private JPanel fileNamePanel;
    private String dbTypeString;

    public KeyFileDialog(JFrame jFrame, String string) {
        this(jFrame, string, 0);
    }

    public KeyFileDialog(JFrame jFrame, String string, int n) {
        this(jFrame, string, null, 1, n);
    }

    public KeyFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, boolean bl) {
        this(jFrame, string, keyStoreManager, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), 1, bl, KeyFileDialog.getTypeLabelText(1), KeyFileDialog.getTypeChoiceLabels(1), bl ? 1 : 0);
    }

    public KeyFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, int n, int n2) {
        this(jFrame, string, keyStoreManager, Ikeyman.getNLSResString("GUI_LABEL_FILENAME"), n, false, KeyFileDialog.getTypeLabelText(n), KeyFileDialog.getTypeChoiceLabels(n), n2);
    }

    public KeyFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, String string2, int n, int n2) {
        this(jFrame, string, keyStoreManager, string2, n, false, KeyFileDialog.getTypeLabelText(n), KeyFileDialog.getTypeChoiceLabels(n), n2);
    }

    public KeyFileDialog(JFrame jFrame, String string, KeyStoreManager keyStoreManager, String string2, int n, boolean bl, String string3, String[] stringArray, int n2) {
        super(jFrame, string, true);
        Serializable serializable;
        Serializable serializable2;
        this.keyDb = keyStoreManager;
        this.mode = n2;
        this.taskType = n;
        this.isExportAllowed = bl;
        this.keyDbType = keyStoreManager.getType();
        this.diagInstance = this;
        this.populateFields(string2, string3, stringArray);
        this.fileNamePanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.fileNamePanel.setLayout(gridBagLayout);
        if (n == 1 && bl) {
            serializable2 = new JPanel();
            serializable2.setLayout(new FlowLayout(0));
            serializable2.add(this.exportRButton);
            serializable2.add(this.importRButton);
            serializable = new TitledBorder(Ikeyman.getNLSResString("GUI_LABEL_CHOOSE_ACTION_TYPE"));
            serializable2.setBorder((Border)((Object)serializable));
            ((TitledBorder)serializable2.getBorder()).setTitleJustification(1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout.setConstraints((Component)serializable2, gridBagConstraints);
            this.fileNamePanel.add((Component)serializable2);
            this.transferType = 2;
            this.exportRButton.setSelected(true);
            n2 = this.exportRButton.isSelected() ? 1 : 0;
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.typeLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.typeChoice, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.fileNameLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.fileNameField, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.browseButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagLayout.setConstraints(this.dirNameField, gridBagConstraints);
        this.fileNamePanel.add(this.typeLabel);
        this.fileNamePanel.add(this.typeChoice);
        this.fileNamePanel.add(this.fileNameLabel);
        this.fileNamePanel.add(this.fileNameField);
        this.fileNamePanel.add(this.browseButton);
        this.fileNamePanel.add(this.dirNameLabel);
        this.fileNamePanel.add(this.dirNameField);
        serializable2 = new SoftBevelBorder(1);
        serializable = new KMHorizontalButtonPanel();
        ((KMHorizontalButtonPanel)serializable).add(this.okButton);
        ((KMHorizontalButtonPanel)serializable).add(this.cancelButton);
        ((KMHorizontalButtonPanel)serializable).equalizeButtons();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.fileNamePanel, "Center");
        jPanel.add((Component)serializable, "South");
        BevelBorder bevelBorder = new BevelBorder(0);
        jPanel.setBorder(bevelBorder);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        this.addWindowListener(new DiagAdapter());
        this.pack();
        this.setResizable(false);
        if (n == 1 && bl) {
            this.importRButton.requestFocus();
        } else {
            this.fileNameField.requestFocus();
        }
    }

    public static String getTypeLabelText(int n) {
        if (n == 1) {
            return Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE");
        }
        if (n == 8) {
            return Ikeyman.getNLSResString("GUI_LABEL_TARGET_DATA_TYPE");
        }
        return null;
    }

    public String getDBTypeLabelText() {
        String string = this.dbTypeString;
        return string;
    }

    public static String[] getTypeChoiceLabels(int n) {
        if (n == 1) {
            return KeyFileDialog.getSupportedExportTargetsLabels();
        }
        if (n == 8) {
            return DEFAULT_EXPORT_DATA_TYPES;
        }
        return null;
    }

    public static String[] getSupportedExportTargetsLabels() {
        String[] stringArray = null;
        boolean bl = false;
        int[] nArray = KeyStoreManager.getSupportedDatabaseTypes();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] != 4 && nArray[n2] != 3 && nArray[n2] != 2) {
                if (nArray[n2] == 1) {
                    bl = true;
                }
                ++n;
            }
            ++n2;
        }
        if (!bl && !Ikeyman.javaOnly) {
            ++n;
        }
        stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] != 4 && nArray[n4] != 3 && nArray[n4] != 2) {
                stringArray[n3] = KeyStoreManager.getKeyStoreName(nArray[n4]);
                ++n3;
            }
            ++n4;
        }
        if (!bl && !Ikeyman.javaOnly) {
            stringArray[n3] = KeyStoreManager.getKeyStoreName(1);
        }
        return stringArray;
    }

    protected void populateFields(String string, String string2, String[] stringArray) {
        this.populateTypeChoices(string2, stringArray);
        this.populateNameFields(string);
        this.populateButtons();
        this.setToolTips();
    }

    protected void populateTypeChoices(String string, String[] stringArray) {
        if (this.taskType != 8 && this.isExportAllowed) {
            this.buttonGroup = new ButtonGroup();
            this.exportRButton = new JRadioButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_EXPORT_KEY"));
            this.importRButton = new JRadioButton(Ikeyman.getNLSResString("GUI_BUTTON_LABEL_IMPORT_KEY"));
            this.exportRButton.setActionCommand("Export");
            this.importRButton.setActionCommand("Import");
            this.exportRButton.addActionListener(this);
            this.importRButton.addActionListener(this);
            this.buttonGroup.add(this.exportRButton);
            this.buttonGroup.add(this.importRButton);
        }
        this.typeLabel = new JLabel(string);
        this.typeChoice = new JComboBox();
        this.typeChoice.getAccessibleContext().setAccessibleName(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.typeChoice.addItem(stringArray[n2]);
            ++n2;
        }
        this.typeChoice.removeItem("Microsoft Certificate Store");
        this.typeChoice.addItemListener(this);
        this.fileTypeSelected = this.taskType == 1 ? 7 : (this.taskType == 8 ? 8 : 0);
    }

    protected void populateNameFields(String string) {
        int n = 45;
        if (Ikeyman.screenSize.width < 800) {
            n = 25;
        } else if (Ikeyman.screenSize.width < 1024) {
            n = 35;
        }
        String string2 = Locale.getDefault().getLanguage();
        if (string2.equals("ja")) {
            n *= 2;
        }
        this.fileNameLabel = new JLabel(string);
        this.fileNameField = new JTextField("*" + KeyStoreManager.getKeyDbFileExtensionWithType(this.typeChoice.getSelectedItem().toString()), n);
        this.fileNameField.getAccessibleContext().setAccessibleName(string);
        if (this.keyDb != null) {
            this.keyDbType = this.keyDb.getType();
        }
        this.currWorkingDirName = KeyStoreManager.getDefaultKeyDbFileLocation(this.keyDbType);
        this.dirNameLabel = new JLabel(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        this.dirNameField = new JTextField(this.currWorkingDirName, n);
        this.dirNameField.getAccessibleContext().setAccessibleName(Ikeyman.getNLSResString("GUI_LABEL_LOCATION"));
        if (string2.equals("ko") || string2.equals("ja")) {
            this.fileNameField.setFont(Ikeyman.defaultMonospacedFont);
            this.dirNameField.setFont(Ikeyman.defaultMonospacedFont);
        }
    }

    protected void populateButtons() {
        this.browseButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_BROWSE"));
        this.okButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_OK"));
        this.cancelButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CANCEL"));
        this.helpButton = new KMButton(this, Ikeyman.getNLSResString("GUI_BUTTON_LABEL_HELP"));
        this.browseButton.setActionCommand("Browse");
        this.okButton.setActionCommand("OK");
        this.cancelButton.setActionCommand("Cancel");
        this.helpButton.setActionCommand("Help");
        this.browseButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        if (!Ikeyman.isHelpAvailable()) {
            this.helpButton.setEnabled(false);
        }
    }

    protected void setToolTips() {
        if (this.taskType == 1) {
            this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_KEY_FILE_TYPE"));
        } else if (this.taskType == 8) {
            this.typeChoice.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_DATA_TYPE"));
        }
        this.fileNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_NAME"));
        this.dirNameField.setToolTipText(Ikeyman.getNLSResString("GUI_MSG_TIP_FILE_LOCATION"));
    }

    public int getTransferType() {
        return this.transferType;
    }

    public String getFileName() {
        return KMUtil.trimBlankSpace(this.fileName);
    }

    public String getDirName() {
        return KMUtil.trimBlankSpace(this.dirName);
    }

    public void setFileName(String string) {
        this.fileNameField.setText(string);
    }

    public void setDirName(String string) {
        this.dirNameField.setText(string);
    }

    public int getFileTypeSelected() {
        int n = this.typeChoice.getSelectedIndex();
        String string = this.typeChoice.getSelectedItem().toString();
        if (this.taskType == 8) {
            this.fileTypeSelected = n == 0 ? 8 : (n == 1 ? 9 : (n == 2 ? 10 : 8));
        } else if (this.taskType == 1) {
            this.fileTypeSelected = KeyStoreManager.getDbTypeFromKeyStore(string);
            if (this.fileTypeSelected == 0 && KeyStoreManager.loadCMSProvider() && !Ikeyman.jniLoadErr()) {
                int[] nArray = KeyStoreManager.getSupportedDatabaseTypes();
                this.fileTypeSelected = KeyStoreManager.getDbTypeFromKeyStore(string);
            }
        } else {
            this.fileTypeSelected = 0;
        }
        return this.fileTypeSelected;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0000, source=" + object + ", arg=" + string);
        if (string.equals("OK")) {
            this.fileName = this.fileNameField.getText();
            this.dirName = this.dirNameField.getText();
            if (KMUtil.trimBlankSpace(this.fileName) != null) {
                File file;
                if (this.dirName == null) {
                    this.dirName = this.currWorkingDirName;
                }
                if (!this.dirName.endsWith(File.separator)) {
                    this.dirName = this.dirName + File.separator;
                }
                if (!(Ikeyman.isOverwriteConfirmedFileDialog() && this.fileName.equals(this.browserFileName) && this.dirName.equals(this.browserDirName) || this.mode != 1 || !(file = new File(this.dirName, this.fileName)).exists())) {
                    if (this.getFileTypeSelected() == 10) {
                        Object[] objectArray;
                        Object[] objectArray2 = new String[]{Ikeyman.getNLSResString("GUI_BUTTON_LABEL_ADDTO"), Ikeyman.getNLSResString("GUI_BUTTON_LABEL_CREATE")};
                        String string2 = Ikeyman.getNLSResString("GUI_DIALOG_QST_REPLACE_OR_ADD");
                        String string3 = MessageFormat.format(string2, objectArray = new Object[]{this.fileName});
                        int n = JOptionPane.showOptionDialog(this, string3, null, -1, 3, null, objectArray2, objectArray2[0]);
                        if (n == 1) {
                            file.delete();
                        }
                    } else {
                        int n = KMFrame.showConfirmDialog(KMAWTUtil.getFrame(this), Ikeyman.getNLSResString("GUI_DIALOG_QST_UPDATE_KDB_FILE"), 1);
                        if (n != 0) {
                            this.fileNameField.requestFocus();
                            return;
                        }
                    }
                }
                KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0500, before setVisible");
                ((Component)this).setVisible(false);
                KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0510, after setVisible");
            } else {
                if (this.KeyStoreIndex != 2) {
                    KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0530");
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INVALID_FILE_PATH_NAME"));
                }
                this.fileNameField.requestFocus();
                ((Component)this).setVisible(false);
            }
        } else if (string.equals("Cancel")) {
            KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0600, Cancel button is hit");
            this.fileName = null;
            this.dirName = null;
            ((Component)this).setVisible(false);
        } else if (string.equals("Browse")) {
            Object object2;
            KMUtil.debugMsg("KeyFileDialog::actionPerformed() 0700, Browse button is hit");
            JFileChooser jFileChooser = new JFileChooser(KMSystem.getWorkingDirName());
            jFileChooser.setFileHidingEnabled(KMFrame.hideHiddenFiles);
            if (KMFrame.isWindowLookAndFeel()) {
                jFileChooser.setPreferredSize(new Dimension(((JComponent)object).getWidth() * 6, ((JComponent)object).getHeight() * 10));
            }
            jFileChooser.setDialogTitle(super.getTitle());
            Dimension dimension = jFileChooser.getSize();
            jFileChooser.setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
            jFileChooser.setSelectedFile(new File("*" + KeyStoreManager.getKeyDbFileExtensionWithType(this.typeChoice.getSelectedItem().toString())));
            jFileChooser.setCurrentDirectory(new File(this.dirNameField.getText()));
            int n = KeyStoreManager.getDbTypeFromKeyStore(this.typeChoice.getSelectedItem().toString());
            String string4 = KeyStoreManager.getKeyDbFileExtensionWithType(this.typeChoice.getSelectedItem().toString());
            if (string4 != null && this.taskType == 1) {
                object2 = new KMFilenameFilter(string4, Ikeyman.getNLSResString("GUI_LABEL_DBTYPE"));
                jFileChooser.addChoosableFileFilter((FileFilter)object2);
            } else {
                object2 = this.fileNameField.getText();
                if (((String)object2).lastIndexOf(".") != -1) {
                    object2 = ((String)object2).substring(((String)object2).lastIndexOf("."));
                    jFileChooser.setSelectedFile(new File("*" + (String)object2));
                } else {
                    object2 = "";
                }
                KMFilenameFilter kMFilenameFilter = new KMFilenameFilter(new String[]{object2, ".cer"}, Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE"));
                jFileChooser.addChoosableFileFilter(kMFilenameFilter);
            }
            int n2 = this.mode == 0 ? jFileChooser.showOpenDialog(null) : jFileChooser.showSaveDialog(null);
            if (n2 == 0) {
                object2 = jFileChooser.getSelectedFile();
                if (object2 != null) {
                    this.fileName = ((File)object2).getName();
                    this.fileNameField.setText(this.fileName);
                    this.dirName = jFileChooser.getCurrentDirectory().toString();
                    if (!this.dirName.endsWith(File.separator)) {
                        this.dirName = this.dirName + File.separator;
                    }
                    this.dirNameField.setText(this.dirName);
                    KMSystem.setCurrentWorkingDirName(this.dirName, this.getFileTypeSelected());
                }
            } else if (n2 != 1) {
                if (n2 == -1) {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_NOT_OPENED"));
                } else {
                    KMFrame.errorHandler(KMAWTUtil.getFrame(this), KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                }
            }
        } else if (string.equals("Export")) {
            this.transferType = 2;
            this.mode = 1;
        } else if (string.equals("Import")) {
            this.transferType = 4;
            this.mode = 0;
        } else if (string.equals("Help")) {
            String string5 = "packages.html";
            Ikeyman.showHelpWindow(this, string5);
        }
        KMUtil.debugMsg("KeyFileDialog::actionPerformed() 9999");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        Object object2 = itemEvent.getSource();
        KMUtil.debugMsg("KeyFileDialog::itemStateChanged() 0000, item=" + object + ", source=" + object2);
        this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(object.toString());
        this.dbTypeString = object.toString();
        int n = this.typeChoice.getSelectedIndex();
        if (this.taskType == 8) {
            this.dirNameField.setText(this.currWorkingDirName);
            if (n == 0) {
                this.fileNameField.setText(KeyStoreManager.DEFAULT_CERTIFICATE_NAME_ARM);
            } else if (n == 1) {
                this.fileNameField.setText(KeyStoreManager.DEFAULT_CERTIFICATE_NAME_DER);
            } else if (n == 2) {
                this.fileNameField.setText(KeyStoreManager.DEFAULT_SSLIGHT_EXTRACT_FILE_NAME);
                this.dirNameField.setText(KeyStoreManager.DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION);
            } else {
                this.fileNameField.setText(KeyStoreManager.DEFAULT_CERTIFICATE_NAME_ARM);
            }
        } else {
            if (this.KeyStoreIndex == 0 && KeyStoreManager.loadCMSProvider()) {
                Ikeyman.jniLoadErr();
                int[] nArray = KeyStoreManager.getSupportedDatabaseTypes();
                this.KeyStoreIndex = KeyStoreManager.getDbTypeFromKeyStore(object.toString());
                KMUtil.debugMsg("KeyFileDialog::itemStateChanged() 0010 selection =" + object.toString() + " KeyStoreIndex=" + this.KeyStoreIndex);
            }
            this.fileNameField.setEditable(true);
            this.dirNameField.setEditable(true);
            this.browseButton.setEnabled(true);
            this.dirNameField.setText(KeyStoreManager.getDefaultKeyDbFileLocation(n));
            this.fileNameField.setText("*" + KeyStoreManager.getKeyDbFileExtensionWithType(this.typeChoice.getSelectedItem().toString()));
            if (this.KeyStoreIndex == 2) {
                this.fileNameField.setText("");
                this.dirNameField.setText("");
                this.fileNameField.setEditable(false);
                this.dirNameField.setEditable(false);
                this.browseButton.setEnabled(false);
            }
        }
        KMUtil.debugMsg("KeyFileDialog::itemStateChanged() 9999");
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.okButton.requestFocus();
    }

    class DiagAdapter
    extends WindowAdapter {
        DiagAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KeyFileDialog.this.fileName = null;
            KeyFileDialog.this.dirName = null;
            KMUtil.debugMsg("DEBUG......KeyFileDialog WindowAdapter to hide");
            ((Component)KeyFileDialog.this).setVisible(false);
            KMUtil.debugMsg("DEBUG......KeyFileDialog WindowAdapter after hide");
        }
    }
}

