/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman;

import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KeyDatabase;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseOperatorNullException;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.cli.CLICertificateInfo;
import com.ibm.gsk.ikeyman.cli.CLICertificateManager;
import com.ibm.gsk.ikeyman.cli.CLIConstants;
import com.ibm.gsk.ikeyman.cli.CLICryptoCertificateManager;
import com.ibm.gsk.ikeyman.cli.CLICryptoDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLICryptoRequestManager;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseInfo;
import com.ibm.gsk.ikeyman.cli.CLIDatabaseManager;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreCertificateManager;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreManager;
import com.ibm.gsk.ikeyman.cli.CLIKeyStoreRequestManager;
import com.ibm.gsk.ikeyman.cli.CLIRequestInfo;
import com.ibm.gsk.ikeyman.cli.CLIRequestManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ikeycmd
implements CLIConstants {
    public static boolean DEBUG = false;
    public static FileOutputStream debugDumpOutputStream = null;
    public static PrintWriter debugPrintWriter = null;
    private static ResourceBundle guiRB;
    private static boolean isTokenLabelFlagUsed;
    private static boolean isSlotIDFlagUsed;
    static /* synthetic */ Class class$com$ibm$gsk$ikeyman$ikeycmd;

    public static void main(String[] stringArray) {
        ikeycmd.init();
        int n = stringArray.length == 0 ? -14 : ikeycmd.getMode(stringArray);
        block0 : switch (n) {
            case 1: {
                int n2 = ikeycmd.getDatabaseAction(stringArray);
                switch (n2) {
                    case 4: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseCreate(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 4);
                        break block0;
                    }
                    case 5: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseChangePw(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 5);
                        break block0;
                    }
                    case 6: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseStashPw(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 6);
                        break block0;
                    }
                    case 7: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseConvert(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 7);
                        break block0;
                    }
                    case 8: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseDelete(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 8);
                        break block0;
                    }
                    case -3: {
                        ikeycmd.displayHelp(stringArray[1], -3);
                        break block0;
                    }
                    case -24: {
                        ikeycmd.displayHelp(null, -24);
                        break block0;
                    }
                    case 30: {
                        CLIDatabaseInfo cLIDatabaseInfo = ikeycmd.parseDatabaseList(stringArray);
                        ikeycmd.handleDatabaseTask(cLIDatabaseInfo, 30);
                        break block0;
                    }
                }
                ikeycmd.displayHelp(null, n2);
                break;
            }
            case 3: {
                int n3 = ikeycmd.getRequestAction(stringArray);
                switch (n3) {
                    case 24: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestCreate(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 24);
                        break block0;
                    }
                    case 9: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestRecreate(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 9);
                        break block0;
                    }
                    case 27: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestList(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 27);
                        break block0;
                    }
                    case 28: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestDetails(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 28);
                        break block0;
                    }
                    case 29: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestExtract(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 29);
                        break block0;
                    }
                    case 26: {
                        CLIRequestInfo cLIRequestInfo = ikeycmd.parseRequestDelete(stringArray);
                        ikeycmd.handleRequestTask(cLIRequestInfo, 26);
                        break block0;
                    }
                    case -4: {
                        ikeycmd.displayHelp(stringArray[1], -4);
                        break block0;
                    }
                    case -25: {
                        ikeycmd.displayHelp(null, -25);
                        break block0;
                    }
                }
                ikeycmd.displayHelp(null, n3);
                break;
            }
            case 2: {
                int n4 = ikeycmd.getCertificateAction(stringArray);
                switch (n4) {
                    case 23: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateCreate(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 23);
                        break block0;
                    }
                    case 15: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateReceive(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 15);
                        break block0;
                    }
                    case 16: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateSign(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 16);
                        break block0;
                    }
                    case 17: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateAdd(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 17);
                        break block0;
                    }
                    case 25: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateDelete(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 25);
                        break block0;
                    }
                    case 10: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateList(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 10);
                        break block0;
                    }
                    case 11: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateDetails(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 11);
                        break block0;
                    }
                    case 18: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateModify(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 18);
                        break block0;
                    }
                    case 13: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateImport(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 13);
                        break block0;
                    }
                    case 12: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateExport(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 12);
                        break block0;
                    }
                    case 14: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateExtract(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 14);
                        break block0;
                    }
                    case 19: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateSetDefault(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 19);
                        break block0;
                    }
                    case 20: {
                        CLICertificateInfo cLICertificateInfo = ikeycmd.parseCertificateGetDefault(stringArray);
                        ikeycmd.handleCertificateTask(cLICertificateInfo, 20);
                        break block0;
                    }
                    case -5: {
                        ikeycmd.displayHelp(stringArray[1], -5);
                        break block0;
                    }
                    case -26: {
                        ikeycmd.displayHelp(null, -26);
                        break block0;
                    }
                }
                ikeycmd.displayHelp(null, n4);
                break;
            }
            case 21: {
                ikeycmd.displayHelp(null, 21);
                break;
            }
            case 22: {
                if (KMSystem.isJNIEnabled()) {
                    KMSystem.showLibInfo();
                    break;
                }
                ikeycmd.showProductInfo();
                break;
            }
            case -2: {
                ikeycmd.displayHelp(stringArray[0], -2);
                break;
            }
            case -14: {
                ikeycmd.displayHelp(null, -14);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, -2);
            }
        }
        ikeycmd.closeDumpFiles();
        KMSystem.cleanAll();
    }

    public static void init() {
        try {
            Object object;
            KMSystem.init();
            ikeycmd.loadGUIMsgResource();
            String string = System.getProperty("keyman.debug");
            String string2 = System.getProperty("keyman.debugDumpFileName");
            if (string != null) {
                if (string.equalsIgnoreCase("true")) {
                    DEBUG = true;
                }
                if (string2 == null) {
                    string2 = "ikmgdbg.log";
                }
                object = new File(string2);
                boolean bl = ((File)object).exists();
                try {
                    debugDumpOutputStream = new FileOutputStream((File)object);
                    debugPrintWriter = new PrintWriter(debugDumpOutputStream, true);
                }
                catch (IOException iOException) {
                    if (debugDumpOutputStream != null) {
                        try {
                            debugDumpOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    debugDumpOutputStream = null;
                    debugPrintWriter = null;
                }
            }
            if ((object = System.getProperty("ikeycmd.properties")) != null) {
                Properties properties = new Properties(System.getProperties());
                properties.load(new BufferedInputStream(new FileInputStream((String)object)));
                System.setProperties(properties);
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            if (DEBUG) {
                System.out.println("\n");
                missingResourceException.printStackTrace();
            }
            KMSystem.cleanAll();
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getMessage());
            if (DEBUG) {
                System.out.println("\n");
                fileNotFoundException.printStackTrace();
            }
            KMSystem.cleanAll();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            if (DEBUG) {
                System.out.println("\n");
                iOException.printStackTrace();
            }
            KMSystem.cleanAll();
            System.exit(1);
        }
    }

    private static void loadGUIMsgResource() {
        guiRB = null;
        Locale locale = KMSystem.getLocale();
        try {
            guiRB = ResourceBundle.getBundle("ikmgui", locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            KMSystem.cleanAll();
            System.exit(1);
        }
    }

    public static String getNLSResString(String string) {
        String string2 = null;
        try {
            string2 = (String)guiRB.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        return string2;
    }

    public static int getMode(String[] stringArray) {
        if (stringArray[0].equalsIgnoreCase("-keydb")) {
            return 1;
        }
        if (stringArray[0].equalsIgnoreCase("-certreq")) {
            return 3;
        }
        if (stringArray[0].equalsIgnoreCase("-cert")) {
            return 2;
        }
        if (stringArray[0].equalsIgnoreCase("-version")) {
            return 22;
        }
        if (stringArray[0].equalsIgnoreCase("-help")) {
            return 21;
        }
        return -2;
    }

    public static int getDatabaseAction(String[] stringArray) {
        if (stringArray.length > 1) {
            if (stringArray[1].equalsIgnoreCase("-create")) {
                return 4;
            }
            if (stringArray[1].equalsIgnoreCase("-changepw")) {
                return 5;
            }
            if (stringArray[1].equalsIgnoreCase("-stashpw")) {
                return 6;
            }
            if (stringArray[1].equalsIgnoreCase("-convert")) {
                return 7;
            }
            if (stringArray[1].equalsIgnoreCase("-delete")) {
                return 8;
            }
            if (stringArray[1].equalsIgnoreCase("-list")) {
                return 30;
            }
            return -3;
        }
        return -24;
    }

    public static int getRequestAction(String[] stringArray) {
        if (stringArray.length > 1) {
            if (stringArray[1].equalsIgnoreCase("-create")) {
                return 24;
            }
            if (stringArray[1].equalsIgnoreCase("-recreate")) {
                return 9;
            }
            if (stringArray[1].equalsIgnoreCase("-list")) {
                return 27;
            }
            if (stringArray[1].equalsIgnoreCase("-details")) {
                return 28;
            }
            if (stringArray[1].equalsIgnoreCase("-extract")) {
                return 29;
            }
            if (stringArray[1].equalsIgnoreCase("-delete")) {
                return 26;
            }
            return -4;
        }
        return -25;
    }

    public static int getCertificateAction(String[] stringArray) {
        if (stringArray.length > 1) {
            if (stringArray[1].equalsIgnoreCase("-create")) {
                return 23;
            }
            if (stringArray[1].equalsIgnoreCase("-receive")) {
                return 15;
            }
            if (stringArray[1].equalsIgnoreCase("-sign")) {
                return 16;
            }
            if (stringArray[1].equalsIgnoreCase("-list")) {
                return 10;
            }
            if (stringArray[1].equalsIgnoreCase("-details")) {
                return 11;
            }
            if (stringArray[1].equalsIgnoreCase("-add")) {
                return 17;
            }
            if (stringArray[1].equalsIgnoreCase("-delete")) {
                return 25;
            }
            if (stringArray[1].equalsIgnoreCase("-modify")) {
                return 18;
            }
            if (stringArray[1].equalsIgnoreCase("-import")) {
                return 13;
            }
            if (stringArray[1].equalsIgnoreCase("-export")) {
                return 12;
            }
            if (stringArray[1].equalsIgnoreCase("-extract")) {
                return 14;
            }
            if (stringArray[1].equalsIgnoreCase("-setdefault")) {
                return 19;
            }
            if (stringArray[1].equalsIgnoreCase("-getdefault")) {
                return 20;
            }
            return -5;
        }
        return -26;
    }

    public static void callDatabaseAPI(CLIDatabaseInfo cLIDatabaseInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, IOException, KMException {
        switch (n) {
            case 4: {
                CLIDatabaseManager.keyDbCreate(cLIDatabaseInfo);
                break;
            }
            case 5: {
                CLIDatabaseManager.keyDbChangePw(cLIDatabaseInfo);
                break;
            }
            case 6: {
                CLIDatabaseManager.keyDbStashPw(cLIDatabaseInfo);
                break;
            }
            case 7: {
                CLIDatabaseManager.keyDbConvert(cLIDatabaseInfo);
                break;
            }
            case 8: {
                CLIDatabaseManager.keyDbDelete(cLIDatabaseInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callKeyStoreDatabaseAPI(CLIDatabaseInfo cLIDatabaseInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, IOException, KMException, Exception {
        switch (n) {
            case 4: {
                CLIKeyStoreManager.keyDbCreate(cLIDatabaseInfo);
                break;
            }
            case 5: {
                CLIKeyStoreManager.keyDbChangePw(cLIDatabaseInfo);
                break;
            }
            case 6: {
                CLIKeyStoreManager.keyDbStashPw(cLIDatabaseInfo);
                break;
            }
            case 7: {
                CLIKeyStoreManager.keyDbConvert(cLIDatabaseInfo);
                break;
            }
            case 8: {
                CLIKeyStoreManager.keyDbDelete(cLIDatabaseInfo);
                break;
            }
            case 30: {
                CLIKeyStoreManager.keyDblist();
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static CLIDatabaseInfo parseDatabaseList(String[] stringArray) {
        CLIDatabaseInfo cLIDatabaseInfo = new CLIDatabaseInfo();
        if (stringArray.length > 2) {
            cLIDatabaseInfo.rc = -7;
            return cLIDatabaseInfo;
        }
        cLIDatabaseInfo.message = "OK ";
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    public static void callCryptoDatabaseAPI(CLIDatabaseInfo cLIDatabaseInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, IOException, KMException, Exception {
        int n2 = 0;
        ikeycmd.debugMsg("callCryptoDatabaseAPI.enter");
        if (cLIDatabaseInfo.getName() == null) {
            cLIDatabaseInfo.setName(CLICryptoDatabaseManager.getCryptoModuleName());
        }
        if (cLIDatabaseInfo.getName() == null) {
            ikeycmd.displayHelp(null, -44);
        } else {
            n2 = cLIDatabaseInfo.getDbType() == 11 ? 2 : 1;
        }
        ikeycmd.debugMsg("callCryptoDatabaseAPI.cryptoType=" + n2);
        ikeycmd.debugMsg("\n");
        if (CLICryptoDatabaseManager.isCSPCrypto(cLIDatabaseInfo.getName())) {
            ikeycmd.displayHelp("-keydb", -48);
            return;
        }
        if (n == 5 && n2 == 2) {
            System.out.print(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            ikeycmd.displayHelp("-keydb -changepw", "JSSE", -47);
            return;
        }
        switch (n) {
            case 5: {
                CLICryptoDatabaseManager.keyDbChangePw(cLIDatabaseInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, -50);
            }
        }
    }

    public static void callCryptoCertificateRequestAPI(CLIRequestInfo cLIRequestInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
        int n2 = 0;
        ikeycmd.debugMsg("callCryptoCertificateRequestAPI.enter");
        if (cLIRequestInfo.cliDb.getName() == null) {
            cLIRequestInfo.cliDb.setName(CLICryptoDatabaseManager.getCryptoModuleName());
        }
        if (cLIRequestInfo.cliDb.getName() == null) {
            ikeycmd.displayHelp(null, -44);
        } else {
            n2 = cLIRequestInfo.cliDb.getDbType() == 11 ? 2 : 1;
        }
        ikeycmd.debugMsg("callCryptoCertificateRequestAPI.cryptoType=" + n2);
        ikeycmd.debugMsg("\n");
        if (CLICryptoDatabaseManager.isCSPCrypto(cLIRequestInfo.cliDb.getName())) {
            ikeycmd.displayHelp("-certreq", -48);
            return;
        }
        if (n == 29 && n2 == 2) {
            System.out.print(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
            ikeycmd.displayHelp("-certreq -extract", "JSSE", -47);
            return;
        }
        switch (n) {
            case 24: {
                CLICryptoRequestManager.create(cLIRequestInfo);
                break;
            }
            case 9: {
                CLICryptoRequestManager.recreate(cLIRequestInfo);
                break;
            }
            case 27: {
                CLICryptoRequestManager.list(cLIRequestInfo);
                break;
            }
            case 28: {
                if (!cLIRequestInfo.getShowOid()) {
                    CLICryptoRequestManager.details(cLIRequestInfo);
                    break;
                }
                CLICryptoRequestManager.moreDetails(cLIRequestInfo);
                break;
            }
            case 29: {
                CLICryptoRequestManager.extract(cLIRequestInfo);
                break;
            }
            case 26: {
                CLICryptoRequestManager.delete(cLIRequestInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callCryptoCertificateAPI(CLICertificateInfo cLICertificateInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
        int n2 = 0;
        ikeycmd.debugMsg("callCryptoCertificateAPI.enter");
        if (n == 13) {
            if (cLICertificateInfo.getTokenDriverName() == null) {
                cLICertificateInfo.setTokenDriverName(CLICryptoDatabaseManager.getCryptoModuleName());
            }
            if (cLICertificateInfo.getTokenDriverName() == null) {
                ikeycmd.displayHelp(null, -44);
            } else {
                n2 = cLICertificateInfo.getTokenType() == 11 ? 2 : 1;
            }
        } else {
            if (cLICertificateInfo.cliDb.getName() == null) {
                cLICertificateInfo.cliDb.setName(CLICryptoDatabaseManager.getCryptoModuleName());
            }
            if (cLICertificateInfo.cliDb.getName() == null) {
                ikeycmd.displayHelp(null, -44);
            } else {
                n2 = cLICertificateInfo.cliDb.getDbType() == 11 ? 2 : 1;
            }
        }
        ikeycmd.debugMsg("callCryptoCertificateAPI.cryptoType=" + n2);
        ikeycmd.debugMsg("\n");
        if (n == 13 && CLICryptoDatabaseManager.isCSPCrypto(cLICertificateInfo.getTokenDriverName()) || CLICryptoDatabaseManager.isCSPCrypto(cLICertificateInfo.cliDb.getName())) {
            if (cLICertificateInfo.cliDb.getPassword() != null) {
                ikeycmd.displayHelp("-pw", -42);
            }
            if (isTokenLabelFlagUsed) {
                ikeycmd.displayHelp("-tokenlabel", -42);
            }
            if (isSlotIDFlagUsed) {
                ikeycmd.displayHelp("-relativeSlotNumber", -42);
            }
            ikeycmd.callKeyStoreCertificateDatabaseAPI(cLICertificateInfo, n);
            return;
        }
        switch (n) {
            case 23: {
                CLICryptoCertificateManager.create(cLICertificateInfo);
                break;
            }
            case 15: {
                CLICryptoCertificateManager.receive(cLICertificateInfo);
                break;
            }
            case 16: {
                CLICryptoCertificateManager.sign(cLICertificateInfo);
                break;
            }
            case 10: {
                CLICryptoCertificateManager.list(cLICertificateInfo);
                break;
            }
            case 11: {
                if (!cLICertificateInfo.getShowOid()) {
                    CLICryptoCertificateManager.details(cLICertificateInfo);
                    break;
                }
                CLICryptoCertificateManager.moreDetails(cLICertificateInfo);
                break;
            }
            case 17: {
                CLICryptoCertificateManager.add(cLICertificateInfo);
                break;
            }
            case 25: {
                CLICryptoCertificateManager.delete(cLICertificateInfo);
                break;
            }
            case 18: {
                CLICryptoCertificateManager.modify(cLICertificateInfo);
                break;
            }
            case 13: {
                CLICryptoCertificateManager.importCert(cLICertificateInfo);
                break;
            }
            case 12: {
                CLICryptoCertificateManager.export(cLICertificateInfo);
                break;
            }
            case 14: {
                CLICryptoCertificateManager.extract(cLICertificateInfo);
                break;
            }
            case 19: {
                CLICryptoCertificateManager.setDefault(cLICertificateInfo);
                break;
            }
            case 20: {
                CLICryptoCertificateManager.getDefault(cLICertificateInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callRequestAPI(CLIRequestInfo cLIRequestInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException {
        switch (n) {
            case 24: {
                CLIRequestManager.create(cLIRequestInfo);
                break;
            }
            case 9: {
                CLIRequestManager.recreate(cLIRequestInfo);
                break;
            }
            case 27: {
                CLIRequestManager.list(cLIRequestInfo);
                break;
            }
            case 28: {
                if (!cLIRequestInfo.getShowOid()) {
                    CLIRequestManager.details(cLIRequestInfo);
                    break;
                }
                CLIRequestManager.moreDetails(cLIRequestInfo);
                break;
            }
            case 29: {
                CLIRequestManager.extract(cLIRequestInfo);
                break;
            }
            case 26: {
                CLIRequestManager.delete(cLIRequestInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callKeyStoreRequestDatabaseAPI(CLIRequestInfo cLIRequestInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException, Exception {
        switch (n) {
            case 24: {
                CLIKeyStoreRequestManager.create(cLIRequestInfo);
                break;
            }
            case 9: {
                CLIKeyStoreRequestManager.recreate(cLIRequestInfo);
                break;
            }
            case 27: {
                CLIKeyStoreRequestManager.list(cLIRequestInfo);
                break;
            }
            case 28: {
                if (!cLIRequestInfo.getShowOid()) {
                    CLIKeyStoreRequestManager.details(cLIRequestInfo);
                    break;
                }
                CLIKeyStoreRequestManager.moreDetails(cLIRequestInfo);
                break;
            }
            case 29: {
                CLIKeyStoreRequestManager.extract(cLIRequestInfo);
                break;
            }
            case 26: {
                CLIKeyStoreRequestManager.delete(cLIRequestInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callKeyStoreCertificateDatabaseAPI(CLICertificateInfo cLICertificateInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, KMException, Exception {
        switch (n) {
            case 23: {
                CLIKeyStoreCertificateManager.create(cLICertificateInfo);
                break;
            }
            case 15: {
                CLIKeyStoreCertificateManager.receive(cLICertificateInfo);
                break;
            }
            case 16: {
                CLIKeyStoreCertificateManager.sign(cLICertificateInfo);
                break;
            }
            case 10: {
                CLIKeyStoreCertificateManager.list(cLICertificateInfo);
                break;
            }
            case 11: {
                if (!cLICertificateInfo.getShowOid()) {
                    CLIKeyStoreCertificateManager.details(cLICertificateInfo);
                    break;
                }
                CLIKeyStoreCertificateManager.moreDetails(cLICertificateInfo);
                break;
            }
            case 17: {
                CLIKeyStoreCertificateManager.add(cLICertificateInfo);
                break;
            }
            case 25: {
                CLIKeyStoreCertificateManager.delete(cLICertificateInfo);
                break;
            }
            case 18: {
                CLIKeyStoreCertificateManager.modify(cLICertificateInfo);
                break;
            }
            case 13: {
                CLIKeyStoreCertificateManager.importCert(cLICertificateInfo);
                break;
            }
            case 12: {
                CLIKeyStoreCertificateManager.export(cLICertificateInfo);
                break;
            }
            case 14: {
                CLIKeyStoreCertificateManager.extract(cLICertificateInfo);
                break;
            }
            case 19: {
                CLIKeyStoreCertificateManager.setDefault(cLICertificateInfo);
                break;
            }
            case 20: {
                CLIKeyStoreCertificateManager.getDefault(cLICertificateInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void callCertificateAPI(CLICertificateInfo cLICertificateInfo, int n) throws KeyDatabaseException, KeyDatabaseOperatorNullException, Exception {
        switch (n) {
            case 23: {
                CLICertificateManager.create(cLICertificateInfo);
                break;
            }
            case 15: {
                CLICertificateManager.receive(cLICertificateInfo);
                break;
            }
            case 16: {
                CLICertificateManager.sign(cLICertificateInfo);
                break;
            }
            case 10: {
                CLICertificateManager.list(cLICertificateInfo);
                break;
            }
            case 11: {
                if (!cLICertificateInfo.getShowOid()) {
                    CLICertificateManager.details(cLICertificateInfo);
                    break;
                }
                CLICertificateManager.moreDetails(cLICertificateInfo);
                break;
            }
            case 17: {
                CLICertificateManager.add(cLICertificateInfo);
                break;
            }
            case 25: {
                CLICertificateManager.delete(cLICertificateInfo);
                break;
            }
            case 18: {
                CLICertificateManager.modify(cLICertificateInfo);
                break;
            }
            case 13: {
                CLICertificateManager.importCert(cLICertificateInfo);
                break;
            }
            case 12: {
                CLICertificateManager.export(cLICertificateInfo);
                break;
            }
            case 14: {
                CLICertificateManager.extract(cLICertificateInfo);
                break;
            }
            case 19: {
                CLICertificateManager.setDefault(cLICertificateInfo);
                break;
            }
            case 20: {
                CLICertificateManager.getDefault(cLICertificateInfo);
                break;
            }
            default: {
                ikeycmd.displayHelp(null, n);
            }
        }
    }

    public static void handleDatabaseTask(CLIDatabaseInfo cLIDatabaseInfo, int n) {
        block17: {
            String string = null;
            if (cLIDatabaseInfo.rc == 0) {
                try {
                    ikeycmd.debugMsg("handleDatabaseTask():: type=" + cLIDatabaseInfo.getDbType() + "\n");
                    ikeycmd.debugMsg("handleDatabaseTask():: request=" + n + "\n");
                    if (cLIDatabaseInfo.getDbType() == 10 || cLIDatabaseInfo.getDbType() == 11) {
                        ikeycmd.callCryptoDatabaseAPI(cLIDatabaseInfo, n);
                        break block17;
                    }
                    ikeycmd.callKeyStoreDatabaseAPI(cLIDatabaseInfo, n);
                }
                catch (KeyDatabaseException keyDatabaseException) {
                    string = keyDatabaseException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KeyDatabaseOperatorNullException keyDatabaseOperatorNullException) {
                    string = keyDatabaseOperatorNullException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseOperatorNullException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KMException kMException) {
                    string = kMException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        kMException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (IOException iOException) {
                    System.out.println(iOException.getMessage());
                    if (DEBUG) {
                        System.out.println("\n");
                        iOException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (DEBUG) {
                        System.out.println("\n");
                        exception.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
            } else {
                ikeycmd.displayHelp(cLIDatabaseInfo.message, cLIDatabaseInfo.rc);
            }
        }
    }

    public static void handleRequestTask(CLIRequestInfo cLIRequestInfo, int n) {
        block15: {
            String string = null;
            if (cLIRequestInfo.rc == 0) {
                try {
                    if (cLIRequestInfo.cliDb.getDbType() == 10 || cLIRequestInfo.cliDb.getDbType() == 11) {
                        ikeycmd.callCryptoCertificateRequestAPI(cLIRequestInfo, n);
                        break block15;
                    }
                    ikeycmd.callKeyStoreRequestDatabaseAPI(cLIRequestInfo, n);
                }
                catch (KeyDatabaseException keyDatabaseException) {
                    string = keyDatabaseException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KeyDatabaseOperatorNullException keyDatabaseOperatorNullException) {
                    string = keyDatabaseOperatorNullException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseOperatorNullException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KMException kMException) {
                    string = kMException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        kMException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (DEBUG) {
                        System.out.println("\n");
                        exception.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
            } else {
                ikeycmd.displayHelp(cLIRequestInfo.message, cLIRequestInfo.rc);
            }
        }
    }

    public static void handleCertificateTask(CLICertificateInfo cLICertificateInfo, int n) {
        block18: {
            String string = null;
            if (cLICertificateInfo.rc == 0) {
                try {
                    if (n == 13) {
                        if (cLICertificateInfo.getTokenType() == 10 || cLICertificateInfo.getTokenType() == 11) {
                            ikeycmd.callCryptoCertificateAPI(cLICertificateInfo, n);
                        } else {
                            ikeycmd.callKeyStoreCertificateDatabaseAPI(cLICertificateInfo, n);
                        }
                        break block18;
                    }
                    if (cLICertificateInfo.cliDb.getDbType() == 10 || cLICertificateInfo.cliDb.getDbType() == 11) {
                        ikeycmd.callCryptoCertificateAPI(cLICertificateInfo, n);
                        break block18;
                    }
                    ikeycmd.callKeyStoreCertificateDatabaseAPI(cLICertificateInfo, n);
                }
                catch (KeyDatabaseException keyDatabaseException) {
                    string = keyDatabaseException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KeyDatabaseOperatorNullException keyDatabaseOperatorNullException) {
                    string = keyDatabaseOperatorNullException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        keyDatabaseOperatorNullException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (KMException kMException) {
                    string = kMException.getNLSErrString();
                    if (string != null) {
                        System.out.println(string);
                    }
                    if (DEBUG) {
                        System.out.println("\n");
                        kMException.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    if (DEBUG) {
                        System.out.println("\n");
                        exception.printStackTrace();
                    }
                    KMSystem.cleanAll();
                    System.exit(1);
                }
            } else {
                ikeycmd.displayHelp(cLICertificateInfo.message, cLICertificateInfo.rc);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLIDatabaseInfo parseDatabaseCreate(String[] stringArray) {
        CLIDatabaseInfo cLIDatabaseInfo;
        block52: {
            boolean bl;
            block50: {
                block53: {
                    String string;
                    String string2;
                    int n;
                    block51: {
                        cLIDatabaseInfo = new CLIDatabaseInfo(4);
                        boolean bl2 = false;
                        bl = false;
                        String string3 = null;
                        n = 0;
                        if (stringArray.length > 11) {
                            cLIDatabaseInfo.rc = -7;
                            return cLIDatabaseInfo;
                        }
                        int n2 = 2;
                        while (n2 < stringArray.length) {
                            block49: {
                                if (stringArray[n2].equalsIgnoreCase("-db")) {
                                    if (stringArray.length > n2 + 1) {
                                        if ((string3 = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                            if (!KMSystem.isMSKeyStoreOS()) {
                                                ikeycmd.displayHelp(null, -49);
                                            } else {
                                                ikeycmd.displayHelp("-keydb -create", -48);
                                            }
                                        }
                                        n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string3);
                                        cLIDatabaseInfo.setName(string3);
                                    } else {
                                        ikeycmd.displayHelp(null, -18);
                                    }
                                } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                                    if (stringArray.length > n2 + 1) {
                                        bl = true;
                                        cLIDatabaseInfo.setPassword(stringArray[++n2]);
                                    } else {
                                        ikeycmd.displayHelp(null, -19);
                                    }
                                } else if (stringArray[n2].equalsIgnoreCase("-type")) {
                                    String string4 = "";
                                    if (stringArray.length > n2 + 1) {
                                        string4 = stringArray[++n2];
                                    } else {
                                        ikeycmd.displayHelp(null, -27);
                                    }
                                    bl2 = true;
                                    if (string4.equalsIgnoreCase("CMS") || string4.equalsIgnoreCase("kdb")) {
                                        cLIDatabaseInfo.setDbType(1);
                                    } else if (string4.equalsIgnoreCase("WEBDB") || string4.equalsIgnoreCase("kyr")) {
                                        ikeycmd.displayHelp(string4, -23);
                                    } else if (string4.equalsIgnoreCase("SSLight") || string4.equalsIgnoreCase("class")) {
                                        cLIDatabaseInfo.setDbType(3);
                                    } else if (string4.equalsIgnoreCase("JKS") || string4.equalsIgnoreCase("jks")) {
                                        cLIDatabaseInfo.setDbType(6);
                                    } else if (string4.equalsIgnoreCase("JCEKS") || string4.equalsIgnoreCase("jck")) {
                                        cLIDatabaseInfo.setDbType(7);
                                    } else {
                                        if (!string4.equalsIgnoreCase("PKCS12") && !string4.equalsIgnoreCase("p12")) {
                                            cLIDatabaseInfo.message = string4;
                                            cLIDatabaseInfo.rc = 4;
                                            return cLIDatabaseInfo;
                                        }
                                        cLIDatabaseInfo.setDbType(8);
                                    }
                                    if (n == 0) {
                                        n = cLIDatabaseInfo.getDbType();
                                    }
                                } else {
                                    if (stringArray[n2].equalsIgnoreCase("-expire")) {
                                        Object object;
                                        if (n != 0 && n != 1 && n != 5) {
                                            ikeycmd.displayHelp("-expire", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                                        }
                                        long l = 0L;
                                        if (stringArray.length > n2 + 1) {
                                            object = stringArray[++n2];
                                            try {
                                                l = Long.valueOf((String)object);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                ikeycmd.displayHelp((String)object, -9);
                                            }
                                        } else {
                                            ikeycmd.displayHelp(null, -28);
                                        }
                                        if (l > 0L && l <= 7300L) {
                                            object = new Date();
                                            long l2 = ((Date)object).getTime();
                                            l = l2 + l * 24L * 3600L * 1000L;
                                            cLIDatabaseInfo.setExpire(l);
                                            break block49;
                                        } else {
                                            cLIDatabaseInfo.message = "" + l;
                                            cLIDatabaseInfo.rc = -9;
                                            return cLIDatabaseInfo;
                                        }
                                    }
                                    if (!stringArray[n2].equalsIgnoreCase("-stash")) {
                                        cLIDatabaseInfo.message = stringArray[n2];
                                        cLIDatabaseInfo.rc = 4;
                                        return cLIDatabaseInfo;
                                    }
                                    if (n == 1 || n == 5) {
                                        cLIDatabaseInfo.setStash(true);
                                    } else {
                                        ikeycmd.displayHelp("-stash", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                                    }
                                }
                            }
                            ++n2;
                        }
                        string2 = System.getProperty("DEFAULT_CMS_PASSWORD_REQUIRED");
                        string = System.getProperty("DEFAULT_SSLIGHT_PASSWORD_REQUIRED");
                        if (string2 == null) {
                            string2 = KMSystem.getInitSetting("DEFAULT_CMS_PASSWORD_REQUIRED");
                        }
                        if (string == null) {
                            string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_PASSWORD_REQUIRED");
                        }
                        if (string2 == null) {
                            string2 = "true";
                        }
                        if (string == null) {
                            string = "true";
                        }
                        if (n != 1 && n != 3) break block50;
                        if (!string.equalsIgnoreCase("false") || n != 3) break block51;
                        if (bl) {
                            ikeycmd.displayHelp(null, -41);
                        }
                        break block52;
                    }
                    if ((!string2.equalsIgnoreCase("true") || n != 1) && (!string.equalsIgnoreCase("true") || n != 3)) break block53;
                    if (!bl && cLIDatabaseInfo.getPassword() == null) {
                        cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
                        if (cLIDatabaseInfo.getPassword() == null) {
                            ikeycmd.displayHelp(null, -19);
                        }
                    }
                    break block52;
                }
                if (!bl) {
                    cLIDatabaseInfo.setPassword("");
                }
                break block52;
            }
            if (!bl && cLIDatabaseInfo.getPassword() == null) {
                cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
            }
        }
        cLIDatabaseInfo.message = "OK " + cLIDatabaseInfo.message;
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    public static CLIDatabaseInfo parseDatabaseDelete(String[] stringArray) {
        Object object;
        boolean bl = false;
        CLIDatabaseInfo cLIDatabaseInfo = new CLIDatabaseInfo(8);
        String string = null;
        int n = 0;
        if (stringArray.length > 6) {
            cLIDatabaseInfo.rc = -7;
            return cLIDatabaseInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-keydb -delete", -48);
                        }
                    }
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                    cLIDatabaseInfo.setName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLIDatabaseInfo.getName()))).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIDatabaseInfo.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLIDatabaseInfo.message = stringArray[n2];
                cLIDatabaseInfo.rc = 8;
                return cLIDatabaseInfo;
            }
            ++n2;
        }
        try {
            object = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseDatabaseDelete()::Check for pwd: " + n + ".." + (String)object + "\n");
            int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
            ikeycmd.debugMsg("ikeycmd.parseDatabaseDelete()::After mapped into KS: " + n3 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n3, cLIDatabaseInfo.getName())) {
                if (!bl && cLIDatabaseInfo.getPassword() == null) {
                    cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIDatabaseInfo.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIDatabaseInfo.message = "OK ";
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    public static CLIDatabaseInfo parseDatabaseStashPw(String[] stringArray) {
        Object object;
        boolean bl = false;
        CLIDatabaseInfo cLIDatabaseInfo = new CLIDatabaseInfo(6);
        String string = null;
        int n = 0;
        if (stringArray.length > 6) {
            cLIDatabaseInfo.rc = -7;
            return cLIDatabaseInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-keydb -stashpw", -48);
                        }
                    }
                    if ((n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string)) == 1 || n == 3) {
                        n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                        cLIDatabaseInfo.setName(string);
                    } else {
                        ikeycmd.displayHelp("-stashpw", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                    }
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLIDatabaseInfo.getName()))).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIDatabaseInfo.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLIDatabaseInfo.message = stringArray[n2];
                cLIDatabaseInfo.rc = 6;
                return cLIDatabaseInfo;
            }
            ++n2;
        }
        try {
            object = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseDatabaseStashpw()::Check for pwd: " + n + ".." + (String)object + "\n");
            int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
            ikeycmd.debugMsg("ikeycmd.parseDatabaseStashpw()::After mapped into KS: " + n3 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n3, cLIDatabaseInfo.getName())) {
                if (!bl && cLIDatabaseInfo.getPassword() == null) {
                    cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                System.out.print(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DB_HANDLE"));
                System.out.print("\n");
                ikeycmd.displayHelp(null, -51);
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIDatabaseInfo.message = "OK ";
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLIDatabaseInfo parseDatabaseConvert(String[] stringArray) {
        CLIDatabaseInfo cLIDatabaseInfo;
        block36: {
            Object object;
            boolean bl = false;
            cLIDatabaseInfo = new CLIDatabaseInfo(7);
            String string = null;
            int n = 0;
            if (stringArray.length > 10) {
                cLIDatabaseInfo.rc = -7;
                return cLIDatabaseInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block35: {
                    block39: {
                        block42: {
                            block41: {
                                block40: {
                                    block38: {
                                        block37: {
                                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block37;
                                            if (stringArray.length > n2 + 1) {
                                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                                    if (!KMSystem.isMSKeyStoreOS()) {
                                                        ikeycmd.displayHelp(null, -49);
                                                    } else {
                                                        ikeycmd.displayHelp("-keydb -convert", -48);
                                                    }
                                                }
                                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                                cLIDatabaseInfo.setName(string);
                                            } else {
                                                ikeycmd.displayHelp(null, -18);
                                            }
                                            if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLIDatabaseInfo.getName()))).exists()) {
                                                ikeycmd.displayHelp(null, -46);
                                            }
                                            break block35;
                                        }
                                        if (!stringArray[n2].equalsIgnoreCase("-pw")) break block38;
                                        if (stringArray.length > n2 + 1) {
                                            bl = true;
                                            cLIDatabaseInfo.setPassword(stringArray[++n2]);
                                            break block35;
                                        } else {
                                            ikeycmd.displayHelp(null, -19);
                                        }
                                        break block35;
                                    }
                                    if (!stringArray[n2].equalsIgnoreCase("-old_format")) break block39;
                                    object = "";
                                    if (stringArray.length > n2 + 1) {
                                        object = stringArray[++n2];
                                    } else {
                                        ikeycmd.displayHelp(null, -30);
                                    }
                                    if (!((String)object).equalsIgnoreCase("CMS") && !((String)object).equalsIgnoreCase("kdb")) break block40;
                                    cLIDatabaseInfo.setDbType(1);
                                    break block35;
                                }
                                if (!((String)object).equalsIgnoreCase("WEBDB") && !((String)object).equalsIgnoreCase("kyr")) break block41;
                                cLIDatabaseInfo.setDbType(2);
                                break block35;
                            }
                            if (!((String)object).equalsIgnoreCase("SSLIGHT") && !((String)object).equalsIgnoreCase("class")) break block42;
                            cLIDatabaseInfo.setDbType(3);
                            break block35;
                        }
                        if (((String)object).equalsIgnoreCase("JKS") || ((String)object).equalsIgnoreCase("jks")) {
                            cLIDatabaseInfo.setDbType(6);
                            break block35;
                        } else if (((String)object).equalsIgnoreCase("JCEKS") || ((String)object).equalsIgnoreCase("jck")) {
                            cLIDatabaseInfo.setDbType(7);
                            break block35;
                        } else {
                            if (!((String)object).equalsIgnoreCase("PKCS12") && !((String)object).equalsIgnoreCase("p12")) {
                                cLIDatabaseInfo.message = object;
                                cLIDatabaseInfo.rc = -8;
                                return cLIDatabaseInfo;
                            }
                            cLIDatabaseInfo.setDbType(8);
                        }
                        break block35;
                    }
                    if (!stringArray[n2].equalsIgnoreCase("-new_format")) {
                        cLIDatabaseInfo.message = stringArray[n2];
                        cLIDatabaseInfo.rc = 7;
                        return cLIDatabaseInfo;
                    }
                    object = "";
                    if (stringArray.length > n2 + 1) {
                        object = stringArray[++n2];
                    } else {
                        ikeycmd.displayHelp(null, -31);
                    }
                    if (((String)object).equalsIgnoreCase("CMS") || ((String)object).equalsIgnoreCase("kdb")) {
                        cLIDatabaseInfo.setNewDbType(1);
                        cLIDatabaseInfo.setNewExtension("kdb");
                    } else if (((String)object).equalsIgnoreCase("WEBDB") || ((String)object).equalsIgnoreCase("kyr")) {
                        cLIDatabaseInfo.setNewDbType(2);
                        cLIDatabaseInfo.setNewExtension("kyr");
                    } else if (((String)object).equalsIgnoreCase("SSLIGHT") || ((String)object).equalsIgnoreCase("class")) {
                        cLIDatabaseInfo.setNewDbType(3);
                        cLIDatabaseInfo.setNewExtension("class");
                    } else if (((String)object).equalsIgnoreCase("JKS") || ((String)object).equalsIgnoreCase("jks")) {
                        cLIDatabaseInfo.setNewDbType(6);
                        cLIDatabaseInfo.setNewExtension("jks");
                    } else if (((String)object).equalsIgnoreCase("JCEKS") || ((String)object).equalsIgnoreCase("jck")) {
                        cLIDatabaseInfo.setNewDbType(7);
                        cLIDatabaseInfo.setNewExtension("jck");
                    } else {
                        if (!((String)object).equalsIgnoreCase("PKCS12") && !((String)object).equalsIgnoreCase("p12")) {
                            cLIDatabaseInfo.message = object;
                            cLIDatabaseInfo.rc = -8;
                            return cLIDatabaseInfo;
                        }
                        cLIDatabaseInfo.setNewDbType(8);
                        cLIDatabaseInfo.setNewExtension("p12");
                    }
                }
                ++n2;
            }
            try {
                object = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseDatabaseConvert()::Check for pwd: " + n + ".." + (String)object + "\n");
                int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
                ikeycmd.debugMsg("ikeycmd.parseDatabaseConvert()::After mapped into KS: " + n3 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n3, cLIDatabaseInfo.getName())) {
                    if (!bl && cLIDatabaseInfo.getPassword() == null) {
                        cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
                    }
                    break block36;
                }
                ikeycmd.displayHelp("", -51);
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLIDatabaseInfo.message = "OK ";
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLIDatabaseInfo parseDatabaseChangePw(String[] stringArray) {
        CLIDatabaseInfo cLIDatabaseInfo;
        boolean bl;
        block48: {
            boolean bl2 = false;
            bl = false;
            cLIDatabaseInfo = new CLIDatabaseInfo(5);
            String string = null;
            int n = 0;
            if (stringArray.length > 11) {
                cLIDatabaseInfo.rc = -7;
                return cLIDatabaseInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block47: {
                    block50: {
                        block49: {
                            File file;
                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block49;
                            if (stringArray.length > n2 + 1) {
                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                    if (!KMSystem.isMSKeyStoreOS()) {
                                        ikeycmd.displayHelp(null, -49);
                                    } else {
                                        ikeycmd.displayHelp("-keydb -changepw", -48);
                                    }
                                }
                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                cLIDatabaseInfo.setName(string);
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIDatabaseInfo.getName())).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block47;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block50;
                        if (stringArray.length > n2 + 1) {
                            cLIDatabaseInfo.setDbType(10);
                            String string2 = stringArray[++n2];
                            if (!string2.startsWith("-")) {
                                cLIDatabaseInfo.setName(string2);
                                break block47;
                            } else {
                                --n2;
                            }
                            break block47;
                        } else {
                            ikeycmd.displayHelp(null, -44);
                        }
                        break block47;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                        if (stringArray.length > n2 + 1) {
                            cLIDatabaseInfo.setTokenLabel(stringArray[++n2]);
                            isTokenLabelFlagUsed = true;
                            cLIDatabaseInfo.setDbType(10);
                        } else {
                            ikeycmd.displayHelp("-tokenlabel", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                        if (stringArray.length > n2 + 1) {
                            String string3 = stringArray[++n2];
                            try {
                                int n3 = Integer.valueOf(string3);
                                cLIDatabaseInfo.setSlotID(n3);
                                isSlotIDFlagUsed = true;
                                cLIDatabaseInfo.setDbType(11);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string3, -9);
                            }
                        } else {
                            ikeycmd.displayHelp("-relativeSlotNumber", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            bl2 = true;
                            cLIDatabaseInfo.setPassword(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-new_pw")) {
                        if (stringArray.length > n2 + 1) {
                            bl = true;
                            cLIDatabaseInfo.setNewPassword(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -29);
                        }
                    } else {
                        if (stringArray[n2].equalsIgnoreCase("-expire")) {
                            Object object;
                            if (n != 1 && n != 5) {
                                ikeycmd.displayHelp("-expire", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                            }
                            long l = 0L;
                            if (stringArray.length > n2 + 1) {
                                object = stringArray[++n2];
                                try {
                                    l = Long.valueOf((String)object);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ikeycmd.displayHelp((String)object, -9);
                                }
                            } else {
                                ikeycmd.displayHelp(null, -28);
                            }
                            if (l > 0L && l <= 7300L) {
                                object = new Date();
                                long l2 = ((Date)object).getTime();
                                l = l2 + l * 24L * 3600L * 1000L;
                                cLIDatabaseInfo.setExpire(l);
                                break block47;
                            } else {
                                cLIDatabaseInfo.message = "" + l;
                                cLIDatabaseInfo.rc = -9;
                                return cLIDatabaseInfo;
                            }
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-stash")) {
                            cLIDatabaseInfo.message = stringArray[n2];
                            cLIDatabaseInfo.rc = 5;
                            return cLIDatabaseInfo;
                        }
                        if (n == 1 || n == 5) {
                            cLIDatabaseInfo.setStash(true);
                        } else {
                            ikeycmd.displayHelp("-stash", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                        }
                    }
                }
                ++n2;
            }
            try {
                String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseDatabaseChangepw()::Check for pwd: " + n + ".." + string4 + "\n");
                int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
                ikeycmd.debugMsg("ikeycmd.parseDatabaseChangepw()::After mapped into KS: " + n4 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n4, cLIDatabaseInfo.getName())) {
                    if (!bl2 && cLIDatabaseInfo.getPassword() == null) {
                        cLIDatabaseInfo.setPassword(ikeycmd.promptForPassword());
                    }
                    break block48;
                }
                if (bl2) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIDatabaseInfo.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        if (!bl) {
            cLIDatabaseInfo.setNewPassword(ikeycmd.promptForNewPassword());
        }
        cLIDatabaseInfo.message = "OK ";
        cLIDatabaseInfo.rc = 0;
        return cLIDatabaseInfo;
    }

    public static CLIRequestInfo parseRequestDelete(String[] stringArray) {
        boolean bl = false;
        CLIRequestInfo cLIRequestInfo = new CLIRequestInfo(26);
        String string = null;
        int n = 0;
        if (stringArray.length > 10) {
            cLIRequestInfo.rc = -7;
            return cLIRequestInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-certreq -delete", -48);
                        }
                    }
                    cLIRequestInfo.cliDb.setName(string);
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIRequestInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLIRequestInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLIRequestInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLIRequestInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                        cLIRequestInfo.cliDb.setDbType(11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setLabel(stringArray[++n2]);
                    if (cLIRequestInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLIRequestInfo.message = stringArray[n2];
                cLIRequestInfo.rc = 26;
                return cLIRequestInfo;
            }
            ++n2;
        }
        try {
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseRequestDelete()::Check for pwd: " + n + ".." + string4 + "\n");
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseRequestDelete()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLIRequestInfo.cliDb.getName())) {
                if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                    cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    public static CLIRequestInfo parseRequestDetails(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        CLIRequestInfo cLIRequestInfo = new CLIRequestInfo(28);
        String string = null;
        int n = 0;
        if (stringArray.length > 11) {
            cLIRequestInfo.rc = -7;
            return cLIRequestInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-certreq -details", -48);
                        }
                    }
                    cLIRequestInfo.cliDb.setName(string);
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIRequestInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLIRequestInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLIRequestInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLIRequestInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                        cLIRequestInfo.cliDb.setDbType(11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setLabel(stringArray[++n2]);
                    if (cLIRequestInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-showoid")) {
                bl2 = true;
                cLIRequestInfo.setShowOid(bl2);
            } else {
                cLIRequestInfo.message = stringArray[n2];
                cLIRequestInfo.rc = 28;
                return cLIRequestInfo;
            }
            ++n2;
        }
        try {
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseRequestDetails()::Check for pwd: " + n + ".." + string4 + "\n");
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseRequestDetails()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLIRequestInfo.cliDb.getName())) {
                if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                    cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    public static CLIRequestInfo parseRequestExtract(String[] stringArray) {
        boolean bl = false;
        CLIRequestInfo cLIRequestInfo = new CLIRequestInfo(29);
        String string = null;
        int n = 0;
        if (stringArray.length > 12) {
            cLIRequestInfo.rc = -7;
            return cLIRequestInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-certreq -extract", -48);
                        }
                    }
                    cLIRequestInfo.cliDb.setName(string);
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIRequestInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLIRequestInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLIRequestInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLIRequestInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setLabel(stringArray[++n2]);
                    if (cLIRequestInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-target")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setExtractTarget(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -20);
                }
                if (cLIRequestInfo.getExtractTarget().equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                    ikeycmd.displayHelp(null, -49);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLIRequestInfo.message = stringArray[n2];
                cLIRequestInfo.rc = 29;
                return cLIRequestInfo;
            }
            ++n2;
        }
        try {
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseRequestExtract()::Check for pwd: " + n + ".." + string4 + "\n");
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseRequestExtract()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLIRequestInfo.cliDb.getName())) {
                if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                    cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    public static CLIRequestInfo parseRequestList(String[] stringArray) {
        boolean bl = false;
        CLIRequestInfo cLIRequestInfo = new CLIRequestInfo(27);
        String string = null;
        int n = 0;
        if (stringArray.length > 8) {
            cLIRequestInfo.rc = -7;
            return cLIRequestInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-certreq -list", -48);
                        }
                    }
                    cLIRequestInfo.cliDb.setName(string);
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIRequestInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLIRequestInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else if (stringArray.length == n2 + 1) {
                    cLIRequestInfo.cliDb.setDbType(10);
                    ikeycmd.debugMsg("ikeycmd.parseRequestList.arg==i " + (n2 + 1));
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLIRequestInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLIRequestInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                        cLIRequestInfo.cliDb.setDbType(11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    bl = true;
                    cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLIRequestInfo.message = stringArray[n2];
                cLIRequestInfo.rc = 27;
                return cLIRequestInfo;
            }
            ++n2;
        }
        ikeycmd.debugMsg("ikeycmd.parseRequestList.end for==");
        try {
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseRequestList()::Check for pwd: " + n + ".." + string4 + "\n");
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseRequestList()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLIRequestInfo.cliDb.getName())) {
                if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                    cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    public static CLIRequestInfo parseRequestRecreate(String[] stringArray) {
        Object object;
        boolean bl = false;
        CLIRequestInfo cLIRequestInfo = new CLIRequestInfo(9);
        String string = null;
        int n = 0;
        if (stringArray.length > 10) {
            cLIRequestInfo.rc = -7;
            return cLIRequestInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-target")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setExtractTarget(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -20);
                }
                if (cLIRequestInfo.getExtractTarget().equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                    ikeycmd.displayHelp(null, -49);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-db")) {
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-certreq -recreate", -48);
                        }
                    }
                    cLIRequestInfo.cliDb.setName(string);
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLIRequestInfo.cliDb.getName()))).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                    bl = true;
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLIRequestInfo.setLabel(stringArray[++n2]);
                    if (cLIRequestInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else {
                cLIRequestInfo.message = stringArray[n2];
                cLIRequestInfo.rc = 9;
                return cLIRequestInfo;
            }
            ++n2;
        }
        try {
            object = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseRequestRecreate()::Check for pwd: " + n + ".." + (String)object + "\n");
            int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
            ikeycmd.debugMsg("ikeycmd.parseRequestRecreate()::After mapped into KS: " + n3 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n3, cLIRequestInfo.cliDb.getName())) {
                if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                    cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLIRequestInfo parseRequestCreate(String[] stringArray) {
        CLIRequestInfo cLIRequestInfo;
        block52: {
            boolean bl = false;
            cLIRequestInfo = new CLIRequestInfo(24);
            String string = null;
            int n = 0;
            if (stringArray.length > 16) {
                cLIRequestInfo.rc = -7;
                return cLIRequestInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block51: {
                    String string2;
                    block54: {
                        block53: {
                            File file;
                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block53;
                            if (stringArray.length > n2 + 1) {
                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                    if (!KMSystem.isMSKeyStoreOS()) {
                                        ikeycmd.displayHelp(null, -49);
                                    } else {
                                        ikeycmd.displayHelp("-certreq -create", -48);
                                    }
                                }
                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                cLIRequestInfo.cliDb.setName(string);
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLIRequestInfo.cliDb.getName())).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block51;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block54;
                        if (stringArray.length > n2 + 1) {
                            cLIRequestInfo.cliDb.setDbType(10);
                            String string3 = stringArray[++n2];
                            if (!string3.startsWith("-")) {
                                cLIRequestInfo.cliDb.setName(string3);
                                break block51;
                            } else {
                                --n2;
                            }
                            break block51;
                        } else {
                            ikeycmd.displayHelp(null, -44);
                        }
                        break block51;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                        if (stringArray.length > n2 + 1) {
                            cLIRequestInfo.cliDb.setTokenLabel(stringArray[++n2]);
                            isTokenLabelFlagUsed = true;
                            cLIRequestInfo.cliDb.setDbType(10);
                        } else {
                            ikeycmd.displayHelp("-tokenlabel", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                        if (stringArray.length > n2 + 1) {
                            string2 = stringArray[++n2];
                            try {
                                int n3 = Integer.valueOf(string2);
                                cLIRequestInfo.cliDb.setSlotID(n3);
                                isSlotIDFlagUsed = true;
                                cLIRequestInfo.cliDb.setDbType(11);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string2, -9);
                            }
                        } else {
                            ikeycmd.displayHelp("-relativeSlotNumber", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            cLIRequestInfo.cliDb.setPassword(stringArray[++n2]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-size")) {
                        int n4 = 0;
                        if (stringArray.length > n2 + 1) {
                            string2 = new String(stringArray[++n2]);
                            try {
                                n4 = Integer.parseInt(string2);
                            }
                            catch (Exception exception) {
                                ikeycmd.displayHelp(string2, -10);
                            }
                        } else {
                            ikeycmd.displayHelp(null, -32);
                        }
                        if (n4 != 1024 && n4 != 512) {
                            cLIRequestInfo.message = n4 + " Is not a valid key size";
                            cLIRequestInfo.rc = -10;
                            return cLIRequestInfo;
                        }
                        cLIRequestInfo.setKeySize(n4);
                    } else if (stringArray[n2].equalsIgnoreCase("-dn")) {
                        if (stringArray.length <= n2 + 1) {
                            ikeycmd.displayHelp(null, -16);
                        }
                        if (!ikeycmd.parseDN(stringArray[++n2], cLIRequestInfo, 24)) {
                            return cLIRequestInfo;
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-file")) {
                        if (stringArray.length > n2 + 1) {
                            String string4;
                            if (!(string4 = stringArray[++n2]).endsWith(KeyStoreManager.DEFAULT_BASE64_FILE_NAME_EXT) && string4.indexOf(46) == -1) {
                                string4 = string4 + KeyStoreManager.DEFAULT_BASE64_FILE_NAME_EXT;
                            }
                            cLIRequestInfo.setFileName(string4);
                        } else {
                            ikeycmd.displayHelp(null, -22);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-label")) {
                            cLIRequestInfo.message = stringArray[n2];
                            cLIRequestInfo.rc = 24;
                            return cLIRequestInfo;
                        }
                        if (stringArray.length > n2 + 1) {
                            cLIRequestInfo.setLabel(stringArray[++n2]);
                            if (cLIRequestInfo.getLabel().length() == 0) {
                                ikeycmd.displayHelp(null, -39);
                            }
                        } else {
                            ikeycmd.displayHelp(null, -21);
                        }
                    }
                }
                ++n2;
            }
            try {
                String string5 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseRequestCreate()::Check for pwd: " + n + ".." + string5 + "\n");
                int n5 = KeyStoreManager.getDbTypeFromKeyStore(string5);
                ikeycmd.debugMsg("ikeycmd.parseRequestCreate()::After mapped into KS: " + n5 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n5, cLIRequestInfo.cliDb.getName())) {
                    if (!bl && cLIRequestInfo.cliDb.getPassword() == null) {
                        cLIRequestInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block52;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLIRequestInfo.cliDb.setPassword("");
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_ADD_PRIKEY_CERTREQ"));
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLIRequestInfo.message = "OK ";
        cLIRequestInfo.rc = 0;
        return cLIRequestInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateAdd(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block52: {
            int n;
            String string = null;
            int n2 = 0;
            if (DEBUG) {
                System.out.println("In parseCertificateAdd");
            }
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(17);
            if (stringArray.length > 14) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            if (DEBUG) {
                System.out.println("Command line for add:");
                n = 0;
                while (n < stringArray.length) {
                    System.out.println(stringArray[n]);
                    ++n;
                }
            }
            n = 2;
            while (n < stringArray.length) {
                block51: {
                    block57: {
                        block56: {
                            block55: {
                                block54: {
                                    block53: {
                                        File file;
                                        if (!stringArray[n].equalsIgnoreCase("-db")) break block53;
                                        if (stringArray.length > n + 1) {
                                            if ((string = stringArray[++n]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                ikeycmd.displayHelp(null, -49);
                                            }
                                            n2 = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                            cLICertificateInfo.cliDb.setName(string);
                                        } else {
                                            ikeycmd.displayHelp(null, -18);
                                        }
                                        if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                            ikeycmd.displayHelp(null, -46);
                                        }
                                        break block51;
                                    }
                                    if (!stringArray[n].equalsIgnoreCase("-crypto")) break block54;
                                    if (stringArray.length > n + 1) {
                                        cLICertificateInfo.cliDb.setDbType(10);
                                        String string2 = stringArray[++n];
                                        if (!string2.startsWith("-")) {
                                            cLICertificateInfo.cliDb.setName(string2);
                                            break block51;
                                        } else {
                                            --n;
                                        }
                                        break block51;
                                    } else {
                                        ikeycmd.displayHelp(null, -44);
                                    }
                                    break block51;
                                }
                                if (!stringArray[n].equalsIgnoreCase("-tokenlabel")) break block55;
                                if (stringArray.length > n + 1) {
                                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n]);
                                    isTokenLabelFlagUsed = true;
                                    cLICertificateInfo.cliDb.setDbType(10);
                                    break block51;
                                } else {
                                    ikeycmd.displayHelp("-tokenlabel", -45);
                                }
                                break block51;
                            }
                            if (!stringArray[n].equalsIgnoreCase("-relativeSlotNumber")) break block56;
                            if (stringArray.length > n + 1) {
                                String string3 = stringArray[++n];
                                try {
                                    int n3 = Integer.valueOf(string3);
                                    cLICertificateInfo.cliDb.setSlotID(n3);
                                    isSlotIDFlagUsed = true;
                                    cLICertificateInfo.cliDb.setDbType(11);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ikeycmd.displayHelp(string3, -9);
                                }
                                break block51;
                            } else {
                                ikeycmd.displayHelp("-relativeSlotNumber", -45);
                            }
                            break block51;
                        }
                        if (!stringArray[n].equalsIgnoreCase("-label")) break block57;
                        if (stringArray.length > n + 1) {
                            cLICertificateInfo.setLabel(stringArray[++n]);
                            if (cLICertificateInfo.getLabel().length() == 0) {
                                ikeycmd.displayHelp(null, -39);
                            }
                            break block51;
                        } else {
                            ikeycmd.displayHelp(null, -21);
                        }
                        break block51;
                    }
                    if (stringArray[n].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n + 1) {
                            if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                ikeycmd.displayHelp(null, -41);
                            }
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n].equalsIgnoreCase("-format")) {
                        String string4 = "";
                        if (stringArray.length > n + 1) {
                            string4 = stringArray[++n];
                        } else {
                            ikeycmd.displayHelp(null, -35);
                        }
                        if (string4.equalsIgnoreCase("ascii")) {
                            cLICertificateInfo.setFormat(true);
                        } else {
                            if (!string4.equalsIgnoreCase("binary")) {
                                cLICertificateInfo.message = string4;
                                cLICertificateInfo.rc = -8;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setFormat(false);
                        }
                    } else if (stringArray[n].equalsIgnoreCase("-trust")) {
                        if (n2 != 1 && n2 != 5) {
                            ikeycmd.displayHelp("-trust", CLIKeyStoreManager.convertMapToKeyStore(n2), -47);
                        }
                        String string5 = "";
                        if (stringArray.length > n + 1) {
                            string5 = stringArray[++n];
                        } else {
                            ikeycmd.displayHelp(null, -36);
                        }
                        if (string5.equalsIgnoreCase("enable")) {
                            cLICertificateInfo.setTrust(true);
                        } else {
                            if (!string5.equalsIgnoreCase("disable")) {
                                cLICertificateInfo.message = string5;
                                cLICertificateInfo.rc = -13;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setTrust(false);
                        }
                    } else {
                        if (!stringArray[n].equalsIgnoreCase("-file")) {
                            cLICertificateInfo.message = stringArray[n];
                            cLICertificateInfo.rc = 17;
                            return cLICertificateInfo;
                        }
                        if (stringArray.length > n + 1) {
                            cLICertificateInfo.setFileName(stringArray[++n]);
                        } else {
                            ikeycmd.displayHelp(null, -22);
                        }
                        File file = new File(cLICertificateInfo.getFileName());
                        if (!file.exists()) {
                            ikeycmd.displayHelp(null, -46);
                        }
                    }
                }
                ++n;
            }
            try {
                String string6 = CLIKeyStoreManager.convertMapToKeyStore(n2);
                ikeycmd.debugMsg("ikeycmd.parseCertificateAdd()::Check for pwd: " + n2 + ".." + string6 + "\n");
                int n4 = KeyStoreManager.getDbTypeFromKeyStore(string6);
                ikeycmd.debugMsg("ikeycmd.parseCertificateAdd()::After mapped into KS: " + n4 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block52;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateCreate(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block56: {
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(23);
            String string = null;
            int n = 0;
            if (stringArray.length > 20) {
                System.out.println("CERT_CREATE_MAX_ARGS=20, args.length=" + stringArray.length);
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block55: {
                    block65: {
                        block64: {
                            block63: {
                                block62: {
                                    String string2;
                                    block61: {
                                        block60: {
                                            block59: {
                                                block58: {
                                                    block57: {
                                                        File file;
                                                        if (!stringArray[n2].equalsIgnoreCase("-db")) break block57;
                                                        if (stringArray.length > n2 + 1) {
                                                            if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                                ikeycmd.displayHelp(null, -49);
                                                            }
                                                            n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                                            cLICertificateInfo.cliDb.setName(string);
                                                        } else {
                                                            ikeycmd.displayHelp(null, -18);
                                                        }
                                                        if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                                            ikeycmd.displayHelp(null, -46);
                                                        }
                                                        break block55;
                                                    }
                                                    if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block58;
                                                    if (stringArray.length > n2 + 1) {
                                                        cLICertificateInfo.cliDb.setDbType(10);
                                                        String string3 = stringArray[++n2];
                                                        if (!string3.startsWith("-")) {
                                                            cLICertificateInfo.cliDb.setName(string3);
                                                            break block55;
                                                        } else {
                                                            --n2;
                                                        }
                                                        break block55;
                                                    } else {
                                                        ikeycmd.displayHelp(null, -44);
                                                    }
                                                    break block55;
                                                }
                                                if (!stringArray[n2].equalsIgnoreCase("-tokenlabel")) break block59;
                                                if (stringArray.length > n2 + 1) {
                                                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                                                    isTokenLabelFlagUsed = true;
                                                    cLICertificateInfo.cliDb.setDbType(10);
                                                    break block55;
                                                } else {
                                                    ikeycmd.displayHelp("-tokenlabel", -45);
                                                }
                                                break block55;
                                            }
                                            if (!stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) break block60;
                                            if (stringArray.length > n2 + 1) {
                                                string2 = stringArray[++n2];
                                                try {
                                                    int n3 = Integer.valueOf(string2);
                                                    cLICertificateInfo.cliDb.setSlotID(n3);
                                                    isSlotIDFlagUsed = true;
                                                    cLICertificateInfo.cliDb.setDbType(11);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    ikeycmd.displayHelp(string2, -9);
                                                }
                                                break block55;
                                            } else {
                                                ikeycmd.displayHelp("-relativeSlotNumber", -45);
                                            }
                                            break block55;
                                        }
                                        if (!stringArray[n2].equalsIgnoreCase("-pw")) break block61;
                                        if (stringArray.length > n2 + 1) {
                                            if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                                ikeycmd.displayHelp(null, -41);
                                            }
                                            cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                                            bl = true;
                                            break block55;
                                        } else {
                                            ikeycmd.displayHelp(null, -19);
                                        }
                                        break block55;
                                    }
                                    if (!stringArray[n2].equalsIgnoreCase("-size")) break block62;
                                    int n4 = 0;
                                    if (stringArray.length > n2 + 1) {
                                        string2 = new String(stringArray[++n2]);
                                        try {
                                            n4 = Integer.parseInt(string2);
                                        }
                                        catch (Exception exception) {
                                            ikeycmd.displayHelp(string2, -10);
                                        }
                                    } else {
                                        ikeycmd.displayHelp(null, -32);
                                    }
                                    if (n4 != 1024 && n4 != 512) {
                                        cLICertificateInfo.message = "" + n4;
                                        cLICertificateInfo.rc = -10;
                                        return cLICertificateInfo;
                                    }
                                    cLICertificateInfo.setKeySize(n4);
                                    break block55;
                                }
                                if (!stringArray[n2].equalsIgnoreCase("-dn")) break block63;
                                if (stringArray.length <= n2 + 1) {
                                    ikeycmd.displayHelp(null, -16);
                                }
                                if (!ikeycmd.parseDN(stringArray[++n2], cLICertificateInfo, 23)) {
                                    return cLICertificateInfo;
                                }
                                break block55;
                            }
                            if (!stringArray[n2].equalsIgnoreCase("-label")) break block64;
                            if (stringArray.length > n2 + 1) {
                                cLICertificateInfo.setLabel(stringArray[++n2]);
                                if (cLICertificateInfo.getLabel().length() == 0) {
                                    ikeycmd.displayHelp(null, -39);
                                }
                                break block55;
                            } else {
                                ikeycmd.displayHelp(null, -21);
                            }
                            break block55;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-x509version")) break block65;
                        int n5 = 0;
                        if (stringArray.length > n2 + 1) {
                            n5 = Integer.valueOf(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -33);
                        }
                        switch (n5) {
                            case 1: {
                                cLICertificateInfo.setVersion(1);
                                break block55;
                            }
                            case 2: {
                                cLICertificateInfo.setVersion(2);
                                break block55;
                            }
                            case 3: {
                                cLICertificateInfo.setVersion(3);
                                break block55;
                            }
                            default: {
                                cLICertificateInfo.message = "" + n5;
                                cLICertificateInfo.rc = -17;
                                return cLICertificateInfo;
                            }
                        }
                    }
                    if (stringArray[n2].equalsIgnoreCase("-default_cert")) {
                        if (n != 1 && n != 5) {
                            ikeycmd.displayHelp("-default_cert", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                        }
                        String string4 = "";
                        if (stringArray.length > n2 + 1) {
                            string4 = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -34);
                        }
                        if (string4.equalsIgnoreCase("yes")) {
                            cLICertificateInfo.setDefault(true);
                        } else {
                            if (!string4.equalsIgnoreCase("no")) {
                                cLICertificateInfo.message = "" + string4;
                                cLICertificateInfo.rc = -6;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setDefault(false);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-expire")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 23;
                            return cLICertificateInfo;
                        }
                        long l = 0L;
                        if (stringArray.length > n2 + 1) {
                            String string5 = stringArray[++n2];
                            try {
                                l = Long.valueOf(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string5, -9);
                            }
                        } else {
                            ikeycmd.displayHelp(null, -28);
                        }
                        if (l <= 0L) {
                            cLICertificateInfo.message = "" + l;
                            cLICertificateInfo.rc = -9;
                            return cLICertificateInfo;
                        }
                        cLICertificateInfo.setExpire(l);
                    }
                }
                ++n2;
            }
            try {
                String string6 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateCreate()::Check for pwd: " + n + ".." + string6 + "\n");
                int n6 = KeyStoreManager.getDbTypeFromKeyStore(string6);
                ikeycmd.debugMsg("ikeycmd.parseCertificateCreate()::After mapped into KS: " + n6 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n6, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block56;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_ADD_PRIKEY_ON_NOPWDDB"));
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    private static boolean parseDN(String string, CLIRequestInfo cLIRequestInfo, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            while (stringArray[n2].endsWith("\\") && stringTokenizer.hasMoreTokens()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(stringArray[n2]);
                stringBuffer.setCharAt(stringBuffer.length() - 1, ',');
                stringBuffer.append(stringTokenizer.nextToken());
                stringArray[n2] = stringBuffer.toString();
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n2) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[n3], "=");
            String string2 = stringTokenizer2.nextToken().trim();
            if (string2.equalsIgnoreCase("CN")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setCommonName(stringTokenizer2.nextToken().trim());
                    bl = true;
                }
            } else if (string2.equalsIgnoreCase("O")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setOrg(stringTokenizer2.nextToken().trim());
                    bl2 = true;
                }
            } else if (string2.equalsIgnoreCase("OU")) {
                if (!bl4) {
                    bl4 = true;
                    if (stringTokenizer2.hasMoreTokens()) {
                        cLIRequestInfo.dn.setOrgUnit(stringTokenizer2.nextToken().trim());
                    }
                }
            } else if (string2.equalsIgnoreCase("L")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setLocality(stringTokenizer2.nextToken().trim());
                }
            } else if (string2.equalsIgnoreCase("ST")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setState(stringTokenizer2.nextToken().trim());
                }
            } else if (string2.equalsIgnoreCase("C")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setCountry(stringTokenizer2.nextToken().trim());
                    bl3 = true;
                }
            } else if (string2.equalsIgnoreCase("ZIP")) {
                if (stringTokenizer2.hasMoreTokens()) {
                    cLIRequestInfo.dn.setZipCode(stringTokenizer2.nextToken().trim());
                }
            } else {
                cLIRequestInfo.message = string2;
                cLIRequestInfo.rc = n;
                return false;
            }
            ++n3;
        }
        if (!(bl && bl2 && bl3)) {
            cLIRequestInfo.message = "-dn";
            cLIRequestInfo.rc = -16;
            return false;
        }
        return true;
    }

    public static CLICertificateInfo parseCertificateDelete(String[] stringArray) {
        boolean bl = false;
        CLICertificateInfo cLICertificateInfo = new CLICertificateInfo(25);
        String string = null;
        int n = 0;
        if (stringArray.length > 10) {
            cLICertificateInfo.rc = -7;
            return cLICertificateInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                        ikeycmd.displayHelp(null, -49);
                    }
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                    cLICertificateInfo.cliDb.setName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLICertificateInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLICertificateInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLICertificateInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                        cLICertificateInfo.cliDb.setDbType(11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.setLabel(stringArray[++n2]);
                    if (cLICertificateInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                        ikeycmd.displayHelp(null, -41);
                    }
                    bl = true;
                    cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLICertificateInfo.message = stringArray[n2];
                cLICertificateInfo.rc = 25;
                return cLICertificateInfo;
            }
            ++n2;
        }
        try {
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseCertificateDelete()::Check for pwd: " + n + ".." + string4 + "\n");
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseCertificateDelete()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                    cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    public static CLICertificateInfo parseCertificateDetails(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        CLICertificateInfo cLICertificateInfo = new CLICertificateInfo(11);
        String string = null;
        int n = 0;
        if (stringArray.length > 11) {
            cLICertificateInfo.rc = -7;
            return cLICertificateInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                File file;
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                        ikeycmd.displayHelp(null, -49);
                    }
                    n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                    cLICertificateInfo.cliDb.setName(string);
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-crypto")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setDbType(10);
                    String string2 = stringArray[++n2];
                    if (!string2.startsWith("-")) {
                        cLICertificateInfo.cliDb.setName(string2);
                    } else {
                        --n2;
                    }
                } else {
                    ikeycmd.displayHelp(null, -44);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                    isTokenLabelFlagUsed = true;
                    cLICertificateInfo.cliDb.setDbType(10);
                } else {
                    ikeycmd.displayHelp("-tokenlabel", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                if (stringArray.length > n2 + 1) {
                    String string3 = stringArray[++n2];
                    try {
                        int n3 = Integer.valueOf(string3);
                        cLICertificateInfo.cliDb.setSlotID(n3);
                        isSlotIDFlagUsed = true;
                        cLICertificateInfo.cliDb.setDbType(11);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ikeycmd.displayHelp(string3, -9);
                    }
                } else {
                    ikeycmd.displayHelp("-relativeSlotNumber", -45);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.setLabel(stringArray[++n2]);
                    if (cLICertificateInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                        ikeycmd.displayHelp(null, -41);
                    }
                    cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                    bl = true;
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-showoid")) {
                bl2 = true;
                cLICertificateInfo.setShowOid(bl2);
            } else {
                cLICertificateInfo.message = stringArray[n2];
                cLICertificateInfo.rc = 11;
                return cLICertificateInfo;
            }
            ++n2;
        }
        try {
            n = cLICertificateInfo.cliDb.getDbType();
            String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseCertificateDetails()::Check for pwd: " + n + ".." + string4 + "\n");
            if (n != 11 && (n == 1 || n == 10 || cLICertificateInfo.cliDb.getName().equalsIgnoreCase("MSCertificateStore")) && KMSystem.isJNIEnabled() && !KeyStoreManager.loadCMSNoJavaOnlyProvider()) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE"));
            }
            KeyStoreManager.getSupportedCLIDatabaseTypes();
            int n4 = KeyStoreManager.getDbTypeFromKeyStore(string4);
            ikeycmd.debugMsg("ikeycmd.parseCertificateDetails()::After mapped into KS: " + n4 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                    cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    public static CLICertificateInfo parseCertificateSetDefault(String[] stringArray) {
        Object object;
        boolean bl = false;
        CLICertificateInfo cLICertificateInfo = new CLICertificateInfo(19);
        String string = null;
        int n = 0;
        if (stringArray.length > 8) {
            cLICertificateInfo.rc = -7;
            return cLICertificateInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-cert -setdefault", -48);
                        }
                    }
                    if ((n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string)) == 1 || n == 5) {
                        cLICertificateInfo.cliDb.setName(string);
                    } else {
                        ikeycmd.displayHelp("-setdefault", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                    }
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLICertificateInfo.cliDb.getName()))).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-label")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.setLabel(stringArray[++n2]);
                    if (cLICertificateInfo.getLabel().length() == 0) {
                        ikeycmd.displayHelp(null, -39);
                    }
                } else {
                    ikeycmd.displayHelp(null, -21);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                    bl = true;
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLICertificateInfo.message = stringArray[n2];
                cLICertificateInfo.rc = 19;
                return cLICertificateInfo;
            }
            ++n2;
        }
        try {
            object = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseCertificateSetDefault()::Check for pwd: " + n + ".." + (String)object + "\n");
            int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
            ikeycmd.debugMsg("ikeycmd.parseCertificateSetDefault()::After mapped into KS: " + n3 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n3, cLICertificateInfo.cliDb.getName())) {
                if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                    cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateExport(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block54: {
            Object object;
            boolean bl;
            block53: {
                boolean bl2 = false;
                bl = false;
                String string = null;
                int n = 0;
                cLICertificateInfo = new CLICertificateInfo(12);
                if (stringArray.length > 18) {
                    cLICertificateInfo.rc = -7;
                    return cLICertificateInfo;
                }
                int n2 = 2;
                while (n2 < stringArray.length) {
                    block52: {
                        block64: {
                            block67: {
                                block66: {
                                    block65: {
                                        block60: {
                                            block63: {
                                                block62: {
                                                    block61: {
                                                        block59: {
                                                            block58: {
                                                                block57: {
                                                                    block56: {
                                                                        block55: {
                                                                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block55;
                                                                            if (stringArray.length > n2 + 1) {
                                                                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                                                    ikeycmd.displayHelp(null, -49);
                                                                                }
                                                                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                                                                cLICertificateInfo.cliDb.setName(string);
                                                                            } else {
                                                                                ikeycmd.displayHelp(null, -18);
                                                                            }
                                                                            ikeycmd.debugMsg("ikeycmd.parseCertExport.KeyDbFileName: " + string);
                                                                            if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLICertificateInfo.cliDb.getName()))).exists()) {
                                                                                ikeycmd.displayHelp(null, -46);
                                                                            }
                                                                            break block52;
                                                                        }
                                                                        if (!stringArray[n2].equalsIgnoreCase("-label")) break block56;
                                                                        if (stringArray.length > n2 + 1) {
                                                                            cLICertificateInfo.setLabel(stringArray[++n2]);
                                                                            if (cLICertificateInfo.getLabel().length() == 0) {
                                                                                ikeycmd.displayHelp(null, -39);
                                                                            }
                                                                            break block52;
                                                                        } else {
                                                                            ikeycmd.displayHelp(null, -21);
                                                                        }
                                                                        break block52;
                                                                    }
                                                                    if (!stringArray[n2].equalsIgnoreCase("-pw")) break block57;
                                                                    if (stringArray.length > n2 + 1) {
                                                                        if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                                                            ikeycmd.displayHelp(null, -41);
                                                                        }
                                                                        cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                                                                        bl2 = true;
                                                                        break block52;
                                                                    } else {
                                                                        ikeycmd.displayHelp(null, -19);
                                                                    }
                                                                    break block52;
                                                                }
                                                                if (!stringArray[n2].equalsIgnoreCase("-target")) break block58;
                                                                if (stringArray.length > n2 + 1) {
                                                                    cLICertificateInfo.setTargetDb(stringArray[++n2]);
                                                                    cLICertificateInfo.setTargetDbType(CLIKeyStoreManager.getKeyDatabaseTypeByName(stringArray[n2]));
                                                                } else {
                                                                    ikeycmd.displayHelp(null, -20);
                                                                }
                                                                if (cLICertificateInfo.getTargetDb().equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                                    ikeycmd.displayHelp(null, -49);
                                                                }
                                                                break block52;
                                                            }
                                                            if (!stringArray[n2].equalsIgnoreCase("-target_pw")) break block59;
                                                            if (stringArray.length > n2 + 1) {
                                                                cLICertificateInfo.setTargetPassword(stringArray[++n2]);
                                                                bl = true;
                                                                break block52;
                                                            } else {
                                                                ikeycmd.displayHelp(null, -37);
                                                            }
                                                            break block52;
                                                        }
                                                        if (!stringArray[n2].equalsIgnoreCase("-target_type")) break block60;
                                                        object = "";
                                                        if (stringArray.length > n2 + 1) {
                                                            object = stringArray[++n2];
                                                        } else {
                                                            ikeycmd.displayHelp(null, -27);
                                                        }
                                                        if (!((String)object).equalsIgnoreCase("CMS") && !((String)object).equalsIgnoreCase("kdb")) break block61;
                                                        cLICertificateInfo.setTargetDbType(1);
                                                        break block52;
                                                    }
                                                    if (!((String)object).equalsIgnoreCase("WEBDB") && !((String)object).equalsIgnoreCase("kyr")) break block62;
                                                    ikeycmd.displayHelp((String)object, -23);
                                                    break block52;
                                                }
                                                if (!((String)object).equalsIgnoreCase("SSLight") && !((String)object).equalsIgnoreCase("class")) break block63;
                                                cLICertificateInfo.setTargetDbType(3);
                                                break block52;
                                            }
                                            if (((String)object).equalsIgnoreCase("jks") || ((String)object).equalsIgnoreCase("JKS")) {
                                                cLICertificateInfo.setTargetDbType(6);
                                                break block52;
                                            } else if (((String)object).equalsIgnoreCase("jck") || ((String)object).equalsIgnoreCase("JCEKS")) {
                                                cLICertificateInfo.setTargetDbType(7);
                                                break block52;
                                            } else {
                                                if (!((String)object).equalsIgnoreCase("PKCS12") && !((String)object).equalsIgnoreCase("p12")) {
                                                    cLICertificateInfo.message = object;
                                                    cLICertificateInfo.rc = -8;
                                                    return cLICertificateInfo;
                                                }
                                                cLICertificateInfo.setTargetDbType(8);
                                            }
                                            break block52;
                                        }
                                        if (!stringArray[n2].equalsIgnoreCase("-type")) break block64;
                                        object = "";
                                        if (stringArray.length > n2 + 1) {
                                            object = stringArray[++n2];
                                        } else {
                                            ikeycmd.displayHelp(null, -27);
                                        }
                                        if (!((String)object).equalsIgnoreCase("CMS") && !((String)object).equalsIgnoreCase("kdb")) break block65;
                                        cLICertificateInfo.cliDb.setDbType(1);
                                        break block52;
                                    }
                                    if (!((String)object).equalsIgnoreCase("WEBDB") && !((String)object).equalsIgnoreCase("kyr")) break block66;
                                    ikeycmd.displayHelp((String)object, -23);
                                    break block52;
                                }
                                if (!((String)object).equalsIgnoreCase("SSLight") && !((String)object).equalsIgnoreCase("class")) break block67;
                                cLICertificateInfo.cliDb.setDbType(3);
                                break block52;
                            }
                            if (((String)object).equalsIgnoreCase("JKS") || ((String)object).equalsIgnoreCase("jks")) {
                                cLICertificateInfo.cliDb.setDbType(6);
                                break block52;
                            } else if (((String)object).equalsIgnoreCase("JCEKS") || ((String)object).equalsIgnoreCase("jck")) {
                                cLICertificateInfo.cliDb.setDbType(7);
                                break block52;
                            } else {
                                if (!((String)object).equalsIgnoreCase("PKCS12") && !((String)object).equalsIgnoreCase("p12")) {
                                    cLICertificateInfo.message = object;
                                    cLICertificateInfo.rc = -8;
                                    return cLICertificateInfo;
                                }
                                cLICertificateInfo.cliDb.setDbType(8);
                            }
                            break block52;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-encryption")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 12;
                            return cLICertificateInfo;
                        }
                        object = "";
                        if (stringArray.length > n2 + 1) {
                            object = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -38);
                        }
                        if (((String)object).equalsIgnoreCase("strong")) {
                            cLICertificateInfo.setEncryption(0);
                        } else {
                            if (!((String)object).equalsIgnoreCase("weak")) {
                                cLICertificateInfo.message = object;
                                cLICertificateInfo.rc = -15;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setEncryption(1);
                        }
                    }
                    ++n2;
                }
                try {
                    object = CLIKeyStoreManager.convertMapToKeyStore(n);
                    ikeycmd.debugMsg("ikeycmd.parseCertificateExport()::Check for pwd: " + n + ".." + (String)object + "\n");
                    int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
                    ikeycmd.debugMsg("ikeycmd.parseCertificateExport()::After mapped into KS: " + n3 + "\n");
                    if (KeyStoreManager.isPasswordNeeded(n3, cLICertificateInfo.cliDb.getName())) {
                        if (!bl2 && cLICertificateInfo.cliDb.getPassword() == null) {
                            cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                        }
                        break block53;
                    }
                    if (bl2) {
                        ikeycmd.displayHelp("-pw", -42);
                    }
                    cLICertificateInfo.cliDb.setPassword("");
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_ADD_PRIKEY_CERTREQ"));
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    // empty catch block
                }
            }
            try {
                int n;
                if (cLICertificateInfo.getTargetDb().endsWith("p12")) {
                    if (!bl && cLICertificateInfo.getTargetPassword() == null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_PROMPT_NEWPW"));
                        cLICertificateInfo.setTargetPassword(ikeycmd.promptForPassword());
                    }
                    break block54;
                }
                if (!cLICertificateInfo.getTargetDb().equalsIgnoreCase("MSCertificateStore")) {
                    object = new File(cLICertificateInfo.getTargetDb());
                    if (!((File)object).exists()) {
                        ikeycmd.displayHelp(null, -46);
                    }
                } else {
                    ikeycmd.displayHelp("-target", -48);
                }
                if ((n = KeyDatabase.getKeyDatabaseTypeByName(cLICertificateInfo.getTargetDb())) != 1 && n != 3) break block54;
                if (!KeyDatabase.isPasswordNeeded(n, cLICertificateInfo.getTargetDb())) {
                    if (bl) {
                        ikeycmd.displayHelp(null, -43);
                    }
                    cLICertificateInfo.setTargetPassword("");
                    break block54;
                }
                if (!bl && cLICertificateInfo.getTargetPassword() == null) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_PROMPT_NEWPW"));
                    cLICertificateInfo.setTargetPassword(ikeycmd.promptForPassword());
                }
            }
            catch (KeyDatabaseException keyDatabaseException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateExtract(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block41: {
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(14);
            String string = null;
            int n = 0;
            if (stringArray.length > 14) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block40: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        File file;
                                        if (!stringArray[n2].equalsIgnoreCase("-db")) break block42;
                                        if (stringArray.length > n2 + 1) {
                                            if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                ikeycmd.displayHelp(null, -49);
                                            }
                                            n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                            cLICertificateInfo.cliDb.setName(string);
                                        } else {
                                            ikeycmd.displayHelp(null, -18);
                                        }
                                        if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                            ikeycmd.displayHelp(null, -46);
                                        }
                                        break block40;
                                    }
                                    if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block43;
                                    if (stringArray.length > n2 + 1) {
                                        cLICertificateInfo.cliDb.setDbType(10);
                                        String string2 = stringArray[++n2];
                                        if (!string2.startsWith("-")) {
                                            cLICertificateInfo.cliDb.setName(string2);
                                            break block40;
                                        } else {
                                            --n2;
                                        }
                                        break block40;
                                    } else {
                                        ikeycmd.displayHelp(null, -44);
                                    }
                                    break block40;
                                }
                                if (!stringArray[n2].equalsIgnoreCase("-tokenlabel")) break block44;
                                if (stringArray.length > n2 + 1) {
                                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                                    isTokenLabelFlagUsed = true;
                                    cLICertificateInfo.cliDb.setDbType(10);
                                    break block40;
                                } else {
                                    ikeycmd.displayHelp("-tokenlabel", -45);
                                }
                                break block40;
                            }
                            if (!stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) break block45;
                            if (stringArray.length > n2 + 1) {
                                String string3 = stringArray[++n2];
                                try {
                                    int n3 = Integer.valueOf(string3);
                                    cLICertificateInfo.cliDb.setSlotID(n3);
                                    isSlotIDFlagUsed = true;
                                    cLICertificateInfo.cliDb.setDbType(11);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    ikeycmd.displayHelp(string3, -9);
                                }
                                break block40;
                            } else {
                                ikeycmd.displayHelp("-relativeSlotNumber", -45);
                            }
                            break block40;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-label")) break block46;
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setLabel(stringArray[++n2]);
                            if (cLICertificateInfo.getLabel().length() == 0) {
                                ikeycmd.displayHelp(null, -39);
                            }
                            break block40;
                        } else {
                            ikeycmd.displayHelp(null, -21);
                        }
                        break block40;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                ikeycmd.displayHelp(null, -41);
                            }
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-target")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setExtractTarget(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -20);
                        }
                        if (cLICertificateInfo.getExtractTarget().equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-format")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 14;
                            return cLICertificateInfo;
                        }
                        String string4 = "";
                        if (stringArray.length > n2 + 1) {
                            string4 = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -35);
                        }
                        if (string4.equalsIgnoreCase("ascii")) {
                            cLICertificateInfo.setFormat(true);
                        } else {
                            if (!string4.equalsIgnoreCase("binary")) {
                                cLICertificateInfo.message = string4;
                                cLICertificateInfo.rc = -8;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setFormat(false);
                        }
                    }
                }
                ++n2;
            }
            try {
                String string5 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateExtract()::Check for pwd: " + n + ".." + string5 + "\n");
                int n4 = KeyStoreManager.getDbTypeFromKeyStore(string5);
                ikeycmd.debugMsg("ikeycmd.parseCertificateExtract()::After mapped into KS: " + n4 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block41;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    public static CLICertificateInfo parseCertificateGetDefault(String[] stringArray) {
        Object object;
        boolean bl = false;
        CLICertificateInfo cLICertificateInfo = new CLICertificateInfo(20);
        String string = null;
        int n = 0;
        if (stringArray.length > 6) {
            cLICertificateInfo.rc = -7;
            return cLICertificateInfo;
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equalsIgnoreCase("-db")) {
                if (stringArray.length > n2 + 1) {
                    if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                        if (!KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        } else {
                            ikeycmd.displayHelp("-cert -getdefault", -48);
                        }
                    }
                    if ((n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string)) == 1 || n == 5) {
                        cLICertificateInfo.cliDb.setName(string);
                    } else {
                        ikeycmd.displayHelp("-getdefault", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                    }
                } else {
                    ikeycmd.displayHelp(null, -18);
                }
                if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLICertificateInfo.cliDb.getName()))).exists()) {
                    ikeycmd.displayHelp(null, -46);
                }
            } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                if (stringArray.length > n2 + 1) {
                    cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                    bl = true;
                } else {
                    ikeycmd.displayHelp(null, -19);
                }
            } else {
                cLICertificateInfo.message = stringArray[n2];
                cLICertificateInfo.rc = 20;
                return cLICertificateInfo;
            }
            ++n2;
        }
        try {
            object = CLIKeyStoreManager.convertMapToKeyStore(n);
            ikeycmd.debugMsg("ikeycmd.parseCertificateGetDefault()::Check for pwd: " + n + ".." + (String)object + "\n");
            int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
            ikeycmd.debugMsg("ikeycmd.parseCertificateGetDefault()::After mapped into KS: " + n3 + "\n");
            if (KeyStoreManager.isPasswordNeeded(n3, cLICertificateInfo.cliDb.getName())) {
                if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                    cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                }
            } else {
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            // empty catch block
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateImport(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block83: {
            boolean bl;
            boolean bl2;
            block82: {
                bl2 = false;
                boolean bl3 = false;
                bl = false;
                cLICertificateInfo = new CLICertificateInfo(13);
                String string = null;
                int n = 0;
                if (stringArray.length > 20) {
                    cLICertificateInfo.rc = -7;
                    return cLICertificateInfo;
                }
                int n2 = 2;
                while (n2 < stringArray.length) {
                    block81: {
                        block95: {
                            String string2;
                            block98: {
                                block97: {
                                    block96: {
                                        block94: {
                                            block93: {
                                                block92: {
                                                    block91: {
                                                        block90: {
                                                            block89: {
                                                                block88: {
                                                                    block87: {
                                                                        block86: {
                                                                            block85: {
                                                                                block84: {
                                                                                    if (!stringArray[n2].equalsIgnoreCase("-db") && !stringArray[n2].equalsIgnoreCase("-file")) break block84;
                                                                                    if (stringArray.length > n2 + 1) {
                                                                                        if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                                                                            ikeycmd.displayHelp(null, -49);
                                                                                        }
                                                                                        n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                                                                        cLICertificateInfo.cliDb.setName(string);
                                                                                        if (stringArray[n2 - 1].equalsIgnoreCase("-file")) {
                                                                                            cLICertificateInfo.cliDb.setDbType(8);
                                                                                            n = 8;
                                                                                        }
                                                                                    } else {
                                                                                        ikeycmd.displayHelp(null, -18);
                                                                                    }
                                                                                    if (!string.equalsIgnoreCase("MSCertificateStore")) {
                                                                                        File file = new File(cLICertificateInfo.cliDb.getName());
                                                                                        if (!file.exists()) {
                                                                                            ikeycmd.displayHelp(null, -46);
                                                                                        }
                                                                                        break block81;
                                                                                    } else {
                                                                                        ikeycmd.displayHelp("-db " + string, -48);
                                                                                    }
                                                                                    break block81;
                                                                                }
                                                                                if (!stringArray[n2].equalsIgnoreCase("-label")) break block85;
                                                                                if (stringArray.length > n2 + 1) {
                                                                                    cLICertificateInfo.setLabel(stringArray[++n2]);
                                                                                    if (cLICertificateInfo.getLabel().length() == 0) {
                                                                                        ikeycmd.displayHelp(null, -39);
                                                                                    }
                                                                                    break block81;
                                                                                } else {
                                                                                    ikeycmd.displayHelp(null, -21);
                                                                                }
                                                                                break block81;
                                                                            }
                                                                            if (!stringArray[n2].equalsIgnoreCase("-new_label")) break block86;
                                                                            if (stringArray.length > n2 + 1) {
                                                                                cLICertificateInfo.cliDb.setNewLabel(stringArray[++n2]);
                                                                                if (cLICertificateInfo.cliDb.getNewLabel().length() == 0) {
                                                                                    ikeycmd.displayHelp("<label>", -45);
                                                                                }
                                                                                break block81;
                                                                            } else {
                                                                                ikeycmd.displayHelp("-new_label", -45);
                                                                            }
                                                                            break block81;
                                                                        }
                                                                        if (!stringArray[n2].equalsIgnoreCase("-pw")) break block87;
                                                                        if (stringArray.length > n2 + 1) {
                                                                            if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                                                                ikeycmd.displayHelp(null, -41);
                                                                            }
                                                                            bl3 = true;
                                                                            if (!bl2) {
                                                                                cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                                                                                break block81;
                                                                            } else {
                                                                                cLICertificateInfo.setPasswordForToken(stringArray[++n2]);
                                                                                bl2 = false;
                                                                            }
                                                                            break block81;
                                                                        } else {
                                                                            ikeycmd.displayHelp(null, -19);
                                                                        }
                                                                        break block81;
                                                                    }
                                                                    if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block88;
                                                                    bl2 = true;
                                                                    if (stringArray.length > n2 + 1) {
                                                                        cLICertificateInfo.setTokenType(10);
                                                                        String string3 = null;
                                                                        string3 = stringArray[++n2];
                                                                        if (!string3.startsWith("-")) {
                                                                            cLICertificateInfo.setTokenDriverName(string3);
                                                                            break block81;
                                                                        } else {
                                                                            --n2;
                                                                        }
                                                                        break block81;
                                                                    } else {
                                                                        ikeycmd.displayHelp(null, -44);
                                                                    }
                                                                    break block81;
                                                                }
                                                                if (!stringArray[n2].equalsIgnoreCase("-tokenlabel")) break block89;
                                                                if (stringArray.length > n2 + 1) {
                                                                    cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                                                                    isTokenLabelFlagUsed = true;
                                                                    cLICertificateInfo.setTokenType(10);
                                                                    break block81;
                                                                } else {
                                                                    ikeycmd.displayHelp("-tokenlabel", -45);
                                                                }
                                                                break block81;
                                                            }
                                                            if (!stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) break block90;
                                                            if (stringArray.length > n2 + 1) {
                                                                String string4 = stringArray[++n2];
                                                                try {
                                                                    int n3 = Integer.valueOf(string4);
                                                                    cLICertificateInfo.cliDb.setSlotID(n3);
                                                                    isSlotIDFlagUsed = true;
                                                                    cLICertificateInfo.setTokenType(11);
                                                                }
                                                                catch (NumberFormatException numberFormatException) {
                                                                    ikeycmd.displayHelp(string4, -9);
                                                                }
                                                                break block81;
                                                            } else {
                                                                ikeycmd.displayHelp("-relativeSlotNumber", -45);
                                                            }
                                                            break block81;
                                                        }
                                                        if (!stringArray[n2].equalsIgnoreCase("-secondarydb")) break block91;
                                                        if (stringArray.length > n2 + 1) {
                                                            cLICertificateInfo.setSecondDBName(stringArray[++n2]);
                                                        } else {
                                                            ikeycmd.displayHelp(null, -18);
                                                        }
                                                        File file = new File(cLICertificateInfo.getSecondDBName());
                                                        if (!file.exists()) {
                                                            ikeycmd.displayHelp(null, -46);
                                                        }
                                                        break block81;
                                                    }
                                                    if (!stringArray[n2].equalsIgnoreCase("-secondarydbpw")) break block92;
                                                    if (stringArray.length > n2 + 1) {
                                                        cLICertificateInfo.setSecondDBPswd(stringArray[++n2]);
                                                        break block81;
                                                    } else {
                                                        ikeycmd.displayHelp(null, -19);
                                                    }
                                                    break block81;
                                                }
                                                if (!stringArray[n2].equalsIgnoreCase("-target")) break block93;
                                                if (stringArray.length > n2 + 1) {
                                                    cLICertificateInfo.setTargetDb(stringArray[++n2]);
                                                    cLICertificateInfo.setTargetDbType(CLIKeyStoreManager.getKeyDatabaseTypeByName(stringArray[n2]));
                                                } else {
                                                    ikeycmd.displayHelp(null, -20);
                                                }
                                                if (cLICertificateInfo.getTargetDb().equalsIgnoreCase("MSCertificateStore")) {
                                                    if (!KMSystem.isMSKeyStoreOS()) {
                                                        ikeycmd.displayHelp(null, -49);
                                                    }
                                                    break block81;
                                                } else {
                                                    File file = new File(cLICertificateInfo.getTargetDb());
                                                    if (!file.exists()) {
                                                        ikeycmd.displayHelp(null, -46);
                                                    }
                                                }
                                                break block81;
                                            }
                                            if (!stringArray[n2].equalsIgnoreCase("-target_pw")) break block94;
                                            if (stringArray.length > n2 + 1) {
                                                cLICertificateInfo.setTargetPassword(stringArray[++n2]);
                                                bl = true;
                                                break block81;
                                            } else {
                                                ikeycmd.displayHelp(null, -37);
                                            }
                                            break block81;
                                        }
                                        if (!stringArray[n2].equalsIgnoreCase("-type")) break block95;
                                        string2 = "";
                                        if (stringArray.length > n2 + 1) {
                                            string2 = stringArray[++n2];
                                        } else {
                                            ikeycmd.displayHelp(null, -27);
                                        }
                                        if (!string2.equalsIgnoreCase("CMS") && !string2.equalsIgnoreCase("kdb")) break block96;
                                        cLICertificateInfo.cliDb.setDbType(1);
                                        break block81;
                                    }
                                    if (!string2.equalsIgnoreCase("WEBDB") && !string2.equalsIgnoreCase("kyr")) break block97;
                                    ikeycmd.displayHelp(string2, -23);
                                    break block81;
                                }
                                if (!string2.equalsIgnoreCase("SSLight") && !string2.equalsIgnoreCase("class")) break block98;
                                cLICertificateInfo.cliDb.setDbType(3);
                                break block81;
                            }
                            if (string2.equalsIgnoreCase("JKS") || string2.equalsIgnoreCase("jks")) {
                                cLICertificateInfo.cliDb.setDbType(6);
                                break block81;
                            } else if (string2.equalsIgnoreCase("JCEKS") || string2.equalsIgnoreCase("jck")) {
                                cLICertificateInfo.cliDb.setDbType(7);
                                break block81;
                            } else {
                                if (!string2.equalsIgnoreCase("PKCS12") && !string2.equalsIgnoreCase("p12")) {
                                    cLICertificateInfo.message = string2;
                                    cLICertificateInfo.rc = -8;
                                    return cLICertificateInfo;
                                }
                                cLICertificateInfo.cliDb.setDbType(8);
                                n = 8;
                            }
                            break block81;
                        }
                        if (stringArray[n2].equalsIgnoreCase("-pfx")) {
                            cLICertificateInfo.cliDb.setPfx(true);
                        } else {
                            if (!stringArray[n2].equalsIgnoreCase("-target_type")) {
                                cLICertificateInfo.message = stringArray[n2];
                                cLICertificateInfo.rc = 13;
                                return cLICertificateInfo;
                            }
                            String string5 = "";
                            if (stringArray.length > n2 + 1) {
                                string5 = stringArray[++n2];
                            } else {
                                ikeycmd.displayHelp(null, -27);
                            }
                            if (string5.equalsIgnoreCase("kdb") || string5.equalsIgnoreCase("CMS")) {
                                cLICertificateInfo.setTargetDbType(1);
                            } else if (string5.equalsIgnoreCase("kyr") || string5.equalsIgnoreCase("WEBDB")) {
                                ikeycmd.displayHelp(string5, -23);
                            } else if (string5.equalsIgnoreCase("SSLight") || string5.equalsIgnoreCase("class")) {
                                cLICertificateInfo.setTargetDbType(3);
                            } else if (string5.equalsIgnoreCase("JKS") || string5.equalsIgnoreCase("jks")) {
                                cLICertificateInfo.setTargetDbType(6);
                            } else if (string5.equalsIgnoreCase("JCEKS") || string5.equalsIgnoreCase("jck")) {
                                cLICertificateInfo.setTargetDbType(7);
                            } else {
                                if (!string5.equalsIgnoreCase("PKCS12") && !string5.equalsIgnoreCase("p12")) {
                                    cLICertificateInfo.message = string5;
                                    cLICertificateInfo.rc = -11;
                                    return cLICertificateInfo;
                                }
                                cLICertificateInfo.setTargetDbType(8);
                            }
                        }
                    }
                    ++n2;
                }
                try {
                    if (n != 8 && cLICertificateInfo.getLabel() == null) {
                        ikeycmd.displayHelp(null, -21);
                    }
                    if (n != 8 && cLICertificateInfo.cliDb.getPfx()) {
                        ikeycmd.displayHelp("-pfx", "non-PKCS12", -47);
                    }
                    if (n == 8 && cLICertificateInfo.cliDb.getPfx() && cLICertificateInfo.getLabel() != null) {
                        ikeycmd.displayHelp("-pfx", "a labelled import of a ", -47);
                    }
                    if (cLICertificateInfo.getLabel() == null && cLICertificateInfo.cliDb.getNewLabel() != null) {
                        ikeycmd.displayHelp("-label", -45);
                    }
                    String string6 = CLIKeyStoreManager.convertMapToKeyStore(n);
                    ikeycmd.debugMsg("ikeycmd.parseCertificateImport()::Check for pwd: " + n + ".." + string6 + "\n");
                    int n4 = KeyStoreManager.getDbTypeFromKeyStore(string6);
                    ikeycmd.debugMsg("ikeycmd.parseCertificateImport()::After mapped into KS: " + n4 + "\n");
                    if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                        if (!bl3 && cLICertificateInfo.cliDb.getPassword() == null) {
                            cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                        }
                        break block82;
                    }
                    if (bl3) {
                        ikeycmd.displayHelp("-pw", -42);
                    }
                    cLICertificateInfo.cliDb.setPassword("");
                }
                catch (KeyStoreManagerException keyStoreManagerException) {
                    // empty catch block
                }
            }
            if (!bl2) {
                try {
                    int n = KeyDatabase.getKeyDatabaseTypeByName(cLICertificateInfo.getTargetDb());
                    if (n != 1 && n != 3) break block83;
                    if (!KeyDatabase.isPasswordNeeded(n, cLICertificateInfo.getTargetDb())) {
                        if (bl) {
                            ikeycmd.displayHelp(null, -43);
                        }
                        cLICertificateInfo.setTargetPassword("");
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_ADD_PRIKEY_ON_NOPWDDB"));
                        break block83;
                    }
                    if (!bl && cLICertificateInfo.getTargetPassword() == null) {
                        System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_PROMPT_NEWPW"));
                        cLICertificateInfo.setTargetPassword(ikeycmd.promptForPassword());
                    }
                }
                catch (KeyDatabaseException keyDatabaseException) {
                    // empty catch block
                }
            }
        }
        cLICertificateInfo.message = "OK";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateModify(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block31: {
            Object object;
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(18);
            String string = null;
            int n = 0;
            if (stringArray.length > 10) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block30: {
                    block33: {
                        block32: {
                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block32;
                            if (stringArray.length > n2 + 1) {
                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                    if (!KMSystem.isMSKeyStoreOS()) {
                                        ikeycmd.displayHelp(null, -49);
                                    } else {
                                        ikeycmd.displayHelp("-cert -modify", -48);
                                    }
                                }
                                if ((n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string)) == 1 || n == 5) {
                                    cLICertificateInfo.cliDb.setName(string);
                                } else {
                                    ikeycmd.displayHelp("-modify", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                                }
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !((File)(object = new File(cLICertificateInfo.cliDb.getName()))).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block30;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-label")) break block33;
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setLabel(stringArray[++n2]);
                            if (cLICertificateInfo.getLabel().length() == 0) {
                                ikeycmd.displayHelp(null, -39);
                            }
                            break block30;
                        } else {
                            ikeycmd.displayHelp(null, -21);
                        }
                        break block30;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-trust")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 18;
                            return cLICertificateInfo;
                        }
                        if (n != 1 && n != 5) {
                            ikeycmd.displayHelp("-trust", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                        }
                        object = "";
                        if (stringArray.length > n2 + 1) {
                            object = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -36);
                        }
                        if (((String)object).equalsIgnoreCase("enable")) {
                            cLICertificateInfo.setTrust(true);
                        } else {
                            if (!((String)object).equalsIgnoreCase("disable")) {
                                cLICertificateInfo.message = object;
                                cLICertificateInfo.rc = -13;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setTrust(false);
                        }
                    }
                }
                ++n2;
            }
            try {
                object = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateModify()::Check for pwd: " + n + ".." + (String)object + "\n");
                int n3 = KeyStoreManager.getDbTypeFromKeyStore((String)object);
                ikeycmd.debugMsg("ikeycmd.parseCertificateModify()::After mapped into KS: " + n3 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n3, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block31;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateList(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block55: {
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(10);
            String string = null;
            int n = 0;
            if (stringArray.length > 13) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            String string2 = "";
            if (stringArray.length > n2) {
                string2 = stringArray[n2];
            } else {
                ikeycmd.displayHelp(null, 10);
            }
            if (string2.equalsIgnoreCase("all") || string2.equalsIgnoreCase("personal") || string2.equalsIgnoreCase("CA") || string2.equalsIgnoreCase("site")) {
                cLICertificateInfo.setList(string2);
                ++n2;
            } else if (!(string2.equalsIgnoreCase("-db") || string2.equalsIgnoreCase("-pw") || string2.equalsIgnoreCase("-crypto") || string2.equalsIgnoreCase("-expiry"))) {
                cLICertificateInfo.message = string2;
                cLICertificateInfo.rc = 10;
                return cLICertificateInfo;
            }
            int n3 = n2;
            while (n3 < stringArray.length) {
                block54: {
                    String string3;
                    block58: {
                        block57: {
                            File file;
                            block56: {
                                if (!stringArray[n3].equalsIgnoreCase("-expiry")) break block56;
                                cLICertificateInfo.cliDb.setExpiryShow(true);
                                if (stringArray.length > n3 + 1) {
                                    int n4 = 0;
                                    string3 = stringArray[++n3];
                                    try {
                                        n4 = Integer.valueOf(string3);
                                        cLICertificateInfo.cliDb.setExpiryTime(n4);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        --n3;
                                    }
                                }
                                break block54;
                            }
                            if (!stringArray[n3].equalsIgnoreCase("-db")) break block57;
                            if (stringArray.length > n3 + 1) {
                                if ((string = stringArray[++n3]).equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                                    ikeycmd.displayHelp(null, -49);
                                }
                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                cLICertificateInfo.cliDb.setName(string);
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block54;
                        }
                        if (!stringArray[n3].equalsIgnoreCase("-crypto")) break block58;
                        if (stringArray.length > n3 + 1) {
                            cLICertificateInfo.cliDb.setDbType(10);
                            String string4 = stringArray[++n3];
                            if (!string4.startsWith("-")) {
                                cLICertificateInfo.cliDb.setName(string4);
                                break block54;
                            } else {
                                --n3;
                            }
                            break block54;
                        } else if (stringArray.length == n3 + 1) {
                            cLICertificateInfo.cliDb.setDbType(10);
                            ikeycmd.debugMsg("ikeycmd.parseCertificateList.arg==i " + n3 + 1);
                            break block54;
                        } else {
                            ikeycmd.displayHelp(null, -44);
                        }
                        break block54;
                    }
                    if (stringArray[n3].equalsIgnoreCase("-tokenlabel")) {
                        if (stringArray.length > n3 + 1) {
                            cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n3]);
                            isTokenLabelFlagUsed = true;
                            cLICertificateInfo.cliDb.setDbType(10);
                        } else {
                            ikeycmd.displayHelp("-tokenlabel", -45);
                        }
                    } else if (stringArray[n3].equalsIgnoreCase("-relativeSlotNumber")) {
                        if (stringArray.length > n3 + 1) {
                            string3 = stringArray[++n3];
                            try {
                                int n5 = Integer.valueOf(string3);
                                cLICertificateInfo.cliDb.setSlotID(n5);
                                isSlotIDFlagUsed = true;
                                cLICertificateInfo.cliDb.setDbType(11);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string3, -9);
                            }
                        } else {
                            ikeycmd.displayHelp("-relativeSlotNumber", -45);
                        }
                    } else if (stringArray[n3].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n3 + 1) {
                            if (string != null && string.equalsIgnoreCase("MSCertificateStore")) {
                                ikeycmd.displayHelp(null, -41);
                            }
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n3]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else {
                        if (!stringArray[n3].equalsIgnoreCase("-type")) {
                            cLICertificateInfo.message = stringArray[n3];
                            cLICertificateInfo.rc = 10;
                            return cLICertificateInfo;
                        }
                        String string5 = "";
                        if (stringArray.length > n3 + 1) {
                            string5 = stringArray[++n3];
                        } else {
                            ikeycmd.displayHelp(null, -27);
                        }
                        if (string5.equalsIgnoreCase("CMS") || string5.equalsIgnoreCase("kdb")) {
                            cLICertificateInfo.cliDb.setDbType(1);
                        } else if (string5.equalsIgnoreCase("WEBDB") || string5.equalsIgnoreCase("kyr")) {
                            ikeycmd.displayHelp(string2, -23);
                        } else if (string5.equalsIgnoreCase("SSLight") || string5.equalsIgnoreCase("class")) {
                            cLICertificateInfo.cliDb.setDbType(3);
                        } else if (string5.equalsIgnoreCase("JKS") || string5.equalsIgnoreCase("jks")) {
                            cLICertificateInfo.cliDb.setDbType(6);
                        } else if (string5.equalsIgnoreCase("JCEKS") || string5.equalsIgnoreCase("jck")) {
                            cLICertificateInfo.cliDb.setDbType(7);
                        } else {
                            if (!string5.equalsIgnoreCase("PKCS12") && !string5.equalsIgnoreCase("p12")) {
                                cLICertificateInfo.cliDb.setDbType(string2);
                                cLICertificateInfo.message = string5;
                                cLICertificateInfo.rc = -11;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.cliDb.setDbType(8);
                        }
                    }
                }
                ++n3;
            }
            try {
                String string6 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateList()::Check for pwd: " + n + ".." + string6 + "\n");
                int n6 = KeyStoreManager.getDbTypeFromKeyStore(string6);
                ikeycmd.debugMsg("ikeycmd.parseCertificateList()::After mapped into KS: " + n6 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n6, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block55;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK ";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateReceive(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block59: {
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(15);
            String string = null;
            int n = 0;
            if (stringArray.length > 16) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block58: {
                    block62: {
                        block61: {
                            File file;
                            block60: {
                                if (!stringArray[n2].equalsIgnoreCase("-file")) break block60;
                                if (stringArray.length > n2 + 1) {
                                    cLICertificateInfo.setFileName(stringArray[++n2]);
                                } else {
                                    ikeycmd.displayHelp(null, -22);
                                }
                                File file2 = new File(cLICertificateInfo.getFileName());
                                if (!file2.exists()) {
                                    ikeycmd.displayHelp(null, -46);
                                }
                                break block58;
                            }
                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block61;
                            if (stringArray.length > n2 + 1) {
                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                    if (!KMSystem.isMSKeyStoreOS()) {
                                        ikeycmd.displayHelp(null, -49);
                                    } else {
                                        ikeycmd.displayHelp("-cert -receive", -48);
                                    }
                                }
                                n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string);
                                cLICertificateInfo.cliDb.setName(string);
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block58;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-crypto")) break block62;
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.cliDb.setDbType(10);
                            String string2 = stringArray[++n2];
                            if (!string2.startsWith("-")) {
                                cLICertificateInfo.cliDb.setName(string2);
                                break block58;
                            } else {
                                --n2;
                            }
                            break block58;
                        } else {
                            ikeycmd.displayHelp(null, -44);
                        }
                        break block58;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-tokenlabel")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.cliDb.setTokenLabel(stringArray[++n2]);
                            isTokenLabelFlagUsed = true;
                            cLICertificateInfo.cliDb.setDbType(10);
                        } else {
                            ikeycmd.displayHelp("-tokenlabel", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-secondarydb")) {
                        if (isSlotIDFlagUsed) {
                            ikeycmd.displayHelp("-secondarydb", "JSSE", -47);
                        }
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setSecondDBName(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -18);
                        }
                        File file = new File(cLICertificateInfo.getSecondDBName());
                        if (!file.exists()) {
                            ikeycmd.displayHelp(null, -46);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-secondarydbpw")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setSecondDBPswd(stringArray[++n2]);
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-relativeSlotNumber")) {
                        if (stringArray.length > n2 + 1) {
                            String string3 = stringArray[++n2];
                            try {
                                int n3 = Integer.valueOf(string3);
                                cLICertificateInfo.cliDb.setSlotID(n3);
                                isSlotIDFlagUsed = true;
                                cLICertificateInfo.cliDb.setDbType(11);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string3, -9);
                            }
                        } else {
                            ikeycmd.displayHelp("-relativeSlotNumber", -45);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-format")) {
                        String string4 = "";
                        if (stringArray.length > n2 + 1) {
                            string4 = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -35);
                        }
                        if (string4.equalsIgnoreCase("ascii")) {
                            cLICertificateInfo.setFormat(true);
                        } else {
                            if (!string4.equalsIgnoreCase("binary")) {
                                cLICertificateInfo.message = string4;
                                cLICertificateInfo.rc = -8;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setFormat(false);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-default_cert")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 15;
                            return cLICertificateInfo;
                        }
                        if (n != 1 && n != 5) {
                            ikeycmd.displayHelp("-default_cert", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                        }
                        String string5 = "";
                        if (stringArray.length > n2 + 1) {
                            string5 = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -34);
                        }
                        if (string5.equalsIgnoreCase("yes")) {
                            cLICertificateInfo.setDefault(true);
                        } else {
                            if (!string5.equalsIgnoreCase("no")) {
                                cLICertificateInfo.message = string5;
                                cLICertificateInfo.rc = 15;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setDefault(false);
                        }
                    }
                }
                ++n2;
            }
            try {
                String string6 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateReceive()::Check for pwd: " + n + ".." + string6 + "\n");
                int n4 = KeyStoreManager.getDbTypeFromKeyStore(string6);
                ikeycmd.debugMsg("ikeycmd.parseCertificateReceive()::After mapped into KS: " + n4 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n4, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block59;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_ADD_PRIKEY_ON_NOPWDDB"));
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CLICertificateInfo parseCertificateSign(String[] stringArray) {
        CLICertificateInfo cLICertificateInfo;
        block45: {
            boolean bl = false;
            cLICertificateInfo = new CLICertificateInfo(16);
            String string = null;
            int n = 0;
            if (stringArray.length > 16) {
                cLICertificateInfo.rc = -7;
                return cLICertificateInfo;
            }
            int n2 = 2;
            while (n2 < stringArray.length) {
                block44: {
                    block48: {
                        block47: {
                            File file;
                            block46: {
                                if (!stringArray[n2].equalsIgnoreCase("-file")) break block46;
                                if (stringArray.length > n2 + 1) {
                                    cLICertificateInfo.setFileName(stringArray[++n2]);
                                } else {
                                    ikeycmd.displayHelp(null, -22);
                                }
                                File file2 = new File(cLICertificateInfo.getFileName());
                                if (!file2.exists()) {
                                    ikeycmd.displayHelp(null, -46);
                                }
                                break block44;
                            }
                            if (!stringArray[n2].equalsIgnoreCase("-db")) break block47;
                            if (stringArray.length > n2 + 1) {
                                if ((string = stringArray[++n2]).equalsIgnoreCase("MSCertificateStore")) {
                                    if (!KMSystem.isMSKeyStoreOS()) {
                                        ikeycmd.displayHelp(null, -49);
                                    } else {
                                        ikeycmd.displayHelp("-cert -sign", -48);
                                    }
                                }
                                if ((n = CLIKeyStoreManager.getKeyDatabaseTypeByName(string)) == 1 || n == 5) {
                                    cLICertificateInfo.cliDb.setName(string);
                                } else {
                                    ikeycmd.displayHelp("-sign", CLIKeyStoreManager.convertMapToKeyStore(n), -47);
                                }
                            } else {
                                ikeycmd.displayHelp(null, -18);
                            }
                            if (!string.equalsIgnoreCase("MSCertificateStore") && !(file = new File(cLICertificateInfo.cliDb.getName())).exists()) {
                                ikeycmd.displayHelp(null, -46);
                            }
                            break block44;
                        }
                        if (!stringArray[n2].equalsIgnoreCase("-label")) break block48;
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setLabel(stringArray[++n2]);
                            if (cLICertificateInfo.getLabel().length() == 0) {
                                ikeycmd.displayHelp(null, -39);
                            }
                            break block44;
                        } else {
                            ikeycmd.displayHelp(null, -21);
                        }
                        break block44;
                    }
                    if (stringArray[n2].equalsIgnoreCase("-pw")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.cliDb.setPassword(stringArray[++n2]);
                            bl = true;
                        } else {
                            ikeycmd.displayHelp(null, -19);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-format")) {
                        String string2 = "";
                        if (stringArray.length > n2 + 1) {
                            string2 = stringArray[++n2];
                        } else {
                            ikeycmd.displayHelp(null, -35);
                        }
                        if (string2.equalsIgnoreCase("ascii")) {
                            cLICertificateInfo.setFormat(true);
                        } else {
                            if (!string2.equalsIgnoreCase("binary")) {
                                cLICertificateInfo.message = string2;
                                cLICertificateInfo.rc = -8;
                                return cLICertificateInfo;
                            }
                            cLICertificateInfo.setFormat(false);
                        }
                    } else if (stringArray[n2].equalsIgnoreCase("-target")) {
                        if (stringArray.length > n2 + 1) {
                            cLICertificateInfo.setTargetDb(stringArray[++n2]);
                            cLICertificateInfo.setTargetDbType(CLIKeyStoreManager.getKeyDatabaseTypeByName(stringArray[n2]));
                        } else {
                            ikeycmd.displayHelp(null, -20);
                        }
                        if (cLICertificateInfo.getTargetDb().equalsIgnoreCase("MSCertificateStore") && !KMSystem.isMSKeyStoreOS()) {
                            ikeycmd.displayHelp(null, -49);
                        }
                    } else {
                        if (!stringArray[n2].equalsIgnoreCase("-expire")) {
                            cLICertificateInfo.message = stringArray[n2];
                            cLICertificateInfo.rc = 16;
                            return cLICertificateInfo;
                        }
                        long l = 0L;
                        if (stringArray.length > n2 + 1) {
                            String string3 = stringArray[++n2];
                            try {
                                l = Long.valueOf(string3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                ikeycmd.displayHelp(string3, -9);
                            }
                        } else {
                            ikeycmd.displayHelp(null, -28);
                        }
                        if (l <= 0L) {
                            cLICertificateInfo.message = "" + l;
                            cLICertificateInfo.rc = -9;
                            return cLICertificateInfo;
                        }
                        cLICertificateInfo.setExpire(l);
                    }
                }
                ++n2;
            }
            try {
                String string4 = CLIKeyStoreManager.convertMapToKeyStore(n);
                ikeycmd.debugMsg("ikeycmd.parseCertificateSign()::Check for pwd: " + n + ".." + string4 + "\n");
                int n3 = KeyStoreManager.getDbTypeFromKeyStore(string4);
                ikeycmd.debugMsg("ikeycmd.parseCertificateSign()::After mapped into KS: " + n3 + "\n");
                if (KeyStoreManager.isPasswordNeeded(n3, cLICertificateInfo.cliDb.getName())) {
                    if (!bl && cLICertificateInfo.cliDb.getPassword() == null) {
                        cLICertificateInfo.cliDb.setPassword(ikeycmd.promptForPassword());
                    }
                    break block45;
                }
                if (bl) {
                    ikeycmd.displayHelp("-pw", -42);
                }
                cLICertificateInfo.cliDb.setPassword("");
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                // empty catch block
            }
        }
        cLICertificateInfo.message = "OK";
        cLICertificateInfo.rc = 0;
        return cLICertificateInfo;
    }

    public static void displayHelp(String string, int n) {
        if (string == null) {
            string = "";
        }
        switch (n) {
            case 21: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-keydb   -changepw    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CHANGEPW"));
                System.out.println("         -convert     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CONVERT"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_DELETE"));
                System.out.println("         -stashpw     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_STASHPW"));
                System.out.println("         -list        " + ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
                System.out.println("-cert    -add         " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_ADD"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DETAILS"));
                System.out.println("         -export      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXPORT"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXTRACT"));
                System.out.println("         -getdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_GETDEFAULT"));
                System.out.println("         -import      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_IMPORT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_LIST"));
                System.out.println("         -modify      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_MODIFY"));
                System.out.println("         -receive     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_RECEIVE"));
                System.out.println("         -setdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SETDEFAULT"));
                System.out.println("         -sign        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SIGN"));
                System.out.println("-certreq -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DETAILS"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_EXTRACT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_LIST"));
                System.out.println("         -recreate    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_RECREATE"));
                System.out.println("-version              " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_VERSION"));
                System.out.println("-help                 " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_HELP"));
                break;
            }
            case -2: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_MODE"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-keydb   -changepw    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CHANGEPW"));
                System.out.println("         -convert     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CONVERT"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_DELETE"));
                System.out.println("         -stashpw     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_STASHPW"));
                System.out.println("         -list        " + ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
                System.out.println("-cert    -add         " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_ADD"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DETAILS"));
                System.out.println("         -export      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXPORT"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXTRACT"));
                System.out.println("         -getdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_GETDEFAULT"));
                System.out.println("         -import      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_IMPORT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_LIST"));
                System.out.println("         -modify      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_MODIFY"));
                System.out.println("         -receive     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_RECEIVE"));
                System.out.println("         -setdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SETDEFAULT"));
                System.out.println("         -sign        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SIGN"));
                System.out.println("-certreq -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DETAILS"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_EXTRACT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_LIST"));
                System.out.println("         -recreate    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_RECREATE"));
                System.out.println("-version              " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_VERSION"));
                System.out.println("-help                 " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_HELP"));
                break;
            }
            case -3: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_DBACTION"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-keydb   -changepw    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CHANGEPW"));
                System.out.println("         -convert     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CONVERT"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_DELETE"));
                System.out.println("         -stashpw     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_STASHPW"));
                System.out.println("         -list        " + ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
                break;
            }
            case -24: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_NO_DBACTION_SPECIFIED"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-keydb   -changepw    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CHANGEPW"));
                System.out.println("         -convert     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CONVERT"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_DELETE"));
                System.out.println("         -stashpw     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_STASHPW"));
                System.out.println("         -list        " + ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
                break;
            }
            case -4: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_REQACTION"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-certreq -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DETAILS"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_EXTRACT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_LIST"));
                System.out.println("         -recreate    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_RECREATE"));
                break;
            }
            case -25: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_NO_REQACTION_SPECIFIED"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-certreq -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DETAILS"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_EXTRACT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_LIST"));
                System.out.println("         -recreate    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_RECREATE"));
                break;
            }
            case -5: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_CERTACTION"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-cert    -add         " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_ADD"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DETAILS"));
                System.out.println("         -export      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXPORT"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXTRACT"));
                System.out.println("         -getdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_GETDEFAULT"));
                System.out.println("         -import      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_IMPORT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_LIST"));
                System.out.println("         -modify      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_MODIFY"));
                System.out.println("         -receive     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_RECEIVE"));
                System.out.println("         -setdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SETDEFAULT"));
                System.out.println("         -sign        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SIGN"));
                break;
            }
            case -26: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_NO_CERTACTION_SPECIFIED"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-cert    -add         " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_ADD"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DETAILS"));
                System.out.println("         -export      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXPORT"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXTRACT"));
                System.out.println("         -getdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_GETDEFAULT"));
                System.out.println("         -import      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_IMPORT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_LIST"));
                System.out.println("         -modify      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_MODIFY"));
                System.out.println("         -receive     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_RECEIVE"));
                System.out.println("         -setdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SETDEFAULT"));
                System.out.println("         -sign        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SIGN"));
                break;
            }
            case -39: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_LABEL_NULL"));
                break;
            }
            case -6: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_ERR_PARAMETER"));
                break;
            }
            case -7: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_TOO_MANY_OPTIONS"));
                break;
            }
            case -8: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_FORMAT"));
                break;
            }
            case -9: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_EXPIRE"));
                break;
            }
            case -10: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_KEY_SIZE"));
                break;
            }
            case -11: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_TYPE"));
                break;
            }
            case -12: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_LIST"));
                break;
            }
            case -13: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_TRUST"));
                break;
            }
            case -14: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_NO_PARAMS"));
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_HELP_TITLE"));
                System.out.println("----     ------       ---------------------------------------------------------");
                System.out.println("-keydb   -changepw    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CHANGEPW"));
                System.out.println("         -convert     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CONVERT"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_DELETE"));
                System.out.println("         -stashpw     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_DB_STASHPW"));
                System.out.println("         -list        " + ikeycmd.getNLSResString("GUI_MSG_TIP_DBTYPE_CHOICE"));
                System.out.println("-cert    -add         " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_ADD"));
                System.out.println("         -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_DETAILS"));
                System.out.println("         -export      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXPORT"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_EXTRACT"));
                System.out.println("         -getdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_GETDEFAULT"));
                System.out.println("         -import      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_IMPORT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_LIST"));
                System.out.println("         -modify      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_MODIFY"));
                System.out.println("         -receive     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_RECEIVE"));
                System.out.println("         -setdefault  " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SETDEFAULT"));
                System.out.println("         -sign        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_CERT_SIGN"));
                System.out.println("-certreq -create      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_CREATE"));
                System.out.println("         -delete      " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DELETE"));
                System.out.println("         -details     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_DETAILS"));
                System.out.println("         -extract     " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_EXTRACT"));
                System.out.println("         -list        " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_LIST"));
                System.out.println("         -recreate    " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_REQ_RECREATE"));
                System.out.println("-version              " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_VERSION"));
                System.out.println("-help                 " + KMSystem.getNLSErrString("GSKKM_CLI_HELP_HELP"));
                break;
            }
            case -15: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_ENCRYPT"));
                break;
            }
            case -16: {
                System.out.println(string);
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_ERR_REQUIRED"));
                break;
            }
            case -17: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_INVALID_VERSION"));
                break;
            }
            case -19: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_NO_PASSWORD_SPECIFIED"));
                break;
            }
            case -18: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_NO_DB_NAME_SPECIFIED"));
                break;
            }
            case -20: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_NO_TARGET_SPECIFIED"));
                break;
            }
            case -21: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_NO_LABEL_SPECIFIED"));
                break;
            }
            case -22: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_NO_FILE_SPECIFIED"));
                break;
            }
            case -23: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_WEBDB_NOT_SUPPORTED"));
            }
            case 5: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-keydb -changepw [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[relativeSlotNumber <slot_number>]] -pw <passwd> -new_pw <new passwd> [-expire <days>] [-stash]");
                break;
            }
            case 7: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-keydb -convert -db <name> [-pw <passwd>] -old_format <cms | webdb | jks | jceks | pkcs12> -new_format <cms | jks | jceks | pkcs12> ");
                break;
            }
            case 4: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-keydb -create -db <name> [-pw <passwd>] [-type <cms | jks | jceks | pkcs12>] [-expire <days>] [-stash]");
                break;
            }
            case 8: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-keydb -delete -db <name> [-pw <passwd>]");
                break;
            }
            case 6: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-keydb -stashpw -db <name> -pw <passwd>");
                break;
            }
            case 17: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -add [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label> -file <name>[-format <ascii | binary>] [-trust <enable | disable>]");
                break;
            }
            case 23: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -create [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label> -dn <dist name> [-size <1024 | 512>] [-x509version <1 | 2 | 3>] [-default_cert <yes | no>] [-expire <days>]");
                break;
            }
            case 25: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -delete [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label>");
                break;
            }
            case 11: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -details [-showOID] [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label>");
                break;
            }
            case 12: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -export [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number]] [-pw <passwd>] -label <label> [-type <cms | jks | jceks | pkcs12>] -target <name> [-target_pw <passwd>] [-target_type <cms | jks | jceks | pkcs12>] [-encryption <strong | weak>]");
                break;
            }
            case 14: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -extract [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number]] [-pw <passwd>] -label <label> -target <name> [-format <ascii | binary>]");
                break;
            }
            case 20: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -getdefault -db <name> [-pw <passwd>]");
                break;
            }
            case 13: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -import -db <name> [-pw <passwd>] -label <label> [-type <cms | jks | jceks>] [-target <name> -target_pw <passwd>] [-target_type <cms | jks | jceks | pkcs12>] [-new_label <label>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>] -pw <passwd>] [-secondaryDB <filename> -secondaryDBpw <password>]\n");
                System.out.println("-cert -import -file <name> [-type <pkcs12>] [-target <name> -target_pw <passwd>] [-target_type <cms | jks | jceks | pkcs12>] [-pfx] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>] -pw <passwd>] [-secondaryDB <filename> -secondaryDBpw <password>]\n");
                break;
            }
            case 10: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -list [<all | personal | CA | site>] [-expiry [<number of days>]] [-db <name>][-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] [-type <cms | jks | jceks | pkcs12>]");
                break;
            }
            case 18: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -modify -db <name> [-pw <passwd>] -label <label> -trust <enable | disable>");
                break;
            }
            case 15: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -receive -file <name> [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] [-format <ascii | binary>] [-default_cert <yes | no>]");
                break;
            }
            case 19: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -setdefault -db <name> [-pw <passwd>] -label <label>");
                break;
            }
            case 16: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-cert -sign -file <name> -db <name> [-pw <passwd>] -label <label) -target <name> [-format <ascii | binary>] [-expire <days>]");
                break;
            }
            case 24: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -create [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label> -dn <dist name> [-size <1024 | 512>] -file <name>");
                break;
            }
            case 26: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -delete [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label>");
                break;
            }
            case 28: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -details [-showOID] [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label>");
                break;
            }
            case 29: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -extract [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>] -label <label> -target <name>");
                break;
            }
            case 27: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -list [-db <name>] [-crypto <module name> [-tokenlabel <token label>]|[-relativeSlotNumber <slot_number>]] [-pw <passwd>]");
                break;
            }
            case 9: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_CLI_ERR_GENERIC_OPTION") + "\n");
                System.out.println("-certreq -recreate -db <name> [-pw <passwd>] -label <label> -target <name>");
                break;
            }
            case -28: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_EXPIRE_DAYS_SPECIFIED"));
                break;
            }
            case -27: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_DB_TYPE_SPECIFIED"));
                break;
            }
            case -29: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_NEW_PASSWORD_SPECIFIED"));
                break;
            }
            case -30: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_OLD_DB_FORMAT_SPECIFIED"));
                break;
            }
            case -31: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_NEW_DB_FORMAT_SPECIFIED"));
                break;
            }
            case -32: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_KEY_SIZE_SPECIFIED"));
                break;
            }
            case -33: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_X509_VER_SPECIFIED"));
                break;
            }
            case -34: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_DEFAULT_CERT_VALUE_SPECIFIED"));
                break;
            }
            case -35: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_CERT_FORMAT_SPECIFIED"));
                break;
            }
            case -36: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_TRUST_STATUS_SPECIFIED"));
                break;
            }
            case -37: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_TARGET_PASSWORD_SPECIFIED"));
                break;
            }
            case -38: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NO_ENCRYP_SPECIFIED"));
                break;
            }
            case -40: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_NATIVE_NOT_ENABLED"));
                break;
            }
            case -41: {
                String string2 = KMSystem.getNLSErrString("GSKKM_CLI_PARAMETER_NOT_REQUIRED");
                Object[] objectArray = new Object[]{"-pw"};
                String string3 = MessageFormat.format(string2, objectArray);
                System.out.println(string3);
                break;
            }
            case -42: {
                String string4 = KMSystem.getNLSErrString("GSKKM_CLI_PARAMETER_NOT_REQUIRED");
                Object[] objectArray = new Object[]{string};
                String string5 = MessageFormat.format(string4, objectArray);
                System.out.println(string5);
                break;
            }
            case -43: {
                String string6 = KMSystem.getNLSErrString("GSKKM_CLI_PARAMETER_NOT_REQUIRED");
                Object[] objectArray = new Object[]{"-target_pw"};
                String string7 = MessageFormat.format(string6, objectArray);
                System.out.println(string7);
                break;
            }
            case -44: {
                String string8 = KMSystem.getNLSErrString("GSKKM_CLI_NO_PARAMETER_SPECIFIED");
                Object[] objectArray = new Object[]{"-crypto"};
                String string9 = MessageFormat.format(string8, objectArray);
                System.out.println(string9);
                break;
            }
            case -45: {
                String string10 = KMSystem.getNLSErrString("GSKKM_CLI_NO_PARAMETER_SPECIFIED");
                Object[] objectArray = new Object[]{string};
                String string11 = MessageFormat.format(string10, objectArray);
                System.out.println(string11);
                break;
            }
            case -46: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_FILE_NAME"));
                break;
            }
            case -51: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NOPWD_KDB"));
                break;
            }
            case -48: {
                String string12 = KMSystem.getNLSErrString("GSKKM_CLI_MICROSOFT_INVALID_OPERATION");
                Object[] objectArray = new Object[]{string};
                String string13 = MessageFormat.format(string12, objectArray);
                System.out.println(string13);
                break;
            }
            case -49: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_WIN2K_SUPPORT"));
                break;
            }
            case -50: {
                System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_SUPPORT"));
            }
            default: {
                System.out.println(string + " " + KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_SUPPORT") + "\n");
            }
        }
        ikeycmd.closeDumpFiles();
        KMSystem.cleanAll();
        System.exit(1);
    }

    public static void displayHelp(String string, String string2, int n) {
        switch (n) {
            case -47: {
                String string3 = KMSystem.getNLSErrString("GSKKM_CLI_NOT_SUPPORTED_PARAMETER");
                Object[] objectArray = new Object[]{string, string2};
                String string4 = MessageFormat.format(string3, objectArray);
                System.out.println(string4);
                break;
            }
            default: {
                System.out.println("");
            }
        }
        ikeycmd.closeDumpFiles();
        KMSystem.cleanAll();
        System.exit(1);
    }

    public static String promptForPassword() {
        String string;
        block3: {
            string = null;
            PasswordMaskingThread passwordMaskingThread = new PasswordMaskingThread();
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_PW_PROMPT_1"));
            System.out.flush();
            passwordMaskingThread.start();
            try {
                string = passwordMaskingThread.getPassword();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                if (!DEBUG) break block3;
                System.out.println("\n");
                exception.printStackTrace();
            }
        }
        if (string == "") {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
            System.exit(1);
        }
        return string;
    }

    public static String promptForNewPassword() {
        String string;
        block3: {
            string = null;
            PasswordMaskingThread passwordMaskingThread = new PasswordMaskingThread();
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_NPW_PROMPT_1"));
            System.out.flush();
            passwordMaskingThread.start();
            try {
                string = passwordMaskingThread.getPassword();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                if (!DEBUG) break block3;
                System.out.println("\n");
                exception.printStackTrace();
            }
        }
        if (string == "") {
            System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_CMN_PASSWORD_NULL"));
            System.exit(1);
        }
        return string;
    }

    public static void debugMsg(String string) {
        if (DEBUG) {
            if (debugDumpOutputStream != null && debugPrintWriter != null) {
                debugPrintWriter.println(string);
            } else {
                System.out.println(string);
            }
        }
    }

    public static void closeDumpFiles() {
        if (debugDumpOutputStream != null && debugPrintWriter != null) {
            debugPrintWriter.close();
            try {
                debugDumpOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        debugDumpOutputStream = null;
        debugPrintWriter = null;
    }

    public static void showProductInfo() {
        String string;
        try {
            InputStream inputStream = (class$com$ibm$gsk$ikeyman$ikeycmd == null ? (class$com$ibm$gsk$ikeyman$ikeycmd = ikeycmd.class$("com.ibm.gsk.ikeyman.ikeycmd")) : class$com$ibm$gsk$ikeyman$ikeycmd).getResourceAsStream("awt/images/gsk_curr_version");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            string = bufferedReader.readLine();
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            string = "7.0.0.0";
        }
        System.out.println(ikeycmd.getNLSResString("GUI_TITLE") + "\n" + ikeycmd.getNLSResString("GUI_LABEL_VERSION") + " : " + string + "\n" + ikeycmd.getNLSResString("GUI_CPYRITE1") + "  " + "1997-2003" + "\n" + ikeycmd.getNLSResString("GUI_CPYRITE2"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isTokenLabelFlagUsed = false;
        isSlotIDFlagUsed = false;
    }

    private static class PasswordMaskingThread
    extends Thread {
        public boolean typing = true;

        private PasswordMaskingThread() {
        }

        public void run() {
            System.out.println(KMSystem.getNLSErrString("GSKKM_CLI_PW_PROMPT_2"));
            while (this.typing) {
                System.out.print("\r \r");
            }
        }

        public String getPassword() throws IOException {
            String string = "";
            while (true) {
                char c = (char)System.in.read();
                this.typing = false;
                if (c == '\n' || c == '\r') break;
                string = string + c;
            }
            return string;
        }
    }
}

