/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hursley.devtools;

import com.ibm.hursley.devtools.TraceDummy;
import com.ibm.hursley.devtools.TraceReal;
import com.ibm.hursley.devtools.Tracer;
import java.io.FileWriter;
import java.io.PrintWriter;

public class Trace {
    private static final String sccsid = "%Z% %W%  %E% %U%";
    private static final String copyright_notice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1997     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Tracer tracer = new TraceReal();
    private static PrintWriter trc = new PrintWriter(System.err, true);
    private static int traceLevel = 1;
    private static int format = 15;
    private static boolean trace;
    private static boolean methodTracing;
    public static final int TIME = 1;
    public static final int MILLIS = 2;
    public static final int THREAD_NAME = 4;
    public static final int OBJECT = 8;
    public static final int TRACE_NORMAL = 15;
    public static final int TRACE_MINIMAL = 9;

    public static final boolean isOn() {
        return trace;
    }

    public static final void setMethodTraceThreshold(int n) {
        tracer.setMethodTraceThreshold(n);
    }

    public static final void setTraceLevel(int n) {
        traceLevel = n;
        tracer.setTraceLevel(n);
    }

    public static final int getTraceLevel() {
        return traceLevel;
    }

    public static final void turnMethodTracingOff() {
        methodTracing = false;
        tracer.turnMethodTracingOff();
    }

    public static final void turnMethodTracingOn() {
        methodTracing = true;
        tracer.turnMethodTracingOn();
    }

    public static final void turnTracingOff() {
        trace = false;
        tracer = new TraceDummy();
    }

    public static final void turnTracingOn() {
        trace = true;
        tracer = new TraceReal();
        tracer.setTraceLevel(traceLevel);
        if (methodTracing) {
            tracer.turnMethodTracingOn();
        }
        tracer.setTraceStream(trc);
        tracer.setFormat(format);
        tracer.turnTracingOn();
    }

    public static final void turnTracingOn(int n) {
        traceLevel = n;
        Trace.turnTracingOn();
    }

    public static final void setTraceStream(FileWriter fileWriter) {
        trc = new PrintWriter(fileWriter);
        tracer.setTraceStream(trc);
    }

    public static final void setTraceStream(PrintWriter printWriter) {
        trc = printWriter;
        tracer.setTraceStream(trc);
    }

    public static final PrintWriter getTraceStream() {
        return trc;
    }

    public static final void setFormat(int n) {
        format = n;
        tracer.setFormat(n);
    }

    public static final void dataTrace(int n, Object object, byte[] byArray) {
        tracer.dataTrace(n, object, byArray);
    }

    public static final void dumpCallStack() {
        tracer.dumpCallStack();
    }

    public static final void entry(int n, Object object, String string) {
        tracer.entry(n, object, string);
    }

    public static final void entry(int n, String string, String string2) {
        tracer.entry(n, string, string2);
    }

    public static final void entry(Object object, String string) {
        tracer.entry(object, string);
    }

    public static final void entry(String string, String string2) {
        tracer.entry(string, string2);
    }

    public static final void exit(int n, Object object, String string) {
        tracer.exit(n, object, string);
    }

    public static final void exit(int n, String string, String string2) {
        tracer.exit(n, string, string2);
    }

    public static final void exit(Object object, String string) {
        tracer.exit(object, string);
    }

    public static final void exit(String string, String string2) {
        tracer.exit(string, string2);
    }

    public static final void trace(int n, Object object, String string) {
        tracer.trace(n, object, string);
    }

    public static final void trace(int n, String string, String string2) {
        tracer.trace(n, string, string2);
    }

    public static final void trace(Object object, String string) {
        tracer.trace(object, string);
    }

    public static final void trace(String string, String string2) {
        tracer.trace(string, string2);
    }
}

