/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class EUCTW_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final String data;
    private final int shift;
    private final int mask1;
    private final int mask2;
    private final boolean maplow;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    EUCTW_Encoder(Charset charset, short[] sArray, int n, String string, byte[] byArray, byte[] byArray2) {
        super(charset, 1.5f, 4.0f);
        this.index = sArray;
        this.data = string;
        this.shift = n;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.maplow = byArray != null && byArray.length > 0 ? byArray[0] == 1 : false;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    public boolean canEncode(char c) {
        if (c < '\u007f') {
            return true;
        }
        return this.data.charAt(this.index[c >> this.shift] + (c & this.mask2)) > '\u0001';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        while (n < n2) {
            char c = cArray[n];
            if (Surrogate.is(c)) {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            if (this.maplow && c < '\u007f') {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = (byte)c;
            } else {
                int n5 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                if (n5 < 160) {
                    if (n5 < 2 && n5 != c) {
                        coderResult = CoderResult.unmappableForLength(1);
                        break;
                    }
                    if (n4 - n3 < 1) {
                        coderResult = CoderResult.OVERFLOW;
                        break;
                    }
                    byArray[n3++] = (byte)n5;
                } else {
                    int n6 = n5 & 0x8080;
                    if (n6 == 32896) {
                        if (n4 - n3 < 2) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)n5;
                    } else {
                        int n7;
                        if (n6 == 32768) {
                            n7 = 162;
                        } else if (n6 == 128) {
                            n7 = 163;
                        } else if (n5 >= 8192) {
                            n7 = 172;
                        } else {
                            n7 = 173;
                            n5 += 8192;
                        }
                        if (n4 - n3 < 4) {
                            coderResult = CoderResult.OVERFLOW;
                            break;
                        }
                        byArray[n3++] = -114;
                        byArray[n3++] = (byte)n7;
                        byArray[n3++] = (byte)((n5 |= 0x8080) >> 8);
                        byArray[n3++] = (byte)n5;
                    }
                }
            }
            ++n;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        block27: {
            CoderResult coderResult2;
            block26: {
                CoderResult coderResult3;
                block25: {
                    CoderResult coderResult4;
                    block24: {
                        CoderResult coderResult5;
                        block23: {
                            CoderResult coderResult6;
                            block22: {
                                CoderResult coderResult7;
                                block21: {
                                    n = charBuffer.position();
                                    try {
                                        while (charBuffer.hasRemaining()) {
                                            char c = charBuffer.get();
                                            if (Surrogate.is(c)) {
                                                if (this.sgp.parse(c, charBuffer) < 0) {
                                                    coderResult7 = this.sgp.error();
                                                    Object var11_13 = null;
                                                    break block21;
                                                }
                                                coderResult6 = this.sgp.unmappableResult();
                                                break block22;
                                            }
                                            if (this.maplow && c < '\u007f') {
                                                if (!byteBuffer.hasRemaining()) break;
                                                byteBuffer.put((byte)c);
                                            } else {
                                                int n2 = this.data.charAt(this.index[c >> this.shift] + (c & this.mask2));
                                                if (n2 < 256) {
                                                    if (n2 < 2 && n2 != c) {
                                                        coderResult5 = CoderResult.unmappableForLength(1);
                                                        break block23;
                                                    }
                                                    if (byteBuffer.remaining() < 1) {
                                                        coderResult4 = CoderResult.OVERFLOW;
                                                        break block24;
                                                    } else {
                                                        byteBuffer.put((byte)n2);
                                                        continue;
                                                    }
                                                }
                                                int n3 = n2 & 0x8080;
                                                if (n3 == 32896) {
                                                    if (byteBuffer.remaining() < 2) {
                                                        coderResult3 = CoderResult.OVERFLOW;
                                                        break block25;
                                                    }
                                                    byteBuffer.put((byte)(n2 >> 8));
                                                    byteBuffer.put((byte)n2);
                                                } else {
                                                    int n4;
                                                    if (n3 == 32768) {
                                                        n4 = 162;
                                                    } else if (n3 == 128) {
                                                        n4 = 163;
                                                    } else if (n2 >= 8192) {
                                                        n4 = 172;
                                                    } else {
                                                        n4 = 173;
                                                        n2 += 8192;
                                                    }
                                                    n2 |= 0x8080;
                                                    if (byteBuffer.remaining() < 4) {
                                                        coderResult2 = CoderResult.OVERFLOW;
                                                        break block26;
                                                    }
                                                    byteBuffer.put((byte)-114);
                                                    byteBuffer.put((byte)n4);
                                                    byteBuffer.put((byte)(n2 >> 8));
                                                    byteBuffer.put((byte)n2);
                                                }
                                            }
                                            ++n;
                                        }
                                        coderResult = CoderResult.UNDERFLOW;
                                        break block27;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_20 = null;
                                        charBuffer.position(n);
                                        throw throwable;
                                    }
                                }
                                charBuffer.position(n);
                                return coderResult7;
                            }
                            Object var11_14 = null;
                            charBuffer.position(n);
                            return coderResult6;
                        }
                        Object var11_15 = null;
                        charBuffer.position(n);
                        return coderResult5;
                    }
                    Object var11_16 = null;
                    charBuffer.position(n);
                    return coderResult4;
                }
                Object var11_17 = null;
                charBuffer.position(n);
                return coderResult3;
            }
            Object var11_18 = null;
            charBuffer.position(n);
            return coderResult2;
        }
        Object var11_19 = null;
        charBuffer.position(n);
        return coderResult;
    }

    protected final CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !IBMCharsetEncoder.UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

