/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Vector;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 0) {
            this.context = null;
        } else if (protectionDomainArray.length == 1) {
            this.context = (ProtectionDomain[])protectionDomainArray.clone();
        } else {
            Vector vector = new Vector(protectionDomainArray.length);
            int n = 0;
            while (n < protectionDomainArray.length) {
                if (protectionDomainArray[n] != null && !vector.contains(protectionDomainArray[n])) {
                    vector.addElement(protectionDomainArray[n]);
                }
                ++n;
            }
            this.context = new ProtectionDomain[vector.size()];
            vector.copyInto(this.context);
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        if (accessControlContext == null) {
            throw new NullPointerException("null AccessControlContext was provided");
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    private AccessControlContext(ProtectionDomain[] protectionDomainArray, DomainCombiner domainCombiner) {
        this.context = (ProtectionDomain[])protectionDomainArray.clone();
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.combiner;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            if (Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    n = 0;
                    while (n < this.context.length) {
                        debug.println("domain " + n + " " + this.context[n]);
                        ++n;
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        n = 0;
        while (n < this.context.length) {
            if (this.context[n] != null && !this.context[n].implies(permission)) {
                if (debug != null) {
                    debug.println("access denied " + permission);
                    if (Debug.isOn("failure")) {
                        Thread.currentThread();
                        Thread.dumpStack();
                        final ProtectionDomain protectionDomain = this.context[n];
                        final Debug debug = AccessControlContext.debug;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                debug.println("domain that failed " + protectionDomain);
                                return null;
                            }
                        });
                    }
                }
                throw new AccessControlException("access denied " + permission, permission);
            }
            ++n;
        }
        if (debug != null) {
            debug.println("access allowed " + permission);
        }
    }

    AccessControlContext optimize() {
        ProtectionDomain[] protectionDomainArray;
        boolean bl;
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean bl2 = this.context == null;
        boolean bl3 = bl = accessControlContext == null || accessControlContext.context == null;
        if (bl && bl2) {
            return accessControlContext != null ? accessControlContext : this;
        }
        if (accessControlContext != null && accessControlContext.combiner != null) {
            return this.goCombiner(this.context, accessControlContext);
        }
        if (bl2) {
            return accessControlContext;
        }
        int n = this.context.length;
        if (bl && n <= 2) {
            return this;
        }
        if (n == 1 && this.context[0] == accessControlContext.context[0]) {
            return accessControlContext;
        }
        int n2 = bl ? 0 : accessControlContext.context.length;
        ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[n + n2];
        if (!bl) {
            System.arraycopy(accessControlContext.context, 0, protectionDomainArray2, 0, n2);
        }
        int n3 = 0;
        while (n3 < this.context.length) {
            block13: {
                protectionDomainArray = this.context[n3];
                if (protectionDomainArray != null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        if (protectionDomainArray != protectionDomainArray2[n4]) {
                            ++n4;
                            continue;
                        }
                        break block13;
                    }
                    protectionDomainArray2[n2++] = protectionDomainArray;
                }
            }
            ++n3;
        }
        if (n2 != protectionDomainArray2.length) {
            if (!bl && n2 == accessControlContext.context.length) {
                return accessControlContext;
            }
            if (bl && n2 == n) {
                return this;
            }
            protectionDomainArray = new ProtectionDomain[n2];
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray, 0, n2);
            protectionDomainArray2 = protectionDomainArray;
        }
        return new AccessControlContext(protectionDomainArray2, false);
    }

    private AccessControlContext goCombiner(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] protectionDomainArray2 = accessControlContext.combiner.combine(protectionDomainArray == null ? null : (ProtectionDomain[])protectionDomainArray.clone(), accessControlContext.context == null ? null : (ProtectionDomain[])accessControlContext.context.clone());
        return new AccessControlContext(protectionDomainArray2, accessControlContext.combiner);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (this.context == null) {
            return accessControlContext.context == null;
        }
        if (accessControlContext.context == null) {
            return false;
        }
        if (!this.containsAllPDs(accessControlContext) || !accessControlContext.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return accessControlContext.combiner == null;
        }
        if (accessControlContext.combiner == null) {
            return false;
        }
        return this.combiner.equals(accessControlContext.combiner);
    }

    private boolean containsAllPDs(AccessControlContext accessControlContext) {
        boolean bl = false;
        int n = 0;
        while (n < this.context.length) {
            int n2;
            bl = false;
            if (this.context[n] == null) {
                n2 = 0;
                while (n2 < accessControlContext.context.length && !bl) {
                    bl = accessControlContext.context[n2] == null;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < accessControlContext.context.length && !bl) {
                    if (accessControlContext.context[n2] != null) {
                        bl = this.context[n].getClass() == accessControlContext.context[n2].getClass() && this.context[n].equals(accessControlContext.context[n2]);
                    }
                    ++n2;
                }
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.context == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.context.length) {
            if (this.context[n2] != null) {
                n ^= this.context[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }
}

