/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class HashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient int contentionFlag = 0;
    static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    private synchronized void onEntry() {
        switch (this.contentionFlag) {
            case 0: {
                this.contentionFlag = 1;
                break;
            }
            case 1: {
                this.contentionFlag = 2;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + this.contentionFlag);
            }
        }
    }

    private synchronized void onExit() {
        int n = this.contentionFlag;
        this.contentionFlag = 0;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                throw new ConcurrentModificationException("concurrent access to HashMap attempted by " + Thread.currentThread());
            }
            default: {
                throw new RuntimeException("Unexpected contentionFlag " + n);
            }
        }
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public HashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAllForCreate(map);
    }

    void init() {
    }

    static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    static int hash(Object object) {
        int n = object.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(object2, entry.key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return entry;
    }

    public boolean containsKey(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(object2, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    Entry getEntry(Object object) {
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (!(entry == null || entry.hash == n && HashMap.eq(object2, entry.key))) {
            entry = entry.next;
        }
        return entry;
    }

    public Object put(Object object, Object object2) {
        Object object3 = HashMap.maskNull(object);
        int n = HashMap.hash(object3);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(object3, entry.key)) {
                Object object4 = entry.value;
                entry.value = object2;
                entry.recordAccess(this);
                return object4;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, object3, object2, n2);
        return null;
    }

    private void putForCreate(Object object, Object object2) {
        Object object3 = HashMap.maskNull(object);
        int n = HashMap.hash(object3);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && HashMap.eq(object3, entry.key)) {
                entry.value = object2;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, object3, object2, n2);
    }

    void putAllForCreate(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < entryArray2.length) {
            Entry entry = entryArray2[n2];
            if (entry != null) {
                Entry entry2;
                entryArray2[n2] = null;
                do {
                    entry2 = entry.next;
                    int n3 = HashMap.indexFor(entry.hash, n);
                    entry.next = entryArray[n3];
                    entryArray[n3] = entry;
                } while ((entry = entry2) != null);
            }
            ++n2;
        }
    }

    public void putAll(Map map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2 = (int)((float)n / this.loadFactor + 1.0f);
            if (n2 > 0x40000000) {
                n2 = 0x40000000;
            }
            int n3 = this.table.length;
            while (n3 < n2) {
                n3 <<= 1;
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        Entry entry = this.removeEntryForKey(object);
        return entry == null ? entry : entry.value;
    }

    Entry removeEntryForKey(Object object) {
        Entry entry;
        Object object2 = HashMap.maskNull(object);
        int n = HashMap.hash(object2);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && HashMap.eq(object2, entry2.key)) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    Entry removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = HashMap.maskNull(entry2.getKey());
        int n = HashMap.hash(object2);
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            entryArray[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        int n = 0;
        while (n < entryArray.length) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.table = new Entry[this.table.length];
        hashMap.entrySet = null;
        hashMap.modCount = 0;
        hashMap.size = 0;
        hashMap.init();
        hashMap.putAllForCreate(this);
        return hashMap;
    }

    void addEntry(int n, Object object, Object object2, int n2) {
        this.table[n2] = new Entry(n, object, object2, this.table[n2]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, Object object, Object object2, int n2) {
        this.table[n2] = new Entry(n, object, object2, this.table[n2]);
        ++this.size;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        int n3 = 0;
        while (n3 < n2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
            ++n3;
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return HashMap.this.newEntryIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = HashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        public boolean remove(Object object) {
            return HashMap.this.removeMapping(object) != null;
        }

        public int size() {
            return HashMap.this.size;
        }

        public void clear() {
            HashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return HashMap.this.newValueIterator();
        }

        public int size() {
            return HashMap.this.size;
        }

        public boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        public void clear() {
            HashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return HashMap.this.newKeyIterator();
        }

        public int size() {
            return HashMap.this.size;
        }

        public boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return HashMap.this.removeEntryForKey(object) != null;
        }

        public void clear() {
            HashMap.this.clear();
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Entry[] entryArray = HashMap.this.table;
            int n = entryArray.length;
            Entry entry = null;
            if (HashMap.this.size != 0) {
                while (n > 0 && (entry = entryArray[--n]) == null) {
                }
            }
            this.next = entry;
            this.index = n;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        Entry nextEntry() {
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            Entry[] entryArray = HashMap.this.table;
            int n = this.index;
            while (entry2 == null && n > 0) {
                entry2 = entryArray[--n];
            }
            this.index = n;
            this.next = entry2;
            this.current = entry;
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object object = this.current.key;
            this.current = null;
            HashMap.this.removeEntryForKey(object);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    static class Entry
    implements Map.Entry {
        final Object key;
        Object value;
        final int hash;
        Entry next;

        Entry(int n, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.next = entry;
            this.key = object;
            this.hash = n;
        }

        public Object getKey() {
            return HashMap.unmaskNull(this.key);
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            Object object2;
            Object object3;
            Object object4;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object5 = this.getKey();
            return (object5 == (object4 = entry.getKey()) || object5 != null && object5.equals(object4)) && ((object3 = this.getValue()) == (object2 = entry.getValue()) || object3 != null && object3.equals(object2));
        }

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HashMap hashMap) {
        }

        void recordRemoval(HashMap hashMap) {
        }
    }
}

