/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import sun.misc.CEFormatException;
import sun.misc.CEStreamExhausted;
import sun.misc.CRC16;
import sun.misc.CharacterDecoder;

public class UCDecoder
extends CharacterDecoder {
    private static final byte[] map_array = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 40, 41};
    private int sequence;
    private byte[] tmp = new byte[2];
    private CRC16 crc = new CRC16();
    private ByteArrayOutputStream lineAndSeq = new ByteArrayOutputStream(2);

    protected int bytesPerAtom() {
        return 2;
    }

    protected int bytesPerLine() {
        return 48;
    }

    protected void decodeAtom(PushbackInputStream pushbackInputStream, OutputStream outputStream, int n) throws IOException {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        byte[] byArray = new byte[3];
        int n5 = pushbackInputStream.read(byArray);
        if (n5 != 3) {
            throw new CEStreamExhausted();
        }
        n5 = 0;
        while (n5 < 64 && (n2 == -1 || n3 == -1 || n4 == -1)) {
            if (byArray[0] == map_array[n5]) {
                n2 = (byte)n5;
            }
            if (byArray[1] == map_array[n5]) {
                n3 = (byte)n5;
            }
            if (byArray[2] == map_array[n5]) {
                n4 = (byte)n5;
            }
            ++n5;
        }
        byte by = (byte)(((n2 & 0x38) << 2) + (n3 & 0x1F));
        byte by2 = (byte)(((n2 & 7) << 5) + (n4 & 0x1F));
        int n6 = 0;
        int n7 = 0;
        n5 = 1;
        while (n5 < 256) {
            if ((by & n5) != 0) {
                ++n6;
            }
            if ((by2 & n5) != 0) {
                ++n7;
            }
            n5 *= 2;
        }
        int n8 = (n3 & 0x20) / 32;
        int n9 = (n4 & 0x20) / 32;
        if ((n6 & 1) != n8) {
            throw new CEFormatException("UCDecoder: High byte parity error.");
        }
        if ((n7 & 1) != n9) {
            throw new CEFormatException("UCDecoder: Low byte parity error.");
        }
        outputStream.write(by);
        this.crc.update(by);
        if (n == 2) {
            outputStream.write(by2);
            this.crc.update(by2);
        }
    }

    protected void decodeBufferPrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) {
        this.sequence = 0;
    }

    protected int decodeLinePrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        this.crc.value = 0;
        do {
            int n;
            if ((n = pushbackInputStream.read(this.tmp, 0, 1)) != -1) continue;
            throw new CEStreamExhausted();
        } while (this.tmp[0] != 42);
        this.lineAndSeq.reset();
        this.decodeAtom(pushbackInputStream, this.lineAndSeq, 2);
        byte[] byArray = this.lineAndSeq.toByteArray();
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        if (n2 != this.sequence) {
            throw new CEFormatException("UCDecoder: Out of sequence line.");
        }
        this.sequence = this.sequence + 1 & 0xFF;
        return n;
    }

    protected void decodeLineSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        int n = this.crc.value;
        this.lineAndSeq.reset();
        this.decodeAtom(pushbackInputStream, this.lineAndSeq, 2);
        byte[] byArray = this.lineAndSeq.toByteArray();
        int n2 = (byArray[0] << 8 & 0xFF00) + (byArray[1] & 0xFF);
        if (n2 != n) {
            throw new CEFormatException("UCDecoder: CRC check failed.");
        }
    }
}

