/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncKrbPrivPart {
    public byte[] userData;
    public KerberosTime timestamp;
    public Integer usec;
    public Integer seqNumber;
    public HostAddress sAddress;
    public HostAddress rAddress;

    public EncKrbPrivPart(byte[] byArray, KerberosTime kerberosTime, Integer n2, Integer n3, HostAddress hostAddress, HostAddress hostAddress2) {
        if (byArray != null) {
            this.userData = (byte[])byArray.clone();
        }
        this.timestamp = kerberosTime;
        this.usec = n2;
        this.seqNumber = n3;
        this.sAddress = hostAddress;
        this.rAddress = hostAddress2;
    }

    public EncKrbPrivPart(byte[] byArray) throws Asn1Exception, IOException {
        this.a(new DerValue(byArray));
    }

    public EncKrbPrivPart(DerValue derValue) throws Asn1Exception, IOException {
        this.a(derValue);
    }

    private void a(DerValue derValue) throws Asn1Exception, IOException {
        if ((derValue.getTag() & 0x1F) != 28 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.userData = derValue3.getData().getOctetString();
        this.timestamp = KerberosTime.parse(derValue2.getData(), (byte)1, true);
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            this.usec = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.usec = null;
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 3) {
            derValue3 = derValue2.getData().getDerValue();
            this.seqNumber = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.seqNumber = null;
        }
        this.sAddress = HostAddress.parse(derValue2.getData(), (byte)4, false);
        if (derValue2.getData().available() > 0) {
            this.rAddress = HostAddress.parse(derValue2.getData(), (byte)5, true);
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOctetString(this.userData);
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream);
        if (this.timestamp != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.timestamp.asn1Encode());
        }
        if (this.usec != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(BigInteger.valueOf(this.usec.intValue()));
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream);
        }
        if (this.seqNumber != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.seqNumber);
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.sAddress.asn1Encode());
        if (this.rAddress != null) {
            derOutputStream2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.rAddress.asn1Encode());
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)28), derOutputStream);
        return derOutputStream2.toByteArray();
    }
}

