/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public class SmudgedChars {
    private char fudgeFactor;
    private char[] contents;
    private String provider = null;
    private static Random generator;
    private static Debug debug;
    private static String className;

    public SmudgedChars(char[] cArray) {
        byte[] byArray = new byte[2];
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SmudgedChars", (Object)cArray);
        }
        do {
            generator.nextBytes(byArray);
            this.fudgeFactor = (char)(byArray[0] * 256 + byArray[1]);
        } while (this.fudgeFactor == '\u0000');
        this.contents = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.contents[i] = (char)(cArray[i] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedChars");
        }
    }

    public SmudgedChars(char[] cArray, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "SmudgedChars", cArray, string);
        }
        byte[] byArray = new byte[2];
        if (string != null) {
            this.provider = new String(string);
        }
        do {
            generator.nextBytes(byArray);
            this.fudgeFactor = (char)(byArray[0] * 256 + byArray[1]);
        } while (this.fudgeFactor == '\u0000');
        this.contents = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            this.contents[i] = (char)(cArray[i] + this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, className, "SmudgedChars");
        }
    }

    public char[] getClearText() {
        char[] cArray = new char[this.contents.length];
        if (debug != null) {
            debug.entry(16384L, className, "getClearText");
        }
        for (int i = 0; i < this.contents.length; ++i) {
            cArray[i] = (char)(this.contents[i] - this.fudgeFactor);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getClearText", cArray);
        }
        return cArray;
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
        }
        if (this.contents != null) {
            Arrays.fill(this.contents, ' ');
            this.contents = null;
        }
        if (debug != null) {
            debug.exit(16384L, className, "finalize");
        }
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.pkcsutil.SmudgedChars";
        generator = new Random(new Date().getTime());
    }
}

