/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.tools;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.Data;
import com.ibm.security.pkcs7.EncapsulatedContentInfo;
import com.ibm.security.pkcs7.EnvelopedData;
import com.ibm.security.pkcs7.SignedData;
import com.ibm.security.pkcs7.SignerInfo;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.smime.SMIMEMessage;
import com.ibm.security.x509.X509CertImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class parsePKCS7 {
    public static void main(String[] stringArray) {
        String string;
        block40: {
            string = null;
            String string2 = null;
            boolean bl = false;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            char[] cArray = null;
            String string6 = null;
            boolean bl2 = false;
            try {
                Object object;
                FileInputStream fileInputStream;
                Object object2;
                if (stringArray.length < 1) {
                    System.out.println("Usage: parsePKCS7 -file=PKCS7FileName [-msg=OriginalMessageFile] [-base64] [-bsmime]\r\n\t[-cert=certificateFile] [-recipientcert=recipientCertFilename]\r\n\t[-privatekey=privatekeyfile] [-password=privatekeyPassword]");
                    System.exit(1);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    object2 = stringArray[i].toLowerCase();
                    boolean bl3 = false;
                    if (((String)object2).startsWith("-file=")) {
                        string = stringArray[i].substring(6);
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-msg=")) {
                        string2 = stringArray[i].substring(5);
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-base64")) {
                        bl = true;
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-bsmime")) {
                        bl2 = true;
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-recipientcert=")) {
                        string6 = stringArray[i].substring(15);
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-cert=")) {
                        string3 = stringArray[i].substring(6);
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-privatekey=")) {
                        string4 = stringArray[i].substring(12);
                        bl3 = true;
                    }
                    if (((String)object2).startsWith("-password=")) {
                        string5 = stringArray[i].substring(10);
                        cArray = string5.toCharArray();
                        bl3 = true;
                    }
                    if (bl3) continue;
                    System.out.println("ERROR:  Unknown parameter " + stringArray[i] + ".");
                    System.exit(1);
                }
                if (string == null) {
                    System.out.println("ERROR:  input file must be specified.");
                    System.exit(1);
                }
                System.out.println("parsePKCS7 invoked with:");
                System.out.println("\tInput file = " + string);
                System.out.println("\tInput file in Base64 format = " + bl);
                System.out.println("\tSignedData parameters:");
                System.out.println("\t\tOriginal message file = " + string2);
                System.out.println("\tEnvelopedData parameters:");
                System.out.println("\t\tCertificate file = " + string3);
                System.out.println("\t\tPrivate key file = " + string4);
                System.out.println("\t\tPrivate key password = " + string5);
                System.out.println("\t\tRecipient Certificate file = " + string6);
                System.out.println("\t\tParse contained S/MIME message = " + bl2);
                ContentInfo contentInfo = new ContentInfo(string, bl);
                System.out.println("PKCS#7 object:");
                System.out.println(contentInfo);
                object2 = null;
                if (string2 != null) {
                    FileInputStream fileInputStream2 = new FileInputStream(string2);
                    object2 = new byte[fileInputStream2.available()];
                    fileInputStream2.read((byte[])object2);
                    fileInputStream2.close();
                    System.out.println("\r\n**** Begin Message from file " + string2 + " ****");
                    try {
                        System.out.println(new String((byte[])object2, "8859_1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        System.out.println(new String((byte[])object2));
                    }
                    System.out.println("**** End Message from file " + string2 + " ****\r\n");
                }
                byte[] byArray = null;
                X509CertImpl x509CertImpl = null;
                if (string3 != null) {
                    fileInputStream = new FileInputStream(string3);
                    byArray = new byte[fileInputStream.available()];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    x509CertImpl = new X509CertImpl(byArray);
                }
                PrivateKey privateKey = null;
                if (string4 != null) {
                    if (string5 == null) {
                        System.out.println("Reading in the private key from " + string4);
                        fileInputStream = new FileInputStream(string4);
                        byArray = new byte[fileInputStream.available()];
                        fileInputStream.read(byArray);
                        fileInputStream.close();
                        privateKey = parsePKCS7.convertPrivateKey(byArray);
                    } else {
                        System.out.println("Reading in the encrypted private key from " + string4);
                        fileInputStream = new FileInputStream(string4);
                        byArray = new byte[fileInputStream.available()];
                        fileInputStream.read(byArray);
                        fileInputStream.close();
                        System.out.println("Decrypting the private key.");
                        object = new EncryptedPrivateKeyInfo(byArray);
                        byArray = ((EncryptedPrivateKeyInfo)object).decrypt(cArray);
                        privateKey = parsePKCS7.convertPrivateKey(byArray);
                    }
                }
                object = null;
                if (string6 == null) {
                    object = x509CertImpl;
                } else {
                    System.out.println("Reading in the recipient certificate from " + string6);
                    fileInputStream = new FileInputStream(string6);
                    byArray = new byte[fileInputStream.available()];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    object = new X509CertImpl(byArray);
                }
                System.out.println("Input object is of type: " + contentInfo.getContentTypeString());
                if (contentInfo.isSignedData()) {
                    parsePKCS7.verifySignedData(contentInfo, (byte[])object2);
                    break block40;
                }
                if (contentInfo.isEnvelopedData()) {
                    if (privateKey != null) {
                        System.out.println("Decrypting EnvelopedData ContentInfo with key of type " + privateKey.getClass().getName() + ".");
                        ContentInfo contentInfo2 = parsePKCS7.decryptEnvelopedData(contentInfo, privateKey, (Certificate)object);
                        if (contentInfo2 == null) {
                            System.out.println("Decrypted ContentInfo is null");
                            break block40;
                        }
                        if (contentInfo2.isData()) {
                            Data data = (Data)contentInfo2.getContent();
                            try {
                                System.out.println("Decrypted Content:\r\n" + new String(data.getData(), "8859_1"));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                System.out.println("Decrypted Content:\r\n" + new String(data.getData()));
                            }
                            if (bl2) {
                                SMIMEMessage sMIMEMessage = new SMIMEMessage(data.getData());
                                System.out.println("*** Contained SMIMEMessage:\r\n" + sMIMEMessage);
                                ContentInfo contentInfo3 = sMIMEMessage.getContentInfo();
                                if (contentInfo3 != null && !contentInfo3.isSignedData()) {
                                    System.out.println("*** Contained ContentInfo is of type " + contentInfo3.getContentTypeString());
                                } else if (contentInfo3 != null) {
                                    SignedData signedData = (SignedData)contentInfo3.getContent();
                                    byte[] byArray2 = sMIMEMessage.getMessage();
                                    System.out.println("*** Contained SignedData: " + signedData);
                                    if (byArray2 != null) {
                                        try {
                                            System.out.println("*** Verifying contained message:\r\n" + new String(byArray2, "8859_1"));
                                        }
                                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                                            System.out.println("*** Verifying contained message:\r\n" + new String(byArray2));
                                        }
                                    } else {
                                        System.out.println("*** Verifying contained message: null");
                                    }
                                    parsePKCS7.verifySignedData(contentInfo3, byArray2);
                                }
                            }
                            break block40;
                        }
                        System.out.println("Decrypted ContentInfo is of type " + contentInfo2.getContentTypeString());
                        break block40;
                    }
                    System.out.println("ERROR:  Private key must be specified to decrypt EnvelopedData ContentInfo.");
                    break block40;
                }
                System.out.println("No special processing for this content type.");
            }
            catch (PKCSException pKCSException) {
                System.out.println("\r\nERROR:  PKCSException: " + pKCSException);
                pKCSException.printStackTrace();
                Exception exception = pKCSException.getRelatedException();
                if (exception != null) {
                    System.out.println("\r\nOriginal PKCSException stack:");
                    exception.printStackTrace();
                } else {
                    System.out.println("\r\nNo Original PKCSException stack available");
                }
            }
            catch (Exception exception) {
                System.out.println("\r\nERROR:  Exception");
                exception.printStackTrace();
            }
        }
        System.out.println("EXIT:  parsePKCS7 input file = " + string);
    }

    static ContentInfo decryptEnvelopedData(ContentInfo contentInfo, PrivateKey privateKey, Certificate certificate) throws IOException, PKCSException {
        if (privateKey == null) {
            System.out.println("Cannot decrypt contents.  Private key not specified.");
            return null;
        }
        if (certificate == null) {
            System.out.println("Cannot decrypt contents.  Certificate not specified.");
            return null;
        }
        System.out.println("Certificate:\r\n" + certificate);
        System.out.println("Private key:\r\n" + privateKey);
        EnvelopedData envelopedData = (EnvelopedData)contentInfo.getContent();
        ContentInfo contentInfo2 = envelopedData.decrypt(privateKey, certificate);
        System.out.println("Decrypted ContentInfo:\r\n" + contentInfo2);
        return contentInfo2;
    }

    static void verifySignedData(ContentInfo contentInfo, byte[] byArray) throws IOException {
        System.out.println("SignedData .... verifying ...");
        SignedData signedData = (SignedData)contentInfo.getContent();
        EncapsulatedContentInfo encapsulatedContentInfo = signedData.getEncapsulatedContentInfo();
        byte[] byArray2 = encapsulatedContentInfo.getContent();
        System.out.println("**** BEGIN CONTENT ****");
        if (byArray2 != null) {
            try {
                System.out.println(new String(byArray2, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(new String(byArray2));
            }
        } else {
            System.out.println("N/A");
        }
        System.out.println("**** END CONTENT ****");
        Certificate[] certificateArray = signedData.getCertificates();
        int n = 0;
        if (certificateArray != null) {
            n = certificateArray.length;
        }
        if (n == 0) {
            System.out.println("No certificates to verify.");
            return;
        }
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        if (signerInfoArray == null || signerInfoArray.length == 0) {
            System.out.println("SignedData contains certificates only.  No verification will occur.");
            return;
        }
        if (byArray2 == null && byArray == null) {
            System.out.println("No content stored with the SignedData or passed in message to verify against.");
            return;
        }
        for (int i = 0; i < n; ++i) {
            Certificate certificate = certificateArray[i];
            System.out.println("Checking certificate[" + i + "].");
            try {
                if (signedData.verify(certificate, byArray)) {
                    System.out.println("SUCCESS:  Verified okay.");
                    return;
                }
                System.out.println("Verification failed for certificate[" + i + "].");
                parsePKCS7.examineError(signedData, certificate, byArray);
                continue;
            }
            catch (PKCSException pKCSException) {
                System.out.println("\r\nERROR:  PKCSException: " + pKCSException);
                pKCSException.printStackTrace();
                Exception exception = pKCSException.getRelatedException();
                if (exception != null) {
                    System.out.println("\r\nOriginal PKCSException stack:");
                    exception.printStackTrace();
                    continue;
                }
                System.out.println("\r\nNo Original PKCSException stack available");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("ERROR: " + exception);
                parsePKCS7.examineError(signedData, certificate, byArray);
            }
        }
        System.out.println("ERROR:  All verification failed.");
    }

    static void examineError(SignedData signedData, Certificate certificate, byte[] byArray) throws IOException {
        System.out.println("ERROR CONDITIONAL:");
        SignerInfo signerInfo = signedData.getSignerInfo(certificate);
        EncapsulatedContentInfo encapsulatedContentInfo = signedData.getEncapsulatedContentInfo();
        byte[] byArray2 = encapsulatedContentInfo.getContent();
        if (signerInfo == null) {
            System.out.println("\tCould not find a SignerInfo to match the certificate.");
            return;
        }
        byte[] byArray3 = byArray;
        if (byArray3 == null) {
            byArray3 = byArray2;
        }
        if (byArray3 == null) {
            System.out.println("\tNo content stored with the SignedData or passed in message to verify against.");
            return;
        }
        byte[] byArray4 = signerInfo.getMessageDigest();
        byte[] byArray5 = parsePKCS7.calculateMessageDigest(signerInfo, byArray3);
        if (byArray4 == null || byArray4.length == 0) {
            System.out.println("\tCannot retrieve the message digest bytes from the SignerInfo.");
            if (signerInfo.hasSignedAttributes()) {
                System.out.println("\t\tThere are signed attributes, but they do not include the message digest.");
            } else {
                System.out.println("\t\tThere are no signed attributes.");
                System.out.println("\t\tThe computed message digest as the bytes to be verified could\r\n\t\thave been rejected by the signature verification method.");
            }
            return;
        }
        if (byArray5 == null || byArray5.length == 0) {
            System.out.println("\tCannot calculate the message digest bytes from the message.");
            return;
        }
        if (byArray4.length != byArray5.length) {
            System.out.println("\tDigest lengths are not the same.");
            System.out.println("\t\tStored digest length = " + byArray4.length);
            System.out.println("\t\tCalculated digest length = " + byArray5.length);
            return;
        }
        for (int i = 0; i < byArray4.length; ++i) {
            if (byArray4[i] == byArray5[i]) continue;
            System.out.println("\tStored and calculated values are not the same.");
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            System.out.println("\tStored digest:\r\n" + hexDumpEncoder.encodeBuffer(byArray4));
            System.out.println("\tCalculated digest:\r\n" + hexDumpEncoder.encodeBuffer(byArray5));
            return;
        }
        System.out.println("\tStored and calculated digest values are the same.");
        System.out.println("\tThe problem might lie with the signature verification.");
    }

    static byte[] calculateMessageDigest(SignerInfo signerInfo, byte[] byArray) throws IOException {
        String string = signerInfo.getDigestAlgorithm().getName();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            System.out.println("ERROR: " + noSuchAlgorithmException);
            return null;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        return byArray2;
    }

    private static PrivateKey convertPrivateKey(byte[] byArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        return privateKey;
    }
}

