/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X500Signer;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public final class CertAndKeyGen {
    private SecureRandom prng;
    private String sigAlg;
    private KeyPairGenerator keyGen;
    private PublicKey publicKey;
    private PrivateKey privateKey;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertAndKeyGen";

    public CertAndKeyGen(String string, String string2) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(16384L, className, "CertAndKeyGen", string, string2);
        }
        this.keyGen = KeyPairGenerator.getInstance(string);
        this.sigAlg = string2;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public CertAndKeyGen(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            Object[] objectArray = new Object[]{string, string2, string3};
            debug.entry(16384L, (Object)className, "CertAndKeyGen", objectArray);
        }
        if (string3 != null) {
            this.provider = new String(string3);
            this.keyGen = KeyPairGenerator.getInstance(string, string3);
        } else {
            this.keyGen = KeyPairGenerator.getInstance(string);
        }
        this.sigAlg = string2;
        if (debug != null) {
            debug.exit(16384L, className, "CertAndKeyGen");
        }
    }

    public void setRandom(SecureRandom secureRandom) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "setRandom", secureRandom);
            debug.exit(16384L, className, "setRandom");
        }
        this.prng = secureRandom;
    }

    public void generate(int n) throws InvalidKeyException {
        KeyPair keyPair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", new Integer(n));
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(n, this.prng);
            keyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", exception);
            }
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public void generate(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        KeyPair keyPair;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generate", algorithmParameterSpec);
        }
        try {
            if (this.prng == null) {
                this.prng = new SecureRandom();
            }
            this.keyGen.initialize(algorithmParameterSpec, this.prng);
            keyPair = this.keyGen.generateKeyPair();
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "generate", exception);
            }
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        if (debug != null) {
            debug.exit(16384L, className, "generate");
        }
    }

    public X509Key getPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPublicKey");
        }
        if (!(this.publicKey instanceof X509Key)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getPublicKey_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getPublicKey_2", (X509Key)this.publicKey);
        }
        return (X509Key)this.publicKey;
    }

    public Key newGetPublicKey() {
        if (debug != null) {
            debug.entry(16384L, className, "newGetPublicKey");
            debug.exit(16384L, (Object)className, "newGetPublicKey", this.publicKey);
        }
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKey");
            debug.exit(16384L, (Object)className, "getPrivateKey", this.privateKey);
        }
        return this.privateKey;
    }

    public KeyPairGenerator getKeyPairGenerator() {
        if (debug != null) {
            debug.entry(16384L, className, "getKeyPairGenerator");
            debug.exit(16384L, (Object)className, "getKeyPairGenerator", this.keyGen);
        }
        return this.keyGen;
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, long l) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, className, "getSelfCertificate", x500Name, new Long(l));
            debug.exit(16384L, (Object)className, "getSelfCertificate", this.getSelfCertificate(x500Name, l, 2));
        }
        return this.getSelfCertificate(x500Name, l, 2);
    }

    public X509Certificate getSelfCertificate(X500Name x500Name, long l, int n) throws CertificateException, InvalidKeyException, SignatureException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Object object;
            if (debug != null) {
                object = new Object[]{x500Name, new Long(l), new Integer(n)};
                debug.entry(16384L, (Object)className, "getSelfCertificate", (Object[])object);
            }
            X500Signer x500Signer = this.getSigner(x500Name);
            Date date = new Date();
            Date date2 = new Date();
            date2.setTime(date2.getTime() + l * 1000L);
            object = new CertificateValidity(date, date2);
            X509CertInfo x509CertInfo = new X509CertInfo();
            if (n != 0 && n != 1 && n != 2) {
                x509CertInfo.set("version", new CertificateVersion(2));
            } else {
                x509CertInfo.set("version", new CertificateVersion(n));
            }
            x509CertInfo.set("serialNumber", new CertificateSerialNumber((int)(date.getTime() / 1000L)));
            AlgorithmId algorithmId = x500Signer.getAlgorithmId();
            x509CertInfo.set("algorithmID", new CertificateAlgorithmId(algorithmId));
            x509CertInfo.set("subject", new CertificateSubjectName(x500Name));
            x509CertInfo.set("key", new CertificateX509Key(this.publicKey));
            x509CertInfo.set("validity", object);
            x509CertInfo.set("issuer", new CertificateIssuerName(x500Signer.getSigner()));
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            if (this.provider == null) {
                x509CertImpl.sign(this.privateKey, this.sigAlg);
            } else {
                x509CertImpl.sign(this.privateKey, this.sigAlg, this.provider);
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getSelfCertificate", x509CertImpl);
            }
            return x509CertImpl;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.exception(16384L, className, "getSelfCertificate", iOException);
            }
            throw new CertificateEncodingException("getSelfCert: " + iOException.getMessage());
        }
    }

    public CertificationRequest getCertRequest(X500Name x500Name) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertRequest", x500Name);
        }
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, this.publicKey, null, this.provider);
        CertificationRequest certificationRequest2 = new CertificationRequest(certificationRequestInfo, this.provider);
        try {
            certificationRequest = certificationRequest2.sign(this.sigAlg, this.privateKey);
        }
        catch (PKCSException pKCSException) {
            if (debug != null) {
                debug.exception(16384L, className, "getCertRequest", pKCSException);
            }
            throw new SignatureException(this.sigAlg + " PKCSException");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getCertRequest", certificationRequest);
        }
        return certificationRequest;
    }

    private X500Signer getSigner(X500Name x500Name) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
        Signature signature = null;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getSigner", x500Name);
        }
        signature = this.provider != null ? Signature.getInstance(this.sigAlg, this.provider) : Signature.getInstance(this.sigAlg);
        signature.initSign(this.privateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getSigner", new X500Signer(signature, x500Name));
        }
        return new X500Signer(signature, x500Name);
    }
}

