/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.misc.Debug;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class SHA
extends MessageDigestSpi
implements Cloneable {
    private static final int SHA_LENGTH = 20;
    private Hash sha;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.SHA";

    public SHA() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SHA");
        }
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "SHA");
        }
    }

    private SHA(SHA sHA) {
        this.sha = (Hash)sHA.sha.clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SHA", (Object)this.sha);
            debug.exit(16384L, (Object)className, "SHA");
        }
    }

    public void init() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        this.sha = new Hash(544);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineReset");
        }
        this.sha.engineReset();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineReset");
        }
    }

    protected int engineGetDigestLength() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetDigestLength");
            debug.exit(16384L, (Object)className, "engineGetDigestLength");
        }
        return 20;
    }

    protected synchronized void engineUpdate(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)(" " + by));
        }
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n).toString(), new Integer(n2).toString()};
            debug.entry(16384L, (Object)className, "engineUpdate", objectArray);
        }
        this.sha.engineUpdate(byArray, n, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDigest");
        }
        byte[] byArray = this.sha.engineDigest();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (debug != null) {
            Object[] objectArray = new Object[]{byArray, new Integer(n).toString(), new Integer(n2).toString()};
            debug.entry(16384L, (Object)className, "engineDigest", objectArray);
        }
        int n3 = this.sha.engineDigest(byArray, n, n2);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return n3;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "clone");
        }
        SHA sHA = null;
        try {
            sHA = (SHA)super.clone();
            sHA.sha = (Hash)this.sha.clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone");
            }
            return sHA;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            block4: {
                if (debug == null) break block4;
                debug.exception(16384L, (Object)className, "clone", (Throwable)cloneNotSupportedException);
            }
            return sHA;
        }
    }
}

