/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapName;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;

class ServiceLocator {
    private static final String SRV_RR = "SRV";
    private static final String[] SRV_RR_ATTR = new String[]{"SRV"};
    private static final Random random = new Random();

    private ServiceLocator() {
    }

    static String mapDnToDomainName(String string) throws InvalidNameException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        LdapName ldapName = new LdapName(string);
        int n = ldapName.size() - 1;
        while (n >= 0) {
            String string2 = ldapName.get(n);
            if (string2.indexOf(43) == -1 && "dc=".equalsIgnoreCase(string2.substring(0, 3))) {
                Object object = LdapName.unescapeAttributeValue(string2.substring(3));
                if (object instanceof String) {
                    if (object.equals(".") || stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                        stringBuffer.setLength(0);
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(object);
                } else {
                    stringBuffer.setLength(0);
                }
            } else {
                stringBuffer.setLength(0);
            }
            --n;
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    static String[] getLdapService(String string, Hashtable hashtable) {
        String[] stringArray;
        block9: {
            if (string == null || string.length() == 0) {
                return null;
            }
            String string2 = "dns:///_ldap._tcp." + string;
            stringArray = null;
            try {
                Attribute attribute;
                Context context = NamingManager.getURLContext("dns", hashtable);
                if (!(context instanceof DirContext)) {
                    return null;
                }
                Attributes attributes = ((DirContext)context).getAttributes(string2, SRV_RR_ATTR);
                if (attributes == null || (attribute = attributes.get(SRV_RR)) == null) break block9;
                int n = attribute.size();
                int n2 = 0;
                Object[] objectArray = new SrvRecord[n];
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    try {
                        objectArray[n4] = new SrvRecord((String)attribute.get(n3));
                        ++n4;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n3;
                }
                n2 = n4;
                if (n2 < n) {
                    SrvRecord[] srvRecordArray = new SrvRecord[n2];
                    System.arraycopy(objectArray, 0, srvRecordArray, 0, n2);
                    objectArray = srvRecordArray;
                }
                if (n2 > 1) {
                    Arrays.sort(objectArray);
                }
                stringArray = ServiceLocator.extractHostports((SrvRecord[])objectArray);
            }
            catch (NamingException namingException) {}
        }
        return stringArray;
    }

    private static String[] extractHostports(SrvRecord[] srvRecordArray) {
        String[] stringArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < srvRecordArray.length) {
            if (stringArray == null) {
                stringArray = new String[srvRecordArray.length];
            }
            n = n5;
            while (n5 < srvRecordArray.length - 1 && srvRecordArray[n5].priority == srvRecordArray[n5 + 1].priority) {
                ++n5;
            }
            n2 = n5;
            n3 = n2 - n + 1;
            int n6 = 0;
            while (n6 < n3) {
                stringArray[n4++] = ServiceLocator.selectHostport(srvRecordArray, n, n2);
                ++n6;
            }
            ++n5;
        }
        return stringArray;
    }

    private static String selectHostport(SrvRecord[] srvRecordArray, int n, int n2) {
        if (n == n2) {
            return srvRecordArray[n].hostport;
        }
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (srvRecordArray[n4] != null) {
                srvRecordArray[n4].sum = n3 += srvRecordArray[n4].weight;
            }
            ++n4;
        }
        String string = null;
        int n5 = n3 == 0 ? 0 : random.nextInt(n3 + 1);
        int n6 = n;
        while (n6 <= n2) {
            if (srvRecordArray[n6] != null && srvRecordArray[n6].sum >= n5) {
                string = srvRecordArray[n6].hostport;
                srvRecordArray[n6] = null;
                break;
            }
            ++n6;
        }
        return string;
    }

    static class SrvRecord
    implements Comparable {
        int priority;
        int weight;
        int sum;
        String hostport;

        SrvRecord(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() != 4) {
                throw new IllegalArgumentException();
            }
            this.priority = Integer.parseInt(stringTokenizer.nextToken());
            this.weight = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            this.hostport = stringTokenizer.nextToken() + ":" + string2;
        }

        public int compareTo(Object object) {
            SrvRecord srvRecord = (SrvRecord)object;
            if (this.priority > srvRecord.priority) {
                return 1;
            }
            if (this.priority < srvRecord.priority) {
                return -1;
            }
            if (this.weight == 0 && srvRecord.weight != 0) {
                return -1;
            }
            if (this.weight != 0 && srvRecord.weight == 0) {
                return 1;
            }
            return 0;
        }
    }
}

