/**INC+***********************************************************************/
/*                                                                           */
/* Include: values_c.h                                                       */
/*                                                                           */
/* Purpose: Standard include file for API libraries, which contains all the  */
/*                                                                           */
/*          - opcode values                                                  */
/*          - return codes                                                   */
/*          - option codes                                                   */
/*                                                                           */
/* (C) COPYRIGHT DATA CONNECTION LIMITED 1989-2005                           */
/*                                                                           */
/**INC-***********************************************************************/

#ifndef VALUES_C_INCLUDED
#define VALUES_C_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************/
/* Define external interface standard types.  These maintain their sizes on  */
/* all UNIX OSs (including 64 bit - as the only 64 bit OS we currently       */
/* support has 32-bit ints).                                                 */
/*****************************************************************************/
#define AP_UINT16     unsigned short
#define AP_INT16      short
#define AP_UINT32     unsigned int
#define AP_INT32      int

/*****************************************************************************/
/* AP_CORR correlator type                                                   */
/*****************************************************************************/
typedef union ap_corr
{
  void            *corr_p;           /* Pointer type                         */
  AP_UINT32        corr_l;           /* Unsigned long type                   */
  AP_INT32         corr_i;           /* Int type                             */
} AP_CORR;

/*****************************************************************************/
/* Primary return codes                                                      */
/*****************************************************************************/
#define  AP_OK                                    (0x0000)
#define  AP_PARAMETER_CHECK                       (0x0100)
#define  AP_STATE_CHECK                           (0x0200)
#define  AP_ALLOCATION_ERROR                      (0x0300)
#define  AP_DEALLOC_ABEND                         (0x0500)
#define  AP_DEALLOC_ABEND_PROG                    (0x0600)
#define  AP_DEALLOC_ABEND_SVC                     (0x0700)
#define  AP_DEALLOC_ABEND_TIMER                   (0x0800)
#define  AP_DEALLOC_NORMAL                        (0x0900)
#define  AP_PROG_ERROR_NO_TRUNC                   (0x0C00)
#define  AP_PROG_ERROR_TRUNC                      (0x0D00)
#define  AP_PROG_ERROR_PURGING                    (0x0E00)
#define  AP_CONV_FAILURE_RETRY                    (0x0F00)
#define  AP_CONV_FAILURE_NO_RETRY                 (0x1000)
#define  AP_SVC_ERROR_NO_TRUNC                    (0x1100)
#define  AP_SVC_ERROR_TRUNC                       (0x1200)
#define  AP_SVC_ERROR_PURGING                     (0x1300)
#define  AP_UNSUCCESSFUL                          (0x1400)
#define  AP_CNOS_PARTNER_LU_REJECT                (0x1800)
#define  AP_CONVERSATION_TYPE_MIXED               (0x1900)
#define  AP_NODE_STOPPING                         (0x1A00)
#define  AP_NODE_NOT_STARTED                      (0x1B00)
#define  AP_CANCELLED                             (0x2100)
#define  AP_BACKED_OUT                            (0x2200)
#define  AP_DUPLEX_TYPE_MIXED                     (0x2300)
#define  AP_LS_FAILURE                            (0x2300)
#define  AP_OPERATION_INCOMPLETE                  (0x4000)
#define  AP_OPERATION_NOT_ACCEPTED                (0x4100)
#define  AP_CONVERSATION_ENDED                    (0x4200)
#define  AP_ERROR_INDICATION                      (0x4300)
#define  AP_EXPD_NOT_SUPPORTED_BY_LU              (0x4400)
#define  AP_BUFFER_TOO_SMALL                      (0x4500)
#define  AP_MEMORY_ALLOCATION_FAILURE             (0x4600)

#define  AP_INDICATION                            (0x0210)
#define  AP_ACTIVATION_FAIL_RETRY                 (0x0310)
#define  AP_ACTIVATION_FAIL_NO_RETRY              (0x0410)
#define  AP_LU_SESS_LIMIT_EXCEEDED                (0x0510)
#define  AP_FUNCTION_NOT_SUPPORTED                (0x0610)

#define  AP_DATA_POSTING_BLOCKED                  (0x0810)
#define  AP_PATH_SWITCH_NOT_ALLOWED               (0x0910)
#define  AP_CP_CP_SESS_ACT_FAILURE                (0x0A10)
#define  AP_TP_BUSY                               (0x02F0)
#define  AP_COMM_SUBSYSTEM_ABENDED                (0x03F0)
#define  AP_COMM_SUBSYSTEM_NOT_LOADED             (0x04F0)
#define  AP_THREAD_BLOCKING                       (0x06F0)
#define  AP_INVALID_VERB_SEGMENT                  (0x08F0)
#define  AP_UNEXPECTED_DOS_ERROR                  (0x11F0)
#define  AP_UNEXPECTED_SYSTEM_ERROR               AP_UNEXPECTED_DOS_ERROR
#define  AP_STACK_TOO_SMALL                       (0x15F0)
#define  AP_INVALID_VERB                          (0xFFFF)

/*****************************************************************************/
/* These are only used in SNAP-IX (asynchronous APPC interface)              */
/*****************************************************************************/
#define  AP_MIXED_API_USED                        (0x16F0)
#define  AP_IN_PROGRESS                           (0x17F0)
#define  AP_COMPLETED                             (0x18F0)

/*****************************************************************************/
/* Secondary return codes                                                    */
/*****************************************************************************/
#define  AP_ALLOCATE_NOT_PENDING              (0x09050000L)
#define  AP_ALLOCATION_FAILURE_NO_RETRY       (0x04000000L)
#define  AP_ALLOCATION_FAILURE_RETRY          (0x05000000L)
#define  AP_INVALID_NODE_TYPE_FOR_HPR         (0xC8020000L)
#define  AP_BAD_CONV_ID                       (0x02000000L)
#define  AP_BAD_CONV_TYPE                     (0x11000000L)
#define  AP_BAD_ERROR_DIRECTION               (0x05010000L)
#define  AP_SEND_EXPD_INVALID_LENGTH          (0x24010000L)
#define  AP_RCV_EXPD_INVALID_LENGTH           (0x25010000L)
#define  AP_EXPD_BAD_RETURN_CONTROL           (0x26010000L)
#define  AP_EXPD_DATA_BAD_CONV_STATE          (0x27010000L)
#define  AP_BAD_LL                            (0xF1000000L)
#define  AP_BAD_REMOTE_LU_ALIAS               (0x03000002L)
#define  AP_BAD_RETURN_CONTROL                (0x14000000L)
#define  AP_BAD_RETURN_STATUS_WITH_DATA       (0xD7000000L)
#define  AP_BAD_SECURITY                      (0x13000000L)
#define  AP_BAD_SYNC_LEVEL                    (0x12000000L)
#define  AP_BAD_TP_ID                         (0x01000000L)
#define  AP_BAD_LU_ALIAS                      (0x03000000L)
#define  AP_BAD_DLOAD_ID                      (0x03000001L)
#define  AP_BAD_ATTACH_ID                     AP_BAD_DLOAD_ID
#define  AP_BAD_TYPE                          (0x50020000L)
#define  AP_BO_NO_RESYNC                      (0x00002408L)
#define  AP_BO_RESYNC                         (0x01002408L)
#define  AP_CANT_MODIFY_PORT_NAME             (0x04100000L)
#define  AP_CONFIRMED_BAD_STATE               (0x41000000L)
#define  AP_CONFIRMED_INVALID_FOR_FDX         (0x42000000L)
#define  AP_CONFIRM_BAD_STATE                 (0x32000000L)
#define  AP_CONFIRM_NOT_LL_BDY                (0x33000000L)
#define  AP_CONFIRM_INVALID_FOR_FDX           (0x34000000L)
#define  AP_CONFIRM_ON_SYNC_LEVEL_NONE        (0x31000000L)
#define  AP_COS_NAME_NOT_DEFD                 (0x10080000L)
#define  AP_CP_OR_SNA_SVCMG_UNDELETABLE       (0xF3010000L)
#define  AP_CPSVCMG_ALREADY_DEFD              (0x21020000L)
#define  AP_DEALLOC_BAD_TYPE                  (0x51000000L)
#define  AP_DEALLOC_CONFIRM_BAD_STATE         (0x53000000L)
#define  AP_DEALLOC_FLUSH_BAD_STATE           (0x52000000L)
#define  AP_DEALLOC_LOG_LL_WRONG              (0x57000000L)
#define  AP_DEALLOC_NOT_LL_BDY                (0x55000000L)
#define  AP_BAD_PARTNER_LU_ALIAS              (0x5B010000L)
#define  AP_DEF_PLU_INVALID_FQ_NAME           (0x74020000L)
#define  AP_DEL_MODE_DEFAULT_SPCD             (0xF4010000L)
#define  AP_DLC_ACTIVE                        (0x01100000L)
#define  AP_DUPLICATE                         (0x8D020000L)
#define  AP_DUPLICATE_CP_NAME                 (0x02100000L)
#define  AP_DUPLICATE_DEST_ADDR               (0x03100000L)
#define  AP_DUPLICATE_TG_NUMBER               (0x15530000L)
#define  AP_DLC_DEACTIVATING                  (0x86020000L)
#define  AP_ALREADY_STARTING                  (0xC0010000L)
#define  AP_DUPLICATE_PORT                    (0x10100000L)
#define  AP_DUPLICATE_PORT_NUMBER             (0x05100000L)
#define  AP_DUPLICATE_PORT_NAME               (0x06100000L)
#define  AP_FLUSH_NOT_SEND_STATE              (0x61000000L)
#define  AP_INVALID_AUTO_ACT_SUPP             (0xB5020000L)
#define  AP_INVALID_CN_NAME                   (0x21080000L)
#define  AP_INVALID_CNOS_SLIM                 (0x17020000L)
#define  AP_INVALID_COS_SNASVCMG_MODE         (0x1C020000L)
#define  AP_INVALID_CP_NAME                   (0xCA010000L)
#define  AP_INVALID_DATA_TYPE                 (0x05070000L)
#define  AP_INVALID_DEFAULT_RU_SIZE           (0x1D020000L)
#define  AP_INVALID_DLC                       (0x10050000L)
#define  AP_INVALID_DLC_NAME                  (0x07100000L)
#define  AP_INVALID_DLC_TYPE                  (0x08100000L)
#define  AP_INVALID_DUPLEX_SUPPORT            (0x17900000L)
#define  AP_INVALID_FQ_LU_NAME                (0xFD010000L)
#define  AP_INVALID_FQ_OWNING_CP_NAME         (0xDB020000L)
#define  AP_INVALID_LIMITED_RESOURCE          (0xCE010000L)
#define  AP_INVALID_LINK_ACTIVE_LIMIT         (0x09100000L)
#define  AP_INVALID_LINK_NAME                 (0xC1010000L)
#define  AP_INVALID_LINK_NAME_SPECIFIED       (0xB0020000L)
#define  AP_INVALID_LINK_ENABLE               (0xBA020000L)
#define  AP_INVALID_CLU_COMPRESSION           (0xBB020000L)
#define  AP_INVALID_DLUR_SUPPORT              (0xBC020000L)
#define  AP_INVALID_LU_ALIAS                  (0xB1020000L)
#define  AP_INVALID_MAX_NEGOT_SESS_LIM        (0x14020000L)
#define  AP_INVALID_MIN_CONWINNERS            (0x1E020000L)
#define  AP_INVALID_MODE_NAME                 (0x15020000L)
#define  AP_INVALID_NAME_LEN                  (0xC5020000L)
#define  AP_INVALID_NETID_LEN                 (0xC6020000L)
#define  AP_INVALID_MAX_DECOMPRESS_LVL        (0xC9020000L)
#define  AP_INVALID_COMP_IN_SERIES            (0xCA020000L)
#define  AP_INVALID_NODE_TYPE                 (0xC4020000L)
#define  AP_INVALID_NUM_LS_SPECIFIED          (0xB2020000L)
#define  AP_INVALID_NUM_PORTS_SPECIFIED       (0x0B100000L)
#define  AP_INVALID_NUMBER_OF_NODE_ROWS       (0x02080000L)
#define  AP_INVALID_NUMBER_OF_TG_ROWS         (0x09080000L)
#define  AP_INVALID_PORT_NAME                 (0x0C100000L)
#define  AP_INVALID_PORT_TYPE                 (0x0D100000L)
#define  AP_INVALID_RECV_PACING_WINDOW        (0x16020000L)
#define  AP_INVALID_TARGET_PACING_CNT         (0x18020000L)
#define  AP_INVALID_TG_NUMBER                 (0x15500000L)
#define  AP_INVALID_MAX_RU_SIZE_UPPER         (0x19020000L)
#define  AP_INVALID_SET_PROT                  (0x00070000L)
#define  AP_INVALID_NEW_PROT                  (0x01070000L)
#define  AP_INVALID_SET_UNPROT                (0x02070000L)
#define  AP_INVALID_NEW_UNPROT                (0x03070000L)
#define  AP_INVALID_SET_USER                  (0x04070000L)
#define  AP_INVALID_SNASVCMG_MODE_LIMIT       (0x1A020000L)
#define  AP_INVALID_WILDCARD_NAME             (0x8C020000L)
#define  AP_INVALID_STATS_TYPE                (0x06070000L)
#define  AP_INVALID_TABLE_TYPE                (0x07070000L)
#define  AP_LINK_ACT_BY_LOCAL                 (0x15100000L)
#define  AP_LINK_ACT_BY_REMOTE                (0x14100000L)
#define  AP_LINK_DEACTIVATED                  (0x13100000L)
#define  AP_PARTNER_NOT_FOUND                 (0x13200000L)
#define  AP_PARTNER_NOT_RESPONDING            (0x13300000L)
#define  AP_ERROR                             (0x13400000L)
#define  AP_LINK_DEACT_IN_PROGRESS            (0x12100000L)
#define  AP_LINK_NOT_DEFD                     (0x17100000L)
#define  AP_LOCAL_CP_NAME                     (0xD7010000L)
#define  AP_LS_ACTIVE                         (0xDA010000L)
#define  AP_MISSING_CP_NAME                   (0x15510000L)
#define  AP_MISSING_CP_TYPE                   (0x15520000L)
#define  AP_INVALID_CP_TYPE                   (0x15520000L)
#define  AP_MISSING_TG_NUMBER                 (0x15550000L)
#define  AP_MODE_NAME_NOT_DEFD                (0xF5010000L)
#define  AP_MODE_SESS_LIM_EXCEEDS_NEG         (0x20020000L)
#define  AP_MODE_UNDELETABLE                  (0xF6010000L)
#define  AP_NO_PORTS_DEFINED_ON_DLC           (0x0F100000L)
#define  AP_NO_USE_OF_SNASVCMG                (0x17000000L)
#define  AP_NODE_ROW_WGT_LESS_THAN_LAST       (0x04080000L)
#define  AP_PARALLEL_TGS_NOT_ALLOWED          (0x15570000L)
#define  AP_PIP_LEN_INCORRECT                 (0x16000000L)
#define  AP_PORT_ACTIVE                       (0x0E100000L)
#define  AP_PORT_DEACTIVATED                  (0x08070000L)
#define  AP_INVALID_SET_PASSWORD              (0x09070000L)
#define  AP_PS_CREATION_FAILURE               (0x18100000L)
#define  AP_P_TO_R_INVALID_TYPE               (0xA1000000L)
#define  AP_P_TO_R_NOT_LL_BDY                 (0xA2000000L)
#define  AP_P_TO_R_NOT_SEND_STATE             (0xA3000000L)
#define  AP_P_TO_R_INVALID_FOR_FDX            (0xA5000000L)
#define  AP_RCV_AND_POST_BAD_FILL             (0xD5000000L)
#define  AP_RCV_AND_POST_BAD_STATE            (0xD1000000L)
#define  AP_RCV_AND_POST_NOT_LL_BDY           (0xD2000000L)
#define  AP_RCV_AND_WAIT_BAD_FILL             (0xB5000000L)
#define  AP_RCV_AND_WAIT_BAD_STATE            (0xB1000000L)
#define  AP_RCV_AND_WAIT_NOT_LL_BDY           (0xB2000000L)
#define  AP_RCV_IMMD_BAD_FILL                 (0xC4000000L)
#define  AP_RCV_IMMD_BAD_STATE                (0xC1000000L)
#define  AP_R_T_S_BAD_STATE                   (0xE1000000L)
#define  AP_R_T_S_INVALID_FOR_FDX             (0xE2000000L)
#define  AP_SECURITY_NOT_VALID                (0x51600F08L)
#define  AP_SEND_DATA_CONFIRM_SYNC_NONE       (0xF5000000L)
#define  AP_SEND_DATA_INVALID_TYPE            (0xF4000000L)
#define  AP_SEND_DATA_NOT_LL_BDY              (0xF6000000L)
#define  AP_SEND_TYPE_INVALID_FOR_FDX         (0xF7000000L)
#define  AP_SEND_DATA_NOT_SEND_STATE          (0xF2000000L)
#define  AP_SEND_ERROR_BAD_TYPE               (0x03010000L)
#define  AP_SEND_ERROR_BAD_STATE              (0x04010000L)
#define  AP_SEND_ERROR_LOG_LL_WRONG           (0x02010000L)
#define  AP_SNA_DEFD_COS_CANT_BE_CHANGE       (0x0A080000L)
#define  AP_SNA_DEFD_COS_CANT_BE_CHANGED      (0x0A080000L)
#define  AP_SNA_DEFD_COS_CANT_BE_DELETE       (0x11080000L)
#define  AP_SNA_DEFD_COS_CANT_BE_DELETED      (0x11080000L)
#define  AP_STOP_PORT_PENDING                 (0x11100000L)
#define  AP_TEST_INVALID_FOR_FDX              (0x23010000L)
#define  AP_TG_NUMBER_IN_USE                  (0x15540000L)
#define  AP_TG_ROW_WGT_LESS_THAN_LAST         (0x05080000L)
#define  AP_TRANS_PGM_NOT_AVAIL_NO_RETRY      (0x00004C08L)
#define  AP_TRANS_PGM_NOT_AVAIL_RETRY         (0x31604B08L)
#define  AP_TP_NAME_NOT_RECOGNIZED            (0x21600810L)
#define  AP_SYSTEM_TP_CANT_BE_CHANGED         (0x22600810L)
#define  AP_SYSTEM_TP_CANT_BE_DELETED         (0x23600810L)
#define  AP_INVALID_CONV_TYPE                 (0xA1020000L)
#define  AP_INVALID_SYNC_LEVEL                (0xA3020000L)
#define  AP_INVALID_DYNAMIC_LOAD              (0x24600810L)
#define  AP_INVALID_ENABLED                   (0x25600810L)
#define  AP_INVALID_PIP_ALLOWED               (0x26600810L)
#define  AP_UNKNOWN_PARTNER_MODE              (0x18000000L)
#define  AP_BAD_DUPLEX_TYPE                   (0x22000000L)
#define  AP_FDX_NOT_SUPPORTED_BY_LU           (0x23000000L)
#define  AP_UNRECOGNIZED_DEACT_TYPE           (0x0E050000L)
#define  AP_LU_NAME_WILDCARD_NAME_CLASH       (0x8E020000L)
#define  AP_TP_ACTIVE                         (0x19100000L)
#define  AP_MODE_ACTIVE                       (0x1A100000L)
#define  AP_PLU_ACTIVE                        (0x1B100000L)
#define  AP_INVALID_PLU_NAME                  (0x1C100000L)
#define  AP_INVALID_SET_NEGOTIABLE            (0x1D100000L)
#define  AP_INVALID_MODE_NAME_SELECT          (0x1E100000L)
#define  AP_INVALID_RESPONSIBLE               (0x1F100000L)
#define  AP_INVALID_DRAIN_SOURCE              (0x20100000L)
#define  AP_INVALID_DRAIN_TARGET              (0x21100000L)
#define  AP_INVALID_FORCE                     (0x22100000L)
#define  AP_INVALID_CLEANUP_TYPE              (0x24100000L)
#define  AP_INVALID_COS_NAME                  (0x25100000L)
#define  AP_INVALID_SESSION_LIMIT             (0x26100000L)
#define  AP_INVALID_DRAIN                     (0x27100000L)
#define  AP_INVALID_PRLL_SESS_SUPP            (0x28100000L)
#define  AP_INVALID_LU_NAME                   (0x29100000L)
#define  AP_MODE_NOT_RESET                    (0x2A100000L)
#define  AP_MODE_RESET                        (0x2B100000L)
#define  AP_CNOS_REJECT                       (0x2C100000L)
#define  AP_CNOS_COMMAND_RACE_REJECT          (0x5F010000L)
#define  AP_CNOS_MODE_NAME_REJECT             (0x57010000L)
#define  AP_INVALID_OP_CODE                   (0x2D100000L)
#define  AP_EXCEEDS_MAX_ALLOWED               (0x5C010000L)
#define  AP_DEACT_CG_INVALID_CGID             (0x6C020000L)
#define  AP_INVALID_SESSION_ID                (0x12050000L)
#define  AP_INVALID_NN_SESSION_TYPE           (0x13050000L)
#define  AP_INVALID_SET_COLLECT_STATS         (0x14050000L)
#define  AP_INVALID_SET_COLLECT_NAMES         (0x15050000L)
#define  AP_INVALID_SET_COLLECT_RSCVS         (0x16050000L)
#define  AP_LU_NAU_ADDR_ALREADY_DEFD          (0x12020000L)
#define  AP_DIR_ENTRY_PARENT                  (0x38100000L)
#define  AP_NODE_ALREADY_STARTED              (0x39100000L)
#define  AP_NODE_FAILED_TO_START              (0x3A100000L)
#define  AP_LU_ALREADY_DEFINED                (0x3B100000L)
#define  AP_IMPLICIT_LU_DEFINED               (0x3C100000L)
#define  AP_PORT_INACTIVE                     (0x3D100000L)
#define  AP_ACTIVATION_LIMITS_REACHED         (0x3E100000L)
#define  AP_PARALLEL_TGS_NOT_SUPPORTED        (0x3F100000L)
#define  AP_DLC_INACTIVE                      (0x40100000L)
#define  AP_NO_LINKS_DEFINED                  (0x41100000L)
#define  AP_STOP_DLC_PENDING                  (0x42100000L)
#define  AP_INVALID_LS_ROLE                   (0x43100000L)
#define  AP_INVALID_BTU_SIZE                  (0x44100000L)
#define  AP_LAST_LINK_ON_ACTIVE_PORT          (0x45100000L)
#define  AP_DYNAMIC_LOAD_ALREADY_REGD         (0x46100000L)
#define  AP_INVALID_LIST_OPTION               (0x47100000L)
#define  AP_INVALID_RES_NAME                  (0x48100000L)
#define  AP_INVALID_RES_TYPE                  (0x49100000L)
#define  AP_INVALID_ADJ_NNCP_NAME             (0x4A100000L)
#define  AP_INVALID_NODE                      (0x4B100000L)
#define  AP_INVALID_ORIGIN_NODE               (0x4C100000L)
#define  AP_INVALID_TG                        (0x4D100000L)
#define  AP_INVALID_FQPCID                    (0x4E100000L)
#define  AP_INVALID_POOL_NAME                 (0x4F100000L)
#define  AP_INVALID_NAU_ADDRESS               (0x50100000L)
#define  AP_INVALID_ENABLE_POOL               (0x50300000L)
#define  AP_LU_NAME_POOL_NAME_CLASH           (0x51100000L)
#define  AP_INVALID_PRIORITY                  (0x52100000L)
#define  AP_INVALID_DNST_LU_NAME              (0x53100000L)
#define  AP_INVALID_HOST_LU_NAME              (0x54100000L)
#define  AP_PU_NOT_DEFINED                    (0x55100000L)
#define  AP_INVALID_PU_NAME                   (0x56100000L)
#define  AP_INVALID_PU_TYPE                   (0x56600000L)
#define  AP_INVALID_MAX_IFRM_RCVD             (0x57100000L)
#define  AP_INVALID_SYM_DEST_NAME             (0x58100000L)
#define  AP_INVALID_LENGTH                    (0x59100000L)
#define  AP_INVALID_ISR_THRESHOLDS            (0x5A100000L)
#define  AP_INVALID_NUM_LUS                   (0x5B100000L)
#define  AP_CANT_DELETE_ADJ_ENDNODE           (0x5C100000L)
#define  AP_INVALID_RESOURCE_TYPE             (0x5D100000L)
#define  AP_PU_CONC_NOT_SUPPORTED             (0x5E100000L)
#define  AP_DLUR_NOT_SUPPORTED                (0x5F100000L)
#define  AP_INVALID_RTP_CONNECTION            (0x60100000L)
#define  AP_PATH_SWITCH_IN_PROGRESS           (0x61100000L)
#define  AP_HPR_NOT_SUPPORTED                 (0x62100000L)
#define  AP_RTP_NOT_SUPPORTED                 (0x63100000L)
#define  AP_COS_TABLE_FULL                    (0x64100000L)
#define  AP_INVALID_DAYS_LEFT                 (0x65100000L)
#define  AP_ANYNET_NOT_SUPPORTED              (0x66100000L)
#define  AP_INVALID_DISCOVERY_SUPPORT         (0x67100000L)
#define  AP_CONVERSATION_TYPE_MISMATCH        (0x34600810L)
#define  AP_PIP_NOT_ALLOWED                   (0x31600810L)
#define  AP_SYNC_LEVEL_NOT_SUPPORTED          (0x41600810L)
#define  AP_PLU_ALIAS_CANT_BE_CHANGED         (0xB3020000L)
#define  AP_PLU_ALIAS_ALREADY_USED            (0xB4020000L)
#define  AP_CANT_DELETE_IMPLICIT_LU           (0xB6020000L)
#define  AP_LU_ALIAS_CANT_BE_CHANGED          (0xB8020000L)
#define  AP_LU_ALIAS_ALREADY_USED             (0xB9020000L)
#define  AP_UNKNOWN_USER                      (0x32100000L)
#define  AP_NO_PROFILES                       (0x33100000L)
#define  AP_TOO_MANY_PROFILES                 (0x36100000L)
#define  AP_INVALID_UPDATE_TYPE               (0x37100000L)
#define  AP_INVALID_USERID                    (0x90020000L)
#define  AP_INVALID_PASSWORD                  (0x91020000L)
#define  AP_INVALID_PROFILE                   (0x93020000L)
#define  AP_INVALID_DLUS_NAME                 (0x00900000L)
#define  AP_NO_DEFAULT_DLUS_DEFINED           (0x01900000L)
#define  AP_INVALID_PU_ID                     (0x02900000L)
#define  AP_PU_ALREADY_ACTIVATING             (0x03900000L)
#define  AP_PU_ALREADY_DEACTIVATING           (0x04900000L)
#define  AP_PU_ALREADY_ACTIVE                 (0x05900000L)
#define  AP_PU_NOT_ACTIVE                     (0x06900000L)
#define  AP_DLUS_REJECTED                     (0x07900000L)
#define  AP_DLUS_CAPS_MISMATCH                (0x08900000L)
#define  AP_PU_FAILED_ACTPU                   (0x09900000L)
#define  AP_PU_NOT_RESET                      (0x0A900000L)
#define  AP_PU_OWNS_LUS                       (0x0B900000L)
#define  AP_INVALID_FILTER_OPTION             (0x0C900000L)
#define  AP_INVALID_STOP_TYPE                 (0x0D900000L)
#define  AP_PU_ALREADY_DEFINED                (0x0E900000L)
#define  AP_DEPENDENT_LU_NOT_SUPPORTED        (0x0F900000L)
#define  AP_INVALID_DSPU_SERVICES             (0x10900000L)
#define  AP_DSPU_SERVICES_NOT_SUPPORTED       (0x11900000L)
#define  AP_INVALID_DSPU_NAME                 (0x12900000L)
#define  AP_DSPU_ALREADY_DEFINED              (0x13900000L)
#define  AP_INVALID_SOLICIT_SSCP_SESS         (0x14900000L)
#define  AP_INVALID_BACK_LEVEL_SUPPORT        (0x15000000L)
#define  AP_INVALID_BKUP_DLUS_NAME            (0x15900000L)
#define  AP_SEC_REQUESTED_NOT_SUPPORTED       (0x16900000L)
#define  AP_INVALID_EFFECTIVE_CAPACITY        (0x24080000L)
#define  AP_INVALID_TIME_COST                 (0xD6010000L)
#define  AP_INVALID_TP_NAME                   (0xA0020000L)
#define  AP_INVALID_BYTE_COST                 (0xD1010000L)
#define  AP_DEF_LINK_INVALID_SECURITY         (0x22080000L)
#define  AP_INVALID_PROPAGATION_DELAY         (0x23080000L)
#define  AP_INVALID_USER_DEF_1                (0xC3010000L)
#define  AP_INVALID_USER_DEF_2                (0xC4010000L)
#define  AP_INVALID_USER_DEF_3                (0xC5010000L)
#define  AP_AS_NEGOTIATED                     (0x07000000L)
#define  AP_AS_SPECIFIED                      (0x00000000L)
#define  AP_FORCED                            (0xB7020000L)
#define  AP_INVALID_LS_NAME                   (0xB7030000L)
#define  AP_INVALID_LFSID_SPECIFIED           (0xB7040000L)
#define  AP_INVALID_FILTER_TYPE               (0xB7050000L)
#define  AP_INVALID_MESSAGE_TYPE              (0xB7060000L)
#define  AP_CANT_DELETE_CP_LU                 (0xB7070000L)
#define  AP_ALL_RESOURCES_NOT_DEFINED         (0xB7090000L)
#define  AP_INVALID_LIST_TYPE                 (0xB70A0000L)
#define  AP_RESOURCE_NAME_NOT_ALLOWED         (0xB70B0000L)
#define  AP_LU_MODE_SESSION_LIMIT_ZERO        (0x5D010000L)
#define  AP_QUEUE_PROHIBITED                  (0x18900000L)
#define  AP_ALLOCATION_ERROR_PENDING          (0x00000300L)
#define  AP_DEALLOC_ABEND_PROG_PENDING        (0x00000600L)
#define  AP_DEALLOC_ABEND_SVC_PENDING         (0x00000700L)
#define  AP_DEALLOC_ABEND_TIMER_PENDING       (0x00000800L)
#define  AP_UNKNOWN_ERROR_TYPE_PENDING        (0x00001100L)
#define  AP_INVALID_SVCMG_LIMITS              (0x60010000L)
#define  AP_INVALID_PARTNER_LU                (0xFE010000L)
#define  AP_INVALID_LOCAL_LU                  (0xFF010000L)
#define  AP_INVALID_BYPASS_SECURITY           (0x22020000L)
#define  AP_INVALID_IMPLICIT_PLU_FORBID       (0x23020000L)
#define  AP_INVALID_SPECIFIC_SECURITY         (0x24020000L)
#define  AP_INVALID_DELAYED_LOGON             (0x25020000L)
#define  AP_INVALID_CNOS_PERMITTED            (0x26020000L)
#define  AP_PW_SUB_NOT_SUPP_ON_SESS           (0x26050000L)
#define  AP_SESSION_FAIL_ALREADY_REGD         (0x68100000L)
#define  AP_CANT_MODIFY_VISIBILITY            (0x69100000L)
#define  AP_CANT_MODIFY_WHEN_ACTIVE           (0x6A100000L)
#define  AP_INVALID_BASE_NUMBER               (0x6B100000L)
#define  AP_INVALID_NAME_ATTRIBUTES           (0x6C100000L)
#define  AP_NAU_ADDRESS_MISMATCH              (0x6D100000L)
#define  AP_POSTED_DATA                       (0x6E100000L)
#define  AP_POSTED_NO_DATA                    (0x6F100000L)
#define  AP_SEC_BAD_PROTOCOL_VIOLATION        (0x58600F08L)
#define  AP_INVALID_TEMPLATE_NAME             (0x19900000L)
#define  AP_CLASHING_NAU_RANGE                (0x1A900000L)
#define  AP_INVALID_NAU_RANGE                 (0x1B900000L)
#define  AP_INVALID_NUM_DSLU_TEMPLATES        (0x1C900000L)
#define  AP_GLOBAL_TIMEOUT_NOT_DEFINED        (0x1D900000L)
#define  AP_INVALID_RESOURCE_NAME             (0x1E900000L)
#define  AP_INVALID_DLUS_RETRY_TIMEOUT        (0x1F900000L)
#define  AP_INVALID_DLUS_RETRY_LIMIT          (0x20900000L)
#define  AP_INVALID_MIN_CONLOSERS             (0x21900000L)
#define  AP_INVALID_MAX_RU_SIZE_LOW           (0x22900000L)
#define  AP_INVALID_MAX_RECV_PACING_WIN       (0x23900000L)
#define  AP_RU_SIZE_LOW_UPPER_MISMATCH        (0x24900000L)
#define  AP_LU_ALREADY_ACTIVATING             (0x25900000L)
#define  AP_LU_DEACTIVATING                   (0x26900000L)
#define  AP_LU_ALREADY_ACTIVE                 (0x27900000L)
#define  AP_INVALID_MIN_CONTENTION_SUM        (0x28900000L)
#define  AP_COMPRESSION_NOT_SUPPORTED         (0x29900000L)
#define  AP_INVALID_MAX_COMPRESS_LVL          (0x2A900000L)
#define  AP_INVALID_COMPRESSION               (0x2B900000L)
#define  AP_INVALID_EXCEPTION_INDEX           (0x2C900000L)
#define  AP_INVALID_MAX_LS_EXCEPTION          (0x2D900000L)
#define  AP_INVALID_DISABLE                   (0x2E900000L)
#define  AP_INVALID_MODIFY_TEMPLATE           (0x2F900000L)
#define  AP_INVALID_ALLOW_TIMEOUT             (0x30900000L)
#define  AP_POST_ON_RECEIPT_BAD_FILL          (0x31900000L)
#define  AP_POST_ON_RECEIPT_BAD_STATE         (0x32900000L)
#define  AP_INVALID_HPR_SUPPORT               (0x33900000L)
#define  AP_INVALID_LU_MODEL                  (0x34900000L)
#define  AP_INVALID_MODEL_NAME                (0x35900000L)
#define  AP_INVALID_CRYPTOGRAPHY              (0x36900000L)
#define  AP_INVALID_CLU_CRYPTOGRAPHY          (0x37900000L)
#define  AP_INVALID_RESOURCE_TYPES            (0x38900000L)
#define  AP_CHECKSUM_FAILED                   (0x39900000L)
#define  AP_DATA_CORRUPT                      (0x3A900000L)
#define  AP_INVALID_RETRY_FLAGS               (0x3B900000L)
#define  AP_DELAYED_VERB_PENDING              (0x3C900000L)
#define  AP_DSLU_ACTIVE                       (0x3D900000L)
#define  AP_INVALID_BRANCH_LINK_TYPE          (0x3E900000L)
#define  AP_INVALID_BRNN_SUPPORT              (0x3F900000L)
#define  AP_BRNN_SUPPORT_MISSING              (0x40900000L)
#define  AP_INVALID_UPLINK                    (0x41900000L)
#define  AP_INVALID_DOWNLINK                  (0x42900000L)
#define  AP_INVALID_IMPLICIT_UPLINK           (0x43900000L)
#define  AP_INVALID_ROCP_NAME                 (0x44900000L)
#define  AP_INVALID_REG_WITH_NN               (0x45900000L)
#define  AP_LS_PENDING_RETRY                  (0x46900000L)
#define  AP_INVALID_COS_TABLE_VERSION         (0x47900000L)
#define  AP_CFRTP_REQUIRED_FOR_MLTG           (0x48900000L)
#define  AP_INVALID_MLTG_PAC_ALGORITHM        (0x49900000L)
#define  AP_LIM_RESRCE_INVALID_FOR_MLTG       (0x4A900000L)
#define  AP_AUTO_ACT_INVALID_FOR_MLTG         (0x4B900000L)
#define  AP_MLTG_LS_VISIBILITY_MISMATCH       (0x4C900000L)
#define  AP_SLTG_LINK_ACTIVE                  (0x4D900000L)
#define  AP_MLTG_LINK_PROPERTIES_DIFFER       (0x4E900000L)
#define  AP_INVALID_ADJ_CP_NAME               (0x4F900000L)
#define  AP_INVALID_SEND_TERM_SELF            (0x50900000L)
#define  AP_INVALID_TERM_METHOD               (0x51900000L)
#define  AP_INVALID_DISABLE_BRANCH_AWRN       (0x52900000L)
#define  AP_INVALID_SHARING_PROHIBITED        (0x53900000L)
#define  AP_INVALID_LINK_SPEC_FORMAT          (0x54900000L)
#define  AP_INVALID_CN_TYPE                   (0x55900000L)
#define  AP_INCONSISTENT_BEST_EFFORT          (0x56900000L)
#define  AP_INVALID_CN_TG                     (0x57900000L)
#define  AP_INVALID_LINK_SPEC_DATA            (0x58900000L)
#define  AP_DLC_UI_ONLY                       (0x59900000L)
#define  AP_ADJ_CP_WRONG_TYPE                 (0x5A900000L)
#define  AP_CP_CP_SESS_ALREADY_ACTIVE         (0x5B900000L)
#define  AP_NO_ACTIVE_CP_CP_LINK              (0x5C900000L)
#define  AP_INVALID_IMPL_APPN_LINKS_LEN       (0x5E900000L)
#define  AP_INVALID_LIMIT_ENABLE              (0x5F900000L)
#define  AP_INVALID_LS_ATTRIBUTE              (0x60900000L)
#define  AP_SOME_ENABLED                      (0x62900000L)
#define  AP_NONE_ENABLED                      (0x63900000L)
#define  AP_INCONSISTENT_IMPLICIT             (0x64900000L)
#define  AP_INVALID_PREFER_ACTIVE_DLUS        (0x65900000L)
#define  AP_INVALID_PERSIST_PIPE_SUPP         (0x66900000L)
#define  AP_ACTIVATION_PROHIBITED             (0x67900000L)
#define  AP_INVALID_NULL_ADDR_MEANING         (0x68900000L)
#define  AP_INVALID_CPLU_SYNCPT_SUPPORT       (0x69900000L)
#define  AP_INVALID_CPLU_ATTRIBUTES           (0x6A900000L)
#define  AP_INVALID_REG_LEN_SUPPORT           (0x6B900000L)
#define  AP_LUNAME_CGID_MISMATCH              (0x6C900000L)
#define  AP_INVALID_DDDLU_OFFLINE             (0x6D900000L)
#define  AP_SEC_BAD_PASSWORD_EXPIRED          (0x00FF0F08L)
#define  AP_SEC_BAD_PASSWORD_INVALID          (0x01FF0F08L)
#define  AP_SEC_BAD_USERID_REVOKED            (0x02FF0F08L)
#define  AP_SEC_BAD_USERID_INVALID            (0x03FF0F08L)
#define  AP_SEC_BAD_USERID_MISSING            (0x04FF0F08L)
#define  AP_SEC_BAD_PASSWORD_MISSING          (0x05FF0F08L)
#define  AP_SEC_BAD_GROUP_INVALID             (0x06FF0F08L)
#define  AP_SEC_BAD_UID_REVOKED_IN_GRP        (0x07FF0F08L)
#define  AP_SEC_BAD_UID_NOT_DEFD_TO_GRP       (0x08FF0F08L)
#define  AP_SEC_BAD_UNAUTHRZD_AT_RLU          (0x09FF0F08L)
#define  AP_SEC_BAD_UNAUTHRZD_FROM_LLU        (0x0AFF0F08L)
#define  AP_SEC_BAD_UNAUTHRZD_TO_TP           (0x0BFF0F08L)
#define  AP_SEC_BAD_INSTALL_EXIT_FAILED       (0x0CFF0F08L)
#define  AP_SEC_BAD_PROCESSING_FAILURE        (0x0DFF0F08L)

#define  AP_BAD_TPSID                         (0x01FF0000L)
#define  AP_NOT_OWNER                         (0x02FF0000L)
#define  AP_INSUFFICIENT_PRIVILEGES           (0x03FF0000L)
#define  AP_INVALID_CALLBACK                  (0x04FF0000L)
#define  AP_BAD_TP_TYPE                       (0x05FF0000L)
#define  AP_ALREADY_REGISTERED                (0x06FF0000L)

/*****************************************************************************/
/* Included for back-compatibility :                                         */
/*****************************************************************************/
#define  AP_ATTACH_MANAGER_INACTIVE           (0x08050000L)
#define  AP_CANNOT_START_TP                   (0x010000F0L)
#define  AP_INVALID_DATA_SEGMENT              (0x06000000L)
#define  AP_INVALID_PROCESS                   (0x25050000L)
#define  AP_LU_ALIAS_NOT_RECOGNIZED           (0x020000F0L)
#define  AP_PIP_NOT_SPECIFIED_CORRECTLY       (0x32600810L)
#define  AP_TOO_MANY_TPS                      (0x43020000L)
#define  AP_UNDEFINED_TP_NAME                 (0x06050000L)

#define  AP_INVALID_TG_CHARS                  (0x18030000L)
#define  AP_CANT_CHANGE_TO_ZERO               AP_LU_MODE_SESSION_LIMIT_ZERO

/*****************************************************************************/
/* Operation Codes                                                           */
/*****************************************************************************/
#define  AP_RECEIVE_ALLOCATE                      (0x0016)
#define  AP_RECEIVE_ALLOCATE_EX                   (0xF103)
#define  AP_TP_ENDED                              (0x0013)
#define  AP_TP_STARTED                            (0x0014)

#define  AP_B_ALLOCATE                            (0x0001)
#define  AP_B_CONFIRM                             (0x0003)
#define  AP_B_CONFIRMED                           (0x0004)
#define  AP_B_DEALLOCATE                          (0x0005)
#define  AP_B_FLUSH                               (0x0006)
#define  AP_B_GET_ATTRIBUTES                      (0x0007)
#define  AP_B_POST_ON_RECEIPT                     (0x0082)
#define  AP_B_PREPARE_TO_RECEIVE                  (0x000A)
#define  AP_B_RECEIVE_AND_POST                    (0x000D)
#define  AP_B_RECEIVE_AND_WAIT                    (0x000B)
#define  AP_B_RECEIVE_EXPEDITED_DATA              (0x0102)
#define  AP_B_RECEIVE_IMMEDIATE                   (0x000C)
#define  AP_B_REQUEST_TO_SEND                     (0x000E)
#define  AP_B_SEND_CONVERSATION                   (0x0018)
#define  AP_B_SEND_DATA                           (0x000F)
#define  AP_B_SEND_ERROR                          (0x0010)
#define  AP_B_SEND_EXPEDITED_DATA                 (0x0011)
#define  AP_B_TEST_RTS                            (0x0012)
#define  AP_B_TEST_RTS_AND_POST                   (0x0081)

#define  AP_M_ALLOCATE                            (0x0001)
#define  AP_M_CONFIRM                             (0x0003)
#define  AP_M_CONFIRMED                           (0x0004)
#define  AP_M_DEALLOCATE                          (0x0005)
#define  AP_M_FLUSH                               (0x0006)
#define  AP_M_GET_ATTRIBUTES                      (0x0007)
#define  AP_M_POST_ON_RECEIPT                     (0x0082)
#define  AP_M_PREPARE_TO_RECEIVE                  (0x000A)
#define  AP_M_RECEIVE_AND_POST                    (0x000D)
#define  AP_M_RECEIVE_AND_WAIT                    (0x000B)
#define  AP_M_RECEIVE_EXPEDITED_DATA              (0x0102)
#define  AP_M_RECEIVE_IMMEDIATE                   (0x000C)
#define  AP_M_REQUEST_TO_SEND                     (0x000E)
#define  AP_M_SEND_CONVERSATION                   (0x0018)
#define  AP_M_SEND_DATA                           (0x000F)
#define  AP_M_SEND_ERROR                          (0x0010)
#define  AP_M_SEND_EXPEDITED_DATA                 (0x0011)
#define  AP_M_TEST_RTS                            (0x0012)
#define  AP_M_TEST_RTS_AND_POST                   (0x0081)

#define  AP_GET_TYPE                              (0x0008)
#define  AP_GET_STATE                             (0x0009)
#define  AP_GET_TP_PROPERTIES                     (0x0017)
#define  AP_SET_TP_PROPERTIES                     (0x007E)
#define  AP_GET_LU_STATUS                         (0x007F)
#define  AP_IMPLIED_FORGET                        (0x0080)
#define  AP_POSTED_INDICATION                     (0x0083)
#define  AP_WAIT                                  (0x0084)
#define  AP_TEST_POSTED                           (0x0085)
#define  AP_CANCEL_CONVERSATION                   (0x0072)

#define  AP_DEFINE_DEFAULTS                       (0x0015)
#define  AP_DEFINE_LOCAL_LU                       (0x0021)
#define  AP_DEFINE_PARTNER_LU                     (0x0037)
#define  AP_DEFINE_MODE                           (0x0039)
#define  AP_DEFINE_TP                             (0x0030)
#define  AP_DEFINE_USERID_PASSWORD                (0x0058)
#define  AP_DEFINE_LU_LU_PASSWORD                 (0x0060)
#define  AP_DELETE_LOCAL_LU                       (0x0044)
#define  AP_DELETE_PARTNER_LU                     (0x003E)
#define  AP_DELETE_MODE                           (0x003F)
#define  AP_DELETE_TP                             (0x0031)
#define  AP_DELETE_USERID_PASSWORD                (0x0059)
#define  AP_DELETE_LU_LU_PASSWORD                 (0x0061)
#define  AP_DEFINE_LU62_TIMEOUT                   (0x0064)
#define  AP_DELETE_LU62_TIMEOUT                   (0x0065)

#define  AP_PS_ABEND_NOTIFICATION                 (0x0071)

#define  AP_DEACTIVATE_CONV_GROUP                 (0x0032)
#define  AP_DEACTIVATE_SESSION                    (0x002E)

#define  AP_DISPLAY_LOCAL_LU                      (0x1005)
#define  AP_DISPLAY_PARTNER_LU                    (0x1006)
#define  AP_DISPLAY_MODE                          (0x1007)
#define  AP_DISPLAY_TP                            (0x1008)
#define  AP_DISPLAY_SESSION                       (0x1009)

#define  AP_DEFINE_TP_AUTHORISE                   (0x1002)
#define  AP_DELETE_TP_AUTHORISE                   (0x1004)
#define  AP_DISPLAY_TP_AUTHORISE                  (0x100A)
#define  AP_DISPLAY_USERID_PASSWORD               (0x100B)
#define  AP_DISPLAY_SIGNED_ON_LIST                (0x100C)

#define  AP_CHANGE_SESSION_LIMIT                  (0x1010)
#define  AP_INITIALIZE_SESSION_LIMIT              (0x1011)
#define  AP_PROCESS_SESSION_LIMIT                 (0x1012)
#define  AP_RESET_SESSION_LIMIT                   (0x1013)
#define  AP_ACTIVATE_SESSION                      (0x1014)

#define  AP_SIGN_OFF                              (0x1020)
#define  AP_PROCESS_SIGN_OFF                      (0x1021)

#define  AP_START_DLC                             (0x2031)
#define  AP_START_LS                              (0x2033)
#define  AP_START_PORT                            (0x2034)
#define  AP_STOP_DLC                              (0x2035)
#define  AP_STOP_LS                               (0x2036)
#define  AP_STOP_PORT                             (0x2037)
#define  AP_DEFINE_CN                             (0x2038)
#define  AP_DEFINE_DLC                            (0x2039)
#define  AP_DEFINE_LS                             (0x2040)
#define  AP_DEFINE_PORT                           (0x2041)
#define  AP_DELETE_CN                             (0x2042)
#define  AP_DELETE_DLC                            (0x2043)
#define  AP_DELETE_LS                             (0x2044)
#define  AP_DELETE_PORT                           (0x2045)

#define  AP_DEFINE_LS_ROUTING                     (0x2046)
#define  AP_DELETE_LS_ROUTING                     (0x2047)

#define  AP_DEFINE_DIRECTORY_ENTRY                (0x2050)
#define  AP_DELETE_DIRECTORY_ENTRY                (0x2051)

#define  AP_DEFINE_COS                            (0x2053)
#define  AP_DELETE_COS                            (0x2054)

#define  AP_NODE_STARTED                          (0x2056)
#define  AP_START_NODE                            (0x2057)
#define  AP_TERM_NODE                             (0x2059)
#define  AP_APING                                 (0x2060)
#define  AP_APINGD                                (0x2061)

#define  AP_DEFINE_CPIC_SIDE_INFO                 (0x2062)
#define  AP_DELETE_CPIC_SIDE_INFO                 (0x2063)

#define  AP_DEFINE_ADJACENT_LEN_NODE              (0x2064)
#define  AP_DELETE_ADJACENT_LEN_NODE              (0x2065)
#define  AP_DYNAMIC_LOAD_REFRESH                  (0x2070)
#define  AP_DEFINE_ISR_STATS                      (0x2073)

#define  AP_DEFINE_CN_TG                          (0x2074)
#define  AP_DELETE_CN_TG                          (0x2075)

#define  AP_STOP_ISR_SESSION                      (0x2076)
#define  AP_START_CP_CP_SESSIONS                  (0x2077)
#define  AP_STOP_CP_CP_SESSIONS                   (0x2078)

#define  AP_SET_RTP_TIMES_LOGGING                 (0x2079)
#define  AP_DEFINE_RTP_TUNING                     (0x2080)

#define  AP_CCE_OPEN                              (0x2801)
#define  AP_CCE_ACTIVATE_ADAPTER                  (0x2802)
#define  AP_CCE_FIND                              (0x2803)
#define  AP_CCE_SEARCH_SINGLE                     (0x2804)
#define  AP_CCE_SEARCH_MULTIPLE                   (0x2805)
#define  AP_CCE_SEARCH_GET_RESOURCE               (0x2806)
#define  AP_CCE_SEARCH_GET_GROUP                  (0x2807)
#define  AP_CCE_SEARCH_DISCARD                    (0x2808)
#define  AP_CCE_CLOSE                             (0x2809)
#define  AP_CCE_TIMER_SET                         (0x280A)

/*****************************************************************************/
/* Query verbs                                                               */
/*****************************************************************************/
#define  AP_MIN_QUERY_OPCODE                      (0x20F5)
#define  AP_MIN_QUERY_WITH_BUF_PTR                (0x20F5)

#define  AP_QUERY_CN_TG                           (0x20F5)
#define  AP_QUERY_MLTG                            (0x20F6)
#define  AP_SAFE_STORE_TOPOLOGY                   (0x20F7)
#define  AP_QUERY_CONVERSATION                    (0x20F8)
#define  AP_QUERY_LS_EXCEPTION                    (0x20F9)
#define  AP_QUERY_LU62_TIMEOUT                    (0x20FA)
#define  AP_QUERY_LS_ROUTING                      (0x20FC)
#define  AP_QUERY_SIGNED_ON_LIST                  (0x20FD)
#define  AP_QUERY_DSPU_TEMPLATE                   (0x20FE)
#define  AP_QUERY_ADJACENT_NN                     (0x2100)
#define  AP_QUERY_CN_PORT                         (0x2101)
#define  AP_QUERY_COS                             (0x2102)
#define  AP_QUERY_COS_NODE_ROW                    (0x2103)
#define  AP_QUERY_COS_TG_ROW                      (0x2104)
#define  AP_QUERY_DIRECTORY_ENTRY                 (0x2105)
#define  AP_QUERY_DIRECTORY_LU                    (0x2106)
#define  AP_QUERY_DLC                             (0x2107)
#define  AP_QUERY_ISR_SESSION                     (0x2108)
#define  AP_QUERY_LOCAL_LU                        (0x2109)
#define  AP_QUERY_LOCAL_TOPOLOGY                  (0x210A)
#define  AP_QUERY_LS                              (0x210B)
#define  AP_QUERY_MODE                            (0x210C)
#define  AP_QUERY_MODE_DEFINITION                 (0x210D)
#define  AP_QUERY_MODE_TO_COS_MAPPING             (0x210E)
#define  AP_QUERY_NN_TOPOLOGY_NODE                (0x210F)
#define  AP_QUERY_NN_TOPOLOGY_TG                  (0x2110)
#define  AP_QUERY_PARTNER_LU                      (0x2111)
#define  AP_QUERY_PARTNER_LU_DEFINITION           (0x2112)
#define  AP_QUERY_PORT                            (0x2113)
#define  AP_QUERY_SESSION                         (0x2114)
#define  AP_QUERY_TP                              (0x2115)
#define  AP_QUERY_TP_DEFINITION                   (0x2116)
#define  AP_QUERY_CN                              (0x2117)
#define  AP_QUERY_FOCAL_POINT                     (0x2118)
#define  AP_QUERY_NMVT_APPLICATION                (0x2119)
#define  AP_QUERY_MDS_APPLICATION                 (0x211A)
#define  AP_QUERY_ACTIVE_TRANSACTION              (0x211B)
#define  AP_QUERY_LU_0_TO_3                       (0x211C)
#define  AP_QUERY_LU_POOL                         (0x211D)
#define  AP_QUERY_PU                              (0x211E)
#define  AP_QUERY_DOWNSTREAM_LU                   (0x211F)
#define  AP_QUERY_DOWNSTREAM_PU                   (0x2120)
#define  AP_QUERY_CPIC_SIDE_INFO                  (0x2121)

#define  AP_SFS_ADJACENT_NN                       (0x2122)
#define  AP_SFS_DIRECTORY                         (0x2123)
#define  AP_SFS_NN_TOPOLOGY_NODE                  (0x2124)
#define  AP_SFS_NN_TOPOLOGY_TG                    (0x2125)

#define  AP_QUERY_DLUS                            (0x2126)
#define  AP_QUERY_DLUR_PU                         (0x2127)
#define  AP_QUERY_DLUR_LU                         (0x2128)

#define  AP_QUERY_RTP_CONNECTION                  (0x2129)

#define  AP_QUERY_LU_LU_PASSWORD                  (0x212A)
#define  AP_QUERY_USERID_PASSWORD                 (0x212B)

#define  AP_MAX_QUERY_WITH_BUF_PTR                (0x212B)
/*****************************************************************************/
/* End of QUERY opcodes that have buf_ptr in vcb                             */
/*****************************************************************************/

/*****************************************************************************/
/* query verbs that do not have buf ptr                                      */
/*****************************************************************************/
#define  AP_QUERY_NODE                            (0x212C)
#define  AP_QUERY_STATISTICS                      (0x212D)
#define  AP_QUERY_DIRECTORY_STATS                 (0x212E)
#define  AP_QUERY_NN_TOPOLOGY_STATS               (0x212F)
#define  AP_QUERY_MDS_STATISTICS                  (0x2130)
#define  AP_QUERY_DEFAULT_PU                      (0x2131)
#define  AP_QUERY_DEFAULTS                        (0x2132)
#define  AP_QUERY_DLUR_DEFAULTS                   (0x2133)
#define  AP_QUERY_HPR_STATS                       (0x2134)
#define  AP_QUERY_RTP_TUNING                      (0x2135)

#define  AP_MAX_QUERY_OPCODE                      (0x2135)
/*****************************************************************************/
/* End of QUERY opcodes                                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Management services opcodes                                               */
/*****************************************************************************/
#define  AP_REGISTER_MS_APPLICATION               (0x0041)
#define  AP_UNREGISTER_MS_APPLICATION             (0x0042)
#define  AP_SEND_MDS_MU                           (0x004E)

#define  AP_MDS_MU_RECEIVED                       (0x3001)
#define  AP_FP_NOTIFICATION                       (0x3002)

#define  AP_REGISTER_NMVT_APPLICATION             (0x3003)
#define  AP_UNREGISTER_NMVT_APPLICATION           (0x3004)
#define  AP_NMVT_RECEIVED                         (0x3005)

#define  AP_REGISTER_ALERT_HANDLER                (0x3006)
#define  AP_REGISTER_HELD_ALERT_HANDLER           (0x3007)
#define  AP_SEND_HELD_ALERTS                      (0x3008)
#define  AP_ALERT_INDICATION                      (0x3009)
#define  AP_CONFIRM_MDS_MU_RCVD                   (0x300A)
#define  AP_DEFINE_FOCAL_POINT                    (0x300B)
#define  AP_DEFINE_DEFAULT_PU                     (0x300C)
#define  AP_UNREGISTER_ALERT_HANDLER              (0x300D)
#define  AP_UNREG_HELD_ALERT_HANDLER              (0x300E)
#define  AP_DELETE_FOCAL_POINT                    (0x300F)

#define SV_CONVERT                                (0x001A)
#define SV_DEFINE_TRACE                           (0x001D)
#define SV_GET_CP_CONVERT_TABLE                   (0x0019)
#define SV_LOG_MESSAGE                            (0x001F)
#define SV_TRANSFER_MS_DATA                       (0x001C)

#define SV_DEFINE_DUMP                            (0x004D)
#define SV_COPY_TRACE_TO_FILE                     (0x004C)
#define SV_SET_USER_LOG_QUEUE                     (0x004B)

/*****************************************************************************/
/* Indication opcodes                                                        */
/*****************************************************************************/
#define  AP_REGISTER_INDICATION_SINK              (0x4000)
#define  AP_UNREGISTER_INDICATION_SINK            (0x4001)

#define  AP_MIN_INDICATION_OPCODE                 (0x4002)

#define  AP_DIRECTORY_INDICATION                  (0x4002)
#define  AP_DYNAMIC_LOAD_INDICATION               (0x4003)
#define  AP_ISR_INDICATION                        (0x4004)
#define  AP_LOCAL_TOPOLOGY_INDICATION             (0x4005)
#define  AP_LS_INDICATION                         (0x4006)
#define  AP_MODE_INDICATION                       (0x4007)
#define  AP_NN_TOPOLOGY_NODE_INDICATION           (0x4008)
#define  AP_NN_TOPOLOGY_TG_INDICATION             (0x4009)
#define  AP_PLU_INDICATION                        (0x400A)
#define  AP_REGISTRATION_FAILURE                  (0x400B)
#define  AP_SESSION_INDICATION                    (0x400C)
#define  AP_PORT_INDICATION                       (0x400D)
#define  AP_DLC_INDICATION                        (0x400E)
#define  AP_FOCAL_POINT_INDICATION                (0x400F)
#define  AP_LU_0_TO_3_INDICATION                  (0x4010)
#define  AP_PU_INDICATION                         (0x4011)
#define  AP_DOWNSTREAM_PU_INDICATION              (0x4012)
#define  AP_DOWNSTREAM_LU_INDICATION              (0x4013)
#define  AP_DLUS_INDICATION                       (0x4014)
#define  AP_RTP_INDICATION                        (0x4015)
#define  AP_LOCAL_LU_INDICATION                   (0x4016)
#define  AP_DLUR_LU_INDICATION                    (0x4017)
#define  AP_SESSION_FAILURE_INDICATION            (0x4018)
#define  AP_EXTENDED_DLOAD_INDICATION             (0x4019)
#define  AP_DLUR_PU_INDICATION                    (0x401A)
#define  AP_MLTG_INDICATION                       (0x401B)

#define  AP_MAX_INDICATION_OPCODE                 (0x401B)
#define NUM_IND_SINK_TYPES              26

/*****************************************************************************/
/* Opcodes for conventional LU support                                       */
/*****************************************************************************/
#define  AP_DEFINE_LU_0_TO_3                      (0x5000)
#define  AP_DEFINE_LU_0_TO_3_RANGE                (0x5001)
#define  AP_DELETE_LU_0_TO_3                      (0x5002)
#define  AP_DELETE_LU_0_TO_3_RANGE                (0x5003)
#define  AP_DEFINE_LU_POOL                        (0x5004)
#define  AP_DELETE_LU_POOL                        (0x5005)
#define  AP_DEFINE_DOWNSTREAM_LU                  (0x5006)
#define  AP_DEFINE_DOWNSTREAM_LU_RANGE            (0x5007)
#define  AP_DELETE_DOWNSTREAM_LU                  (0x5008)
#define  AP_DELETE_DOWNSTREAM_LU_RANGE            (0x5009)
#define  AP_DEFINE_DSPU_TEMPLATE                  (0x500A)
#define  AP_DELETE_DSPU_TEMPLATE                  (0x500B)
#define  AP_DEACTIVATE_LU_0_TO_3                  (0x500C)

/*****************************************************************************/
/* Opcodes for DLUR                                                          */
/*****************************************************************************/
#define  AP_DEFINE_INTERNAL_PU                    (0x6000)
#define  AP_DEFINE_DLUR_DEFAULTS                  (0x6001)
#define  AP_START_INTERNAL_PU                     (0x6002)
#define  AP_STOP_INTERNAL_PU                      (0x6003)
#define  AP_DELETE_INTERNAL_PU                    (0x6004)

/*****************************************************************************/
/* Opcodes for HPR and RTP                                                   */
/*****************************************************************************/
#define AP_PATH_SWITCH                            (0x7000)

/*****************************************************************************/
/* DLC_TRACE verb opcodes                                                    */
/*****************************************************************************/
#define  AP_ADD_DLC_TRACE                         (0x8000)
#define  AP_REMOVE_DLC_TRACE                      (0x8001)
#define  AP_QUERY_DLC_TRACE                       (0x8002)

/*****************************************************************************/
/* SNAP-IX V5 control verbs                                                  */
/*****************************************************************************/
#define  AP_CONNECT_NODE                          (0xF001)
#define  AP_DISCONNECT_NODE                       (0xF002)
#define  AP_SET_PROCESSING_MODE                   (0xF003)
#define  AP_OPEN_FILE                             (0xF004)
#define  AP_CLOSE_FILE                            (0xF005)
#define  AP_DEFINE_NODE                           (0xF006)
#define  AP_INIT_NODE                             (0xF008)
#define  AP_QUERY_NODE_ALL                        (0xF009)
#define  AP_QUERY_NODE_LIMITS                     (0xF00B)

/*****************************************************************************/
/* Opcode value to use when registering and unregistering for config         */
/* indications.  The opcode on the actual indications is the opcode on the   */
/* config modifying verb.                                                    */
/*****************************************************************************/
#define  AP_CONFIG_INDICATION                     (0xF018)

/*****************************************************************************/
/* Opcode value for status indications.  Applications get status             */
/* indications if they are registered for any indications.                   */
/*****************************************************************************/
#define  AP_NOF_STATUS_INDICATION                 (0xF019)

/*****************************************************************************/
/* Opcode value to use in registering and unregistering for SNAP-IX Server   */
/* indications.                                                              */
/*****************************************************************************/
#define  AP_SERVER_INDICATION                     (0xF01A)

/*****************************************************************************/
/* Opcode value to use in registering and unregistering for SNAP-IX IP       */
/* Redirector indications.                                                   */
/*****************************************************************************/
#define  AP_TN_REDIRECTION_INDICATION             (0xF01B)

/*****************************************************************************/
/* SNAP-IX V5 logging/tracing verbs                                          */
/*****************************************************************************/
#define  AP_MIN_LOGTRACE_OPCODE                   (0xF021)

#define  AP_SET_CENTRAL_LOGGING                   (0xF021)
#define  AP_QUERY_CENTRAL_LOGGING                 (0xF022)
#define  AP_SET_LOG_TYPE                          (0xF023)
#define  AP_SET_GLOBAL_LOG_TYPE                   (0xF024)
#define  AP_SET_LOG_FILE                          (0xF025)
#define  AP_SET_TRACE_TYPE                        (0xF026)
#define  AP_SET_TRACE_FILE                        (0xF027)
#define  AP_SET_DIAGNOSTICS_DIRECTORY             (0xF028)
#define  AP_QUERY_CENTRAL_LOGGER                  (0xF029)
#define  AP_QUERY_LOG_TYPE                        (0xF02A)
#define  AP_QUERY_GLOBAL_LOG_TYPE                 (0xF02B)
#define  AP_QUERY_LOG_FILE                        (0xF02C)
#define  AP_QUERY_TRACE_TYPE                      (0xF02D)
#define  AP_QUERY_TRACE_FILE                      (0xF02E)
#define  AP_QUERY_DIAGNOSTICS_DIRECTORY           (0xF02F)

#define  AP_MAX_LOGTRACE_OPCODE                   (0xF02F)

/*****************************************************************************/
/* SNAP-IX V5 TP Verbs                                                       */
/*****************************************************************************/
#define  AP_QUERY_AVAILABLE_TP                    (0xF031)

/*****************************************************************************/
/* SNAP-IX V5 3270 user verbs                                                */
/*****************************************************************************/
#define  AP_DEFINE_EMULATOR_USER                  (0xF041)
#define  AP_DELETE_EMULATOR_USER                  (0xF042)
#define  AP_QUERY_EMULATOR_USER_DEF               (0xF043)
#define  AP_QUERY_3270_USER                       (0xF044)
#define  AP_DEFINE_3270_DIAG                      (0xF045)
#define  AP_QUERY_3270_DIAG                       (0xF046)
#define  AP_QUERY_3270_USER_SESSIONS              (0xF047)

/*****************************************************************************/
/* SNAP-IX V5 Config File verbs                                              */
/*****************************************************************************/
#define  AP_DEFINE_DOMAIN_CONFIG_FILE             (0xF050)
#define  AP_QUERY_DOMAIN_CONFIG_FILE              (0xF051)

/*****************************************************************************/
/* SNAP-IX V5 RJE user verbs                                                 */
/*****************************************************************************/
#define  AP_DEFINE_RJE_WKSTN                       (0xF061)
#define  AP_DELETE_RJE_WKSTN                       (0xF062)
#define  AP_QUERY_RJE_WKSTN_DEF                    (0xF063)
#define  AP_QUERY_RJE_WKSTN                        (0xF064)

/*****************************************************************************/
/* SNAP-IX V5 Extra Data verbs                                               */
/*****************************************************************************/
#define AP_DEFINE_EXTRA_DATA                       (0xF065)
#define AP_DELETE_EXTRA_DATA                       (0xF066)
#define AP_QUERY_EXTRA_DATA                        (0xF067)

/*****************************************************************************/
/* SNAP-IX V5 Client-server user verbs                                       */
/*****************************************************************************/
#define  AP_SET_CS_TRACE                           (0xF070)
#define  AP_QUERY_CS_TRACE                         (0xF071)
#define  AP_ADD_BACKUP                             (0xF072)
#define  AP_DELETE_BACKUP                          (0xF073)
#define  AP_QUERY_SNA_NET                          (0xF074)

/*****************************************************************************/
/* Opcode value to use when registering and unregistering for sna.net        */
/* indications.  The opcode on the actual indications is the opcode on the   */
/* sna.net modifying verb.                                                   */
/*****************************************************************************/
#define  AP_SNA_NET_INDICATION                    (0xF077)

/*****************************************************************************/
/* RCF verbs                                                                 */
/*****************************************************************************/
#define  AP_DEFINE_RCF_ACCESS                     (0xF078)
#define  AP_DELETE_RCF_ACCESS                     (0xF079)
#define  AP_QUERY_RCF_ACCESS                      (0xF07A)

/*****************************************************************************/
/* Kernel memory limiting verbs                                              */
/*****************************************************************************/
#define  AP_SET_KERNEL_MEMORY_LIMIT               (0xF07B)
#define  AP_QUERY_KERNEL_MEMORY_LIMIT             (0xF07C)

/*****************************************************************************/
/* Buffer availability verbs                                                 */
/*****************************************************************************/
#define  AP_SET_BUFFER_AVAILABILITY               (0xF07D)
#define  AP_QUERY_BUFFER_AVAILABILITY             (0xF07E)

/*****************************************************************************/
/* TN Server user verbs                                                      */
/*****************************************************************************/
#define  AP_DEFINE_TN3270_ACCESS                  (0xF090)
#define  AP_DELETE_TN3270_ACCESS                  (0xF091)
#define  AP_QUERY_TN3270_ACCESS_DEF               (0xF092)
#define  AP_SET_TN_SERVER_TRACE                   (0xF093)
#define  AP_QUERY_TN_SERVER_TRACE                 (0xF094)
#define  AP_DEFINE_TN3270_ASSOCIATION             (0xF095)
#define  AP_DELETE_TN3270_ASSOCIATION             (0xF096)
#define  AP_QUERY_TN3270_ASSOCIATION              (0xF097)
#define  AP_DEFINE_TN3270_DEFAULTS                (0xF098)
#define  AP_QUERY_TN3270_DEFAULTS                 (0xF099)
#define  AP_DEFINE_TN3270_SSL_LDAP                (0xF09A)
#define  AP_QUERY_TN3270_SSL_LDAP                 (0xF09B)
#define  AP_DEFINE_TN_REDIRECT                    (0xF09C)
#define  AP_DELETE_TN_REDIRECT                    (0xF09D)
#define  AP_QUERY_TN_REDIRECT_DEF                 (0xF09E)

/*****************************************************************************/
/* Back Level (V4) SLIM opcodes                                              */
/*****************************************************************************/
#define  AP_SET_BCK_CS_TRACE                      (0xF0A0)
#define  AP_QUERY_BCK_CS_TRACE                    (0xF0A1)

/*****************************************************************************/
/* TP Server API opcodes                                                     */
/*****************************************************************************/
#define AP_REGISTER_TP_SERVER                     (0xF104)
#define AP_UNREGISTER_TP_SERVER                   (0xF105)
#define AP_REGISTER_TP                            (0xF106)
#define AP_UNREGISTER_TP                          (0xF107)
#define AP_QUERY_ATTACH                           (0xF108)
#define AP_ACCEPT_ATTACH                          (0xF109)
#define AP_REJECT_ATTACH                          (0xF10A)
#define AP_ABORT_ATTACH                           (0xF10B)

/*****************************************************************************/
/* Operation Codes for SNAP-IX V5 MS API extension verbs                     */
/*****************************************************************************/
#define  AP_CONNECT_MS_NODE                       (0xF600)
#define  AP_DISCONNECT_MS_NODE                    (0xF601)
#define  AP_MS_STATUS                             (0xF602)

/*****************************************************************************/
/* Operation Codes for LU1-3 verbs                                           */
/*****************************************************************************/
#define  AP_B_SEND_FMH                            (0xF0B0)
#define  AP_B_SEND_STATUS                         (0xF0B1)

/*****************************************************************************/
/* Operation codes for LU0 primary verbs                                     */
/*****************************************************************************/
#define  AP_DEFINE_PRIMARY_LINE                   (0xF0C0)
#define  AP_DELETE_PRIMARY_LINE                   (0xF0C1)
#define  AP_QUERY_PRIMARY_LINE                    (0xF0C2)
#define  AP_DEFINE_PRIMARY_LU0                    (0xF0C4)
#define  AP_DELETE_PRIMARY_LU0                    (0xF0C5)
#define  AP_QUERY_PRIMARY_LU0                     (0xF0C6)

/*****************************************************************************/
/* LU6.2 Security opcodes                                                    */
/*****************************************************************************/
#define AP_DEFINE_TRUSTED_GROUPS                  (0xF0D0)
#define AP_QUERY_TRUSTED_GROUPS                   (0xF0D1)
#define AP_DEFINE_SECURITY_ACCESS_LIST            (0xF0D2)
#define AP_DELETE_SECURITY_ACCESS_LIST            (0xF0D3)
#define AP_QUERY_SECURITY_ACCESS_LIST             (0xF0D4)

/*****************************************************************************/
/* Verbs for accessing TP Load Information                                   */
/*****************************************************************************/
#define AP_DEFINE_TP_LOAD_INFO                    (0xF0D5)
#define AP_DELETE_TP_LOAD_INFO                    (0xF0D6)
#define AP_QUERY_TP_LOAD_INFO                     (0xF0D7)

/*****************************************************************************/
/* Verb Parameter Values                                                     */
/*****************************************************************************/
#define  AP_NO                                    (0x00)
#define  AP_YES                                   (0x01)
#define  AP_LEAVE_UNCHANGED                       (0x11)

#define  AP_INDEPENDENT_LU                        (0x00)
#define  AP_SYSTEM_LIMIT                          (0x00)

/*****************************************************************************/
/* conversation states - half duplex                                         */
/*****************************************************************************/
#define  AP_RESET_STATE                 (0x00)
#define  AP_SEND_STATE                  (0x01)
#define  AP_RECEIVE_STATE               (0x02)
#define  AP_CONFIRM_STATE               (0x03)
#define  AP_CONFIRM_SEND_STATE          (0x04)
#define  AP_CONFIRM_DEALL_STATE         (0x05)
#define  AP_PEND_POST_STATE             (0x06)
#define  AP_PEND_DEALL_STATE            (0x07)
#define  AP_END_CONV_STATE              (0x08)
#define  AP_SEND_PENDING_STATE          (0x09)
#define  AP_POST_ON_RECEIPT_STATE       (0x0A)

/*****************************************************************************/
/* conversation states - full duplex (see also AP_RESET_STATE)               */
/*****************************************************************************/
#define AP_SEND_RECEIVE_STATE          (0x81)
#define AP_SEND_ONLY_STATE             (0x82)
#define AP_RECEIVE_ONLY_STATE          (0x83)

/*****************************************************************************/
/* dealloc_type and ptr_type                                                 */
/*****************************************************************************/
#define  AP_SYNC_LEVEL                  (0x00)
#define  AP_FLUSH                       (0x01)
#define  AP_CONFIRM_TYPE                (0x0B)

/*****************************************************************************/
/* ptr_type                                                                  */
/*****************************************************************************/
#define  AP_P_TO_R_CONFIRM              (0x02)

/*****************************************************************************/
/* dealloc_type                                                              */
/*****************************************************************************/
#define  AP_ABEND                       (0x05)
#define  AP_ABEND_PROG                  (0x02)
#define  AP_ABEND_SVC                   (0x03)
#define  AP_ABEND_TIMER                 (0x04)
#define  AP_TP_NOT_AVAIL_RETRY          (0x06)
#define  AP_TP_NOT_AVAIL_NO_RETRY       (0x07)
#define  AP_TPN_NOT_RECOGNIZED          (0x08)
#define  AP_PIP_DATA_NOT_ALLOWED        (0x09)
#define  AP_PIP_DATA_INCORRECT          (0x0A)
#define  AP_RESOURCE_FAILURE_NO_RETRY   (0x0C)
#define  AP_CONV_TYPE_MISMATCH          (0x0D)
#define  AP_SYNC_LVL_NOT_SUPPORTED      (0x0E)
#define  AP_SECURITY_PARAMS_INVALID     (0x0F)
#define  AP_ATTACH_ERROR                (0xFF)

/*****************************************************************************/
/* sync_level                                                                */
/*****************************************************************************/
#define  AP_CONFIRM_SYNC_LEVEL          (0x01)
#define  AP_SYNCPT                      (0x02)

/*****************************************************************************/
/* sync_level - used for DEFINE_TP. Also uses AP_EITHER=0x02 (also used for  */
/* conversation type!) and AP_CONFIRM_SYNC_LEVEL=0x01                        */
/*****************************************************************************/
#define  AP_SYNCPT_REQUIRED             (0x03)
#define  AP_SYNCPT_NEGOTIABLE           (0x04)

/*****************************************************************************/
/* duplex_type                                                               */
/*****************************************************************************/
#define  AP_HALF_DUPLEX                 (0x00)
#define  AP_FULL_DUPLEX                 (0x01)

/*****************************************************************************/
/* routing protocol preference                                               */
/*****************************************************************************/
#define  AP_NATIVE                      (0x00)
#define  AP_NONNATIVE                   (0x01)
#define  AP_NATIVE_THEN_NONNATIVE       (0x02)
#define  AP_NONNATIVE_THEN_NATIVE       (0x03)
#define  AP_USE_DEFAULT_PREFERENCE      (0xFF)

/*****************************************************************************/
/* Anynet Support of node.                                                   */
/*       AP_NONE                        (0x00)                               */
/*       AP_GATEWAY                     (0x02)      defined elsewhere        */
/*****************************************************************************/
#define  AP_ACCESS_NODE                 (0x01)

/*****************************************************************************/
/* fill                                                                      */
/*****************************************************************************/
#define  AP_BUFFER                      (0x00)
#define  AP_LL                          (0x01)
#define  AP_MULTIPLE_LL                 (0x02)

/*****************************************************************************/
/* conv_type in opext field                                                  */
/*****************************************************************************/
#define  AP_BASIC_CONVERSATION          (0x00)
#define  AP_MAPPED_CONVERSATION         (0x01)

/*****************************************************************************/
/* duplex type in opext field                                                */
/*****************************************************************************/
#define  AP_FULL_DUPLEX_CONVERSATION    (0x04)

/*****************************************************************************/
/* Other flags for the opext field of APPC verbs                             */
/*   NON_BLOCKING is a supplied value                                        */
/*   OPERATION_INCOMPLETE is a returned value                                */
/*****************************************************************************/
#define  AP_NON_BLOCKING                (0x02)
#define  AP_OPERATION_INCOMPLETE_FLAG   (0x40)

/*****************************************************************************/
/* Reserved wait_object values                                               */
/* wait objects are used for non-blocking verbs, supplied in secondary_rc    */
/* field                                                                     */
/*****************************************************************************/
#define  AP_BLOCKING_WAIT_OBJECT        (0x00000000L)
#define  AP_NULL_WAIT_OBJECT            (0xFFFFFFFFL)

/*****************************************************************************/
/* security                                                                  */
/*****************************************************************************/
#define  AP_PGM_STRONG                  (0x05)
#define  AP_PGM                         (0x02)
#define  AP_SAME                        (0x01)

/*****************************************************************************/
/* LULU verification protocol defined/in use                                 */
/*****************************************************************************/
#define  AP_EITHER_PROTOCOL             (0x00)
#define  AP_BASIC_PROTOCOL              (0x01)
#define  AP_ENHANCED_PROTOCOL           (0x02)

/*****************************************************************************/
/* ptr_locks                                                                 */
/*****************************************************************************/
#define  AP_LONG                        (0x01)
#define  AP_SHORT                       (0x00)

/*****************************************************************************/
/* err_type                                                                  */
/*****************************************************************************/
#define  AP_PROG                        (0x00)
#define  AP_SVC                         (0x01)
#define  AP_BACKOUT_NO_RESYNC           (0x02)
#define  AP_BACKOUT_RESYNC              (0x03)

/*****************************************************************************/
/* rtn_ctl                                                                   */
/*****************************************************************************/
#define  AP_WHEN_SESSION_ALLOCATED      (0x00)
#define  AP_WHEN_EXPD_RECEIVED          (0x00)
#define  AP_IMMEDIATE                   (0x01)
#define  AP_WHEN_SESSION_FREE           (0x02)
#define  AP_WHEN_CONWINNER_ALLOC        (0x03)
#define  AP_WHEN_CONV_GROUP_ALLOC       (0x04)
#define  AP_WHEN_CONLOSER_ALLOC         (0x05)

/*****************************************************************************/
/* TP_ENDED type                                                             */
/*****************************************************************************/
#define  AP_SOFT                        (0x00)
#define  AP_HARD                        (0x01)
#define  AP_CANCEL                      (0x0A)

/*****************************************************************************/
/* data_type                                                                 */
/*****************************************************************************/
#define  AP_APPLICATION                 (0x00)
#define  AP_USER_CONTROL_DATA           (0x01)
#define  AP_PS_HEADER                   (0x02)
#define  AP_BASIC_DATA                  (0x03)

/*****************************************************************************/
/* send_type                                                                 */
/*****************************************************************************/
#define  AP_SEND_DATA_FLUSH              (0x01)
#define  AP_SEND_DATA_CONFIRM            (0x02)
#define  AP_SEND_DATA_P_TO_R_FLUSH       (0x03)
#define  AP_SEND_DATA_P_TO_R_SYNC_LEVEL  (0x04)
#define  AP_SEND_DATA_P_TO_R_CONFIRM     (0x08)
#define  AP_SEND_DATA_DEALLOC_FLUSH      (0x05)
#define  AP_SEND_DATA_DEALLOC_SYNC_LEVEL (0x06)
#define  AP_SEND_DATA_DEALLOC_CONFIRM    (0x09)
#define  AP_SEND_DATA_DEALLOC_ABEND      (0x07)

/*****************************************************************************/
/* pacing_type for SESSION_STATS in queries                                  */
/*      AP_NONE                         (0x00)      defined elsewhere        */
/*****************************************************************************/
#define AP_PACING_FIXED                 (0x01)
#define AP_PACING_ADAPTIVE              (0x02)

/*****************************************************************************/
/* error direction                                                           */
/*****************************************************************************/
#define  AP_RCV_DIR_ERROR               (0x00)
#define  AP_SEND_DIR_ERROR              (0x01)

/*****************************************************************************/
/* what received                                                             */
/*****************************************************************************/
#define  AP_CONFIRM_WHAT_RECEIVED       (0x0002)
#define  AP_CONFIRM_DEALLOCATE          (0x0004)
#define  AP_CONFIRM_SEND                (0x0003)
#define  AP_SEND                        (0x0001)

#define  AP_DATA                        (0x0100)
#define  AP_DATA_COMPLETE               (0x0200)
#define  AP_DATA_INCOMPLETE             (0x0400)
#define  AP_USER_CONTROL_DATA_COMPLETE  (0x0800)
#define  AP_USER_CONTROL_DATA_INCMP     (0x1000)
#define  AP_PS_HEADER_COMPLETE          (0x2000)
#define  AP_PS_HEADER_INCOMPLETE        (0x4000)

#define  AP_DATA_COMPLETE_CONFIRM       (0x0202)
#define  AP_DATA_COMPLETE_CONFIRM_DEALL (0x0204)
#define  AP_DATA_COMPLETE_CONFIRM_SEND  (0x0203)
#define  AP_DATA_COMPLETE_SEND          (0x0201)

#define  AP_UC_DATA_COMPLETE_CONFIRM    (0x0802)
#define  AP_UC_DATA_COMPLETE_CNFM_DEALL (0x0804)
#define  AP_UC_DATA_COMPLETE_CNFM_SEND  (0x0803)
#define  AP_UC_DATA_COMPLETE_SEND       (0x0801)

#define  AP_PS_HDR_COMPLETE_CONFIRM     (0x2002)
#define  AP_PS_HDR_COMPLETE_CNFM_DEALL  (0x2004)
#define  AP_PS_HDR_COMPLETE_CNFM_SEND   (0x2003)
#define  AP_PS_HDR_COMPLETE_SEND        (0x2001)

#define  AP_DATA_CONFIRM                (0x0102)
#define  AP_DATA_CONFIRM_DEALLOCATE     (0x0104)
#define  AP_DATA_CONFIRM_SEND           (0x0103)
#define  AP_DATA_SEND                   (0x0101)

/*****************************************************************************/
/* masks for accessing data and status portions of what_rcvd                 */
/*****************************************************************************/
#define  AP_DATA_INDICATOR              (0xFF00)
#define  AP_STATUS_INDICATOR            (0x00FF)

/*****************************************************************************/
/* reason for implied forget indication                                      */
/*****************************************************************************/
#define  AP_DATA_FLOW                   (0x00)
#define  AP_UNBIND                      (0x01)
#define  AP_FAILURE                     (0x02)

#define  AP_CNF_BACK_SYNC_LEVEL                   (0x02)

#define  AP_SEC_NONSECURE                         (0x01)
#define  AP_SEC_PUBLIC_SWITCHED_NETWORK           (0x20)
#define  AP_SEC_UNDERGROUND_CABLE                 (0x40)
#define  AP_SEC_SECURE_CONDUIT                    (0x60)
#define  AP_SEC_GUARDED_CONDUIT                   (0x80)
#define  AP_SEC_ENCRYPTED                         (0xA0)
#define  AP_SEC_GUARDED_RADIATION                 (0xC0)
#define  AP_SEC_MAXIMUM                           (0xC0)

#define  AP_PROP_DELAY_MINIMUM                    (0x00)
#define  AP_PROP_DELAY_LAN                        (0x4C)
#define  AP_PROP_DELAY_TELEPHONE                  (0x71)
#define  AP_PROP_DELAY_PKT_SWITCHED_NET           (0x91)
#define  AP_PROP_DELAY_SATELLITE                  (0x99)
#define  AP_PROP_DELAY_MAXIMUM                    (0xFF)

#define  AP_CONGESTED                             (0x80)
#define  AP_UNCONGESTED                           (0x00)
#define  AP_IRR_DEPLETED                          (0x40)
#define  AP_ERR_DEPLETED                          (0x20)
#define  AP_GARBAGE_COLLECT                       (0x10)
#define  AP_QUIESCING                             (0x04)

#define  AP_TG_OPERATIVE                          (0x80)
#define  AP_TG_QUIESCING                          (0x20)
#define  AP_TG_CP_CP_SESSIONS                     (0x10)
#define  AP_TG_HPR                                (0x01)
#define  AP_TG_RTP                                (0x02)

#define  AP_HOME                                  (0x03)
#define  AP_REGISTER                              (0x02)
#define  AP_CACHE                                 (0x00)
#define  AP_INVALID_ENTRY_TYPE                    (0x10)

#define  AP_REAL                                  (0x00)
#define  AP_VIRTUAL                               (0x01)

#define  AP_LEARN_NODE                            (0x00)
#define  AP_APPN_NODE                             (0x00)
#define  AP_LEN_NODE                              (0x01)
#define  AP_NETWORK_NODE                          (0x02)
#define  AP_END_NODE                              (0x03)
#define  AP_VRN                                   (0x04)
#define  AP_BACK_LEVEL_LEN_NODE                   (0x05)
#define  AP_HOST_XID3                             (0x06)
#define  AP_HOST_XID0                             (0x07)
#define  AP_DSPU_XID                              (0x08)
#define  AP_DSPU_NOXID                            (0x09)

#define  AP_USE_ADAPTER_DEF_CHAR                  (0xFF)
#define  AP_USE_ADAPTER_DEF_SHORT                 (0xFFFF)
#define  AP_USE_ADAPTER_DEF_LONG                  (0xFFFFFFFFL)

#define  AP_SWITCHED                              (0x01)
#define  AP_NONSWITCHED                           (0x02)

#define  AP_LOW                                   (0x00)
#define  AP_MEDIUM                                (0x01)
#define  AP_HIGH                                  (0x02)
#define  AP_NETWORK                               (0x03)

#define  AP_BACKGROUND                            (0x00)
#define  AP_FULL_SCREEN                           (0x01)
#define  AP_PRESENTATION_MANAGER                  (0x02)
#define  AP_VIO_WINDOWABLE                        (0x03)

#define  AP_LOCALLY                               (0x00)
#define  AP_REMOTELY                              (0x01)

#define  AP_BASIC                                 (0x00)
#define  AP_MAPPED                                (0x01)
#define  AP_EITHER                                (0x02)

#define  AP_CONFIRM                               (0x01)

#define  AP_INFINITE                              (0xFFFF)

#define  AP_FULL                                  (0x01)
#define  AP_PARTIAL                               (0x02)

#define  AP_ACTIVATE_ONE                          (0x01)
#define  AP_ACTIVATE_ALL                          (0xFF)

#define  AP_LINK_HARD                             (0x00)
#define  AP_LINK_SOFT                             (0x01)

#define  AP_LINK_CONNECT                          (0x00)
#define  AP_LINK_AUTO_CONNECT                     (0x01)

#define  AP_SOURCE                                (0x00)
#define  AP_TARGET                                (0x01)

#define  AP_POL_EITHER                            (0x00)
#define  AP_POL_FIRST_SPEAKER                     (0x01)
#define  AP_POL_BIDDER                            (0x02)

#define  AP_ONE                                   (0x00)
#define  AP_ALL                                   (0x01)

#define  AP_SECONDARY                             (0x00)
#define  AP_PRIMARY                               (0x01)
#define  AP_NEGOTIABLE                            (0x03)

#define  AP_EXPLICIT_PRIMARY_FP                   (0x01)
#define  AP_IMPLICIT_PRIMARY_FP                   (0x02)
#define  AP_BACKUP_FP                             (0x20)
#define  AP_DEFAULT_PRIMARY_FP                    (0x30)
#define  AP_DOMAIN_FP                             (0x50)
#define  AP_HOST_FP                               (0xF0)
#define  AP_NO_FP                                 (0xFF)

#define  AP_NOT_ACTIVE                            (0x00)
#define  AP_ACTIVE                                (0x01)
#define  AP_PENDING                               (0x02)
#define  AP_NEVER_ACTIVE                          (0x04)
#define  AP_PENDING_ACTIVE                        (0x02)
#define  AP_PENDING_INACTIVE                      (0x08)
#define  AP_PENDING_ACTIVE_BY_LR                  (0x10)

#define  AP_PEND_ACTPU                            (0x02)
#define  AP_PEND_ACTPU_RSP                        (0x03)
#define  AP_PEND_DACTPU_RSP                       (0x04)
#define  AP_PEND_INOP                             (0x05)
#define  AP_RESET_RETRY                           (0x06)
#define  AP_RESET_NO_RETRY                        (0x07)

#define  AP_CONWINNER_ACTIVE                      (0x02)
#define  AP_CONLOSER_ACTIVE                       (0x03)

#define  AP_BACKUP                                (0x02)
#define  AP_IMPLICIT                              (0x03)

/*****************************************************************************/
/* Sub-states returned on QUERY_LS.  Note that the full list includes:       */
/*       AP_ACTIVE                      (0x01)                               */
/*       AP_PENDING_RETRY               (0x09)                               */
/*****************************************************************************/
#define  AP_RESET                                 (0x00)
#define  AP_SENT_CONNECT_OUT                      (0x02)
#define  AP_PENDING_XID_EXCHANGE                  (0x03)
#define  AP_SENT_ACTIVATE_AS                      (0x04)
#define  AP_SENT_SET_MODE                         (0x05)
#define  AP_SENT_DEACTIVATE_AS_ORDERLY            (0x06)
#define  AP_SENT_DISCONNECT                       (0x07)
#define  AP_WAITING_STATS                         (0x08)

#define  AP_DEFAULT                               (0x00)
#define  AP_DIRECT                                (0x01)

#define  AP_DEACT_CLEANUP                         (0x02)
#define  AP_DEACT_NORMAL                          (0x01)
#define  AP_ASYNCHRONOUS_DEACTIVATION             (0x00)
#define  AP_SYNCHRONOUS_DEACTIVATION              (0x80)

#define  AP_NONE                                  (0x00)

/*****************************************************************************/
/* Levels of HPR support                                                     */
/*****************************************************************************/
#define  AP_BASE                                  (0x01)
#define  AP_RTP                                   (0x02)
#define  AP_CONTROL_FLOWS                         (0x03)

/*****************************************************************************/
/* Levels of ARB support                                                     */
/*  AP_ARB_S - Standard ARB supported                                        */
/*  AP_ARB_R - ARB Responsive Mode supported                                 */
/*****************************************************************************/
#define  AP_ARB_S                                 (0x01)
#define  AP_ARB_R                                 (0x02)

/*****************************************************************************/
/* Levels of DLUR support.  Allowed combinations are:                        */
/*                                               NN   BrNN   EN    LEN       */
/*  AP_NO                                        yes   yes   yes   yes       */
/*  AP_YES                                       yes   yes   yes   no        */
/* ( AP_YES |  AP_LIMITED_DLUR_MULTI_SUBNET)      no   yes   yes   no        */
/*****************************************************************************/
#define  AP_LIMITED_DLUR_MULTI_SUBNET             (0x02)

#define  AP_PU_CONCENTRATION                      (0x01)
#define  AP_DLUR                                  (0x02)
#define  AP_DIRECT_ATTACHED                       (0x03)
#define  AP_DLUR_ATTACHED                         (0x04)

#define  AP_LUA_APPLICATION                       (0x02)
#define  AP_FMI_APPLICATION                       (0x03)
#define  AP_TN_SERVER                             (0x04)
#define  AP_DUNLAP                                (0x05)

#define  AP_LOCAL                                 (0x00)
#define  AP_REMOTE                                (0x01)

#define  AP_DOMAIN                                (0x01)
#define  AP_CROSS_DOMAIN                          (0x02)

#define  AP_OTHER                                 (0x01)
#define  AP_EXPLICIT                              (0x02)
#define  AP_PARTIAL_WILDCARD                      (0x03)
#define  AP_FULL_WILDCARD                         (0x04)

#define  AP_OUTBOUND                              (0x00)
#define  AP_INBOUND                               (0x01)

#define  AP_NOT_SUPPORTED                         (0x00)
#define  AP_SUPPORTED                             (0x01)

#define  AP_HOLD_FOREVER                          (-1)

#define  AP_QUEUED_OPERATOR_STARTED               (0x00)
#define  AP_QUEUED_AM_STARTED                     (0x01)
#define  AP_NONQUEUED_AM_STARTED                  (0x02)
#define  AP_QUEUED_OPERATOR_PRELOADED             (0x03)

#define  AP_TP_TYPE_UNKNOWN                       (0x00)
#define  AP_TP_TYPE_NON_QUEUED                    (0x01)
#define  AP_TP_TYPE_QUEUED                        (0x02)
#define  AP_TP_TYPE_QUEUED_BROADCAST              (0x03)

#define  AP_TP_STYLE_UNKNOWN                      (0x00)
#define  AP_TP_STYLE_EXTENDED                     (0x01)
#define  AP_TP_STYLE_COMPATIBLE                   (0x02)

#define  AP_INACTIVE                              (0x00)
#define  AP_LOADED                                (0x01)
#define  AP_LOADING                               (0x02)
#define  AP_RUNNING                               (0x03)

#define  AP_SSCP_PU_SESSION                       (0x00)
#define  AP_SSCP_LU_SESSION                       (0x01)
#define  AP_LU_LU_SESSION                         (0x02)

#define  AP_ISR_SESSIONS                (0x00)
#define  AP_DLUR_SESSIONS               (0x01)

#define  AP_ISR_STATS_NO_CHANGE         (0x00)
#define  AP_ISR_STATS_ACTIVE            (0x01)
#define  AP_ISR_STATS_INACTIVE          (0x02)

#define  AP_ISR_INACTIVE                (0x00)
#define  AP_ISR_ACTIVE                  (0x01)
#define  AP_ISR_PENDING_ACTIVE          (0x02)
#define  AP_ISR_PENDING_INACTIVE        (0x03)

/*****************************************************************************/
/* LU type values (type 5 is deliberately omitted).                          */
/*****************************************************************************/
#define  AP_LU_TYPE_0                   (0x00)
#define  AP_LU_TYPE_1                   (0x01)
#define  AP_LU_TYPE_2                   (0x02)
#define  AP_LU_TYPE_3                   (0x03)
#define  AP_LU_TYPE_4                   (0x04)
#define  AP_LU_TYPE_6                   (0x06)
#define  AP_LU_TYPE_7                   (0x07)
#define  AP_LU_TYPE_UNKNOWN             (0xFF)

#define  AP_LU_LEVEL_0                  (0x00)
#define  AP_LU_LEVEL_1                  (0x01)
#define  AP_LU_LEVEL_2                  (0x02)
#define  AP_LU_LEVEL_UNKNOWN            (0xFF)

/*****************************************************************************/
/* RTP connection types, returned on RTP_INDICATION and QUERY_RTP_CONNECTION */
/*****************************************************************************/
#define  AP_RTP_LU_LU_SESSION           (0x00)
#define  AP_RTP_CP_CP_SESSION           (0x01)
#define  AP_RTP_ROUTE_SETUP             (0x02)

#define  AP_DEACTIVATED                           (0x00)
#define  AP_ACTIVATED                             (0x80)
#define  AP_SETUP_FAILED                          (0x20)
#define  AP_PATH_SWITCHED                         (0x40)

#define  AP_FAILED                                (0x80)
#define  AP_ACTIVATION_STARTED                    (0x01)
#define  AP_ACTIVATION_FAILED                     (0x02)
#define  AP_LR_ACTIVATING                         (0x04)
#define  AP_ACTIVATING                            (0x40)
#define  AP_DEACTIVATION_STARTED                  (0x03)
#define  AP_DEACTIVATING                          (0x20)
#define  AP_DETACHING                             (0x10)
#define  AP_SESS_COUNT_CHANGING                   (0x10)
#define  AP_CP_NAME_CHANGING                      (0x05)
#define  AP_PENDING_RETRY                         (0x09)
#define  AP_DATA_LOST                             (0x00)

/*****************************************************************************/
/* Reasons for MLTG_INDICATION                                               */
/*****************************************************************************/

#define AP_MLTG_LINK_ACTIVATING                   (0x01)
#define AP_MLTG_LINK_DEACTIVATING                 (0x02)
#define AP_MLTG_LOAD_HIGH                         (0x03)
#define AP_MLTG_LOAD_LOW                          (0x04)

/*****************************************************************************/
/* Reasons for DLUR PU indications                                           */
/*****************************************************************************/
#define  AP_FAILED_RETRY                          (0x06)
#define  AP_FAILED_NO_RETRY                       (0x07)

#define  AP_NOT_BOUND                             (0x00)
#define  AP_BOUND                                 (0x80)
#define  AP_BINDING                               (0x40)
#define  AP_UNBINDING                             (0x20)

#define  AP_HOST_CONNECTION                       (0x01)
#define  AP_PEER_CONNECTION                       (0x02)
#define  AP_BOTH_CONNECTION                       (0x03)

#define  AP_CONALS_PND                            (0x02)
#define  AP_XID_PND                               (0x03)
#define  AP_CONTACT_PND                           (0x05)
#define  AP_CONTACTED                             (0x06)
#define  AP_DISC_PND                              (0x07)
#define  AP_DISC_RQ                               (0x08)

/*****************************************************************************/
/* LU 6.2 lu_attributes                                                      */
/*****************************************************************************/
#define  AP_DISABLE_PWSUB                         (0x01)

#define  AP_3270_EMULATION                        (0x00)
#define  AP_LUA                                   (0x01)

#define  AP_LU0                                   (0x00)
#define  AP_LU1                                   (0x01)
#define  AP_LU2                                   (0x02)
#define  AP_LU3                                   (0x03)
#define  AP_LU62                                  (0x06)
#define  AP_3270_DISPLAY                          (0x10)
#define  AP_RJE_WKSTN                             (0x20)
#define  AP_UNKNOWN                               (0xFF)

#define  AP_3270_DISPLAY_MODEL_2                  (0x02)
#define  AP_3270_DISPLAY_MODEL_3                  (0x03)
#define  AP_3270_DISPLAY_MODEL_4                  (0x04)
#define  AP_3270_DISPLAY_MODEL_5                  (0x05)
#define  AP_RJE_WKSTN                             (0x20)
#define  AP_PRINTER                               (0x80)
#define  AP_SCS_PRINTER                           (0x81)

#define  AP_LEASED_LINE                           (0x00)
#define  AP_VX32                                  (0x01)

#define  AP_DISCONNECT                            (0x00)
#define  AP_CONNECT                               (0x01)
#define  AP_AUTO_CONNECT                          (0x02)

#define  AP_CONNECTING                            (0x00)
#define  AP_CONNECTED                             (0x01)
#define  AP_ERROR_LEVEL_1                         (0x02)
#define  AP_ERROR_LEVEL_2                         (0x03)
#define  AP_DISCONNECTING                         (0x04)
#define  AP_DISCONNECTED                          (0x05)
#define  AP_ADAPTER_ERROR                         (0x06)
#define  AP_ADAPTER_ACCESS_ERROR                  (0x07)
#define  AP_INCONB_MING_WAIT                      (0x08)

#define  AP_INCONB_MING                           (0x00)
#define  AP_OUTGOING                              (0x01)
#define  AP_2_WAY                                 (0x02)

#define  AP_FIXED                                 (0x12)
#define  AP_ADAPTIVE                              (0x13)

#define  AP_ADD                                   (0x00)
#define  AP_NO_ADD                                (0x01)

#define  AP_LOG_SEND                              (0x00)
#define  AP_NO_LOG_SEND                           (0x01)

#define  AP_NO_LIST_INFO                          (0x00)
#define  AP_LIST_INFO                             (0x01)

#define  AP_ORDERLY_STOP                          (0x01)
#define  AP_IMMEDIATE_STOP                        (0x02)

#define  AP_DEACT_OPER_ORDERLY                    (0x01)
#define  AP_DEACT_OPER_IMMEDIATE                  (0x02)
#define  AP_DEACT_AUTOMATIC                       (0x03)
#define  AP_DEACT_FAILURE                         (0x04)

#define  AP_PORT_NONSWITCHED                      (0x01)
#define  AP_PORT_SWITCHED                         (0x02)
#define  AP_PORT_SATF                             (0x04)
#define  AP_PORT_ATM                              (0x08)

#define  AP_NO_IMPLICIT_LINKS                     (0xFFFF)

#define  AP_DISCOVERY_CLIENT                      (0x01)
#define  AP_DISCOVERY_SERVER                      (0x02)

#define  AP_LS_TWA                                (0x00)
#define  AP_LS_TWS                                (0x01)

#define  AP_LS_NEG                                (0x00)
#define  AP_LS_PRI                                (0x01)
#define  AP_LS_SEC                                (0x02)
#define  AP_USE_PORT_DEFAULTS                     (0xFF)
#define  AP_LS_MSEC                               (0x04)

#define  AP_LOAD_OUTSTANDING                      (0x01)
#define  AP_LOAD_RESOLVED                         (0x02)

/*****************************************************************************/
/* Reasons for Local LU and DLUR LU indications                              */
/*****************************************************************************/
#define  AP_ADDED                                 (0x00)
#define  AP_REMOVED                               (0x01)
#define  AP_SSCP_ACTIVE                           (0x02)
#define  AP_SSCP_INACTIVE                         (0x03)

/*****************************************************************************/
/* Resource types for SAFE_STORE_TOPOLOGY                                    */
/*****************************************************************************/
#define  AP_SFS_NODES                             (0x01)
#define  AP_SFS_ADJ_NODES                         (0x02)
#define  AP_SFS_TGS                               (0x04)

/*****************************************************************************/
/* Appended vector types for topology query detail overlays.  Only TG        */
/* descriptors are appended at present.                                      */
/*****************************************************************************/
#define  AP_TG_DESCRIPTOR_CV                      (0x01)

/*****************************************************************************/
/* Flags to dictate retry behaviour, supplied on DEFINE_LS, DEFINE_PORT and  */
/* DEFINE_DLC, and returned on queries.                                      */
/*****************************************************************************/
#define  AP_RETRY_ON_START                        (0x80)
#define  AP_RETRY_ON_FAILURE                      (0x40)
#define  AP_RETRY_ON_DISCONNECT                   (0x20)
#define  AP_DELAY_APPLICATION_RETRIES             (0x10)
#define  AP_INHERIT_RETRY                         (0x08)
#define  AP_RETRY_ON_ACTIVATION_ERROR             (0x04)

/*****************************************************************************/
/* Use Default value for LS and Port defined data                            */
/*****************************************************************************/
#define  AP_USE_DEFAULTS                          (0xFFFF)

/*****************************************************************************/
/* LTV types for TP Load Info                                                */
/*****************************************************************************/
#define AP_TYPE_TP_PATH                (0x01)
#define AP_TYPE_TP_ARGUMENTS           (0x02)
#define AP_TYPE_TP_STDIN               (0x03)
#define AP_TYPE_TP_STDOUT              (0x04)
#define AP_TYPE_TP_STDERR              (0x05)
#define AP_TYPE_TP_ENV                 (0x06)

/*****************************************************************************/
/* Discovery primary return codes                                            */
/*****************************************************************************/
#define  AP_CCE_RC_OK                   (0)
#define  AP_CCE_RC_BAD_PARAMETER        (10)
#define  AP_CCE_RC_VALUE_OUT_OF_RANGE   (11)
#define  AP_CCE_RC_DUPLICATE_ENTRY      (12)
#define  AP_CCE_RC_NO_ENTRY             (13)
#define  AP_CCE_RC_NO_MATCH             (15)
#define  AP_CCE_RC_NO_MORE_ENTRIES      (16)
#define  AP_CCE_RC_NO_MORE_GROUPS       (17)
#define  AP_CCE_RC_STATE_ERROR          (18)
#define  AP_CCE_RC_INVALID_HANDLE       (24)
#define  AP_CCE_RC_ADAPTER_NOT_ACTIVE   (27)
#define  AP_CCE_RC_NOT_IMPLEMENTED      (101)
#define  AP_CCE_RC_FATAL_ERROR          (200)

/*****************************************************************************/
/* Discovery secondary return codes                                          */
/*****************************************************************************/
#define  AP_CCE_INSUFFICIENT_RESOURCES  (203L)
#define  AP_CCE_DLC_ERROR               (222L)
#define  AP_CCE_UNEXPECTED_SYS_ERROR    (228L)
#define  AP_CCE_INVALID_GROUP_NAME      (230L)
#define  AP_CCE_INVALID_PORT_NAME       (231L)
#define  AP_CCE_ILLEGAL_SAP             (232L)
#define  AP_CCE_GROUP_LIMIT_REACHED     (233L)

/*****************************************************************************/
/* Port Attributes                                                           */
/*****************************************************************************/

/*****************************************************************************/
/* byte 0                                                                    */
/*****************************************************************************/
#define  AP_RESOLVE_BY_LINK_ADDRESS     (0x80)
#define  AP_ALLOW_INV_ABM_SUPPORT       (0x40)

/*****************************************************************************/
/* LS Attributes                                                             */
/*****************************************************************************/

/*****************************************************************************/
/* byte 0                                                                    */
/*****************************************************************************/
#define  AP_SNA                         (0x00)
#define  AP_FNA                         (0x80)
#define  AP_HNA                         (0x40)

/*****************************************************************************/
/* byte 1                                                                    */
/*****************************************************************************/
#define  AP_SUPPRESS_CP_NAME            (0x80)
#define  AP_REACTIVATE_ON_FAILURE       (0x40)
#define  AP_USE_PU_NAME_IN_XID_CVS      (0x20)
#define  AP_USE_DSPU_NAME_IN_XID_CVS    (0x10)

/*****************************************************************************/
/* constants used for the PTF array                                          */
/*****************************************************************************/

/*****************************************************************************/
/* byte 0                                                                    */
/*   bit 0 -                                                                 */
/*   bit 1 -                                                                 */
/*   bit 2 -                                                                 */
/*   bit 3 -                                                                 */
/*   bit 4 - Set search status.  This forces the NNS of this node to forward */
/*           broadcast LOCATEs to this node.  This slows down network        */
/*           searches, so is usually only done if this EN/BrNN is unable to  */
/*           register LUs with its NNs.  But if this is a BrNN Anynet        */
/*           Gateway which registers its LUs, then only by setting this bit  */
/*           can the Anynet resources be made visible to the network.        */
/*                                                                           */
/*****************************************************************************/
#define  AP_SUPPRESS_REQDISCONT         (0x80)
#define  AP_OVERRIDE_REQDISCONT         (0x40)
#define  AP_REQDISCONT_TYPE             (0x20)
#define  AP_REQDISCONT_RECONTACT        (0x10)
#define  AP_SET_SEARCH_STATUS           (0x08)

/*****************************************************************************/
/* byte 1                                                                    */
/*****************************************************************************/
#define  AP_OVERRIDE_ERP                (0x80)

/*****************************************************************************/
/* byte 2                                                                    */
/*****************************************************************************/
#define  AP_SUPPRESS_BIS                (0x80)

/*****************************************************************************/
/* byte 3                                                                    */
/*****************************************************************************/
#define AP_EXTERNAL_APINGD              (0x80)

/*****************************************************************************/
/* byte 4                                                                    */
/*****************************************************************************/
#define  AP_ALLOW_BB_RQE                (0x80)
#define  AP_RELAX_LU03_PACING_CHECKS    (0x40)
#define  AP_SEND_ACTLU_POWER_ON         (0x20)

/*****************************************************************************/
/* byte 5                                                                    */
/*****************************************************************************/
#define  AP_LIMIT_TP_SECURITY           (0x80)

/*****************************************************************************/
/* byte 6                                                                    */
/*****************************************************************************/
#define  AP_FORCE_STANDARD_ARB          (0x80)
#define  AP_RTP_TIMES_LOGGING           (0x40)

/*****************************************************************************/
/* byte 7                                                                    */
/*****************************************************************************/
#define  AP_ADD_LEN_TO_DIRECTORY        (0x80)
#define  AP_NETWORK_QUALIFY_CP_NAME     (0x40)
#define  AP_RETRY_PRIMARY_DLUS_FIRST    (0x20)
#define  AP_LOCATE_TIMEOUT_NO_DEACT     (0x10)
#define  AP_DYNAMIC_DLUR_DEFINITION     (0x08)
#define  AP_USE_DACTPU_NOT_FINAL_USE    (0x04)
#define  AP_DLUR_UNBIND_ON_DACTLU       (0x02)
#define  AP_ADD_LEN_LU_TO_DIRECTORY     (0x01)

/*****************************************************************************/
/* byte 8                                                                    */
/*****************************************************************************/
#define  AP_TREAT_UNBIND_AS_GIVEBACK    (0x80)
#define  AP_RETRY_CNOS_ON_BIND_NEG_RSP  (0x08)
#define  AP_SEND_PU_NAME_ON_REQACTPU    (0x04)

/*****************************************************************************/
/* byte 9                                                                    */
/*****************************************************************************/
#define  AP_LUA_PASSTHRU_BB_RACE        (0x80)
#define  AP_CN_OVERRIDE_LIM_RES         (0x20)
#define  AP_NO_TCPIP_VECTOR             (0x10)

#define  AP_SDLC                                  (0x00)
#define  AP_X25                                   (0x01)
#define  AP_TR                                    (0x02)
#define  AP_LLC2                                  (0x03)
#define  AP_DLSW                                  (0x04)
#define  AP_TWINAX                                (0x05)
#define  AP_FDDI                                  (0x06)
#define  AP_ETHERNET                              (0x07)
#define  AP_FRAME_RELAY                           (0x08)
#define  AP_ISDN                                  (0x09)
#define  AP_ATM                                   (0x0A)
#define  AP_CHANNEL                               (0x0B)
#define  AP_ASYNC                                 (0x0C)
#define  AP_DFT                                   (0x0D)
#define  AP_ANYNET                                (0x0E)
#define  AP_IP                                    (0x0F)
#define  AP_GENERIC_SNA                           (0x80)
#define  AP_MPC                                   (0x81)
#define  AP_MPC_PLUS                              (0x82)
#define  AP_DLC_DLUR                              (0xFF)

#define  AP_STATS_TBL                             (0x00)
#define  AP_ADMIN_TBL                             (0x01)
#define  AP_OPER_TBL                              (0x02)

#define  AP_MANDATORY                             (0x01)

#define  AP_ADD_USER                              (0x01)
#define  AP_ADD_PROFILES                          (0x02)

#define  AP_REMOVE_USER                           (0x01)
#define  AP_REMOVE_PROFILES                       (0x02)

#define  AP_DOWNSTREAM                            (0x01)
#define  AP_INTERNAL                              (0x02)

#define  AP_CONT                                  (0x01)
#define  AP_STOP                                  (0x02)

#define  AP_LS                                    (0x01)
#define  AP_PORT                                  (0x02)

#define  AP_NO_SESSIONS                           (0x01)
#define  AP_INACTIVITY                            (0x02)

/*****************************************************************************/
/* Resource types for DLC tracing - use AP_LS and AP_PORT above              */
/*****************************************************************************/
#define  AP_ALL_RESOURCES                         (0x00)
#define  AP_DLC                                   (0x03)
#define  AP_PORT_DEFINED_LS                       (0x04)
#define  AP_PORT_IMPLICIT_LS                      (0x05)
#define  AP_ALL_DLC_TRACES                        (0x06)

/*****************************************************************************/
/* ls types for DLC tracing - use AP_ALL and AP_IMPLICIT as well             */
/*****************************************************************************/
#define  AP_DEFINED                               (0x02)

/*****************************************************************************/
/* Message types for DLC trace filtering                                     */
/*****************************************************************************/
#define  AP_TRACE_XID                             (0x01)
#define  AP_TRACE_SC                              (0x02)
#define  AP_TRACE_DFC                             (0x04)
#define  AP_TRACE_FMD                             (0x08)
#define  AP_TRACE_NLP                             (0x10)
#define  AP_TRACE_NC                              (0x20)
#define  AP_TRACE_SEGS                            (0x40)
#define  AP_TRACE_CTL                             (0x80)
#define  AP_TRACE_ALL                             (0xFF)

/*****************************************************************************/
/* Constants for SPCF security                                               */
/*****************************************************************************/
#define  AP_SPCF_PERMIT_QUERY                     (0x01)
#define  AP_SPCF_PERMIT_DEFINE                    (0x02)
#define  AP_SPCF_PERMIT_ACTION                    (0x04)

/*****************************************************************************/
/* Constants for functions supported in QUERY_NODE                           */
/*****************************************************************************/
#define  AP_NEGOTIABLE_LS                         (0x01)
#define  AP_SEGMENT_REASSEMBLY                    (0x02)
#define  AP_BIND_REASSEMBLY                       (0x04)
#define  AP_PARALLEL_TGS                          (0x08)
#define  AP_CALL_IN                               (0x10)
#define  AP_ADAPTIVE_PACING                       (0x20)
#define  AP_TOPOLOGY_AWARENESS                    (0x40)

/*****************************************************************************/
/* Constants for nn functions supported in QUERY_NODE                        */
/*****************************************************************************/
#define  AP_RCV_REG_CHAR                          (0x01)
#define  AP_GATEWAY                               (0x02)
#define  AP_CDS                                   (0x04)
#define  AP_TREE_CACHING                          (0x08)
#define  AP_TREE_UPDATES                          (0x10)
#define  AP_ISR                                   (0x20)
#define  AP_PERIPHERAL_BORDER_NODE                (0x40)
#define  AP_EXTENDED_BORDER_NODE                  (0x80)

/*****************************************************************************/
/* Constants for nn functions2 supported in QUERY_NODE                       */
/*****************************************************************************/
#define  AP_BRANCH_AWARENESS            (0x01)

/*****************************************************************************/
/* Constants for functions supported in QUERY_NN_TOPOLOGY_NODE.              */
/* These are taken from the QUERY_NODE values above with the following       */
/* replacements.                                                             */
/*****************************************************************************/
#define  AP_INTERCHANGE_NODE                      (0x01)
#define  AP_HPR                                   (0x08)
#define  AP_RTP_TOWER                             (0x10)
#define  AP_CONTROL_OVER_RTP_TOWER                (0x18)

/*****************************************************************************/
/* Constants for en functions supported in QUERY_NODE                        */
/*****************************************************************************/
#define  AP_SEGMENT_GENERATION                    (0x01)
#define  AP_MODE_TO_COS_MAP                       (0x02)
#define  AP_LOCATE_CDINIT                         (0x04)
#define  AP_REG_WITH_NN                           (0x08)
#define  AP_REG_CHARS_WITH_NN                     (0x10)

/*****************************************************************************/
/* Constants for START_LS/STOP_LS/QUERY_LS                                   */
/*****************************************************************************/
#define  AP_ACTIVATE                              (0x00)
#define  AP_AUTO_ACT                              (0x01)
#define  AP_REMOTE_ACT                            (0x02)

/*****************************************************************************/
/* Constants for stop type in STOP_NODE                                      */
/*****************************************************************************/
#define  AP_ABORT                                 (0x00)
#define  AP_SHUTDOWN                              (0x01)
#define  AP_QUIESCE                               (0x02)
#define  AP_QUIESCE_ISR                           (0x03)
#define  AP_DEACT_CLEAN                           (0x04)

/*****************************************************************************/
/* Constants for security_details field in PLU_DETAIL structure.  These      */
/* constants have the same values as the equivalent constants for the bit    */
/* settings for BIND byte 23                                                 */
/*****************************************************************************/
#define  AP_CONVERSATION_LEVEL_SECURITY ((unsigned char)0x10)
#define  AP_PERSISTENT_VERIFICATION     ((unsigned char)0x01)
#define  AP_ALREADY_VERIFIED            ((unsigned char)0x02)
#define  AP_PASSWORD_SUBSTITUTION       ((unsigned char)0x04)

/*****************************************************************************/
/* Contants for security field in QUERY_SNA_NET                              */
/*****************************************************************************/
#define  AP_SECURITY_OFF                          (0x00)
#define  AP_SECURITY_DOMAIN                       (0x01)

/*****************************************************************************/
/* Constants for config_role in QUERY_NODE_ALL                               */
/*****************************************************************************/
#define  AP_ROLE_NONE                             (0x00)
#define  AP_ROLE_MASTER                           (0x01)
#define  AP_ROLE_BACKUP                           (0x02)

/*****************************************************************************/
/* Constants for bit values of flags field in SERVER_INDICATION              */
/*****************************************************************************/
#define  AP_MASTER_FLAG                           (0x00000008L)
#define  AP_BACKUP_FLAG                           (0x00002000L)


/*****************************************************************************/
/* Primary return codes used in MS                                           */
/*****************************************************************************/
#define  AP_REPLACED                              (0x0080)

/*****************************************************************************/
/* Secondary Return Codes used in MS                                         */
/*****************************************************************************/
#define  AP_MS_APPL_NAME_ALREADY_REGD             (0x40080000L)
#define  AP_MS_APPL_NAME_NOT_REGD                 (0x44080000L)
#define  AP_INVALID_MDS_MU_FORMAT                 (0x46080000L)
#define  AP_INVALID_ORIGIN_CP_NAME                (0x47080000L)
#define  AP_SSCP_PU_SESSION_NOT_ACTIVE            (0x01030000L)
#define  AP_INVALID_MS_CATEGORY                   (0x60080000L)
#define  AP_INVALID_APPLICATION_NAME              (0x61080000L)
#define  AP_INVALID_DATA_SIZE                     (0x62080000L)
#define  AP_APPL_ALREADY_REGISTERED               (0x63080000L)
#define  AP_APPL_NOT_REGISTERED                   (0x4A080000L)
#define  AP_KEY_APPL_ALREADY_REGISTERED           (0x42080000L)
#define  AP_SPCF_APPL_ALREADY_REGD                (0x45080000L)
#define  AP_ALL_APPL_ALREADY_REGISTERED           (0x48080000L)
#define  AP_INVALID_FP_NAME                       (0x64080000L)
#define  AP_IMPLICIT_REQUEST_REJECTED             (0x65080000L)
#define  AP_INVALID_ACTIVE_TRANSACTION            (0x66080000L)
#define  AP_INVALID_CATEGORY_NAME                 (0x67080000L)
#define  AP_INVALID_DESTINATION                   (0x68080000L)
#define  AP_INVALID_TYPE                          (0x69080000L)
#define  AP_IMPLICIT_REQUEST_FAILED               (0x6A080000L)

/*****************************************************************************/
/* SNA defined return code used in MS                                        */
/*****************************************************************************/
#define  RESOURCE_SHORTAGE                        (0x00001208L)

/*****************************************************************************/
/* Major vector types                                                        */
/*****************************************************************************/
#define AP_ALL_KEYS                               (0xFFFF)
#define AP_SPCF_KEYS                              (0xFFFE)

/*****************************************************************************/
/* MS_STATUS status codes                                                    */
/*****************************************************************************/
#define AP_TARGET_HAS_DIED                        (0xEDD1E000)

/*****************************************************************************/
/* Resource types                                                            */
/*****************************************************************************/
#define  AP_LU_RESOURCE                           (0x00F3)
#define  AP_ENCP_RESOURCE                         (0x00F4)
#define  AP_NNCP_RESOURCE                         (0x00F6)
#define  AP_ASSOCIATED_RESOURCE                   (0x00F7)
#define  AP_DLUR_LU_RESOURCE                      (0x00F8)
#define  AP_WILDCARD_LU_RESOURCE                  (0x1000)

/*****************************************************************************/
/* Constants returned on QUERY_DLUS                                          */
/*****************************************************************************/
#define  AP_PERSISTENT_UNKNOWN                    (0x00)
#define  AP_PERSISTENT_SUPPORTED                  (0x01)
#define  AP_PERSISTENT_NOT_SUPPORTED              (0x02)


/*****************************************************************************/
/* Constants used by Convention LU support:                                  */
/*  (components CH, LM, PU, GW)                                              */
/*****************************************************************************/

/*****************************************************************************/
/* Interface types                                                           */
/*****************************************************************************/
#define AP_FMI 2
#define AP_TCI 3

/*****************************************************************************/
/* FMI message types                                                         */
/*****************************************************************************/
#define  AP_OPENMSG                               0x01
#define  AP_CLOSEMSG                              0x02
#define  AP_DATAFMI                               0x20
#define  AP_STATFMI                               0x21
#define  AP_DATATCI                               0x41
#define  AP_STATTCI                               0x44

/*****************************************************************************/
/* ACTLU type                                                                */
/*****************************************************************************/
#define  AP_COLD                                  ((0x01))
#define  AP_ERP                                   ((0x02))

/*****************************************************************************/
/* Open and Close sub_types                                                  */
/*****************************************************************************/
#define  AP_SSCPSEC                               0x01
#define  AP_LUSEC                                 0x02
#define  AP_SBPUSEC                               0x03
#define  AP_OERROR                                0xff

/*****************************************************************************/
/* Open and Close qualifiers                                                 */
/*****************************************************************************/
#define AP_REQU 1
#define AP_RSPOK 2
#define AP_RSPERR 3
#define AP_CONFOK 4
#define AP_CONFERR 5

/*****************************************************************************/
/* Close control_code (reason code)                                          */
/*****************************************************************************/
#define  AP_CLOSE_NORMAL                          0x01
#define  AP_CLOSE_BIND_FORTHCOMING                0x02
#define  AP_CLOSE_CFA_ERROR                       0x03
#define  AP_CLOSE_PU_INACTIVE                     0x04
#define  AP_CLOSE_LU_INACTIVE                     0x05
#define  AP_CLOSE_LINK_ERROR                      0x06
#define  AP_CLOSE_BUFF_SHORTAGE                   0x07
#define  AP_CLOSE_DFC_RCV_CHECK                   0x08
#define  AP_CLOSE_SLU_TERM                        0x09

/*****************************************************************************/
/* Status acknowledge and status control qualifiers                          */
/*****************************************************************************/
#define AP_CTLREQU 1
#define AP_ACKPOS 2
#define AP_ACKNEG1 3
#define AP_ACKNEG2 4
#define AP_ACKLUA 5

/*****************************************************************************/
/* Status Control Types                                                      */
/*****************************************************************************/
#define  AP_CCLEAR                                0x01
#define  AP_CSDT                                  0x02
#define  AP_CRQR                                  0x03
#define  AP_CSTSN                                 0x04
#define  AP_CCRV                                  0x05
#define  AP_CCANCEL                               0x10
#define  AP_CLUSTAT                               0x11
#define  AP_CSIGNAL                               0x12
#define  AP_CRSHUTD                               0x13
#define  AP_CBID                                  0x14
#define  AP_CCHASE                                0x15
#define  AP_CSHUTC                                0x16
#define  AP_CSHUTD                                0x17
#define  AP_CRTR                                  0x18
#define  AP_CBIS                                  0x19
#define  AP_CSBI                                  0x1a
#define  AP_CQC                                   0x20
#define  AP_CQEC                                  0x21
#define  AP_CRELQ                                 0x22

/*****************************************************************************/
/* Status-Session codes                                                      */
/*****************************************************************************/
#define  AP_BETWEEN_BRACKETS                      0x07
#define  AP_NO_SESSION                            0x01
#define  AP_LINK_FAILURE                          0x01
#define  AP_LINK_ERROR                            0x02
#define  AP_PU_INACTIVE                           0x10
#define  AP_PU_ACTIVE                             0x03
#define  AP_PU_REACTIVATED                        0x04
#define  AP_LU_INACTIVE                           0x11
#define  AP_LU_ACTIVE                             0x05
#define  AP_LU_REACTIVATED                        0x06
#define  AP_LINK_ERROR_INACTIVE                   0x14
#define  AP_LINK_ERROR_DEACTIVATED                0x29
#define  AP_CONN_CLOSED                           0x08

/*****************************************************************************/
/* Application flag constants                                                */
/* Flag 1:                                                                   */
/*****************************************************************************/
#define  AP_AF_FMH                                0x80
#define  AP_AF_BC                                 0x40
#define  AP_AF_EC                                 0x20
#define  AP_AF_COMM                               0x10
#define  AP_AF_BB                                 0x08
#define  AP_AF_EB                                 0x04
#define  AP_AF_CD                                 0x02
#define  AP_AF_SD                                 0x01

/*****************************************************************************/
/* Flag 2:                                                                   */
/*****************************************************************************/
#define  AP_AF_CODE                               0x80
#define  AP_AF_ENCR                               0x40
#define  AP_AF_ENPD                               0x20
#define  AP_AF_QRI                                0x10
#define  AP_AF_CEI                                0x08
#define  AP_AF_BBIU                               0x04
#define  AP_AF_EBIU                               0x02
#define  AP_AF_RBI                                0x01

/*****************************************************************************/
/* BIND check                                                                */
/*****************************************************************************/
#define  AP_BIND_CHK_LUA                          0x00
#define  AP_BIND_CHK_NONE                         0x00
#define  AP_BIND_CHK_3270_DISPLAY                 0x01
#define  AP_BIND_CHK_3270_PRINTER                 0x02
#define  AP_BIND_CHK_RJE                          0x03
#define  AP_BIND_CHK_LU1                          0x04

/*****************************************************************************/
/* RTM definitions                                                           */
/*****************************************************************************/
#define  AP_NO_CHANGE                             0x00
#define  AP_TILL_SCREEN_WRITE                     0x01
#define  AP_TILL_KEYBOARD_UNLOCKED                0x02
#define  AP_TILL_APPL_CAN_SEND                    0x03

/*****************************************************************************/
/* sense_support values passed on OPEN_LU_SSCP_SEC_RQ                        */
/*****************************************************************************/
#define  AP_SENSE_4003                            (0x0001)
#define  AP_SENSE_4004                            (0x0002)
#define  AP_SENSE_4006                            (0x0004)
#define  AP_SENSE_4007                            (0x0008)
#define  AP_SENSE_4009                            (0x0010)
#define  AP_SENSE_400A                            (0x0020)
#define  AP_SENSE_400B                            (0x0040)
#define  AP_SENSE_400C                            (0x0080)
#define  AP_SENSE_400D                            (0x0100)
#define  AP_SENSE_400F                            (0x0200)
#define  AP_SENSE_4011                            (0x0400)
#define  AP_SENSE_4012                            (0x0800)
#define  AP_SENSE_4014                            (0x1000)

/*****************************************************************************/
/* Values for app_will_send_notify field in OPEN_LU_SSCP_SEC_RQ              */
/*       AP_NONE                        (0x00)                               */
/*****************************************************************************/
#define  AP_ENABLED                               (0x01)
#define  AP_ALL_NOTIFYS                           (0x02)

/*****************************************************************************/
/* Values for seg_delivery field in OPEN_PLU_SLU_SEC_RSP                     */
/*****************************************************************************/
#define  AP_SEG_DELIVERY_SAME                     (0x00)
#define  AP_SEG_DELIVERY_NO                       (0x10)
#define  AP_SEG_DELIVERY_YES                      (0x11)

/*****************************************************************************/
/* Resource types for LU62 timeouts                                          */
/*****************************************************************************/
#define AP_GLOBAL_TIMEOUT                         (0x01)
#define AP_PARTNER_LU_TIMEOUT                     (0x02)
#define AP_LOCAL_LU_TIMEOUT                       (0x03)
#define AP_MODE_TIMEOUT                           (0x04)

/*****************************************************************************/
/* Cryptography level supported                                              */
/*      AP_NONE                        (0x00)                                */
/*****************************************************************************/
#define AP_MANDATORY                   (0x01)
#define AP_OPTIONAL                    (0x02)

/*****************************************************************************/
/* Level of cryptography in use, returned on QUERY_SESSION                   */
/*      AP_NONE                        (0x00)                                */
/*      AP_MANDATORY                   (0x01)                                */
/*****************************************************************************/

/*****************************************************************************/
/* Level of cryptography in use, returned on QUERY_LU_0_TO_3                 */
/*      AP_NONE                        (0x00)                                */
/*      AP_MANDATORY                   (0x01)                                */
/*****************************************************************************/
#define AP_PASSTHRU                    (0xFF)

/*****************************************************************************/
/* Compression level supported                                               */
/*      AP_NONE                        (0x00)                                */
/*****************************************************************************/
#define AP_RLE_COMPRESSION             (0x01)
#define AP_LZ9_COMPRESSION             (0x02)
#define AP_RLE_LZ9_COMPRESSION         (0x03)
#define AP_LZ10_COMPRESSION            (0x04)
#define AP_RLE_LZ10_COMPRESSION        (0x05)
#define AP_LZ12_COMPRESSION            (0x06)
#define AP_RLE_LZ12_COMPRESSION        (0x07)
#define AP_COMP_PASSTHRU               (0x10)

/*****************************************************************************/
/* Use of compression on sessions                                            */
/*****************************************************************************/
#define AP_COMP_PROHIBITED             (0x00)
#define AP_COMP_REQUESTED              (0x01)
#define AP_COMP_MID_POINT              (0x02)
#define AP_COMP_END_POINT              (0x03)
#define AP_COMP_NOT_REQUESTED          (0x04)

/*****************************************************************************/
/* Level of compression in use, returned on QUERY_LU_0_TO_3                  */
/*      AP_NO                          (0x00)                                */
/*      AP_YES                         (0x01)                                */
/*      AP_PASSTHRU                    (0xFF)                                */
/*****************************************************************************/

/*****************************************************************************/
/* Constants for DEFINE_DSPU_TEMPLATE                                        */
/*****************************************************************************/
#define  AP_REPLACE_DSPU_TEMPLATE       (0x00)
#define  AP_MODIFY_DSPU_TEMPLATE        (0x01)

/*****************************************************************************/
/* Possible values of TG type for TOPOLOGY_TG_DETAIL.  The value AP_UNKNOWN  */
/* may also be returned.                                                     */
/*****************************************************************************/
#define  AP_APPN_OR_BOUNDARY_TG         (0x00)
#define  AP_INTERCHANGE_TG              (0x01)
#define  AP_VIRTUAL_ROUTE_BASED_TG      (0x02)

/*****************************************************************************/
/* Flags for name_attributes field on DEFINE_LU_0_TO_3_RANGE and             */
/* DELETE_LU_0_TO_3_RANGE                                                    */
/*****************************************************************************/
#define  AP_USE_BASE_NUMBER             (0x01)
#define  AP_USE_HEX_IN_NAME             (0x02)
/*****************************************************************************/
/* Possible values for null_address_meaning field in DEFINE_LS and QUERY_LS  */
/*****************************************************************************/
#define  AP_SATF_NULL_MEANS_WILDCARD  (0x00)
#define  AP_SATF_NULL_MEANS_USE_NAME  (0x01)


/*****************************************************************************/
/* Possible values for brnn_link_type field in QUERY_LS and TOPOLOGY         */
/* Indications and Queries.                                                  */
/* AP_UPLINK and AP_DOWNLINK are also (the only) valid values for            */
/* branch_link_type in a DEFINE_LS on a BrNN.                                */
/*****************************************************************************/
#define AP_BRNN_NOT_SUPPORTED          (0x00)
#define AP_UPLINK                      (0x01)
#define AP_DOWNLINK                    (0x02)
#define AP_DOWNLINK_TO_BRNN            (0x03)
#define AP_OTHERLINK                   (0x04)
#define AP_UNKNOWN_LINK_TYPE           (0xFF)

/*****************************************************************************/
/* Possible values for adj_brnn_cp_support field in DEFINE_LS and QUERY_LS   */
/*****************************************************************************/
#define AP_BRNN_ALLOWED      (0x00)
#define AP_BRNN_REQUIRED     (0x01)
#define AP_BRNN_PROHIBITED   (0x02)

/*****************************************************************************/
/* BrNN values for reg_with_nn field in CP_CREATE_PARMS                      */
/*****************************************************************************/
#define AP_REGISTER_NONE               (0x00)
#define AP_REGISTER_ALL                (0x01)
#define AP_REGISTER_LOCAL_ONLY         (0x02)

/*****************************************************************************/
/* Possible values for cos_table_verison in CP_CREATE_PARMS                  */
/*****************************************************************************/
#define AP_VERSION_0_COS_TABLES (0x00)
#define AP_VERSION_1_COS_TABLES (0x01)

/*****************************************************************************/
/* This value may be set in the hpr_support field of DEFINE_LS, and the      */
/* implicit_hpr_support field of DEFINE_PORT, to indicate that the link may  */
/* be part of an Multi-link Transmission Group                               */
/*****************************************************************************/
#define AP_MLTG                        (0x02)

/*****************************************************************************/
/* Possible values for mltg_pacing_algorithm on DEFINE_LS and DEFINE_PORT.   */
/*****************************************************************************/
#define AP_LMP                         (0x00)
#define AP_ROUND_ROBIN_WITH_LMP        (0x01)

/*****************************************************************************/
/* Possible values for term_method on DEFINE_LU_0_TO_3 and                   */
/* DEFINE_LU_0_TO_3_RANGE                                                    */
/*****************************************************************************/
#define AP_USE_NODE_DEFAULT            (0x00)
#define AP_SEND_UNBIND                 (0x01)
#define AP_SEND_TERM_SELF              (0x02)

/*****************************************************************************/
/* The status of a TG with respect to TG sharing (for QUERY_LS and           */
/* LS_INDICATION)                                                            */
/*****************************************************************************/
#define AP_TG_NOT_SHAREABLE            (0x01)
#define AP_TG_SHAREABLE                (0x02)

/*****************************************************************************/
/* The Link Station type (for QUERY_LS and LS_INDICATION)                    */
/*****************************************************************************/
#define AP_LS_DEFINED                  (0x00)
#define AP_LS_DYNAMIC                  (0x01)
#define AP_LS_TEMPORARY                (0x02)
#define AP_LS_IMPLICIT                 (0x03)
#define AP_LS_DISCOVERY                (0x04)
#define AP_LS_DLUS_DEFINED             (0x05)

/*****************************************************************************/
/* Types of connection networks (used in CN_DEF_DATA on DEFINE_CN and        */
/* QUERY_CN)                                                                 */
/*****************************************************************************/
#define AP_SINGLE_TG_CN                (0x00)
#define AP_MULTIPLE_TG_CN              (0x01)

/*****************************************************************************/
/* Available formats for link spec data                                      */
/*****************************************************************************/
#define AP_UNSPECIFIED_FORMAT          (0x00)
#define AP_SVC_TRAFFIC_PARMS           (0x01)

/*****************************************************************************/
/* implicit_links_len options on DEFINE_PORT                                 */
/*      AP_NO                          (0x00)                                */
/*****************************************************************************/
#define AP_YES_USE_CP_NAME             (0x01)
#define AP_YES_GENERATE_CP_NAME        (0x02)

/*****************************************************************************/
/* flags for limit_enable bit-field on DEFINE_PORT                           */
/*****************************************************************************/
#define AP_DLUS_DEPENDENT              (0x80)
#define AP_CP_CP_SESS_TO_NNS_DEPENDENT (0x20)
#define AP_IMPLICIT_LIMIT_DEPENDENT    (0x40)

/*****************************************************************************/
/* persistent_pipe_support values on DEFINE_DLUR_DEFAULTS                    */
/*****************************************************************************/
#define AP_ALLOW                       (0x00)
#define AP_REQUEST                     (0x01)
#define AP_REQUEST_AND_KEEP            (0x02)
#define AP_REQUIRE_AND_KEEP            (0x03)

/*****************************************************************************/
/*        Parameters for the Common Service Verbs.                           */
/*****************************************************************************/

#define SV_ADD                                     0
#define SV_NO_ADD                                  1
#define SV_CHANGE                                  1
#define SV_IGNORE                                  0
#define SV_SEND                                    0
#define SV_NO_SEND                                 1

#define SV_NO                                      0x00
#define SV_YES                                     0x01
#define SV_A                                       0x01
#define SV_AE                                      0x00
#define SV_ASCII_TO_EBCDIC                         0x00

#define SV_PROBLEM                                 0x00
#define SV_EXCEPTION                               0x01
#define SV_AUDIT                                   0x02
#define SV_INTRV                                   SV_PROBLEM
#define SV_NO_INTRV                                SV_EXCEPTION
#define SV_INTRV_16                                SV_PROBLEM
#define SV_NO_INTRV_16                             SV_PROBLEM
#define SV_NO_INTRV_10                             SV_EXCEPTION
#define SV_NO_INTRV_8                              SV_AUDIT
#define SV_NO_INTRV_6                              SV_AUDIT

#define SV_EBCDIC_TO_ASCII                         0x01
#define SV_G                                       0x02
#define SV_OFF                                     0x00
#define SV_ON                                      0x01
#define SV_SUBSTITUTE                              0x00
#define SV_ROUND_TRIP                              0x01
#define SV_NEW                                     0x00
#define SV_OVERWRITE                               0x01

/*****************************************************************************/
/*        Return Codes from the Common Service Verbs.                        */
/*****************************************************************************/

#define SV_OK                                     (0x0000)
#define SV_PARAMETER_CHECK                        (0x0100)
#define SV_STATE_CHECK                            (0x0200)
#define SV_FILE_ALREADY_EXISTS                    (0x3000)
#define SV_OUTPUT_DEVICE_FULL                     (0x3100)
#define SV_INVALID_VERB_SEGMENT                   (0x08F0)
#define SV_UNEXPECTED_DOS_ERROR                   (0x11F0)
#define SV_UNEXPECTED_SYSTEM_ERROR                (0x11F0)
#define SV_COMM_SUBSYSTEM_NOT_LOADED              (0x12F0)
#define SV_INVALID_VERB                           (0xFFFF)

#define SV_CONVERSION_ERROR                   (0x06040000L)
#define SV_DATA_EXCEEDS_RU_SIZE               (0x02030000L)
#define SV_INVALID_CHARACTER_SET              (0x02040000L)
#define SV_INVALID_DATA_SEGMENT               (0x06000000L)
#define SV_INVALID_DATA_TYPE                  (0x03030000L)
#define SV_INVALID_DIRECTION                  (0x01040000L)
#define SV_INVALID_FIRST_CHARACTER            (0x04040000L)
#define SV_INVALID_MESSAGE_ACTION             (0x21060000L)
#define SV_INVALID_SET                        (0x24060000L)
#define SV_INVALID_STORAGE_SIZE               (0x27060000L)
#define SV_SSCP_PU_SESSION_NOT_ACTIVE         (0x01030000L)
#define SV_INVALID_NMVT_ERROR                 (0x04030000L)
#define SV_TABLE_ERROR                        (0x05040000L)
#define SV_INVALID_RESET_TRACE                (0x2F060000L)
#define SV_INVALID_CHAR_NOT_FOUND             (0x30060000L)
#define SV_INVALID_SOURCE_CODE_PAGE           (0x31060000L)
#define SV_INVALID_TARGET_CODE_PAGE           (0x32060000L)
#define SV_TRACE_NOT_STOPPED                  (0x2A060000L)
#define SV_INVALID_FILE_OPTION                (0x2B060000L)
#define SV_TRACE_BUFFER_EMPTY                 (0X2C060000L)

/*****************************************************************************/
/* Verb parameter values for TRANSFER_MS_DATA                                */
/*****************************************************************************/
#define  SV_TIME_STAMP_SUBVECTOR                  (0x80)
#define  SV_PRODUCT_SET_ID_SUBVECTOR              (0x40)
#define  SV_SEND_ON_SESSION                       (0x20)
#define  SV_LOCAL_LOGGING                         (0x10)

#define  SV_ALL_OPTIONS_SET                       (0x00)
#define  SV_NO_OPTIONS_SET                        (0xF0)

#define  SV_USER_DEFINED                          (0x00)
#define  SV_NMVT                                  (0x01)
#define  SV_ALERT_SUBVECTORS                      (0x02)
#define  SV_PDSTATS_SUBVECTORS                    (0x03)
#define  SV_HELD_ALERT_SUBVECTORS                 (0x04)
#define  SV_RESOLUTION_SUBVECTORS                 (0x05)

#define  SV_LOG                                   (0x00)
#define  SV_NO_LOG                                (0x01)

/*****************************************************************************/
/* Trace-type constants for SET_ and QUERY_TRACE_TYPE                        */
/*****************************************************************************/
#define      AP_NO_TRACE 0x00000000L

#define      AP_NODE_MSG 0x00000001L /* SNAP APPN IPS trace                  */
#define      AP_NODE_DLC 0x00000002L /* SNAP APPN DLC trace                  */

#define      AP_APPC_MSG 0x00000004L /* APPC stub to APPC library            */
#define      AP_FM_MSG   0x00000008L /* FM stub to FM library messages       */
#define      AP_LUA_MSG  0x00000010L /* LUA stub to LUA library messages     */
#define      AP_NOF_MSG  0x00000020L /* NOF stub to..                        */
#define      AP_MS_MSG   0x00000040L /* MS ...                               */

#define      AP_DLPI_MSG 0x00000080L /* DLPI messages                        */
#define      AP_LLI_MSG  0x00000100L /* LLI messages                         */

#define      AP_SDLC_MSG 0x00000200L /* SNAP LINK IPS trace                  */

#define      AP_DLC_MSG  0x00000400L /* DLC stub to any DLC driver           */

#define      AP_DATAGRAM 0x00000800L /* Datagrams (ALL)                      */

#define      AP_NLI_MSG  0x00001000L /* NLI messages                         */
#define      AP_MAC_MSG  0x00002000L /* NMAC messages                        */
#define      AP_GDLC_MSG 0x00004000L /* GDLC tracing (= V0_SDLC_MSG)         */
#define      AP_LLC2_MSG 0x00008000L /* SNAP-LLC2 messages                   */
#define      AP_PV_MSG   0x00010000L /* PV API messages                      */

#define      AP_ALL_TRACE 0xFFFFFFFFL

/*****************************************************************************/
/* Trace-type constants for SET_ and QUERY_CS_TRACE                          */
/*****************************************************************************/
#define  AP_CS_ADMIN_MSG   (0x0001)
#define  AP_CS_DATAGRAM    (0x0002)
#define  AP_CS_DATA        (0x0004)

#define  AP_CS_SEND        (0x0100)
#define  AP_CS_RECEIVE     (0x0200)
#define  AP_CS_BOTH        (0x0300)

/*****************************************************************************/
/* Primary return codes used by LU1-3 API                                    */
/*****************************************************************************/
#define  AP_SHUT                        (0x000E)
#define  AP_SENSE_CODE                  (0x001E)
#define  AP_RCANC                       (0x002E)
#define  AP_NSES                        (0x003E)

/*****************************************************************************/
/* Primary return code to indicate that the node is not licensed             */
/*****************************************************************************/
#define  AP_NOT_LICENSED                (0X006E)

/*****************************************************************************/
/* Secondary return codes - used by NOF library                              */
/*****************************************************************************/

/*****************************************************************************/
/* primary_rc = AP_UNEXPECTED_SYSTEM_ERROR                                   */
/*****************************************************************************/
#define  AP_OUT_OF_MEMORY                     (0x00005501L)
#define  AP_FILE_ROLE_UNAVAILABLE             (0x00005502L)
#define  AP_CONNECTION_NOT_MADE               (0x00005503L)

#define  AP_START_FAILED                      (0x00005504L)
#define  AP_RESTORE_FAILED                    (0x00005505L)
#define  AP_LOAD_FAILED                       (0x00005506L)

#define  AP_NOF_NOT_CREATED                   (0x00005507L)
#define  AP_STUB_NOT_CREATED                  (0x00005508L)

#define  AP_FILE_READ_FAILED                  (0x00005509L)

/*****************************************************************************/
/* primary_rc = AP_PARAMETER_CHECK                                           */
/*****************************************************************************/
#define  AP_INVALID_TARGET_HANDLE             (0x00005511L)
#define  AP_INVALID_TARGET                    (0x00005512L)
#define  AP_INVALID_TARGET_STATE              (0x00005513L)
#define  AP_INVALID_TARGET_MODE               (0x00005514L)
#define  AP_INVALID_NODE_NAME                 (0x00005515L)
#define  AP_DUPLICATE_NODE_NAME               (0x00005516L)
#define  AP_INVALID_FILE_INFO                 (0x00005517L)
#define  AP_INVALID_FILE_NAME                 (0x00005518L)
#define  AP_INVALID_PROC_MODE                 (0x00005519L)
#define  AP_SYNC_NOT_ALLOWED                  (0x0000551AL)
#define  AP_INVALID_VERB_SCOPE                (0x0000551BL)
#define  AP_NO_CENTRAL_LOG                    (0x0000551CL)
#define  AP_INVALID_FILE_TYPE                 (0x0000551DL)
#define  AP_INVALID_LOAD_PHASE                (0x0000551EL)
#define  AP_INVALID_3270_USER                 (0x0000551FL)
#define  AP_INVALID_SESSION_NUMBER            (0x00005520L)
#define  AP_INVALID_ALERT_NUMBER              (0x00005521L)
#define  AP_INVALID_3270_SESSION              (0x00005522L)
#define  AP_INVALID_RTM_THRESHOLD             (0x00005523L)
#define  AP_UNKNOWN_TP                        (0x00005526L)
#define  AP_INVALID_TIMEOUT                   (0x00005529L)
#define  AP_INVALID_FILE_ACTION               (0x0000552AL)
#define  AP_INVALID_FILE_SIZE                 (0x0000552BL)
#define  AP_NOT_CENTRAL_LOGGER                (0x0000552CL)
#define  AP_INVALID_TRUNC_LEN                 (0x0000552DL)
#define  AP_UCF_USER_CANNOT_BE_ROOT           (0x0000552EL)
#define  AP_INVALID_SPCF_SECURITY             (0x0000552FL)
#define  AP_INVALID_FORMAT                    (0x00005530L)
#define  AP_INVALID_RJE_WKSTN                 (0x00005531L)
#define  AP_INVALID_CALLBACK_HANDLE           (0x000000D6L)
#define  AP_NAME_NOT_FOUND                    (0x00005532L)
#define  AP_LOCAL_SYSTEM                      (0x00005533L)
#define  AP_NOT_MASTER                        (0x00005534L)
#define  AP_INVALID_TRC_DIRECTION             (0x00005535L)
#define  AP_INVALID_EMULATOR_USER             (0x00005536L)
#define  AP_INVALID_SESSION_NAME              (0x00005537L)
#define  AP_INVALID_SESSION_TYPE              (0x00005538L)
#define  AP_INVALID_USER_SESSION              (0x00005539L)
#define  AP_NOT_SERVER                        (0x0000553AL)
#define  AP_INVALID_SUCCINCT_SETTING          (0x0000553BL)
#define  AP_INVALID_CLIENT_ADDRESS            (0x0000553CL)
#define  AP_INVALID_PORT_NUMBER               (0x0000553DL)
#define  AP_CLIENT_ADDRESS_CLASH              (0x0000553EL)
#define  AP_UNKNOWN_CLIENT_ADDRESS            (0x0000553FL)
#define  AP_TCPIP_PORT_IN_USE                 (0x00005580L)
#define  AP_DUPLICATE_ADAPTER_NUMBER          (0x00005581L)
#define  AP_INVALID_AUTH_TYPE                 (0x00005582L)

#define  AP_INVALID_SUPPLIED_KEY              (0x40FF0000L)
#define  AP_INVALID_PRIMARY_KEY               (0x41FF0000L)
#define  AP_INVALID_SECONDARY_KEY             (0x42FF0000L)
#define  AP_SECONDARY_KEY_IN_USE              (0x43FF0000L)
#define  AP_UNSUPPORTED_RESOURCE_TYPE         (0x44FF0000L)
#define  AP_INVALID_EXTRA_DATA_LEN            (0x45FF0000L)
#define  AP_INVALID_TN3270_SUPPORT            (0x46FF0000L)
#define  AP_ASSOCIATION_NOT_DEFD              (0x47FF0000L)
#define  AP_INVALID_KEEPALIVE                 (0x48FF0000L)
#define  AP_NOT_WORKING_DB                    (0x49FF0000L)
#define  AP_CANT_DELETE_LAST_BACKUP           (0x4AFF0000L)
#define  AP_ALREADY_OPEN                      (0x4BFF0000L)
#define  AP_FILE_EXISTS                       (0x4CFF0000L)
#define  AP_NOT_VERIFIED                      (0x4DFF0000L)
#define  AP_INVALID_CP_SSCP_SUPPORT           (0x4EFF0000L)
#define  AP_UNKNOWN_IP_HOST                   (0x4FFF0000L)

#define  AP_INVALID_LU_TYPE                   (0x50FF0000L)
#define  AP_BAD_SESS_TYPE                     (0x51FF0000L)
#define  AP_INVALID_LIST_NAME                 (0x55FF0000L)
#define  AP_INVALID_USER_NAME                 (0x56FF0000L)
#define  AP_INVALID_NUM_GROUPS                (0x57FF0000L)
#define  AP_INVALID_TP_TYPE                   (0x58FF0000L)
#define  AP_INVALID_TP_STYLE                  (0x59FF0000L)
#define  AP_INVALID_LTV_LENGTH                (0x60FF0000L)
#define  AP_INVALID_LTV_TYPE                  (0x61FF0000L)
#define  AP_INVALID_LTV_VALUE                 (0x62FF0000L)
#define  AP_SECURITY_LIST_NOT_DEFINED         (0x63FF0000L)
#define  AP_INVALID_SPEC_DATA_LEN             (0x65FF0000L)
#define  AP_CANT_RESOLVE_LOCAL_IP             (0x68FF0000L)
#define  AP_CLIENT_CLASH                      (0x69FF0000L)
#define  AP_INVALID_LOAD_BALANCING            (0x6AFF0000L)
#define  AP_INVALID_FREQUENCY                 (0x6BFF0000L)
#define  AP_INVALID_THRESHOLD                 (0x6CFF0000L)
#define  AP_INVALID_LOAD_FACTOR               (0x6DFF0000L)
#define  AP_INVALID_SCOPE                     (0x6EFF0000L)
#define  AP_INVALID_NUM_SCOPES                (0x6FFF0000L)
#define  AP_DUPLICATE_LINK_ADDRESS            (0x70000000L)

/*****************************************************************************/
/* primary_rc = AP_STATE_CHECK                                               */
/*****************************************************************************/
#define  AP_SYNC_PENDING                      (0x00005541L)
#define  AP_TARGET_ABENDED                    (0x00005542L)
#define  AP_LOCAL_ABENDED                     (0x00005543L)
#define  AP_VERB_IN_PROGRESS                  (0x00005544L)
#define  AP_FILE_LOCK_FAILED                  (0x00005545L)
#define  AP_FILE_UNLOCK_FAILED                (0x00005546L)
#define  AP_FILE_NOT_WRITTEN                  (0x00005547L)
#define  AP_FILE_NOT_LOCKED                   (0x00005548L)
#define  AP_FILE_UNAVAILABLE                  (0x00005549L)
#define  AP_FILE_BAD_RECORD                   (0x0000554AL)
#define  AP_NODE_DELETED                      (0x0000554BL)
#define  AP_FILE_LOCKED                       (0x0000554CL)
#define  AP_RESOURCE_NOT_LOADED               (0x0000554DL)
#define  AP_NODE_PART_LOADED                  (0x0000554EL)
#define  AP_DUPLICATE_RECORD                  (0x0000554FL)
#define  AP_INITIALIZATION_FAILED             (0x00005550L)
#define  AP_CONNECT_FAILED                    (0x00005551L)
#define  AP_INVALID_VERSION                   (0x00005552L)
#define  AP_RECORD_NOT_FOUND                  (0x00005553L)
#define  AP_MACHINE_ACTIVE                    (0x00005554L)
#define  AP_SAVE_NODE_FAILED                  (0x00005555L)
#define  AP_ACTIVE_CONFIG_UNAVAIL             (0x00005556L)
#define  AP_SAVE_IN_PROGRESS                  (0x00005557L)
#define  AP_MASTER_TAKEOVER                   (0x00005558L)
#define  AP_TN_SERVER_FAILED                  (0x00005559L)
#define  AP_NODE_NOT_CONFIGURED               (0x0000555AL)
#define  AP_TN_SERVER_ACTIVE                  (0x0000555BL)
#define  AP_ALLOCATE_BAD_STATE                (0x52FF0000L)
#define  AP_SEND_FMH_NOT_SEND_STATE           (0x53FF0000L)
#define  AP_SEND_STATUS_BAD_STATE             (0x54FF0000L)
#define  AP_NOT_AUTHORIZED                    (0x67FF0000L)
#define  AP_NO_FREE_TRACE_CHANNELS            (0x71000000L)

/*****************************************************************************/
/* primary_rc = AP_INDICATION                                                */
/*****************************************************************************/
#define  AP_EXTRA_DATA_LOST                   (0x00005561L)

/*****************************************************************************/
/* Additional secondary return codes used by AnyNet                          */
/* These codes use the range reserved by SNAP APPN for customer use, namely, */
/* (0x??FF0000)                                                              */
/*****************************************************************************/
#define  AP_INVALID_DOMAIN_NAME_SUFFIX        (0x10FF0000)
#define  AP_INVALID_CONNWAIT                  (0x11FF0000)
#define  AP_INVALID_UNACK_RETRY               (0x12FF0000)
#define  AP_INVALID_UNSENT_RETRY              (0x13FF0000)
#define  AP_INVALID_INACTIVITY_SWEEP          (0x14FF0000)
#define  AP_INVALID_MAP_NAME                  (0x15FF0000)
#define  AP_NO_MATCHING_MAP                   (0x16FF0000)
#define  AP_INVALID_IP_ADDRESS                (0x17FF0000)
#define  AP_INVALID_MAP_MASK                  (0x18FF0000)
#define  AP_INVALID_LU_MAP_TEMPLATE           (0x19FF0000)
#define  AP_INVALID_NETWORK_NAME              (0x1AFF0000)
#define  AP_ANYNET_ACTIVE                     (0x1BFF0000)
#define  AP_INVALID_SEND_BUFFER               (0x1CFF0000)
#define  AP_INVALID_DATAGRAM_TIMEOUT          (0x1DFF0000)
#define  AP_INVALID_CONNECTION_START          (0x1EFF0000)
#define  AP_INVALID_SUBNET_MASK               (0x1FFF0000)
#define  AP_INVALID_CONNECTION_RETRY_TIME     (0x20FF0000)
#define  AP_INVALID_GATEWAY_NAME              (0x21FF0000)
#define  AP_ANYNET_FAILED                     (0x23FF0000)
#define  AP_INVALID_ANYNET_ID                 (0x24FF0000)
#define  AP_ANYNET_STOPPING                   (0x25FF0000)
#define  AP_ANYNET_STARTING                   (0x26FF0000)
#define  AP_NON_UNIQUE_MAPPING                (0x27FF0000)
#define AP_CANT_DELETE_SNACKETS_LU            (0x28FF0000)

/*****************************************************************************/
/* Extra value for Yes or No field - don't change from current value.        */
/* This must be a different value from AP_YES and AP_NO                      */
/*****************************************************************************/
#define  AP_LEAVE_UNCHANGED                       (0x11)

/*****************************************************************************/
/* SPCF Permission flags                                                     */
/*****************************************************************************/
#define  AP_ALLOW_QUERY_LOCAL           0x00000001
#define  AP_ALLOW_DEFINE_LOCAL          0x00000002
#define  AP_ALLOW_ACTION_LOCAL          0x00000004

#define  AP_ALLOW_QUERY_REMOTE          (AP_ALLOW_QUERY_LOCAL  << 16)
#define  AP_ALLOW_DEFINE_REMOTE         (AP_ALLOW_DEFINE_LOCAL << 16)
#define  AP_ALLOW_ACTION_REMOTE         (AP_ALLOW_ACTION_LOCAL << 16)

/*****************************************************************************/
/* Node status on CONNECT_NODE                                               */
/*****************************************************************************/
#define  AP_NDE_STARTING                          (0x01)
#define  AP_NDE_STARTED                           (0x02)
#define  AP_NDE_STOPPING                          (0x03)
#define  AP_NDE_STOPPED                           (0x04)

/*****************************************************************************/
/* Node type on CONNECT_NODE.  CONNECT_NODE either connects to the node with */
/* the name specified on the verb or to the node containing the central      */
/* logger.                                                                   */
/*****************************************************************************/
#define  AP_SPECIFIED_NODE                        (0x01)
#define  AP_CENTRAL_LOGGER                        (0x02)

/*****************************************************************************/
/* Mode on SET_PROCESSING_MODE                                               */
/*****************************************************************************/
#define  AP_MODE_READ_ONLY                        (0x11)
#define  AP_MODE_READ_WRITE                       (0x12)
#define  AP_MODE_COMMIT                           (0x13)
#define  AP_MODE_SYNC                             (0x14)

/*****************************************************************************/
/* Configuration file role                                                   */
/*****************************************************************************/
#define  AP_MASTER                                (0x01)
#define  AP_BACKUP                                (0x02)
#define  AP_SPECIFIED                             (0x03)
#define  AP_SPECIFIED_NEW                         (0x04)
#define  AP_SNA_NET                               (0x05)
#define  AP_TP_LOAD_INFO                          (0x06)

/*****************************************************************************/
/* Field values for ms support in the node create parms  - this field is     */
/* not present for all platforms.                                            */
/*****************************************************************************/
#define AP_MS_NORMAL                              (0x00)
#define AP_CSAIX_BACK_LEVEL                       (0x01)
#define AP_CSAIX_MIGRATION_LEVEL                  (0x02)

/*****************************************************************************/
/* Log file type - bit significant field                                     */
/*****************************************************************************/
#define  AP_AUDIT_FILE                            (0x01)
#define  AP_ERROR_FILE                            (0x02)
#define  AP_USAGE_FILE                            (0x04)

/*****************************************************************************/
/* Action on a set log file verb                                             */
/*****************************************************************************/
#define  AP_NO_FILE_ACTION                        (0x00)
#define  AP_DELETE_FILE                           (0x01)
#define  AP_BACKUP_FILE                           (0x02)

/*****************************************************************************/
/* Trace file type - bit significant field                                   */
/*****************************************************************************/
#define  AP_INTERNAL_TRACE                        (0x01)
#define  AP_IPS_TRACE                             (0x02)
#define  AP_CS_TRACE                              (0x04)
#define  AP_TN_SERVER_TRACE                       (0x08)
#define  AP_BCK_CS_TRACE                          (0x10)
#define  AP_TN3270_SLP_TRACE                      (0x20)

/*****************************************************************************/
/* SLIM trace type - bit significant field                                   */
/*****************************************************************************/
#define  AP_CS_NO_TRACE    (0x0000)
#define  AP_CS_ADMIN_MSG   (0x0001)
#define  AP_CS_DATAGRAM    (0x0002)
#define  AP_CS_DATA        (0x0004)
#define  AP_CS_ALL_TRACE   (AP_CS_ADMIN_MSG | AP_CS_DATAGRAM | AP_CS_DATA)

#define  AP_CS_SEND        (0x0100)
#define  AP_CS_RECEIVE     (0x0200)
#define  AP_CS_BOTH        (0x0300)

/*****************************************************************************/
/* TN Server trace type - bit significant field                              */
/*****************************************************************************/
#define  AP_TN_SERVER_NO_TRACE        (0x0000)
#define  AP_TN_SERVER_TRC_TCP         (0x0001)
#define  AP_TN_SERVER_TRC_FM          (0x0002)
#define  AP_TN_SERVER_TRC_CFG         (0x0004)
#define  AP_TN_SERVER_TRC_NOF         (0x0008)
#define  AP_TN_SERVER_ALL_TRACE       (AP_TN_SERVER_TRC_TCP |  \
                                       AP_TN_SERVER_TRC_FM  |  \
                                       AP_TN_SERVER_TRC_CFG |  \
                                       AP_TN_SERVER_TRC_NOF)

/*****************************************************************************/
/* TN3270 SLP trace type - bit significant field                             */
/*****************************************************************************/
#define  AP_TN3270_SLP_NO_TRACE       (0x0000)
#define  AP_TN3270_SLP_TRC_TCP        (0x0001)
#define  AP_TN3270_SLP_TRC_CFG        (0x0002)
#define  AP_TN3270_SLP_TRC_NOF        (0x0004)
#define  AP_TN3270_SLP_ALL_TRACE      (AP_TN3270_SLP_TRC_TCP |  \
                                       AP_TN3270_SLP_TRC_CFG |  \
                                       AP_TN3270_SLP_TRC_NOF)

/*****************************************************************************/
/* Back Level SLIM trace type - bit significant field                        */
/*****************************************************************************/
#define  AP_BCK_NO_TRACE   (0x00000000)
#define  AP_BCK_UDP_TRACE  (0x00000001)
#define  AP_BCK_TCP_TRACE  (0x00000002)
#define  AP_BCK_MS_TRACE   (0x00000004)
#define  AP_BCK_UDP_TEXT   (0x00000008)
#define  AP_BCK_TCP_TEXT   (0x00000010)
#define  AP_BCK_TEXT       (0x00000020)
#define  AP_BCK_ALL_TRACE  (0xFFFFFFFF)

/*****************************************************************************/
/* Constants for 3270 diagnostics record                                     */
/*****************************************************************************/
                                   /* RTM timers run until:                  */
#define AP_RTM_SCREEN       0      /* - first data reaches screen            */
#define AP_RTM_UNLOCK       1      /* - host unlocks keyboard                */
#define AP_RTM_DIRECTION    2      /* - host lets user send                  */

/*****************************************************************************/
/* Constants for 3270 user record                                            */
/*****************************************************************************/
#define AP_NOT_LIMITED    2        /* no limit on number of active sessions  */
#define AP_LIMITED        0        /* limit on number of active sessions     */

/*****************************************************************************/
/* Values used to determine the scope of a search in query_rje_wkstn         */
/*****************************************************************************/
#define AP_WKSTN           1            /* Match on the Wkstn Name           */
#define AP_WKSTN_AT_SYSTEM 3            /* Match on Wkstn AND System name    */
#define AP_WKSTN_PROCESS   7            /* Match to a single Wkstn process   */

/*****************************************************************************/
/* Values used to determine the scope of a search in query_3270_user         */
/*****************************************************************************/
#define AP_USER           1             /* Match on the User Name            */
#define AP_SYSTEM         2             /* Match on the System Name          */
#define AP_USER_AT_SYSTEM 3             /* Match on User AND System name     */
#define AP_USER_PROCESS   7             /* Match to a single User process    */

/*****************************************************************************/
/* Values used to specify session types in query_3270_user_sessions.         */
/*****************************************************************************/
#define AP_SESSION_ALL                 (0x0100)
#define AP_SESSION_3270                (0x0101)
#define AP_SESSION_5250                (0x0102)

/*****************************************************************************/
/* Values used in emulator configuration verbs                               */
/* DEFINE_EMULATOR_USER                                                      */
/* DELETE_EMULATOR_USER                                                      */
/* QUERY_EMULATOR_USER                                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Values for change_style field                                             */
/*****************************************************************************/
#define AP_STYLE_ADVANCED              (0x02)
#define AP_STYLE_NORMAL                (0x01)
#define AP_STYLE_INITIAL               (0x03)
#define AP_STYLE_RESTRICTED            (0x00)

/*****************************************************************************/
/* Values for emulator_type fields                                           */
/* each AP_xxx_SESSION is a flag; AP_ALL_SESSIONS is the combination of all  */
/* flags (present and future)                                                */
/*****************************************************************************/
#define AP_DELETE_USER                 (0x00)  /* only for DELETE            */
#define AP_3270_SESSION                (0x01)
#define AP_5250_SESSION                (0x02)
#define AP_ALL_SESSIONS                (0xFF)  /* only for QUERY/DELETE      */

/*****************************************************************************/
/* Values for 5250 session type                                              */
/*****************************************************************************/
#define AP_5250_DISPLAY                (0x00)
#define AP_5250_PRINTER                (0x01)

/*****************************************************************************/
/* Values for TN Server access records                                       */
/*****************************************************************************/
#define  AP_ADDRESS_IP                    0
#define  AP_ADDRESS_FQN                   1
#define  AP_TN3270                                (0x01)
#define  AP_TN3270E                               (0x00)

/*****************************************************************************/
/* Values for TN Server defaults records                                     */
/*****************************************************************************/
#define  AP_TN3270_NOP                            (0x01)
#define  AP_TN3270_TM                             (0x02)

/*****************************************************************************/
/* Constants used by TN Server SSL LDAP record.                              */
/*****************************************************************************/
#define  AP_YES_WITH_CLI_AUTH                     (0x02)

#define  AP_LOCAL_ONLY                            (0x00)
#define  AP_LOCAL_X500                            (0x01)

/*****************************************************************************/
/* Values for TN Server session user info records                            */
/*****************************************************************************/
#define  AP_LEVEL_TN3270                          (0x00)
#define  AP_LEVEL_TN3270E                         (0x01)
#define  AP_GENERIC_LU                            (0x00)
#define  AP_SPECIFIC_LU                           (0x01)
#define  AP_ASSOCIATED_LU                         (0x02)

/*****************************************************************************/
/* Values for NDLC filter level                                              */
/*****************************************************************************/
#define  AP_DLC_FILTER_ALL     0    /* Trace all DLC_MUs                     */
#define  AP_DLC_FILTER_FMH     1    /* trace SC, DFC and FMH PIUs            */
#define  AP_DLC_FILTER_DFC     2    /* trace SC and DFC PIUs                 */

/*****************************************************************************/
/* Values QUERY_EXTRA_DATA resource type                                     */
/*****************************************************************************/
#define  AP_PRIMARY_KEY                 (0x00)
#define  AP_SECONDARY_KEY               (0x01)

/*****************************************************************************/
/* DLC implementation identifiers :                                          */
/*****************************************************************************/

/*****************************************************************************/
/* SDLC using SNAP LINK                                                      */
/*****************************************************************************/
#define  AP_IMPL_SDLC_SL     0x0001

/*****************************************************************************/
/* DLC stacks using the NDG and a 3rd party DLPI provider                    */
/*****************************************************************************/
#define  AP_IMPL_TR_DLPI                0x0002
#define  AP_IMPL_ETHER_DLPI             0x0003
#define  AP_IMPL_SDLC_DLPI              0x0004
#define  AP_IMPL_FDDI_DLPI              0x000D
#define  AP_IMPL_FRAME_RELAY_DLPI       0x000E

/*****************************************************************************/
/* DLC stacks using the DCL LLC2 code and a 3rd party LLI MAC driver.        */
/*****************************************************************************/
#define  AP_IMPL_TR_SNAP_LLC2    0x0005
#define  AP_IMPL_ETHER_SNAP_LLC2 0x0006
#define  AP_IMPL_FDDI_SNAP_LLC2  0x0007

/*****************************************************************************/
/* GDLC stacks for AIX                                                       */
/*****************************************************************************/
#define  AP_IMPL_TR_GDLC     0x0008
#define  AP_IMPL_X25_GDLC    0x0009
#define  AP_IMPL_SDLC_GDLC   0x000A
#define  AP_IMPL_ETHER_GDLC  0x000B
#define  AP_IMPL_FDDI_GDLC   0x000C
#define  AP_IMPL_CHANNEL_GDLC 0x000D

/*****************************************************************************/
/* QLLC stacks                                                               */
/*****************************************************************************/
#define  AP_IMPL_NLI_QLLC    0x000F

#define  AP_IMPL_ANY_DLC      0xFFFF

/*****************************************************************************/
/* Card types                                                                */
/*****************************************************************************/
#define  AP_CARD_TOKEN_RING_DLPI         1
#define  AP_CARD_ETHERNET_DLPI           2
#define  AP_CARD_FDDI_DLPI               3
#define  AP_CARD_HP_PSI                  4
#define  AP_CARD_HP_ACC                  5
#define  AP_CARD_UNISYS_SDLC             6
#define  AP_CARD_GDLC_TOKEN_RING         7
#define  AP_CARD_GDLC_ETHERNET           8
#define  AP_CARD_GDLC_FDDI               9
#define  AP_CARD_GDLC_SDLC_RETIRED      10
#define  AP_CARD_GDLC_QLLC              11
#define  AP_CARD_IBM_SDLC               12
#define  AP_CARD_IBM_MPCA               13
#define  AP_CARD_IBM_MPAA               14
#define  AP_CARD_TOKEN_RING_LLI         15
#define  AP_CARD_ETHERNET_LLI           16
#define  AP_CARD_FDDI_LLI               17
#define  AP_CARD_QLLC_NLI               18
#define  AP_CARD_DCA_ISCA               19
#define  AP_CARD_ATT_MPCA               20
#define  AP_CARD_ATT_MCIA               21
#define  AP_CARD_ATT_MPCM               22
#define  AP_CARD_ATT_ARNET              23
#define  AP_CARD_ATT_X25NS              24
#define  AP_CARD_ATT_X25NI              25
#define  AP_CARD_ATT_ILD_TOKEN_RING     26
#define  AP_CARD_ATT_ILD_ETHERNET       27
#define  AP_CARD_ATT_ILD_FDDI           28
#define  AP_CARD_ATT_MPCM_TOKEN_RING    29
#define  AP_CARD_ATT_MPCM_ETHERNET      30
#define  AP_CARD_ATT_DEPLOYER_ETHERNET  31
#define  AP_CARD_QLLC_MLI               32
#define  AP_CARD_FRAME_RELAY_DLPI       33
#define  AP_CARD_ISI_SDLC               34
#define  AP_CARD_IBM_ESCON              35
#define  AP_CARD_IBM_BLK_MUX            36
#define  AP_CARD_ATT_ILD_FRAME_RELAY    37
#define  AP_CARD_ANYNET_DLC             38
#define  AP_CARD_UXW_SDLC               39
#define  AP_CARD_GDLC_SDLC              40
#define  AP_CARD_GDLC_SDLC_MPC          41
#define  AP_CARD_GDLC_SDLC_MPQP         42
#define  AP_CARD_GDLC_SDLC_RICCOM       43
#define  AP_CARD_GDLC_SDLC_RICPCOM      44
#define  AP_CARD_FRAME_RELAY_UNISYS     45
#define  AP_CARD_MDI_ETHERNET           46
#define  AP_CARD_MDI_TOKEN              47
#define  AP_CARD_MDI_FDDI               48
#define  AP_CARD_UXW_QLLC               49
#define  AP_CARD_HP_EISA_SDLC           50
#define  AP_CARD_HP_EICON_PCI_SDLC      51
#define  AP_CARD_SPARC_TR               52
#define  AP_CARD_SPARC_TRP              53
#define  AP_CARD_INTEL_TR               54
#define  AP_CARD_SPARC_SE_SDLC          55
#define  AP_CARD_SPARC_ZS_SDLC          56
#define  AP_CARD_DIGI_SYNC570           57
#define  AP_CARD_CHANNEL_DLPI           58
#define  AP_CARD_ETHERNET_LLG           59
#define  AP_CARD_SBE_WANXL              60
#define  AP_CARD_SDLC_SOLARIS           61
#define  AP_CARD_IP                     62
#define  AP_CARD_ISI_SDLC_FIFO          63
#define  AP_CARD_ISI_SDLC_A570i_PCI2	64
#define  AP_CARD_ISI_SDLC_A570i_PCI4	65
#define  AP_CARD_TR_LLG                 66
#define  AP_CARD_SDLC_LINUX             67

/*****************************************************************************/
/* DLC types that match the xx used in the define_xx_dlc verbs.  Defined for */
/* the Network Adapter Discovery support for Unixware 7.                     */
/*****************************************************************************/
#define AP_DLCTYPE_ETHERNET            1
#define AP_DLCTYPE_TOKEN               2
#define AP_DLCTYPE_FDDI                3
#define AP_DLCTYPE_SDLC                4
#define AP_DLCTYPE_QLLC                5

/*****************************************************************************/
/* Maximum length of a UNIX file name                                        */
/*****************************************************************************/
#define MAXFNAMEL   80

/*****************************************************************************/
/* SDLC port types :                                                         */
/*****************************************************************************/
#define PORT_LEASED     0x00
#define PORT_SW_DIAL    0x01
#define PORT_SW_ANSWER  0x02
#define PORT_SW_MAN     0x04

/*****************************************************************************/
/* SDLC polling commands                                                     */
/*****************************************************************************/
#define XIDFRM 191
#define TESTT  243
#define SNRM   147
#define SNRME  223
#define DISC    83

/*****************************************************************************/
/* SDLC role values                                                          */
/*****************************************************************************/
#define SDL_MIB_PRIMARY    1
#define SDL_MIB_SECONDARY  2
#define SDL_MIB_NEGOTIABLE 3

/*****************************************************************************/
/* SDLC type values                                                          */
/*****************************************************************************/
#define SDL_MIB_LEASED     1
#define SDL_MIB_SWITCHED   2

/*****************************************************************************/
/* SDLC topology values                                                      */
/*****************************************************************************/
#define SDL_MIB_POINT_TO_POINT   1
#define SDL_MIB_MULTIPOINT       2

/*****************************************************************************/
/* SDLC slow pool method values                                              */
/*****************************************************************************/
#define SDL_MIB_SERVLIM   1
#define SDL_MIB_POLLPAUSE 2
#define SDL_MIB_OTHER     3

/*****************************************************************************/
/* SDLC port last failure cause values                                       */
/*****************************************************************************/
#define SDL_MIB_UNDEFINED  1
#define SDL_MIB_PHYSICAL   2

/*****************************************************************************/
/* SDLC LS state values                                                      */
/*****************************************************************************/
#define SDL_MIB_DISCONTACTED        1
#define SDL_MIB_CONTACT_PENDING     2
#define SDL_MIB_CONTACTED           3
#define SDL_MIB_DISCONTACT_PENDING  4

/*****************************************************************************/
/* SDLC modulus values                                                       */
/*****************************************************************************/
#define SDL_MIB_EIGHT             8
#define SDL_MIB_ONETWENTYEIGHT  128

/*****************************************************************************/
/* SDLC communications mode values                                           */
/*****************************************************************************/
#define SDL_MIB_HALF  1
#define SDL_MIB_FULL  2

/*****************************************************************************/
/* SDLC LS last failure cause values                                         */
/*****************************************************************************/
#define SDL_MIB_RX_FRMR          2
#define SDL_MIB_TX_FRMR          3
#define SDL_MIB_NO_RESPONSE      4
#define SDL_MIB_PROTOCOL_ERR     5
#define SDL_MIB_NO_ACTIVITY      6
#define SDL_MIB_RNR_LIMIT        7
#define SDL_MIB_RETRIES_EXPIRED  8

/*****************************************************************************/
/* SDLC LS 'sim_rim' values                                                  */
/*****************************************************************************/
#define SDL_MIB_NO  1
#define SDL_MIB_YES 2

/*****************************************************************************/
/* SDLC option values                                                        */
/*****************************************************************************/
#define SDL_OPT_4WIRE            0x80
#define SDL_OPT_2WIRE            0x00
#define SDL_OPT_NRZI             0x40
#define SDL_OPT_NRZ              0x00
#define SDL_OPT_HDLC             0x20
#define SDL_OPT_SDLC             0x00
#define SDL_OPT_FDPLX            0x10
#define SDL_OPT_HDPLX            0x00
#define SDL_OPT_INTCLK           0x08
#define SDL_OPT_EXTCLK           0x00
#define SDL_OPT_DMA              0x04
#define SDL_OPT_NO_DMA           0x00
#define SDL_OPT_UNSUP1           0x03

#define SDL_OPT_DSRS             0x80
#define SDL_OPT_NO_DSRS          0x00
#define SDL_OPT_SEL_STANDBY      0x40
#define SDL_OPT_NO_SEL_STANDBY   0x00
#define SDL_OPT_MONITOR_DCD      0x20
#define SDL_OPT_NO_MONITOR_DCD   0x00
#define SDL_OPT_STREAM_FLAGS     0x10
#define SDL_OPT_NO_STREAM_FLAGS  0x00
#define SDL_OPT_WAIT_FOR_RING    0x08
#define SDL_OPT_NO_WAIT_FOR_RING 0x00
#define SDL_OPT_AUTO_DIAL        0x04
#define SDL_OPT_MANUAL_DIAL      0x00
#define SDL_OPT_UNSUP2           0x03

/*****************************************************************************/
/* Physical Link type (used by GDLC - must match values in sys/mpqp.h).      */
/*****************************************************************************/
#define SDLC_PL_232D          0x20     /* EIA232-D                           */
#define SDLC_PL_422A          0x10     /* EIA422-A                           */
#define SDLC_PL_V35           0x08     /* V.35                               */
#define SDLC_PL_X21           0x04     /* X.21                               */
#define SDLC_PL_SMART_MODEM   0x02     /* Smart modem                        */
#define SDLC_PL_V25           0x01     /* V25bis                             */

/*****************************************************************************/
/* LU0 Secondary return codes (AP_STATE_CHECK)                               */
/*****************************************************************************/
#define AP_LU0_LU_LIMIT_REACHED        (0x34FF0000L)
#define AP_LU0_PU_LIMIT_REACHED        (0x35FF0000L)
#define AP_DEFAULT_NAME_ALREADY_USED   (0x36FF0000L)
#define AP_INVALID_DEFAULT_NAME        (0x37FF0000L)
#define AP_INVALID_TRANSMIT_RATE       (0x38FF0000L)
#define AP_INVALID_LINE_NAME           (0x39FF0000L)
#define AP_GSNA_LU_MAY_NOT_MOVE        (0x3AFF0000L)

/*****************************************************************************/
/* LU0 Primary Line DLC type                                                 */
/*****************************************************************************/
#define AP_EIA232D                     0x20
#define AP_EIA422A                     0x10

/*****************************************************************************/
/* LU0 Primary Line options                                                  */
/*****************************************************************************/
#define LU0_OPT_NRZI                   0x40
#define LU0_OPT_NRZ                    0x00
#define LU0_OPT_SW                     0x20
#define LU0_OPT_NON                    0x00
#define LU0_OPT_INT                    0x10
#define LU0_OPT_EXT                    0x00
#define LU0_OPT_RTS                    0x08
#define LU0_OPT_CONTROLLED             0x08
#define LU0_OPT_CONTINUOUS             0x00
#define LU0_OPT_DTR                    0x04
#define LU0_OPT_CDSTL                  0x00

/*****************************************************************************/
/* QLLC LS 'cud_mode' values                                                 */
/*****************************************************************************/
#define VQL_DONTCARE     1
#define VQL_IDENTITY     2
#define VQL_STARTSWITH   3

/*****************************************************************************/
/* QLLC LS 'xtras' values                                                    */
/*****************************************************************************/
#define VQL_XTRA_DATA 0x01
#define VQL_MUX_DATA  0x02

/*****************************************************************************/
/* QLLC LS 'vc_type' values                                                  */
/*****************************************************************************/
#define VQL_SVC       1
#define VQL_PVC       2

/*****************************************************************************/
/* LAN (MAC level type) definitions                                          */
/*****************************************************************************/
#define LLC_UNKNOWN        0
#define LLC_802_3          3
#define LLC_DIX            0x0D
#define LLC_802_3_DIX      0x3D
#define LLC_TOKEN_RING     5
#define LLC_FDDI           6

/*****************************************************************************/
/* Values for the conversation_security_type used on CPI-C verbs             */
/*****************************************************************************/
#define CM_SECURITY_NONE            0
#define CM_SECURITY_SAME            1
#define CM_SECURITY_PROGRAM         2
#define CM_SECURITY_DISTRIBUTED     3
#define CM_SECURITY_MUTUAL          4
#define CM_SECURITY_PROGRAM_STRONG  5
#define XC_SECURITY_NONE            CM_SECURITY_NONE
#define XC_SECURITY_SAME            CM_SECURITY_SAME
#define XC_SECURITY_PROGRAM         CM_SECURITY_PROGRAM
#define XC_SECURITY_PROGRAM_STRONG  CM_SECURITY_PROGRAM_STRONG

/*****************************************************************************/
/* Values for the TP_name_type used on CPI-C verbs                           */
/*****************************************************************************/
#define XC_APPLICATION_TP           0
#define XC_SNA_SERVICE_TP           1

/*****************************************************************************/
/* Reason codes used by TN_REDIRECTION_INDICATION.                           */
/*****************************************************************************/
#define AP_CONNECTION_ACTIVATED 0x01
#define AP_CONNECTION_DEACTIVATED 0x02
#define AP_TN_SERVER_TERMINATED 0x03
#define AP_RED_SSL_AUTH_FAILED 0x04
#define AP_RED_HOST_CONN_FAILED 0x05
#define AP_RED_NOT_CONFIGURED 0x06
#define AP_RED_SOCKETS_ERROR 0x07
#define AP_RED_RESOURCE_FAILURE 0x08
#define AP_RED_HOST_NOT_FOUND 0x09

/*****************************************************************************/
/*****************************************************************************/
/* Definitions used by AnyNet                                                */
/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/
/* AnyNet verb opcodes                                                       */
/*****************************************************************************/
#define AP_DEFINE_ANYNET_APPCIP_DEFAULTS      (0xFC00)
#define AP_DELETE_ANYNET_APPCIP_DEFAULTS      (0xFC01)
#define AP_QUERY_ANYNET_APPCIP_DEFAULTS       (0xFC02)
#define AP_QUERY_ANYNET_APPCIP                (0xFC10)
#define AP_ANYNET_INDICATION                  (0xFC12)
#define AP_MIN_ANYNET_OPCODE                  (0xFC00)
#define AP_MAX_ANYNET_OPCODE                  (0xFC13)

/*****************************************************************************/
/* Connection types.                                                         */
/*****************************************************************************/
#define AP_APPCIP                             (0x00)
#define AP_SNACKETS                           (0x01)

/*****************************************************************************/
/* These values are used by the DEFINE_ANYNET_IP_GATEWAY verbs               */
/*****************************************************************************/
#define AP_ANYNET_HOST                        (0x00)
#define AP_ANYNET_SUBNETWORK                  (0x01)

/*****************************************************************************/
/* Values for AnyNet status                                                  */
/*****************************************************************************/
#define AP_ANYNET_INIT                        (0x00)
#define AP_ANYNET_REGISTERING                 (0x01)
#define AP_ANYNET_REGISTERED                  (0x02)
#define AP_ANYNET_LOCATING                    (0x03)
#define AP_ANYNET_CLOSED                      (0x04)
#define AP_ANYNET_CONNECTED                   (0x05)
#define AP_ANYNET_CONNECTING                  (0x06)
#define AP_ANYNET_LISTENING                   (0x07)
#define AP_ANYNET_ACCEPT_REJECTED             (0x08)
#define AP_ANYNET_CLOSING_IMMEDIATE           (0x09)
#define AP_ANYNET_GW_INIT                     (0x0A)
#define AP_ANYNET_GW_LOCATING                 (0x0B)
#define AP_ANYNET_GW_CLOSED                   (0x0C)
#define AP_ANYNET_CLOSING                     (0x0D)

/*****************************************************************************/
/* Values for AnyNet type                                                    */
/*****************************************************************************/
#define AP_ANYNET_ALL                         (0x00)
#define AP_ANYNET_NON_LISTENING               (0x01)
#define AP_ANYNET_DATAGRAM                    (0x02)
#define AP_ANYNET_CONNECTION                  (0x03)

/*****************************************************************************/
/* IP_ADDRESS family types                                                   */
/*****************************************************************************/
#define NAP_IPV4_ADDRESS                      (0x00)
#define NAP_IPV6_ADDRESS                      (0x01)

/*****************************************************************************/
/*****************************************************************************/
/* End of AnyNet specific definitions                                        */
/*****************************************************************************/
/*****************************************************************************/

/*****************************************************************************/
/* Constants used for TN Server SSL support                                  */
/*****************************************************************************/
/*****************************************************************************/
/* Security types                                                            */
/*****************************************************************************/
#define AP_SSL_AUTHENTICATE_MIN     0
#define AP_SSL_AUTHENTICATE_ONLY    1
#define AP_SSL_40_BIT_MIN           2
#define AP_SSL_56_BIT_MIN           3
#define AP_SSL_128_BIT_MIN          4
#define AP_SSL_168_BIT_MIN          5

/*****************************************************************************/
/* Encryption strength                                                       */
/*****************************************************************************/
#define AP_SSL_NO_SSL                0
#define AP_SSL_NULL_MD5              1
#define AP_SSL_NULL_SHA              2
#define AP_SSL_RC4_MD5_EXPORT        3
#define AP_SSL_RC4_MD5_US            4
#define AP_SSL_RC4_SHA_US            5
#define AP_SSL_RC2_MD5_EXPORT        6
#define AP_SSL_DES_SHA_EXPORT        9
#define AP_SSL_3DES_SHA_US          10

/**STRUCT+********************************************************************/
/* Structure: APPC_HDR                                                       */
/*                                                                           */
/* Description: Common APPC verb header                                      */
/*****************************************************************************/
typedef struct appc_hdr
{
  AP_UINT16            opcode;
  unsigned char        opext;
  unsigned char        format;
  AP_UINT16            primary_rc;
  AP_UINT32            secondary_rc;
} APPC_HDR;
/**STRUCT-********************************************************************/


/*****************************************************************************/
/*                                                                           */
/* IO Handler API                                                            */
/*                                                                           */
/* API extensions to provide Application control of the scheduling of        */
/* messages coming up into User Space from Kernel components.                */
/*                                                                           */
/* The application must call SNA_SET_IO_NOTIFICATION to pass the addresses   */
/* of a register and a deregister function.  When initializing its IO, the   */
/* SNA library calls the register function passing the File descriptor it is */
/* interested in and the address of its IO handler function - the appl must  */
/* then call the IO handler whenever it detects READ data available or an    */
/* error condition on the file.  The deregister function is called (by the   */
/* SNA library) when the input file is closed.                               */
/*                                                                           */
/* The application can optionally call SNA_SET_IO_LIMIT to control how many  */
/* messages at a time are processed by the SNA library. The default is to    */
/* process all of them.                                                      */
/*                                                                           */
/*****************************************************************************/

/*****************************************************************************/
/* #define to map the macro name to a real SNA library function.             */
/*****************************************************************************/
#define SNA_SET_IO_LIMIT vpm_set_io_limit

/*****************************************************************************/
/* #define to map the macro name to a real SNA library function.             */
/*****************************************************************************/
#define SNA_SET_IO_NOTIFICATION vpm_set_io_notification

#if defined (__STDC__) || defined (__cplusplus)

/*****************************************************************************/
/* Fully specified function prototypes                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Function pointer definitions for the three functions addresses passed     */
/* across the IO control API.                                                */
/*****************************************************************************/
typedef void    (*SNA_IO_HANDLER_PROC)    (AP_CORR, AP_INT32*, AP_CORR);
typedef AP_CORR (*SNA_IO_REGISTER_PROC)   (AP_INT32, SNA_IO_HANDLER_PROC, AP_CORR);
typedef void    (*SNA_IO_DEREGISTER_PROC) (AP_CORR);

/*****************************************************************************/
/* Function template declaration for the exposed API function.               */
/*****************************************************************************/
extern AP_UINT16 SNA_SET_IO_NOTIFICATION (SNA_IO_REGISTER_PROC,
                                               SNA_IO_DEREGISTER_PROC);

#else

/*****************************************************************************/
/* K&R function prototypes                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* Function pointer definitions for the three functions addresses passed     */
/* across the IO control API.                                                */
/*****************************************************************************/
typedef void    (*SNA_IO_HANDLER_PROC)    ();
typedef AP_CORR (*SNA_IO_REGISTER_PROC)   ();
typedef void    (*SNA_IO_DEREGISTER_PROC) ();

/*****************************************************************************/
/* Function template declaration for the exposed API function.               */
/*****************************************************************************/
extern AP_UINT16 vpm_set_io_notification ();

#endif


/*****************************************************************************/
/*                                                                           */
/* Application Scheduling API                                                */
/*                                                                           */
/* This API gives applications control over the scheduling of events from    */
/* multiple work sources.  This is achieved by the SNA library not making    */
/* API callbacks asynchronously, but by providing a SNA event handler entry  */
/* point that the application can call.  Callbacks are then made from within */
/* the context of this SNA event handler.                                    */
/*                                                                           */
/* An applications can obtain access to the file descriptor over which SNA   */
/* events arrive.  Using this, it can know when to call the SNA event        */
/* handler to process these events.                                          */
/*                                                                           */
/* There are two variants of the API.                                        */
/*                                                                           */
/*                                                                           */
/*  - The Xt variant is suitable for applications that use the Motif or Xt   */
/*    libraries and use the scheduling techniques provided by the Xt         */
/*    library.                                                               */
/*                                                                           */
/*    To use it, the application should call SNA_USE_XT_SCHED(app_context)   */
/*    before any other calls into any SNA library, passing in the            */
/*    app_context value returned by XtAppInitialize().                       */
/*                                                                           */
/*    The Xt library scheduling loop will then call the SNA event handler    */
/*    directly, and this in turn makes any API call-backs to the application */
/*    that may be required.                                                  */
/*                                                                           */
/*                                                                           */
/*  - The other variant is suitable for applications that use select() or    */
/*    poll() in their main scheduling loop to block for work from multiple   */
/*    sources.                                                               */
/*                                                                           */
/*    To use it, the application should call SNA_USE_FD_SCHED() before any   */
/*    other calls into any SNA library.                                      */
/*                                                                           */
/*    The application's main scheduling loop should be coded to obtain and   */
/*    track any changes to the SNA file descriptor.  This file descriptor    */
/*    does not normally change, but does if (e.g.) the SNA software is       */
/*    stopped.                                                               */
/*                                                                           */
/*    The SNA_GET_FD() function is provided to obtain the SNA file           */
/*    descriptor.  The application must call the SNA event handler function  */
/*    SNA_EVENT_FD() when it detects a "read" event on this file descriptor. */
/*                                                                           */
/*****************************************************************************/

/*****************************************************************************/
/* The #defines used to map the macro names to real SNA library functions.   */
/*****************************************************************************/
#define SNA_USE_XT_SCHED(A) vpm_asm_use_xt_sched((void *)(A),            \
                                                 (void *)XtAppAddInput,  \
                                                 (void *)XtRemoveInput)
#define SNA_USE_FD_SCHED    vpm_asm_use_fd_sched
#define SNA_GET_FD          vpm_asm_get_fd
#define SNA_GET_TIME        vpm_asm_get_time
#define SNA_EVENT_FD        vpm_asm_event_fd

#if defined (__STDC__) || defined (__cplusplus)

/*****************************************************************************/
/* Fully specified function prototypes                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Function template declarations for the exposed API functions.             */
/*****************************************************************************/
extern void vpm_asm_use_xt_sched(void *, void *, void *);
extern void vpm_asm_use_fd_sched(void);
extern AP_INT32  vpm_asm_get_fd(void);
extern AP_INT32  vpm_asm_get_time(void);
extern void vpm_asm_event_fd(void);

#else

/*****************************************************************************/
/* K&R function prototypes                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* Function template declarations for the exposed API functions.             */
/*****************************************************************************/
extern void vpm_asm_use_xt_sched();
extern void vpm_asm_use_fd_sched();
extern AP_INT32  vpm_asm_get_fd();
extern AP_INT32  vpm_asm_get_time();
extern void vpm_asm_event_fd();

#endif


#ifdef __cplusplus
}
#endif

#endif /* VALUES_C_INCLUDED */
