--                                                                           --
--                                                                           --
--  Licensed Materials - Property of IBM                                     --
--                                                                           --
--  5765-530 (C) Copyright IBM Corp. 1996 All Rights Reserved.               --
--                                                                           --
--                                                                           --
--                                                                           --
-- This is a generated DB2/6000 v1 SQL Script to insert the predefined       --
-- checks for DataHub for Unix (R)                                           --
--                                                                           --
--                                                                           --


insert into DBA_PRED_CHECKS values (
   1011, '# login shells',
   'users | wc -w',
   'Return the number of login shells currently active',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1012, '# login shells',
   'users | wc -w',
   'Return the number of login shells currently active',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1013, '# login shells',
   'who | wc -l',
   'Return the number of login shells currently active',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1021, '# users (not root)',
   'who | awk ''{ print $1 }'' | fgrep -v root | sort -u | wc -l',
   'Return the number of users (other than root) currently logged on',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1022, '# users (not root)',
   'who | awk ''{ print $1 }'' | fgrep -v root | sort -u | wc -l',
   'Return the number of users (other than root) currently logged on',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1023, '# users (not root)',
   'who | awk ''{ print $1 }'' | fgrep -v root | sort -u | wc -l',
   'Return the number of users (other than root) currently logged on',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1031, '# processes',
   'ps -e | awk ''{ x += 1 }; END { printf "%d\n", x-1 }'' ',
   'Return the number of processes',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1032, '# processes',
   'ps -e | awk ''{ x += 1 }; END { printf "%d\n", x-1 }'' ',
   'Return the number of processes',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1033, '# processes',
   'ps -e | awk ''{ x += 1 }; END { printf "%d\n", x-1 }'' ',
   'Return the number of processes',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1041, '# user processes',
   'ps -ef | awk ''{ print $1 }'' | fgrep -v root | fgrep -v USER | wc -l',
   'Return the number of user processes (i.e., processes not owned by root)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1042, '# user processes',
   'ps -ef | awk ''{ print $1 }'' | fgrep -v root | fgrep -v USER | wc -l',
   'Return the number of user processes (i.e., processes not owned by root)',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1043, '# user processes',
   'ps -ef | awk ''{ print $1 }'' | fgrep -v root | fgrep -v UID | wc -l',
   'Return the number of user processes (i.e., processes not owned by root)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1051, '# defunct processes',
   'ps -ef | fgrep -v fgrep | fgrep ''<defunct>'' | wc -l',
   'Return the number of defunctional processes',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1061, '# zombies',
   'ps -ef | fgrep '' -1'' | fgrep -v 0: | fgrep -v telnet | wc -l',
   'Return the number of zombies (runaway processes)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1111, '# "full" filesystems',
   'df | fgrep -v '':/'' | fgrep -v ''free'' | awk ''{ if (int($4) >= 90) print $4 }'' | wc -l',
   'Return the number of (local) filesystems which are more than 90% full',
   'host',
   null, 'aix',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1112, '# "full" filesystems',
   'bdf | fgrep ''/dev/dsk'' | awk ''{ if (int($5) >= 90) print $5 }'' | wc -l',
   'Return the number of (local) filesystems which are more than 90% full',
   'host',
   null, 'hpux',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1113, '# "full" filesystems',
   'df -kl | fgrep -v ''Filesystem'' | awk ''{ print $5 }'' | sed ''s/\(.*\)%/\1/g'' | awk ''{ if ( $1 > 90 ) print $1 }'' | wc -l',
   'Return the number of (local) filesystems which are more than 90% full',
   'host',
   null, 'solaris',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1121, '# "full" filesystems (inode)',
   'df | fgrep -v '':/'' | fgrep -v ''free'' | awk ''{ if (int($6) >= 80) print $6 }'' | wc -l',
   'Return the number of (local) filesystems which have more than 80% of their inodes used',
   'host',
   null, 'aix',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1122, '# "full" filesystems (inode)',
   'bdf | fgrep ''/dev/dsk'' | awk ''{ if (int($8) >= 80) print $8 }'' | wc -l',
   'Return the number of (local) filesystems which have more than 80% of their inodes used',
   'host',
   null, 'hpux',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1131, 'free space in /tmp (KB)',
   '&scriptdir/freespace_tmp',
   'Return free space in /tmp (KB)',
   'host',
   null, 'aix',
   'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1132, 'free space in /tmp (KB)',
   'bdf /tmp | grep ''/tmp$'' | awk ''{ print $4 }'' ',
   'Return free space in /tmp (KB)',
   'host',
   null, 'hpux',
   'os',
   1, '<', '10000', 'y' );

insert into DBA_PRED_CHECKS values (
   1133, 'free space in /tmp (KB)',
   'df -k | fgrep ''/tmp'' | awk ''{ print $4 }'' ',
   'Return free space in /tmp (KB)',
   'host',
   null, 'solaris',
   'os',
   1, '<', '10000', 'y' );

insert into DBA_PRED_CHECKS values (
   1141, 'used space in /tmp (KB)',
   '&scriptdir/usedspace_tmp',
   'Return used space in /tmp (KB)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1143, 'used space in /tmp (KB)',
   'df -k | fgrep ''/tmp'' | awk ''{ print $3 }'' ',
   'Return used space in /tmp (KB)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1151, 'size of /tmp (KB)',
   '&scriptdir/size_tmp',
   'Return size of /tmp (KB)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1153, 'size of /tmp (KB)',
   'df -k | fgrep ''/tmp'' | awk ''{ print $2 }'' ',
   'Return size of /tmp (KB)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1221, '% used all paging spaces',
   '/usr/sbin/lsps -a | fgrep -v ''%Used'' | awk ''{ print $4, $5 }'' | awk ''{ x += $1*$2*0.01 }; { y += $1 };END { printf "%d\n", (x/y)*100 }'' ',
   'Return percent used all paging spaces',
   'host',
   null, 'aix',
   'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1231, 'used paging space (MB)',
   '/usr/sbin/lsps -a | fgrep -v ''%Used'' | awk ''{ print $4, $5 }'' | awk ''{ x += $1*$2*0.01 }; END { printf "%d/n", x }'' ',
   'Return used paging space (MB)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1233, 'avail. swap space (KB)',
   'vmstat 1 2 | tail -1 | awk ''{ print $4 }'' ',
   'Return avail. swap space (KB)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1241, 'total paging space (MB)',
   '/usr/sbin/lsps -a | fgrep -v ''%Used'' | awk ''{ print $4, $5 }'' | awk ''{ x += $1 }; END { printf "%d\n", x }'' ',
   'Return total paging space (MB)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1251, '# paging spaces',
   '/usr/sbin/lsps -a | fgrep -v ''%Used'' | wc -l',
   'Return number of paging spaces',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1311, 'current system load',
   'uptime | sed ''s/.*average:\(.*\),.*,.*/\1/g'' ',
   'Return the current system load (as shown by "uptime")',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1312, 'current system load',
   'uptime | sed ''s/.*average:\(.*\),.*,.*/\1/g'' ',
   'Return the current system load (as shown by "uptime")',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1313, 'current system load',
   'uptime | sed ''s/.*average:\(.*\),.*,.*/\1/g'' ',
   'Return the current system load (as shown by "uptime")',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1321, 'avg system load (last 5min)',
   'uptime | sed ''s/.*average:.*,\(.*\),.*/\1/g'' ',
   'Return the average system load over the last 5 minutes (as shown by "uptime")',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1322, 'avg system load (last 5min)',
   'uptime | sed ''s/.*average:.*,\(.*\),.*/\1/g'' ',
   'Return the average system load over the last 5 minutes (as shown by "uptime")',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1323, 'avg system load (last 5min)',
   'uptime | sed ''s/.*average:.*,\(.*\),.*/\1/g'' ',
   'Return the average system load over the last 5 minutes (as shown by "uptime")',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1331, 'avg system load (last 15min)',
   'uptime | sed ''s/.*average:.*,.*,\(.*\)/\1/g'' ',
   'Return the average system load over the last 15 minutes (as shown by "uptime")',
   'host',
   null, 'aix',
   'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1332, 'avg system load (last 15min)',
   'uptime | sed ''s/.*average:.*,.*,\(.*\)/\1/g'' ',
   'Return the average system load over the last 15 minutes (as shown by "uptime")',
   'host',
   null, 'hpux',
   'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1333, 'avg system load (last 15min)',
   'uptime | sed ''s/.*average:.*,.*,\(.*\)/\1/g'' ',
   'Return the average system load over the last 15 minutes (as shown by "uptime")',
   'host',
   null, 'solaris',
   'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1341, '% CPU usage: user',
   'iostat -t | tail -1 | awk ''{ print $3 }'' ',
   'Return percent of CPU usage: user',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1342, '% CPU usage: user',
   'iostat -t | head -3 | tail -1 | awk ''{ print $3 }'' ',
   'Return percent of CPU usage: user',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1343, '% CPU usage: user',
   'iostat -c | tail -1 | awk ''{ print $1 }'' ',
   'Return percent of CPU usage: user',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1351, '% CPU usage: system',
   'iostat -t | tail -1 | awk ''{ print $4 }'' ',
   'Return percent of CPU usage: system',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1352, '% CPU usage: system',
   'iostat -t | head -3 | tail -1 | awk ''{ print $5 }'' ',
   'Return percent of CPU usage: system',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1353, '% CPU usage: system',
   'iostat -c | tail -1 | awk ''{ print $2 }'' ',
   'Return percent of CPU usage: system',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1361, '% CPU usage: idle',
   'iostat -t | tail -1 | awk ''{ print $5 }'' ',
   'Return percent of CPU usage: idle',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1362, '% CPU usage: idle',
   'iostat -t | head -3 | tail -1 | awk ''{ print $6 }'' ',
   'Return percent of CPU usage: idle',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1363, '% CPU usage: idle',
   'iostat -c | tail -1 | awk ''{ print $4 }'' ',
   'Return percent of CPU usage: idle',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1371, '% CPU usage: iowait',
   'iostat -t | tail -1 | awk ''{ print $6 }'' ',
   'Return percent of CPU usage: iowait',
   'host',
   null, 'aix',
   'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1372, '% CPU usage: iowait',
   'iostat -t | head -3 | tail -1 | awk ''{ print 100-($3+$4+$5+$6) }'' ',
   'Return percent of CPU usage: iowait',
   'host',
   null, 'hpux',
   'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   1373, '% CPU usage: iowait',
   'iostat -c | tail -1 | awk ''{ print $3 }'' ',
   'Return percent of CPU usage: iowait',
   'host',
   null, 'solaris',
   'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   1382, '% CPU usage: niced',
   'iostat -t | head -3 | tail -1 | awk ''{ print $4 }'' ',
   'Return percent of CPU usage: niced',
   'host',
   null, 'hpux',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1411, '% usage bandwidth hdisk0',
   'iostat -d hdisk0 | tail -1 | awk ''{ print $2 }'' ',
   'Return percent of usage bandwidth hdisk0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1413, '% utilization of disk sd0',
   'iostat -x | fgrep sd0 | awk ''{ print $10 }'' ',
   'Return percent of utilization of disk sd0',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1421, '% usage bandwidth cd0',
   'iostat -d cd0 | tail -1 | awk ''{ print $2 }'' ',
   'Return percent of usage bandwidth cd0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1431, 'transfer kb/sec on hdisk0',
   'iostat -d hdisk0 | tail -1 | awk ''{ print $3 }'' ',
   'Return transfer kb/sec on hdisk0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1433, 'Return transfer kb/sec on disk sd0',
   'iostat -x | fgrep sd0 | awk ''{ printf "%f\n", $4+$5 }'' ',
   'Return transfer kb/sec on disk sd0',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1441, 'Return transfer kb/sec on cd0',
   'iostat -d cd0 | tail -1 | awk ''{ print $3 }'' ',
   'Return transfer kb/sec on cd0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1451, '# transfers/second on hdisk0',
   'iostat -d hdisk0 | tail -1 | awk ''{ print $4 }'' ',
   'Return number of transfers per second on hdisk0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1453, '# transfers/second on disk sd0',
   'iostat -x | fgrep sd0 | awk ''{ printf "%f\n", $2+$3 }'' ',
   'Return number of transfers per second on disk sd0',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1461, '# transfers/second on cd0',
   'iostat -d cd0 | tail -1 | awk ''{ print $4 }'' ',
   'Return number of transfers per second on cd0',
   'host',
   null, 'aix',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1473, 'avg service time (ms) of disk sd0',
   'iostat -x | fgrep sd0 | awk ''{ printf "%f\n", $8 }'' ',
   'Return avg service time (ms) of disk sd0',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   1511, '# proc. to RUN',
   'vmstat | tail -1 | awk ''{ print $1 }'' ',
   'Return number of processes per second placed on the run queue during vmstat command report interval ',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1512, '# proc. to RUN',
   'vmstat | tail -1 | awk ''{ print $1 }'' ',
   'Return number of processes per second placed on the run queue during vmstat command report interval ',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1513, '# proc. to RUN',
   'vmstat | tail -1 | awk ''{ print $1 }'' ',
   'Return number of processes per second placed on the run queue during vmstat command report interval ',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1521, '# proc. to WAIT',
   'vmstat | tail -1 | awk ''{ print $2 }'' ',
   'Return number of processes per second placed on the wait queue during vmstat comment report interval ',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1522, '# proc. to WAIT',
   'vmstat | tail -1 | awk ''{ print $2 }'' ',
   'Return number of processes per second placed on the wait queue during vmstat comment report interval ',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1523, '# proc. to WAIT',
   'vmstat | tail -1 | awk ''{ print $2 }'' ',
   'Return number of processes per second placed on the wait queue during vmstat comment report interval ',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1531, '# act. virt. mem. pages',
   'vmstat | tail -1 | awk ''{ print $3 }'' ',
   'Return number of active virtual memory pages',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1532, '# act. virt. mem. pages',
   'vmstat | tail -1 | awk ''{ print $4 }'' ',
   'Return number of active virtual memory pages',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1541, '# free pages real mem.',
   'vmstat | tail -1 | awk ''{ print $4 }'' ',
   'Return number of free pages real memory',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1542, '# free pages real mem.',
   'vmstat | tail -1 | awk ''{ print $5 }'' ',
   'Return number of free pages real memory',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1543, 'free real mem. (KB)',
   'vmstat 1 2 | tail -1 | awk ''{ print $5 }'' ',
   'Return number of free real memory (KB)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1551, '# page reclaims/second',
   'vmstat | tail -1 | awk ''{ print $5 }'' ',
   'Return number of page reclaims/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1552, '# page reclaims/second',
   'vmstat | tail -1 | awk ''{ print $6 }'' ',
   'Return number of page reclaims/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1553, '# page reclaims/second',
   'vmstat | tail -1 | awk ''{ print $6 }'' ',
   'Return number of page reclaims/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1561, '# page-ins/second',
   'vmstat | tail -1 | awk ''{ print $6 }'' ',
   'Return number of page-ins/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1562, '# page-ins/second',
   'vmstat | tail -1 | awk ''{ print $8 }'' ',
   'Return number of page-ins/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1563, 'KB paged in/second',
   'vmstat | tail -1 | awk ''{ print $8 }'' ',
   'Return KB paged in/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1571, '# page-outs/second',
   'vmstat | tail -1 | awk ''{ print $7 }'' ',
   'Return number of page-outs/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1572, '# page-outs/second',
   'vmstat | tail -1 | awk ''{ print $9 }'' ',
   'Return number of page-outs/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1573, 'KB paged out/second',
   'vmstat | tail -1 | awk ''{ print $9 }'' ',
   'Return KB paged out/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1581, '# pages freed/second',
   'vmstat | tail -1 | awk ''{ print $8 }'' ',
   'Return number of pages freed/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1582, '# pages freed/second',
   'vmstat | tail -1 | awk ''{ print $10 }'' ',
   'Return number of pages freed/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1583, 'KB freed/second',
   'vmstat | tail -1 | awk ''{ print $10 }'' ',
   'Return KB freed/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1591, '# pages aged/second',
   'vmstat | tail -1 | awk ''{ print $9 }'' ',
   'Return number of pages aged/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1592, '# pages aged/second',
   'vmstat | tail -1 | awk ''{ print $12 }'' ',
   'Return number of pages aged/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1593, '# pages aged/second',
   'vmstat | tail -1 | awk ''{ print $12 }'' ',
   'Return number of pages aged/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1601, '# clock rev./second',
   'vmstat | tail -1 | awk ''{ print $10 }'' ',
   'Return number of clock revolutions/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1611, '# dev. interrupts/second',
   'vmstat | tail -1 | awk ''{ print $11 }'' ',
   'Return number of device interrupts/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1612, '# dev. interrupts/second',
   'vmstat | tail -1 | awk ''{ print $13 }'' ',
   'Return number of device interrupts/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1613, '# dev. interrupts/second',
   'vmstat | tail -1 | awk ''{ print $17 }'' ',
   'Return number of device interrupts/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1621, '# system calls/second',
   'vmstat | tail -1 | awk ''{ print $12 }'' ',
   'Return number of system calls/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1622, '# system calls/second',
   'vmstat | tail -1 | awk ''{ print $14 }'' ',
   'Return number of system calls/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1623, '# system calls/second',
   'vmstat | tail -1 | awk ''{ print $18 }'' ',
   'Return number of system calls/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1631, '# context switches/second',
   'vmstat | tail -1 | awk ''{ print $13 }'' ',
   'Return number of context switches/second',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1632, '# context switches/second',
   'vmstat | tail -1 | awk ''{ print $15 }'' ',
   'Return number of context switches/second',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1633, '# context switches/second',
   'vmstat | tail -1 | awk ''{ print $19 }'' ',
   'Return number of context switches/second',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1641, '# forks (total)',
   'vmstat -f | awk ''{ print $1 }'' ',
   'Return number of forks (total)',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1642, '# forks (total)',
   'vmstat -f | awk ''{ print $1 }'' ',
   'Return number of forks (total)',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1652, 'shortfall',
   'vmstat | tail -1 | awk ''{ print $11 }'' ',
   'shortfall',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1653, 'short-term memory shortfall (KB)',
   'vmstat | tail -1 | awk ''{ print $11 }'' ',
   'Return the anticipated short-term memory shortfall (KB)',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1661, '# Pages Swapped In',
   'vmstat 10 2 | tail -1 | awk ''{print $6}''',
   'Return the average number of pages per second that were swapped in in a 10 second interval',
   'host',
   null,
   'aix', 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1662, '# Pages Swapped In',
   'vmstat 10 2 | tail -1 | awk ''{print $8}''',
   'Return the average number of pages per second that were swapped in in a 10 second interval',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1663, '# Pages Swapped In',
   'vmstat 10 2 | tail -1 | awk ''{print $8}''',
   'Return the average number of pages per second that were swapped in in a 10 second interval',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1671, '# Pages Swapped Out',
   'vmstat 10 2 | tail -1 | awk ''{print $7}''',
   'Return the average number of pages per second that were swapped out in a 10 second interval',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1672, '# Pages Swapped Out',
   'vmstat 10 2 | tail -1 | awk ''{print $9}''',
   'Return the average number of pages per second that were swapped out in a 10
           second interval',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1673, '# Pages Swapped Out',
   'vmstat 10 2 | tail -1 | awk ''{print $9}''',
   'Return the average number of pages per second that were swapped out in a 10
           second interval',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1711, 'Hour of the day',
   'date +%H',
   'Return the whole hour, e.g. 13 for 13:35 hours',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1712, 'Hour of the day',
   'date +%H',
   'Return the whole hour, e.g. 13 for 13:35 hours',
   'host',
   null, 'hpux',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1713, 'Hour of the day',
   'date +%H',
   'Return the whole hour, e.g. 13 for 13:35 hours',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1813, '# disks over 20% busy and service time over 50 ms',
   'iostat -x 30 2 | awk ''$1 ~ /sd[0-9]+/ {if ($10 > 20 && $8 > 50.0) print $1}'' | sort -u | wc -l',
   'Return the number of disks that are over 20% busy averaged over a 30-second period with service time more than 50 ms',
   'host',
   null, 'solaris',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1823, '# disks over 5% of time with transactions waiting',
   'iostat -x 30 2 | awk ''$1 ~ /sd[0-9]+/ {if ($9 > 5) print $1}'' | sort -u | wc -l',
   'Return the number of disks that are over 5% of time with transactions waiting for service averaged over a 30-second period',
   'host',
   null, 'solaris',
   'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   1833, 'avail. swap space (KB) over 30-second interval',
   'vmstat 30 2 | tail -1 | awk ''{ print $4 }''',
   'Return avail. swap space (KB) over a 30-second interval',
   'host',
   null, 'solaris',
   'os',
   1, '<', '5000', 'y' );

insert into DBA_PRED_CHECKS values (
   1843, 'average # processes in run queue (1-CPU system)',
   'vmstat 30 2 | tail -1 | awk ''{ print $1 }''',
   'Return average number of processes in the run queue (queue length divided by the number of CPUs',
   'host',
   null, 'solaris',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   1844, 'average # processes in run queue (2-CPU system)',
   'vmstat 30 2 | tail -1 | awk ''{printf "%f\n", $1/2}''',
   'Return average number of processes in the run queue (queue length divided by the number of CPUs',
   'host',
   null, 'solaris',
   'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   2000, 'oracle DB active',
   '&scriptdir/db_active &dbdir &database',
   'Return a 1 if a database is active and a 0 if it is not',
   'database',
   'ora7',
   null, 'os',
   1, '<', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   2011, '# tables',
   'select count(*) from sysibm.systables where type = ''T''',
   'Return number of tables that is in the database',
   'database',
   'db6000',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2012, '# tables',
   'select count(*) from sysibm.systables where type = ''T''',
   'Return number of tables that is in the database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2013, '# tables',
   'select count(*) from iitables where table_type = ''T''',
   'Return number of tables that is in the database',
   'database',
   'ing64',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2014, '# tables',
   'select count(*) from sys.dba_tables',
   'Return number of tables that is in the database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2015, '# tables',
   'select count(*) from &database..sysobjects where type in (''U'',''S'') ',
   'Return number of tables that is in the database',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2021, '# Views',
   'select count(*) from sysibm.sysviews',
   'Return number of views in the database',
   'database',
   'db6000',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2022, '# Views',
   'select count(*) from sysibm.sysviews',
   'Return number of views in the database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2023, '# Views',
   'select count(*) from iitables where table_type = ''V''',
   'Return number of views in the database',
   'database',
   'ing64',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2024, '# Views',
   'select count(*) from sys.dba_views',
   'Return number of views in the database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2025, '# Views',
   'select count(*) from &database..sysobjects where type = ''V''',
   'Return number of views in the database',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2031, 'transactions waiting for locks',
   '&scriptdir/tr_locks &home &database waiting',
   'Return number of transactions waiting for locks',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2032, 'transactions waiting for locks',
   '&scriptdir/tr_locks &home &database waiting',
   'Return number of transactions waiting for locks',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2033, 'Transactions waiting for locks',
   '&scriptdir/tr_waiting &database &home',
   'Return number of transactions waiting for locks',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2034, 'transactions waiting for locks',
   'select count(*) from sys.v_$lock where request <> 0',
   'Return number of transactions waiting for locks',
   'database',
   'ora7',
   null, 'sql',
   1, '>', '0', null );

insert into DBA_PRED_CHECKS values (
   2041, '# locks',
   '&scriptdir/tr_locks &home &database Locks',
   'Return number of locks',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2042, '# locks',
   '&scriptdir/tr_locks &home &database Locks',
   'Return number of locks',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2043, '# locks',
   '&scriptdir/tr_locks &database &home',
   'Return number of locks',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2044, '# locks',
   'select count(*) from sys.v_$lock where request = 0',
   'Return number of locks',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2045, '# locks',
   'select count(l.id) from master..sysdatabases d, master..syslocks l
   where d.dbid = l.dbid and d.name = ''&database''',
   'Return number of locks',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2051, '# connections',
   '&scriptdir/tr_locks &home &database connected',
   'Return number of connections',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2052, '# connections',
   '&scriptdir/tr_locks &home &database connected',
   'Return number of connections',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   2054, '# connections',
   'select count(*) from v$session',
   'Return number of connections',
   'database',
   'ora7',
   null, 'sql',
   1, '>', '0', null );

insert into DBA_PRED_CHECKS values (
   2060, 'DB2 instance active',
   '&scriptdir/db2_active &home',
   'Return whether the database manager for this database is active. A 0 is returned if the DBM is NOT active - a value of 1 or more is returned if the DBM is active.',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   2061, 'data buffer pool hit ratio',
   '&scriptdir/bp_hit_ratio &home &database data',
   'Return data buffer pool hit ratio - approaching zero is low, -1 returned if database has no connection or buffer pool monitor switch is inactive.',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '-1', 'y' );

insert into DBA_PRED_CHECKS values (
   2062, 'index buffer pool hit ratio',
   '&scriptdir/bp_hit_ratio &home &database index',
   'Return index buffer pool hit ratio - approaching zero is low, -1 returned if database has no connection or buffer pool monitor switch is inactive.',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '-1', 'y' );

insert into DBA_PRED_CHECKS values (
   2070, 'average sort time',
   '&scriptdir/sort_ratio &home &database Total sort time',
   'Return the average sort time.  Basic monitoring in DB2 collects this data. As sorting improves the average will decrease. Returns -1 if sort monitor switch is inactive.',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '-1', 'y' );

insert into DBA_PRED_CHECKS values (
   2071, 'percent of sorts requiring more heap space',
   '&scriptdir/sort_ratio &home &database Sort overflows',
   'Return the percent of sorts requiring at least one merge phase.  Basic monitoring provides this data.',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   2080, 'max storage for lock lists in 4K pages',
   '&scriptdir/db_config &home &database LOCKLIST',
   'Return the configured value for the max storage for the locklist.',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   3001, '# rows in a table',
   'select count(*) from &owner.&table',
   'Return number of rows in a table',
   'table',
   'db6000',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   3002, '# rows in a table',
   'select count(*) from &owner.&table',
   'Return number of rows in a table',
   'table',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   3003, '# rows in a table',
   'select count(*) from &owner.&table',
   'Return number of rows in a table',
   'table',
   'ing64',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   3004, '# rows in a table',
   'select count(*) from &owner.&table',
   'Return number of rows in a table',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   3005, '# rows in a table',
   'select count(*) from &database.&owner.&table',
   'Return number of rows in a table',
   'table',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4001, '# tables with overflow pages',
   'select count(*) from iitables where table_type = ''T''
and storage_structure <> ''HEAP''
and (overflow_pages / number_pages * 100) > 10',
   'Return number of tables that have more than 10% overflow pages',
   'database',
   'ing64',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4002, '# users connected',
   '&scriptdir/users_connected &home',
   'Return number of users that are connected to the database',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4003, 'Size default checkpoint files',
   'du -sk `grep II_CHECKPOINT &home/ingres/files/symbol.tbl | awk ''{print $2}''`/ingres/ckp/default/&database | awk ''{print $1 }'' ',
   'Return the size of the default checkpoint files of the database',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4004, 'Size default database files',
   'du -sk `grep II_DATABASE &home/ingres/files/symbol.tbl | awk ''{print $2}''`/ingres/data/default/&database | awk ''{print $1 }'' ',
   'Return the size of the default database files of the database',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4005, 'Size default dump files',
   'du -sk `grep II_DUMP &home/ingres/files/symbol.tbl | awk ''{print $2}''`/ingres/dmp/default/&database | awk ''{print $1 }'' ',
   'Return the size of the default dump files of the database',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4006, 'Size default journal files',
   'du -sk `grep II_JOURNAL &home/ingres/files/symbol.tbl | awk ''{print $2}''`/ingres/jnl/default/&database | awk ''{print $1 }'' ',
   'Return the size of the default journal files of the database',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4099, 'Disk transfer rate',
   '&scriptdir/disk_transfer',
   'get the transfer rate of the disk in kbps',
   'database',
   'ing64',
   null, 'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   4101, 'Total locks',
   '&scriptdir/set_environment &home \
lockstat | head -14 | awk ''/Total locks/ { print $3 }''',
   'Return number of total locks',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4102, '# deadlocks',
   '&scriptdir/deadlocks &home',
   'get the accumulative number of deadlocks in the system',
   'database',
   'ing64',
   null, 'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4103, 'Locks escalations',
   '&scriptdir/set_environment &home \
lockstat | head -14 | awk ''/Escalate/ { print $2 }''',
   'Return number of total locks',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4104, 'Percentage lock lists in use',
   '&scriptdir/set_environment &home \
lockstat | head | awk ''/Total lock lists/ { printf("%f\n", 100 * $(NF) / $4) }''',
   'Returns percentage of lock lists in use',
   'database',
   'ing64',
   null, 'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4105, 'Percentage locks in use',
   '&scriptdir/set_environment &home \
lockstat | head | awk ''\
        BEGIN { } \
        /Total locks/ { TOTAL = $3 } \
        /Locks in use/ { USED = $(NF) } \
        END { printf("%f\n", 100 * USED / TOTAL ) }''',
   'Returns percentage of locks in use',
   'database',
   'ing64',
   null, 'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4106, 'Locks in use',
   '&scriptdir/set_environment &home \
lockstat | head -11 | awk '' /Locks in use/ { print $NF }''',
   'Returns number of locks in use',
   'database',
   'ing64',
   null, 'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   4200, 'Percentage of log file in use',
   '&scriptdir/logfill &home',
   'get the percentage of the log file that is in use',
   'database',
   'ing64',
   null, 'os',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4201, 'Log reads',
   '&scriptdir/log_reads &home',
   'get number of log reads',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4202, 'Log writes',
   '&scriptdir/log_writes &home',
   'get number of log writes',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4203, 'Kbytes written',
   '&scriptdir/set_environment &home \
logstat | head -20 | awk ''/Kbytes written/ {print $(NF)}''',
   'Return total number of kbytes written',
   'database',
   'ing64',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   4300, 'Size errlog file',
   'du -sk &home/ingres/files/errlog.log | awk ''{print $1}'' ',
   'Return the size of the errlog.log file',
   'database',
   'ing64',
   null, 'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4310, 'Database not available',
   '&scriptdir/trace_errlog hour &home E_US0014',
   'Return the traced error of the errlog.log file',
   'database',
   'ing64',
   null, 'os',
   2, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4311, 'Trace error log file on DEADLOCK error',
   '&scriptdir/trace_errlog hour &home DEADLOCK',
   'Return the traced error of the errlog.log file',
   'database',
   'ing64',
   null, 'os',
   2, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   4320, 'Trace error log file on SESSION_INITIATE error',
   '&scriptdir/trace_errlog hour &home SESSION_INITIATE',
   'Return the traced error of the errlog.log file',
   'database',
   'ing64',
   null, 'os',
   2, null, null, null );

insert into DBA_PRED_CHECKS values (
   4330, 'Trace error log file on LICENSE error',
   '&scriptdir/trace_errlog day &home LICENSE',
   'Return the traced error of the errlog.log file',
   'database',
   'ing64',
   null, 'os',
   2, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5000, 'cumulative logons',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=0',
   'Return number of cumulative logons in current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5001, 'current logons',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=1',
   'Return number of current logons in the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5002, 'cumulative opened cursors',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=2',
   'Return cumulative opened cursors of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5003, 'current open cursors',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic# = 3',
   'Return current open cursors of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5004, 'user commits',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''user commits''',
   'Return number of user commits of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5005, 'user rollbacks',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''user rollbacks''',
   'Return number of user rollbacks of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5006, 'user calls',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''user calls''',
   'Return the user calls of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5007, 'recursive calls',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''recursive calls''',
   'Return the recursive calls of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5008, 'recursive cpu usage',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''recursive cpu usage''',
   'Return the recursive cpu usage of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5009, 'logical reads per session',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''session logical reads''',
   'Return the logical reads per session of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5010, 'stored procedure space per session',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''session stored procedure space''',
   'Return the stored procedure space of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5011, 'CPU used when call started',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''CPU used when call started''',
   'Return the CPU used when call started in this current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5012, 'CPU used by this session',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''CPU used by this session''',
   'Return the CPU used by this session of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5013, 'session connect time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''session connect time''',
   'Return the session connect time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5014, 'process last non-idle time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''process last non-idle time''',
   'Return the process last non-idle time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5015, 'session memory',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=15',
   'Return the session memory of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5016, 'max session memory',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=16',
   'Return the max session memory of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5017, 'messages sent',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''messages sent''',
   'Return the messages sent of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5018, 'messages received',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''messages received''',
   'Return the messages received of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5019, 'background timeouts',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''background timeouts''',
   'Return the background timeouts of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5020, 'pga memory per session',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=20',
   'Return the pga memory of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5021, 'max pga memory per session',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.statistic#=21',
   'Return the max pga memory of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5022, 'enqueue timeouts',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue timeouts''',
   'Return the enqueue timeouts of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5023, 'enqueue waits',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue waits''',
   'Return the enqueue waits of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5024, 'enqueue deadlocks',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue deadlocks''',
   'Return the enqueue deadlocks of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5025, 'enqueue requests',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue requests''',
   'Return the enqueue requests of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5026, 'enqueue conversions',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue conversions''',
   'Return the enqueue conversions of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5027, 'enqueue releases',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''enqueue releases''',
   'Return the enqueue releases of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5028, 'db block gets',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''db block gets''',
   'Return the db block gets of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5029, 'consistent gets',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''consistent gets''',
   'Return the consistent gets of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5030, 'physical reads',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''physical reads''',
   'Return the physical reads of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5031, 'physical writes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''physical writes''',
   'Return the physical writes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5032, 'write requests',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''write requests''',
   'Return the write requests of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5033, 'summed dirty queue length',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''summed dirty queue length''',
   'Return the summed dirty queue length of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5034, 'db block changes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''db block changes''',
   'Return the db block changes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5035, 'change write time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''change write time''',
   'Return the change write time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5036, 'consistent changes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''consistent changes''',
   'Return the consistent changes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5041, 'redo synch writes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo synch writes''',
   'Return the redo synch writes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5042, 'redo synch time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo synch time''',
   'Return the redo synch time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5044, 'exchange deadlocks',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''exchange deadlocks''',
   'Return the exchange deadlocks of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5045, 'free buffer requested',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''free buffer requested''',
   'Return the free buffer requested of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5046, 'dirty buffers inspected',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''dirty buffers inspected''',
   'Return the dirty buffers inspected of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5047, 'free buffer inspected',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''free buffer inspected''',
   'Return the free buffer inspected of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5050, 'remote instance undo writes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''remote instance undo writes''',
   'Return the remote instance undo writes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5051, 'remote instance undo requests',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''remote instance undo requests''',
   'Return the remote instance undo requests of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5053, 'cross instance CR read',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''cross instance CR read''',
   'Return the cross instance CR read of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5054, 'DBWR timeouts',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR timeouts''',
   'Return the DBWR timeouts of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5055, 'DBWR make free requests',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR make free requests''',
   'Return the dbwr make free requests of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5056, 'DBWR free buffers found',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR free buffers found''',
   'Return the dbwr free buffers found of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5057, 'DBWR lru scans',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR lru scans''',
   'Return the dbwr lru scans of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5058, 'DBWR summed scan depth',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR summed scan depth''',
   'Return the dbwr summed scan depth of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5059, 'DBWR buffers scanned',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR buffers scanned''',
   'Return the dbwr buffers scanned of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5060, 'DBWR checkpoints',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''DBWR checkpoints''',
   'Return the dbwr checkpoints of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5061, 'calls to kcmgcs',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''calls to kcmgcs''',
   'Return the calls to kcmgcs of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5064, 'redo entries',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo entries''',
   'Return the redo entries of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5065, 'redo size',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo size''',
   'Return the redo size of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5066, 'redo entries linearized',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo entries linearized''',
   'Return the redo entries linearized of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5067, 'redo buffer allocation retries',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo buffer allocation retries''',
   'Return the redo buffer allocation retries of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5069, 'redo wastage',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo wastage''',
   'Return the redo wastage of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5070, 'redo writer latching time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo writer latching time''',
   'Return the redo writer latching time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5071, 'redo writes',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo writes''',
   'Return the redo writes of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5072, 'redo blocks written',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo blocks written''',
   'Return the redo blocks written of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5073, 'redo write time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo write time''',
   'Return the redo write time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5076, 'redo log space requests',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo log space requests''',
   'Return the redo log space requests of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5077, 'redo log space wait time',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo log space wait time''',
   'Return the redo log space wait time of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5078, 'redo log switch interrupts',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''redo log switch interrupts''',
   'Return the redo log switch interrupts of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5079, 'background checkpoints started',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''background checkpoints started''',
   'Return the background checkpoints started of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5080, 'background checkpoints completed',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''background checkpoints completed''',
   'Return the background checkpoints completed of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5083, 'table scan rows gotten',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''table scan rows gotten''',
   'Return the table scan rows gotten of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5084, 'table scan blocks gotten',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''table scan blocks gotten''',
   'Return the table scan blocks gotten of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5085, 'table fetch by rowid',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''table fetch by rowid''',
   'Return the table fetch by rowid of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5086, 'table fetch continued row',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''table fetch continued row''',
   'Return the table fetch continued row of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5087, 'cluster key scans',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''cluster key scans''',
   'Return the cluster key scans of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5088, 'cluster key scan block gets',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''cluster key scan block gets''',
   'Return the cluster key scan block gets of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5089, 'parse time cpu',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''parse time cpu''',
   'Return the parse time cpu of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5090, 'parse time elapsed',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''parse time elapsed''',
   'Return the parse time elapsed of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5091, 'parse count',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''parse count''',
   'Return the parse count of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5092, 'sorts (memory)',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''sorts (memory)''',
   'Return the sorts (memory) of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5093, 'sorts (disk)',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''sorts (disk)''',
   'Return the sorts (disk) of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5094, 'sorts (rows)',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''sorts (rows)''',
   'Return the sorts (rows) of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5095, 'cursor authentications',
   'select v_$sysstat.value
          from sys.v_$sysstat v_$sysstat
          where v_$sysstat.name=''cursor authentications''',
   'Return the cursor authentications of the current instance',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5098, 'Database(s) active (Oracle)',
   'ps -ef | awk ''BEGIN {st = 0} /ora_dbwr_$database/ {st = 1} END { print st}''',
   'Return a 1 if a database is up and running and a 0 if it is not',
   'host',
   'ora7',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5099, 'Fill Percentage Filesystem',
   'df | awk ''{ print $4*1 }'' | fgrep system',
   'Return the degree that a filesystem is filled',
   'filesystem',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5100, '# tables in a Database',
   'select count(*) from sys.tab$',
   'Return the number of tables in the database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5101, '# users in a database',
   'select count(*) from sys.user$',
   'Return the number of users in the database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5102, '# Views in a database',
   'select count(*) from sys.view$',
   'Return the number of views in a database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5103, '# Free Space (Bytes) in a database',
   'select sum(bytes) from sys.dba_free_space',
   'Return the number of free space bytes in a database',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5104, '# Free Space (Bytes) in a tablespace',
   'select sum(bytes) from sys.dba_free_space where tablespace_name = ''&tablespace''',
   'Return the number of free space bytes within a tablespace',
   'tablespace',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5105, '# Free Space (Blocks) in a database',
   'select sum(blocks) from sys.dba_free_space',
   null, 'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5106, '# Free Space (Blocks) in a tablespace',
   'select sum(blocks) from sys.dba_free_space
  where tablespace_name = ''&tablespace''',
   null, 'tablespace',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5107, '% Free Space in a given Tablespace (in float)',
   'select (sum(sys.dba_free_space.blocks))/(sum (distinct sys.dba_data_files.blocks)) * 100 from sys.dba_free_space, sys.dba_data_files where sys.dba_free_space.tablespace_name = sys.dba_data_files.tablespace_name and sys.dba_free_space.file_id = sys.dba_data_files.file_id and sys.dba_free_space.tablespace_name = ''&tablespace''',
   null, 'tablespace',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5111, '# of Data Blocks Needed (in float)',
   'select (120*(NUM_ROWS)*(AVG_ROW_LEN))/((100-PCT_FREE)*(VALUE)) from sys.DBA_TABLES,sys.V_$PARAMETER where V_$PARAMETER.NAME=''db_block_size'' and DBA_TABLES.OWNER=UPPER(''&owner'') and DBA_TABLES.TABLE_NAME=UPPER(''&table'')',
   'Return the number of datablocks that are needed to store the table',
   'table',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5112, 'Blocks Allocated',
   'select BLOCKS from SYS.DBA_TABLES where DBA_TABLES.OWNER=UPPER(''&owner'') and DBA_TABLES.TABLE_NAME=UPPER(''&table'')',
   'Return the number of datablocks that are ALLOCATED to store the data that is in the table.',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5115, 'Blocked Sessions',
   'select count(*) from sys.v_$session v_$session where v_$session.lockwait is not null',
   null, 'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5117, 'Transactions Rate',
   'Select sum(v_$sysstat.value) from sys.v_$sysstat v_$sysstat where (v_$sysstat.name = ''user rollbacks'') or (v_$sysstat.name = ''user commits'')',
   null, 'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5118, 'Disk I/O',
   'Select sum(v_$sysstat.value)
      from sys.v_$sysstat v_$sysstat
      where (v_$sysstat.name = ''physical reads'') or
      (v_$sysstat.name = ''physical writes'')',
   null, 'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5119, 'Cache Miss % (in float)',
   'select
           (100*v_$sysstat1.value) /(v_$sysstat2.value+v_$sysstat3.value)
     from
     sys.v_$sysstat v_$sysstat1,
     sys.v_$sysstat v_$sysstat2,
     sys.v_$sysstat v_$sysstat3
     where
     v_$sysstat1.name = ''physical reads''
     and v_$sysstat2.name = ''consistent gets''
     and v_$sysstat3.name = ''db block gets''',
   null, 'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5121, 'Unauthorized Access by session id',
   'select sessionid from sys.aud$ where returncode=2004 and obj$name=''&table'' and obj$creator=''&owner''',
   'Return the session identification number of the session that issued the unauthorized access',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5134, 'Fragmentation of a tablespace',
   'select count(a.block_id) from sys.dba_free_space a where a.tablespace_name = ''&tablespace'' and a.blocks < (select sum(b.blocks)*0.05 from sys.dba_data_files b)',
   'Return a number that indicates the degree of fragmentation of a tablespace. It returns the number of separate datablocks that are smaller than 5% of the total space in the tablespace',
   'tablespace',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5138, 'Rollback Segment Contention (in float)',
   'select (sum(waits)/sum(gets)) from v$rollstat',
   null, 'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5139, 'Library Cache Miss % (in float)',
   'select (sum(reloads)/sum(pins)) from v$librarycache',
   null, 'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5140, 'Data Dictionary GETSMISSES/GETS % (in float)',
   'select (sum(getmisses)/sum(gets)) from v$rowcache',
   null, 'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5242, 'Buffer Cache Hit Ratio (in float)',
   'select (1-(v$sysstat1.value)/((v$sysstat2.value)+(v$sysstat3.value)))
     from
     sys.v_$sysstat v$sysstat1,
     sys.v_$sysstat v$sysstat2,
     sys.v_$sysstat v$sysstat3
     where
     v$sysstat1.name =''physical reads''
     and v$sysstat2.name=''consistent gets''
     and v$sysstat3.name=''db block gets''',
   'Returns buffer cache hit ratio', 'database',
   'ora7',
   null, 'sql',
   0, '<', '0.80', 'y' );

insert into DBA_PRED_CHECKS values (
   5143, 'Percentage Paging Space Used',
   '/usr/sbin/lsps -sa | tail -1 | awk ''{print $2*1}''',
   'Return the percentage of the Paging Space that is currently instance',
   'host',
   'ora7',
   'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5146, 'Total Size of the Paging Space (MB)',
   '/usr/sbin/lsps -sa | tail -1 | awk ''{print $1*1}''',
   'Return the total size of the Paging Space in Mega Bytes',
   'host',
   null, 'aix',
   'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5149, 'Number of tables approaching max remaining extents',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''TABLE'' and (extents > (max_extents * 0.95)) ',
   'Return the number of tables approaching max remaining extents',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5150, 'Number of free sessions',
   'select (SESSIONS_MAX - SESSIONS_CURRENT) from sys.v_$license where sessions_max > 0',
   'Return the number of free sessions remaining',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5151, 'Max number of processes per user',
   '/usr/sbin/lsattr -E -l sys0 | grep maxuproc | awk ''{print $2}''',
   'Return max number of processes per user',
   'host',
   null,
   'aix', 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5152, 'Number of active processes',
   'select count(*) from sys.v_$process',
   'Return the number of processes',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5153, 'Process limit',
   'select value from sys.v_$parameter where name = ''processes''',
   'Return the max process limit',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5154, 'Rollback seg approaching max remaining extents',
   'select (extents / max_extents) from sys.dba_segments where segment_type = ''ROLLBACK'' and segment_name = upper(''&table'')',
   'Return the number of remaining extents for the current rollback segment; if 0, dynamic extent allocation will fail',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5155, 'latches miss ratio',
   'select sum(misses) / (sum(gets) + sum(misses)) from sys.v_$latch',
   null,
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5156, 'Index approaching max remaining extents',
   'select (max_extents - extents) from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''INDEX'' and segment_name = upper(''&table'')',
   'Return the number of remaining extents for the current index; if 0, dynamic extent allocation will fail',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5157, '# of indexes approaching max remaining extents',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''INDEX'' and extents < (max_extents * 0.1) ',
   'Return the number of indexes approaching max remaining extents',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5158, 'SGA free memory (in bytes) ',
   'select bytes from sys.v_$sgastat where name = ''free memory''',
   'Return the SGA free memory in bytes',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5159, 'Logfile alarm - # of invalid logfiles',
   'select count(group#) from sys.v_$logfile where status = ''INVALID''',
   'Return the number of invalid log files in the database',
   'database',
   'ora7',
   null, 'sql',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5160, 'Logfile alarm - # of stale logfiles',
   'select count(group#) from sys.v_$logfile where status = ''STALE''',
   'Return the number of log files that have incomplete contents',
   'database',
   'ora7',
   null, 'sql',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5162, 'DML locks threshold exceeded',
   'select count(*) from sys.v_$lock where type in (''RW'',''TM'',''TX'',''ul'')',
   'Return the number user locks',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5163, 'Max number of DML locks',
   'select value from sys.v_$parameter where name=''dml_locks''',
   'Return max number of DML locks',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5164, 'Max number of database files',
   'select value from sys.v_$parameter where name=''db_files''',
   'Return max number of database files',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5165, 'Number of database files',
   'select count(*) from sys.dba_data_files',
   'Return number of database files',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5166, 'Number of open cursors',
   'select count(*) from sys.v_$open_cursor',
   'Return number of open cursors',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5167, 'Number of shared servers',
   'select count(*) from sys.v_$shared_server',
   'Return number of shared server process',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5168, 'Avg # of leaf blocks in which a key appears',
   'select avg(avg_leaf_blocks_per_key) from sys.dba_indexes',
   'Return average number of leaf blocks in which a key appears',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5169, 'Avg # of data blocks in which a key appears',
   'select avg(avg_data_blocks_per_key) from sys.dba_indexes',
   'Return average number of data blocks in which a key appears',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5170, 'Average number of distinct keys in each index',
   'select avg(distinct_keys) from sys.dba_indexes',
   'Return average number of distinct keys in each index',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5171, 'Average number of leaf blocks in each index',
   'select avg(leaf_blocks) from sys.dba_indexes',
   'Return average number of leaf blocks in each index',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5172, 'Average clustering factor in each index',
   'select avg(clustering_factor) from sys.dba_indexes',
   'Return average clustering factor in each index',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5173, 'Amount of memory sharable by users',
   'select avg(sharable_mem) from sys.v_$sqlarea',
   'Return amount of memory sharable by users',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5174, 'Amount of per user memory for life of cursor',
   'select avg(persistent_mem) from sys.v_$sqlarea',
   'Return amount of per user memory for life of cursor',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5175, '# of Table dynamic extent allocation failure',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''TABLE'' and (extents = max_extents)',
   'Return # of tables that have reached maximum extent specified',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5176, '# of rollback seg dynamic extent alloc failure',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''ROLLBACK'' and (extents = max_extents)',
   'Return # of rollback segments that have reached maximum extent specified',
   'database',
   'ora7',
   null, 'sql',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5177, '# of index dynamic extent allocation failure',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''INDEX'' and (extents < max_extents) ',
   'Return # of indexes that have reached maximum extent specified',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5178, '# broken jobs in Oracle queue',
   'select count(*) from sys.dba_jobs where broken=''Y''',
   'Return # of jobs in Oracle job queue that have broken',
   'database',
   'ora7',
   null, 'sql',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   5179, 'If job in Oracle job queue has broken Y/N',
   'select broken from sys.dba_jobs where job = &jobid',
   'Return Y if job has been broken; otherwise, return N',
   'database',
   'ora7',
   null, 'sql',
   2, null, null, null );

insert into DBA_PRED_CHECKS values (
   5180, 'Cluster approaching max remaining extents',
   'select (extents / max_extents) from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''CLUSTER'' and segment_name = upper(''&table'')',
   'Return the number of remaining extents for the current cluster; if 0, dynamic extent allocation will fail',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5181, '# of clusters approaching max remaining extents',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''CLUSTER'' and (max_extents-extents) < 5',
   'Return the number of clusters approaching max remaining extents',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5182, '# of cluster dynamic extent allocation failure',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''CLUSTER'' and (extents = max_extents)',
   'Return # of clusters that have reached maximum extent specified',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5183, 'Data buffer busy waits',
   'select count(sid) from sys.v_$session_wait where event = ''buffer busy waits''',
   'Return # of sessions that have buffer busy waits',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5184, '# of extents allocated to index',
   'select extents from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''INDEX'' and segment_name = upper(''&table'')',
   'Return the number of extents for the current index',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5185, 'size of index (in bytes)',
   'select bytes from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''INDEX'' and segment_name = upper(''&table'')',
   'Return the number of bytes for the current index',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5186, 'Max # of cluster extents',
   'select max_extents from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''CLUSTER'' and segment_name = upper(''&table'')',
   'Return the maximum number of extents that can be allocated for the current cluster',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5187, 'Next extent (in bytes) of cluster extents',
   'select next_extent from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''CLUSTER'' and segment_name = upper(''&table'')',
   'Return the number of bytes for the next cluster extent',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5188, '# of extents allocated to cluster',
   'select extents from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''CLUSTER'' and segment_name = upper(''&table'')',
   'Return the number of extents for the current cluster',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5189, 'size of cluster (in bytes)',
   'select bytes from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''CLUSTER'' and segment_name = upper(''&table'')',
   'Return the number of bytes for the current cluster',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5190, 'Total # of job in Oracle job queue',
   'select count(*) from sys.dba_jobs',
   'Return # of jobs in Oracle job queue',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5191, 'Total # of job failures in Oracle job queue',
   'select count(*) from sys.dba_jobs where failures > 0',
   'Return total # of job failures in Oracle job queue',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5192, '# of job failures in an Oracle job',
   'select failures from sys.dba_jobs where job = ''&jobid''',
   'Return # of job failures in an Oracle job',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5193, 'Total # of transactions',
   'select count(*) from sys.v_$transaction',
   'Return total # of transactions',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5194, 'Table approaching max remaining extents',
   'select (max_extents - extents) from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''TABLE'' and segment_name = upper(''&table'')',
   'Return the number of remaining extents for the current table; if 0, dynamic extent allocation will fail',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5195, 'Open Cursors hit ratio',
   'select hit_ratio from sys.v_$system_cursor_cache',
   null,
   'database',
   'ora7',
   null, 'sql',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5196, 'Excessively log exclusive lock wait',
   'select * from sys.v_$lock where request in (3,5,6) and (lmode < request) and (type in (''LS'' ,''RT''))',
   'Returns Excessively log exclusive lock wait',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5197, '# of rollback approaching max remaining extents',
   'select count(distinct(segment_name)) from sys.dba_segments where segment_type = ''ROLLBACK'' and (extents > (max_extents * 0.95))',
   'Return the number of tables that have less than 5 remaining extents',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5198, 'Total # of times that latches are obtained',
   'select sum(gets) from sys.v_$latch',
   null,
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5199, 'Total # of times that latches are missed',
   'select sum(misses) from sys.v_$latch',
   null,
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5200, 'Library Cache Request Hits Ratio',
   'select sum(gethitratio) from sys.v_$librarycache',
   'Return Library Cache Request Hits Ratio',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5201, 'Library Cache Request Hits',
   'select sum(gethits) from sys.v_$librarycache',
   'Return Library Cache Request Hits',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5202, 'Library Cache Request',
   'select sum(gets) from sys.v_$librarycache',
   'Return Library Cache Request',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5203, 'Library Cache Invalidations',
   'select sum(invalidations) from sys.v_$librarycache',
   'Return Library Cache Invalidations',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5204, 'Library Cache Pin Hits Ratio',
   'select sum(pinhitratio) from sys.v_$librarycache',
   'Return Library Cache Pin Hits Ratio',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5205, 'Library Cache Pin Requests',
   'select sum(pins) from sys.v_$librarycache',
   'Return Library Cache Pin Requests',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5206, 'Library Cache Reloads',
   'select sum(reloads) from sys.v_$librarycache',
   'Return Library Cache Reloads',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5207, 'Rollback Buffer Busy Waits',
   'select sum(waits) from sys.v_$rollstat, sys.v_$rollname where sys.v_$rollstat.usn=sys.v_$rollname.usn',
   'Return Rollback Buffer Busy Waits',
   'database',
   'ora7',
   null, 'sql',
   0, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   5208, 'Total File Physical Blocks Write',
   'select sum(phyblkwrt) from sys.v_$filestat',
   'Return Total File Physical Blocks Write',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5209, 'Total File Physical Blocks Read',
   'select sum(phyblkrd) from sys.v_$filestat',
   'Return Total File Physical Blocks Read',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5210, 'File Physical Writes',
   'select sum(phywrts) from sys.v_$filestat',
   'Return File Physical Writes',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5211, 'File Physical Reads',
   'select sum(phyrds) from sys.v_$filestat',
   'Return File Physical Reads',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5212, 'Average File Physical Blocks Write',
   'select (sum(phyblkwrt)/count(*)) from sys.v_$filestat',
   'Return Average File Physical Blocks Write',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5213, 'Average File Physical Blocks Read',
   'select (sum(phyblkrd)/count(*)) from sys.v_$filestat',
   'Return Average File Physical Blocks Read',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5214, 'Average File Physical Writes',
   'select (sum(phywrts)/count(*)) from sys.v_$filestat',
   'Return Average File Physical Writes',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5215, 'Average File Physical Reads',
   'select (sum(phyrds)/count(*)) from sys.v_$filestat',
   'Return Average File Physical Reads',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5216, 'Number Of Gets Per Rollback Segment(in float)',
   'select (sum(gets)/count(*)) from sys.v_$rollstat',
   'Return Number Of Gets Per Rollback Segment(in float)',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5217, 'Average Number of Rollback Segment Waits',
   'select (sum(waits)/count(*)) from sys.v_$rollstat',
   'Return Average Number of Rollback Segment Waits',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5218, 'Physical Writes For Current Logon Session',
   'select sum(value) from sys.v_$session sess, sys.v_$sesstat stat, sys.v_$statname name where sess.sid=stat.sid and stat.statistic# = name.statistic# and username = user and name.name = ''physical writes''',
   'Return Physical Writes For Current Logon Session',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5219, 'Average Number of Rollback Segment Writes',
   'select (sum(writes)/count(*)) from sys.v_$rollstat',
   'Return Average Number of Rollback Segment Writes',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5220, 'Rollback Transactions Per Active Rollback Segment',
   'select (sum(xacts)/count(*)) from sys.v_$rollstat roll where roll.status=''ONLINE''',
   'Return Rollback Transactions Per Active Rollback Segment',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5221, 'Maximum Number Of Rollback Segment Extents',
   'select max_extents from sys.dba_rollback_segs where segment_name = UPPER(''&segname'')',
   'Return Maximum Number Of Rollback Segment Extents',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5222, 'Size Of The Next Rollback Segment Extent',
   'select next_extent from sys.dba_rollback_segs where segment_name = UPPER(''&segname'')',
   'Return Size Of The Next Rollback Segment Extent',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5223, 'Number Of Rollback Segment Extents',
   'select extents from sys.dba_segments where segment_type = ''ROLLBACK'' and segment_name = UPPER(''&segname'')',
   'Return Number Of Rollback Segment Extents',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5224, 'Size Of Rollback Segment In Oracle Blocks',
   'select blocks from sys.dba_segments where segment_type = ''ROLLBACK'' and segment_name = UPPER(''&segname'')',
   'Return Size Of Rollback Segment In Oracle Blocks',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5225, 'Max extents allocated to index',
   'select max_extents from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''INDEX'' and segment_name = upper(''&table'')',
   'Return the max number of extents for the current index',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5226, 'Next extent allocated to index',
   'select next_extent from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''INDEX'' and segment_name = upper(''&table'')',
   'Return the next of extents for the current index',
   'table',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5227, 'Tablespace Size In Bytes',
   'select sum(bytes) from sys.dba_extents where tablespace_name = upper(''&tablespace'')',
   'Return the tablespace size in bytes',
   'tablespace',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5228, 'Size In Bytes Of Largest Free Extent',
   'select max(bytes) from sys.dba_free_space where tablespace_name = upper(''&tablespace'')',
   'Return the largest size in bytes of the largest free extent',
   'tablespace',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5229, 'Size Of Next Extent For Table',
   'select next_extent from sys.DBA_TABLE where DBA_TABLES.OWNER=UPPER(''&owner'') and DBA_TABLES.TABLE_NAME=UPPER(''&table'')',
   'Return the size of the next extent for table',
   'table',
   'ora7',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5230, 'Number of extents allocated to table',
   'select extents from sys.dba_segments where owner = upper(''&owner'') and segment_type = ''TABLE'' and segment_name = upper(''&table'')',
   'Return the number of extents allocated to table',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5231, 'Rollback buffer busy waits',
   'select sum(count) from sys.v_$waitstat where class in (''system undo header'', ''system undo block'', ''undo header'', ''undo block'')',
   'Rollback buffer busy waits',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5232, 'Table chained rows threshold exceeded',
   'select chain_cnt from sys.dba_tables where table_name = upper(''&table'') and owner = upper(''&owner'')',
   'Return table chained rows threshold exceeded',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5233, 'Max sessions',
   'select SESSIONS_MAX from sys.v_$license',
   'Return the number of max sessions',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5234, 'Current sessions',
   'select SESSIONS_CURRENT from sys.v_$license',
   'Return the number of current sessions',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5235, 'SGA size (in bytes) ',
   'select sum(bytes) from sys.v_$sgastat',
   'Return the SGA size in bytes',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5237, 'DML locks held',
   'select count(*) from sys.v_$lock where type in (''RW'',''TM'',''TX'',''ul'')',
   'Returns the total number of DML locks held',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5238, 'latches get ratio',
   'select sum(gets) / (sum(gets) + sum(misses)) from sys.v_$latch',
   'Returns the latches get ratio.',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5239, 'table scans (short tables)',
   'select v_$sysstat.value from sys.v_$sysstat v_$sysstat where v_$sysstat.name=''table scans (short tables)''',
   'Returns the short table scans',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5240, 'table scans (long tables)',
   'select v_$sysstat.value from sys.v_$sysstat v_$sysstat where v_$sysstat.name=''table scans (long
tables)''',
   'Returns long table scans',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5241, 'redo small copies',
   'select v_$sysstat.value from sys.v_$sysstat v_$sysstat where v_$sysstat.name=''redo small copies''',
   'Returns redo small copies',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5243, 'Fragmentation of a tablespace',
   'select count(a.block_id) from sys.dba_free_space a where a.tablespace_name = upper(''&tablespace'') and a.blocks < (select sum(b.blocks)*0.05 from sys.dba_data_files b)',
   'Returns Fragmentation of a tablespace',
   'database',
   'ora7',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   5244, 'Buffer Contention % (in float)',
   'select ((100*a.value) / (b.value + c.value)) from sys.v_$sysstat a, sys.v_$sysstat b, sys.v_$sysstat c where a.name = ''buffer busy wait'' and b.name = ''consistent gets'' and c.name=''db block gets''',
   'Returns Buffer Contention % ',
   'database',
   'ora7',
   null, 'sql',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   5246, '% CPU usage: user',
   'iostat -t | tail -1 | awk ''{ print $3 }''',
   'Returns % CPU usage: user',
   'host',
   null,
   'aix', 'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   5248, 'current system load',
   'uptime | sed ''s/.*average:\(.*\),.*,.*/\1/g''',
   'Returns current system load',
   'host',
   null,
   'aix', 'os',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   6702, '# users who can access a specific database',
   'select count(*) from &database..sysusers where gid <> uid',
   'Return number of users who can access a database',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6703, '# logins who can access the sybase server',
   'select count(*) from master..syslogins',
   'Return number of logins who can access the sybase server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6704, '# databases in a sybase server',
   'select count(name) from master..sysdatabases',
   'Return number of databases in a sybase server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6705, 'max # of connections to sybase server',
   'select @@max_connections',
   'Return maximum number of connections to the sybase server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6706, 'maximum number of processes in database',
   'select count(*)
    from    master..sysprocesses p
    ,    master..sysdatabases d
    where   p.dbid = d.dbid
    and     d.name = "&database"',
   'Return maximum number of processes in a database',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6707, '# of CPU sec that Sybase Server Worked',
   'select cpu_busy from master..spt_monitor',
   'Return number of CPU seconds that Sybase Server was doing SQL Server Work',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6708, '# of sec that Sybase Server performed I/O',
   'select io_busy from master..spt_monitor',
   'Return number of seconds that Sybase Server has spent doing I/O operations',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6709, '# seconds that Sybase Server has been idle',
   'select idle from master..spt_monitor',
   'Return number of seconds that Sybase Server has been idle',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6710, '# input packets read by Sybase Server',
   'select pack_received from master..spt_monitor',
   'Return number of input packets read by Sybase Server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6711, '# output packets written by Sybase Server',
   'select pack_sent from master..spt_monitor',
   'Return number of output packets written by Sybase Server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6712, '# of read/write packet errors detected',
   'select pack_errors from master..spt_monitor',
   'Return number of errors detected by Sybase Server while reading and writing packets',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6713, '# disk reads by Sybase Server',
   'select total_read from master..spt_monitor',
   'Return number of disk reads by Sybase Server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6714, '# disk writes by Sybase Server',
   'select total_write from master..spt_monitor',
   'Return number of disk writes by Sybase Server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6715, '# of total read/write errors detected',
   'select total_errors from master..spt_monitor',
   'Return number of errrors detected by Sybase Server while reading and writing packets',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6716, '# of logins or attempted logins',
   'select connections from master..spt_monitor',
   'Return the number of logins or attempted logins to Sybase Server',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6721, 'remaining log space in a database(KB)',
   'select sum(curunreservedpgs(d.dbid, u.lstart, u.unreservedpgs) * 2)
            from master.dbo.sysdatabases d,
                 master.dbo.sysusages u,
                 master.dbo.sysdevices v,
                 master.dbo.spt_values a,
                 master.dbo.spt_values b,
                 master.dbo.sysmessages m
                where d.dbid = u.dbid
                        and v.low <= u.size + vstart
                        and v.high >= u.size + vstart - 1
                        and v.status & 2 = 2
                        and d.name = "&database"
                        and a.type = "E"
                        and a.number = 1
                        and b.type = "S"
                        and u.segmap & 7 = b.number
                        and b.msgnum = m.error
                        and m.description like "%log%"
            order by 1',
   'Return remaining log space in a database(KB)',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6722, 'used log space in a database(KB)',
   'select data_pgs(id, doampg) * 2
     from sysindexes where id = 8',
   'Return used log space in a database(KB)',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6723, '# deadlocks',
   'select count(l.id) from master..sysdatabases d, master..syslocks l
   where d.dbid = l.dbid and d.name = "&database" and l.type=256',
   'Return number of deadlocks',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   6724, 'Run value of the config param, devices (Sybase 10)',
   'select b.value from master.dbo.spt_values a, master.dbo.sysconfigures b,master.dbo.syscurconfigs c
   where type = "C" and number *= b.config and number *= c.config and number >= 0 and name like "devices"',
   'Return the run value of the configuration parameter, devices',
   'sybase_server',
   'syb',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   6725, 'Total devices currently used (Sybase 10)',
   'select count(d.name) from master.dbo.sysdevices d, master.dbo.spt_values v
   where v.type = "E" and v.number = 3',
   'Return the total device number currently used',
   'sybase_server',
   'syb',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   6726, 'Run val. of config param, open databases(Sybase10)',
   'select value from master..syscurconfigs
   where comment like "%open databases allowed%"',
   'Return the run config limit of the allowed open databases',
   'sybase_server',
   'syb',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   6727, 'Number of open databases (Sybase 10)',
   'select count(*) from master..sysdatabases',
   'Returns the number of databases which are currently open',
   'sybase_server',
   'syb',
   null, 'sql',
   0, null, null, null );

insert into DBA_PRED_CHECKS values (
   6728, 'Free space available for a database in KBytes',
   'select sum((curunreservedpgs(d.dbid, u.lstart, u.unreservedpgs) * 2))
   from master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.sysdevices v,
    master.dbo.spt_values a, master.dbo.spt_values b, master.dbo.sysmessages m
   where d.dbid = u.dbid
    and v.low <= u.size + vstart
    and v.high >= u.size + vstart - 1
    and v.status & 2 = 2
    and d.name = "&database"
    and a.type = "E"
    and a.number = 1
    and b.type = "S"
    and u.segmap & 7 = b.number
    and b.msgnum = m.error
   order by 1',
   'Return the free space available for a database in KBytes',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6729, 'Size of the database in KBytes',
   'select sum(size) *2 from master..sysusages
   where dbid=db_id(''&database'')',
   'Return the size available for a database in KBytes',
   'database_syb',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6730, '# of db marked suspect or unusable by the server',
   'select count(*) from master..sysdatabases
   where status = 32 or status = 256',
   'Return number of database have been marked syspect or unusable by the server',
   'database_syb',
   'syb',
   null, 'sql',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6731, 'Number of long-running transactions in a database',
   'select first from &database..sysindexes where id=8',
   'Return number of long-running transactions in a database',
   'database_syb',
   'syb',
   null, 'sql',
   0, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6732, 'Remaining space in master..syslogs in kbytes',
   'select sum(curunreservedpgs(d.dbid, u.lstart, u.unreservedpgs) * 2)
   from master.dbo.sysdatabases d, master.dbo.sysusages u, master.dbo.sysdevices v,
    master.dbo.spt_values a, master.dbo.spt_values b, master.dbo.sysmessages m
   where d.dbid = u.dbid
    and v.low <= u.size + vstart
    and v.high >= u.size + vstart - 1
    and v.status & 2 = 2
    and d.name = "master"
    and a.type = "E"
    and a.number = 1
    and b.type = "S"
    and u.segmap & 7 = b.number
    and m.description like "%log%"
   order by 1',
   'Return remaining amount of space in master..syslogs in KBytes',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6733, 'Full capacity of the transaction log in master db',
   'select sum(size) from master..sysusages
   where dbid=db_id("master") and (segmap & 4) = 4',
   'Return full capacity of the transaction log in master database in KBytes',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6734, 'Free segment space for the default db in kbytes',
   'select sum(curunreservedpgs(dbid, lstart, unreservedpgs)) * 2
   from master.dbo.sysusages u, syssegments s
   where u.dbid=( select db_id(dbname) from master.dbo.syslogins
    where name = suser_name () )
   and u.segmap & power( 2, s.segment ) != 0
   and s.name = "default"',
   'Return free segment space for the default database in kbytes',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   6735, 'Total default segment space for def. db in KBytes',
   'select sum(u.size) * 2
   from master.dbo.sysusages u, syssegments s
   where u.dbid=( select db_id(dbname) from master.dbo.syslogins
    where name = suser_name () )
   and u.segmap & power( 2, s.segment ) != 0
   and s.name = "default"',
   'Return total default segment space for the default database in kbytes',
   'sybase_server',
   'syb',
   null, 'sql',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   7001, '# indexes in a database',
   'select count(*) from sysibm.sysindexes where
   creator <>''SYSIBM'' and tbcreator <>''WINDMILL''',
   'Return number of user created indexes
   in the database excluding those created by SYSIBM
   and DATAHUB',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7002, '# triggers defined in the database',
   'select count(*) from syscat.triggers',
   'Return number of triggers defined in the database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7003, '# invalid triggers defined in the database',
   'select count(*) from syscat.triggers where valid !=''Y''',
   'Return number of invalid triggers in the database',
   'database',
   'db2_2',
   null, 'sql',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7004, '# tablespaces defined in the database',
   'select count(*) from syscat.tablespaces',
   'Return number of tablespaces in database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7005, '# system managed tablespaces ',
   'select count(*) from syscat.tablespaces where  tbspacetype =''S''',
   'Return number of system managed tablespaces in database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7006, '# database managed tablespaces ',
   'select count(*) from syscat.tablespaces where  tbspacetype =''D''',
   'Return number of database managed tablespaces in database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7007, '# tablespaces that stores Long data type',
   'select count(*) from syscat.tablespaces where datatype =''L''',
   'Return number of tablespaces that stores Long data type',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7008, '# event monitors in this database',
   'select count(*) from syscat.events',
   'Return number of event monitors defined in the database',
   'database',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7009, '# tables in a tablespace',
   'select count(*) from syscat.tables where tbspace = ''&tablespace''',
   'Return number of tables in a specific tablespace',
   'tablespace',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7010, '# tables owned by a user in a database',
   'select count(distinct tabname) from syscat.tables where tabschema=
     translate(''&name'') and type = ''T''',
   'Return number of tables owned by a user in a database',
   'user',
   'db2_2',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7011, 'idle DB2 agents for an instance',
   '&scriptdir/dbm_snap &home  Idle agents',
   'Return number of idle agents for an instance',
   'instance ',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7012, 'applications currently waiting on locks',
   '&scriptdir/db_locks &home &database waiting on locks',
   'Return number of applications currently waiting on locks in a database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7014, '# locks held in a database',
   '&scriptdir/db_locks &home &database Locks held',
   'Return number of locks held in a database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7015, 'time application waited on locks(ms)',
   '&scriptdir/ap_locks &home &database Time application waited',
   'Return amount of time application waited on locks(ms)',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7016, 'exclusive lock escalations for application ',
   '&scriptdir/ap_locks &home &database Exclusive lock escalations',
   'Return number of times of exclusive lock escalations for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7017, 'lock escalations for application ',
   '&scriptdir/ap_locks &home &database Lock escalations',
   'Return number of times of lock escalations for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7018, 'lock timeouts since application connection',
   '&scriptdir/ap_locks &home &database Lock Timeouts since',
   'Return number of lock timeouts since application connection',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7019, 'deadlocks detected for apps. ',
   '&scriptdir/ap_locks &home &database Deadlocks detected',
   'Return number of times deadlocks detected for application',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7020, 'lock waits since connect',
   '&scriptdir/ap_locks &home &database Lock waits since',
   'Return lock waits since application connect',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7021, 'locks held by application',
   '&scriptdir/ap_locks &home &database Locks held by',
   'Return number of locks held by application ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7022, 'total time UOW waited on locks (ms)',
   '&scriptdir/ap_locks &home &database Total time UOW',
   'Return total time UOW waited on locks (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7023, 'total sorts for applications',
   '&scriptdir/ap_locks &home &database Total sorts',
   'Return total sorts for applications (ms) ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7024, 'total sort time (ms) for application ',
   '&scriptdir/ap_locks &home &database Total sort time',
   'Return total sort time (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7025, 'total sort overflows',
   '&scriptdir/ap_locks &home &database Total sort overflows',
   'Return total sort overflows for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7026, 'rows deleted for apps. ',
   '&scriptdir/ap_locks &home &database Rows deleted',
   'Return number of rows deleted for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7027, 'rows inserted for apps. ',
   '&scriptdir/ap_locks &home &database Rows inserted',
   'Return number of rows inserted for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7028, 'rows updated for apps. ',
   '&scriptdir/ap_locks &home &database Rows updated',
   'Return number of rows updated for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7029, 'rows selected for apps. ',
   '&scriptdir/ap_locks &home &database Rows selected',
   'Return number of rows selected for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7030, 'rows read ',
   '&scriptdir/ap_locks &home &database Rows read',
   'Return number of rows read for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7031, 'rows written ',
   '&scriptdir/ap_locks &home &database Rows written',
   'Return number of rows written for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7032, 'commit statements ',
   '&scriptdir/ap_locks &home &database Commit statements',
   'Return number of commit statements for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7033, 'rollback statements ',
   '&scriptdir/ap_locks &home &database Rollback statements',
   'Return number of rollback statements for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7034, 'failed statement operations for apps.',
   '&scriptdir/ap_locks &home &database Failed statement operations',
   'Return number of failed statement operations for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7035, 'internal rollbacks due to deadlock for apps.',
   '&scriptdir/ap_locks &home &database Internal rollbacks due',
   'Return number of internal rollbacks due to deadlock for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7036, 'update/insert/delete statements executed for apps.',
   '&scriptdir/ap_locks &home &database Update/Insert/Delete',
   'Return number of update/insert/delete statements executed',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7037, 'internal automatic rebinds for apps.',
   '&scriptdir/ap_locks &home &database Internal automatic rebinds ',
   'Return internal automatic rebinds for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7038, 'internal rows deleted for apps. ',
   '&scriptdir/ap_locks &home &database Internal rows deleted',
   'Return internal rows deleted for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7039, 'internal rows inserted for apps.',
   '&scriptdir/ap_locks &home &database Internal rows inserted',
   'Return internal rows inserted for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7040, 'internal rows updated for apps. ',
   '&scriptdir/ap_locks &home &database Internal rows updated',
   'Return internal rows updated for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7042, 'internal commits for applications',
   '&scriptdir/ap_locks &home &database Internal commits',
   'Return internal commits for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7043, 'internal rollbacks for applications',
   '&scriptdir/ap_locks &home &database Internal rollbacks',
   'Return internal rollbacks for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7044, 'UOW log space used (bytes)',
   '&scriptdir/ap_locks &home &database UOW log space',
   'Return UOW log space used (bytes) for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7045, 'open local cursors ',
   '&scriptdir/ap_locks &home &database Open local cursors',
   'Return open local cursors for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7046, 'open local cursors with blocking ',
   '&scriptdir/ap_locks &home &database cursors with blocking',
   'Return open local cursors with blocking for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7047, 'current communication heap size (bytes)',
   '&scriptdir/ap_locks &home &database Current communication',
   'Return current communication heap size (bytes) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7048, 'maximum communication heap size (bytes)',
   '&scriptdir/ap_locks &home &database Maximum communication heap',
   'Return maximum communication heap size (bytes) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7049, 'total User CPU time used by statement(s)',
   '&scriptdir/ap_locks &home &database User CPU Time used by statement',
   'Return total user CPU time used by statement(s) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7050, 'total System CPU Time used by statement(s)',
   '&scriptdir/ap_locks &home &database System CPU Time used by statement',
   'Return total System CPU Time used by statement(s) for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7051, 'total User CPU Time used by agent(s)',
   '&scriptdir/ap_locks &home &database User CPU Time used by agent',
   'Return total user CPU time used by agent(s) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7052, 'total System CPU Time used by agent(s)',
   '&scriptdir/ap_locks &home &database System CPU time used by agent',
   'Return total System Cpu Time used by agent(s) for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7053, 'package cache lookups for apps.',
   '&scriptdir/ap_locks &home &database Package cache lookups',
   'Return package cache lookups for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7054, 'package cache inserts for apps.',
   '&scriptdir/ap_locks &home &database Package cache inserts',
   'Return package cache inserts for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7055, 'catalog cache overflows for apps.',
   '&scriptdir/ap_locks &home &database Catalog cache overflows',
   'Return catalog cache overflows for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7056, 'catalog cache heap full for apps.',
   '&scriptdir/ap_locks &home &database Catalog cache heap full',
   'Return catalog cache heap full for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7057, 'buffer pool data logical reads for apps.',
   '&scriptdir/ap_locks &home &database data logical reads ',
   'Return buffer pool data logical reads for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7058, 'buffer pool data physical reads for apps. ',
   '&scriptdir/ap_locks &home &database data physical reads ',
   'Return buffer pool data physical reads for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7059, 'buffer pool data writes for apps.',
   '&scriptdir/ap_locks &home &database pool data writes',
   'Return buffer pool data writes for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7060, 'buffer pool index logical reads for apps. ',
   '&scriptdir/ap_locks &home &database index logical reads ',
   'Return buffer pool index logical reads for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7061, 'buffer pool index physical reads for apps.',
   '&scriptdir/ap_locks &home &database index physical reads ',
   'Return buffer pool index physical reads for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7062, 'buffer pool index writes for apps. ',
   '&scriptdir/ap_locks &home &database pool index writes ',
   'Return buffer pool index writes for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7063, 'total buffer pool read time (ms) for apps. ',
   '&scriptdir/ap_locks &home &database buffer pool read ',
   'Return total buffer pool read time (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7064, 'total buffer pool write time (ms) for apps. ',
   '&scriptdir/ap_locks &home &database buffer pool write ',
   'Return total buffer pool write time (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7065, 'direct reads for apps.',
   '&scriptdir/ap_locks &home &database Direct reads',
   'Return direct reads for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7066, 'direct writes for apps.',
   '&scriptdir/ap_locks &home &database Direct writes',
   'Return direct writes for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7067, 'direct read requests for apps.',
   '&scriptdir/ap_locks &home &database Direct read requests',
   'Return direct read requests for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7068, 'direct write requests for apps.',
   '&scriptdir/ap_locks &home &database Direct write requests',
   'Return direct write requests for applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7069, 'direct reads elapsed time (ms) for apps. ',
   '&scriptdir/ap_locks &home &database reads elapsed time',
   'Return direct reads elapsed time (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7070, 'direct write elapsed time (ms) for apps.',
   '&scriptdir/ap_locks &home &database write elapsed time',
   'Return direct write elapsed time (ms) for applications ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7071, 'sort heap allocated in instance',
   '&scriptdir/dbm_snap &home  Sort heap allocated',
   'Return sort heap allocated in the instance ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7072, 'post threshold sorts ',
   '&scriptdir/dbm_snap &home  Post threshold sorts',
   'Return post threshold sorts for the instance ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7073, 'piped sorts requested ',
   '&scriptdir/dbm_snap &home  Piped sorts requested',
   'Return piped sorts requested for the database manager ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7074, 'piped sorts accepted ',
   '&scriptdir/dbm_snap &home  Piped sorts accepted',
   'Return piped sorts accepted for the database manager ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7075, 'remote connections to db manager ',
   '&scriptdir/dbm_snap &home  connections to db manager',
   'Return remote connections to database manager ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7076, 'remote connections executing in db manager ',
   '&scriptdir/dbm_snap &home  connections executing in db',
   'Return remote connections executing in database manager ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7077, 'local connections ',
   '&scriptdir/dbm_snap &home  Local connections',
   'Return local connections ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7078, 'local connections executing in db manager ',
   '&scriptdir/dbm_snap &home  Local connections executing in',
   'Return local connections executing in db manager ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7079, 'active local databases ',
   '&scriptdir/dbm_snap &home  Active local databases',
   'Return active local databases ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7080, 'high water mark for agents registered',
   '&scriptdir/dbm_snap &home  mark for agents registered',
   'Return high water mark for agents registered ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7081, 'high water mark for agents waiting for a token ',
   '&scriptdir/dbm_snap &home  mark for agents waiting',
   'Return high water mark for agents waiting for a token ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7082, 'agents registered',
   '&scriptdir/dbm_snap &home  Agents registered',
   'Return number of agents registered ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7083, 'agents waiting for a token',
   '&scriptdir/dbm_snap &home  Agents waiting for a token',
   'Return number of agents waiting for a token ',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7084, 'committed private memory (bytes)',
   '&scriptdir/dbm_snap &home  Committed private memory',
   'Return committed private memory in bytes in the instance',
   'instance',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7090, 'time database waited on locks(ms)',
   '&scriptdir/db_snap &home &database Time database waited',
   'Return amount of time database waited on locks(ms)',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7091, 'exclusive lock escalations in database',
   '&scriptdir/db_snap &home &database Exclusive lock escalations',
   'Return number of times of exclusive lock escalations in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7092, 'lock escalations in database ',
   '&scriptdir/db_snap &home &database Lock escalations',
   'Return number of times of lock escalations in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7093, 'lock timeouts ',
   '&scriptdir/db_snap &home &database Lock Timeouts ',
   'Return number of lock timeouts in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7094, 'deadlocks detected in database ',
   '&scriptdir/db_snap &home &database Deadlocks detected',
   'Return number of times deadlocks detected for database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7095, 'lock waits ',
   '&scriptdir/db_snap &home &database Lock waits ',
   'Return number of lock waits in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7096, 'locks held currently ',
   '&scriptdir/db_snap &home &database Locks held currently',
   'Return number of locks held currently in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7097, 'current applications waiting on locks',
   '&scriptdir/db_snap &home &database Current applications waiting',
   'Return current applications waiting on locks in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7098, 'lock list memory in use (bytes)',
   '&scriptdir/db_snap &home &database Lock list memory',
   'Return lock list memory in use in bytes in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7099, 'total sorts in database',
   '&scriptdir/db_snap &home &database Total sorts',
   'Return total sorts in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7100, 'total sort time (ms) for database ',
   '&scriptdir/db_snap &home &database Total sort time',
   'Return total sort time (ms) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7101, 'sort overflows',
   '&scriptdir/db_snap &home &database Sort overflows',
   'Return sort overflows in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7102, 'active sorts ',
   '&scriptdir/db_snap &home &database Active sorts',
   'Return active sorts in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7103, 'total sort heap allocated ',
   '&scriptdir/db_snap &home &database Total sort heap ',
   'Return total sort heap allocated in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7104, 'rows deleted in database ',
   '&scriptdir/db_snap &home &database Rows deleted',
   'Return number of rows deleted in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7105, 'rows inserted in database',
   '&scriptdir/db_snap &home &database Rows inserted',
   'Return number of rows inserted in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7106, 'rows updated in database ',
   '&scriptdir/db_snap &home &database Rows updated',
   'Return number of rows updated in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7107, 'rows selected in database ',
   '&scriptdir/db_snap &home &database Rows selected',
   'Return number of rows selected in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7108, 'failed statement operations in database',
   '&scriptdir/db_snap &home &database Failed statement operations',
   'Return number of failed statement operations in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7109, 'internal rollbacks due to deadlock in database',
   '&scriptdir/db_snap &home &database Internal rollbacks due',
   'Return number of internal rollbacks due to deadlock',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7110, 'update/insert/delete statements executed in db',
   '&scriptdir/db_snap &home &database Update/Insert/Delete',
   'Return number of update/insert/delete statements executed in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7111, 'internal automatic rebinds in database',
   '&scriptdir/db_snap &home &database Internal automatic rebinds ',
   'Return internal automatic rebinds in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>=', '1', 'y' );

insert into DBA_PRED_CHECKS values (
   7112, 'internal rows deleted in database ',
   '&scriptdir/db_snap &home &database Internal rows deleted',
   'Return internal rows deleted in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7113, 'internal rows inserted in database ',
   '&scriptdir/db_snap &home &database Internal rows inserted',
   'Return internal rows inserted for database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7114, 'internal rows updated in database ',
   '&scriptdir/db_snap &home &database Internal rows updated',
   'Return internal rows updated in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7116, 'internal commits for database',
   '&scriptdir/db_snap &home &database Internal commits',
   'Return internal commits in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7117, 'internal rollbacks in database',
   '&scriptdir/db_snap &home &database Internal rollbacks',
   'Return internal rollbacks in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7118, 'high water mark for connections',
   '&scriptdir/db_snap &home &database mark for connections ',
   'Return high water mark for connections in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7119, 'high water mark for database heap',
   '&scriptdir/db_snap &home &database mark for database heap ',
   'Return high water mark for database heap',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7120, 'application connects ',
   '&scriptdir/db_snap &home &database Application connects',
   'Return application connects in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7121, 'applications connected currently in database',
   '&scriptdir/db_snap &home &database Applications connected currently',
   'Return applications connected currently in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7122, 'appls. executing in db manager currently',
   '&scriptdir/db_snap &home &database Appls. executing ',
   'Return appls. executing in database manager currently',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7123, 'maximum secondary log space used (bytes)',
   '&scriptdir/db_snap &home &database Maximum secondary log',
   'Return maximum secondary log space used (bytes) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7124, 'maximum total log space used (bytes)',
   '&scriptdir/db_snap &home &database Maximum total log',
   'Return maximum total log space used (bytes) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7125, 'secondary logs allocated currently',
   '&scriptdir/db_snap &home &database Secondary logs allocated',
   'Return secondary logs allocated currently in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7126, 'log pages read',
   '&scriptdir/db_snap &home &database Log pages read',
   'Return log pages read in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7127, 'log pages written',
   '&scriptdir/db_snap &home &database Log pages written',
   'Return log pages written in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7128, 'package cache lookups in database',
   '&scriptdir/db_snap &home &database Package cache lookups',
   'Return number of package cache lookups in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7129, 'package cache inserts in database',
   '&scriptdir/db_snap &home &database Package cache inserts',
   'Return package cache inserts in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7130, 'catalog cache overflows in database',
   '&scriptdir/db_snap &home &database Catalog cache overflows',
   'Return catalog cache overflows in database ',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7131, 'catalog cache heap full in database',
   '&scriptdir/db_snap &home &database Catalog cache heap full',
   'Return number of times catalog cache heap full ',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7132, 'catalog cache lookups ',
   '&scriptdir/db_snap &home &database Catalog cache lookups ',
   'Return number of catalog cache lookups in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7133, 'catalog cache inserts in database ',
   '&scriptdir/db_snap &home &database Catalog cache inserts ',
   'Return number of catalog cache inserts ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7134, 'buffer pool data logical reads in database',
   '&scriptdir/db_snap &home &database data logical reads ',
   'Return buffer pool data logical reads',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7135, 'buffer pool data physical reads in database',
   '&scriptdir/db_snap &home &database data physical reads ',
   'Return buffer pool data physical reads',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7136, 'buffer pool data writes in database ',
   '&scriptdir/db_snap &home &database pool data writes',
   'Return buffer pool data writes in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7137, 'buffer pool index logical reads in database',
   '&scriptdir/db_snap &home &database index logical reads ',
   'Return buffer pool index logical reads in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7138, 'buffer pool index physical reads in database ',
   '&scriptdir/db_snap &home &database index physical reads ',
   'Return buffer pool index physical reads in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7139, 'buffer pool index writes in database ',
   '&scriptdir/db_snap &home &database pool index writes ',
   'Return buffer pool index writes in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7140, 'total buffer pool read time (ms) in database ',
   '&scriptdir/db_snap &home &database buffer pool read ',
   'Return total buffer pool read time (ms) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7141, 'total buffer pool write time (ms) in database ',
   '&scriptdir/db_snap &home &database buffer pool write ',
   'Return total buffer pool write time (ms) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7142, 'asynchronous pool data page reads',
   '&scriptdir/db_snap &home &database pool data page reads',
   'Return asynchronous pool data page reads in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7143, 'asynchronous pool data page writes',
   '&scriptdir/db_snap &home &database pool data page writes',
   'Return asynchronous pool data page writes in database',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7144, 'asynchronous pool index page writes',
   '&scriptdir/db_snap &home &database pool index page writes',
   'Return asynchronous pool index page writes',
   'database',
   'db2_2',
   null, 'os',
   1, '>', '0', 'y' );

insert into DBA_PRED_CHECKS values (
   7145, 'total elapsed asynchronous read time',
   '&scriptdir/db_snap &home &database elapsed asynchronous read time',
   'Return total elapsed asynchronous read time',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7146, 'total elapsed asynchronous write time',
   '&scriptdir/db_snap &home &database elapsed asynchronous write ',
   'Return total elapsed asynchronous write time',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7147, 'asynchronous read requests',
   '&scriptdir/db_snap &home &database Asynchronous read requests',
   'Return number of asynchronous read requests in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7148, 'LSN Gap cleaner triggers',
   '&scriptdir/db_snap &home &database LSN Gap cleaner triggers',
   'Return number of LSN Gap cleaner triggers in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7149, 'dirty page steal cleaner triggers',
   '&scriptdir/db_snap &home &database steal cleaner triggers',
   'Return number of dirty page steal cleaner triggers',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7150, 'dirty page threshold cleaner triggers',
   '&scriptdir/db_snap &home &database threshold cleaner triggers',
   'Return number of threshold cleaner triggers in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7151, 'direct reads in database',
   '&scriptdir/db_snap &home &database Direct reads',
   'Return number of direct reads in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7152, 'direct writes in database',
   '&scriptdir/db_snap &home &database Direct writes',
   'Return number of direct writes in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7153, 'direct read requests in database',
   '&scriptdir/db_snap &home &database Direct read requests',
   'Return direct read requests in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7154, 'direct write requests in database',
   '&scriptdir/db_snap &home &database Direct write requests',
   'Return direct write requests in database',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7155, 'direct reads elapsed time (ms) in database ',
   '&scriptdir/db_snap &home &database reads elapsed time',
   'Return direct reads elapsed time (ms) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7156, 'direct write elapsed time (ms) in database',
   '&scriptdir/db_snap &home &database write elapsed time',
   'Return direct write elapsed time (ms) in database ',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7157, 'database files closed',
   '&scriptdir/db_snap &home &database Database files closed',
   'Return number of database files closed',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   7158, 'max applications config parameter',
   '&scriptdir/db_config &home &database MAXAPPLS',
   'Return the configured value for the max applications',
   'database',
   'db2_2',
   null, 'os',
   1, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   7159, 'backup pending indicator',
   '&scriptdir/db_config &home &database Backup pending',
   'Return the current backup pending indicator for the database',
   'database',
   'db2_2',
   null, 'os',
   2, '=', '"YES"', 'y' );

insert into DBA_PRED_CHECKS values (
   7160, 'roll forward pending indicator',
   '&scriptdir/db_config &home &database Rollforward pending',
   'Return the current Rollforward pending indicator for the database',
   'database',
   'db2_2',
   null, 'os',
   2, null, null, 'y' );

insert into DBA_PRED_CHECKS values (
   8001, '# indexes in a database',
   'select count(*) from sysibm.sysindexes where
   creator <>''SYSIBM'' and tbcreator <>''WINDMILL''',
   'Return number of user created indexes
   in the database excluding those created by SYSIBM
   and DATAHUB',
   'database',
   'db6000',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8010, '# tables owned by a user in a database',
   'select count(distinct name) from sysibm.systables where name=
     &name',
   'Return number of tables owned by a user in a database',
   'user',
   'db6000',
   null, 'sql',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8011, 'idle DB2 agents for an instance',
   '&scriptdir/dbm_snap &home  Idle agents',
   'Return number of idle agents for an instance',
   'instance ',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8012, 'applications currently waiting on locks',
   '&scriptdir/db_locks &home &database waiting on locks',
   'Return number of applications currently waiting on locks in a database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8014, '# locks held in a database',
   '&scriptdir/db_locks &home &database Locks held',
   'Return number of locks held in a database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8015, 'time application waited on locks(ms)',
   '&scriptdir/ap_locks &home &database Time application waited',
   'Return amount of time application waited on locks(ms)',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8016, 'exclusive lock escalations for application ',
   '&scriptdir/ap_locks &home &database Exclusive lock escalations',
   'Return number of times of exclusive lock escalations for application',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8017, 'lock escalations for application ',
   '&scriptdir/ap_locks &home &database Lock escalations',
   'Return number of times of lock escalations for application',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8018, 'statement sorts ',
   '&scriptdir/ap_locks &home &database Statement sorts ',
   'Return statement sorts for application ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8019, 'deadlocks detected for apps. ',
   '&scriptdir/ap_locks &home &database Deadlocks detected',
   'Return number of times deadlocks detected for application',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8020, 'lock waits since connect',
   '&scriptdir/ap_locks &home &database Lock waits since',
   'Return lock waits since application connect',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8021, 'locks held by application',
   '&scriptdir/ap_locks &home &database Locks held by',
   'Return number of locks held by application ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8022, 'total time UOW waited on locks (ms)',
   '&scriptdir/ap_locks &home &database Total time UOW',
   'Return total time UOW waited on locks (ms) for application ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8023, 'total sorts for application',
   '&scriptdir/ap_locks &home &database Total sorts',
   'Return total sorts for application (ms) ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8024, 'total sort time (ms) ',
   '&scriptdir/ap_locks &home &database Total sort time',
   'Return total sort time (ms) for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8025, 'total sort overflows',
   '&scriptdir/ap_locks &home &database Total sort overflows',
   'Return total sort overflows',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8026, 'rows deleted for apps. ',
   '&scriptdir/ap_locks &home &database Rows deleted',
   'Return number of rows deleted for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8027, 'rows inserted for apps. ',
   '&scriptdir/ap_locks &home &database Rows inserted',
   'Return number of rows inserted for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8028, 'rows updated for apps. ',
   '&scriptdir/ap_locks &home &database Rows updated',
   'Return number of rows updated for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8029, 'rows selected for apps. ',
   '&scriptdir/ap_locks &home &database Rows selected',
   'Return number of rows selected',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8030, 'rejected block remote cursor requests ',
   '&scriptdir/ap_locks &home &database Rejected Block Remote ',
   'Return rejected block remote cursor requests',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8031, 'accepted block remote cursor requests ',
   '&scriptdir/ap_locks &home &database Accepted Block',
   'Return accepted block remote cursor requests for application',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8032, 'commit statements ',
   '&scriptdir/ap_locks &home &database Commit statements',
   'Return number of commit statements ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8033, 'rollback statements ',
   '&scriptdir/ap_locks &home &database Rollback statements',
   'Return number of rollback statements ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8034, 'failed statement operations for apps.',
   '&scriptdir/ap_locks &home &database Failed statement operations',
   'Return number of failed statement operations ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8035, 'internal rollbacks due to deadlock for apps.',
   '&scriptdir/ap_locks &home &database Internal rollbacks due',
   'Return number of internal rollbacks due to deadlock for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8036, 'update/insert/delete statements executed for apps.',
   '&scriptdir/ap_locks &home &database Update/Insert/Delete',
   'Return number of update/insert/delete statements executed for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8037, 'internal automatic rebinds for apps.',
   '&scriptdir/ap_locks &home &database Internal automatic rebinds ',
   'Return internal automatic rebinds for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8038, 'internal rows deleted for apps. ',
   '&scriptdir/ap_locks &home &database Internal rows deleted',
   'Return internal rows deleted for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8040, 'internal rows updated for apps. ',
   '&scriptdir/ap_locks &home &database Internal rows updated',
   'Return internal rows updated for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8042, 'internal commits for applications',
   '&scriptdir/ap_locks &home &database Internal commits',
   'Return internal commits for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8043, 'internal rollbacks for applications',
   '&scriptdir/ap_locks &home &database Internal rollbacks',
   'Return internal rollbacks for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8044, 'UOW log space used (bytes)',
   '&scriptdir/ap_locks &home &database UOW log space',
   'UOW log space used (in bytes) for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8045, 'open remote cursors ',
   '&scriptdir/ap_locks &home &database Open remote cursors',
   'Return open local cursors for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8046, 'open remote cursors with blocking ',
   '&scriptdir/ap_locks &home &database cursors with blocking',
   'Return open local cursors with blocking for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8047, 'current communication heap size (bytes)',
   '&scriptdir/ap_locks &home &database Current communication',
   'Return current communication heap size (bytes) for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8048, 'maximum communication heap size (Bytes)',
   '&scriptdir/ap_locks &home &database Maximum communication heap',
   'Return maximum communication heap size (bytes) for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8057, 'buffer pool data logical reads for apps. ',
   '&scriptdir/ap_locks &home &database data logical reads ',
   'Return buffer pool data logical reads for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8058, 'buffer pool data physical reads for apps. ',
   '&scriptdir/ap_locks &home &database data physical reads ',
   'Return buffer pool data physical reads',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8059, 'buffer pool data writes for apps. ',
   '&scriptdir/ap_locks &home &database pool data writes',
   'Return buffer pool data writes for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8060, 'buffer pool index logical reads for apps.',
   '&scriptdir/ap_locks &home &database index logical reads ',
   'Return buffer pool index logical reads for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8061, 'buffer pool index physical reads for apps.',
   '&scriptdir/ap_locks &home &database index physical reads ',
   'Return buffer pool index physical reads for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8062, 'buffer pool index writes for apps.',
   '&scriptdir/ap_locks &home &database pool index writes ',
   'Return buffer pool index writes for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8063, 'total buffer pool physical read time (MS) ',
   '&scriptdir/ap_locks &home &database buffer pool physical read ',
   'Return total buffer pool read time (ms) for applications',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8064, 'total buffer pool physical write time (MS) ',
   '&scriptdir/ap_locks &home &database buffer pool physical write ',
   'Return total buffer pool write time (ms) for applications ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8071, 'sort heap allocated in instance',
   '&scriptdir/dbm_snap &home  Sort heap allocated',
   'Return sort heap allocated in the instance ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8072, 'post threshold sorts ',
   '&scriptdir/dbm_snap &home  Post threshold sorts',
   'Return post threshold sorts for instance ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8073, 'piped sorts requested ',
   '&scriptdir/dbm_snap &home  Piped sorts requested',
   'Return piped sorts requested ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8074, 'piped sorts accepted ',
   '&scriptdir/dbm_snap &home  Piped sorts accepted',
   'Return piped sorts accepted ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8075, 'remote connections to db manager ',
   '&scriptdir/dbm_snap &home  connections to db manager',
   'Return remote connections to database manager ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8076, 'remote connections executing in db manager ',
   '&scriptdir/dbm_snap &home  connections executing in db',
   'Return remote connections executing in database manager ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8077, 'local connections ',
   '&scriptdir/dbm_snap &home  Local connections',
   'Return local connections ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8078, 'local connections executing in db manager ',
   '&scriptdir/dbm_snap &home  Local connections executing in',
   'Return local connections executing in db manager ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8079, 'active local databases ',
   '&scriptdir/dbm_snap &home  Active local databases',
   'Return active local databases ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8082, 'agents registered',
   '&scriptdir/dbm_snap &home  Agents registered',
   'Return agents registered ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8083, 'agents waiting for a token',
   '&scriptdir/dbm_snap &home  Agents waiting for a token',
   'Return agents waiting for a token ',
   'instance',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8090, 'time database waited on locks(ms)',
   '&scriptdir/db_snap &home &database Time database waited',
   'Return amount of time database waited on locks(ms)',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8091, 'exclusive lock escalations for database',
   '&scriptdir/db_snap &home &database Exclusive lock escalations',
   'Return number of times of exclusive lock escalations',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8092, 'lock escalations for database ',
   '&scriptdir/db_snap &home &database Lock escalations',
   'Return number of times of lock escalations for database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8094, 'deadlocks detected in database ',
   '&scriptdir/db_snap &home &database Deadlocks detected',
   'Return number of times deadlocks detected for database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8095, 'lock waits ',
   '&scriptdir/db_snap &home &database Lock waits ',
   'Return lock waits for database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8096, 'locks held currently ',
   '&scriptdir/db_snap &home &database Locks held currently',
   'Return number of locks held currently in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8097, 'current applications waiting on locks',
   '&scriptdir/db_snap &home &database Current applications waiting',
   'Return current applications waiting on locks in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8098, 'lock list memory in use (bytes)',
   '&scriptdir/db_snap &home &database Lock list memory',
   'Return lock list memory in use (bytes)',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8099, 'total sorts in database',
   '&scriptdir/db_snap &home &database Total sorts',
   'Return total sorts in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8101, 'sort overflows',
   '&scriptdir/db_snap &home &database Sort overflows',
   'Return sort overflows',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8102, 'active sorts ',
   '&scriptdir/db_snap &home &database Active sorts',
   'Return active sorts in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8103, 'total sort heap allocated ',
   '&scriptdir/db_snap &home &database Total sort heap ',
   'Return total sort heap allocated',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8104, 'rows deleted in database ',
   '&scriptdir/db_snap &home &database Rows deleted',
   'Return number of rows deleted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8105, 'rows inserted in database ',
   '&scriptdir/db_snap &home &database Rows inserted',
   'Return number of rows inserted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8106, 'rows updated in database ',
   '&scriptdir/db_snap &home &database Rows updated',
   'Return number of rows updated in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8107, 'rows selected in database ',
   '&scriptdir/db_snap &home &database Rows selected',
   'Return number of rows selected in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8108, 'failed statement operations in database',
   '&scriptdir/db_snap &home &database Failed statement operations',
   'Return number of failed statement operations in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8109, 'internal rollbacks due to deadlock in database',
   '&scriptdir/db_snap &home &database Internal rollbacks due',
   'Return number of internal rollbacks due to deadlock in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8110, 'update/insert/delete statements executed in db',
   '&scriptdir/db_snap &home &database Update/Insert/Delete',
   'Return number of update/insert/delete statements executed in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8111, 'internal automatic rebinds in database',
   '&scriptdir/db_snap &home &database Internal automatic rebinds ',
   'Return internal automatic rebinds in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8112, 'internal rows deleted in database',
   '&scriptdir/db_snap &home &database Internal rows deleted',
   'Return internal rows deleted in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8113, 'DDL statements executed ',
   '&scriptdir/db_snap &home &database DDL statements ',
   'Return DDL statements executed in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8114, 'internal rows updated in database',
   '&scriptdir/db_snap &home &database Internal rows updated',
   'Return internal rows updated in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8115, 'binds/precompiles attempted ',
   '&scriptdir/db_snap &home &database Binds/precompiles attempted ',
   'Return binds/precompiles attempted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8116, 'internal commits in database',
   '&scriptdir/db_snap &home &database Internal commits',
   'Return internal commits in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8117, 'internal rollbacks in database',
   '&scriptdir/db_snap &home &database Internal rollbacks',
   'Return internal rollbacks in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8118, 'commit statements attempted ',
   '&scriptdir/db_snap &home &database Commit statements attempted ',
   'Return commit statements attempted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8119, 'rollback statements attempted ',
   '&scriptdir/db_snap &home &database Rollback statements attempted ',
   'Return rollback statements attempted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8120, 'application connects ',
   '&scriptdir/db_snap &home &database Application connects',
   'Return application connects in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8121, 'applications connected currently in database',
   '&scriptdir/db_snap &home &database Applications connected currently',
   'Return applications connected currently',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8122, 'appls. executing in db manager currently',
   '&scriptdir/db_snap &home &database Appls. executing ',
   'Return appls. executing in database manager currently',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8123, 'maximum secondary log space used (bytes)',
   '&scriptdir/db_snap &home &database Maximum secondary log ',
   'Return maximum secondary log space used (bytes) ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8124, 'maximum total log space used (bytes)',
   '&scriptdir/db_snap &home &database Maximum total log',
   'Return maximum total log space used (bytes) in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8125, 'secondary logs allocated currently',
   '&scriptdir/db_snap &home &database Secondary logs allocated',
   'Return secondary logs allocated currently ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8126, 'dynamic statements attempted ',
   '&scriptdir/db_snap &home &database Dynamic statements attempted ',
   'Return dynamic statements attempted in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8127, 'static statements attempted ',
   '&scriptdir/db_snap &home &database Static statements attempted ',
   'Return static statements attempted in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8128, 'select SQL statements executed ',
   '&scriptdir/db_snap &home &database Select SQL statements ',
   'Return select SQL statements executed in database ',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8134, 'buffer pool data logical reads in database',
   '&scriptdir/db_snap &home &database data logical reads ',
   'Return buffer pool data logical reads in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8135, 'buffer pool data physical reads in database ',
   '&scriptdir/db_snap &home &database data physical reads ',
   'Return buffer pool data physical reads in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8136, 'buffer pool data writes in database ',
   '&scriptdir/db_snap &home &database pool data writes',
   'Return buffer pool data writes in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8137, 'buffer pool index logical reads in database',
   '&scriptdir/db_snap &home &database index logical reads ',
   'Return buffer pool index logical reads in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8138, 'buffer pool index physical reads in database',
   '&scriptdir/db_snap &home &database index physical reads ',
   'Return buffer pool index physical reads in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8139, 'buffer pool index writes in database',
   '&scriptdir/db_snap &home &database pool index writes ',
   'Return buffer pool index writes in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_CHECKS values (
   8157, 'database files closed',
   '&scriptdir/db_snap &home &database Database files closed',
   'Return database files closed in database',
   'database',
   'db6000',
   null, 'os',
   1, null, null, null );

insert into DBA_PRED_TIMES values (
   1111, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   1112, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   1113, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   1121, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   1122, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   1131, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   1132, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   1133, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   1221, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   1331, 1, 0, 0, 1800, 1, 0 );

insert into DBA_PRED_TIMES values (
   1332, 1, 0, 0, 1800, 1, 0 );

insert into DBA_PRED_TIMES values (
   1333, 1, 0, 0, 1800, 1, 0 );

insert into DBA_PRED_TIMES values (
   1371, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   1372, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   1373, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   1813, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   1823, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   1833, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   2000, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   2024, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   2034, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   2054, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   2060, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   2061, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   2062, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   2070, 1, 0, 0, 1800, 1, 0 );

insert into DBA_PRED_TIMES values (
   2071, 1, 0, 0, 1800, 1, 0 );

insert into DBA_PRED_TIMES values (
   2080, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   4001, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   4102, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   4104, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   4105, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   4200, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   4300, 1, 0, 0, 500, 1, 0 );

insert into DBA_PRED_TIMES values (
   4310, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   4311, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   4330, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5012, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   5020, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   5028, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5029, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5030, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5031, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5118, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   5152, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5153, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5158, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5159, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5160, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5162, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5163, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5164, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5165, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5176, 1, 0, 0, 600, 1, 0 );

insert into DBA_PRED_TIMES values (
   5178, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5195, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5207, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5233, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5234, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5235, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   5238, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   5239, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5240, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5241, 1, 0, 0, 600, 1, 0 );

insert into DBA_PRED_TIMES values (
   5242, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   5244, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   6703, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6705, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6728, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6729, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6730, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6731, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6732, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6733, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6734, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   6735, 1, 0, 0, 14400, 1, 0 );

insert into DBA_PRED_TIMES values (
   7003, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   7092, 1, 0, 0, 600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7094, 1, 0, 0, 300, 1, 0 );

insert into DBA_PRED_TIMES values (
   7098, 1, 0, 0, 600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7111, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7118, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   7121, 1, 0, 0, 60, 1, 0 );

insert into DBA_PRED_TIMES values (
   7130, 1, 0, 0, 600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7131, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7136, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   7139, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   7143, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   7144, 1, 0, 0, 900, 1, 0 );

insert into DBA_PRED_TIMES values (
   7158, 1, 0, 0, 86400, 1, 0 );

insert into DBA_PRED_TIMES values (
   7159, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_TIMES values (
   7160, 1, 0, 0, 3600, 1, 0 );

insert into DBA_PRED_RULE values (
   1001, 'aix', 'val(1111) >= 1 and val(1111) > val(1111, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1002, 'hpux', 'val(1112) >= 1 and val(1112) > val(1112, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1003, 'solaris', 'val(1113) >= 1 and val(1113) > val(1113, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1011, 'aix', 'val(1121) >= 1 and val(1121) > val(1121, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1012, 'hpux', 'val(1122) >= 1 and val(1122) > val(1122, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1021, 'aix', 'val(1131) < 10000 and val(1131) < val(1131, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1022, 'hpux', 'val(1132) < 10000 and val(1132) < val(1132, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1023, 'solaris', 'val(1133) < 10000 and val(1133) < val(1133, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1031, 'aix', 'val(1221) >= 35 and val(1221) > val(1221, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1041, 'aix', 'val(1331) >= 2.0 and val(1331) > val(1331, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1042, 'hpux', 'val(1332) >= 2.0 and val(1332) > val(1332, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1043, 'solaris', 'val(1333) >= 2.0 and val(1333) > val(1333, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1051, 'aix', 'val(1371) >= 10.0 and val(1371) > val(1371, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1052, 'hpux', 'val(1372) >= 10.0 and val(1372) > val(1372, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1053, 'solaris', 'val(1373) >= 10 and val(1373) > val(1373, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1064, 'solaris', 'val(1813) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1065, 'solaris', 'val(1823) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1066, 'solaris', 'val(1833) >= 1000 and val(1833) < 4000 and val(1833) < val(1833, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1067, 'solaris', 'val(1833) < 1000 and val(1833) < val(1833, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1070, 'db2_2', 'val(2060) < 1 and val(2060, -1) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1071, 'db2_2', 'val(2061) < 20 and val(2061) < val(2061, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1072, 'db2_2', 'val(2062) < 20 and val(2062) < val(2062, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1073, 'db2_2', 'val(2070) > val(2070,-1)*1.2',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1074, 'db2_2', 'val(2071) > 20 and val(2071) > val(2071, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1075, 'db2_2', 'new(7098) and new(7092) # val(7098)/(val(2080)*4096) > 0.80 and val(7092)>val(7092,-1) and val(7098) > val(7098, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1080, 'syb', 'new(6703) and new(6705) #
     val(6703) > 0.90 * val(6705)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1083, 'syb', 'new(6728) and new(6729) #
     (val(6728)/val(6729)) < 0.20',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1084, 'syb', 'val(6730) > val(6730,-1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1085, 'syb', 'val(6731) > val(6731,-1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1086, 'syb', 'new(6732) and new(6733) #
     val(6732)/val(6733) < 0.10',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   1087, 'syb', 'new(6734) and new(6735) #
     val(6734)/val(6735) > 0.90',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2012, 'db2_2', 'val(7003) > 0 and val(7003) > val(7003, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2024, 'ora7', 'val(2034) > 0',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2030, 'db2_2', 'val(7094) - val(7094,-2) > 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2031, 'db2_2', 'val(7111) >= 1 and val(7111) > val(7111, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2032, 'db2_2', 'val(7130) > (val(7130)+val(7130,-1)+val(7130,-2)+val(7130,-3)+val(7130,-4) )/5',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2033, 'db2_2', 'val(7131) > 0 and val(7131) > val(7131, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2034, 'db2_2', 'new(7136) and new(7143) and new(7139) and new(7144) and new(7121) # val(7136) - val(7143) < 2 and val(7139) - val(7144) < 2 and val(7158) - val(7121) <=2',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2035, 'db2_2', 'new(7136) and new(7143) # val(7136) > val(7143)*1.25 and (val(7136) > val(7136, -1) or val(7143) > val(7143, -1))',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2036, 'db2_2', 'new(7139) and new(7144) # val(7139) > val(7144)*1.25 and (val(7139) > val(7139, -1) or val(7144) > val(7144, -1))',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2037, 'db2_2', 'val(7121)=val(7158) and val(7121,-1)=val(7158) and val(7121,-2)=val(7158) and val(7121,-3)=val(7158) and val(7121,-4)=val(7158)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2038, 'db2_2', 'val(7118)=val(7158) and val(7118) <> val(7118, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2039, 'db2_2', 'val(7158)-val(7118)<=2 and val(7118) <> val(7118, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2040, 'db2_2', 'val(7159)="YES"',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2041, 'db2_2', 'val(7160)="DATABASE"',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2042, 'db2_2', 'val(7160)="TABLESPACES"',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4001, 'ing64', 'val(4001) > 5',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4102, 'ing64', 'val(4102) > 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4104, 'ing64', 'val(4104) > 80',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4105, 'ing64', 'val(4105) > 80',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4200, 'ing64', 'val(4200) > 80',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4300, 'ing64', 'val(4300) > 10000',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4310, 'ing64', 'val(4310) <> ""',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4311, 'ing64', 'val(4311) <> ""',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   4330, 'ing64', 'val(4330) <> ""',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2100, 'ora7', 'val(2000) < 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2101, 'ora7', 'val(5152) >= 0.95*val(5153) and val(5152, -1) >= 0.95*val(5153) and val(5152, -2) >= 0.95*val(5153) and val(5152, -3) >= 0.95*val(5153) and val(5152, -4) >= 0.95*val(5153) and val(5152) > val(5152, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2102, 'ora7', 'val(5159) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2103, 'ora7', 'val(5160) >= 1 and val(5160) > val(5160,-1) and val(5160) > val(5160,-2) and val(5160) > (5160,-3) and val(5160) > val(5160,-4)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2104, 'ora7', 'val(5162) >= 0.95 * val(5163) and val(5162, -1) >= 0.95 * val(5163) and val(5162) > val(5162, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2105, 'ora7', 'val(5165) >= 0.95* val(5164) and val(5165) > val(5165, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2106, 'ora7', 'val(5176) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2107, 'ora7', 'val(5178) >= 1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2108, 'ora7', 'val(5195) < 0.95 and val(5195, -1) < 0.95 and val(5195, -2) < 0.95 and val(5195, -3) < 0.95 and val(5195, -4) < 0.95 and val(5195) > val(5195, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2109, 'ora7', 'new(5207) and new(5028) and new(5029) # val(5207) >= (val(5028) + val(5029)) * 0.05 and val(5207) > val(5207,-1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2110, 'ora7', 'val(5233) > 0 and val(5234) >= 0.95*val(5233) and val(5234, -1) >= 0.95*val(5233) and val(5234, -2) >= 0.95*val(5233) and val(5234, -3) >= 0.95*val(5233) and val(5234, -4) >= 0.95*val(5233) and val(5234) > val(5234, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2111, 'ora7', 'val(5158) <= 0.05*val(5235) and val(5158, -1) <= 0.05*val(5235) and val(5158, -2) <= 0.05*val(5235) and val(5158, -3) <= 0.05*val(5235) and val(5158, -4) <= 0.05*val(5235) and val(5158) > val(5158, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2112, 'ora7', 'val(5238) < 0.80 and val(5238, -1) < 0.80 and val(5238, -2) < 0.80 and val(5238, -3) < 0.80 and val(5238, -4) < 0.80 and val(5238) > val(5238, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2113, 'ora7', 'val(5239) > val(5239, -1) * 1.1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2114, 'ora7', 'val(5240) > val(5240, -1) * 1.1',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2115, 'ora7', 'val(5241) >= 1000 and val(5241) > val(5241, -1) * 1.05',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2116, 'ora7', 'val(5242) < 0.80 and val(5242) < val(5242, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2117, 'ora7', 'val(5244) > 0.95 and val(5244, -1) > 0.95 and val(5244, -2) > 0.95 and val(5244, -3) > 0.95 and val(5244, -4) > 0.95 and val(5244) > val(5244, -1)',
   'alert', 'none', null, null );

insert into DBA_PRED_RULE values (
   2118, 'ora7', 'val(5160) >= 1 and val(5160) > val(5160,-1)',
   'alert', 'none', null, null );

insert into DBA_PRED_ALERT values (
   1001, 'yellow', 'At least one filesystem is a minimum of 90% full',
   'Use DataHub''s File System action to view the filesystem space.  Consider activating checks to monitor critical filesystem space (free space and percent utilized).  You may want to increase the size of the filesystem or delete unnecessary files.' );

insert into DBA_PRED_ALERT values (
   1002, 'yellow', 'At least one filesystem is a minimum of 90% full.',
   'Use DataHub''s File System action to view the filesystem space.  Consider activating checks to monitor critical filesystem space (free space and percent utilized).  You may want to increase the size of the filesystem or delete unnecessary files.' );

insert into DBA_PRED_ALERT values (
   1003, 'yellow', 'Number of (local) filesystems which are more than 90% full is one or more',
   'Perform a ''df'' command and check filesystem space, may want to delete unnecessary files' );

insert into DBA_PRED_ALERT values (
   1011, 'yellow', 'At least one filesystem has more than 80% of inodes used',
   'Perform a ''df'' command and check filesystem inode space.  You may want to consider increasing the size of the filesystem or deleting some unnecessary files to increase the number of available inodes for the filesystem.' );

insert into DBA_PRED_ALERT values (
   1012, 'yellow', 'At least one filesystem has more than 80% of inodes used',
   'Perform a ''bdf'' command and check filesystem inode space.  You may want to consider increasing the size of the filesystem or deleting some unnecessary files to increase the number of available inodes for the filesystem.' );

insert into DBA_PRED_ALERT values (
   1021, 'yellow', 'Free space in /tmp is less than 10MB',
   'Continue to monitor, may want to increase /tmp space if this condition persists.' );

insert into DBA_PRED_ALERT values (
   1022, 'yellow', 'Free space in /tmp is less than 10 MB',
   'Continue to monitor, may want to increase /tmp space if this condition persists.' );

insert into DBA_PRED_ALERT values (
   1023, 'yellow', 'Free space in /tmp is less than 10 MB',
   'Continue to monitor, may want to increase /tmp space if condition persist' );

insert into DBA_PRED_ALERT values (
   1031, 'yellow', 'Percent used of all paging spaces is at 35% or greater',
   'Consider increasing the available paging space if this condition persists. The recommended starting size is a paging space four times greater than the size of the real memory. Each paging space should be defined with the size of the real memory.' );

insert into DBA_PRED_ALERT values (
   1041, 'yellow', 'Average system load over the past 15 minutes is high',
   'Continue to monitor, may want to consider moving workload to another machine.' );

insert into DBA_PRED_ALERT values (
   1042, 'yellow', 'Average system load over the last 15 minutes exceed 2.0',
   'Continue to monitor, may want to move workload to another machine' );

insert into DBA_PRED_ALERT values (
   1043, 'yellow', 'Average system load over the last 15 minutes exceed 2.0',
   'Continue to monitor, may want to move workload to another machine' );

insert into DBA_PRED_ALERT values (
   1051, 'yellow', 'Percent of CPU usage; iowait is high (greater than 10%)',
   'Continue to monitor.  Investigate degree of I/O dependency using the iostat command and determine if reorganization at some level would yield an improvement.' );

insert into DBA_PRED_ALERT values (
   1052, 'yellow', 'Percent of CPU usage: iowait is greater than 50%',
   'Continue to monitor.  Investigate degree of I/O dependency using the iostat command and determine if reorganization at some level would yield an improvement.' );

insert into DBA_PRED_ALERT values (
   1053, 'yellow', 'Percent of CPU usage: iowait is greater than 10%',
   'Continue to monitor' );

insert into DBA_PRED_ALERT values (
   1064, 'yellow', 'One or more disks are overloaded',
   'You may want to rebalance the load or stripe the disks with idle ones' );

insert into DBA_PRED_ALERT values (
   1065, 'yellow', 'Overloaded SCSI bus',
   'Continue to monitor' );

insert into DBA_PRED_ALERT values (
   1066, 'yellow', 'Low in swap space',
   'Continue to monitor' );

insert into DBA_PRED_ALERT values (
   1067, 'red', 'Effectively no swap space',
   'You may want to add more swap space' );

insert into DBA_PRED_ALERT values (
   1070, 'red', 'The DB2 instance supporting this database is not active',
   'From the instance owner userid for the database issue db2start.' );

insert into DBA_PRED_ALERT values (
   1071, 'yellow', 'Data buffer pool hit ratio is low',
   'Increasing the number of buffer pool pages may improve performance.  The size of the buffer pool is one of the most important parameters for tuning DB2.  See the DB2 Administration Guide for tuning considerations.' );

insert into DBA_PRED_ALERT values (
   1072, 'yellow', 'Index buffer pool hit ratio is low',
   'Increasing the number of buffer pool pages may improve performance.  The size of the buffer pool is one of the most important parameters for tuning DB2.  See the DB2 Administration Guide for tuning considerations.' );

insert into DBA_PRED_ALERT values (
   1073, 'yellow', 'average sort time increased more than 20% in the past 30 minutes.',
   'Consider increasing the sortheap size. Investigate the number of piped sorts which are rejected for the database.' );

insert into DBA_PRED_ALERT values (
   1074, 'yellow', 'Percent of sorts requiring at least one merge phase is high.',
   'Consider increasing the sortheap configuration parameter and the sort heap threshold (sheapthres).  Investigate the number of piped sorts which are rejected for the database.' );

insert into DBA_PRED_ALERT values (
   1075, 'yellow', 'Locklist utilization high and lock escalations are occurring.',
   'Consider increasing the locklist and maxlocks config parameters. Identify which applications are holding too much of the lock list.' );

insert into DBA_PRED_ALERT values (
   1080, 'yellow', 'Connections have exceeded the 90 percent of max allowed.',
   'The maximum number of connections that can be supported by SQL Server is too low.  Configuration parameter, user connections, may be modified to increase the value.' );

insert into DBA_PRED_ALERT values (
   1081, 'yellow', 'The device number usage have exceeded the 90 percent of maximum configured.',
   'Use sp_configure, review the value of the configuration parameter device object and increase this value if feasible.' );

insert into DBA_PRED_ALERT values (
   1082, 'red', 'The number of databases that can be opened exceeded the current configuration limit.',
   'Use sp_configure, review the value of the configuration parameter open database object and increase this value if feasible.' );

insert into DBA_PRED_ALERT values (
   1083, 'yellow', 'The database has only 20% of free space for expansion.',
   'Use sp_helpdb, review the database size to determine if changes are required.' );

insert into DBA_PRED_ALERT values (
   1084, 'red', 'Databases marked suspect or unusable by server were found.',
   'Use dbcc dbrepair to drop the suspect database if applicable.' );

insert into DBA_PRED_ALERT values (
   1085, 'yellow', 'The system has detected a long-running transaction. These transactions are often a result of application errors or badly formed queries but they can also result from operating system or SQL Server problems.',
   'If the transaction has been identified, use the kill command to stop the process.  If the kill command cannot stop the process, you must restart the SQL Server to resolve the problem.' );

insert into DBA_PRED_ALERT values (
   1086, 'yellow', 'Log usage has exceeded the 90 percent of total log space allocated.',
   'There is no hard and fast rule dictating how big the log space should be.  Use dbcc checktable("master..syslogs") to review the free and used log space usage and take appropriate action(s).' );

insert into DBA_PRED_ALERT values (
   1087, 'yellow', 'The default segment in your default database has exceeded the 90 percent of total space allocated.',
   'There is no hard and fast rule dictating how big the segment space should be.  Use sp_helpsegment "default" to review your segment usage and take appropriate action(s).' );

insert into DBA_PRED_ALERT values (
   2002, 'yellow', 'Applications are currently waiting on locks',
   'Continue to monitor, may want to investigate if wait persist' );

insert into DBA_PRED_ALERT values (
   2012, 'red', 'At least one trigger is invalid.',
   'To revalidate the trigger you must retrieve the definition of the trigger from the catalog and submit a new CREATE TRIGGER statement.' );

insert into DBA_PRED_ALERT values (
   2024, 'yellow', 'Transactions are waiting on locks',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   2030, 'yellow', 'More than 1 deadlocks have been detected in the past 15 minutes',
   'Consider increasing the locklist and maxlocks config parameters. Investigate the applications the deadlocks are occurring for and consider modifying them to enable concurrent execution.' );

insert into DBA_PRED_ALERT values (
   2031, 'yellow', 'At least one internal automatic rebind has occurred',
   'Minimize internal automatic rebinds where possible.  Rebinds occurs when DB2 needs to execute an SQL statement from a package that is dependent upon an object which has been changed (dropped, modified, authorizations changed).' );

insert into DBA_PRED_ALERT values (
   2032, 'yellow', 'Catalog cache overflows are occurring at a higher than average rate',
   'Consider increasing the size of the catalog cache or splitting packages so they include fewer SQL statements.' );

insert into DBA_PRED_ALERT values (
   2033, 'yellow', 'Catalog cache heap is full.',
   'This can be corrected by increasing the database heap size or reducing the catalog cache size.' );

insert into DBA_PRED_ALERT values (
   2034, 'yellow', 'Most buffer pool writes are occurring asynchronously and active connections are currently within two of max configured',
   'Consider decreasing the number of asynchronous page cleaners you have configured. See the DB2 Administration Guide (num_iocleaners) for tuning considerations.' );

insert into DBA_PRED_ALERT values (
   2035, 'yellow', 'Buffer pool writes are occurring synchronously',
   'The number of asynchronous page cleaners should be increased. See the DB2 Administration Guide (num_iocleaners) for tuning considerations.' );

insert into DBA_PRED_ALERT values (
   2036, 'yellow', 'Buffer pool writes are occurring synchronously',
   'The number of asynchronous page cleaners should be increased. See the DB2 Administration Guide (num_iocleaners) for tuning considerations.' );

insert into DBA_PRED_ALERT values (
   2037, 'red', 'Active connections at max configured for past 5 minutes.',
   'Consider increasing the maxappls configuration parameter. When active connections at maxappls it is likely that some database connection requests are rejected.' );

insert into DBA_PRED_ALERT values (
   2038, 'red', 'Concurrent connections have reached the max configured',
   'Consider increasing the maxappls configuration parameter. When active connections at maxappls it is likely that some database connection requests are rejected.' );

insert into DBA_PRED_ALERT values (
   2039, 'yellow', 'Concurrent connections approaching max configured',
   'Consider increasing the maxappls configuration parameter. When active connections at maxappls it is likely that some database connection requests are rejected.' );

insert into DBA_PRED_ALERT values (
   2040, 'red', 'Backup pending indicator is on for the database',
   'You must do a full backup of the database before this database can be accessed. This parameter is turned on after either logretain or userexit has been set and accepted.' );

insert into DBA_PRED_ALERT values (
   2041, 'red', 'Rollforward pending indicator (DATABASE) is on',
   'A Roll-forward recovery procedure is required for this database before the database can be accessed.' );

insert into DBA_PRED_ALERT values (
   2042, 'red', 'Rollforward pending indicator (TABLESPACES) is on',
   'One or more table spaces need to be rolled forward before you can access the tablespace.' );

insert into DBA_PRED_ALERT values (
   2100, 'red', 'Oracle DB on host is down',
   'Check the Oracle ALERT and trace files for any database error messages.   These files are defined in BACKGROUND_DUMP_DEST initialization parameter.  When the problem is identified and resolved, restart the Oracle database.' );

insert into DBA_PRED_ALERT values (
   2101, 'yellow', 'Oracle DB on host - active process threshold approaching max processes for last 5 intervals',
   'You may use the MONITOR PROCESS (SQL*DBA command) to view the idle processes and take the appropriate actions.  Otherwise, you may consider increasing the PROCESSES initialization parameter.' );

insert into DBA_PRED_ALERT values (
   2102, 'yellow', 'Oracle DB on host has at least 1 invalid logfile. Oracle marks a redo log INVALID if it cannot access it. If the online redo log is mirrored & at least 1 member of each online redo log group is unaffected by the media failure, you MAY continue as normal.',
   'Fix the hardware problem as soon as possible & make sure you have at least 2 members in each online redo log group. Then drop the damaged log file & repair the damaged storage device.  Refer to the Oracle pubs for details on recovering redo log group.' );

insert into DBA_PRED_ALERT values (
   2103, 'red', 'Oracle DB has had at least 1 stale logfile for past 5 intervals. The log file STALE if it is not complete or correct.  A stale log file is valid again the next time its group is made the active group.',
   'If the STALE log file is active and log file is not mirrored, use the DataHub SWITCH_LOG function to make it inactive and follow log recovery procedures.  Refer to the Oracle publications for details on recovering redo log group.' );

insert into DBA_PRED_ALERT values (
   2104, 'red', 'DML lock threshold is at or above 95% of max for past 2 minutes. The
maximum number of DML locks should be equal to the grand total of locks on tables referenced by all users. The default value assumes an average of 4 tables referenced per transaction.',
   'For some systems, this default value may not be sufficient.  You may want to re-evaluate the number of concurrent transactions and average table reference and change the DML_LOCKS initialization parameter.' );

insert into DBA_PRED_ALERT values (
   2105, 'yellow', 'Oracle DB on host - datafiles are within 95% of max allowed',
   'Consider increasing space in the db by resizing datafiles (using the ALTER DATABASE command). If you still need more datafiles in the db, you can increase the DB_FILES parameter temporarily or the MAXDATAFILES initialization parameter permanently.' );

insert into DBA_PRED_ALERT values (
   2106, 'yellow', 'Oracle DB on host has at least one rollback segment with dynamic extent allocation failure. The size of your rollback segment must be large enough to hold the rollback entries for your transactions.',
   'If you cannot increase the size of the rollback segments, consider shrinking the TRANSACTIONS param to reduce the number of concurrent transactions. Otherwise, you may change the ROLLBACK_SEGMENTS initialization param or issue ALTER ROLLBACK SEGMENT.' );

insert into DBA_PRED_ALERT values (
   2107, 'yellow', 'Oracle DB on host has at least one job in the job queue which is broken.  Possible causes are: (1) Oracle7 has failed to successfully execute the job after 16 attempts (2) you have marked the job as broken, using the procedure DBMS_JOB.BROKEN.',
   'To force a job to be executed after you have fixed it, use DBMS_JOB.RUN. Caution: This job will run in your current session, re-initializing your session''s packages. RUN contains an implicit commit. Once you execute a job using RUN, you cannot rollback.' );

insert into DBA_PRED_ALERT values (
   2108, 'yellow', 'Oracle DB on host - open cursor hit ratio less than 95%',
   'Consider increasing the SESSION_CACHED_CURSORS value if you use cached cursors.  Furthermore, if you have the CURSOR_SPACE_FOR_TIME set to TRUE and you have encountered library cache misses, consider setting the CURSOR_SPACE_FOR_TIME to FALSE.' );

insert into DBA_PRED_ALERT values (
   2109, 'yellow', 'Database is experiencing high rollback buffer busy waits which exceeds 5% of total data requests.  Contention for rollback segments is reflected by contention for buffers that contain rollback segment blocks.',
   'To reduce contention, create more rollback segments.  For example, for up to 16 concurrent transactions, 4 rollback segments are recommended, for 17 - 32 transactions, 8 segments, for more than 32 transactions, n/4 - but no more than 50.' );

insert into DBA_PRED_ALERT values (
   2110, 'yellow', 'Oracle DB on host - number of sessions approaching max allowed for past 5 minutes',
   'Verify the LICENSE_MAX_USERS initialization parameter shows the actual number of license users for Oracle.  If not, correct it; otherwise, check the connected user for long idle time and take the appropriate action.' );

insert into DBA_PRED_ALERT values (
   2111, 'yellow', 'SGA free memory is less than 5 percent of max for past 5 minutes.  (Note that for optimal performance, the entire SGA should be as large as possible to store as much data in memory as possible and minimize disk I/O.)',
   'Consider adjusting DB_BLOCK_SIZE, DB_BLOCK_BUFFERS, LOG_BUFFER and SHARED_POOL_SIZE. To tune the SGA, you can cause Oracle to read the entire SGA into memory when you start your instance by setting PRE_PAGE_SGA to YES.' );

insert into DBA_PRED_ALERT values (
   2112, 'yellow', 'The database has a latch contention problem (less than 80% for past 5 minutes). ENQUEUE_RESOURCES sets the # of resources that can be locked by the lock manager. The default is ((SESSIONS-3)*5)+20, as long as DML_LOCKS+20 is less than ENQUEUE_RESOURCES.',
   'If there are many tables, consider increasing the ENQUEUE_RESOURCES value, but it should be less than DML_LOCKS + DDL_LOCKS + overhead of about 20.  For redo allocation/copy latch contention, tune LOG_SMALL_ENTRY_MAX_SIZE and LOG_SIMULTANEOUS_COPIES.' );

insert into DBA_PRED_ALERT values (
   2113, 'yellow', 'Oracle DB on host - short table scans exceeded 20000 and is growing by 10 percent in 5 minutes',
   '' );

insert into DBA_PRED_ALERT values (
   2114, 'yellow', 'Oracle DB on host - long table scans exceeded 15000 and is growing by 10 percent in 5 minutes',
   'Ensure large tables have proper indexes. Optimize SQL statements that access large tables by transforming ORs into compound queries to minimize full table scan. Consider increasing your SMALL_TABLE_THRESHOLD initialization parameter. The default is 4.' );

insert into DBA_PRED_ALERT values (
   2115, 'yellow', 'Oracle DB on host is experiencing excessive redo small copies (exceeding 1000 and growing by 5 percent)',
   'The total number of entries less than or equal to LOG_SMALL_ENTRY_MAX_SIZE is exceeding the threshold.  You may want to increase LOG_SMALL_ENTRY_MAX_SIZE initialization parameter.' );

insert into DBA_PRED_ALERT values (
   2116, 'yellow', 'Oracle DB on host - buffer cache hit ratio is low (less than 80 percent)',
   'Determine the optimum size of Oracle memory structures and adjust the buffer cache allocated to SGA by changing the DB_BLOCK_BUFFERS initialization parameter.  Caution: make sure the new SGA size fits into main memory to avoid SGA being paged or swapped.' );

insert into DBA_PRED_ALERT values (
   2117, 'yellow', 'Data buffer contention has been high (over 95%) for the past 5 minutes.  Possible causes include: disk contention, poor space allocation in data blocks, use of dynamic space management.',
   'Tune the I/O activities in your system.Plan where you allocate your datafiles & how you allocate your heavily accessed tables in these datafiles.For example, tables you access concurrently should reside on datafiles that are allocated on separate disks.' );

insert into DBA_PRED_ALERT values (
   2118, 'red', 'Oracle DB on host has at least 1 stale logfile.  Oracle marks a redo
log file STALE if it is not complete or correct.  A stale log file becomes valid again the next time its group is made the active group.',
   'If the STALE log file is active and log file is not mirrored, use the
DataHub SWITCH_LOG function to make it inactive and follow log recovery procedures.  Refer to the Oracle publications for details on recovering redo log group.' );

insert into DBA_PRED_ALERT values (
   4001, 'red', 'There are more than 5 tables with 10%
overflow',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   4102, 'red', 'Deadlock occurred',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   4104, 'red', 'More than 80% of the lock lists are in use',
   'Increase the number of lock lists (use iibuild or iistartup -init' );

insert into DBA_PRED_ALERT values (
   4105, 'red', 'More than 80% of the locks are in use',
   'Increase the number os locks (use iistartup -init)' );

insert into DBA_PRED_ALERT values (
   4200, 'red', 'More than 80% of the log file is in use',
   'Investigate open transactions' );

insert into DBA_PRED_ALERT values (
   4300, 'red', 'The errlog.log file is greater than 10MB',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   4310, 'red', 'errlog.log:Database not available',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   4311, 'red', 'errlog.log:DEADLOCK error',
   'You may want to investigate and correct' );

insert into DBA_PRED_ALERT values (
   4330, 'red', 'errlog.log:LICENSE error',
   'You may want to investigate and correct' );

