/*							*/
/*   Licensed Materials - Property of IBM               */
/*							*/
/*   5765-530            				*/
/*   (C) Copyright IBM Corp. 1996 All Rights Reserved.	*/
/*							*/

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

/* protocol version for communication between control point and daemons */
#define VER_FETCHN	2		/* first version supporting FetchN */
#define VER_LOAD_ERR	3		/* varlength err mess in (un)load */
#define VER_CONN_OPT	4		/* added options to connect */
#define VER_EXT_FETCH	5		/* added error messages to fetch */
#define DR_PROT_VER	VER_EXT_FETCH

#define CONNECT 	10
#define COMMIT		11
#define ROLLBACK 	12
#define ATTRIBUTES 	13
#define INDEX 		14
#define COMMAND 	15
#define FETCH 		16
#define CLOSE 		17
#define DISCONNECT 	18
#define FETCHONE 	19
#define	EXIT		20
#define	CONTENTS	21
#define	FILEGET		22
#define	FILEPUT		23
#define FETCHALL	24
#define UNLOAD		25
#define CREATEFILE	26
#define EXECUTE		27
#define EXECUTE1	28
#define CONNECTU 	29
#define RECONNECT 	30
#define SET_MONITOR	31
#define RESET_MONITOR	32
#define GET_SNAPSHOT	33
#define PROCCOMMAND	34
#define EXECUTE_ASYNC   50
#define ASYNC_PROC_LIST 51
#define ASYNC_KILL 	52
#define ASYNC_PROC_READY 53
#define ASYNC_FILE_LINE	54
#define ASYNC_CLEAR	55
#define TRACELEVEL	56
#define PROCSTATUS	57
#define ASYNC_FILE_LINE_ALL	58
#define UNLOAD_SYLL	59
#define LOAD_SYLL	60
#define FETCHN 		61
#define UPDATE 		62
#define EXECUTE_STREAM	63

#define DBMCONNECT 	100
#define EXT_CONNECT 	101
#define SHUTDOWN 	102
#define CONNECT_INTERNAL	103
/* note the numbers 135 to 163 are reserved for the db2/6000 api */

/* options for connect, DBMCONNECT,CONNECT_INTERNAL etc are 
 * now all mapped to CONNECT.
 * The form of connect is passed as a bitmap of the following values
 */
#define NO_OPTIONS              0
#define OPTION_CONNECT          1       /* all   : normal connect */
#define OPTION_DBM_CONNECT      2       /* all   : connect to daemon only */
#define OPTION_INT_CONNECT      4       /* oracle: connect internal */
#define OPTION_EXT_CONNECT      8       /* oracle: identified external */

#define SET_READY 	-4
#define READY 		-1
#define ACTIVE 		0
#define DATA 		0
#define REC_LEN 	63
#define NAMELEN 	30
#define TYPELEN 	15
#define MESSLEN 	100
#define COMMLEN 	80
#define OK		0
#define	FILEOPEN_FAILED 1
#define	DBERROR 	2
#define	TEXT 		1
#define	RAW 		2
#define	MAXREADERROR 	-99
#define	NOMORE 		-100
#define	NOT_FOUND 	-101
#define	INVALID_CURSOR 	-102
#define	TOO_MANY_CONC_CURSORS 	-103
#define	CANNOT_ALLOCATE_MEMORY 	-104
#define	STATEMENT_TOO_LONG 	-105

#define BUFSIZE		2048
#define LASTDB 		5
#define MAXSTAT		4096
#define	MAXFIELD	4096
#define PATHLEN		255
#define MAX_BINARY_SIZE	10

#ifndef MAX
#define MAX(a,b)        ((a) > (b) ? (a) : (b))
#endif

#ifndef MIN
#define MIN(a,b)        ((a) < (b) ? (a) : (b))
#endif

#ifndef ABS
#define ABS(a)		((a) > 0 ? (a) : -(a))
#endif

struct table_t {
	char	table[NAMELEN];
	char 	owner[NAMELEN];
};

struct field_t {
	int  	type;	/* INVALID_CURSOR,TEXT,NOMORE,NOT_FOUND            */
	int	error;	/* 0 in case of success, db error otherwise	   */
	int	indicator;/* 1 null, 0 not null 		           */
	size_t 	len;	/* length of the value field			   */
	char	*value;	/* record or error message, depending		   */
			/* on the value of error			   */
};

struct field_desc_t {
	int mtype;
	char name[NAMELEN];
	char type[TYPELEN];
	int len;
};

struct sql_comm {
	int cursor;
	int errcode;
	char errmess[MESSLEN];
};

struct sql_conn {
	char	name[NAMELEN];
	char 	password[NAMELEN];
	char 	dbname[NAMELEN];
	char 	homedir[PATHLEN];
};

struct contents {
	short	result; 		/* OK, FILEOPEN_FAILED, DBERROR */
	char	remarks[MESSLEN];	/* filename or errormessage */
};

struct  async_proc_t {
	int     processid;
	char    command[COMMLEN];
	char    outputfile[COMMLEN];
	int     starttime;
	int     endtime;
	short   status;
};

/*
 *      dbs_command_t:  struct to send to server to obtain checks
 */
struct  dbs_command_t {
	char	type[8];                /* database type */
	char	host[20];               /* hostname */
	char	dbname[20];             /* database name */
	char	dbdir[255];             /* directory/instance */
	int 	alias;			/* 1 = alias, 0 = real host name */
};

/* the return string is restricted to 255 because of the table definition */
#define WD_RET_STRLEN	255

union return_value {
	float	fvalue;
	long	ivalue;
	char	svalue[WD_RET_STRLEN];
};

/*
 *      dbs_check_t:    struct received from server for 1 check
 */
#define CHECK_TEXT_LENGTH 1000
struct  dbs_check_t {
	int	id;                     /* check number or -1 */
	int	del_ind;                /* 0 if active, -1, 1 if to delete  */
	int	chk_type;               /* SQL or OS or REFRESH */
	char	chk_text[CHECK_TEXT_LENGTH];        /* command to be executed */
	int	filter_type;            /* LE, LT, GE, GT, EQ, NE, NONE or 0 */
	union return_value filter_val;  /* value for filter */
	long	ret_type;		/* CHECK_FLOAT ... */
	int	times;                  /* number of time structures */
};


/*
 *      dbs_time_t:     struct received from server for 1 checktime
 */
#define SPEC_FOLLOWS	0
#define TIME_NOW	1
#define TIME_ONCE	1
#define TIME_FOREVER	1

struct  dbs_time_t {
	int	start_type;		/* SPEC_FOLLOWS,TIME_NOW */
	long	start_time;
	int	repeat_type;		/* SPEC_FOLLOWS,TIME_ONCE */
	long	repeat_time;
	int	end_type;		/* SPEC_FOLLOWS,TIME_FOREVER */
	long	end_time;
	};

#define CHECK_FLOAT	0
#define CHECK_INT	1
#define CHECK_STRING	2

struct  return_t {
	int	check;
	long	ts;		/* timestamp in UNIX format (localtime) */
	long	ret_type;	/* CHECK_FLOAT ... */
	union return_value value;
	};

/* structure for returning errors from an operation like commit, rollback etc */
struct error_t 
{
	int	error_code;	/* db error code */
	char	*error_msg;	/* db error message */
};

#define	NONE		-1
#define	INT		0
#define	STRING		1
#define	TABLE_T		2
#define	FIELD_DESC_T	3
#define	SQL_COMM	4
#define	SQL_CONN	5
#define	FIELD_T		6
#define	SNAPSHOT_T	7
#define	ASYNC_PROC_T	8
#define	CHAR		9
#define	FLOAT		10
#define	RETURN_T	12
#define	DBS_CHECK_T	13
#define	DBS_TIME_T	14
#define	DBS_COMMAND_T	15
#define	PASSWD		16
#define	TIME		17
#define DBS_TIME_TABLE_T 18
#define DBS_TIME_CHECK_T 19
#define SHORT 		 20
#define RAW_STRING	 22
#define VAR_STRING	 23
#define	FIELD_T_ORG	 24	/* compatibility */
#define ERROR_T		 25
#define	FIELD_T_DYNAMIC	 26

#define SELECT_SIZE	255

#define DECRYPT         'D'
#define ENCRYPT         'E'

#ifndef LIB
extern char *duplicate_quotes2( char *);
#endif
