-----------------------------------------------------------------------
--(c) Copyright IBM Corporation 2006  All rights reserved.           --
--                                                                   --
--This sample program is owned by International Business Machines    --
--Corporation or one of its subsidiaries ("IBM") and is copyrighted  --
--and licensed, not sold.                                            --
--BY ACCESSING, COPYING, OR USING THIS SAMPLE PROGRAM, YOU AGREE TO  --
--THE TERMS OF THE AGREEMENT TITLED "International License Agreement --
--for Non-Warranted db2perf Programs" LOCATED IN THE FILE NAMED      --
--"license.txt".                                                     --
--                                                                   --
-- db2perf_procevmon.db2                                             --
-- Steve Rees - srees@ca.ibm.com                                     --
--                                                                   --
-- Creates a table to receive the data generated by db2perf_procevmon--
-- from an event monitor output file.                                --
--                                                                   --
-----------------------------------------------------------------------

CALL db2perf_quiet_drop( 'table db2perf_evmon' );

CREATE TABLE db2perf_evmon (
	record			INTEGER,
	AGENT_ID 		BIGINT,
	AGENTS_TOP 		BIGINT,
	APPL_ID 		CHAR(32),
	BLOCKING_CURSOR 	SMALLINT,
	CONSISTENCY_TOKEN 	CHAR(8),
	CREATOR 		VARCHAR(30),
	CURSOR_NAME 		VARCHAR(18),
	EVMON_FLUSHES 		BIGINT,
	FETCH_COUNT 		BIGINT,
	INT_ROWS_DELETED 	BIGINT,
	INT_ROWS_INSERTED 	BIGINT,
	INT_ROWS_UPDATED 	BIGINT,
	PACKAGE_NAME 		CHAR(8),
	PACKAGE_VERSION_ID 	VARCHAR(64),
	PARTIAL_RECORD 		SMALLINT,
	POOL_DATA_L_READS 	BIGINT,
	POOL_DATA_P_READS 	BIGINT,
	POOL_INDEX_L_READS 	BIGINT,
	POOL_INDEX_P_READS 	BIGINT,
	POOL_TEMP_DATA_L_READS	BIGINT,
	POOL_TEMP_DATA_P_READS 	BIGINT,
	POOL_TEMP_INDEX_L_READS BIGINT,
	POOL_TEMP_INDEX_P_READS BIGINT,
	ROWS_READ 		BIGINT,
	ROWS_WRITTEN 		BIGINT,
	SECTION_NUMBER 		BIGINT,
	SEQUENCE_NO 		CHAR(5),
	SORT_OVERFLOWS 		BIGINT,
	SQL_REQ_ID 		BIGINT,
	SQLCABC 		INTEGER,
	SQLCAID 		CHAR(8),
	SQLCODE 		INTEGER,
	SQLERRD1 		INTEGER,
	SQLERRD2 		INTEGER,
	SQLERRD3 		INTEGER,
	SQLERRD4 		INTEGER,
	SQLERRD5 		INTEGER,
	SQLERRD6 		INTEGER,
	SQLERRM 		VARCHAR(72),
	SQLERRP 		CHAR(8),
	SQLSTATE 		CHAR(5),
	SQLWARN 		CHAR(11),
	START_TIME 		TIMESTAMP,
	STMT_OPERATION 		BIGINT,
	STMT_TYPE 		BIGINT,
	STOP_TIME 		TIMESTAMP,
	SYSTEM_CPU_TIME 	BIGINT,
	TOTAL_SORT_TIME 	BIGINT,
	TOTAL_SORTS 		BIGINT,
	USER_CPU_TIME 		BIGINT,
	STMT_TEXT 		CLOB(2097152)
);

CALL db2perf_quiet_drop( 'table db2perf_evmon_subsect' );

CREATE TABLE db2perf_evmon_subsect (
RECORD          INTEGER,
APPL_HANDLE     INTEGER,
FLUSH           CHAR(5),
SUBSECTION      INTEGER,
NODE            INTEGER,
EXEC_TIME       DECIMAL(12,6),
USER_CPU        DECIMAL(12,6),
SYSTEM_CPU      DECIMAL(12,6),
TQ_SEND_OVFLW   INTEGER,
TQ_ROWS_READ    INTEGER,
TQ_ROWS_WRITTEN INTEGER,
AGENTS_CREATED  INTEGER 
);
