/*



	Copyright 1992-1999 Hyperion Solutions Corporation. All Rights Reserved.



	RESTRICTED RIGHTS LEGEND:



	Use, duplication, or disclosure by the Government is subject to 

	restrictions as set forth in subparagraph (c)(1)(ii) of the Rights 

	in Technical Data and Computer Software clause at DFARS 252.227-7013, 

	or in the Commercial Computer Software Restricted Rights clause at 

	FAR 52.227-19, as applicable.



	Hyperion Solutions Corporation

	1344 Crossman Avenue, Sunnyvale, CA  94089  USA



	NAME

	csamp1.c



	DEPENDENCIES

	You must add ESSAPIN.LIB to your project.

	You must also identify the Essbase/API/Include and Essbase/API/Lib 

	directories to the compiler/linker.



	DESCRIPTION

        This file is used by Hyperion Publications for testing of the Main API and 

	describing the most fundamental aspects of the Essbase API.  This simple 

	application program is intended as a starting point for more complex programs. 

	This program performs only the most basic initialization and login functions.  

	It connects to a server/application/database, performs only the most basic of

	tasks (lists connected users), disconnects, logs out and terminates. Because 

	all Essbase API programs must do these things, this program represents the 

	most simple API program possible. It is applicable in the most general sense 

	to being used as a starting point for more useful and complex 

	production-oriented programs. 



	NOTES

	This program has three sections:

	  1 - The includes and function definitions

	  2 - The function declarations

	  3 - The main flow



	MODIFIED

		* Created   26 Aug 1999		publications	



*/

/************************************************************************************/

/************************************************************************************/

/************************************************************************************/





/*

Declaration of Include files 

*/



#if defined _WIN32 || defined _WINDOWS

#include <windows.h>

#endif 



#include <string.h>

#include <stdio.h> 

#include <stdlib.h>

#pragma pack (1)

#include <essapi.h>

#include <essotl.h>

#pragma pack ()



/*

Declaration of handles and connection information variables

*/



ESS_HINST_T  hInst;              

ESS_HCTX_T hCtx;

ESS_SVRNAME_T	srvrName	=	"";

ESS_USERNAME_T	userName	=	"";

ESS_PASSWORD_T	pswd		=	"";





/*

Declaration of all the Essbase API functions used in this program.

You could declare all the functions here, and have them available

for the prototype section. This program only uses a few functions.

*/



/* Initialization and Login functions */

void ESS_Init();

void ESS_AutoLogin();                    

void ESS_Login();                  //This app uses EssAutoLogin(), but it is 

void ESS_LoginSetPassword();	   //fairly easy to use these other login functions,

void ESS_AutoLoginSetPassword();   //so I declared them here for future use.

void ESS_Logout();  

void ESS_Term();

void ESS_GetVersion();

void ESS_GetAPIVersion();            

void ESS_SetActive();

void ESS_ListDatabases();

void ESS_ListUsers();

void ESS_Free();





/**********************  START FUNCTION DECLARATIONS  *******************************/

/************************************************************************************/



void ESS_Init()

{

    ESS_STS_T    sts;

    ESS_INIT_T InitStruct = {ESS_API_VERSION,

     							NULL,

     							0L,

     							255,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

								NULL,

								NULL,

     							0L

     						};  

   if ((sts = EssInit(&InitStruct, &hInst)) != ESS_STS_NOERR)

   {       printf("EssInit failure: %ld\n", sts);

      exit ((int) sts);

   }

   printf("EssInit sts: %ld\n", sts);  

}    

  

/*****************************************************/

/*****************************************************/



void ESS_Login ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;

    

   sts = EssLogin (hInst, srvrName, userName, pswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLogin sts: %ld\r\n", sts);

   if ( (sts == 1051093L) || (sts == 1051090L) )

   {	ESS_LoginSetPassword(); }

   else 

   if ( (sts != 0) && (sts != 1051093L) && (sts != 1051090L) )

   {   printf("\n\tUsage:  MAINAPI servername username password\n");

	   printf("\tDefault: \n\tserver name: local\n\tuser name:  admin\n\tpassword:  password\n");

	   exit ((int) sts);

   }

}



/*****************************************************/

/*****************************************************/



void ESS_AutoLogin ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_CHAR_T SvrName[ESS_SVRNAMELEN];		//this is different in VC++6

   ESS_CHAR_T UserName[ESS_USERNAMELEN];

   ESS_CHAR_T Password[ESS_PASSWORDLEN];

   ESS_CHAR_T AppName[ESS_APPNAMELEN];

   ESS_CHAR_T DbName[ESS_DBNAMELEN];

  

   ESS_USHORT_T   Option;

   ESS_ACCESS_T   Access ;

//   ESS_HCTX_T     hCtx;  Don't set this again, it is set in EssInit

   

   /* Initialize parameters */

   strcpy(SvrName,"localhost");

   strcpy(UserName,"Admin");

   strcpy(Password,"Password");

   strcpy(AppName,"");

   strcpy(DbName,"");

   Option = AUTO_DEFAULT;

   

   /* Login to Essbase server */

   sts = EssAutoLogin (hInst, SvrName, UserName, Password,

                 AppName, DbName, Option, &Access, &hCtx);

   printf("EssAutoLogin sts: %ld\r\n", sts);

   

}   



/*****************************************************/

/*****************************************************/



void ESS_LoginSetPassword()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;



   ESS_PASSWORD_T newPswd = "password2";

    

   sts = EssLoginSetPassword (hInst, srvrName, userName, pswd, newPswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLoginSetPassword sts: %ld\r\n", sts);

   if (sts)

   {   printf("\n\tEssLoginSetPassword sts: %ld\n",sts);

	   exit ((int) sts);

   }

 

}



/*****************************************************/

/*****************************************************/



void ESS_GetAPIVersion()

{     

   ESS_STS_T    sts = ESS_STS_NOERR;   

   ESS_ULONG_T  Version;                                   

   

   sts = EssGetAPIVersion(&Version); 

   

   if(!sts)

      printf("API Version %#x\n",Version);

}



/*****************************************************/

/*****************************************************/



void ESS_Term()

{     

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   if ((sts = EssTerm(hInst)) != ESS_STS_NOERR)

   {

      /* error terminating API */

      exit((ESS_USHORT_T) sts);

   }

   printf("EssTerm sts: %ld\r\n", sts);

}



/*****************************************************/

/*****************************************************/



void ESS_Logout()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   

   sts = EssLogout (hCtx);

   printf("\n\nEssLogout sts: %ld\n",sts);

}



/*****************************************************/

/*****************************************************/



void ESS_GetVersion()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Release;

   ESS_USHORT_T Version;

   ESS_USHORT_T Revision;

   

   sts = EssGetVersion (hCtx, &Release, &Version, &Revision);

   printf("EssGetVersion sts: %ld\r\n", sts);

   

   if(!sts)

   {

     printf("\r\nEssbase Application Server -  Version %d.%d.%d\r\n", Release, Version, Revision);

   }

}



/*****************************************************/

/*****************************************************/



void ESS_SetActive()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_ACCESS_T Access;

   ESS_STR_T AppName;

   ESS_STR_T DbName;

   

   AppName = "sample";

   DbName = "basic";

   sts = EssSetActive(hCtx, AppName, DbName, &Access);

   printf("EssSetActive sts: %ld\r\n",sts);

}

   

/*****************************************************/

/*****************************************************/



void ESS_ListDatabases()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Items;

   ESS_USHORT_T ind;

   ESS_PAPPDB_T pAppsDbs = NULL;

   

   sts = EssListDatabases(hCtx, NULL, &Items, &pAppsDbs);    

   printf("EssListDatabases sts: %ld\r\n",sts);

   

   if(!sts)

   {

      if(Items && pAppsDbs)

      {

         printf("\r\n--Applications/databases available--\r\n");

         for (ind = 0; ind<Items; ind++)

         {

            if((pAppsDbs+ind) !=NULL)

            {

               if((pAppsDbs[ind].AppName != NULL) && (pAppsDbs[ind].DbName != NULL))

               {

                  printf("%s",pAppsDbs[ind].AppName);

                  printf(" ==> ");

                  printf("%s",pAppsDbs[ind].DbName);

                  printf("\n\r");

               }

            }

         }

         EssFree(hInst, pAppsDbs);

      }

      else

         printf("\r\nDatabase List is Empty\r\n\r\n");

   }

}



/*****************************************************/

/*****************************************************/



void ESS_ListUsers()

{



   ESS_STS_T	    sts;

   ESS_USHORT_T     Count;

   ESS_PUSERINFO_T  Users = NULL;

   ESS_USHORT_T     ind;



   sts = EssListUsers (hCtx, NULL, NULL, &Count, &Users); 

   if (!sts)

   {

      if (Count && Users)

      {

         printf ("\r\n-------User List from EssListUsers()-------\r\n\r\n");    

         for (ind = 0; ind < Count; ind++)

         {

            printf ("Name->%s\tApplication->%s\tdatabase->%s\r\n",

                     Users[ind].Name, Users[ind].AppName, Users[ind].DbName);

            // printf("Login %d\r\n",Users[ind].Login);

            // printf("Type %d\r\n",Users[ind].Type);

            // printf("Access %d\r\n",Users[ind].Access);                                 

            // printf("MaxAccess %d\r\n",Users[ind].MaxAccess);

            // printf("Expiration %d\r\n",Users[ind].Expiration); 

            // printf("LastLogin %d\r\n",Users[ind].LastLogin);

            // printf("FailCount %d\r\n",Users[ind].FailCount); 

            // printf("LoginId %ld\r\n",Users[ind].LoginId);

         }

            // printf("end of userlist %d\r\", count);

         printf ("\r\n-------User List from EssListUsers()-------\r\n\r\n");    

         EssFree (hInst, Users);     

		 printf("\r\n");

      }

      else

         printf ("\r\nUsers list is empty\r\n\r\n");    

   }

}

 

/*****************************************************/

/*************** MAIN FUNCTION ***********************/



/*

This is the actual program. It initializes and logs with EssAutoLogin,

then gets the Essbase version and the version of the API. It sets the 

active application and lists the users connected to the application. The

output consists of simple printf statements.

*/

main()

{

   ESS_Init();

   ESS_AutoLogin();  



/*

Every Essbase API program must issue EssInit to get the context handle (hCtx).

The EssLogin is required to connect to a database/application. Almost any 

functions can follow the Init and Login. We used EssAutoLogin to display

the Connect dialog box, but this program could have used EssLogin and 

retrieve the Username and Password as command line arguments. Following 

sample programs will illustrate the use of command line arguments.

*/



/*

The following statements perform some of the most simple actions. The output, 

in the form of printf statements, is done by the individual functions. The 

EssFree functions that release allocated memory are also in the individual 

functions. More complex programs will not free memory in the individual functions 

because the allocated structures and handles are needed until the end.



These simple actions can easily be more complex.  Additional operations would

be added in this section.  Following sample programs will do more, but this

program merely retrieves some basic information and displays it.

*/



   ESS_GetVersion();   

   ESS_GetAPIVersion();   

   ESS_SetActive();

   ESS_ListDatabases();         

   ESS_ListUsers();

/*

The EssLogout disconnects the user from the Essbase server, application, and 

database.  The EssTerm ends the program and frees allocated memory, such

as the context handle.

*/

   ESS_Logout(); 

   ESS_Term();   

} 



/*

End of program CSamp1.c

*/



