/*



	Copyright 1992-1999 Hyperion Solutions Corporation. All Rights Reserved.



	RESTRICTED RIGHTS LEGEND:



	Use, duplication, or disclosure by the Government is subject to 

	restrictions as set forth in subparagraph (c)(1)(ii) of the Rights 

	in Technical Data and Computer Software clause at DFARS 252.227-7013, 

	or in the Commercial Computer Software Restricted Rights clause at 

	FAR 52.227-19, as applicable.



	Hyperion Solutions Corporation

	1344 Crossman Avenue, Sunnyvale, CA  94089  USA



	NAME

        CSamp2.c



	DEPENDENCIES

		



	DESCRIPTION

        This file is used by Hyperion Publications as an example of a simple

        applications program. This program performs basic initialization and

		login and queries the active application/database. It then manipulates

		the user list, adding, renaming, and deleting a new user.



	NOTES

	This program has three sections:

	  1 - The includes and function definitions

	  2 - The function declarations

	  3 - The main flow





	MODIFIED

		* Modified  03 Sep 1999		Publications



*/

/************************************************************************************/

/***********************  START FUNCTION DEFINITIONS  *******************************/

/************************************************************************************/



#if defined _WIN32 || defined _WINDOWS

#include <windows.h>

#endif 



#include <string.h>

#include <stdio.h> 

#include <stdlib.h>

#pragma pack (1)

#include <essapi.h>

#include <essotl.h>

#pragma pack ()





ESS_HINST_T  hInst;              

ESS_HCTX_T hCtx;

ESS_SVRNAME_T	srvrName	=	"";

ESS_USERNAME_T	userName	=	"";

ESS_PASSWORD_T	pswd		=	"";



/* Initialization and Login functions */

void ESS_Init();

// void ESS_Login();			/* This requires command line arguments */

void ESS_Logout();  

void ESS_Term();

void ESS_AutoLogin();			/* This displays the login dialog box */

void ESS_LoginSetPassword();	/* This is called if EssAutoLogin returns error */

void ESS_GetVersion();

void ESS_GetAPIVersion();            



/* Application functions */

void ESS_SetActive();

// void ESS_GetActive(); 

void ESS_ListApplications();

void ESS_ListDatabases();

void ESS_GetDatabaseInfo();



void ESS_ListUsers();			/*  These functions will be called repeatedly */

void ESS_CreateUser ();			/*  to create a user, list users, rename the  */

void ESS_RenameUser();			/*  new user, list users again, then delete   */

void ESS_DeleteUser();			/*  the new users and list users again        */

void ESS_GetUserInfo ();



/************************************************************************************/

/**********************  START FUNCTION DECLARATIONS  *******************************/

/************************************************************************************/

void ESS_Init()

{

    ESS_STS_T    sts;

    ESS_INIT_T InitStruct = {ESS_API_VERSION,

     							NULL,

     							0L,

     							255,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

     							NULL,

								NULL,

								NULL,

     							0L

     						};  

   if ((sts = EssInit(&InitStruct, &hInst)) != ESS_STS_NOERR)

   {       printf("EssInit failure: %ld\n", sts);

      exit ((int) sts);

   }

   printf("EssInit sts: %ld\n", sts);  

}    

  

/************************************************************************************/

void ESS_Login ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;

    

   sts = EssLogin (hInst, srvrName, userName, pswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLogin sts: %ld\r\n", sts);

   if ( (sts == 1051093L) || (sts == 1051090L) )

   {	ESS_LoginSetPassword(); }

   else 

   if ( (sts != 0) && (sts != 1051093L) && (sts != 1051090L) )

   {   printf("\n\tUsage:  MAINAPI servername username password\n");

	   printf("\tDefault: \n\tserver name: local\n\tuser name:  admin\n\tpassword:  password\n");

	   exit ((int) sts);

   }

}



/************************************************************************************/

void ESS_AutoLogin ()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_CHAR_T SvrName[ESS_SVRNAMELEN];		//this is different in VC++6

   ESS_CHAR_T UserName[ESS_USERNAMELEN];

   ESS_CHAR_T Password[ESS_PASSWORDLEN];

   ESS_CHAR_T AppName[ESS_APPNAMELEN];

   ESS_CHAR_T DbName[ESS_DBNAMELEN];

  

   ESS_USHORT_T   Option;

   ESS_ACCESS_T   Access ;

//   ESS_HCTX_T     hCtx;  Don't set this again, it is set at the top

   

   /* Initialize parameters */

   strcpy(SvrName,"localhost");

   strcpy(UserName,"Admin");

   strcpy(Password,"Password");

   strcpy(AppName,"");

   strcpy(DbName,"");

   Option = AUTO_DEFAULT;

   

   /* Login to Essbase server */

   sts = EssAutoLogin (hInst, SvrName, UserName, Password,

                 AppName, DbName, Option, &Access, &hCtx);

   printf("EssAutoLogin sts: %ld\r\n", sts);

}   



/************************************************************************************/

void ESS_LoginSetPassword()

{

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   ESS_USHORT_T Items;

   ESS_PAPPDB_T pAppsDbs = NULL;



   ESS_PASSWORD_T newPswd = "password2";

    

   sts = EssLoginSetPassword (hInst, srvrName, userName, pswd, newPswd, &Items, &pAppsDbs, &hCtx);

   printf("EssLoginSetPassword sts: %ld\r\n", sts);

   if (sts)

   {   printf("\n\tEssLoginSetPassword sts: %ld\n",sts);

	   exit ((int) sts);

   }

}



/************************************************************************************/

void ESS_GetAPIVersion()

{     

   ESS_STS_T    sts = ESS_STS_NOERR;   

   ESS_ULONG_T  Version;                                   

   

   sts = EssGetAPIVersion(&Version); 

   

   if(!sts)

      printf("API Version %#x\n",Version);

}



/************************************************************************************/

void ESS_Term()

{     

   ESS_STS_T sts = ESS_STS_NOERR;                                    

   if ((sts = EssTerm(hInst)) != ESS_STS_NOERR)

   {

      /* error terminating API */

      exit((ESS_USHORT_T) sts);

   }

   printf("EssTerm sts: %ld\r\n", sts);

}



/************************************************************************************/

void ESS_Logout()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   

   sts = EssLogout (hCtx);

   printf("\n\nEssLogout sts: %ld\n",sts);

}



/************************************************************************************/

void ESS_GetVersion()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Release;

   ESS_USHORT_T Version;

   ESS_USHORT_T Revision;

   

   sts = EssGetVersion (hCtx, &Release, &Version, &Revision);

   printf("EssGetVersion sts: %ld\r\n", sts);

   

   if(!sts)

   {

     printf("\r\nEssbase Application Server -  Version %d.%d.%d\r\n", Release, Version, Revision);

   }

}



/************************************************************************************/

void ESS_GetActive()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_STR_T pDbName;

   ESS_STR_T pAppName;

   ESS_ACCESS_T Access;

   

   if((sts = EssAlloc (hInst, 80, (ESS_PPVOID_T)&pAppName)) == 0)

   {

      if((sts = EssAlloc (hInst, 80, (ESS_PPVOID_T)&pDbName)) == 0)

      {

         if((sts = EssGetActive(hCtx, &pAppName, &pDbName, &Access)) == 0)

         {

            if(pAppName)

            {

               if(*pAppName)

                  printf("Current active application is [%s]\r\n",pAppName);

               else

                  printf("No active Application is set\r\n");

            }

            EssFree(hInst, pDbName);

         }

         EssFree(hInst, pAppName);     

      }

   }

}     



/************************************************************************************/

void ESS_SetActive()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_ACCESS_T Access;

   ESS_STR_T AppName;

   ESS_STR_T DbName;

   

   AppName = "sample";

   DbName = "basic";

   sts = EssSetActive(hCtx, AppName, DbName, &Access);

   printf("EssSetActive sts: %ld\r\n",sts);

}

   

/************************************************************************************/

void ESS_ListApplications()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_PAPPNAME_T strp = NULL;

   ESS_USHORT_T Items;

   ESS_USHORT_T ind;

   

   sts = EssListApplications(hCtx, &Items, &strp);

   if(!sts)

   {

      if(Items && strp)

      {

      	 printf("Applications availables\r\n");

      	 for(ind = 0; ind <Items; ind++)

      	 {

      	    if(strp[ind] != NULL)

      	       printf("%s\r\n", strp[ind]);

      	 }

      	 EssFree(hInst, strp);

      }

      else

         printf("\r\nApplication List is Empty\r\n\r\n");

    }

}



/************************************************************************************/

void ESS_ListDatabases()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_USHORT_T Items;

   ESS_USHORT_T ind;

   ESS_PAPPDB_T pAppsDbs = NULL;

   

   sts = EssListDatabases(hCtx, NULL, &Items, &pAppsDbs);    

   printf("EssListDatabases sts: %ld\r\n",sts);

   

   if(!sts)

   {

      if(Items && pAppsDbs)

      {

         printf("\r\n--Applications/databases available--\r\n");

         for (ind = 0; ind<Items; ind++)

         {

            if((pAppsDbs+ind) !=NULL)

            {

               if((pAppsDbs[ind].AppName != NULL) && (pAppsDbs[ind].DbName != NULL))

               {

                  printf("%s",pAppsDbs[ind].AppName);

                  printf(" ==> ");

                  printf("%s",pAppsDbs[ind].DbName);

                  printf("\n\r");

               }

            }

         }

         EssFree(hInst, pAppsDbs);

      }

      else

         printf("\r\nDatabase List is Empty\r\n\r\n");

   }

}

            

/************************************************************************************/

void ESS_GetDatabaseInfo()

{

   ESS_STS_T sts = ESS_STS_NOERR;

   ESS_PDBINFO_T DbInfo;

   ESS_STR_T AppName;

   ESS_STR_T DbName;

   

   AppName = "Sample";

   DbName = "Basic";

   

   sts = EssGetDatabaseInfo(hCtx, AppName, DbName, &DbInfo);

   if(!sts)

   {  

      printf("\r\n----- Results of EssGetDatabaseInfo -----\r\n");

	  printf("AppName: %s\r\n",DbInfo->AppName);

      printf("DbName: %s\r\n",DbInfo->Name);

      printf("DbType: %d\r\n",DbInfo->DbType);

      printf("Status: %d\r\n",DbInfo->Status);

      printf("nConnects: %d\r\n",DbInfo->nConnects);

      printf("nLocks: %d\r\n",DbInfo->nLocks);

      printf("nDims: %d\r\n",DbInfo->Data);

      printf("Country: %s\r\n",DbInfo->Country);

      printf("Time: %s\r\n",DbInfo->Time);

      printf("Category: %s\r\n",DbInfo->Category);

      printf("Type: %s\r\n",DbInfo->Type);

      printf("CrPartition: %s\r\n",DbInfo->CrPartition);

      printf("\r\n----- Results of EssGetDatabaseInfo -----\r\n");

      

      if(DbInfo)

      {

      	EssFree(hInst, DbInfo);

      }

   }

}



/************************************************************************************/

void ESS_ListUsers()

{



   ESS_STS_T	    sts;

   ESS_USHORT_T     Count;

   ESS_PUSERINFO_T  Users = NULL;

   ESS_USHORT_T     ind;



   sts = EssListUsers (hCtx, NULL, NULL, &Count, &Users); 

   if (!sts)

   {

      if (Count && Users)

      {

         printf ("\r\n-------User List from EssListUsers()-------\r\n\r\n");    

         for (ind = 0; ind < Count; ind++)

         {

            printf ("Name->%s\tApplication->%s\tdatabase->%s\r\n",

                     Users[ind].Name, Users[ind].AppName, Users[ind].DbName);

         }

         printf ("\r\n-------User List from EssListUsers()-------\r\n\r\n");    

         EssFree (hInst, Users);     

		 printf("\r\n");

      }

      else

         printf ("\r\nUsers list is empty\r\n\r\n");    

   }

}

 

/************************************************************************************/

void ESS_CreateUser()

{

   ESS_STS_T     sts = ESS_STS_NOERR;

      

   ESS_CHAR_T UserName[] = "newuser";		//this is different in VC++6

   ESS_CHAR_T Password[] = "password";		//compare to the API reference example   



   printf("Begin EssCreateUser Function");



   sts = EssCreateUser (hCtx, UserName, Password);

   printf("EssCreateUser sts: %ld",sts);

}



/************************************************************************************/

void ESS_RenameUser()

{

   ESS_STS_T     sts = ESS_STS_NOERR;

   ESS_CHAR_T OldName[] = "newuser";

   ESS_CHAR_T NewName[] = "user4";

      

   sts = EssRenameUser (hCtx, OldName, NewName);

}



/************************************************************************************/

void ESS_DeleteUser()

{

   ESS_STS_T     sts = ESS_STS_NOERR;

   ESS_CHAR_T UserName[] = "user4";

   

   sts = EssDeleteUser (hCtx, UserName);

   printf("EssDeleteUser sts: %ld",sts);

}



/************************************************************************************/

void ESS_GetUserInfo ()

{

   ESS_STS_T        sts  = ESS_STS_NOERR;

   ESS_PUSERINFO_T  User = NULL;

     

   sts = EssGetUser (hCtx, "Jim Smith", &User);

   printf("EssGetUserInfo %ld\r\n",sts);

   

   if (!sts)

   { 

        printf ("Name->%s Application->%s database->%s\r\n",

                     User->Name, User->AppName, User->DbName);

        printf("Login %d\r\n",User->Login);

        printf("Type %d\r\n",User->Type);

        printf("Access %d\r\n",User->Access);                                 

        printf("MaxAccess %d\r\n",User->MaxAccess);

        printf("Expiration %d\r\n",User->Expiration); 

        printf("LastLogin %d\r\n",User->LastLogin);

        printf("FailCount %d\r\n",User->FailCount); 

        printf("LoginId %ld\r\n",User->LoginId);

    

      if (User)

         EssFree (hInst, User);

   }

}



/************************************************************************************/

void getCmdLineArgs(int argc, char *argv[])

{

   if (argc>1)

	strcpy(srvrName,argv[1]);



   if (argc>2)

	   strcpy(userName,argv[2]);



   if (argc>3)

	   strcpy(pswd,argv[3]);



    printf("Server name:  %s\n",srvrName);

    printf("User name:  %s\n",userName);

    printf("Password:  %s\n",pswd);

}



/*****************************************************/

/*************** MAIN FUNCTION ***********************/

/*****************************************************/



void main(int argc, char *argv[])

{                 



	getCmdLineArgs(argc,argv);



   ESS_Init();

   ESS_AutoLogin();  

   ESS_GetVersion();   

   ESS_GetAPIVersion();   

   

   ESS_SetActive();

   ESS_ListApplications();

   ESS_ListDatabases();         

   ESS_GetDatabaseInfo(); 



   ESS_ListUsers();

   //ESS_CreateUser();

   //ESS_RenameUser();

   //ESS_DeleteUser();

   //ESS_GetUserInfo ();

   

   ESS_Logout(); 

   ESS_Term();   

}

/*

End of program cs2.c

*/

