/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttDef;
import com.ibm.xml.framework.Attr;
import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import org.xml.sax.AttributeList;

public final class DefaultAttrPool
implements AttrPool,
AttributeList {
    static final int CHUNK_SHIFT = 5;
    static final int CHUNK_SIZE = 32;
    static final int CHUNK_MASK = 31;
    static final int INITIAL_CHUNK_COUNT = 32;
    static final int ATTRFLAG_SPECIFIED = 64;
    static final int ATTRFLAG_LASTATTR = 128;
    private StringPool fStringPool;
    private XMLErrorHandler fErrorHandler;
    private int fAttlistIndex = -1;
    private int fAttlistLength;
    private int fAttrCount;
    private int[][] fAttName = new int[32][];
    private int[][] fAttValue = new int[32][];
    private byte[][] fAttTypeAndFlags = new byte[32][];

    public DefaultAttrPool(ParserState parserState) {
        this.fStringPool = parserState.cacheStringPool();
        this.fErrorHandler = parserState.getErrorHandler();
    }

    public void reset(ParserState parserState) {
        this.fStringPool = parserState.cacheStringPool();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fAttlistIndex = -1;
        this.fAttlistLength = 0;
        this.fAttrCount = 0;
    }

    public AttrPool resetOrCopy(ParserState parserState) {
        return new DefaultAttrPool(parserState);
    }

    private boolean ensureCapacity(int n, int n2) {
        try {
            return this.fAttName[n][n2] != 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int[][] nArray = new int[n * 2][];
            System.arraycopy(this.fAttName, 0, nArray, 0, n);
            this.fAttName = nArray;
            nArray = new int[n * 2][];
            System.arraycopy(this.fAttValue, 0, nArray, 0, n);
            this.fAttValue = nArray;
            byte[][] byArray = new byte[n * 2][];
            System.arraycopy(this.fAttTypeAndFlags, 0, byArray, 0, n);
            this.fAttTypeAndFlags = byArray;
        }
        catch (NullPointerException nullPointerException) {}
        this.fAttName[n] = new int[32];
        this.fAttValue[n] = new int[32];
        this.fAttTypeAndFlags[n] = new byte[32];
        return true;
    }

    public int addAttr(Attr attr, int n) throws Exception {
        int n2;
        int n3;
        if (n != -1) {
            n3 = n >> 5;
            n2 = n & 0x1F;
            while (n < this.fAttrCount) {
                if (this.fAttName[n3][n2] == attr.attName) {
                    this.fErrorHandler.error1(9, attr.attName);
                    return -1;
                }
                ++n;
                if (++n2 != 32) continue;
                ++n3;
                n2 = 0;
            }
        } else {
            n3 = this.fAttrCount >> 5;
            n2 = this.fAttrCount & 0x1F;
        }
        this.ensureCapacity(n3, n2);
        this.fAttName[n3][n2] = attr.attName;
        this.fAttValue[n3][n2] = attr.attValue;
        this.fAttTypeAndFlags[n3][n2] = (byte)((attr.specified ? 64 : 0) | attr.attType);
        int n4 = this.fAttrCount++;
        return n4;
    }

    public void setIsLastAttr(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        byte[] byArray = this.fAttTypeAndFlags[n2];
        int n4 = n3;
        byArray[n4] = (byte)(byArray[n4] | 0x80);
    }

    public int getAttrName(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttName[n2][n3];
    }

    public int getAttType(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttTypeAndFlags[n2][n3] & 0x3F;
    }

    public int getAttValue(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return this.fAttValue[n2][n3];
    }

    public boolean isSpecified(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return true;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return (this.fAttTypeAndFlags[n2][n3] & 0x40) != 0;
    }

    public boolean isLastAttr(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return true;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return (this.fAttTypeAndFlags[n2][n3] & 0x80) != 0;
    }

    public void releaseAttrList(int n) {
        boolean bl;
        if (n == -1) {
            return;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        do {
            bl = (this.fAttTypeAndFlags[n2][n3] & 0x80) != 0;
            this.fAttName[n2][n3] = -1;
            if ((this.fAttTypeAndFlags[n2][n3] & 0x40) != 0) {
                this.fStringPool.releaseString(this.fAttValue[n2][n3]);
            }
            this.fAttValue[n2][n3] = -1;
            if (++n3 != 32) continue;
            ++n2;
            n3 = 0;
        } while (!bl);
        if (this.fAttrCount == (n2 << 5) + n3) {
            this.fAttrCount = n;
            return;
        }
        try {
            this.fErrorHandler.error(169);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public AttributeList getAttributeList(int n) {
        this.fAttlistIndex = n;
        if (this.fAttlistIndex == -1) {
            this.fAttlistLength = 0;
        } else {
            int n2 = this.fAttlistIndex >> 5;
            int n3 = this.fAttlistIndex & 0x1F;
            this.fAttlistLength = 1;
            while ((this.fAttTypeAndFlags[n2][n3] & 0x80) == 0) {
                if (++n3 == 32) {
                    ++n2;
                    n3 = 0;
                }
                ++this.fAttlistLength;
            }
        }
        return this;
    }

    public int getLength() {
        return this.fAttlistLength;
    }

    public String getName(int n) {
        if (n < 0 || n >= this.fAttlistLength) {
            return null;
        }
        int n2 = this.fAttlistIndex + n >> 5;
        int n3 = this.fAttlistIndex + n & 0x1F;
        return this.fStringPool.toString(this.fAttName[n2][n3]);
    }

    public String getType(int n) {
        if (n < 0 || n >= this.fAttlistLength) {
            return null;
        }
        int n2 = this.fAttlistIndex + n >> 5;
        int n3 = this.fAttlistIndex + n & 0x1F;
        int n4 = this.fAttTypeAndFlags[n2][n3] & 0x3F;
        if (n4 == 9) {
            n4 = 6;
        }
        return AttDef.getAttTypeString(n4);
    }

    public String getValue(int n) {
        if (n < 0 || n >= this.fAttlistLength) {
            return null;
        }
        int n2 = this.fAttlistIndex + n >> 5;
        int n3 = this.fAttlistIndex + n & 0x1F;
        return this.fStringPool.toString(this.fAttValue[n2][n3]);
    }

    public String getType(String string) {
        int n = this.fStringPool.addSymbol(string.intern());
        if (n == -1) {
            return null;
        }
        int n2 = this.fAttlistIndex >> 5;
        int n3 = this.fAttlistIndex & 0x1F;
        int n4 = 0;
        while (n4 < this.fAttlistLength) {
            if (this.fAttName[n2][n3] == n) {
                int n5 = this.fAttTypeAndFlags[n2][n3] & 0x3F;
                if (n5 == 9) {
                    n5 = 6;
                }
                return AttDef.getAttTypeString(n5);
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return null;
    }

    public String getValue(String string) {
        int n = this.fStringPool.addSymbol(string.intern());
        if (n == -1) {
            return null;
        }
        int n2 = this.fAttlistIndex >> 5;
        int n3 = this.fAttlistIndex & 0x1F;
        int n4 = 0;
        while (n4 < this.fAttlistLength) {
            if (this.fAttName[n2][n3] == n) {
                return this.fStringPool.toString(this.fAttValue[n2][n3]);
            }
            if (++n3 == 32) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return null;
    }

    public int getFirstAttr(int n) {
        if (n < 0 || n >= this.fAttrCount) {
            return -1;
        }
        return n;
    }

    public int getNextAttr(int n) {
        if (this.isLastAttr(n)) {
            return -1;
        }
        return n + 1;
    }
}

