/**********************************************************************
*
*  IBM CONFIDENTIAL
*  OCO SOURCE MATERIALS
*
*  COPYRIGHT:  P#2 P#1
*              (C) COPYRIGHT IBM CORPORATION Y1, Y2
*
*  The source code for this program is not published or otherwise divested of
*  its trade secrets, irrespective of what has been deposited with the U.S.
*  Copyright Office.
*
*  Source File Name = (com/ibm/dxx/db2/tools/common/uamanager/HelpFileNames.java, common, db2cc_v71, c000114)
*
*  Descriptive Name = Help Names constants
*
*  Function: Simple interface providing centralized equates for various help files
*            used throughout the DBA tools.
*
*            The interface defines no methods.
*
*  Dependencies: See import list.
*
*  Restrictions:
*
*  Change Activity:
*    DATE    DESCRIPTION                                             S&D Code
*  ============================================================================
*  97/10/23  First cut of this interface class.                      @d77849dje
*  97/10/21  Add Command Center, Alert, Legend, Tools Settings       @d77860GCO
*            Help file constants.                                    @d77860GCO
*  97/10/21  Add Tablespaces, Schemas, Bufferpools help constants    @d77914al
*  97/10/22  Add partition help constants                            @d77941CEU
*  97/10/22  More filnames                                           @d77849dje
*  97/10/22  Filename for instance attach.                           @d77913JGJ
*  97/10/23  Filename for system attach.                             @d77998JGJ
*  97/11/05  Add Visual Explain help ids                             @d78340wl
*  97/11/17  Add instance Help id                                    @d78458bcy
*  97/11/17  Add Replication Help id                                 @d78676yhk
*  97/11/20  Add system Help id                                      @d78700bcy
*  97/12/04  Added constant for Database backup notebook help        @d79210sb
*  97/12/05  Added constant for Tablespace backup notebook help      @d79268sb
*  97/12/18  Added Database Configure Performance SmartGuide entries @d79635pt
*  98/01/18  Added entries for Create Table SmartGuide.              @d80495FJA
*  98/01/23  Added entries for Create Database, Create Tablespace
*            Backup Database and Restore Database SmartGuides        @d80157MJZ
*  98/01/27  Add User&Group privileges Help ids                      @d80006jal
*  98/02/02  Complete User&Group privileges Help ids                 @d81142jal
*  98/02/12  Hook up help for Recovery Notebooks                     @d81866sb
*  98/02/24  Added entries for Alias, View, Index                    @d82478mak
*  98/02/25  Added entries for Info Center                           @d82556jdr
*  98/02/26  Added entries for Table                                 @d80077ABM
*  98/02/27  Add common components                                   @d82672dje
*  98/02/28  Added VE operator help                                  @d82747wl
*  98/03/05  Add SMS/DMS add/change container help                   @d82360al
*  98/03/05  Added entries for Trigger and UDT                       @d83006kmm
*  98/03/17  Add Open and Save As CC entries                         @d83443jse
*  98/04/06  Signin/Default passwords                                @d83647dje
*  98/04/06  Filenames reversed                                      @d84665dje
*  98/04/21  Fix help                                                @d85105lw
*  98/04/27  INstance/System attach                                  @d85393dje
*  98/05/11  Help index and Using help                               @d85073mak
*  98/06/16  add help index/file name for change repl target/src     @d88253shg
*  98/06/22  Add help for Pre-Filter                                 @d88298al
*  98/06/26  Fix help for Add DMS container                          @d89114al
*  98/07/10  Fix help for CommandCenter Open, Script/File SaveAs     @d90104thx
*            Fix help for Change DMS FileSystemDialog ref. d90077    @d90104thx
*  98/11/05  Add help for Performance monitor                        @d96461abm
*  98/11/27  Add help for Tools settings                             @d97592abm
*  98/12/04  Add help for Monitor save as                            @d97841abm
*  98/12/10  Add Help filename for connections                       @d98061rzp
*  98/12/10  Added "uc" suffix to .ndx filenames                     @d98776jdr
*  99/01/07  Add help for more Monitor functions                     @d99085shg
*  99/01/11  Update PerfMon help names                               @d99032abm
*  99/01/18  Update PerfMon help names                               @d99623abm
*  99/01/18  Add restart database help names                         @d99580wl
*  99/01/22  Add Satellite Administration help names                 @f99950jal
*  99/01/26  Add more Satellite Administration help names            @f100167jal
*  99/02/02  Updates for Code Review                                 @d100735pwk
*  99/02/16  Updates names for perfmon                               @d101751abm
*  99/02/19  Move HotKeyxxx.java to common package                   @d102171bc
*  99/02/25  Add list satellites for SAC                             @d102952al
*  99/03/03  Add more Satellite Administration help names            @d103043jal
*  99/03/04  Add Help file names for the license center              @d104609awh
*  99/03/18  Add Help file names for Index SmartGuide                @d104729mjz
*  99/03/22  Change name of "help index" file                        @d105pp4jdr
*  99/03/22  Change help for sort,  filter,  etc                     @d106155mjm
*  99/03/26  Change help for generate ddl and estimate size          @d103219ssc
*  99/03/26  Add more Satellite Administration help names            @d106130jal
*  99/03/30  Add help file names for SPM Smartguide and Test Dlg     @d104456ys
*  99/03/30  Change all Info Center file names to match HTML         @d107581jdr
*  99/03/31  Change Completion Actions help file name                @d103279ssc
*  99/04/01  Add hyperlink items for Index SmartGuide                @d107961mjz
*  99/04/08  Add entry for Info Center overview                      @d109138jdr
*  99/04/09  Set up help for Show SQL                                @d109480bc
*  99/04/12  Correct help file name for Show Logs dialog             @d107505jal
*  99/04/15  Fix incorrect help for save as monitor window           @d110436abm
*  99/05/17  Fix hyperlinks for Index SmartGuide                     @d116361mjz
*  99/05/27  Show sql help is wrong                                  @d117844mjm
*  99/07/06  add help to view script                                 @d120313dri
*  99/07/19  Help for Edit Script was incorrect                      @d120329kmm
*  99/06/17  Update the applications dialog help page                @d119860jse
*  99/09/28  Set up help for Rename tablespace                       @d125948bc
*  99/09/29  Set up help for EISCAN operator (VE)                    @d126132wl
*  99/10/14  Created Fonts Settings Panel in Tools Settings Dialog   @d127739ang
*  99/10/20  Add help file names for DWC Schedule Notebook           @d128156abm
*  99/10/21  Add DB2/VSE&VM help file names                          @d126245gm
*  99/11/04  Add delete custom tree help name                        @d130468grs
*  99/11/15  add warehouse schema modeler help file names            @d131498rac
*  99/11/18  add Tools Settings OS/390 help file name                @d132160tdt
*  99/11/22  Move CommonDialog to common jar                         @d130512bc
*  99/12/01  Add delete utility and delete dataset help file names   @d133306grs
*  99/12/13  Add help IDs for tablespace priv dialogs                @d133174wl
*  00/01/10  Add help IDs for Control DB Management in DWC           @d137996tkl
*  00/01/11  Add help IDs for Warehouse Center                       @d138046mjm
*  03/09/09  fix iSeries Wizard and unify the V7/V8 code             @d291667jc
*
*  Last Changed = 00/01/11 17:44:35
*
***********************************************************************/

package com.ibm.dxx.db2.tools.common.uamanager;     //@d291667jc

/*
* HelpFileNames
*/


public   interface   HelpFileNames
{
public static final String HELP_CONTROL_CENTER_OVERVIEW  = "ctlctr01" ;
public static final String HELP_CC_SIGNIN                = "tccso" ;    //@d83647dje @d84665dje
public static final String HELP_CC_RESET_DEFAULT         = "treid01" ;    //@d83647dje @d84665dje

public static final String HELP_DROP            = "tcomdr01" ;
public static final String HELP_DELETE_CUSTOM   = "common\\deletecustomtreedialog" ; //@d130468grs
public static final String HELP_DELETE_UTILITY  = "common\\deleteutilityobjdialog" ; //@d133306grs
public static final String HELP_DELETE_DATASET  = "db2_390\\deletedatasetdialog" ; //@d133306grs
public static final String HELP_CUSTOM_COLUMNS  = "tcust01" ;
public static final String HELP_FILTER          = "tanav-10" ;
public static final String HELP_FIND            = "cfind01" ;
public static final String HELP_SORT            = "tsort01" ;

public static final String HELP_SCRIPT_OVERVIEW      = "oscrc01" ;
public static final String HELP_SCRIPT_CREATE        = "tscrc01" ;
public static final String HELP_SCRIPT_RUN           = "tscrc02" ;
public static final String HELP_SCRIPT_SCHEDULE      = "tscrc03" ;
public static final String HELP_SCRIPT_EDIT          = "csrcs03" ;      //@d120329kmm
public static final String HELP_SCRIPT_COPY          = "tscrc05" ;
public static final String HELP_SCRIPT_DELETE        = "tscrc06" ;
public static final String HELP_SCRIPT_SHOW          = "pgsch-07";      //@d120313dri

public static final String HELP_JOURNAL              = "ologs01" ;
public static final String HELP_JJOBS                = "plogs01" ;
public static final String HELP_JRECOVERY            = "plogs02" ;
public static final String HELP_JALERTS              = "plogs03" ;
public static final String HELP_JMESSAGES            = "plogs04" ;

public static final String HELP_SCHEDULE_RESULTS          = "clogs01" ;
public static final String HELP_SCHEDULE_CHANGE_ACTIONS   = "tjbsd05" ; //@d103279ssc
public static final String HELP_VIEW_TABLESPACES          = "clogs02" ;    //@d77849dje
public static final String HELP_RESTORE_DATABASE_RECOVERY ="clogs03" ;    //@d77849dje

public static final String HELP_RUN_NOW              = "csrcs04" ;    //@d77849dje
public static final String HELP_SCHEDULE             = "ojbsd01" ;



public static final String HELP_FILE_BROWSER         = "uicomp07" ;
public static final String HELP_FILE_BROWSER_DMS     = "uicomp01" ;
public static final String HELP_ADD_CHANGE_SMS_CNR   = "uicomp02" ; // @d82360al
public static final String HELP_ADD_CHANGE_DMS_CNR   = "uicomp11" ; // @d89114al  //@d90104thx
public static final String HELP_DIRECTORY_BROWSER    = "uicomp08" ;
public static final String HELP_DATABASE_SELECTION_DIALOG  = "uicomp09" ; //@d77849dje

public static final String HELP_ATTACH_INSTANCE       = "tdbcon01" ; //@d85393dje
public static final String HELP_ATTACH_SYSTEM         = "tdbcon01" ; //@d85393dje
public static final String HELP_CONNECT_DATABASE      = "tdbcon01" ; //@d85393dje

public static final String HELP_ADD_INSTANCE          = "tainad01";  //<@d78458bcy
public static final String HELP_CHANGE_INSTANCE       = "tainch01";
public static final String HELP_INSTANCE_CONFIGURE    = "taincf01";
public static final String HELP_INSTANCE_FORCE_APPL   = "tainfr01";
public static final String HELP_INSTANCE_LIST_APPL    = "tainls01";
public static final String HELP_INSTANCE_SETUP_COMM   = "tincom01";
public static final String HELP_INSTANCE_COMM_NETBIOS = "tincom02";
public static final String HELP_INSTANCE_COMM_TCPIP   = "tincom03";
public static final String HELP_INSTANCE_COMM_IPXSPX  = "tincom04";
public static final String HELP_INSTANCE_COMM_NPIPE   = "tincom07";
public static final String HELP_INSTANCE_COMM_APPC    = "tincom08";  //>@d78458bcy

public static final String HELP_ADD_SYSTEM           = "tasyad01";  //<@d78700bcy
public static final String HELP_CHANGE_SYSTEM        = "tasych01";  //>@d78700bcy
                                                                    //<@d77860GCO
public static final String HELP_LEGEND               = "pnav04" ;

public static final String HELP_TS_OVERVIEW          = "pnav01" ;
public static final String HELP_TS_GENERAL           = "pnav02" ;
public static final String HELP_TS_ALERT             = "ttset05" ;
public static final String HELP_TS_REPLICATION       = "tnav08" ;
public static final String HELP_TS_NODE_STATUS       = "ttset01" ;
public static final String HELP_TS_TRACE             = "ttset02" ; //@d83647dje
public static final String HELP_TS_FONTS             = "ttset03" ; //@d127739ang
public static final String HELP_TS_OS390             = "ttset07" ; //@d132160tdt

public static final String HELP_CC_OVERVIEW          = "ocmdp01" ;
public static final String HELP_CC_SCRIPT            = "pcmdp01" ;
public static final String HELP_CC_RESULTS           = "pcmdp02" ;
public static final String HELP_CC_ACCESS            = "tapcc01" ;
public static final String HELP_CC_OPTIONS           = "tcmdp05" ;
public static final String HELP_CC_RESULT_SAVEAS     = "tcmdp06" ;                  //@d90104thx
public static final String HELP_CC_OPEN              = "tcmdp08" ;   //@d83443jse   //@d90104thx
public static final String HELP_CC_SCRIPT_SAVEAS     = "tcmdp09" ;   //@d83443jse   //@d90104thx
public static final String HELP_ALERT_OVERVIEW       = "oalert01";
public static final String HELP_ALERT_SUSPEND        = "talert06";

                                                                    //>@d77860GCO

//<@d82556jdr
public static final String HELP_IC_TASKS       = "taia-r4";
public static final String HELP_IC_REFS        = "taia-r1";
public static final String HELP_IC_BOOKS       = "taia-1";
public static final String HELP_IC_SAMPS       = "taia-r3";
public static final String HELP_IC_MSGS        = "taia-r5";
public static final String HELP_IC_WEB         = "taia-3";
public static final String HELP_IC_TIPS        = "tsia-r1";
public static final String HELP_IC_CTLS        = "ctlia";
//>@d82556jdr
public static final String HELP_IC_OVERVIEW    = "ovia-r1"; //@d109138jdr

//<@d98776jdr
public static final String HELP_IC_FRAME       = "db2info";
public static final String HELP_IC_TASKS_NDX   = "db2tasksuc.ndx";
public static final String HELP_IC_REFS_NDX    = "db2refsuc.ndx";
public static final String HELP_IC_BOOKS_NDX   = "db2booksuc.ndx";
public static final String HELP_IC_SAMPS_NDX   = "db2sampsuc.ndx";
public static final String HELP_IC_MSGS_NDX    = "db2msgsuc.ndx";
public static final String HELP_IC_WEB_NDX     = "db2webuc.ndx";
//>@d98776jdr

                                                                 //<@d77914al
public static final String HELP_ALTER_BUFFERPOOL             = "tbpal01";
public static final String HELP_ALTER_BUFFERPOOL_MPP         = "tbpalp01";
public static final String HELP_CREATE_BUFFERPOOL            = "tbpcr01";
public static final String HELP_CREATE_BUFFERPOOL_MPP        = "tbpcrp01";
public static final String HELP_RESTORE_DB_BACKUP_IMAGE_PAGE = "tadbrs01";
public static final String HELP_RESTORE_DB_TABLESPACE_PAGE   = "tadbrs02";
public static final String HELP_ALTER_SCHEMAS                = "tsc01";
public static final String HELP_CREATE_SCHEMAS               = "tsc02";
public static final String HELP_ALTER_TABLESPACE             = "tuttsa01";
public static final String HELP_TABLESPACE_ADVANCED_ALTER    = "tuttsa02";
public static final String HELP_TABLESPACE_LIST_EXCEPTIONS   = "tconex01";
public static final String HELP_TABLESPACE_LIST_ALL_CNRS     = "tlstcn01";
public static final String HELP_CREATE_TABLESPACE            = "tut01";
public static final String HELP_TABLESPACE_ADVANCED_CREATE   = "tut02";
public static final String HELP_RESTORE_TS_BACKUP_IMAGE_PAGE = "ttsrs01";
public static final String HELP_RESTORE_TS_CONTAINERS_PAGE   = "ttsrs02";
public static final String HELP_RENAME_TABLESPACE            = "tats1";         //@d125948bc
                                                                 //>@d77914al

                                                                   //<@d77941CEU
public static final String HELP_NODES_VIEW                   = "tnodes01";
public static final String HELP_DATABASE_PARTITIONS          = "odbprt01";
public static final String HELP_TABLESPACE_PARTITIONS        = "otsprt01";
public static final String HELP_TABLE_PARTITIONS             = "otaprt01";
public static final String HELP_CONNECTION_PARTITIONS        = "ocoprt01";  //@d98061rzp
public static final String HELP_CREATE_NODEGROUP             = "tangcr01";
public static final String HELP_ALTER_NODEGROUP              = "tangad01";
public static final String HELP_CONFIRM_NODE_STOP            = "tinst01";
public static final String HELP_DB2_TRACE_SERVICE_ACTIONS    = "ttrc01";
public static final String HELP_DIAG_LOG_SERVICE_ACTIONS     = "tdi01";
                                                                   //>@d77941CEU

//<@d78340wl
public static final String HELP_VE_EXPLAIN_SQL_STATEMENT           = "tve08";
public static final String HELP_VE_EXPLAINABLE_STATEMENTS          = "tve09";
public static final String HELP_VE_EXPLAINED_STATEMENTS_HISTORY    = "tve10";
public static final String HELP_VE_ACCESS_PLAN_GRAPH               = "tve11";
public static final String HELP_VE_SQL_TEXT                        = "tve12";
public static final String HELP_VE_CHANGE_EXPLAINED_STATEMENT      = "tve13";
public static final String HELP_VE_FIND                            = "tve14";
public static final String HELP_VE_FILTER_EXPLAINABLE_STATEMENTS   = "tve15";
public static final String HELP_VE_FILTER_EXPLAINED_STATEMENTS     = "tve16";
public static final String HELP_VE_SELECT_PRINTER                  = "tve17";
public static final String HELP_VE_OPTIMIZATION_PARAMETERS         = "tve18";
public static final String HELP_VE_TABLE_SPACES                    = "tve19";
public static final String HELP_VE_TABLE_SPACE_STATISTICS          = "tve20";
public static final String HELP_VE_FUNCTIONS                       = "tve21";
public static final String HELP_VE_FUNCTION_STATISTICS             = "tve22";
public static final String HELP_VE_OPERATOR_DETAILS                = "tve23";
public static final String HELP_VE_INDEX_STATISTICS                = "tve24";
public static final String HELP_VE_PAGE_FETCH_PAIRS_STATISTICS     = "tve25";
public static final String HELP_VE_TABLE_STATISTICS                = "tve26";
public static final String HELP_VE_REFERENCED_COLUMNS              = "tve27";
public static final String HELP_VE_REFERENCED_COLUMN_STATISTICS    = "tve28";
public static final String HELP_VE_COLUMN_DISTRIBUTION_STATISTICS  = "tve29";
public static final String HELP_VE_INDEXES                         = "tve30";
public static final String HELP_VE_DATABASE_PARTITIONS_OPERATOR    = "tve31";
public static final String HELP_VE_TABLE_FUNCTION_STATISTICS       = "tve32";
public static final String HELP_VE_GRAPH_OVERVIEW                  = "tve33";
public static final String HELP_VE_GRAPH_SETTINGS                  = "tve34";
public static final String HELP_VE_GRAPH_SETTINGS_GRAPH            = "tve35";
public static final String HELP_VE_GRAPH_SETTINGS_NODE             = "tve36";
public static final String HELP_VE_GRAPH_SETTINGS_OPERATOR         = "tve37";
public static final String HELP_VE_GRAPH_SETTINGS_BASIC            = "tve38";
public static final String HELP_VE_GRAPH_SETTINGS_EXTENDED         = "tve39";
public static final String HELP_VE_GRAPH_SETTINGS_UPDATE           = "tve40";
public static final String HELP_VE_GRAPH_SETTINGS_MISCELLANEOUS    = "tve41";
public static final String HELP_VE_GRAPH_SETTINGS_OPERAND          = "tve42";
//>@d78340wl

//<@d78676yhk
public static final String HELP_DP_DEFINE_SRC            = "reaw01" ;
public static final String HELP_DP_SRC_CHANGE            = "rehw01" ;
public static final String HELP_DP_SRC_JOIN              = "reew01" ;
public static final String HELP_DP_SRC_JOIN_SHOW_COLS    = "reew02" ;
public static final String HELP_DP_SRC_REMOVE            = "recw01" ;
public static final String HELP_DP_DEFINE_SUB            = "redw01" ;
public static final String HELP_DP_SUB_ADV_TYPE          = "redw04" ;
public static final String HELP_DP_SUB_ADV_COL           = "redw05" ;
public static final String HELP_DP_SUB_ADV_CREATE_COL    = "redw06" ;
public static final String HELP_DP_SUB_ADV_SHOW_KEY      = "redw07" ;
public static final String HELP_DP_SUB_ADV_CHANGE_COL    = "redw08" ;
public static final String HELP_DP_SUB_ADV_COL_EXAMP     = "redw09" ;
public static final String HELP_DP_SUB_ADV_ROW           = "redw10" ;
public static final String HELP_DP_SUB_ADV_ROW_EXAMP     = "redw11" ;
public static final String HELP_DP_SUB_ADD_SRC           = "redw02" ;
public static final String HELP_DP_SUB_SQL               = "redw12" ;
public static final String HELP_DP_SUB_SQL_ADD           = "redw13" ;
public static final String HELP_DP_SUB_TIMING_SRC        = "redw14" ;
public static final String HELP_DP_SUB_TIMING_TGT        = "redw15" ;
public static final String HELP_DP_SUB_TIMING_BLOCK      = "redw16" ;
public static final String HELP_DP_SUB_CLONE             = "regw01" ;
public static final String HELP_DP_SUB_REMOVE            = "refw01" ;
public static final String HELP_DP_SUB_CHANGE            = "reiw01" ;
public static final String HELP_DP_RUN_OR_SAVE           = "rezzw01" ;
public static final String HELP_DP_SUB_RUN_OR_SAVE       = "rezw01" ;
public static final String HELP_DP_SUB_CHG_SRC           = "redw20" ;
//>@d78676yhk
//@d79210sb
public static final String HELP_DATABASE_BACKUP_NOTEBOOK   = "tadbbu01";
public static final String HELP_TABLESPACE_BACKUP_NOTEBOOK = "ttsbu01"; //@d79268sb

public static final String HELP_DB_CFGPERF_SG_OVERVIEW       = "operf01"; //@d79635pt
public static final String HELP_DB_CFGPERF_SG_DBNAME_PG      = "pperf01";
public static final String HELP_DB_CFGPERF_SG_SERVER_PG      = "pperf02";
public static final String HELP_DB_CFGPERF_SG_WORKLOAD_PG    = "pperf03";
public static final String HELP_DB_CFGPERF_SG_TRANSACTION_PG = "pperf04";
public static final String HELP_DB_CFGPERF_SG_PRIORITY_PG    = "pperf05";
public static final String HELP_DB_CFGPERF_SG_POPULATED_PG   = "pperf06";
public static final String HELP_DB_CFGPERF_SG_CONNECTION_PG  = "pperf07";
public static final String HELP_DB_CFGPERF_SG_ISOLATION_PG   = "pperf08";
public static final String HELP_DB_CFGPERF_SG_RESULT_PG      = "pperf09";

// Create Table SmartGuide @d80495FJA
public static final String HELP_TABLE_SG_OVERVIEW            = "otasg01";
public static final String HELP_TABLE_SG_NAME_PAGE           = "ptasg01";
public static final String HELP_TABLE_SG_COLUMNS_PAGE        = "ptasg02";
public static final String HELP_TABLE_SG_EDIT_COLUMNS_PAGE   = "ptasg03";
public static final String HELP_TABLE_SG_PRIMARY_KEY_PAGE    = "ptasg04";
public static final String HELP_TABLE_SG_TABLE_SPACE_PAGE    = "ptasg05";
// EditColumnLists
public static final String HELP_TABLE_SG_EDIT_LISTS          = "ptasg06";

public static final String HELP_TABLE_SG_COLINFO_ADD         = "ptasg09";
public static final String HELP_TABLE_SG_COLINFO_CHANGE      = "ptasg10";
public static final String HELP_TABLE_SG_COLINFO_PREDEF_ADD  = "ptasg07";
public static final String HELP_TABLE_SG_COLINFO_PREDEF_EDIT = "ptasg08";

                                                                 //<@d80157MJZ
// Create Database SmartGuide
public static final String HELP_NEW_DB_SG_OVERVIEW          = "ocrdb01";
public static final String HELP_NEW_DB_SG_NAME_PAGE         = "pcrdb01";
public static final String HELP_NEW_DB_SG_USER_PAGE         = "pcrdb02";
public static final String HELP_NEW_DB_SG_CAT_PAGE          = "pcrdb03";
public static final String HELP_NEW_DB_SG_TEMP_PAGE         = "pcrdb04";
public static final String HELP_NEW_DB_SG_PERF_PAGE         = "pcrdb05";
public static final String HELP_NEW_DB_SG_REGION_PAGE       = "pcrdb06";
// Backup Database SmartGuide
public static final String HELP_BACKUP_SG_OVERVIEW          = "oback01";
public static final String HELP_BACKUP_SG_DB_PAGE           = "pback01";
public static final String HELP_BACKUP_SG_AVAIL_PAGE        = "pback02";
public static final String HELP_BACKUP_SG_PROTECT_PAGE      = "pback03";
public static final String HELP_BACKUP_SG_RATE_PAGE         = "pback04";
public static final String HELP_BACKUP_SG_RECOMMEND_PAGE    = "pback05";
public static final String HELP_BACKUP_SG_IMAGE_PAGE        = "pback06";
// Restore Database SmartGuide
public static final String HELP_RESTORE_SG_OVERVIEW         = "orest01";
public static final String HELP_RESTORE_SG_STATUS_PAGE      = "prest01";
public static final String HELP_RESTORE_SG_HISTORY_PAGE     = "prest02";
public static final String HELP_RESTORE_SG_ROLL_FORWARD     = "prest03";
public static final String HELP_RESTORE_SG_LOG_FILES_PAGE   = "prest04";
// Create Table space SmartGuide
public static final String HELP_NEW_TS_SG_OVERVIEW          = "ptssg01";
public static final String HELP_NEW_TS_SG_NAME_PAGE         = "ptssg02";
public static final String HELP_NEW_TS_SG_TYPE_PAGE         = "ptssg03";
public static final String HELP_NEW_TS_SG_MANAGMNT_PAGE     = "ptssg04";
public static final String HELP_NEW_TS_SG_CONTAINER_PAGE    = "ptssg05";
public static final String HELP_NEW_TS_SG_READ_WRITE_PAGE   = "ptssg06";
public static final String HELP_NEW_TS_SG_DRIVE_SPEED_PAGE  = "ptssg07";
public static final String HELP_DRIVE_SPECIFICATIONS_DIALOG = "ptssg08";
public static final String HELP_EXTENT_PREFETCH_DIALOG      = "ptssg09";
                                                                 //>@d80157MJZ
                                                                 //<<@d104729mjz
// Index SmartGuide
public static final String HELP_INDEX_SG_INTRO              = "tainsgsu";
public static final String HELP_INDEX_SG_WORKLOAD_SELECT    = "insgsg2b";
public static final String HELP_INDEX_SG_WORKLOAD_CREATE    = "insgsg2a";
public static final String HELP_INDEX_SG_LIMITS             = "insgsg3";
public static final String HELP_INDEX_SG_CALCULATE          = "insgsg4";
public static final String HELP_INDEX_SG_RECOMMEND          = "insgsg5";
public static final String HELP_INDEX_SG_DROP               = "insgsg6";
public static final String HELP_INDEX_SG_SUMMARY            = "insgsg7";
public static final String HELP_INDEX_SG_WORKLOAD_NAME      = "cncpwkld";       //@d116361mjz   //@d107961mjz
public static final String HELP_INDEX_SG_WORKLOAD_TARGET    = "HDRWORKLOAD_ID"; //@d116361mjz   //@d107961mjz
public static final String HELP_INDEX_SG_TIMERON_NAME       = "cncptmrn";       //@d116361mjz   //@d107961mjz
public static final String HELP_INDEX_SG_TIMERON_TARGET     = "HDRTIMERON_ID";  //@d116361mjz   //@d107961mjz
public static final String HELP_INDEX_SG_FREQUENCY_NAME     = "cncpfreq";       //@d116361mjz
public static final String HELP_INDEX_SG_FREQUENCY_TARGET   = "HDRFREQUENCY_ID";//@d116361mjz

// Dialogs for Index SmartGuide
public static final String HELP_INDEX_SG_IMPORT_SQL         = "tinsgis";
public static final String HELP_INDEX_SG_ADD_SQL            = "tinsgas";
public static final String HELP_INDEX_SG_CHANGE_SQL         = "tinsgcs";
public static final String HELP_INDEX_SG_VIEW_SQL           = "tinsgvs";
public static final String HELP_INDEX_SG_ADVANCED_LIMITS    = "tinsgal";
public static final String HELP_INDEX_SG_CREATE_WORKLOAD    = "tinsgcw";
public static final String HELP_INDEX_SG_EDIT_WORKLOAD      = "tinsgew";
public static final String HELP_INDEX_SG_WORKLOAD_DETAILS   = "tinsgwd";
                                                                 //>>@d104729mjz
                                                                 //<@d80006jal
public static final String HELP_PRIV_DATABASE_USER         ="tdbpr01";
public static final String HELP_PRIV_DATABASE_GROUP        ="tdbpr02";
public static final String HELP_PRIV_TABLE_USER            ="ttapr01";
public static final String HELP_PRIV_TABLE_GROUP           ="ttapr02";
public static final String HELP_PRIV_SCHEMA_USER           ="tscpr01";
public static final String HELP_PRIV_SCHEMA_GROUP          ="tscpr02";
public static final String HELP_PRIV_VIEW_USER             ="tvwpr01";
public static final String HELP_PRIV_VIEW_GROUP            ="tvwpr03";
public static final String HELP_PRIV_INDEX_USER            ="tinpr01";
public static final String HELP_PRIV_INDEX_GROUP           ="tinpr02";
public static final String HELP_PRIV_TABLESPACE_USER       ="taispr01";//@d133174wl
public static final String HELP_PRIV_TABLESPACE_GROUP      ="tatspr02h";//@d133174wl

public static final String HELP_PRIV_DATABASE_ADD_USER     ="tdbpr03";//@d81142jal
public static final String HELP_PRIV_DATABASE_ADD_GROUP    ="tdbpr04";//@d81142jal
public static final String HELP_PRIV_TABLE_ADD_USER        ="ttapr03";
public static final String HELP_PRIV_TABLE_ADD_GROUP       ="ttapr04";
public static final String HELP_PRIV_SCHEMA_ADD_USER       ="tscpr03";//@d81142jal
public static final String HELP_PRIV_SCHEMA_ADD_GROUP      ="tscpr04";//@d81142jal
public static final String HELP_PRIV_VIEW_ADD_USER         ="tvwpr02";
public static final String HELP_PRIV_VIEW_ADD_GROUP        ="tvwpr04";
public static final String HELP_PRIV_INDEX_ADD_USER        ="tinpr03";//@d81142jal
public static final String HELP_PRIV_INDEX_ADD_GROUP       ="tinpr04";//@d81142jal
public static final String HELP_PRIV_TABLESPACE_ADD_USER   ="tatspr03h";//@d133174wl
public static final String HELP_PRIV_TABLESPACE_ADD_GROUP  ="tatspr04h";//@d133174wl


public static final String HELP_USER_ADD_DATABASE_PRIV     ="purcr01";
public static final String HELP_USER_ADD_SCHEMA_PRIV       ="turcr03";
public static final String HELP_USER_ADD_TABLE_PRIV        ="turcr04";
public static final String HELP_USER_ADD_INDEX_PRIV        ="turcr05";
public static final String HELP_USER_ADD_VIEW_PRIV         ="turcr06";
public static final String HELP_USER_ADD_TABLESPACE_PRIV   ="urcrtsuserh";//@d133174wl
public static final String HELP_USER_CHANGE_DATABASE_PRIV  ="tural01";
public static final String HELP_USER_CHANGE_SCHEMA_PRIV    ="tural02";
public static final String HELP_USER_CHANGE_TABLE_PRIV     ="tural03";
public static final String HELP_USER_CHANGE_INDEX_PRIV     ="tural04";
public static final String HELP_USER_CHANGE_VIEW_PRIV      ="tural05";
public static final String HELP_USER_CHANGE_TABLESPACE_PRIV="uraltatsuserh";//@d133174wl
public static final String HELP_USER_ADD_SCHEMA            ="purcr02";
public static final String HELP_USER_ADD_TABLE             ="purcr03";
public static final String HELP_USER_ADD_INDEX             ="purcr04";
public static final String HELP_USER_ADD_VIEW              ="purcr05";
public static final String HELP_USER_ADD_TABLESPACE        ="addtswin2";//@d133174wl

public static final String HELP_GROUP_ADD_DATABASE_PRIV    ="pugcr01";
public static final String HELP_GROUP_ADD_SCHEMA_PRIV      ="tugcr03";
public static final String HELP_GROUP_ADD_TABLE_PRIV       ="tugcr04";
public static final String HELP_GROUP_ADD_INDEX_PRIV       ="tugcr05";
public static final String HELP_GROUP_ADD_VIEW_PRIV        ="tugcr06";
public static final String HELP_GROUP_ADD_TABLESPACE_PRIV  ="ugalta7agh";//@d133174wl
public static final String HELP_GROUP_CHANGE_DATABASE_PRIV ="ugalpg1";//@d81142jal
public static final String HELP_GROUP_CHANGE_SCHEMA_PRIV   ="ugalpg2";//@d81142jal
public static final String HELP_GROUP_CHANGE_TABLE_PRIV    ="ugalpg3";//@d81142jal
public static final String HELP_GROUP_CHANGE_INDEX_PRIV    ="ugalpg4";//@d81142jal
public static final String HELP_GROUP_CHANGE_VIEW_PRIV     ="ugalpg5";//@d81142jal
public static final String HELP_GROUP_CHANGE_TABLESPACE_PRIV ="ugaltatsuse";//@d133174wl
public static final String HELP_GROUP_ADD_SCHEMA           ="pugcr02";
public static final String HELP_GROUP_ADD_TABLE            ="pugcr03";
public static final String HELP_GROUP_ADD_INDEX            ="pugcr04";
public static final String HELP_GROUP_ADD_VIEW             ="pugcr05";
public static final String HELP_GROUP_ADD_TABLESPACE       ="addtswin2";//@d133174wl

public static final String HELP_SELECT_GRANT_OPTION        ="uicomp10";
                                                                 //>@d80006jal
//Database - Backup             //@d81866sb
public static final String HELP_DB_BACKUP_MEDIA_PAGE       ="tadbbu01";
public static final String HELP_DB_BACKUP_OPTIONS_PAGE     ="dbbup02";

//Database - Restore
public static final String HELP_DB_RESTORE_CNR_PAGE        ="tadbrs03";
public static final String HELP_DB_RESTORE_RFD_PAGE        ="tadbrs04";
public static final String HELP_DB_RESTORE_OPT_PAGE        ="tadbrs06";

//Database - Create from Backup
public static final String HELP_DB_CFB_DESC_PAGE           ="tadbcb01";
public static final String HELP_DB_CFB_IMAGE_PAGE          ="tadbcb02";
public static final String HELP_DB_CFB_CNR_PAGE            ="tadbcb03";
public static final String HELP_DB_CFB_RFD_PAGE            ="tadbcb04";
public static final String HELP_DB_CFB_OPT_PAGE            ="tadbcb06";

//Database - Restore to new
public static final String HELP_DB_RTN_IMAGE_PAGE          ="tadbnw01";
public static final String HELP_DB_RTN_CNR_PAGE            ="tadbnw02";
public static final String HELP_DB_RTN_DESC_PAGE           ="tadbnw05";
public static final String HELP_DB_RTN_RFD_PAGE            ="tadbnw03";
public static final String HELP_DB_RTN_OPT_PAGE            ="tadbnw06";

//Database - Rollforward
public static final String HELP_DB_RFD_RFD_PAGE            ="pdbrf01";
public static final String HELP_DB_RFD_TSP_PAGE            ="tadbrf03";
public static final String HELP_DB_RFD_OPT_PAGE            ="cdbrf01";

//Database - Restart
public static final String HELP_DB_RESTART_DLG             ="tdbrsdb";       //@d99580wl

//Database - GenerateDDL
public static final String HELP_DB_GENERATE_DDL            ="tddl1";              //@d100735pwk //@d103219ssc

//Tablespace - Backup
public static final String HELP_TSP_BACKUP_MEDIA_PAGE      ="ttsbu01";
public static final String HELP_TSP_BACKUP_OPTIONS_PAGE    ="ctsbu01";

//Tablespace - Restore
public static final String HELP_TSP_RESTORE_RFD_PAGE       ="ttsrs03";
public static final String HELP_TSP_RESTORE_OPT_PAGE       ="ctsrs01";

//Tablespace - Rollforward
public static final String HELP_TSP_RFD_RFD_PAGE           ="ptsrf01";
public static final String HELP_TSP_RFD_OPT_PAGE           ="ctsrf01";

//Recovery History - Restore
public static final String HELP_RH_RESTORE_IMAGE_PAGE      ="tadbrs01";
public static final String HELP_RH_RESTORE_OPTIONS_PAGE    ="tadbrs06";

//Alias, View, Index
public static final String HELP_ALTER_ALIAS                ="talal01";
public static final String HELP_CREATE_ALIAS               ="talcr01";
public static final String HELP_ALTER_VIEW                 ="tvwal01";
public static final String HELP_CREATE_VIEW                ="tvwcr01";
public static final String HELP_SHOW_RELATED_VIEWS         ="tvwsr01";
public static final String HELP_SAMPLE_VIEW_CONTENTS       ="tvwcn01";
public static final String HELP_ALTER_INDEX                ="tinal01";
public static final String HELP_CREATE_INDEX               ="tincr01";

//Table
public static final String HELP_TB_ALTER_OVERVIEW          ="otaal01";
public static final String HELP_TB_ALTER_TABLE_PAGE        ="ttaal01";
public static final String HELP_TB_ALTER_ADD_COLUMN        ="ttaal03";
public static final String HELP_TB_ALTER_CHANGE_COL_COMMENT="ttaal05";
public static final String HELP_TB_ALTER_CHANGE_COLUMN_NEW ="ttaal06";
public static final String HELP_TB_ALTER_SELECT_COLUMN     ="ttaal07";
public static final String HELP_TB_ALTER_EDIT_COLUMN_LIST  ="ttaal08";
public static final String HELP_TB_ALTER_ADD_FOREIGN_KEY   ="ttaal14";
public static final String HELP_TB_ALTER_CHANGE_FOREIGN_KEY="ttaal16";
public static final String HELP_TB_ALTER_ADD_CHECK_CONST   ="ttaal18";
public static final String HELP_TB_ALTER_CHANGE_CHECK_CONST="ttaal20";
public static final String HELP_TB_ALTER_COLUMN_PAGE       ="ptaal01";
public static final String HELP_TB_ALTER_ADD_COLUMN_2      ="ptaal02";
public static final String HELP_TB_ALTER_CHANGE_COLUMN_2   ="ptaal03";
public static final String HELP_TB_ALTER_PRIMARY_KEY_PAGE  ="ptaal04";
public static final String HELP_TB_ALTER_PARTITION_KEY_PAGE="ptaal05";
public static final String HELP_TB_ALTER_FOREIGN_KEY_PAGE  ="ptaal06";
public static final String HELP_TB_ALTER_CHECK_CONST_PAGE  ="ptaal07";
//
public static final String HELP_TB_CREATE_OVERVIEW         ="otacr01";
public static final String HELP_TB_CREATE_TABLE_PAGE       ="ttacr01";
public static final String HELP_TB_CREATE_SELECT_COLUMN    ="ttacr03";
public static final String HELP_TB_CREATE_EDIT_COLUMN_LIST ="ttacr04";
public static final String HELP_TB_CREATE_PRIMARY_KEY_PAGE ="ttacr05";
public static final String HELP_TB_CREATE_PARTITION_KEY_PAGE ="ttacr06";
public static final String HELP_TB_CREATE_FOREIGN_KEY_PAGE ="ttacr07";
public static final String HELP_TB_CREATE_CHECK_CONST_PAGE ="ttacr08";
public static final String HELP_TB_CREATE_COLUMN_PAGE      ="ptacr01";
public static final String HELP_TB_CREATE_ADD_COLUMN       ="ptacr02";
public static final String HELP_TB_CREATE_CHANGE_COLUMN    ="ptacr03";
public static final String HELP_TB_CREATE_ADD_COLUMN_2     ="ptacr04";
public static final String HELP_TB_CREATE_CHANGE_COLUMN_2  ="ptacr05";
public static final String HELP_TB_CREATE_ADD_FOREIGN_KEY   ="ptacr06";
public static final String HELP_TB_CREATE_CHANGE_FOREIGN_KEY="ptacr07";
public static final String HELP_TB_CREATE_ADD_CHECK_CONST   ="ptacr08";
public static final String HELP_TB_CREATE_CHANGE_CHECK_CONST="ptacr09";
//
public static final String HELP_TB_EXPORT_OVERVIEW         ="otaex01";
public static final String HELP_TB_EXPORT_FILE_PAGE        ="ttaex101";
public static final String HELP_TB_EXPORT_LARGE_OBJ_PAGE   ="ttaex201";
public static final String HELP_TB_EXPORT_COLUMN_PAGE      ="ttaex301";
public static final String HELP_TB_EXPORT_DEL_OPTIONS      ="ttaex102";
public static final String HELP_TB_EXPORT_WSF_OPTIONS      ="ttaex103";
public static final String HELP_TB_EXPORT_ADD_LOB_PATH     ="ttaex202";
public static final String HELP_TB_EXPORT_CHANGE_LOB_PATH  ="ttaex203";
public static final String HELP_TB_EXPORT_ADD_LOB_FILE     ="ttaex204";
public static final String HELP_TB_EXPORT_CHANGE_LOB_FILE  ="ttaex205";
public static final String HELP_TB_EXPORT_ADD_COLUMN       ="ttaex302";
public static final String HELP_TB_EXPORT_CHANGE_COLUMN    ="ttaex303";
//
public static final String HELP_TB_IMPORT_OVERVIEW         ="otima01";
public static final String HELP_TB_IMPORT_ASC_OPTIONS      ="ttima201";
public static final String HELP_TB_IMPORT_DEL_OPTIONS      ="ttima202";
public static final String HELP_TB_IMPORT_WSF_OPTIONS      ="ttima203";
public static final String HELP_TB_IMPORT_IXF_OPTIONS      ="ttima204";
public static final String HELP_TB_IMPORT_ADD_LOB          ="ttima301";
public static final String HELP_TB_IMPORT_CHANGE_LOB       ="ttima302";
public static final String HELP_TB_IMPORT_CHANGE_COL_POS   ="ttima401";
public static final String HELP_TB_IMPORT_CHANGE_COL_LOC   ="ttima402";
public static final String HELP_TB_IMPORT_CHANGE_COL_NAME  ="ttima403";
public static final String HELP_TB_IMPORT_FILE_PAGE        ="ptaimf01";
public static final String HELP_TB_IMPORT_LARGE_OBJ_PAGE   ="ptaiml01";
public static final String HELP_TB_IMPORT_COLUMN_PAGE      ="ptaimc01";
public static final String HELP_TB_IMPORT_OVERVIEW_CRT     ="ttimb101";
public static final String HELP_TB_IMPORT_FILE_PAGE_CRT    ="ttimb102";
public static final String HELP_TB_IMPORT_LARGE_OBJ_PAGE_CRT ="ttimb103";
public static final String HELP_TB_IMPORT_COLUMN_PAGE_CRT  ="ttimb104";
public static final String HELP_TB_IMPORT_COL_PG_CHG_COL   ="ttimb105";
public static final String HELP_TB_IMPORT_COL_PG_ADD_COL   ="ttimb106";
//
public static final String HELP_TB_LOAD_OVERVIEW           ="otald01";
public static final String HELP_TB_LOAD_FILE_PAGE          ="ttald01";
public static final String HELP_TB_LOAD_STAT_PAGE          ="ttald06";
public static final String HELP_TB_LOAD_COPY_PAGE          ="ttald07";
public static final String HELP_TB_LOAD_OTHER_PAGE         ="ttald08";
public static final String HELP_TB_LOAD_ASC_OPTIONS        ="ttald09";
public static final String HELP_TB_LOAD_DEL_OPTIONS        ="ttald10";
public static final String HELP_TB_LOAD_IXF_OPTIONS        ="ttald11";
public static final String HELP_TB_LOAD_COLUMN_PAGE        ="ptald01";
public static final String HELP_TB_LOAD_COUNT_PAGE         ="ptald02";
public static final String HELP_TB_LOAD_ADD_CHANGE         ="ptald03";
public static final String HELP_TB_LOAD_CHANGE_COL_POS     ="ptald04";
public static final String HELP_TB_LOAD_CHANGE_COL_NAME    ="ptald05";
public static final String HELP_TB_LOAD_CHANGE_COL_NUMBER  ="ptald06";
//
public static final String HELP_TB_DROP_CONFIRM            ="ttadr01";
public static final String HELP_TB_QUIESCE                 ="ttaqu01";
public static final String HELP_TB_COPY                    ="ttacp01";
public static final String HELP_TB_RENAME                  ="ttarn01";
public static final String HELP_TB_REORGANIZE              ="ttarg01";
public static final String HELP_TB_RUN_STATS               ="ttart01";
public static final String HELP_TB_SET_CONSTRAINT          ="ptasc01";
public static final String HELP_TB_SAMPLE_CONTENT          ="ttacn01";
public static final String HELP_TB_RELATED_VIEW            ="tvwsr01";

//
// VE operator help begin @d82747wl
public static final String HELP_CMPEXP_OP                  ="cncp52";
public static final String HELP_DELETE_OP                  ="cncp53";
public static final String HELP_FETCH_OP                   ="cncp54";
public static final String HELP_FILTER_OP                  ="cncp55";
public static final String HELP_GENROW_OP                  ="cncp56";
public static final String HELP_GRPBY_OP                   ="cncp57";
public static final String HELP_INSERT_OP                  ="cncp58";
public static final String HELP_IXAND_OP                   ="cncp59";
public static final String HELP_IXSCAN_OP                  ="cncp60";
public static final String HELP_MSJOIN_OP                  ="cncp61";
public static final String HELP_NLJOIN_OP                  ="cncp62";
public static final String HELP_PIPE_OP                    ="cncp63";
public static final String HELP_RETURN_OP                  ="cncp64";
public static final String HELP_RIDSCAN_OP                 ="cncp65";
public static final String HELP_SORT_OP                    ="cncp66";
public static final String HELP_TBSCAN_OP                  ="cncp67";
public static final String HELP_TEMP_OP                    ="cncp68";
public static final String HELP_TQUEUE_OP                  ="cncp69";
public static final String HELP_UNION_OP                   ="cncp70";
public static final String HELP_UNIQUE_OP                  ="cncp71";
public static final String HELP_UPDATE_OP                  ="cncp72";
public static final String HELP_HSJOIN_OP                  ="cncp73";
public static final String HELP_RQUERY_OP                  ="cncp74";
public static final String HELP_EISCAN_OP                  ="cncp75"; //@d126132wl
// VE operator help end @d82747wl

//Trigger and UDT
public static final String HELP_ALTER_TRIGGER              ="ttral01";
public static final String HELP_ALTER_TRIGGERED_ACTION     ="ttral02";
public static final String HELP_CREATE_TRIGGER             ="ttrcr01";
public static final String HELP_CREATE_TRIGGERED_ACTION    ="ttrcr02";
public static final String HELP_CREATE_DISTINCT_TYPE       ="tudtdr01";

public static final String HELP_INDEX                      ="idx";  // @d105994jdr
public static final String HELP_USING                      ="conhow2";  // @d85073mak

public static final String HELP_PREFILTER                  ="tpfilt01"; // @d88298al

// Performance Monitor HELP
public static final String HELP_PM_SHOW_MONITOR            ="ovpm18";
public static final String HELP_PM_CLASS_NAME_PAGE         ="tapm51";
public static final String HELP_PM_PARTITION_PAGE          ="tapm51";
public static final String HELP_PM_DETAILS_PAGE            ="tapm53";
public static final String HELP_PM_WHAT_PAGE               ="tapm54";
public static final String HELP_PM_ADD_WHAT_COLLECT        ="tapm50";
public static final String HELP_PM_GRAPH_PAGE              ="tapm55";
public static final String HELP_PM_THRESHOLD_PAGE          ="tapm56";
public static final String HELP_PM_GRAPH_SETTING_PAGE      ="tapm57";
public static final String HELP_PM_LIST_MONITOR            ="ovpm14";
public static final String HELP_PM_LIST_MONITORED_OBJ      ="tapm15";
public static final String HELP_PM_CHANGE_MONITOR          ="ovpm11";
public static final String HELP_PM_SAVE_MONITOR            ="tapm17";
public static final String HELP_PM_SAVE_AS                 ="tapm17";   //@d110436abm
public static final String HELP_PM_COPY_MONITOR            ="tapm12";
public static final String HELP_PM_RENAME_MONITOR          ="tapm20";
public static final String HELP_PM_CREATE_MONITOR          ="ovpm13";
public static final String HELP_PM_START_MONITOR           ="tapm17";   //@d99085shg
public static final String HELP_PM_CHANGE_DEFAULT          ="tapm10";
public static final String HELP_PM_APPLICATION_NOTEBOOK    ="ovpm";     //@d119860jse
public static final String HELP_PM_LIST_APPLICATION        ="tapm59";
public static final String HELP_PM_LIST_DCS_APPLICATION    ="tapm60";
public static final String HELP_PM_SELECT_SCRIPT_FOR_ALERT ="tapm58";   //@d99085shg
// End of Performance Monitor HELP
// Estimate Size Dialog HELP
public static final String HELP_ESTIMATE_SIZE              ="tsize1"; //@d103219ssc
// End of Estimate Size Dialog HELP

public static final String HELP_SHOW_SQL                   = "tscmd1"; //@d109480bc  //@d117844mjm

// Satellite Administration HELP                                 //<@f99950jal
public static final String HELP_SAT_SAC                  = "suscsawr";
public static final String HELP_SAT_COPY_BATCH           = "tascbacp";
public static final String HELP_SAT_CREATE_BATCH         = "tascbacr";
public static final String HELP_SAT_EDIT_BATCH           = "tascbaed";
public static final String HELP_SAT_VIEW_BATCH           = "tascbavw";
public static final String HELP_SAT_CREATE_SAT           = "suscsacr";
public static final String HELP_SAT_FIX_SAT              = "tascsarf";
public static final String HELP_SAT_EDIT_SAT             = "tascsaed";
public static final String HELP_SAT_PROMOTE_SAT          = "tascsapm";
public static final String HELP_SAT_SET_EXEC_START_POINT = "tascsasl";
public static final String HELP_SAT_CHANGE_LEVEL         = "tascaped";
public static final String HELP_SAT_VIEW_LEVEL           = "tascapvw";
public static final String HELP_SAT_EDIT_SCRIPT          = "tascsced";
public static final String HELP_SAT_CREATE_GROUP         = "suscgrcr";
public static final String HELP_SAT_EDIT_GROUP           = "tascgred";
public static final String HELP_SAT_CREATE_TARGET        = "tasctrcr";
public static final String HELP_SAT_EDIT_TARGET          = "tasctred";
public static final String HELP_SAT_CREATE_AUTH          = "tascaucr";
public static final String HELP_SAT_EDIT_AUTH            = "tascaued";
public static final String HELP_SAT_CREATE_SUCCESS_CODE  = "tascsucr";
public static final String HELP_SAT_EDIT_SUCCESS_CODE    = "tascsued";
public static final String HELP_SAT_ADD_SCRIPT           = "tascspad";
public static final String HELP_SAT_IMPORT_SCRIPTS       = "tascspim";
public static final String HELP_SAT_EDIT_PROPERTY        = "tascsped";
public static final String HELP_SAT_LOG_DETAILS          = "csclgdet";
public static final String HELP_SAT_SELECT_AUTH          = "tascausl";//<@f100167jal
public static final String HELP_SAT_SELECT_BATCHSTEP     = "tascbasl";
public static final String HELP_SAT_SELECT_SERVER_TARGET = "tasctrsl";
public static final String HELP_SAT_SELECT_DATABASE      = "tascdbsl";
public static final String HELP_SAT_SELECT_BATCH         = "tascbasb";
public static final String HELP_SAT_SELECT_SUCCESS_CODE_SET = "tascsscs";
public static final String HELP_SAT_ENABLE_SAT           = "cscsaenb";
public static final String HELP_SAT_DISABLE_SAT          = "cscsadsb";
public static final String HELP_SAT_ENABLE_GROUP         = "cscgrenb";
public static final String HELP_SAT_DISABLE_GROUP        = "cscgrdsb";
public static final String HELP_SAT_RENAME_GROUP         = "tascgrrn";
public static final String HELP_SAT_RENAME_SCRIPT        = "tascscrn";
public static final String HELP_SAT_COPY_GROUP           = "tascgrcp";
public static final String HELP_SAT_COPY_SAT             = "tascsacp";
public static final String HELP_SAT_COPY_SCRIPT          = "tascsccp";
public static final String HELP_SAT_EDIT_APP_VER         = "tascaved";//>@f100167jal
public static final String HELP_SAT_LIST_SATELLITES      = "cscsscs"; // @d102952al
public static final String HELP_SAT_CHG_REPL_PARAMS      = "tarprpcg";//<@d103043jal
public static final String HELP_SAT_EDIT_WHERE_CLAUSE    = "tascrpcd";
public static final String HELP_SAT_CREATE_APP_VERSION   = "tascavcr";
public static final String HELP_SAT_CREATE_SCRIPT        = "cscsced";
public static final String HELP_SAT_DELETE_ALL_REPL_SUBS = "tascrpdz";
public static final String HELP_SAT_GENERALIZE_REPL_SUB  = "tascrpgr";
public static final String HELP_SAT_IMPORT_SCRIPT        = "tascscim";
public static final String HELP_SAT_PROMOTE_REPL_SOURCE  = "tascprpt";
public static final String HELP_SAT_PROMOTE_REPL_SUB     = "tascprps";
public static final String HELP_SAT_SELECT_SATELLITES    = "tascsass";//>@d103043jal
public static final String HELP_SAT_SHOW_LOGS_TEMP       = "ctlsct22";//@d107505jal
public static final String HELP_SAT_SELECT_TARGET_TEMP   = "csctacl";//@d106130jal
// End of Satellite Administration HELP                          //>@f99950jal

// Start of License Center Online HELP                               //d104609awh
public static final String HELP_LC_MAIN_OVERVIEW         = "hoverlc";//d104609awh
public static final String HELP_LC_CHANGE                = "hchange";//d104609awh
public static final String HELP_LC_ADD_USER              = "haddus"; //d104609awh
public static final String HELP_LC_REMOVE_USER           = "hremus"; //d104609awh
// End of License Center Online Help                                 //d104609awh

//b@d104456ys
// Multisite update smartguide
public static final String HELP_SG_SPM               = "tainst";
// Mutlisite update test & test result dialogs
public static final String HELP_SPM_TEST             = "taspmtst";
//e@d1054456ys

// Start of DWC Schedule Notebook HELP                               //<@d128156abm
public static final String HELP_DWC_SN_NOTEBOOK          = "scheduledialog";
public static final String HELP_DWC_SN_SCHEDULE_PAGE     = "scheduledialogschedule";
public static final String HELP_DWC_SN_TASKFLOW_PAGE     = "scheduledialogtaskflow";
public static final String HELP_DWC_SN_NOTIFICATION_PAGE = "scheduledialognotification";
public static final String HELP_DWC_SN_SELECT_USERS      = "modifyusersdialog";
public static final String HELP_DWC_SN_EDIT_MESSAGE      = "editmessagedialog";
public static final String HELP_DWC_SN_PROC_CONFIRM      = "editmessagedialog";
// End of DWC Schedule Notebook HELP                               //<@d128156abm

//Adding VSE & VM Help Files                                       //<@d126245gm
public static final String HELP_VSEVM_DBSPC_RUN_STAT     = "taudsvm";
public static final String HELP_VSEVM_CREATE_INDEX       = "taincrvm";
public static final String HELP_VSEVM_REORG_INDEX        = "tainrevm";
public static final String HELP_VSEVM_TABLE_RUN_STAT   = "tautsvm";
//End of Adding VSE & VM Help Files                                //>@d126245gm

// start of DWC schema modeler help                              //<@d131498rac
public static final String HELP_DWC_SM_MODELER           = "warehouseschemamodeldialog";
public static final String HELP_DWC_SM_PROPERTIES        = "starschemapropertiesdialog";
public static final String HELP_DWC_SM_EXPORT            = "exportstarschemadialog";
// end of DWC schema modeler help                                //>@d131498rac

// DWC Control DB Management Dialog
  public static final String HELP_DWC_CDB_MANAGE            = "controldbmanage"; //@d137996tkl
// End Control DB Management Dialog

// Warehouse Center General Help
  public static final String WAREHOUSECENTER_GENERAL        = "dwcmain"; //@d138046mjm
  public static final String PROCESS_GENERAL_HELP           = "processmodelerframe"; //@d138046mjm
// End Warehouse Center General Help


}
