/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AFileChooser
extends JDialog {
    AFileTree tree;
    public JTextField displayTextField;
    private JLabel displayLabel;
    public int retCode = 1;
    public JFrame owner;
    private ATraceFile tf;

    public AFileChooser(JFrame jFrame) {
        super(jFrame, "File Chooser", true);
        this.constructRest(jFrame, false, "");
    }

    public AFileChooser(JFrame jFrame, boolean bl) {
        super(jFrame, "File Chooser", true);
        this.constructRest(jFrame, bl, "");
    }

    public AFileChooser(JFrame jFrame, String string) {
        super(jFrame, "Directory Chooser", true);
        this.constructRest(jFrame, false, string);
    }

    public AFileChooser(JFrame jFrame, boolean bl, String string) {
        super(jFrame, "File Chooser", true);
        this.constructRest(jFrame, bl, string);
    }

    public void constructRest(JFrame jFrame, boolean bl, String string) {
        JPanel jPanel;
        JPanel jPanel2;
        this.owner = jFrame;
        this.tf = new ATraceFile(this);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.tree = new AFileTree(jFrame, bl);
        JPanel jPanel3 = jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel3, this.tree);
        String string2 = "File name:";
        if (!bl) {
            string2 = "Directory name:";
        }
        this.displayLabel = new JLabel(string2);
        this.displayTextField = new JTextField(80);
        this.displayTextField.setText("");
        this.displayTextField.setEditable(true);
        this.displayTextField.setVisible(true);
        JPanel jPanel4 = jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.displayLabel);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.displayTextField);
        JPanel jPanel5 = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 20, 0);
            }
        };
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jButton.setMnemonic('O');
        jButton2.setMnemonic('C');
        jPanel5.add((Component)jButton, "East");
        jPanel5.add((Component)jButton2, "West");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AFileChooser.this.getSelectedPath().length() == 0) {
                    return;
                }
                AFileChooser.this.retCode = 0;
                AFileChooser.this.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AFileChooser.this.retCode = 1;
                AFileChooser.this.dispose();
            }
        });
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel5);
        APropertyChangeListener aPropertyChangeListener = new APropertyChangeListener();
        this.tree.addPropertyChangeListener(aPropertyChangeListener);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AFileChooser.this.retCode = 1;
                AFileChooser.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        ((Component)this).setSize(400, 300);
        this.setLocationRelativeTo(jFrame);
        if (string.length() > 0) {
            this.setDefaultPath(string);
        }
        ((Component)this).setVisible(true);
    }

    public void setDefaultPath(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                AFileChooser.this.tree.setDefaultPath(string2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public String getSelectedPath() {
        return this.displayTextField.getText().trim();
    }

    private void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    class APropertyChangeListener
    implements PropertyChangeListener {
        APropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Directory")) {
                String string2 = (String)propertyChangeEvent.getOldValue();
                AFileChooser.this.displayTextField.setText(string2);
            }
        }
    }
}

