/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class AFontChooser
extends JDialog
implements ActionListener,
Runnable {
    JColorChooser colorChooser;
    JComboBox fontName;
    JCheckBox fontBold;
    JCheckBox fontItalic;
    JTextField fontSize;
    JLabel previewLabel;
    SimpleAttributeSet attributes;
    Font newFont;
    Color newColor;

    public AFontChooser(Frame frame) {
        super(frame, "Font Chooser", true);
        ((Component)this).setSize(400, 400);
        ((Component)this).setLocation(frame.getX() + 20, frame.getY() + 20);
        this.run();
    }

    public void run() {
        this.attributes = new SimpleAttributeSet();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AFontChooser.this.closeAndCancel();
            }
        });
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        this.fontName = new JComboBox<String>(new String[]{"TimesRoman", "Helvetica", "Courier"});
        this.fontName.setSelectedIndex(1);
        this.fontName.addActionListener(this);
        this.fontSize = new JTextField("12", 4);
        this.fontSize.setHorizontalAlignment(4);
        this.fontSize.addActionListener(this);
        this.fontBold = new JCheckBox("Bold");
        this.fontBold.setSelected(true);
        this.fontBold.addActionListener(this);
        this.fontItalic = new JCheckBox("Italic");
        this.fontItalic.addActionListener(this);
        jPanel.add(this.fontName);
        jPanel.add(new JLabel(" Size: "));
        jPanel.add(this.fontSize);
        jPanel.add(this.fontBold);
        jPanel.add(this.fontItalic);
        container.add((Component)jPanel, "North");
        this.colorChooser = new JColorChooser(Color.black);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AFontChooser.this.updatePreviewColor();
            }
        });
        container.add((Component)this.colorChooser, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.previewLabel = new JLabel("Here's a sample of this font.");
        this.previewLabel.setForeground(this.colorChooser.getColor());
        jPanel2.add((Component)this.previewLabel, "Center");
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AFontChooser.this.closeAndSave();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AFontChooser.this.closeAndCancel();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel2.add((Component)jPanel3, "South");
        jPanel2.setMinimumSize(new Dimension(100, 100));
        jPanel2.setPreferredSize(new Dimension(100, 100));
        container.add((Component)jPanel2, "South");
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!StyleConstants.getFontFamily(this.attributes).equals(this.fontName.getSelectedItem())) {
            StyleConstants.setFontFamily(this.attributes, (String)this.fontName.getSelectedItem());
        }
        if (StyleConstants.getFontSize(this.attributes) != Integer.parseInt(this.fontSize.getText())) {
            StyleConstants.setFontSize(this.attributes, Integer.parseInt(this.fontSize.getText()));
        }
        if (StyleConstants.isBold(this.attributes) != this.fontBold.isSelected()) {
            StyleConstants.setBold(this.attributes, this.fontBold.isSelected());
        }
        if (StyleConstants.isItalic(this.attributes) != this.fontItalic.isSelected()) {
            StyleConstants.setItalic(this.attributes, this.fontItalic.isSelected());
        }
        this.updatePreviewFont();
    }

    protected void updatePreviewFont() {
        String string = StyleConstants.getFontFamily(this.attributes);
        boolean bl = StyleConstants.isBold(this.attributes);
        boolean bl2 = StyleConstants.isItalic(this.attributes);
        int n = StyleConstants.getFontSize(this.attributes);
        Font font = new Font(string, (bl ? 1 : 0) + (bl2 ? 2 : 0), n);
        this.previewLabel.setFont(font);
    }

    protected void updatePreviewColor() {
        this.previewLabel.setForeground(this.colorChooser.getColor());
        this.previewLabel.repaint();
    }

    public Font getNewFont() {
        return this.newFont;
    }

    public Color getNewColor() {
        return this.newColor;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public void closeAndSave() {
        this.newFont = this.previewLabel.getFont();
        this.newColor = this.previewLabel.getForeground();
        ((Component)this).setVisible(false);
    }

    public void closeAndCancel() {
        this.newFont = null;
        this.newColor = null;
        ((Component)this).setVisible(false);
    }
}

