/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AMigrate
extends JDialog {
    private JLabel sourceLabel;
    private JLabel targetLabel;
    private JLabel infoLabel;
    private JTextField sourceField;
    private JButton sourcePathButton;
    public String targetRepository;
    private Vector aRepositoryList;
    public int retCode = 0;
    private static boolean standAlone = false;
    private String sourcePath = "";
    private String targetPath = "";
    private AMainWindow owner;
    private ATraceFile tf;

    public static void main(String[] stringArray) {
        standAlone = true;
        AMigrate aMigrate = new AMigrate(null, false);
    }

    public AMigrate(AMainWindow aMainWindow, boolean bl) {
        super((Frame)aMainWindow, bl);
        JPanel jPanel;
        JPanel jPanel2;
        this.setTitle("SCL - Migrate");
        ((Component)this).setSize(new Dimension(650, 650));
        this.setResizable(true);
        this.owner = aMainWindow;
        this.tf = new ATraceFile(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - 325, dimension.height / 2 - 325);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JPanel jPanel4 = jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.infoLabel = new JLabel();
        String string = "<H3>Migrate V3.x Files</H3><P>This function will migrate repository definitions and catalog files used by the older versions of the Softcopy Librarian.</P>";
        String string2 = "";
        if (AMainWindow.userProperties.isMigrationDone() && aMainWindow.listWindow.aRepositoryList.size() > 0) {
            string2 = "<P><P><B>WARNING:</B> Repositories have already been migrated. These repository definitions will be <B>lost</B> if you continue with the migration.</P>";
            string = string + string2;
        } else if (!AMainWindow.userProperties.isMigrationDone() && aMainWindow.listWindow.aRepositoryList.size() > 0) {
            string2 = "<P><P><B>WARNING:</B> You may have already created new repositories. These repository definitions will be <B>lost</B> if you continue with the migration.</P>";
            string = string + string2;
        }
        String string3 = "<P><P>1) Identify the old work directory. The default work directory was C:\\Program Files\\IBM\\IBM Softcopy Librarian\\output You may have installed the Librarian elsewhere, or you may have changed the work directory to another drive. To find the old work directory: <LI>Start the old Librarian</LI><LI>Click on <I>Setup->Share work files</I></LI><LI>The contents of the input field in that window is the old work directory</LI></P>";
        string = string + string3;
        this.infoLabel.setText("<html>" + string + "</html>");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel4, this.infoLabel);
        JPanel jPanel5 = jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel5.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        this.sourceLabel = new JLabel();
        this.sourceLabel.setText("<html><P>2) Enter the old work directory here:</P><html>");
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(10, 10, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel5, this.sourceLabel);
        this.sourceField = new JTextField();
        this.sourceField.setText("C:\\Program Files\\IBM\\IBM SoftCopy Librarian\\output\\");
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.insets = new Insets(0, 40, 20, 10);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel5, this.sourceField);
        this.sourcePathButton = new JButton("Browse");
        this.sourcePathButton.setVerticalAlignment(1);
        final AMainWindow aMainWindow2 = aMainWindow;
        this.sourcePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AFileChooser aFileChooser = new AFileChooser(aMainWindow2);
                int n = aFileChooser.retCode;
                if (n == 0) {
                    AMigrate.this.sourceField.setText(aFileChooser.getSelectedPath());
                }
            }
        });
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 10, 20, 10);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel5, this.sourcePathButton);
        string = "<P>3) Ensure the old Librarian is closed</P><P>4) Things you may want to do after migration is complete: <LI>Re-create the catalogs, which will fill in new fields.</LI><LI>Use <I>File->Properties</I> to enter FTP userid and password for each repository.</LI><LI>You can continue to use the old Librarian, but any changes you make with one Librarian will not be known to the other.</LI></P>";
        this.targetLabel = new JLabel();
        this.targetLabel.setText("<html>" + string + "</html>");
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.insets = new Insets(10, 10, 20, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel5, this.targetLabel);
        JPanel jPanel6 = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 20, 0);
            }
        };
        JButton jButton = new JButton("Migrate");
        jButton.setMnemonic('M');
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic('C');
        jPanel6.add((Component)jButton, "West");
        jPanel6.add((Component)jButton2, "East");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ASwingWorker aSwingWorker = new ASwingWorker(this, "Migration"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public Object construct() {
                        3.access$100(this.this$1).retCode = 0;
                        AStatusWindow.write("Migrating ...");
                        3.access$100(this.this$1).setCursor(Cursor.getPredefinedCursor(3));
                        boolean bl = AMigrate.access$200(3.access$100(this.this$1));
                        3.access$100(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                        if (bl) {
                            AStatusWindow.write("Migration done.");
                            if (AMigrate.access$300()) {
                                System.exit(0);
                            } else {
                                3.access$100(this.this$1).dispose();
                            }
                        }
                        return null;
                    }
                };
            }

            static /* synthetic */ AMigrate access$100(3 var0) {
                return var0.AMigrate.this;
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AMigrate.this.retCode = 1;
                if (standAlone) {
                    System.exit(0);
                } else {
                    AMigrate.this.dispose();
                }
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AMigrate.this.retCode = 1;
                if (standAlone) {
                    System.exit(0);
                } else {
                    AMigrate.this.dispose();
                }
            }
        };
        this.addWindowListener(windowAdapter);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        this.getContentPane().add(jPanel3);
        ((Component)this).setVisible(true);
    }

    private void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private boolean startProcess() {
        boolean bl = true;
        this.sourcePath = AUtilities.strip(this.sourceField.getText().trim(), File.separatorChar) + File.separator;
        this.targetPath = System.getProperty("user.dir") + File.separator + "output" + File.separator;
        this.tf.write("startProcess()", 19, "Source:" + this.sourcePath + ", Target:" + this.targetPath);
        if (!AUtilities.CopyFile(this.sourcePath + "repository.fil", this.targetPath + "repository.fil")) {
            AUtilities.showInfoMessage("<html><P>Repository definitions do not exist in " + this.sourcePath + "</P></html>");
            bl = false;
            return bl;
        }
        try {
            this.aRepositoryList = new Vector();
            if (this.readRepositories(this.targetPath + "repository.fil") > 0) {
                this.tf.write("startProcess()", 0, "Error occurred during process readRepositories");
                bl = false;
                return bl;
            }
            this.writeRepositories(this.targetPath + "repository.fil");
        }
        catch (IOException iOException) {
            this.tf.write("startProcess()", 0, "IOException:" + iOException.toString());
        }
        if (!standAlone) {
            AMainWindow.userProperties.setMigrationDone(true);
        }
        this.reInitialize();
        AUtilities.showInfoMessage(this.owner, "<html>Migration Done<br>For any repositories which you access via FTP,<br>you must enter the userids and optionally the<br>passwords in the Properties of the those repositories</html>");
        return bl;
    }

    private int readRepositories(String string) throws IOException {
        this.tf.write("readRepositories()", 18, "Entry");
        int n = 0;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            this.tf.write("readRepositories()", 0, "IO Exception, Repository file " + string + " not found.");
            return 1;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        String string2 = "";
        String string3 = "";
        string2 = lineNumberReader.readLine();
        if (string2 == null) {
            lineNumberReader.close();
            return n;
        }
        if (!string2.startsWith(ARepository.LABELREPOSITORYVERSION)) {
            return 4;
        }
        string3 = string2.substring(ARepository.LABELREPOSITORYVERSION.length());
        int n2 = new Integer(string3);
        if (n2 >= new Integer(ARepository.REPOSITORYVERSION)) {
            AUtilities.showInfoMessage("<html>Latest repository file</html>");
            n = 4;
            return n;
        }
        string2 = lineNumberReader.readLine();
        if (!string2.startsWith(ARepository.LABELNUMBERREPOSITORIES)) {
            return 4;
        }
        string3 = string2.substring(ARepository.LABELNUMBERREPOSITORIES.length());
        Integer n3 = new Integer(string3);
        int n4 = 0;
        while (n4 < n3) {
            ARepository aRepository = new ARepository("");
            n = aRepository.read(lineNumberReader, n2, true);
            this.tf.write("readRepositories()", 19, "retCode:" + n + ", Rep. Index:" + aRepository.index());
            if (n > 0) {
                n = 2;
                break;
            }
            String string4 = aRepository.catalogFileName();
            int n5 = string4.indexOf(File.separator);
            if (n5 != -1) {
                string4 = string4.substring(n5 + 1);
            }
            if (!AUtilities.CopyFile(this.sourcePath + string4, this.targetPath + string4)) {
                AUtilities.showInfoMessage("Error copying " + this.sourcePath + string4 + " to " + this.targetPath + string4);
                this.tf.write("readRepositories()", 0, "Error copying " + this.sourcePath + string4 + " to " + this.targetPath + string4);
            }
            String string5 = string4.substring(0, string4.indexOf("."));
            File file = new File(this.sourcePath + string5);
            String[] stringArray = file.list();
            if (stringArray == null) {
                AUtilities.showInfoMessage("Cache directory " + this.sourcePath + string5 + " does not exist");
                this.tf.write("readRepositories()", 0, "Cache directory " + this.sourcePath + string5 + " does not exist");
            } else {
                new File(this.targetPath + string5).mkdir();
                int n6 = 0;
                while (n6 < stringArray.length) {
                    File file2 = new File(file, stringArray[n6]);
                    this.tf.write("readRepositories()", 19, "Source:" + file2.getAbsolutePath() + ", Target:" + this.targetPath + string5 + File.separator + file2.getName());
                    AUtilities.CopyFile(file2.getAbsolutePath(), this.targetPath + string5 + File.separator + file2.getName());
                    ++n6;
                }
                n = aRepository.catalog().read(aRepository.catalogFileName());
                if (n == 1) {
                    this.tf.write("readRepositories()", 0, "Catalog file " + aRepository.catalogFileName() + " not found");
                    AUtilities.showInfoMessage("Catalog file " + aRepository.catalogFileName() + " not found");
                    n = 0;
                } else if (n > 1 && n < 5) {
                    this.tf.write("readRepositories()", 0, "Error reading line no. : " + aRepository.catalog().catalogBuffer.getLineNumber());
                    AUtilities.showInfoMessage("Error reading catalog file " + aRepository.catalogFileName() + "<br>" + "Error on line number " + aRepository.catalog().catalogBuffer.getLineNumber());
                }
                this.aRepositoryList.addElement(aRepository);
                this.tf.write("readRepositories()", 19, "Host:" + aRepository.ftpHost() + ", Userid:" + aRepository.ftpUserid());
            }
            ++n4;
        }
        lineNumberReader.close();
        fileReader.close();
        this.tf.write("readRepositories()", 18, "Exit");
        return n;
    }

    public int writeRepositories(String string) {
        this.tf.write("writeRepositories()", 18, "Entry");
        String string2 = string;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n) + ".tmp";
        }
        File file = null;
        try {
            Object object;
            file = new File(string2);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(ARepository.LABELREPOSITORYVERSION + ARepository.REPOSITORYVERSION);
            printStream.println(ARepository.LABELNUMBERREPOSITORIES + this.aRepositoryList.size());
            Enumeration enumeration = this.aRepositoryList.elements();
            while (enumeration.hasMoreElements()) {
                object = (ARepository)enumeration.nextElement();
                int n2 = ((ARepository)object).write(printStream);
                if (n2 > 0) {
                    return n2;
                }
                ((ARepository)object).catalog().write(true);
            }
            printStream.close();
            object = null;
            object = new FileReader(string2);
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            file = new File(string);
            printStream = new PrintStream(new FileOutputStream(file));
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                printStream.println(string3);
            }
            ((InputStreamReader)object).close();
            printStream.close();
            new File(string2).delete();
        }
        catch (IOException iOException) {
            AUtilities.showInfoMessage("Error saving repository file : " + string);
        }
        this.tf.write("writeRepositories()", 18, "Exit");
        return 0;
    }

    private void reInitialize() {
        JInternalFrame[] jInternalFrameArray = this.owner.getDeskTopPane().getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n2];
            if (!jInternalFrame.getTitle().startsWith("Sources and Repositories") && !jInternalFrame.getTitle().startsWith("Messages")) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.owner.listWindow.Refresh();
    }

    static /* synthetic */ boolean access$200(AMigrate aMigrate) {
        return aMigrate.startProcess();
    }
}

