/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.landp.device.internal;

import com.ibm.landp.BadRouterRCException;
import com.ibm.landp.BadServerRCException;
import com.ibm.landp.Cprb;
import com.ibm.landp.InvalidCprbException;
import com.ibm.landp.LandpCommunicationException;
import com.ibm.landp.LandpUtils;
import com.ibm.landp.RmtReq;
import com.jxfs.events.IJxfsEventNotification;
import com.jxfs.events.JxfsException;
import com.jxfs.forum.support.IJxfsServiceJob;
import com.jxfs.forum.support.IQueueResponse;
import com.jxfs.forum.support.QueueControl;
import com.jxfs.general.JxfsConst;
import com.jxfs.general.JxfsLocalDeviceInformation;
import com.jxfs.general.JxfsLogger;
import com.jxfs.general.JxfsStatus;
import com.jxfs.general.JxfsType;
import com.jxfs.general.JxfsVersion;
import com.jxfs.service.IJxfsBaseService;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class LandpDeviceService
implements IJxfsBaseService,
JxfsConst,
IQueueResponse {
    private static final String copyrightNotice = "5639-I90 (C) Copyright IBM Corp. 1990, 2000 All Rights Reserved. US Government Users Restricted Rights. Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. Licensed Material - Property of IBM";
    protected String subclass;
    protected String landpServer;
    protected String physicalDeviceDescription;
    protected String physicalDeviceName;
    protected JxfsLocalDeviceInformation localDeviceInfo;
    protected JxfsVersion version;
    protected JxfsStatus status;
    protected static String ORIGIN;
    protected static String DESCRIPTION;
    protected Hashtable controls = new Hashtable();
    protected QueueControl queue;
    protected int openCount;
    protected boolean isShutdownActive = false;
    protected JxfsLogger logger;
    protected final int INTERNAL_TIMEOUT = 2000;

    public void initialize(JxfsLocalDeviceInformation jxfsLocalDeviceInformation) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".initialize(JxfsLocalDeviceInformation: " + jxfsLocalDeviceInformation + ")");
        }
        this.localDeviceInfo = jxfsLocalDeviceInformation;
        this.landpServer = (String)((Object)this.localDeviceInfo.getValueForKey("landpServer"));
    }

    public int registerControl(String string, IJxfsEventNotification iJxfsEventNotification) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(device_control_type: " + string + ")");
        }
        int n = this.queue.registerControl(iJxfsEventNotification, string);
        RmtReq rmtReq = new RmtReq(1);
        boolean bl = false;
        try {
            bl = rmtReq.register();
        }
        catch (LandpCommunicationException landpCommunicationException) {
            if (this.logger.isLogActive(ORIGIN, 80)) {
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(LandpCommunicationException registering RmtReq : " + landpCommunicationException.getReturnCode() + ")");
            }
            throw new JxfsException(1019, landpCommunicationException.getReturnCode(), landpCommunicationException.getMessage(), (Exception)((Object)landpCommunicationException));
        }
        Cprb cprb = new Cprb("SPV", "IN");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        rmtReq.setCprb(cprb);
        try {
            cprb = rmtReq.send();
        }
        catch (InvalidCprbException invalidCprbException) {
            if (this.logger.isLogActive(ORIGIN, 80)) {
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(InvalidCprbException SPV IN)");
            }
            throw new JxfsException(1019, invalidCprbException.getMessage(), (Exception)((Object)invalidCprbException));
        }
        catch (LandpCommunicationException landpCommunicationException) {
            if (this.logger.isLogActive(ORIGIN, 80)) {
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(LandpCommunicationException SPV IN : " + landpCommunicationException.getReturnCode() + ")");
            }
            throw new JxfsException(1019, landpCommunicationException.getReturnCode(), landpCommunicationException.getMessage(), (Exception)((Object)landpCommunicationException));
        }
        catch (BadRouterRCException badRouterRCException) {
            if (this.logger.isLogActive(ORIGIN, 80)) {
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(BadRouterRCException SPV IN : " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badRouterRCException.getReturnCode()) + ")");
            }
            throw new JxfsException(1019, badRouterRCException.getMessage(), (Exception)((Object)badRouterRCException));
        }
        catch (BadServerRCException badServerRCException) {
            if (this.logger.isLogActive(ORIGIN, 80)) {
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(BadServerRCException SPV IN : " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badServerRCException.getReturnCode()) + ")");
            }
            throw new JxfsException(1019, badServerRCException.getMessage(), (Exception)((Object)badServerRCException));
        }
        this.controls.put(new Integer(n), rmtReq);
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".registerControl(returns control_id: " + n + ")");
        }
        return n;
    }

    public void deregisterControl(int n) throws JxfsException {
        RmtReq rmtReq;
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(control_id: " + n + ")");
        }
        if ((rmtReq = (RmtReq)this.controls.remove(new Integer(n))) != null) {
            Cprb cprb = new Cprb("SPV", "EJ");
            cprb.setQParmLength(26);
            cprb.setQDataLength(0);
            cprb.setRParmLength(26);
            cprb.setRDataLength(0);
            cprb.setQParm(new byte[1024]);
            cprb.setQData(new byte[1024]);
            cprb.setRParm(new byte[1024]);
            cprb.setRData(new byte[1024]);
            rmtReq.setCprb(cprb);
            try {
                cprb = rmtReq.send();
            }
            catch (InvalidCprbException invalidCprbException) {
                if (this.logger.isLogActive(ORIGIN, 80)) {
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(InvalidCprbException SPV EJ)");
                }
                throw new JxfsException(1019, invalidCprbException.getMessage(), (Exception)((Object)invalidCprbException));
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(ORIGIN, 80)) {
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(LandpCommunicationException SPV EJ : " + landpCommunicationException.getReturnCode() + ")");
                }
                throw new JxfsException(1019, landpCommunicationException.getReturnCode(), landpCommunicationException.getMessage(), (Exception)((Object)landpCommunicationException));
            }
            catch (BadRouterRCException badRouterRCException) {
                if (this.logger.isLogActive(ORIGIN, 80)) {
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(BadRouterRCException SPV EJ : " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badRouterRCException.getReturnCode()) + ")");
                }
                throw new JxfsException(1019, badRouterRCException.getMessage(), (Exception)((Object)badRouterRCException));
            }
            catch (BadServerRCException badServerRCException) {
                if (this.logger.isLogActive(ORIGIN, 80)) {
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(BadServerRCException SPV EJ : " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badServerRCException.getReturnCode()) + ")");
                }
                throw new JxfsException(1019, badServerRCException.getMessage(), (Exception)((Object)badServerRCException));
            }
            boolean bl = false;
            try {
                bl = rmtReq.unregister();
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (this.logger.isLogActive(ORIGIN, 80)) {
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(LandpCommunicationException unregistering RmtReq : " + landpCommunicationException.getReturnCode() + ")");
                }
                throw new JxfsException(1019, landpCommunicationException.getReturnCode(), landpCommunicationException.getMessage(), (Exception)((Object)landpCommunicationException));
            }
        }
        this.queue.deregisterControl(n);
    }

    public void connectionFailure(int n) {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".connectionFailure(control_id: " + n + ")");
        }
        try {
            this.release(2000, n);
        }
        catch (JxfsException jxfsException) {}
        try {
            this.close(n);
        }
        catch (JxfsException jxfsException) {}
        try {
            this.deregisterControl(n);
            return;
        }
        catch (JxfsException jxfsException) {
            return;
        }
    }

    public void shutdown() throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdown()");
        }
        this.isShutdownActive = true;
        this.queue.shutdown(true);
        Cprb cprb = new Cprb("SPV", "EJ");
        cprb.setQParmLength(26);
        cprb.setQDataLength(0);
        cprb.setRParmLength(26);
        cprb.setRDataLength(0);
        cprb.setQParm(new byte[1024]);
        cprb.setQData(new byte[1024]);
        cprb.setRParm(new byte[1024]);
        cprb.setRData(new byte[1024]);
        Enumeration enumeration = this.controls.elements();
        while (enumeration.hasMoreElements()) {
            RmtReq rmtReq;
            block13: {
                rmtReq = (RmtReq)enumeration.nextElement();
                rmtReq.setCprb(cprb);
                try {
                    rmtReq.send();
                }
                catch (InvalidCprbException invalidCprbException) {
                    if (this.logger.isLogActive(ORIGIN, 80)) {
                        this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdown(InvalidCprbException SPV EJ)");
                    }
                }
                catch (LandpCommunicationException landpCommunicationException) {
                    if (this.logger.isLogActive(ORIGIN, 80)) {
                        this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdown(LandpCommunicationException SPV EJ : " + landpCommunicationException.getReturnCode() + ")");
                    }
                }
                catch (BadRouterRCException badRouterRCException) {
                    if (this.logger.isLogActive(ORIGIN, 80)) {
                        this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdown(BadRouterRCException SPV EJ : " + LandpUtils.rcAsString((long)badRouterRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badRouterRCException.getReturnCode()) + ")");
                    }
                }
                catch (BadServerRCException badServerRCException) {
                    if (!this.logger.isLogActive(ORIGIN, 80)) break block13;
                    this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdownControl(BadServerRCException SPV EJ : " + LandpUtils.rcAsString((long)badServerRCException.getReturnCode()) + " " + LandpUtils.rcAsHex((long)badServerRCException.getReturnCode()) + ")");
                }
            }
            boolean bl = false;
            try {
                bl = rmtReq.register();
            }
            catch (LandpCommunicationException landpCommunicationException) {
                if (!this.logger.isLogActive(ORIGIN, 80)) continue;
                this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".deregisterControl(LandpCommunicationException unregistering RmtReq : " + landpCommunicationException.getReturnCode() + ")");
            }
        }
        this.isShutdownActive = false;
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".shutdown(returns)");
        }
        this.logger.deregisterModule(ORIGIN);
    }

    public JxfsStatus getStatus(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getStatus(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return this.status;
    }

    public JxfsVersion getDeviceServiceVersion(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getStatus(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return this.version;
    }

    public String getPhysicalDeviceDescription(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getPhysicalDeviceDescription(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return this.physicalDeviceDescription;
    }

    public String getPhysicalDeviceName(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getPhysicalDeviceName(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return this.physicalDeviceName;
    }

    public JxfsVersion getDeviceFirmwareVersion(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getDeviceFirmwareVersion(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        throw new JxfsException(1022);
    }

    public int getFirmwareStatus(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getFirmwareStatus(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return 1;
    }

    public JxfsVersion getRepositoryFirmwareVersion(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".getRepositoryFirmwareVersion(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        throw new JxfsException(1022);
    }

    public boolean updateFirmware(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".updateFirmware(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        throw new JxfsException(1022);
    }

    public boolean isPowerSaveModeSupported(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".isPowerSaveModeSupported(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return false;
    }

    public int wakeUpFromPowerSave(int n) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".wakeUpFromPowerSave(control_id: " + n + ")");
        }
        this.checkShutdown(n);
        return -1;
    }

    public int directIO(int n, JxfsType jxfsType, int n2) throws JxfsException {
        if (this.logger.isLogActive(ORIGIN, 80)) {
            this.logger.writeLog((Object)this, ORIGIN, 80, this.subclass + ".directIO(control_id: " + n2 + ")");
        }
        this.checkShutdown(n2);
        throw new JxfsException(1022);
    }

    public void checkShutdown(int n) throws JxfsException {
        if (this.isShutdownActive) {
            if (this.logger.isLogActive(ORIGIN, 82)) {
                this.logger.writeLog((Object)this, ORIGIN, 82, this.subclass + ".checkShutdown(control_id:" + n + " command cancelled. Shutdown active.)");
            }
            throw new JxfsException(1001);
        }
    }

    public abstract int open(int var1) throws JxfsException;

    public abstract int close(int var1) throws JxfsException;

    public abstract boolean claim(int var1, int var2) throws JxfsException;

    public abstract boolean release(int var1, int var2) throws JxfsException;

    public abstract void cancel(int var1, int var2) throws JxfsException;

    public abstract void openInternal(IJxfsServiceJob var1) throws JxfsException;

    public abstract void closeInternal(IJxfsServiceJob var1) throws JxfsException;

    public abstract void claimInternal(int var1);

    public abstract void releaseInternal(int var1);

    public abstract boolean checkInternal();
}

