/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a PM32 CLS structure */
/* 9/5/97 fixed possible acidental exponential comparison */
signal on halt name haltexit

arg cls .

if cls='' then do
   say 'CLS <pcls>'
   exit 0
end /* do */

pmver=pmver()
if '#'pmver='#00000084' then call fmtcls(cls)
else if '#'pmver='#00000080' then call fmtcls1(cls)
else say 'PM version not supported'

haltexit: exit 0


pmver: procedure
magic_offset=value('DF_PMVER',,'OS2ENVIRONMENT')
say 'Warning: PMMERGE symbols assumed and current slot is a PM thread/app.'
say ''
if magic_offset='' then do
   address df "cmd output s %(dw(pmqshell)) l100 'S' 'T' "
   o=output.0-1
   magic=word(output.o,1)
   address df 'cmd output ?' magic '- %(dw(pmqshell))'
   o=output.0-1
   magic_offset=substr(output.o,2)
   x=value('DF_PMVER',magic_offset,'OS2ENVIRONMENT')
end
return magic_offset


fmtcls: procedure
arg pcls

say ' '
address df 'cmd output dd' pcls 'L0b'
o=output.0-3
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Magic                       ' right(d1,4)
say '+06 Window data size            ' left(d1,4)
say '+08 Class style                 ' d2
say '+0c Atom Class Name             ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+10 Pid key                     ' d0
say '+14 16-bit window proc?         ' d1
if '#'d1='#00000000' then wp=left(d2,4)':'right(d2,4)
else wp=d2
say '+18 Window Procedure            ' wp
say '+1c User thunk procedure        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
if '#'d0<>'#00000000' then do
   address df 'cmd out da %'d0
   p=out.0-1
   name=word(out.p,2)
end /* do */
else name=''
say '+20 pModule name                ' d0 name
say '+24 16-bit original window proc?' d1
if '#'d1='#00000000' then wp=left(d2,4)':'right(d2,4)
else wp=d2
say '+28 Original window Procedure   ' wp

return


fmtcls1: procedure
arg pcls

say ' '
address df 'cmd output dd' pcls 'L0c'
o=output.0-3
parse var output.o addr d0 d1 d2 d3 .
say '+00 Next                        ' d0
say '+04 Magic                       ' right(d1,4)
say '+06 Window data size            ' left(d1,4)
say '+08 Class style                 ' d2
say '+0c Atom Class Name             ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
say '+10 Pid key                     ' d0
say '+14 16-bit window proc?         ' d1
if '#'d1='#00000000' then wp=left(d2,4)':'right(d2,4)
else wp=d2
say '+18 Window Procedure            ' wp
say '+1c User thunk procedure        ' d3
o=o+1
parse var output.o addr d0 d1 d2 d3 .
if '#'d0<>'#00000000' then do
   address df 'cmd out da %'d0
   p=out.0-1
   name=word(out.p,2)
end /* do */
else name=''
say '+20 pModule name                ' d0 name
say '+24 16-bit original window proc?' d1
if '#'d1='#00000000' then wp=left(d2,4)':'right(d2,4)
else wp=d2
say '+28 Original window Procedure   ' wp
say '+2c Prop Data Pointer           ' d3

return
