/* IBM Internal Use Only.                                            */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Dieter Damm                                  Version: 1.0  */
/* format an exception context record                                */
/*                                                                   */
/* Syntax: ECR <addr> <option>                                       */
/*                                                                   */
/* where:      <addr>     is a valid DF address expression for the   */
/*                        beginning of the context record            */
/*                                                                   */
/*             <option>   specify if the record is formatted in a    */
/*                        verbose format                             */
/*                        /v specifies verbose format                */
/*                        Option  may be combined, each with a       */
/*                        leading /                                  */
/* Change Log:                                                       */
/* 17/12/96 Version 1 created.                                       */







/*       CONTEXTRECORD Exception handler context record.                  */


/* Ŀ */
/* Field Name   OffsetLengthTypeDescription                          */
/* Ĵ */
/* ContextFlags +0    4     D   Flags                                */
/* Ĵ */
/* Ĵ */
/*              +4    6c    S   Floating point section               */
/* Ĵ */
/* Ĵ */
/* ctx_env      +4    1c    D   Floating point environment           */
/* Ĵ */
/* ctx_stack    +20   50    S   Floating point register stack        */
/*                              8 FPREG structures)                  */
/* Ĵ */
/* Ĵ */
/*              +70   10    S   Segment Register section             */
/* Ĵ */
/* Ĵ */
/* ctx_SegGs    +70   4     D   GS segment register                  */
/* Ĵ */
/* ctx_SegFs    +74   4     D   FS segment register                  */
/* Ĵ */
/* ctx_SegEs    +78   4     D   ES segment register                  */
/* Ĵ */
/* ctx_SegDs    +7c   4     D   DS segment register                  */
/* Ĵ */
/* Ĵ */
/*              +80   18    S   Integer Register section             */
/* Ĵ */
/* Ĵ */
/* ctx_RegEdi   +80   4     D   EDI register                         */
/* Ĵ */
/* ctx_RegEsi   +84   4     D   ESI register                         */
/* Ĵ */
/* ctx_RegEax   +88   4     D   EAX register                         */
/* Ĵ */
/* ctx_RegEbx   +8c   4     D   EBX register                         */
/* Ĵ */
/* ctx_RegEcx   +90   4     D   ECX register                         */
/* Ĵ */
/* ctx_RegEdx   +94   4     D   EDX register                         */
/* Ĵ */
/* Ĵ */
/*              +98   18    S   Control Register section             */
/* Ĵ */
/* Ĵ */
/* ctx_RegEbp   +98   4     D   EBP register                         */
/* Ĵ */
/* ctx_RegEip   +9c   4     D   EIP register                         */
/* Ĵ */
/* ctx_SegCs    +a0   4     D   CS selector                          */
/* Ĵ */
/* ctx_EFlags   +a4   4     D   Processor Flags register             */
/* Ĵ */
/* ctx_RegEsp   +a8   4     D   ESP register                         */
/* Ĵ */
/* ctx_SegSs    +ac   4     D   SS segment register                  */
/*  */



numeric digits 20
arg parms

args=''
opts=''
do while parms<>''
   parse var parms parm parms
   if left(parm,1)='/' then opts=opts||substr(parm,2)
   else args=args parm
end /* do */
if words(args)>1 then do
   say 'Invalid parameters'
   call helpmsg
   exit 0
end /* do */
linaddr=strip(args,'b',' ')

if linaddr='' | linaddr='?' then do
   call helpmsg
   exit 0
end /* do */

verbose=0=1

if pos('V',opts)>0 then verbose=0=0



position=pos('%',linaddr)
if position=0 then linaddr = '%'linaddr

say ' '
say ' ************ Formatting Exception Context Record *************'
say ' '


/*       ContextFlags flag definitions:                                    */
/*       Ŀ */
/*       Name                  Bit Mask   Description                  */
/*       Ĵ */
/*       CONTEXT_CONTROL       0x00000001LSS:ESP, CS:EIP, EFLAGS, EBP  */
/*       Ĵ */
/*       CONTEXT_INTEGER       0x00000002LEAX, EBX, ECX, EDX, ESI, EDI */
/*       Ĵ */
/*       CONTEXT_SEGMENTS      0x00000004LDS, ES, FS, GS               */
/*       Ĵ */
/*       CONTEXT_FLOATING_POINT0x00000008LNumeric coprocessor state    */
/*        */

address df 'cmd output dd 'linaddr ' L1'
o=output.0-1
flags=word(output.o,2)
str=' '
cc=0           /* Context control        */
ci=0           /* Context Integer        */
cs=0           /* Contret segments       */
cf=0           /* Context floating point */
if BITAND(flags,'00000001') = '00000000' then str=str || ' -> none '
if BITAND(flags,'00000001') = '00000001' then do
  str=str || ' -> CONTEXT_CONTROL'

  cc=1
end
if BITAND(flags,'00000002') = '00000002' then do
   str=str || ' -> CONTEXT_INTEGER'
   ci=1
end
if BITAND(flags,'00000004') = '00000004' then do
  str=str || ' -> CONTEXT_SEGMENTS'
  cs=1
end
if BITAND(flags,'00000008') = '00000008' then do
  str=str || ' -> CONTEXT_FLOATING_POINT'
  cf=1
end

if BITAND(flags,'0000000F') = '0000000F' then do
  str=str || ' -> All'
  cf=1
  cc=1
  ci=1
  cs=1
end
call format "ContextFlags","+00",linaddr,"D", 'Flags' || str
say ' '

/* -------- formatting floating point register section --------- */



/*                                                               */
/* According to the Intel reference the Floating point           */
/* environment is the following:                                 */

/* Ŀ */
/* Field Name   OffsetLengthTypeDescription                          */
/* Ĵ */
/* fpu_Cntrl    +0    2     W   Control Word                         */
/* Ĵ */
/* reserved1    +2    2     W   reserved                             */
/* Ĵ */
/* fpu_Status   +4    2     W   Status  Word                         */
/* Ĵ */
/* reserved2    +6    2     W   reserved                             */
/* Ĵ */
/* fpu_tag      +8    2     W   Tag Word                             */
/* Ĵ */
/* reserved3    +a    2     W   reserved                             */
/* Ĵ */
/* fpu_IP       +c    4     D   IP Offset                            */
/* Ĵ */
/* fpu_CS       +10   2     W   CS Selector                          */
/* Ĵ */
/* fpu_OpCode   +12   1.3   W   Opcode bits 0-10                     */
/* Ĵ */
/* fpu_Zero     +13   0.5   B   filler for byte boundary             */
/* Ĵ */
/* fpu_DataOffs +14   4     D   Data Operand Offset                  */
/* Ĵ */
/* fpu_OpSel    +18   2     W   Operand Selector                     */
/* Ĵ */
/* reserved4    +1a   2     W   filler for word boundary             */
/*  */

if cf=1 then do
  opcode=right(x2b(getstor(linaddr'+16','w','x')),11)
  opcode2=right(opcode,8)
  opcode1='11011' || left(opcode,3)

  say ' ------- Floating point section -----------'
  say ' '
  call format "fpu_Cntrl","+04",linaddr,"W", 'FPU Control Word'
  call format "fpu_Status","+08",linaddr,"W", 'FPU Status Word'
  call format "fpu_Tag","+0c",linaddr,"W", 'FPU Tag Word'
  call format "fpu_IP","+10",linaddr,"D", 'IP Offset'
  call format "fpu_CS","+14",linaddr,"W", 'CS Selector'
  call format "fpu_OpCode","+16",linaddr,"W", 'Opcode -> ' || b2x(opcode1) || b2x(opcode2)
  call format "fpu_DataOffs","+18",linaddr,"D", 'Data Operand Offset'
  call format "fpu_OpSel","+1c",linaddr,"W", 'Operand Selector'
  say ' '
/* --------- formatting fpu register stack -------------- */

/*  FPREG Floating Point Register Stack Element  */

/* Ŀ */
/* Field Name  OffsetLengthTypeDescription                          */
/* Ĵ */
/* losig       +0    4     D   Low significance double-word         */
/* Ĵ */
/* hisig       +4    4     D   High significance double-word        */
/* Ĵ */
/* signexp     +8    2     W   Exponent                             */
/*  */

say '---- Floating point register stack ------'
say ' '

  call format "losig","+20",linaddr,"D", 'ST('0') low significant'
  call format "hisig","+24",linaddr,"D", 'ST('0') high significant'
  call format "signexp","+28",linaddr,"W", 'ST('0') exponent'

  call format "losig","+2a",linaddr,"D", 'ST('1') low significant'
  call format "hisig","+2e",linaddr,"D", 'ST('1') high significant'
  call format "signexp","+32",linaddr,"W", 'ST('1') exponent'

  call format "losig","+34",linaddr,"D", 'ST('2') low significant'
  call format "hisig","+38",linaddr,"D", 'ST('2') high significant'
  call format "signexp","+3c",linaddr,"W", 'ST('2') exponent'

  call format "losig","+3e",linaddr,"D", 'ST('3') low significant'
  call format "hisig","+42",linaddr,"D", 'ST('3') high significant'
  call format "signexp","+46",linaddr,"W", 'ST('3') exponent'

  call format "losig","+48",linaddr,"D", 'ST('4') low significant'
  call format "hisig","+4c",linaddr,"D", 'ST('4') high significant'
  call format "signexp","+50",linaddr,"W", 'ST('4') exponent'

  call format "losig","+52",linaddr,"D", 'ST('5') low significant'
  call format "hisig","+56",linaddr,"D", 'ST('5') high significant'
  call format "signexp","+5a",linaddr,"W", 'ST('5') exponent'

  call format "losig","+5c",linaddr,"D", 'ST('6') low significant'
  call format "hisig","+60",linaddr,"D", 'ST('6') high significant'
  call format "signexp","+64",linaddr,"W", 'ST('6') exponent'

  call format "losig","+66",linaddr,"D", 'ST('7') low significant'
  call format "hisig","+6a",linaddr,"D", 'ST('7') high significant'
  call format "signexp","+6e",linaddr,"W", 'ST('7') exponent'
end

/* formatting Context Segment Section         */

if cs=1 then do
  say
  say '---------- Context Segment section --------------'
  say ' '
  call format "ctx_SegGs","+70",linaddr,"D","GS segment register"
  call format "ctx_SegFs","+74",linaddr,"D","FS segment register"
  call format "ctx_S egEs","+78",linaddr,"D","ES segment register"
  call format "ctx_SegDs","+7c",linaddr,"D","DS segment register"
end

/* formatting Context Integer Section                 */

if ci=1 then do
  say
  say '---------- Context Integer section --------------'
  say ' '
  call format "ctx_RegEdi","+80",linaddr,"D","EDI register"
  call format "ctx_RegEsi","+84",linaddr,"D","ESI register"
  call format "ctx_RegEax","+88",linaddr,"D","EAX register"
  call format "ctx_RegEbx","+8c",linaddr,"D","EBX register"
  call format "ctx_RegEcx","+90",linaddr,"D","ECX register"
  call format "ctx_RegEdx","+94",linaddr,"D","EDX register"
end

/*     formatting Context Control Section       */

if cc=1 then do
  say
  say '---------- Context Control section --------------'
  say ' '
  call format "ctx_RegEbp","+98",linaddr,"D","EBP register"
  call format "ctx_RegEip","+9c",linaddr,"D","EIP register"
  call format "ctx_SegCs","+a0",linaddr,"D","CS register"
  call format "ctx_EFlags","+a4",linaddr,"D","Processor Flags register"
  call format "ctx_RegEsp","+a8",linaddr,"D","ESP register"
  call format "ctx_SegSs","+ac",linaddr,"D","SS segment register"
end

if verbose then do
  say
  eflags=getstor(linaddr'+a4','D','X')
  eflags=x2b(eflags)
  say '---------- EFLAGS --------------'
  say ' (Bit0 )    Carry Flag            : ' substr(eflags,32,1)
  say ' (Bit2 )    Parity Flag           : ' substr(eflags,30,1)
  say ' (Bit4 )    Auxiliary Carry Flag  : ' substr(eflags,28,1)
  say ' (Bit6 )    Zero Flag             : ' substr(eflags,26,1)
  say ' (Bit7 )    Sign Flag             : ' substr(eflags,25,1)
  say ' (Bit8 )    Trap Flag             : ' substr(eflags,24,1)
  say ' (Bit9 )    Interrupt Enable Flag : ' substr(eflags,23,1)
  say ' (Bit10)    Direction Flag        : ' substr(eflags,22,1)
  say ' (Bit11)    Overflow Flag         : ' substr(eflags,21,1)
  say ' (Bit12-13) CPL                   : ' substr(eflags,19,2)
  say ' (Bit14)    Nested Task           : ' substr(eflags,18,1)
  say ' (Bit16)    Resume Flag           : ' substr(eflags,16,1)
  say ' (Bit17)    Virtual 8086 mode Flag: ' substr(eflags,15,1)
  say ' (Bit18)    Alignment Check       : ' substr(eflags,14,1)

  /* numerical exception masking */

  if cf=1 then do
    im=0   /* invalid operation    */
    dm=0   /* denormalized operand */
    zm=0   /* zero devide          */
    om=0   /* overflow             */
    um=0   /* undeflow             */
    pm=0   /* precision            */
    pc=0
    rc=0

    CtrlWord=getstor(linaddr'+4',"W",'X')
    if BITAND(x2c(CtrlWord),'0001'x) = '0001'x then im=1
    if BITAND(x2c(CtrlWord),'0002'x) = '0002'x then dm=1
    if BITAND(x2c(CtrlWord),'0004'x) = '0004'x then zm=1
    if BITAND(x2c(CtrlWord),'0008'x) = '0008'x then om=1
    if BITAND(x2c(CtrlWord),'0010'x) = '0010'x then um=1
    if BITAND(x2c(CtrlWord),'0020'x) = '0020'x then pm=1
    if BITAND(x2c(CtrlWord),'0300'x) = '0000' then pc=0
    if BITAND(x2c(CtrlWord),'0300'x) = '0100'x then pc=1
    if BITAND(x2c(CtrlWord),'0300'x) = '0200'x then pc=2
    if BITAND(x2c(CtrlWord),'0300'x) = '0300'x then pc=3
    if pc=0 then pcstr=' -> 24 Bits - single precision'
    if pc=1 then pcstr=' -> Reserved'
    if pc=2 then pcstr=' -> 53 Bits - double precision'
    if pc=3 then pcstr=' -> 64 Bits - extended Precision'
    if BITAND(x2c(CtrlWord),'0C00'x) = '0000' then rc=0
    if BITAND(x2c(CtrlWord),'0C00'x) = '0400'x then rc=1
    if BITAND(x2c(CtrlWord),'0C00'x) = '0800'x then rc=2
    if BITAND(x2c(CtrlWord),'0C00'x) = '0C00'x then rc=3
    if rc=0 then rcstr=' -> Round to nearest even'
    if rc=1 then rcstr=' -> Round down'
    if rc=2 then rcstr=' -> Round up'
    if rc=3 then rcstr=' -> Chop'
    say' '
    say 'FPU Control Word: ' || CtrlWord  || ' ->  ' || x2b(CtrlWord)
    say
    say '            (Bit0)     Invalid operation    : 'im
    say '            (Bit1)     Denormalized Operand : 'dm
    say '            (Bit2)     Zero Devide          : 'zm
    say '            (Bit3)     Overflow             : 'om
    say '            (Bit4)     Underflow            : 'um
    say '            (Bit5)     Precision            : 'pm
    say '            (Bit8-9)   Precision Control    : 'pc' 'pcstr
    say '            (Bit10-11) Rounding Control     : 'rc' 'rcstr

    /* Formatting FPU status word */
    /* Exception Flags            */
    IE=0       /* Bit 0 Invalid operation */
    DE=0       /* Bit 1 Denormalized operand */
    ZE=0       /* Bit 2 Zero Divide          */
    OE=0       /* Bit 3 Overflow             */
    UE=0       /* Bit 4 Underflow            */
    PE=0       /* Bit 5 Precision            */
    SF=0       /* Bit 6 Stack Fault          */
    ES=0       /* Bit 7 Error Summary Status */
    /* Condition Codes */
    C0=0       /* Bit 8                      */
    C1=0       /* Bit 9                      */
    C2=0       /* Bit 10                     */
    /* Top of stack pointer                  */
    TOP=0      /* Bits 11-13                 */
    C3=0       /* Bit 14 Condition Code 4th bit */
    BB=0       /* Bit 15 FPU Busy Flag          */

    StatusWord=getstor(linaddr'+8',"W",'X')
    if BITAND(x2c(statusWord),'0001'x) = '0001'x then ie=1
    if BITAND(x2c(statusWord),'0002'x) = '0002'x then de=1
    if BITAND(x2c(statusWord),'0004'x) = '0004'x then ze=1
    if BITAND(x2c(statusWord),'0008'x) = '0008'x then oe=1
    if BITAND(x2c(statusWord),'0010'x) = '0010'x then ue=1
    if BITAND(x2c(statusWord),'0020'x) = '0020'x then pe=1
    if BITAND(x2c(statusWord),'0040'x) = '0040'x then sf=1
    if BITAND(x2c(statusWord),'0080'x) = '0080'x then es=1
    if BITAND(x2c(statusWord),'0100'x) = '0100'x then c0=1
    if BITAND(x2c(statusWord),'0200'x) = '0200'x then c1=1
    if BITAND(x2c(statusWord),'0400'x) = '0400'x then c2=1
    if BITAND(x2c(statusWord),'4000'x) = '4000'x then c3=1
    if BITAND(x2c(statusWord),'3800'x) = '0000'x then top=0
    if BITAND(x2c(statusWord),'3800'x) = '0800'x then top=1
    if BITAND(x2c(statusWord),'3800'x) = '1000'x then top=2
    if BITAND(x2c(statusWord),'3800'x) = '1800'x then top=3
    if BITAND(x2c(statusWord),'3800'x) = '2000'x then top=4
    if BITAND(x2c(statusWord),'3800'x) = '2800'x then top=5
    if BITAND(x2c(statusWord),'3800'x) = '3000'x then top=6
    if BITAND(x2c(statusWord),'3800'x) = '3800'x then top=7

    if BITAND(x2c(statusWord),'8000'x) = '8000'x then bb=1

    say
    say 'FPU Status Word: '  || StatusWord || ' ->  '  || x2b(StatusWord)
    say
    say 'Expt Flags: (Bit0)     Invalid operation    : 'ie
    say '            (Bit1)     Denormalized operand : 'de
    say '            (Bit2)     Zero devide          : 'ze
    say '            (Bit3)     Overflow             : 'oe
    say '            (Bit4)     Underflow            : 'ue
    say '            (Bit5)     Precision            : 'pe
    say' '
    say '            (Bit6)     Stack Fault          : 'sf
    say '            (Bit7)     Error summary flag   : 'es
    say' '
    say 'Cond.Code:  (Bit8)     C0                   : 'c0
    say '            (Bit9)     C1                   : 'c1
    say '            (Bit10)    C2                   : 'c2
    say '            (Bit14)    C3                   : 'c3
    say ' '
    say '            (Bit11-13) Top of Stack         : 'top
    say ' '
    say '            (Bit15)    FPU Busy Flag        : 'bb
    say ' '

    /* Formatting TAG word */
    TagWord=getstor(linaddr'+0c',"W",'X')
    binTagWord=x2b(tagword)
    tag7=b2x(substr(bintagword,1,2))
    tag6=b2x(substr(bintagword,3,2))
    tag5=b2x(substr(bintagword,5,2))
    tag4=b2x(substr(bintagword,7,2))
    tag3=b2x(substr(bintagword,9,2))
    tag2=b2x(substr(bintagword,11,2))
    tag1=b2x(substr(bintagword,13,2))
    tag0=b2x(substr(bintagword,15,2))

    say 'FPU tag word: ' || tagword || ' ->  ' || x2b(tagword)
    say
    say '(0=valid, 1=zero, 2=special, 3=empty)'
    say' '
    say '   Tag0     : ' tag0
    say '   Tag1     : ' tag1
    say '   Tag2     : ' tag2
    say '   Tag3     : ' tag3
    say '   Tag4     : ' tag4
    say '   Tag5     : ' tag5
    say '   Tag6     : ' tag6
    say '   Tag7     : ' tag7
    say ' '
  end
end



return


helpmsg: procedure

   say "Format exception context record                                   "
   say "                                                                  "
   say "Syntax: ECR <option> <linaddr> <option>                           "
   say "                                                                  "
   say "where:      <addr>     is the linear address ofthe beginning of   "
   say "                       the context record                         "
   say "                                                                  "
   say "            <option>   specify if record is formatted in a        "
   say "                       verbose format                             "
   say "                       /v specifies the verbose format            "
   say " "
   say "                       Option may be combined, with or without a  "
   say "                       leading /                                  "
   say " "
return


/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end


format: procedure
parse arg name,offset,base,type,desc

value=getstor(base||offset,type)
desc=strip(desc,"B"," ")
name=strip(name,"B"," ")
if length(name) > 20 then name=substr(name,1,20)
if length(name) < 20 then name=left(name,20,' ')
text=offset ' | '  name" | "
tl=length(text)
vl=length(value)
pad=40-tl-vl
if pad>0 then text=left(text,pad+tl," ")
say text value ' | ' desc
return value





