/*.im seciuo*/
/* IBM Internal Use Only.                                            */
/*.im coibm*/
/* (C) Copyright IBM Corp. 1993                                      */
/* (C) Copyright IBM Information Solutions 1993                      */
/*                                                                   */
/*rexx*/
/*Author: Richard Moore  / Dieter Damm               Version: 1.0    */
/* format file system driver (FSD)                                   */
/* 1 optional parameter: adr                                         */
/*                                                                   */
/* 10/01/97 if user types ?, spit out help                           */
/*                                                                   */

trace 'o'
numeric digits 12


arg adr
say adr

if (adr='?' |,
   adr='/?' |,
   adr='/h' |,
   adr='/H') then do
   say "Format FSD entries"
   say " "
   say 'Syntax: %FSD <num>'
   say ' '
   say 'where: num = fsd number (starts with FSD2 since FSD1 is reserved for mini_fsd'
   say '       if num is ommited, all fsds are listed'
   exit 0
end  /* Do */


  address df 'cmd output ln gdt_fsc'
  o=output.0-1
  dummy=word(output.o,1)
  if dummy='No' then do
   say 'Kernel symbols not loaded '
   exit 0
  end
fsc=right(dummy,4)

address df 'cmd output dw 'fsc':0000 L4'
o=output.0-1
l=word(output.o,2)
fsdmax=(x2d(l-8))/x2d(c0)  

say ' '
say '----------   Formatting  File System Drivers ----------'
say ' '
say ' FSC segment at: 'fsc ':0000'
say ' FSC length    : 'l

if adr > fsdmax+1 then do
  say ' '
  say ' ERROR: FSD ' adr 'does not exist - last FSD is ' fsdmax+1
  exit
end


if adr = '' then do
   cnt = fsdmax
   ofs=8
end 
else do
  if adr < 2 then do
    say ' '
    say ' ERROR: FSD  numbering starts at 2 (1 is MINIFSD)'
    exit
  end
  cnt =1
  ofs=d2x(8+((adr-2)*192))
end

i=1
Do cnt
  i=i+1
  address df 'cmd output dw 'fsc':'ofs ' l8'
  o=output.0-1
  attrptr=word(output.o,3) || ':' || word(output.o,2)
  nameptr=word(output.o,5) || ':' || word(output.o,4)

e1 =getstor(fsc':'ofs'+a','W','X') || ':' || getstor(fsc':'ofs'+8','W','X')
e2 =getstor(fsc':'ofs'+e','W','X') || ':' || getstor(fsc':'ofs'+c','W','X')
e3 =getstor(fsc':'ofs'+12','W','X') || ':'|| getstor(fsc':'ofs'+10','W','X')
e4 =getstor(fsc':'ofs'+16','W','X') || ':' || getstor(fsc':'ofs'+14','W','X')
e5 =getstor(fsc':'ofs'+1a','W','X') || ':' || getstor(fsc':'ofs'+18','W','X')
e6 =getstor(fsc':'ofs'+1e','W','X') || ':' || getstor(fsc':'ofs'+1c','W','X')
e7 =getstor(fsc':'ofs'+22','W','X') || ':' || getstor(fsc':'ofs'+20','W','X')
e8 =getstor(fsc':'ofs'+26','W','X') || ':' || getstor(fsc':'ofs'+24','W','X')
e9 =getstor(fsc':'ofs'+2a','W','X') || ':' || getstor(fsc':'ofs'+28','W','X')
e10 =getstor(fsc':'ofs'+2e','W','X') || ':' || getstor(fsc':'ofs'+2c','W','X')
e11 =getstor(fsc':'ofs'+32','W','X') || ':' || getstor(fsc':'ofs'+30','W','X')
e12 =getstor(fsc':'ofs'+36','W','X') || ':' || getstor(fsc':'ofs'+34','W','X')
e13 =getstor(fsc':'ofs'+3a','W','X') || ':' || getstor(fsc':'ofs'+38','W','X')
e14 =getstor(fsc':'ofs'+3e','W','X') || ':' || getstor(fsc':'ofs'+3c','W','X')
e15 =getstor(fsc':'ofs'+42','W','X') || ':' || getstor(fsc':'ofs'+40','W','X')
e16 =getstor(fsc':'ofs'+46','W','X') || ':' || getstor(fsc':'ofs'+44','W','X')
e17 =getstor(fsc':'ofs'+4a','W','X') || ':' || getstor(fsc':'ofs'+48','W','X')
e18 =getstor(fsc':'ofs'+4e','W','X') || ':' || getstor(fsc':'ofs'+4c','W','X')
e19 =getstor(fsc':'ofs'+52','W','X') || ':' || getstor(fsc':'ofs'+50','W','X')
e20 =getstor(fsc':'ofs'+56','W','X') || ':' || getstor(fsc':'ofs'+54','W','X')
e21 =getstor(fsc':'ofs'+5a','W','X') || ':' || getstor(fsc':'ofs'+58','W','X')
e22 =getstor(fsc':'ofs'+5e','W','X') || ':' || getstor(fsc':'ofs'+5c','W','X')
e23 =getstor(fsc':'ofs'+62','W','X') || ':' || getstor(fsc':'ofs'+60','W','X')
e24 =getstor(fsc':'ofs'+66','W','X') || ':' || getstor(fsc':'ofs'+64','W','X')
e25 =getstor(fsc':'ofs'+6a','W','X') || ':' || getstor(fsc':'ofs'+68','W','X')
e26 =getstor(fsc':'ofs'+6e','W','X') || ':' || getstor(fsc':'ofs'+6c','W','X')
e27 =getstor(fsc':'ofs'+72','W','X') || ':' || getstor(fsc':'ofs'+70','W','X')
e28 =getstor(fsc':'ofs'+76','W','X') || ':' || getstor(fsc':'ofs'+74','W','X')
e29 =getstor(fsc':'ofs'+7a','W','X') || ':' || getstor(fsc':'ofs'+78','W','X')
e30 =getstor(fsc':'ofs'+7e','W','X') || ':' || getstor(fsc':'ofs'+7c','W','X')
e31 =getstor(fsc':'ofs'+82','W','X') || ':' || getstor(fsc':'ofs'+80','W','X')
e32 =getstor(fsc':'ofs'+86','W','X') || ':' || getstor(fsc':'ofs'+84','W','X')
e33 =getstor(fsc':'ofs'+8a','W','X') || ':' || getstor(fsc':'ofs'+88','W','X')
e34 =getstor(fsc':'ofs'+8e','W','X') || ':' || getstor(fsc':'ofs'+8c','W','X')
e35 =getstor(fsc':'ofs'+92','W','X') || ':' || getstor(fsc':'ofs'+90','W','X')
e36 =getstor(fsc':'ofs'+96','W','X') || ':' || getstor(fsc':'ofs'+94','W','X')
e37 =getstor(fsc':'ofs'+9a','W','X') || ':' || getstor(fsc':'ofs'+98','W','X')
e38 =getstor(fsc':'ofs'+9e','W','X') || ':' || getstor(fsc':'ofs'+9c','W','X')
e39 =getstor(fsc':'ofs'+a2','W','X') || ':' || getstor(fsc':'ofs'+a0','W','X')
e40 =getstor(fsc':'ofs'+a6','W','X') || ':' || getstor(fsc':'ofs'+a4','W','X')
e41 =getstor(fsc':'ofs'+aa','W','X') || ':' || getstor(fsc':'ofs'+a8','W','X')
e42 =getstor(fsc':'ofs'+ae','W','X') || ':' || getstor(fsc':'ofs'+ac','W','X')
e43 =getstor(fsc':'ofs'+b2','W','X') || ':' || getstor(fsc':'ofs'+b0','W','X')
e44 =getstor(fsc':'ofs'+b6','W','X') || ':' || getstor(fsc':'ofs'+b4','W','X')
e45 =getstor(fsc':'ofs'+ba','W','X') || ':' || getstor(fsc':'ofs'+b8','W','X')
e46 =getstor(fsc':'ofs'+be','W','X') || ':' || getstor(fsc':'ofs'+bc','W','X')

  ofs=x2d(ofs)
  address df 'cmd output dd 'attrptr ' L1'
  o=output.0-1
  attrib=word(output.o,2)
  address df 'cmd output da 'nameptr 
  o=output.0-1
  name=word(output.o,2)  
  
  
   
  say ' '
  if adr='' then
  say '----------- FSD 'i' ------------' 
  else
  say '-----------  FSD 'x2d(adr) ' --------------'
  say
  say 'Attrib   : ' attrib
  say 'Name     : ' name
  say 'fsc entry: ' fsc || ':' || d2x(ofs,4) 
  say
  say '1   FS_ATTACH            ' || e1 ||  ' DosQFsAttach, DosFsAttach'
  say '2   FS_CHDIR             ' || e2 ||  ' DosChDir'
  say '3   FS_CHGFILEPTR        ' || e3 ||  ' DosChgFilePtr'
  say '4   FS_CLOSE             ' || e4 ||  ' DosClose'
  say '5   FS_COPY              ' || e5 ||  ' DosCopy'
  say '6   FS_DELETE            ' || e6 ||  ' DosDelete'
  say '7   FS_EXIT              ' || e7 ||  ' DosExit'
  say '8   FS_FILEATTRIBUTE     ' || e8 ||  ' DosFileInfo,DosSetFoleMode'
  say '9   FS_FILEINFO          ' || e9 ||  ' DosQFileInfo,DosSetFileInfo'
  say '10  FS_FILEIO            ' || e10 || ' DosFileIO'
  say '11  FS_FINDCLOSE         ' || e11 || ' DosFindClose'
  say '12  FS_FINDFIRST         ' || e12 || ' DosFindFirst'
  say '13  FS_FINDFROMNAME      ' || e13 || ' DosFindFromName'
  say '14  FS_FINDNEXT          ' || e14 || ' DosFindNext'
  say '15  FS_FINDNOTIFYCLOSE   ' || e15 || ' DosFindNotifyClose'
  say '16  FS_FINDNOTIFYFIRST   ' || e16 || ' DosFindNotifyFirst'
  say '17  FS_FINDNOTIFYNEXT    ' || e17 || ' DosFindNotifyNext'
  say '18  FS_INFO              ' || e18 || ' DosQFsInfo,DosSetFsInfo'
  say '19  FS_INIT              ' || e19 || ' '
  say '20  FS_IOCTL             ' || e20 || ' DosDevIOCtl'
  say '21  FS_MKDIR             ' || e21 || ' DosMkDir'
  say '22  FS_MOUNT             ' || e22 || ' '
  say '23  FS_MOVE              ' || e23 || ' DosMove'
  say '24  FS_NEWSIZE           ' || e24 || ' DosNewSize'
  say '25  FS_NMPIPE            ' || e25 || ' All named pipe related APIs'
  say '26  FS_OPENCREATE        ' || e26 || ' DosOpen'
  say '27  FS_PATHINFO          ' || e27 || ' DosQPathInfo, DosSetPathInfo'
  say '28  FS_PROCESSNAME       ' || e28 || ' '
  say '29  FS_READ              ' || e29 || ' DosRead, DosReadAsync'
  say '30  FS_RMDIR             ' || e30 || ' DosRmDir'
  say '31  FS_SETSWAP           ' || e31 || ' '
  say '32  FS_WRITE             ' || e32 || ' DosWrite, DosWriteAsync'
  say '33  FS_OPENPAGEFILE      ' || e33 || ' init time only '  
  say '34  FS_ALLOCATEPAGESPACE ' || e34 || ' size swap file'
  say '35  FS_CANCELLOCKREQUEST ' || e35 || ' DosCancelLockRequest'
  say '36  FS_FILELOCKS         ' || e36 || ' DosSetFileLocks'
  say '37  FS_VERIFYUNCNAME     ' || e37 || ' '
  say '38  FS_COMMIT            ' || e38 || ' DosBufReset, DosClose'
  say '39  FS_DOPAGEIO          ' || e39 || ' perform paging'
  say '40  FS_FSCTL             ' || e40 || ' DosFsCtl'
  say '41  FS_FLUSHBUF          ' || e41 || ' DosBufReset'
  say '42  FS_SHUTDOWN          ' || e42 || ' DosShutDown'
  say '43  FS_SDCHGFILEPTR      ' || e43 || ' '
  say '44  FS_SDFSINFO          ' || e44 || ' '
  say '45  FS_SDREAD            ' || e45 || ' '
  say '46  FS_SDWRITE           ' || e46 || ' '

  ofs=d2x(ofs+(48*4))
  
end


return


/*.im getstor*/
/*.ifdef gblgetstor*/
/*.endif*/
/*.se gblgetstor=1*/
getstor: procedure
arg address,size,format
select
   when size='B' then cmd="DB" address "L1"
   when size='W' then cmd="DW" address "L1"
   when size="D" then cmd="DD" address "L1"

otherwise cmd="DB" address "L1"
end  /* select */
address df "cmd output" cmd
if rc<>0 then return 'df error' rc
else do
    if substr(output.3,1,1)='#' then do
       parse var output.2 . stor .
       select
          when format="C" then return x2c(stor)
          when format="N" then return x2d(stor)
          when format="X" then return stor
       otherwise return stor
       end  /* select */
    end  /* Do */
    else return output.3
end






