/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format the MUXTABLE                                               */
/* Change Log:                                                       */
/* 29/10/96 Version 1 created.                                       */
/* 09/05/97 ver 1.1 fixed possible acidental exponential comparison  */
/*                                                                   */

arg mt

signal on halt name haltexit
trace 'o'
numeric digits 12
if mt='?' then do
   say 'Format the muxtable'
   say ''
   say 'Syntax: %muxtable <addr>'
   say ''
   say 'where: <addr> is the address of the muxtable'
   say '       if <addr> is omitted then it is calculated from'
   say '       the SAB or kernle symbols'
   exit 0
end /* do */
dver=sysver()
parse var dver major minor rev kver krnl
if minor>=40 then do
   /* if merlin, use the SAB */
   mt='poi(poi(b0:18))'
end /* do */
else if mt='' then do
   mt='muxtable'
   say 'Warning: OS2KRNL Symbols assumed'
   say ''
end /* do */

address df 'cmd output ?' mt
o=output.0-1
if pos('error',output.o)>0 then do
   say 'Unable to locate the muxtable'
   exit 0
end /* do */
mt=word(output.o,1)


do i=0 to 255
   mtoff=d2x(i*9,4)
   address df 'cmd output db' mt'+'mtoff 'l 9'
   o=output.0-1
   parse var output.o ma b1 b2 b3 b4 b5 b6 b7 b8'-'b9 .
   if left(ma,1)<'20'x then ma=substr(ma,2) /* kdb leaves some junk behind */
   link=b2||b1
   slot=b4||b3
   type=b5
   desc=''
   addr=''
   if '#'type='#00' then do
      desc='clear,'
      addr='id='b9||b8||b7||b6
   end /* do */
   else if '#'type='#01' then do
      desc='syssem'
      addr='#0400:'b7||b6
   end /* do */
   else if '#'type='#02' then do
      desc='ramsem'
      addr='hob='b9||b8 'offset='b7||b6
   end /* do */
   else if '#'type='#03' then do
      desc='physical ramsem'
      addr='%%'b9||b8||b7||b6
   end /* do */
   else if '#'type='#04' then do
      desc='event sem32'
      addr='%'b9||b8||b7||b6
   end /* do */
   say ma '+'mtoff 'link='link 'slot='slot 'type='type desc addr
end /* do */

haltexit:
exit 0


sysver: procedure

segoff=getwords("#70:14",1)
iseg=getwords("#70:"segoff,1)
iseg="#"iseg":15"

address df 'cmd output db' iseg 'l10'
o=output.0-1
parse var output.o . major minor revision .
major=x2d(major)
minor=x2d(minor)
revision=x2d(revision)
if x2d(minor)>=40 then do
   address df 'cmd output db #b0:0 l0c'
   o=output.0-1
   parse var output.o . . . . . . . . .'-'h1 h2 h3 h4 . krnl .
   krnl=left(krnl,4)
   hdr=h4||h3':'h2||h1
   address df 'cmd output da #'hdr
   o=output.0-1
   parse var output.o . . krev',' .
end /* do */
else do
   krev=''
   krnl=''
end /* do */

return major minor revision krev krnl
getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
