/* rexx                                                     */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* translate an OS2 Ordinal to an API Name               */

arg module ordinal

parse var module module '.' ord .
if module='' then do
   say 'OS2ORD module[.]ordinal'
   exit 0
end /* do */

if ord='' then ord=ordinal

if ord='' then do
   say 'OS2ORD module[.]ordinal'
   exit 0
end /* do */

if left(ord,2)='0X' then ord=x2d(substr(ord,3))
if (datatype(ord,'x') & datatype(ord,'n')) then ord=x2d(ord)

if datatype(ord,'n') then do
   say 'OS2ORD module[.]ordinal'
   exit 0
end /* do */

call kinitord
call oinitord

if module='DOSCALL1' then module='DOSCALLS'
if module='OS2KRNL' then module='DOSCALLS'
if module='OS2KRNLR' then module='DOSCALLS'
if module='OS2KRNLB' then module='DOSCALLS'
if module='OS2KRNLD' then module='DOSCALLS'

if module='DOSCALLS' | module='MVDM' | module='FSHELPER' then ,
   name=kordinals.module.ord
else ,
   name=oordinals.module.ord

if name='' then say module'.'ord'(0x'd2x(ord)') not found'
else say module'.'ord'(0x'd2x(ord)') ==>' name

exit 0

kinitord: procedure expose kordinals.
kordinals.=''
kordinals.FSHELPER.1='SEGALLOC'
kordinals.FSHELPER.2='SEGFREE'
kordinals.FSHELPER.3='SEGREALLOC'
kordinals.FSHELPER.4='FORCENOSWAP'
kordinals.FSHELPER.5='INTERR'
kordinals.FSHELPER.6='SEMREQUEST'
kordinals.FSHELPER.7='SEMCLEAR'
kordinals.FSHELPER.8='PROBEBUF'
kordinals.FSHELPER.9='GETPRIORITY'
kordinals.FSHELPER.10='IOSEMCLEAR'
kordinals.FSHELPER.11='FLUSHBUF'
kordinals.FSHELPER.12='CRITERROR'
kordinals.FSHELPER.13='DEVIOCTL'
kordinals.FSHELPER.14='GETVOLPARM'
kordinals.FSHELPER.15='FINDDUPHVPB'
kordinals.FSHELPER.16='DOVOLIO'
kordinals.FSHELPER.17='ADDSHARE'
kordinals.FSHELPER.18='REMOVESHARE'
kordinals.FSHELPER.19='GETOVERLAPBUF'
kordinals.FSHELPER.20='ISCURDIRPREFIX'
kordinals.FSHELPER.21='LOADCHAR'
kordinals.FSHELPER.22='PREVCHAR'
kordinals.FSHELPER.23='STORECHAR'
kordinals.FSHELPER.24='SEMSET'
kordinals.FSHELPER.25='SEMSETWAIT'
kordinals.FSHELPER.26='SEMWAIT'
kordinals.FSHELPER.27='WILDMATCH'
kordinals.FSHELPER.28='YIELD'
kordinals.FSHELPER.29='DOVOLIO2'
kordinals.FSHELPER.30='FINDCHAR'
kordinals.FSHELPER.31='SETBOOTDRIVE'
kordinals.FSHELPER.32='CANONICALIZE'
kordinals.FSHELPER.33='DOVOLIO'
kordinals.FSHELPER.34='INTERR'
kordinals.FSHELPER.35='SEGALLOC'
kordinals.FSHELPER.36='SEGFREE'
kordinals.FSHELPER.37='SEGREALLOC'
kordinals.FSHELPER.38='CALLRM'
kordinals.FSHELPER.39='LOCK'
kordinals.FSHELPER.40='PHYSTOVIRT'
kordinals.FSHELPER.41='UNLOCK'
kordinals.FSHELPER.42='UNPHYSTOVIRT'
kordinals.FSHELPER.43='VIRT2PHYS'
kordinals.FSHELPER.44='QSYSINFO'
kordinals.FSHELPER.45='NAMEFROMSFN'
kordinals.FSHELPER.46='UPPERCASE'
kordinals.FSHELPER.47='CHECKEANAME'
kordinals.FSHELPER.48='CALLDRIVER'
kordinals.FSHELPER.49='SETVOLUME'
kordinals.FSHELPER.50='STACKSPACE'
kordinals.FSHELPER.51='REGISTERPERFCTRS'
kordinals.FSHELPER.52='IOBOOST'
kordinals.FSHELPER.53='QUERYSERVERTHREAD'
kordinals.FSHELPER.54='QUERYOPLOCK'
kordinals.FSHELPER.55='EXTENDTIMESLICE'
kordinals.MVDM.1='VDHSetDosDevice'
kordinals.MVDM.2='_TKSSBase'
kordinals.MVDM.3='VDHInstallUserHook'
kordinals.MVDM.4='VDHPopup'
kordinals.MVDM.5='VDHKillVDM'
kordinals.MVDM.6='VDHSetPriority'
kordinals.MVDM.7='VDHFreezeVDM'
kordinals.MVDM.8='VDHThawVDM'
kordinals.MVDM.9='VDHIsVDMFrozen'
kordinals.MVDM.10='VDHInstallFaultHandler'
kordinals.MVDM.11='VDHEnumerateVDMs'
kordinals.MVDM.12='VDHHandleFromSGID'
kordinals.MVDM.13='VDHHandleFromPID'
kordinals.MVDM.14='VDHInstallIOHook'
kordinals.MVDM.15='VDHRemoveIOHook'
kordinals.MVDM.16='VDHSetIOHookState'
kordinals.MVDM.17='VDHInstallIntHook'
kordinals.MVDM.18='VDHArmBPHook'
kordinals.MVDM.19='VDHArmSTIHook'
kordinals.MVDM.20='VDHArmReturnHook'
kordinals.MVDM.21='VDHInstallFaultHook'
kordinals.MVDM.22='VDHRemoveFaultHook'
kordinals.MVDM.23='VDHOpenPDD'
kordinals.MVDM.24='VDHRegisterVDD'
kordinals.MVDM.25='VDHOpenVDD'
kordinals.MVDM.26='VDHRequestVDD'
kordinals.MVDM.27='VDHAllocMem'
kordinals.MVDM.28='VDHFreeMem'
kordinals.MVDM.29='VDHAllocDosMem'
kordinals.MVDM.30='VDHCreateBlockPool'
kordinals.MVDM.31='VDHAllocBlock'
kordinals.MVDM.32='VDHFreeBlock'
kordinals.MVDM.33='VDHDestroyBlockPool'
kordinals.MVDM.34='VDHCopyMem'
kordinals.MVDM.35='VDHExchangeMem'
kordinals.MVDM.36='VDHLockMem'
kordinals.MVDM.37='VDHUnLockMem'
kordinals.MVDM.38='VDHQuerySel'
kordinals.MVDM.39='VDHCreateSel'
kordinals.MVDM.40='VDHDestroySel'
kordinals.MVDM.41='VDHAllocPages'
kordinals.MVDM.42='VDHReallocPages'
kordinals.MVDM.43='VDHFreePages'
kordinals.MVDM.44='VDHFindFreePages'
kordinals.MVDM.45='VDHGetDirtyPageInfo'
kordinals.MVDM.46='VDHQueryFreePages'
kordinals.MVDM.47='VDHReservePages'
kordinals.MVDM.48='VDHMapPages'
kordinals.MVDM.49='VDHArmTimerHook'
kordinals.MVDM.50='VDHDisarmTimerHook'
kordinals.MVDM.51='VDHOpen'
kordinals.MVDM.52='VDHClose'
kordinals.MVDM.53='VDHRead'
kordinals.MVDM.54='VDHWrite'
kordinals.MVDM.55='VDHPushInt'
kordinals.MVDM.56='VDHPopInt'
kordinals.MVDM.57='VDHPushRegs'
kordinals.MVDM.58='VDHPopRegs'
kordinals.MVDM.59='VDHPushFarCall'
kordinals.MVDM.60='VDHViewHandle'
kordinals.MVDM.61='VDHRegisterAPI'
kordinals.MVDM.62='VDHGetError'
kordinals.MVDM.63='VDHSetError'
kordinals.MVDM.64='VDHQuerySysValue'
kordinals.MVDM.65='VDHPutSysValue'
kordinals.MVDM.66='VDHSeek'
kordinals.MVDM.67='VDHDevIOCtl'
kordinals.MVDM.68='VDHPhysicalDisk'
kordinals.MVDM.69='VDHFSCtl'
kordinals.MVDM.70='VDHYield'
kordinals.MVDM.71='VDHArmContextHook'
kordinals.MVDM.72='VDHHaltSystem'
kordinals.MVDM.73='VDHGetCodePageFont'
kordinals.MVDM.74='VDHReleaseCodePageFont'
kordinals.MVDM.75='_VDHPanic'
kordinals.MVDM.76='_printf'
kordinals.MVDM.77='VDHSetTimer0'
kordinals.MVDM.78='VDHDevBeep'
kordinals.MVDM.79='VDHSetFlags'
kordinals.MVDM.80='VDHAssertTask'
kordinals.MVDM.81='VDHAssertVDMTask'
kordinals.MVDM.82='VDHAssertTaskOnly'
kordinals.MVDM.83='VDHAssertVDMTaskOnly'
kordinals.MVDM.84='VDHAssertInitOnly'
kordinals.MVDM.85='VDHCheckHVDM'
kordinals.MVDM.86='VDHAllocHook'
kordinals.MVDM.87='VDHQueryHookData'
kordinals.MVDM.88='VDHFreeHook'
kordinals.MVDM.89='VDHReleaseNPX'
kordinals.MVDM.90='VDHNPXReset'
kordinals.MVDM.91='VDHNPXClearBusy'
kordinals.MVDM.92='VDHNPXRegisterVDD'
kordinals.MVDM.93='VDHUnreservePages'
kordinals.MVDM.94='VDHQueryLin'
kordinals.MVDM.95='VDHCreateSem'
kordinals.MVDM.96='VDHDestroySem'
kordinals.MVDM.97='VDHQuerySem'
kordinals.MVDM.98='VDHResetEventSem'
kordinals.MVDM.99='VDHPostEventSem'
kordinals.MVDM.100='VDHWaitEventSem'
kordinals.MVDM.101='VDHRequestMutexSem'
kordinals.MVDM.102='VDHReleaseMutexSem'
kordinals.MVDM.103='VDHRegisterProperty'
kordinals.MVDM.104='VDHQueryProperty'
kordinals.MVDM.105='VDHRegisterPerfCtrs'
kordinals.MVDM.106='VDHDecodeProperty'
kordinals.MVDM.107='UNUSED'
kordinals.MVDM.108='VDHPushStack'
kordinals.MVDM.109='VDHPopStack'
kordinals.MVDM.110='VDHAllocDMABuffer'
kordinals.MVDM.111='VDHFreeDMABuffer'
kordinals.MVDM.112='INTSetVDMIRQ'
kordinals.MVDM.113='INTUnsetVDMIRQ'
kordinals.MVDM.114='INTEOIVDMIRQ'
kordinals.MVDM.115='VDHSwitchToV86'
kordinals.MVDM.116='VDHSwitchToVPM'
kordinals.MVDM.117='VDHCheckVPMIntVector'
kordinals.MVDM.118='VDHGetVPMIntVector'
kordinals.MVDM.119='VDHSetVPMIntVector'
kordinals.MVDM.120='VDHArmVPMBPHook'
kordinals.MVDM.121='VDHBeginUseVPMStack'
kordinals.MVDM.122='VDHEndUseVPMStack'
kordinals.MVDM.123='_flVdmStatus'
kordinals.MVDM.124='VDHCloseVDD'
kordinals.MVDM.125='_pdhdHostData'
kordinals.MVDM.126='VDHRegisterDPMI'
kordinals.MVDM.127='_flVpmIRQHooks'
kordinals.MVDM.128='VDHChangeVPMIF'
kordinals.MVDM.129='VDHGetSelBase'
kordinals.MVDM.130='VDHReadUBuf'
kordinals.MVDM.131='VDHWriteUBuf'
kordinals.MVDM.132='VDHCheckPagePerm'
kordinals.MVDM.133='VDHRaiseException'
kordinals.MVDM.134='VDHStartHWInt'
kordinals.MVDM.135='VDHGetVPMExcept'
kordinals.MVDM.136='VDHSetVPMExcept'
kordinals.MVDM.137='VDHProbeUBuf'
kordinals.MVDM.138='VDHPrepVPMIret'
kordinals.MVDM.139='VDHPopVPMFarRet'
kordinals.MVDM.140='VDHCheckVPMExcept'
kordinals.MVDM.141='VDHSetBoost'
kordinals.MVDM.142='VDHWakeRamSem'
kordinals.MVDM.143='VDHRequestRamSem'
kordinals.MVDM.144='VDHProcessToGlobal'
kordinals.MVDM.145='VDHValidatePID'
kordinals.MVDM.146='VDHMapMemBlock'
kordinals.MVDM.147='DevWOHandle'
kordinals.MVDM.148='VDHVMGetHandle'
kordinals.MVDM.149='VDHVMAttach'
kordinals.MVDM.150='VDHCreateThread'
kordinals.MVDM.151='VDHExitThread'
kordinals.MVDM.152='_em86Is32Sel'
kordinals.MVDM.153='INTGetIRR'
kordinals.MVDM.154='VDHWaitRamSem'
kordinals.MVDM.155='VDHPortIO'
kordinals.MVDM.156='VDHVMDetach'
kordinals.MVDM.157='VDHGetFlags'
kordinals.DOSCALLS.1='DOSICREATETHREAD'
kordinals.DOSCALLS.2='DOSCWAIT'
kordinals.DOSCALLS.3='DOSENTERCRITSEC'
kordinals.DOSCALLS.4='DOSIEXECPGM'
kordinals.DOSCALLS.5='DOSEXIT'
kordinals.DOSCALLS.6='DOSEXITCRITSEC'
kordinals.DOSCALLS.7='DOSEXITLIST'
kordinals.DOSCALLS.8='DOSGETINFOSEG'
kordinals.DOSCALLS.9='DOSGETPRTY'
kordinals.DOSCALLS.10='DOSKILLPROCESS'
kordinals.DOSCALLS.11='DOSSETPRTY'
kordinals.DOSCALLS.12='DOSPTRACE'
kordinals.DOSCALLS.13='DOSHOLDSIGNAL'
kordinals.DOSCALLS.14='DOSSETSIGHANDLER'
kordinals.DOSCALLS.15='DOSFLAGPROCESS'
kordinals.DOSCALLS.16='DOSMAKEPIPE'
kordinals.DOSCALLS.17='DOSISYSSEMCLEAR'
kordinals.DOSCALLS.18='DOSISEMREQUEST'
kordinals.DOSCALLS.19='DOSISYSSEMSET'
kordinals.DOSCALLS.20='DOSSEMSETWAIT'
kordinals.DOSCALLS.21='DOSISEMWAIT'
kordinals.DOSCALLS.22='DOSMUXSEMWAIT'
kordinals.DOSCALLS.23='DOSCLOSESEM'
kordinals.DOSCALLS.24='DOSCREATESEM'
kordinals.DOSCALLS.25='DOSOPENSEM'
kordinals.DOSCALLS.26='DOSRESUMETHREAD'
kordinals.DOSCALLS.27='DOSSUSPENDTHREAD'
kordinals.DOSCALLS.28='DOSSETDATETIME'
kordinals.DOSCALLS.29='DOSTIMERASYNC'
kordinals.DOSCALLS.30='DOSTIMERSTART'
kordinals.DOSCALLS.31='DOSTIMERSTOP'
kordinals.DOSCALLS.32='DOSSLEEP'
kordinals.DOSCALLS.33='DOSGETDATETIME'
kordinals.DOSCALLS.34='DOSALLOCSEG'
kordinals.DOSCALLS.35='DOSALLOCSHRSEG'
kordinals.DOSCALLS.36='DOSGETSHRSEG'
kordinals.DOSCALLS.37='DOSGIVESEG'
kordinals.DOSCALLS.38='DOSREALLOCSEG'
kordinals.DOSCALLS.39='DOSFREESEG'
kordinals.DOSCALLS.40='DOSALLOCHUGE'
kordinals.DOSCALLS.41='DOSGETHUGESHIFT'
kordinals.DOSCALLS.42='DOSREALLOCHUGE'
kordinals.DOSCALLS.43='DOSCREATECSALIAS'
kordinals.DOSCALLS.44='DOSLOADMODULE'
kordinals.DOSCALLS.45='DOSGETPROCADDR'
kordinals.DOSCALLS.46='DOSFREEMODULE'
kordinals.DOSCALLS.47='DOSGETMODHANDLE'
kordinals.DOSCALLS.48='DOSGETMODNAME'
kordinals.DOSCALLS.49='DOSGETMACHINEMODE'
kordinals.DOSCALLS.50='DOSBEEP'
kordinals.DOSCALLS.51='DOSCLIACCESS'
kordinals.DOSCALLS.52='DOSDEVCONFIG'
kordinals.DOSCALLS.53='DOSDEVIOCTL'
kordinals.DOSCALLS.54='DOSSGSWITCH'
kordinals.DOSCALLS.55='DOSSGSWITCHME'
kordinals.DOSCALLS.56='DOSBUFRESET'
kordinals.DOSCALLS.57='DOSCHDIR'
kordinals.DOSCALLS.58='DOSCHGFILEPTR'
kordinals.DOSCALLS.59='DOSCLOSE'
kordinals.DOSCALLS.60='DOSDELETE'
kordinals.DOSCALLS.61='DOSDUPHANDLE'
kordinals.DOSCALLS.62='DOSFILELOCKS'
kordinals.DOSCALLS.63='DOSFINDCLOSE'
kordinals.DOSCALLS.64='DOSFINDFIRST'
kordinals.DOSCALLS.65='DOSFINDNEXT'
kordinals.DOSCALLS.66='DOSMKDIR'
kordinals.DOSCALLS.67='DOSMOVE'
kordinals.DOSCALLS.68='DOSNEWSIZE'
kordinals.DOSCALLS.69='DOSPORTACCESS'
kordinals.DOSCALLS.70='DOSOPEN'
kordinals.DOSCALLS.71='DOSQCURDIR'
kordinals.DOSCALLS.72='DOSQCURDISK'
kordinals.DOSCALLS.73='DOSQFHANDSTATE'
kordinals.DOSCALLS.74='DOSQFILEINFO'
kordinals.DOSCALLS.75='DOSQFILEMODE'
kordinals.DOSCALLS.76='DOSQFSINFO'
kordinals.DOSCALLS.77='DOSQHANDTYPE'
kordinals.DOSCALLS.78='DOSQVERIFY'
kordinals.DOSCALLS.79='DOSIREAD'
kordinals.DOSCALLS.80='DOSRMDIR'
kordinals.DOSCALLS.81='DOSSELECTDISK'
kordinals.DOSCALLS.82='DOSSETFHANDSTATE'
kordinals.DOSCALLS.83='DOSSETFILEINFO'
kordinals.DOSCALLS.84='DOSSETFILEMODE'
kordinals.DOSCALLS.85='DOSSETMAXFH'
kordinals.DOSCALLS.86='DOSSETVERIFY'
kordinals.DOSCALLS.87='DOSIWRITE'
kordinals.DOSCALLS.88='DOSSYSTEMSERVICE'
kordinals.DOSCALLS.89='DOSSETVEC'
kordinals.DOSCALLS.90='DOSSYSTRACE'
kordinals.DOSCALLS.91='DOSGETENV'
kordinals.DOSCALLS.92='DOSGETVERSION'
kordinals.DOSCALLS.93='DOSQTRACEINFO'
kordinals.DOSCALLS.94='DOSGETPID'
kordinals.DOSCALLS.95='DOSOPEN2'
kordinals.DOSCALLS.96='DOSLIBINIT'
kordinals.DOSCALLS.97='DOSSETFSINFO'
kordinals.DOSCALLS.98='DOSQPATHINFO'
kordinals.DOSCALLS.99='DOSDEVIOCTL2'
kordinals.DOSCALLS.100='DOSICANONICALIZE'
kordinals.DOSCALLS.101='DOSSETFGND'
kordinals.DOSCALLS.102='DOSSWAPTASKINIT'
kordinals.DOSCALLS.103='DOSREADPHYS'
kordinals.DOSCALLS.104='DOSSETPATHINFO'
kordinals.DOSCALLS.105='DOSSGSWITCHPROC2'
kordinals.DOSCALLS.106='STRUCHECK'
kordinals.DOSCALLS.107='STRURESUPDATE'
kordinals.DOSCALLS.108='DOSISETRELMAXFH'
kordinals.DOSCALLS.109='DOSIDEVIOCTL'
kordinals.DOSCALLS.110='DOS32FORCEDELETE'
kordinals.DOSCALLS.111='DOS32KILLTHREAD'
kordinals.DOSCALLS.112='DOSQUERYRASINFO'
kordinals.DOSCALLS.113='DOS32DUMPPROCESS'
kordinals.DOSCALLS.114='DOS32SUPPRESSPOPUPS'
kordinals.DOSCALLS.118='DOSOPEN2COMPT'
kordinals.DOSCALLS.119='DOSGETSTDA'
kordinals.DOSCALLS.120='DOSERROR'
kordinals.DOSCALLS.121='DOSGETSEG'
kordinals.DOSCALLS.122='DOSLOCKSEG'
kordinals.DOSCALLS.123='DOSUNLOCKSEG'
kordinals.DOSCALLS.124='DOSSGSWITCHPROC'
kordinals.DOSCALLS.125='DOSIRAMSEMWAKE'
kordinals.DOSCALLS.126='DOSSIZESEG'
kordinals.DOSCALLS.127='DOSMEMAVAIL'
kordinals.DOSCALLS.128='DOSIRAMSEMREQUEST'
kordinals.DOSCALLS.129='DOSPHYSICALDISK'
kordinals.DOSCALLS.130='DOSGETCP'
kordinals.DOSCALLS.131='DOSISETCP'
kordinals.DOSCALLS.132='DOSGLOBALSEG'
kordinals.DOSCALLS.133='DOSPROFILE'
kordinals.DOSCALLS.134='DOSSENDSIGNAL'
kordinals.DOSCALLS.135='DOSHUGESHIFT'
kordinals.DOSCALLS.136='DOSHUGEINCR'
kordinals.DOSCALLS.137='DOSREAD'
kordinals.DOSCALLS.138='DOSWRITE'
kordinals.DOSCALLS.139='DOSERRCLASS'
kordinals.DOSCALLS.140='DOSSEMREQUEST'
kordinals.DOSCALLS.141='DOSSEMCLEAR'
kordinals.DOSCALLS.142='DOSSEMWAIT'
kordinals.DOSCALLS.143='DOSSEMSET'
kordinals.DOSCALLS.144='DOSEXECPGM'
kordinals.DOSCALLS.145='DOSCREATETHREAD'
kordinals.DOSCALLS.146='DOSSUBSET'
kordinals.DOSCALLS.147='DOSSUBALLOC'
kordinals.DOSCALLS.148='DOSSUBFREE'
kordinals.DOSCALLS.149='DOSREADASYNC'
kordinals.DOSCALLS.150='DOSWRITEASYNC'
kordinals.DOSCALLS.151='DOSSEARCHPATH'
kordinals.DOSCALLS.152='DOSSCANENV'
kordinals.DOSCALLS.153='DOSSETCP'
kordinals.DOSCALLS.154='DOSQPROCSTATUS'
kordinals.DOSCALLS.155='DOSGETRESOURCE'
kordinals.DOSCALLS.156='DOSGETPPID'
kordinals.DOSCALLS.157='DOSCALLBACK'
kordinals.DOSCALLS.158='DOSICALLBACK'
kordinals.DOSCALLS.159='DOSRETFORWARD'
kordinals.DOSCALLS.160='DOSR2STACKREALLOC'
kordinals.DOSCALLS.161='DOSFSRAMSEMREQUEST'
kordinals.DOSCALLS.162='DOSFSRAMSEMCLEAR'
kordinals.DOSCALLS.163='DOSQAPPTYPE'
kordinals.DOSCALLS.164='DOSSETPROCCP'
kordinals.DOSCALLS.165='DOSDYNAMICTRACE'
kordinals.DOSCALLS.166='DOSQSYSINFO'
kordinals.DOSCALLS.167='DOSIMAKENMPIPE'
kordinals.DOSCALLS.168='DOSICALLNMPIPE'
kordinals.DOSCALLS.169='DOSICONNECTNMPIPE'
kordinals.DOSCALLS.170='DOSIDISCONNECTNMPIPE'
kordinals.DOSCALLS.171='DOSIPEEKNMPIPE'
kordinals.DOSCALLS.172='DOSIQNMPIPEINFO'
kordinals.DOSCALLS.173='DOSIQNMPHANDSTATE'
kordinals.DOSCALLS.174='DOSISETNMPHANDSTATE'
kordinals.DOSCALLS.175='DOSITRANSACTNMPIPE'
kordinals.DOSCALLS.176='DOSIWAITNMPIPE'
kordinals.DOSCALLS.177='DOSISETNMPIPESEM'
kordinals.DOSCALLS.178='DOSIQNMPIPESEMSTATE'
kordinals.DOSCALLS.179='DOSIRAWREADNMPIPE'
kordinals.DOSCALLS.180='DOSIRAWWRITENMPIPE'
kordinals.DOSCALLS.181='DOSFSATTACH'
kordinals.DOSCALLS.182='DOSQFSATTACH'
kordinals.DOSCALLS.183='DOSFSCTL'
kordinals.DOSCALLS.184='DOSFINDFIRST2'
kordinals.DOSCALLS.185='DOSMKDIR2'
kordinals.DOSCALLS.186='DOSFILEIO'
kordinals.DOSCALLS.187='DOSFINDNOTIFYCLOSE'
kordinals.DOSCALLS.188='DOSFINDNOTIFYFIRST'
kordinals.DOSCALLS.189='DOSFINDNOTIFYNEXT'
kordinals.DOSCALLS.190='DOSSETTRACEINFO'
kordinals.DOSCALLS.191='DOSEDITNAME'
kordinals.DOSCALLS.192='DOSLOGMODE'
kordinals.DOSCALLS.193='DOSLOGENTRY'
kordinals.DOSCALLS.194='DOSGETLOGBUFFER'
kordinals.DOSCALLS.195='DOSLOGREGISTER'
kordinals.DOSCALLS.196='DOSLOGREAD'
kordinals.DOSCALLS.197='DOSFINDFROMNAME'
kordinals.DOSCALLS.198='DOSOPLOCKRELEASE'
kordinals.DOSCALLS.199='DOSOPLOCKWAIT'
kordinals.DOSCALLS.200='DOSICOPY'
kordinals.DOSCALLS.201='DOSCOPY'
kordinals.DOSCALLS.202='DOSIQAPPTYPE'
kordinals.DOSCALLS.203='DOSFORCEDELETE'
kordinals.DOSCALLS.204='DOSENUMATTRIBUTE'
kordinals.DOSCALLS.205='DOSOPLOCKSHUTDOWN'
kordinals.DOSCALLS.206='DOSSHUTDOWN'
kordinals.DOSCALLS.207='DOSGETRESOURCE2'
kordinals.DOSCALLS.208='DOSFREERESOURCE'
kordinals.DOSCALLS.209='DOS32SETMAXFH'
kordinals.DOSCALLS.210='DOS32SETVERIFY'
kordinals.DOSCALLS.211='DOS32ERRCLASS'
kordinals.DOSCALLS.212='DOS32ERROR'
kordinals.DOSCALLS.213='DOSCREATEVDM'
kordinals.DOSCALLS.214='DOSMAXPATHLEN'
kordinals.DOSCALLS.215='DOSPAGESIZE'
kordinals.DOSCALLS.216='DOSLOCALINFO'
kordinals.DOSCALLS.217='DOSGLOBALINFO'
kordinals.DOSCALLS.218='DOS32SETFILEINFO'
kordinals.DOSCALLS.219='DOS32SETPATHINFO'
kordinals.DOSCALLS.220='DOS32SETDEFAULTDISK'
kordinals.DOSCALLS.221='DOS32SETFHSTATE'
kordinals.DOSCALLS.222='DOS32SETFSINFO'
kordinals.DOSCALLS.223='DOS32QUERYPATHINFO'
kordinals.DOSCALLS.224='DOS32QUERYHTYPE'
kordinals.DOSCALLS.225='DOS32QUERYVERIFY'
kordinals.DOSCALLS.226='DOS32DELETEDIR'
kordinals.DOSCALLS.227='DOS32SCANENV'
kordinals.DOSCALLS.228='DOS32SEARCHPATH'
kordinals.DOSCALLS.229='DOS32SLEEP'
kordinals.DOSCALLS.230='DOS32GETDATETIME'
kordinals.DOSCALLS.231='DOS32DEVCONFIG'
kordinals.DOSCALLS.232='DOS32ENTERCRITSEC'
kordinals.DOSCALLS.233='DOS32EXITCRITSEC'
kordinals.DOSCALLS.234='DOS32EXIT'
kordinals.DOSCALLS.235='DOS32KILLPROCESS'
kordinals.DOSCALLS.236='DOS32SETPRIORITY'
kordinals.DOSCALLS.237='DOS32RESUMETHREAD'
kordinals.DOSCALLS.238='DOS32SUSPENDTHREAD'
kordinals.DOSCALLS.239='DOS32CREATEPIPE'
kordinals.DOSCALLS.240='DOS32CALLNPIPE'
kordinals.DOSCALLS.241='DOS32CONNECTNPIPE'
kordinals.DOSCALLS.242='DOS32DISCONNECTNPIPE'
kordinals.DOSCALLS.243='DOS32CREATENPIPE'
kordinals.DOSCALLS.244='DOS32PEEKNPIPE'
kordinals.DOSCALLS.245='DOS32QUERYNPHSTATE'
kordinals.DOSCALLS.246='DOS32RAWREADNPIPE'
kordinals.DOSCALLS.247='DOS32RAWWRITENPIPE'
kordinals.DOSCALLS.248='DOS32QUERYNPIPEINFO'
kordinals.DOSCALLS.249='DOS32QUERYNPIPESEMSTATE'
kordinals.DOSCALLS.250='DOS32SETNPHSTATE'
kordinals.DOSCALLS.251='DOS32SETNPIPESEM'
kordinals.DOSCALLS.252='DOS32TRANSACTNPIPE'
kordinals.DOSCALLS.253='DOS32WAITNPIPE'
kordinals.DOSCALLS.254='DOS32RESETBUFFER'
kordinals.DOSCALLS.255='DOS32SETCURRENTDIR'
kordinals.DOSCALLS.256='DOS32SETFILEPTR'
kordinals.DOSCALLS.257='DOS32CLOSE'
kordinals.DOSCALLS.258='DOS32COPY'
kordinals.DOSCALLS.259='DOS32DELETE'
kordinals.DOSCALLS.260='DOS32DUPHANDLE'
kordinals.DOSCALLS.261='DOS32EDITNAME'
kordinals.DOSCALLS.263='DOS32FINDCLOSE'
kordinals.DOSCALLS.264='DOS32FINDFIRST'
kordinals.DOSCALLS.265='DOS32FINDNEXT'
kordinals.DOSCALLS.266='DOSOPENVDD'
kordinals.DOSCALLS.267='DOSREQUESTVDD'
kordinals.DOSCALLS.268='DOSCLOSEVDD'
kordinals.DOSCALLS.269='DOS32FSATTACH'
kordinals.DOSCALLS.270='DOS32CREATEDIR'
kordinals.DOSCALLS.271='DOS32MOVE'
kordinals.DOSCALLS.272='DOS32SETFILESIZE'
kordinals.DOSCALLS.273='DOS32OPEN'
kordinals.DOSCALLS.274='DOS32QUERYCURRENTDIR'
kordinals.DOSCALLS.275='DOS32QUERYCURRENTDISK'
kordinals.DOSCALLS.276='DOS32QUERYFHSTATE'
kordinals.DOSCALLS.277='DOS32QUERYFSATTACH'
kordinals.DOSCALLS.278='DOS32QUERYFSINFO'
kordinals.DOSCALLS.279='DOS32QUERYFILEINFO'
kordinals.DOSCALLS.280='DOS32WAITCHILD'
kordinals.DOSCALLS.281='DOS32READ'
kordinals.DOSCALLS.282='DOS32WRITE'
kordinals.DOSCALLS.283='DOS32EXECPGM'
kordinals.DOSCALLS.284='DOS32DEVIOCTL'
kordinals.DOSCALLS.285='DOS32FSCTL'
kordinals.DOSCALLS.286='DOS32BEEP'
kordinals.DOSCALLS.287='DOS32PHYSICALDISK'
kordinals.DOSCALLS.288='DOS32SETCP'
kordinals.DOSCALLS.289='DOS32SETPROCESSCP'
kordinals.DOSCALLS.290='DOS32STOPTIMER'
kordinals.DOSCALLS.291='DOS32QUERYCP'
kordinals.DOSCALLS.292='DOS32SETDATETIME'
kordinals.DOSCALLS.293='THK32ALLOCBLOCK'
kordinals.DOSCALLS.294='THK32FREEBLOCK'
kordinals.DOSCALLS.295='THK32R3DS'
kordinals.DOSCALLS.296='DOS32EXITLIST'
kordinals.DOSCALLS.297='DOS32ALLOCPROTECTEDMEM'
kordinals.DOSCALLS.298='DOS32ALIASMEM'
kordinals.DOSCALLS.299='DOS32ALLOCMEM'
kordinals.DOSCALLS.300='DOS32ALLOCSHAREDMEM'
kordinals.DOSCALLS.301='DOS32GETNAMEDSHAREDMEM'
kordinals.DOSCALLS.302='DOS32GETSHAREDMEM'
kordinals.DOSCALLS.303='DOS32GIVESHAREDMEM'
kordinals.DOSCALLS.304='DOS32FREEMEM'
kordinals.DOSCALLS.305='DOS32SETMEM'
kordinals.DOSCALLS.306='DOS32QUERYMEM'
kordinals.DOSCALLS.307='DOS32QUERYMEMSTATE'
kordinals.DOSCALLS.308='DOS32OPENVDD'
kordinals.DOSCALLS.309='DOS32REQUESTVDD'
kordinals.DOSCALLS.310='DOS32CLOSEVDD'
kordinals.DOSCALLS.311='DOS32CREATETHREAD'
kordinals.DOSCALLS.312='DOS32GETINFOBLOCKS'
kordinals.DOSCALLS.313='DOSALLOCPROTSEG'
kordinals.DOSCALLS.314='DOSALLOCSHRPROTSEG'
kordinals.DOSCALLS.315='DOSALLOCPROTHUGE'
kordinals.DOSCALLS.316='DOS32DYNAMICTRACE'
kordinals.DOSCALLS.317='DOS32DEBUG'
kordinals.DOSCALLS.318='DOS32LOADMODULE'
kordinals.DOSCALLS.319='DOS32QUERYMODULEHANDLE'
kordinals.DOSCALLS.320='DOS32QUERYMODULENAME'
kordinals.DOSCALLS.321='DOS32QUERYPROCADDR'
kordinals.DOSCALLS.322='DOS32FREEMODULE'
kordinals.DOSCALLS.323='DOS32QUERYAPPTYPE'
kordinals.DOSCALLS.324='DOS32CREATEEVENTSEM'
kordinals.DOSCALLS.325='DOS32OPENEVENTSEM'
kordinals.DOSCALLS.326='DOS32CLOSEEVENTSEM'
kordinals.DOSCALLS.327='DOS32RESETEVENTSEM'
kordinals.DOSCALLS.328='DOS32POSTEVENTSEM'
kordinals.DOSCALLS.329='DOS32WAITEVENTSEM'
kordinals.DOSCALLS.330='DOS32QUERYEVENTSEM'
kordinals.DOSCALLS.331='DOS32CREATEMUTEXSEM'
kordinals.DOSCALLS.332='DOS32OPENMUTEXSEM'
kordinals.DOSCALLS.333='DOS32CLOSEMUTEXSEM'
kordinals.DOSCALLS.334='DOS32REQUESTMUTEXSEM'
kordinals.DOSCALLS.335='DOS32RELEASEMUTEXSEM'
kordinals.DOSCALLS.336='DOS32QUERYMUTEXSEM'
kordinals.DOSCALLS.337='DOS32CREATEMUXWAITSEM'
kordinals.DOSCALLS.338='DOS32OPENMUXWAITSEM'
kordinals.DOSCALLS.339='DOS32CLOSEMUXWAITSEM'
kordinals.DOSCALLS.340='DOS32WAITMUXWAITSEM'
kordinals.DOSCALLS.341='DOS32ADDMUXWAITSEM'
kordinals.DOSCALLS.342='DOS32DELETEMUXWAITSEM'
kordinals.DOSCALLS.343='DOS32QUERYMUXWAITSEM'
kordinals.DOSCALLS.344='DOS32SUBSETMEM'
kordinals.DOSCALLS.345='DOS32SUBALLOCMEM'
kordinals.DOSCALLS.346='DOS32SUBFREEMEM'
kordinals.DOSCALLS.347='DOS32SUBUNSETMEM'
kordinals.DOSCALLS.348='DOS32QUERYSYSINFO'
kordinals.DOSCALLS.349='DOS32WAITTHREAD'
kordinals.DOSCALLS.350='DOS32ASYNCTIMER'
kordinals.DOSCALLS.351='DOS32STARTTIMER'
kordinals.DOSCALLS.352='DOS32GETRESOURCE'
kordinals.DOSCALLS.353='DOS32FREERESOURCE'
kordinals.DOSCALLS.354='DOS32SETEXCEPTIONHANDLER'
kordinals.DOSCALLS.355='DOS32UNSETEXCEPTIONHANDLER'
kordinals.DOSCALLS.356='DOS32RAISEEXCEPTION'
kordinals.DOSCALLS.357='DOS32UNWINDEXCEPTION'
kordinals.DOSCALLS.358='DOS32QUERYPAGEUSAGE'
kordinals.DOSCALLS.359='DOSQUERYMODFROMCS'
kordinals.DOSCALLS.360='DOS32QUERYMODFROMEIP'
kordinals.DOSCALLS.361='DOSFPDATAAREA'
kordinals.DOSCALLS.362='DOS32TMRQUERYFREQ'
kordinals.DOSCALLS.363='DOS32TMRQUERYTIME'
kordinals.DOSCALLS.364='DOS32ALIASPERFCTRS'
kordinals.DOSCALLS.365='DOS32CONFIGUREPERF'
kordinals.DOSCALLS.366='DOS32DECONPERF'
kordinals.DOSCALLS.367='DOS32REGISTERPERFCTRS'
kordinals.DOSCALLS.368='DOS32QUERYSYSSTATE'
kordinals.DOSCALLS.369='DOS32FLATCS'
kordinals.DOSCALLS.370='DOS32FLATDS'
kordinals.DOSCALLS.371='DOS32QUERYABIOSSUPPORT'
kordinals.DOSCALLS.372='DOS32ENUMATTRIBUTE'
kordinals.DOSCALLS.373='DOS32QUERYDOSPROPERTY'
kordinals.DOSCALLS.374='DOS32SETDOSPROPERTY'
kordinals.DOSCALLS.375='DOSQUERYDOSPROPERTY'
kordinals.DOSCALLS.376='DOSSETDOSPROPERTY'
kordinals.DOSCALLS.377='DOS32PROFILE'
kordinals.DOSCALLS.378='DOS32SETSIGNALEXCEPTIONFOC'
kordinals.DOSCALLS.379='DOS32SENDSIGNALEXCEPTION'
kordinals.DOSCALLS.380='DOS32ENTERMUSTCOMPLETE'
kordinals.DOSCALLS.381='DOS32EXITMUSTCOMPLETE'
kordinals.DOSCALLS.382='DOS32SETRELMAXFH'
kordinals.DOSCALLS.383='MSGPUTMESSAGE'
kordinals.DOSCALLS.384='MSGTRUEGETMESSAGE'
kordinals.DOSCALLS.385='MSGINSMESSAGE'
kordinals.DOSCALLS.386='MSG32INSERTMESSAGE'
kordinals.DOSCALLS.387='MSG32PUTMESSAGE'
kordinals.DOSCALLS.388='MSG32TRUEGETMESSAGE'
kordinals.DOSCALLS.389='MSGIQUERYMESSAGECP'
kordinals.DOSCALLS.390='MSG32IQUERYMESSAGECP'
kordinals.DOSCALLS.391='NLSCASEMAP'
kordinals.DOSCALLS.392='NLSGETCOLLATE'
kordinals.DOSCALLS.393='NLSGETCTRYINFO'
kordinals.DOSCALLS.394='NLSGETDBCSEV'
kordinals.DOSCALLS.395='NLS32QUERYCTRYINFO'
kordinals.DOSCALLS.396='NLS32QUERYDBCSENV'
kordinals.DOSCALLS.397='NLS32MAPCASE'
kordinals.DOSCALLS.398='NLS32QUERYCOLLATE'
kordinals.DOSCALLS.399='NPIPEMAKENMPIPE'
kordinals.DOSCALLS.400='NPIPEQNMPIPEINFO'
kordinals.DOSCALLS.401='NPIPECONNECTNMPIPE'
kordinals.DOSCALLS.402='NPIPEDISCONNECTNMPIPE'
kordinals.DOSCALLS.403='NPIPEQNMPHANDSTATE'
kordinals.DOSCALLS.404='NPIPESETNMPHANDSTATE'
kordinals.DOSCALLS.405='NPIPEPEEKNMPIPE'
kordinals.DOSCALLS.406='NPIPEWAITNMPIPE'
kordinals.DOSCALLS.407='NPIPETRANSACTNMPIPE'
kordinals.DOSCALLS.408='NPIPECALLNMPIPE'
kordinals.DOSCALLS.409='NPIPERAWREADNMPIPE'
kordinals.DOSCALLS.410='NPIPERAWWRITENMPIPE'
kordinals.DOSCALLS.411='NPIPESETNMPIPESEM'
kordinals.DOSCALLS.412='NPIPEQNMPIPESEMSTATE'
kordinals.DOSCALLS.413='HPFSSTARTLAZYWRITER'
kordinals.DOSCALLS.414='QUEINSTANCEDATA'
kordinals.DOSCALLS.415='DOS32SHUTDOWN'
kordinals.DOSCALLS.416='DOS32ICACHEMODULE'
kordinals.DOSCALLS.417='DOS32REPLACEMODULE'
kordinals.DOSCALLS.418='DOS32ACKNOWLEDGESIGNALEXC'
kordinals.DOSCALLS.419='DOS32TIB'
kordinals.DOSCALLS.420='DOSTMRQUERYFREQ'
kordinals.DOSCALLS.421='DOSTMRQUERYTIME'
kordinals.DOSCALLS.422='DOSREGISTERPERFCTRS'
kordinals.DOSCALLS.423='DOSFLATTOSEL'
kordinals.DOSCALLS.424='DOSSELTOFLAT'
kordinals.DOSCALLS.425='DOS32FLATTOSEL'
kordinals.DOSCALLS.426='DOS32SELTOFLAT'
kordinals.DOSCALLS.427='DOSIODELAYCNT'
kordinals.DOSCALLS.428='DOS32SETFILELOCKS'
kordinals.DOSCALLS.429='DOS32CANCELLOCKREQUEST'
kordinals.DOSCALLS.430='LOGOPEN'
kordinals.DOSCALLS.431='LOGCLOSE'
kordinals.DOSCALLS.432='LOGADDENTRIES'
kordinals.DOSCALLS.433='LOGGETENTRIES'
kordinals.DOSCALLS.434='LOGSETSTATE'
kordinals.DOSCALLS.435='LOGSETNAME'
kordinals.DOSCALLS.436='LOGQUERYSTATE'
kordinals.DOSCALLS.437='DOSOPENCHANGENOTIFY'
kordinals.DOSCALLS.438='DOSRESETCHANGENOTIFY'
kordinals.DOSCALLS.439='DOSCLOSECHANGENOTIFY'
kordinals.DOSCALLS.440='DOS32OPENCHANGENOTIFY'
kordinals.DOSCALLS.441='DOS32RESETCHANGENOTIFY'
kordinals.DOSCALLS.442='DOS32CLOSECHANGENOTIFY'
kordinals.DOSCALLS.443='DOSQUERYABIOSSUPPORT'
kordinals.DOSCALLS.444='DOS32FORCESYSTEMDUMP'
kordinals.DOSCALLS.Y454='DOS32ALLOCTHREADLOCALMEMOR'
kordinals.DOSCALLS.455='DOS32FREETHREADLOCALMEMORY'
kordinals.DOSCALLS.460='DOS32VERIFYPIDTID'
kordinals.DOSCALLS.464='PTDA_LANMAN_SEC'
kordinals.DOSCALLS.465='PTDA_PID'
kordinals.DOSCALLS.466='SAS_SEL'
kordinals.DOSCALLS.467='TCB_OPCOOKIE'
kordinals.DOSCALLS.468='TCB_OPFLAGS'
kordinals.DOSCALLS.469='TCB_NEWFLAGS'
kordinals.DOSCALLS.470='TCB_USER_ID'
kordinals.DOSCALLS.471='TCB_PROC_ID'
kordinals.DOSCALLS.472='TCB_FSHARING'
kordinals.DOSCALLS.473='TCB_SRVATTRIB'
kordinals.DOSCALLS.474='TCB_ALLOWED'
kordinals.DOSCALLS.475='TCB_PRTCB'
kordinals.DOSCALLS.476='TCB_NUMBER'
kordinals.DOSCALLS.477='TCB_THISSFT'
kordinals.DOSCALLS.478='TCB_THISCDS'
kordinals.DOSCALLS.479='TKOPTDA'
kordinals.DOSCALLS.480='PTDA_CRITSEC'
kordinals.DOSCALLS.481='PTDA_HOLDSIGCNT'
kordinals.DOSCALLS.482='PTDA_PPTDAPARENT'
kordinals.DOSCALLS.483='PTDA_PGDATA'
kordinals.DOSCALLS.484='PTDA_HANDLE'
kordinals.DOSCALLS.485='PTDA_MODULE'
kordinals.DOSCALLS.486='PTDA_LDTHANDLE'
kordinals.DOSCALLS.487='PTDA_CODEPAGE_TAG'
kordinals.DOSCALLS.488='PTDA_JFN_LENGTH'
kordinals.DOSCALLS.489='PTDA_JFN_PTABLE'
kordinals.DOSCALLS.490='PTDA_JFN_FLG_PTR'
kordinals.DOSCALLS.491='PTDA_EXTERR_LOCUS'
kordinals.DOSCALLS.492='PTDA_EXTERR'
kordinals.DOSCALLS.493='PTDA_EXTERR_ACTION'
kordinals.DOSCALLS.494='PTDA_EXTERR_CLASS'
kordinals.DOSCALLS.495='PTDA_PPID'
kordinals.DOSCALLS.496='PTDA_PROCTYPE'
kordinals.DOSCALLS.497='PTDA_CURRTCB'
kordinals.DOSCALLS.498='PTDA_CURRTSD'
kordinals.DOSCALLS.499='PTDA_SIGNATURE'
kordinals.DOSCALLS.545='DOS32EXCEPTIONCALLBACK'
kordinals.DOSCALLS.548='DOS32R3EXCEPTIONDISPATCHER'
kordinals.DOSCALLS.549='DOSLIBIDISP'
kordinals.DOSCALLS.550='DOSLIBIDISP16'
kordinals.DOSCALLS.551='DOSLIBIDISP32'
kordinals.DOSCALLS.552='DOSR3EXITADDR'
kordinals.DOSCALLS.553='DOS32R3EXITADDR'
kordinals.DOSCALLS.554='DOS32IREAD'
kordinals.DOSCALLS.556='DOS32IWRITE'
kordinals.DOSCALLS.565='DOSISETFILEINFO'
kordinals.DOSCALLS.566='DOSISETPATHINFO'
kordinals.DOSCALLS.569='DOSIFINDNEXT'
kordinals.DOSCALLS.572='DOS32QUERYRESOURCESIZE'
kordinals.DOSCALLS.573='DOSQUERYRESOURCESIZE'
kordinals.DOSCALLS.574='DOSPMSEMWAIT'
kordinals.DOSCALLS.575='DOSPMMUXSEMWAIT'
kordinals.DOSCALLS.576='THK16_UNITHUNK'
kordinals.DOSCALLS.577='HT16_STARTUP'
kordinals.DOSCALLS.580='DOS32INITIALIZEPORTHOLE'
kordinals.DOSCALLS.582='DOS32QUERYHEADERINFO'
kordinals.DOSCALLS.583='DOSINITIALIZEPORTHOLE'
kordinals.DOSCALLS.584='DOSQUERYHEADERINFO'
kordinals.DOSCALLS.585='MON32MONREAD'
kordinals.DOSCALLS.586='DOS32QUERYPROCTYPE'
kordinals.DOSCALLS.587='DOSQUERYPROCTYPE'
kordinals.DOSCALLS.588='MON32MONWRITE'
kordinals.DOSCALLS.589='DOSISIGDISPATCH'
kordinals.DOSCALLS.592='DOS32DLLTERMDISP'
kordinals.DOSCALLS.594='DOS32IRAISEEXCEPTION'
kordinals.DOSCALLS.597='DOS32IQUERYFHSTATE'
kordinals.DOSCALLS.598='DOS32ISETFHSTATE'
kordinals.DOSCALLS.599='DOSLDTSEL'
kordinals.DOSCALLS.600='DOS32R3FRESTOR'
kordinals.DOSCALLS.601='DOSIFINDFIRST'
kordinals.DOSCALLS.615='DOS32IPROTECTWRITE'
kordinals.DOSCALLS.617='DOSIPROTECTSETFILEINFO'
kordinals.DOSCALLS.618='DOS32IPROTECTSETFILEINFO'
kordinals.DOSCALLS.619='DOS32IPROTECTSETFHSTATE'
kordinals.DOSCALLS.620='DOS32IPROTECTQUERYFHSTATE'
kordinals.DOSCALLS.621='DOS32PROTECTSETFILEPTR'
kordinals.DOSCALLS.622='DOSPROTECTCLOSE'
kordinals.DOSCALLS.623='DOSPROTECTFILEIO'
kordinals.DOSCALLS.624='DOSPROTECTFILELOCKS'
kordinals.DOSCALLS.625='DOSIPROTECTREAD'
kordinals.DOSCALLS.626='DOSIPROTECTWRITE'
kordinals.DOSCALLS.627='DOSPROTECTNEWSIZE'
kordinals.DOSCALLS.628='DOSPROTECTOPEN'
kordinals.DOSCALLS.629='DOSPROTECTQFHANDSTATE'
kordinals.DOSCALLS.630='DOSPROTECTSETFHANDSTATE'
kordinals.DOSCALLS.631='DOSPROTECTQFILEINFO'
kordinals.DOSCALLS.632='DOSPROTECTSETFILEINFO'
kordinals.DOSCALLS.634='DOSPROTECTCHGFILEPTR'
kordinals.DOSCALLS.635='DOSPROTECTENUMATTRIBUTE'
kordinals.DOSCALLS.636='DOS32PROTECTENUMATTRIBUTE'
kordinals.DOSCALLS.637='DOS32PROTECTOPEN'
kordinals.DOSCALLS.638='DOS32PROTECTCLOSE'
kordinals.DOSCALLS.639='DOS32PROTECTSETFILELOCKS'
kordinals.DOSCALLS.640='DOS32PROTECTSETFILESIZE'
kordinals.DOSCALLS.641='DOS32PROTECTREAD'
kordinals.DOSCALLS.642='DOS32PROTECTWRITE'
kordinals.DOSCALLS.643='DOS32PROTECTSETFILEINFO'
kordinals.DOSCALLS.644='DOS32PROTECTSETFHSTATE'
kordinals.DOSCALLS.645='DOS32PROTECTQUERYFHSTATE'
kordinals.DOSCALLS.646='DOS32PROTECTQUERYFILEINFO'
kordinals.DOSCALLS.647='DOS32IPROTECTREAD'
kordinals.DOSCALLS.649='MSGCLOSEMESSAGEFILE'
kordinals.DOSCALLS.650='DOSLDRDIRTYWORKER'
kordinals.DOSCALLS.651='DOS16LDRDIRTYWORKER'
kordinals.DOSCALLS.661='QUEDOS32READQUEUE'
kordinals.DOSCALLS.662='QUEDOS32PURGEQUEUE'
kordinals.DOSCALLS.663='QUEDOS32CLOSEQUEUE'
kordinals.DOSCALLS.664='QUEDOS32QUERYQUEUE'
kordinals.DOSCALLS.665='QUEDOS32PEEKQUEUE'
kordinals.DOSCALLS.666='QUEDOS32WRITEQUEUE'
kordinals.DOSCALLS.667='QUEDOS32OPENQUEUE'
kordinals.DOSCALLS.668='QUEDOS32CREATEQUEUE'
kordinals.DOSCALLS.669='SMGDOS32STARTSESSION'
kordinals.DOSCALLS.670='SMGDOS32SELECTSESSION'
kordinals.DOSCALLS.671='SMGDOS32SETSESSION'
kordinals.DOSCALLS.672='SMGDOS32STOPSESSION'
kordinals.DOSCALLS.673='SMGREGISTERNOTIFICATION'
kordinals.DOSCALLS.674='QUEDOSREADQUEUE'
kordinals.DOSCALLS.675='QUEDOSPURGEQUEUE'
kordinals.DOSCALLS.676='QUEDOSCLOSEQUEUE'
kordinals.DOSCALLS.677='QUEDOSQUERYQUEUE'
kordinals.DOSCALLS.678='QUEDOSPEEKQUEUE'
kordinals.DOSCALLS.679='QUEDOSWRITEQUEUE'
kordinals.DOSCALLS.680='QUEDOSOPENQUEUE'
kordinals.DOSCALLS.681='QUEDOSCREATEQUEUE'
kordinals.DOSCALLS.682='CHRDOSSMGETME'
kordinals.DOSCALLS.683='CHRDOSSMFREEMEM'
kordinals.DOSCALLS.684='CHRDOSSMGETSGCB'
kordinals.DOSCALLS.685='CHRDOSSMINITSGCB'
kordinals.DOSCALLS.686='SMGDOSSMSGDOPOPUP'
kordinals.DOSCALLS.687='SMGDOSSMSWITCH'
kordinals.DOSCALLS.688='SMGDOSSMSERVEAPPREQ'
kordinals.DOSCALLS.689='SMGDOSGETTIMES'
kordinals.DOSCALLS.690='SMGDOSSMSETTITLE'
kordinals.DOSCALLS.691='SMGDOSSCRUNLOCK'
kordinals.DOSCALLS.692='SMGDOSSMDOAPPREQ'
kordinals.DOSCALLS.693='SMGDOSSTOPSESSION'
kordinals.DOSCALLS.694='SMGDOSSELECTSESSION'
kordinals.DOSCALLS.695='SMGDOSSCRLOCK'
kordinals.DOSCALLS.696='SMGDOSSAVREDRAWWAIT'
kordinals.DOSCALLS.697='SMGDOSSAVREDRAWUNDO'
kordinals.DOSCALLS.698='SMGDOSSMSGENDPOPUP'
kordinals.DOSCALLS.699='SMGDOSSETSESSION'
kordinals.DOSCALLS.700='SMGDOSSETMNLOCKTIME'
kordinals.DOSCALLS.701='SMGDOSMODEUNDO'
kordinals.DOSCALLS.702='SMGDOSSTARTSESSION'
kordinals.DOSCALLS.703='SMGDOSSMGETSTATUS'
kordinals.DOSCALLS.704='SMGDOSSMMODEWAIT'
kordinals.DOSCALLS.705='SMGDOSSMTERMINATE'
kordinals.DOSCALLS.706='SMGDOSSMGETAPPREQ'
kordinals.DOSCALLS.707='SMGDOSSMINITIALIZE'
kordinals.DOSCALLS.708='SMGDOSSMSTART'
kordinals.DOSCALLS.709='SMGDOSSMPARENTSWITCH'
kordinals.DOSCALLS.710='SMGDOSSMPAUSE'
kordinals.DOSCALLS.711='SMGDOSSMHDEINIT'
kordinals.DOSCALLS.712='SMGDOSSMPMPRESENT'
kordinals.DOSCALLS.713='SMGDOSSMREGISTERDD'
kordinals.DOSCALLS.714='SMGDOSSMNOTIFYDD'
kordinals.DOSCALLS.715='SMGDOSSMNOTIFYDD2'
kordinals.DOSCALLS.716='SMGDOSSMOPENDD'
kordinals.DOSCALLS.717='SMGDOSSMSETSESSIONTYPE'
kordinals.DOSCALLS.718='CHRBASEINIT'
kordinals.DOSCALLS.719='MOUDOSGETPTRSHAPE'
kordinals.DOSCALLS.720='MOUDOSSETPTRSHAPE'
kordinals.DOSCALLS.721='MOUDOSGETNUMMICKEYS'
kordinals.DOSCALLS.722='MOUDOSGETTHRESHOLD'
kordinals.DOSCALLS.723='MOUDOSSHELLINIT'
kordinals.DOSCALLS.724='MOUDOSGETSCALEFACT'
kordinals.DOSCALLS.725='MOUDOSFLUSHQUE'
kordinals.DOSCALLS.726='MOUDOSGETNUMBUTTONS'
kordinals.DOSCALLS.727='MOUDOSCLOSE'
kordinals.DOSCALLS.728='MOUDOSSETTHRESHOLD'
kordinals.DOSCALLS.729='MOUDOSSETSCALEFACT'
kordinals.DOSCALLS.730='MOUDOSGETNUMQUEEL'
kordinals.DOSCALLS.731='MOUDOSDEREGISTER'
kordinals.DOSCALLS.732='MOUDOSGETEVENTMASK'
kordinals.DOSCALLS.733='MOUDOSSETEVENTMASK'
kordinals.DOSCALLS.734='MOUDOSOPEN'
kordinals.DOSCALLS.735='MOUDOSREMOVEPTR'
kordinals.DOSCALLS.736='MOUDOSGETPTRPOS'
kordinals.DOSCALLS.737='MOUDOSREADEVENTQUE'
kordinals.DOSCALLS.738='MOUDOSSETPTRPOS'
kordinals.DOSCALLS.739='MOUDOSGETDEVSTATUS'
kordinals.DOSCALLS.740='MOUDOSSYNCH'
kordinals.DOSCALLS.741='MOUDOSREGISTER'
kordinals.DOSCALLS.742='MOUDOSSETDEVSTATUS'
kordinals.DOSCALLS.743='MOUDOSDRAWPTR'
kordinals.DOSCALLS.744='MOUDOSINITREAL'
kordinals.DOSCALLS.745='KBDDOSSETCUSTXT'
kordinals.DOSCALLS.746='KBDDOSPROCESSINIT'
kordinals.DOSCALLS.747='KBDDOSGETCP'
kordinals.DOSCALLS.748='KBDDOSCHARIN'
kordinals.DOSCALLS.749='KBDDOSSETCP'
kordinals.DOSCALLS.750='KBDDOSLOADINSTANCE'
kordinals.DOSCALLS.751='KBDDOSSYNCH'
kordinals.DOSCALLS.752='KBDDOSREGISTER'
kordinals.DOSCALLS.753='KBDDOSSTRINGIN'
kordinals.DOSCALLS.754='KBDDOSGETSTATUS'
kordinals.DOSCALLS.755='KBDDOSSETSTATUS'
kordinals.DOSCALLS.756='KBDDOSGETFOCUS'
kordinals.DOSCALLS.757='KBDDOSFLUSHBUFFER'
kordinals.DOSCALLS.758='KBDDOSXLATE'
kordinals.DOSCALLS.759='KBDDOSSWITCHFGND'
kordinals.DOSCALLS.760='KBDDOSSHELLINIT'
kordinals.DOSCALLS.761='KBDDOSCLOSE'
kordinals.DOSCALLS.762='KBDDOSFREEFOCUS'
kordinals.DOSCALLS.763='KBDDOSFREE'
kordinals.DOSCALLS.764='KBDDOSDEREGISTER'
kordinals.DOSCALLS.765='KBDDOSSETFGND'
kordinals.DOSCALLS.766='KBDDOSPEEK'
kordinals.DOSCALLS.767='KBDDOSOPEN'
kordinals.DOSCALLS.768='KBDDOSGETHWID'
kordinals.DOSCALLS.769='KBDDOSSETHWID'
kordinals.DOSCALLS.770='VIODOSENDPOPUP'
kordinals.DOSCALLS.771='VIODOSGETPHYSBUF'
kordinals.DOSCALLS.772='VIODOSGETANSI'
kordinals.DOSCALLS.773='VIODOSFREE'
kordinals.DOSCALLS.774='VIODOSSETANSI'
kordinals.DOSCALLS.775='VIODOSDEREGISTER'
kordinals.DOSCALLS.776='VIODOSSCROLLUP'
kordinals.DOSCALLS.777='VIODOSPRTSC'
kordinals.DOSCALLS.778='VIODOSGETCURPOS'
kordinals.DOSCALLS.779='VIODOSWRTCELLSTR'
kordinals.DOSCALLS.780='VIODOSPOPUP'
kordinals.DOSCALLS.781='VIODOSSCROLLRT'
kordinals.DOSCALLS.782='VIODOSWRTCHARSTR'
kordinals.DOSCALLS.783='VIODOSAVS_PRTSC'
kordinals.DOSCALLS.784='VIODOSSETCURPOS'
kordinals.DOSCALLS.785='VIODOSSRFUNBLOCK'
kordinals.DOSCALLS.786='VIODOSSRFBLOCK'
kordinals.DOSCALLS.787='VIODOSSCRUNLOCK'
kordinals.DOSCALLS.788='VIODOSWRTTTY'
kordinals.DOSCALLS.789='VIODOSSAVE'
kordinals.DOSCALLS.790='VIODOSGETMODE'
kordinals.DOSCALLS.791='VIODOSSETMODE'
kordinals.DOSCALLS.792='VIODOSSCRLOCK'
kordinals.DOSCALLS.793='VIODOSREADCELLSTR'
kordinals.DOSCALLS.794='VIODOSSAVREDRAWWAIT'
kordinals.DOSCALLS.795='VIODOSWRTNATTR'
kordinals.DOSCALLS.796='VIODOSGETCURTYPE'
kordinals.DOSCALLS.797='VIODOSSAVREDRAWUNDO'
kordinals.DOSCALLS.798='VIODOSGETFONT'
kordinals.DOSCALLS.799='VIODOSREADCHARSTR'
kordinals.DOSCALLS.800='VIODOSGETBUF'
kordinals.DOSCALLS.801='VIODOSSETCURTYPE'
kordinals.DOSCALLS.802='VIODOSSETFONT'
kordinals.DOSCALLS.803='VIODOSHETINIT'
kordinals.DOSCALLS.804='VIODOSMODEUNDO'
kordinals.DOSCALLS.805='VIODOSSSWSWITCH'
kordinals.DOSCALLS.806='VIODOSMODEWAIT'
kordinals.DOSCALLS.807='VIODOSAVS_PRTSCTOGGLE'
kordinals.DOSCALLS.808='VIODOSGETCP'
kordinals.DOSCALLS.809='VIODOSRESTORE'
kordinals.DOSCALLS.810='VIODOSSETCP'
kordinals.DOSCALLS.811='VIODOSSHOWBUF'
kordinals.DOSCALLS.812='VIODOSSCROLLLF'
kordinals.DOSCALLS.813='VIODOSREGISTER'
kordinals.DOSCALLS.814='VIODOSGETCONFIG'
kordinals.DOSCALLS.815='VIODOSSCROLLDN'
kordinals.DOSCALLS.816='VIODOSWRTCHARSTRATT'
kordinals.DOSCALLS.817='VIODOSGETSTATE'
kordinals.DOSCALLS.818='VIODOSPRTSCTOGGLE'
kordinals.DOSCALLS.819='VIODOSSETSTATE'
kordinals.DOSCALLS.820='VIODOSWRTNCELL'
kordinals.DOSCALLS.821='VIODOSWRTNCHAR'
kordinals.DOSCALLS.822='VIODOSSHELLINIT'
kordinals.DOSCALLS.823='VIODOSASSOCIATE'
kordinals.DOSCALLS.824='VIODOSCREATEPS'
kordinals.DOSCALLS.825='VIODOSDELETESETID'
kordinals.DOSCALLS.826='VIODOSGETDEVICECELLSIZE'
kordinals.DOSCALLS.827='VIODOSGETORG'
kordinals.DOSCALLS.828='VIODOSCREATELOGFONT'
kordinals.DOSCALLS.829='VIODOSDESTROYPS'
kordinals.DOSCALLS.830='VIODOSQUERYSETIDS'
kordinals.DOSCALLS.831='VIODOSSETORG'
kordinals.DOSCALLS.832='VIODOSQUERYFONTS'
kordinals.DOSCALLS.833='VIODOSSETDEVICECELLSIZE'
kordinals.DOSCALLS.834='VIODOSSHOWPS'
kordinals.DOSCALLS.835='VIODOSGETPSADDRESS'
kordinals.DOSCALLS.836='VIODOSQUERYCONSOLE'
kordinals.DOSCALLS.837='VIODOSREDRAWSIZE'
kordinals.DOSCALLS.838='VIODOSGLOBALREG'
kordinals.DOSCALLS.839='XVIODOSSETCASTATE'
kordinals.DOSCALLS.840='XVIODOSCHECKCHARTYPE'
kordinals.DOSCALLS.841='XVIODOSDESTROYCA'
kordinals.DOSCALLS.842='XVIODOSCREATECA'
kordinals.DOSCALLS.843='VIOCDOSHECKCHARTYPE'
kordinals.DOSCALLS.844='XVIODOSGETCASTATE'
kordinals.DOSCALLS.845='BVSDOSMAIN'
kordinals.DOSCALLS.846='BVSDOSREDRAWSIZE'
kordinals.DOSCALLS.847='BVSDOSGETPTRDRAWNAME'
kordinals.DOSCALLS.848='ANSIDOSINJECT'
kordinals.DOSCALLS.849='ANSIDOSKEYDEF'
kordinals.DOSCALLS.850='ANSIDOSINTERP'
kordinals.DOSCALLS.851='BKSDOSMAIN'
kordinals.DOSCALLS.852='BMSDOSMAIN'
kordinals.DOSCALLS.853='MOUDOSGETHOTKEY'
kordinals.DOSCALLS.854='MOUDOSSETHOTKEY'
kordinals.DOSCALLS.855='SMGDOSSMSYSINIT'
kordinals.DOSCALLS.856='SMGQHKEYBDHANDLE'
kordinals.DOSCALLS.857='SMGQHMOUSEHANDLE'
kordinals.DOSCALLS.858='CHRQueueRamSem'
kordinals.DOSCALLS.859='CHRArray'
kordinals.DOSCALLS.860='CHRPIDArray'
kordinals.DOSCALLS.861='CHRInitialized'
kordinals.DOSCALLS.862='CHRArraySize'
kordinals.DOSCALLS.863='CHRBVSGLOBAL'
kordinals.DOSCALLS.864='CHRSMGINSTANCE'
kordinals.DOSCALLS.865='CHRBVHINSTANCE'
kordinals.DOSCALLS.115='THK32ALLOCMEM'
kordinals.DOSCALLS.116='THK32FREEMEM'
kordinals.DOSCALLS.117='THK32ALLOCSTACK'
kordinals.DOSCALLS.262='THK32FREESTACK'
kordinals.DOSCALLS.546='THK32STRLEN'
kordinals.DOSCALLS.547='THK32_UNITHUNK'
kordinals.DOSCALLS.578='HT16_CLEANUP'
kordinals.DOSCALLS.579='HT32_STARTUP'
kordinals.DOSCALLS.581='HT32_CLEANUP'
kordinals.DOSCALLS.590='DOS32PMPOSTEVENTSEM'
kordinals.DOSCALLS.591='DOS32PMWAITEVENTSEM'
kordinals.DOSCALLS.593='DOS32PMREQUESTMUTEXSEM'
kordinals.DOSCALLS.595='DOS32PMWAITMUXWAITSEM'
kordinals.DOSCALLS.596='DOS32PM16SEMCHK'
kordinals.DOSCALLS.866='THK32ALIASMEM'
kordinals.DOSCALLS.867='THK32FREEALIAS'
kordinals.DOSCALLS.868='THK32ALLOCVARLEN'
kordinals.DOSCALLS.869='THK32HANDLEBOUNDARY'
kordinals.DOSCALLS.870='THK32HANDLESTRING'
kordinals.DOSCALLS.871='THK32DEALLOC'
kordinals.DOSCALLS.872='THK32XHNDLR'
kordinals.DOSCALLS.873='DOS32SETEXTLIBPATH'
kordinals.DOSCALLS.874='DOS32QUERYEXTLIBPATH'
kordinals.DOSCALLS.875='DOS32PM16SEMRST'
kordinals.DOSCALLS.876='DOS32SYSCTL'
kordinals.DOSCALLS.998='DOSSETEXTLIBPATH'
kordinals.DOSCALLS.999='DOSQUERYEXTLIBPATH'
kordinals.DOSCALLS.1000='T32EXITLIST'
kordinals.DOSCALLS.1001='T32ALLOCPROTECTEDMEM'
kordinals.DOSCALLS.1002='T32ALIASMEM'
kordinals.DOSCALLS.1003='T32ALLOCMEM'
kordinals.DOSCALLS.1004='T32ALLOCSHAREDMEM'
kordinals.DOSCALLS.1005='T32GETNAMEDSHAREDMEM'
kordinals.DOSCALLS.1006='T32GETSHAREDMEM'
kordinals.DOSCALLS.1007='T32GIVESHAREDMEM'
kordinals.DOSCALLS.1008='T32FREEMEM'
kordinals.DOSCALLS.1009='T32SETMEM'
kordinals.DOSCALLS.1010='T32QUERYMEM'
kordinals.DOSCALLS.1011='T32QUERYMEMSTATE'
kordinals.DOSCALLS.1012='T32OPENVDD'
kordinals.DOSCALLS.1013='T32REQUESTVDD'
kordinals.DOSCALLS.1014='T32CLOSEVDD'
kordinals.DOSCALLS.1015='T32CREATETHREAD'
kordinals.DOSCALLS.1016='T32DYNAMICTRACE'
kordinals.DOSCALLS.1017='T32DEBUG'
kordinals.DOSCALLS.1018='T32QUERYPROCADDR'
kordinals.DOSCALLS.1019='T32CREATEEVENTSEM'
kordinals.DOSCALLS.1020='T32OPENEVENTSEM'
kordinals.DOSCALLS.1021='T32CLOSEEVENTSEM'
kordinals.DOSCALLS.1022='T32RESETEVENTSEM'
kordinals.DOSCALLS.1023='T32POSTEVENTSEM'
kordinals.DOSCALLS.1024='T32WAITEVENTSEM'
kordinals.DOSCALLS.1025='T32QUERYEVENTSEM'
kordinals.DOSCALLS.1026='T32CREATEMUTEXSEM'
kordinals.DOSCALLS.1027='T32OPENMUTEXSEM'
kordinals.DOSCALLS.1028='T32CLOSEMUTEXSEM'
kordinals.DOSCALLS.1029='T32REQUESTMUTEXSEM'
kordinals.DOSCALLS.1030='T32RELEASEMUTEXSEM'
kordinals.DOSCALLS.1031='T32QUERYMUTEXSEM'
kordinals.DOSCALLS.1032='T32CREATEMUXWAITSEM'
kordinals.DOSCALLS.1033='T32OPENMUXWAITSEM'
kordinals.DOSCALLS.1034='T32CLOSEMUXWAITSEM'
kordinals.DOSCALLS.1035='T32WAITMUXWAITSEM'
kordinals.DOSCALLS.1036='T32ADDMUXWAITSEM'
kordinals.DOSCALLS.1037='T32DELETEMUXWAITSEM'
kordinals.DOSCALLS.1038='T32QUERYMUXWAITSEM'
kordinals.DOSCALLS.1039='T32QUERYSYSINFO'
kordinals.DOSCALLS.1040='T32WAITTHREAD'
kordinals.DOSCALLS.1041='T32GETRESOURCE'
kordinals.DOSCALLS.1042='T32FREERESOURCE'
kordinals.DOSCALLS.1043='T32EXCEPTIONCALLBACK'
kordinals.DOSCALLS.1044='T32QUERYPAGEUSAGE'
kordinals.DOSCALLS.1045='T32FORCESYSTEMDUMP'
kordinals.DOSCALLS.1046='TI32ASYNCTIMER'
kordinals.DOSCALLS.1047='TI32STARTTIMER'
kordinals.DOSCALLS.1048='T32QUERYABIOSSUPPORT'
kordinals.DOSCALLS.1049='T32QUERYMODFROMEIP'
kordinals.DOSCALLS.1050='T32ALIASPERFCTRS'
kordinals.DOSCALLS.1051='T32CONFIGUREPERF'
kordinals.DOSCALLS.1052='T32DECONPERF'
kordinals.DOSCALLS.1053='T32REGISTERPERFCTRS'
kordinals.DOSCALLS.1054='T32QUERYSYSSTATE'
kordinals.DOSCALLS.1055='T32IREAD'
kordinals.DOSCALLS.1056='T32IWRITE'
kordinals.DOSCALLS.1057='T32TMRQUERYFREQ'
kordinals.DOSCALLS.1058='T32TMRQUERYTIME'
kordinals.DOSCALLS.1059='T32IMONREAD'
kordinals.DOSCALLS.1060='T32IMONWRITE'
kordinals.DOSCALLS.1061='T32QUERYRESOURCESIZE'
kordinals.DOSCALLS.1062='T32PROFILE'
kordinals.DOSCALLS.1063='T32SETSIGNALEXCEPTIONFOC'
kordinals.DOSCALLS.1064='T32SENDSIGNALEXCEPTION'
kordinals.DOSCALLS.1065='T32STARTTIMER'
kordinals.DOSCALLS.1066='T32STOPTIMER'
kordinals.DOSCALLS.1067='T32ASYNCTIMER'
kordinals.DOSCALLS.1068='T32INITIALIZEPORTHOLE'
kordinals.DOSCALLS.1069='T32QUERYHEADERINFO'
kordinals.DOSCALLS.1070='T32QUERYPROCTYPE'
kordinals.DOSCALLS.1071='T32IEXITMUSTCOMPLETE'
kordinals.DOSCALLS.1072='T32ICACHEMODULE'
kordinals.DOSCALLS.1073='T32DLLTERM'
kordinals.DOSCALLS.1074='T32IRAISEEXCEPTION'
kordinals.DOSCALLS.1075='T32ACKNOWLEDGESIGNALEXC'
kordinals.DOSCALLS.1076='T32QUERYDOSPROPERTY'
kordinals.DOSCALLS.1077='T32SETDOSPROPERTY'
kordinals.DOSCALLS.1078='T32SETFILELOCKS'
kordinals.DOSCALLS.1079='T32CANCELLOCKREQUEST'
kordinals.DOSCALLS.1080='T32KILLTHREAD'
kordinals.DOSCALLS.1081='TQUERYRASINFO'
kordinals.DOSCALLS.1082='T32DUMPPROCESS'
kordinals.DOSCALLS.1083='T32SUPPRESSPOPUPS'
kordinals.DOSCALLS.1084='T32IPROTECTWRITE'
kordinals.DOSCALLS.1085='T32PROTECTSETFILELOCKS'
kordinals.DOSCALLS.1086='T32IPROTECTREAD'
kordinals.DOSCALLS.1087='T32PMPOSTEVENTSEM'
kordinals.DOSCALLS.1088='T32PMWAITEVENTSEM'
kordinals.DOSCALLS.1089='T32PMREQUESTMUTEXSEM'
kordinals.DOSCALLS.1090='T32PMWAITMUXWAITSEM'
kordinals.DOSCALLS.1091='T32PM16SEMCHK'
kordinals.DOSCALLS.1092='T32ALLOCTHREADLOCALMEMORY'
kordinals.DOSCALLS.1093='T32FREETHREADLOCALMEMORY'
kordinals.DOSCALLS.1094='T32SETEXTLIBPATH'
kordinals.DOSCALLS.1095='T32QUERYEXTLIBPATH'
kordinals.DOSCALLS.1096='T32PM16SEMRST'
kordinals.DOSCALLS.1097='T32VERIFYPIDTID'
kordinals.DOSCALLS.1098='T32SYSCTL'

return
oinitord: procedure expose oordinals.
oordinals.=''

oordinals.PMWP.150='AllocMem'
oordinals.PMWP.254='AddRunningProgram'
oordinals.PMWP.130='CleanupDesktop'
oordinals.PMWP.255='CreateDuplicatePointer'
oordinals.PMWP.220='DiskFilter'
oordinals.PMWP.431='DecodeBackgroundData'
oordinals.PMWP.430='EncodeBackgroundData'
oordinals.PMWP.151='FreeMem'
oordinals.PMWP.476='FindOneObject'
oordinals.PMWP.256='GetFrameHandle'
oordinals.PMWP.1='LoadPMWP'
oordinals.PMWP.203='MRILoadResource'
oordinals.PMWP.284='MessageLoopProc'
oordinals.PMWP.310='M_WPFileSystemCClassData'
oordinals.PMWP.311='M_WPFileSystemClassData'
oordinals.PMWP.312='M_WPFileSystemNewClass'
oordinals.PMWP.313='M_WPFolderCClassData'
oordinals.PMWP.314='M_WPFolderClassData'
oordinals.PMWP.315='M_WPFolderNewClass'
oordinals.PMWP.316='M_WPDataFileCClassData'
oordinals.PMWP.317='M_WPDataFileClassData'
oordinals.PMWP.318='M_WPDataFileNewClass'
oordinals.PMWP.319='M_WPTemplatesCClassData'
oordinals.PMWP.320='M_WPTemplatesClassData'
oordinals.PMWP.321='M_WPTemplatesNewClass'
oordinals.PMWP.322='M_WPObjectCClassData'
oordinals.PMWP.323='M_WPObjectClassData'
oordinals.PMWP.324='M_WPObjectNewClass'
oordinals.PMWP.325='M_WPAbstractCClassData'
oordinals.PMWP.326='M_WPAbstractClassData'
oordinals.PMWP.327='M_WPAbstractNewClass'
oordinals.PMWP.328='M_WPShadowCClassData'
oordinals.PMWP.329='M_WPShadowClassData'
oordinals.PMWP.330='M_WPShadowNewClass'
oordinals.PMWP.331='M_WPDiskCClassData'
oordinals.PMWP.332='M_WPDiskClassData'
oordinals.PMWP.333='M_WPDiskNewClass'
oordinals.PMWP.334='M_WPStartupCClassData'
oordinals.PMWP.335='M_WPStartupClassData'
oordinals.PMWP.336='M_WPStartupNewClass'
oordinals.PMWP.337='M_WPTransientCClassData'
oordinals.PMWP.338='M_WPTransientClassData'
oordinals.PMWP.339='M_WPTransientNewClass'
oordinals.PMWP.340='M_WPDrivesCClassData'
oordinals.PMWP.341='M_WPDrivesClassData'
oordinals.PMWP.342='M_WPDrivesNewClass'
oordinals.PMWP.343='M_WPProgramCClassData'
oordinals.PMWP.344='M_WPProgramClassData'
oordinals.PMWP.345='M_WPProgramNewClass'
oordinals.PMWP.346='M_WPProgramFileCClassData'
oordinals.PMWP.347='M_WPProgramFileClassData'
oordinals.PMWP.348='M_WPProgramFileNewClass'
oordinals.PMWP.349='M_WPShredderCClassData'
oordinals.PMWP.350='M_WPShredderClassData'
oordinals.PMWP.351='M_WPShredderNewClass'
oordinals.PMWP.355='M_WPDesktopCClassData'
oordinals.PMWP.356='M_WPDesktopClassData'
oordinals.PMWP.357='M_WPDesktopNewClass'
oordinals.PMWP.358='M_WPRootFolderCClassData'
oordinals.PMWP.359='M_WPRootFolderClassData'
oordinals.PMWP.360='M_WPRootFolderNewClass'
oordinals.PMWP.361='M_WPIconCClassData'
oordinals.PMWP.362='M_WPIconClassData'
oordinals.PMWP.363='M_WPIconNewClass'
oordinals.PMWP.364='M_WPPointerCClassData'
oordinals.PMWP.365='M_WPPointerClassData'
oordinals.PMWP.366='M_WPPointerNewClass'
oordinals.PMWP.367='M_WPBitmapCClassData'
oordinals.PMWP.368='M_WPBitmapClassData'
oordinals.PMWP.369='M_WPBitmapNewClass'
oordinals.PMWP.385='M_WPCommandFileCClassData'
oordinals.PMWP.386='M_WPCommandFileClassData'
oordinals.PMWP.387='M_WPCommandFileNewClass'
oordinals.PMWP.388='M_WPNetworkCClassData'
oordinals.PMWP.389='M_WPNetworkClassData'
oordinals.PMWP.390='M_WPNetworkNewClass'
oordinals.PMWP.391='M_WPNetgrpCClassData'
oordinals.PMWP.392='M_WPNetgrpClassData'
oordinals.PMWP.393='M_WPNetgrpNewClass'
oordinals.PMWP.394='M_WPServerCClassData'
oordinals.PMWP.395='M_WPServerClassData'
oordinals.PMWP.396='M_WPServerNewClass'
oordinals.PMWP.397='M_WPSharedDirCClassData'
oordinals.PMWP.398='M_WPSharedDirClassData'
oordinals.PMWP.399='M_WPSharedDirNewClass'
oordinals.PMWP.400='M_WPNetLinkCClassData'
oordinals.PMWP.401='M_WPNetLinkClassData'
oordinals.PMWP.402='M_WPNetLinkNewClass'
oordinals.PMWP.403='M_WPPifCClassData'
oordinals.PMWP.404='M_WPPifClassData'
oordinals.PMWP.405='M_WPPifNewClass'
oordinals.PMWP.406='M_WPMetCClassData'
oordinals.PMWP.407='M_WPMetClassData'
oordinals.PMWP.408='M_WPMetNewClass'
oordinals.PMWP.435='M_WPMinWindowNewClass'
oordinals.PMWP.439='M_WPCnrViewNewClass'
oordinals.PMWP.441='M_WPFindFolderNewClass'
oordinals.PMWP.443='M_WPProgramGroupNewClass'
oordinals.PMWP.451='M_WPFilterNewClass'
oordinals.PMWP.455='M_WPFinderNewClass'
oordinals.PMWP.459='M_WPMinWinViewerNewClass'
oordinals.PMWP.470='M_WPLaunchPadCClassData'
oordinals.PMWP.471='M_WPLaunchPadClassData'
oordinals.PMWP.472='M_WPLaunchPadNewClass'
oordinals.PMWP.484='M_WPCnrViewCClassData'
oordinals.PMWP.485='M_WPCnrViewClassData'
oordinals.PMWP.230='NWIEnumCache'
oordinals.PMWP.231='NWIEnumNetwork'
oordinals.PMWP.232='NWIQueryCache'
oordinals.PMWP.233='NWIQueryNetwork'
oordinals.PMWP.234='NWIGetNewName'
oordinals.PMWP.235='NWIAuthDefaults'
oordinals.PMWP.236='NWIAuthenticate'
oordinals.PMWP.237='NWIUnAuthenticate'
oordinals.PMWP.238='NWIConnect'
oordinals.PMWP.239='NWIDisconnect'
oordinals.PMWP.240='NWIAllocUNC'
oordinals.PMWP.241='NWIFreeUNC'
oordinals.PMWP.242='NWIGetConnList'
oordinals.PMWP.243='NWIIL'
oordinals.PMWP.244='NWIIP'
oordinals.PMWP.245='NETFillComboBox'
oordinals.PMWP.246='NWIQueryNetCaps'
oordinals.PMWP.247='NWIQueryServerVersion'
oordinals.PMWP.248='NWIEnumInfo'
oordinals.PMWP.249='NWIQueryInfo'
oordinals.PMWP.482='NotifyObjectInCnrOpened'
oordinals.PMWP.202='OldWinCreateObject'
oordinals.PMWP.483='PMWPDateToString'
oordinals.PMWP.101='RestoreDesktop'
oordinals.PMWP.223='ReportMessage'
oordinals.PMWP.257='RelocateObjectMinWindows'
oordinals.PMWP.445='RWMonitorCClassData'
oordinals.PMWP.446='RWMonitorClassData'
oordinals.PMWP.447='RWMonitorNewClass'
oordinals.PMWP.147='ShlInsertContextMenuItems'
oordinals.PMWP.148='ShlInsertSettingsPage'
oordinals.PMWP.204='ShlCreateContextMenu'
oordinals.PMWP.206='ShlQueryFolderFromPath'
oordinals.PMWP.211='ShlStartWorkplace'
oordinals.PMWP.212='ShlExceptionHandler'
oordinals.PMWP.213='ShlSaveEnv'
oordinals.PMWP.214='ShlRestoreEnv'
oordinals.PMWP.215='SHCRT_memcmp'
oordinals.PMWP.217='ShlQueryIconGivenFEAL2'
oordinals.PMWP.218='ShlLoadIcon'
oordinals.PMWP.224='ShlGetUserWordPtr'
oordinals.PMWP.258='SetSysMenu'
oordinals.PMWP.260='SetupFontSample'
oordinals.PMWP.261='SubstituteStrings'
oordinals.PMWP.427='SchemeBackgroundDlgProc'
oordinals.PMWP.428='ShlStoreString'
oordinals.PMWP.429='ShlFreeString'
oordinals.PMWP.473='ShlRealizeDefaultPalette'
oordinals.PMWP.477='ShlCreateTempFile'
oordinals.PMWP.478='ShlDeleteTempFile'
oordinals.PMWP.481='ShlUnloadServer'
oordinals.PMWP.432='UnloadUnitBitmap'
oordinals.PMWP.145='WinStartShell'
oordinals.PMWP.149='WinShutdownSystem'
oordinals.PMWP.200='WinRegisterObjectClass'
oordinals.PMWP.201='WinDeregisterObjectClass'
oordinals.PMWP.205='WinEnumObjectClasses'
oordinals.PMWP.207='WinStoreWindowPos'
oordinals.PMWP.208='WinRestoreWindowPos'
oordinals.PMWP.209='WinLoadFileIcon'
oordinals.PMWP.210='WinSetFileIcon'
oordinals.PMWP.216='WinFreeFileIcon'
oordinals.PMWP.219='WinReplaceObjectClass'
oordinals.PMWP.221='WinRestartWorkplace'
oordinals.PMWP.250='WinSetObjectData'
oordinals.PMWP.251='WinDestroyObject'
oordinals.PMWP.252='WinQueryObject'
oordinals.PMWP.262='WinQueryActiveDesktopPathname'
oordinals.PMWP.263='WinQueryObjectPath'
oordinals.PMWP.281='WinCreateObject'
oordinals.PMWP.282='WinUnlockSystem'
oordinals.PMWP.283='WinLockupSystem'
oordinals.PMWP.285='WinSaveObject'
oordinals.PMWP.286='WinOpenObject'
oordinals.PMWP.287='WinMoveObject'
oordinals.PMWP.288='WinCopyObject'
oordinals.PMWP.289='WinCreateShadow'
oordinals.PMWP.10='WPFileSystemCClassData'
oordinals.PMWP.11='WPFileSystemClassData'
oordinals.PMWP.12='WPFileSystemNewClass'
oordinals.PMWP.13='WPFolderCClassData'
oordinals.PMWP.14='WPFolderClassData'
oordinals.PMWP.15='WPFolderNewClass'
oordinals.PMWP.16='WPDataFileCClassData'
oordinals.PMWP.17='WPDataFileClassData'
oordinals.PMWP.18='WPDataFileNewClass'
oordinals.PMWP.22='WPObjectCClassData'
oordinals.PMWP.23='WPObjectClassData'
oordinals.PMWP.24='WPObjectNewClass'
oordinals.PMWP.25='WPAbstractCClassData'
oordinals.PMWP.26='WPAbstractClassData'
oordinals.PMWP.27='WPAbstractNewClass'
oordinals.PMWP.28='WPTemplatesCClassData'
oordinals.PMWP.29='WPTemplatesClassData'
oordinals.PMWP.30='WPTemplatesNewClass'
oordinals.PMWP.31='WPShadowCClassData'
oordinals.PMWP.32='WPShadowClassData'
oordinals.PMWP.33='WPShadowNewClass'
oordinals.PMWP.34='WPDiskCClassData'
oordinals.PMWP.35='WPDiskClassData'
oordinals.PMWP.36='WPDiskNewClass'
oordinals.PMWP.37='WPStartupCClassData'
oordinals.PMWP.38='WPStartupClassData'
oordinals.PMWP.39='WPStartupNewClass'
oordinals.PMWP.40='WPTransientCClassData'
oordinals.PMWP.41='WPTransientClassData'
oordinals.PMWP.42='WPTransientNewClass'
oordinals.PMWP.43='WPDrivesCClassData'
oordinals.PMWP.44='WPDrivesClassData'
oordinals.PMWP.45='WPDrivesNewClass'
oordinals.PMWP.46='WPProgramCClassData'
oordinals.PMWP.47='WPProgramClassData'
oordinals.PMWP.48='WPProgramNewClass'
oordinals.PMWP.49='WPProgramFileCClassData'
oordinals.PMWP.50='WPProgramFileClassData'
oordinals.PMWP.51='WPProgramFileNewClass'
oordinals.PMWP.52='WPShredderCClassData'
oordinals.PMWP.53='WPShredderClassData'
oordinals.PMWP.54='WPShredderNewClass'
oordinals.PMWP.55='WPDesktopCClassData'
oordinals.PMWP.56='WPDesktopClassData'
oordinals.PMWP.57='WPDesktopNewClass'
oordinals.PMWP.58='WPRootFolderCClassData'
oordinals.PMWP.59='WPRootFolderClassData'
oordinals.PMWP.60='WPRootFolderNewClass'
oordinals.PMWP.61='WPIconCClassData'
oordinals.PMWP.62='WPIconClassData'
oordinals.PMWP.63='WPIconNewClass'
oordinals.PMWP.64='WPPointerCClassData'
oordinals.PMWP.65='WPPointerClassData'
oordinals.PMWP.66='WPPointerNewClass'
oordinals.PMWP.67='WPBitmapCClassData'
oordinals.PMWP.68='WPBitmapClassData'
oordinals.PMWP.69='WPBitmapNewClass'
oordinals.PMWP.85='WPCommandFileCClassData'
oordinals.PMWP.86='WPCommandFileClassData'
oordinals.PMWP.87='WPCommandFileNewClass'
oordinals.PMWP.88='WPClassManagerCClassData'
oordinals.PMWP.89='WPClassManagerClassData'
oordinals.PMWP.90='WPClassManagerNewClass'
oordinals.PMWP.91='WPPifCClassData'
oordinals.PMWP.92='WPPifClassData'
oordinals.PMWP.93='WPPifNewClass'
oordinals.PMWP.94='WPMetCClassData'
oordinals.PMWP.95='WPMetClassData'
oordinals.PMWP.96='WPMetNewClass'
oordinals.PMWP.409='WPNetworkCClassData'
oordinals.PMWP.410='WPNetworkClassData'
oordinals.PMWP.411='WPNetworkNewClass'
oordinals.PMWP.412='WPSharedDirCClassData'
oordinals.PMWP.413='WPSharedDirClassData'
oordinals.PMWP.414='WPSharedDirNewClass'
oordinals.PMWP.415='WPServerCClassData'
oordinals.PMWP.416='WPServerClassData'
oordinals.PMWP.417='WPServerNewClass'
oordinals.PMWP.418='WPNetLinkCClassData'
oordinals.PMWP.419='WPNetLinkClassData'
oordinals.PMWP.420='WPNetLinkNewClass'
oordinals.PMWP.421='WPNetgrpCClassData'
oordinals.PMWP.422='WPNetgrpClassData'
oordinals.PMWP.423='WPNetgrpNewClass'
oordinals.PMWP.433='WPMinWindowCClassData'
oordinals.PMWP.434='WPMinWindowClassData'
oordinals.PMWP.436='WPMinWindowNewClass'
oordinals.PMWP.437='WPCnrViewCClassData'
oordinals.PMWP.438='WPCnrViewClassData'
oordinals.PMWP.440='WPCnrViewNewClass'
oordinals.PMWP.442='WPFindFolderNewClass'
oordinals.PMWP.444='WPDiskCVNewClass'
oordinals.PMWP.448='WPFilterCClassData'
oordinals.PMWP.449='WPFilterClassData'
oordinals.PMWP.450='WPFilterNewClass'
oordinals.PMWP.452='WPFinderCClassData'
oordinals.PMWP.453='WPFinderClassData'
oordinals.PMWP.454='WPFinderNewClass'
oordinals.PMWP.456='WPMinWinViewerCClassData'
oordinals.PMWP.457='WPMinWinViewerClassData'
oordinals.PMWP.458='WPMinWinViewerNewClass'
oordinals.PMWP.460='WPProgramGroupCClassData'
oordinals.PMWP.461='WPProgramGroupClassData'
oordinals.PMWP.462='WPProgramGroupNewClass'
oordinals.PMWP.463='WinRestartWPDServer'
oordinals.PMWP.464='WinRestartSOMDD'
oordinals.PMWP.465='WinIsWPDServerReady'
oordinals.PMWP.467='WPLaunchPadCClassData'
oordinals.PMWP.468='WPLaunchPadClassData'
oordinals.PMWP.469='WPLaunchPadNewClass'
oordinals.PMWP.480='WinIsSOMDDReady'
oordinals.PMWP.112='atoi'
oordinals.PMWP.126='atol'
oordinals.PMWP.225='doNETLogon'
oordinals.PMWP.226='doNETLogoff'
oordinals.PMWP.227='doNETError'
oordinals.PMWP.228='doNETConnect'
oordinals.PMWP.229='doNETDisconnect'
oordinals.PMWP.107='itoa'
oordinals.PMWP.114='isdbcs'
oordinals.PMWP.489='lwpdOpenedOnWPDServer'
oordinals.PMWP.103='memset'
oordinals.PMWP.110='memcpy'
oordinals.PMWP.215='memcmp'
oordinals.PMWP.115='nextpch'
oordinals.PMWP.116='prevpch'
oordinals.PMWP.264='pszData'
oordinals.PMWP.102='strcat'
oordinals.PMWP.105='strcpy'
oordinals.PMWP.106='strlen'
oordinals.PMWP.108='strchr'
oordinals.PMWP.109='strrchr'
oordinals.PMWP.111='strcmp'
oordinals.PMWP.117='strcmpi'
oordinals.PMWP.118='strncmpi'
oordinals.PMWP.119='strncat_trunc'
oordinals.PMWP.120='strncat'
oordinals.PMWP.121='strncpy_trunc'
oordinals.PMWP.122='strncpy'
oordinals.PMWP.123='strstr'
oordinals.PMWP.124='strupr'
oordinals.PMWP.127='strncmp'
oordinals.PMWP.128='strpbrk'
oordinals.PMWP.129='stripblanks'
oordinals.PMWP.113='ultoa'
oordinals.PMWP.253='vapsz'
oordinals.PMWP.265='vButtonType'
oordinals.PMWP.266='vDefButtonType'
oordinals.PMWP.267='vDefMinWindows'
oordinals.PMWP.268='vMinWindows'
oordinals.PMWP.269='vcxIcon'
oordinals.PMWP.270='vcxScreen'
oordinals.PMWP.271='vcxScroll'
oordinals.PMWP.272='vcyIcon'
oordinals.PMWP.273='vcyScreen'
oordinals.PMWP.274='vcyScroll'
oordinals.PMWP.276='vhmodMRI'
oordinals.PMWP.277='vhwndDesktop'
oordinals.PMWP.278='vhwndDesktopFrame'
oordinals.PMWP.279='vhwndHelpInstance'
oordinals.PMWP.280='vhwndTaskList'
oordinals.PMWP.424='vpidWorkplace'
oordinals.PMWP.466='vhwndWorkplaceWindow'
oordinals.PMWP.474='vhpalDefaultColors'
oordinals.PMWP.475='vfPaletteManagedDisplay'
oordinals.PMWP.479='vszDesktopFolder'
oordinals.PMWP.486='vfConfirmations'
oordinals.PMWP.487='vfConfirmationsLoaded'
oordinals.PMWP.488='vulWPSDSOMThreadId'
oordinals.PMWP.125='xlatblank'
oordinals.WPCONFIG.4='ColorSelectWndProc'
oordinals.WPCONFIG.6='InitStdDlg'
oordinals.WPCONFIG.110='M_WPWinConfigCClassData'
oordinals.WPCONFIG.111='M_WPWinConfigClassData'
oordinals.WPCONFIG.112='M_WPWinConfigNewClass'
oordinals.WPCONFIG.113='M_WPSpecialNeedsCClassData'
oordinals.WPCONFIG.114='M_WPSpecialNeedsClassData'
oordinals.WPCONFIG.115='M_WPSpecialNeedsNewClass'
oordinals.WPCONFIG.116='M_WPMouseCClassData'
oordinals.WPCONFIG.117='M_WPMouseClassData'
oordinals.WPCONFIG.118='M_WPMouseNewClass'
oordinals.WPCONFIG.119='M_WPSoundCClassData'
oordinals.WPCONFIG.120='M_WPSoundClassData'
oordinals.WPCONFIG.121='M_WPSoundNewClass'
oordinals.WPCONFIG.122='M_WPKeyboardCClassData'
oordinals.WPCONFIG.123='M_WPKeyboardClassData'
oordinals.WPCONFIG.124='M_WPKeyboardNewClass'
oordinals.WPCONFIG.125='M_WPCountryCClassData'
oordinals.WPCONFIG.126='M_WPCountryClassData'
oordinals.WPCONFIG.127='M_WPCountryNewClass'
oordinals.WPCONFIG.128='M_WPClockCClassData'
oordinals.WPCONFIG.129='M_WPClockClassData'
oordinals.WPCONFIG.130='M_WPClockNewClass'
oordinals.WPCONFIG.131='M_WPFontPaletteCClassData'
oordinals.WPCONFIG.132='M_WPFontPaletteClassData'
oordinals.WPCONFIG.133='M_WPFontPaletteNewClass'
oordinals.WPCONFIG.134='M_WPColorPaletteCClassData'
oordinals.WPCONFIG.135='M_WPColorPaletteClassData'
oordinals.WPCONFIG.136='M_WPColorPaletteNewClass'
oordinals.WPCONFIG.137='M_WPPaletteCClassData'
oordinals.WPCONFIG.138='M_WPPaletteClassData'
oordinals.WPCONFIG.139='M_WPPaletteNewClass'
oordinals.WPCONFIG.140='M_WPSchemePaletteCClassData'
oordinals.WPCONFIG.141='M_WPSchemePaletteClassData'
oordinals.WPCONFIG.142='M_WPSchemePaletteNewClass'
oordinals.WPCONFIG.143='M_WPSystemCClassData'
oordinals.WPCONFIG.144='M_WPSystemClassData'
oordinals.WPCONFIG.145='M_WPSystemNewClass'
oordinals.WPCONFIG.147='M_WPPowerCClassData'
oordinals.WPCONFIG.148='M_WPPowerClassData'
oordinals.WPCONFIG.149='M_WPPowerNewClass'
oordinals.WPCONFIG.5='SetSysColors'
oordinals.WPCONFIG.7='SetDefaultSysColors'
oordinals.WPCONFIG.146='SOMInitModule'
oordinals.WPCONFIG.2='WCColorSampleWndProc'
oordinals.WPCONFIG.3='WCFontSampleWndProc'
oordinals.WPCONFIG.13='WPSpecialNeedsCClassData'
oordinals.WPCONFIG.14='WPSpecialNeedsClassData'
oordinals.WPCONFIG.15='WPSpecialNeedsNewClass'
oordinals.WPCONFIG.16='WPMouseCClassData'
oordinals.WPCONFIG.17='WPMouseClassData'
oordinals.WPCONFIG.18='WPMouseNewClass'
oordinals.WPCONFIG.19='WPSoundCClassData'
oordinals.WPCONFIG.20='WPSoundClassData'
oordinals.WPCONFIG.21='WPSoundNewClass'
oordinals.WPCONFIG.22='WPKeyboardCClassData'
oordinals.WPCONFIG.23='WPKeyboardClassData'
oordinals.WPCONFIG.24='WPKeyboardNewClass'
oordinals.WPCONFIG.25='WPCountryCClassData'
oordinals.WPCONFIG.26='WPCountryClassData'
oordinals.WPCONFIG.27='WPCountryNewClass'
oordinals.WPCONFIG.28='WPClockCClassData'
oordinals.WPCONFIG.29='WPClockClassData'
oordinals.WPCONFIG.30='WPClockNewClass'
oordinals.WPCONFIG.31='WPFontPaletteCClassData'
oordinals.WPCONFIG.32='WPFontPaletteClassData'
oordinals.WPCONFIG.33='WPFontPaletteNewClass'
oordinals.WPCONFIG.34='WPColorPaletteCClassData'
oordinals.WPCONFIG.35='WPColorPaletteClassData'
oordinals.WPCONFIG.36='WPColorPaletteNewClass'
oordinals.WPCONFIG.37='WPPaletteCClassData'
oordinals.WPCONFIG.38='WPPaletteClassData'
oordinals.WPCONFIG.39='WPPaletteNewClass'
oordinals.WPCONFIG.40='WPSchemePaletteCClassData'
oordinals.WPCONFIG.41='WPSchemePaletteClassData'
oordinals.WPCONFIG.42='WPSchemePaletteNewClass'
oordinals.WPCONFIG.43='WPSystemCClassData'
oordinals.WPCONFIG.44='WPSystemClassData'
oordinals.WPCONFIG.45='WPSystemNewClass'
oordinals.WPCONFIG.46='WPPowerCClassData'
oordinals.WPCONFIG.47='WPPowerClassData'
oordinals.WPCONFIG.48='WPPowerNewClass'
oordinals.WPCONFIG.49='WPWinConfigCClassData'
oordinals.WPCONFIG.50='WPWinConfigClassData'
oordinals.WPCONFIG.51='WPWinConfigNewClass'
oordinals.PMVIOP.1='WINCREATECONSOLE'
oordinals.PMVIOP.2='WINDESTROYCONSOLE'
oordinals.PMVIOP.3='WINSYNCWITHPS'
oordinals.PMVIOP.4='WINCONSOLEOPENKBD'
oordinals.PMVIOP.5='WINCONSOLECLOSEKBD'
oordinals.PMVIOP.6='WINCONSOLESETSTATUS'
oordinals.PMVIOP.7='WINCONSOLEGETSTATUS'
oordinals.PMVIOP.8='WINCONSOLESETCP'
oordinals.PMVIOP.10='WINCONSOLEGETCP'
oordinals.PMVIOP.11='WINCONSOLEKBDXLATE'
oordinals.PMVIOP.12='WINCONSOLESETCUSTXT'
oordinals.PMVIOP.13='WINCONSOLEGETFOCUS'
oordinals.PMVIOP.14='WINCONSOLEFREEFOCUS'
oordinals.PMVIOP.15='WINCONSOLEREADKEYEVENT'
oordinals.PMVIOP.16='WINCONSOLEFLUSHKEYEVENTS'
oordinals.PMVIOP.17='WINCONSOLEQUEUEDPOINTEREVENTS'
oordinals.PMVIOP.18='WINCONSOLEREADPOINTEREVENT'
oordinals.PMVIOP.19='WINCONSOLEFLUSHPOINTEREVENTS'
oordinals.PMVIOP.20='WINCONSOLEGETPOINTERFILTERMASK'
oordinals.PMVIOP.21='WINCONSOLESETPOINTERFILTERMASK'
oordinals.PMVIOP.22='WINCONSOLEGETPTRPOS'
oordinals.PMVIOP.23='WINCONSOLESETPTRPOS'
oordinals.PMVIOP.24='WINSHIELDABORT'
oordinals.PMVIOP.25='SHIELDFRAMEPROC'
oordinals.PMVIOP.26='VIOSHIELDWINDOWPROC'
oordinals.PMVIOP.27='LOCKVIOPS'
oordinals.PMVIOP.28='UNLOCKVIOPS'
oordinals.PMVIOP.29='MARKINGWINDOWPROC'
oordinals.PMVIOP.30='WINDEFAVIOWINDOWPROC'
oordinals.PMVIOP.31='WINCONSOLEGETKBDHANDLE'
oordinals.PMVIOP.32='WINCONSOLEATTACHMOUSEUSER'
oordinals.PMVIOP.33='WINCONSOLEDETACHMOUSEUSER'
oordinals.PMVIOP.34='TASKMGRSUBCLASSPROC'
oordinals.PMVIOP.35='WINSHIELDPRETHAW'
oordinals.PMVIOP.36='WININITSHIELD'
oordinals.PMVIOP.37='MORTICIAN'
oordinals.PMVIOP.39='UNLOCKSEMAPHORES'
oordinals.PMVIOP.40='CLEARDATA'
oordinals.PMVIOP.41='QUERYCONSOLE'
oordinals.PMVIOP.42='MAKEVISIBLE'
oordinals.PMVIOP.43='GETPASTECHAR'
oordinals.PMVIOP.46='TERMINATECLIPDDE'
oordinals.PMVIOP.47='VDMCLIPDDENOTIFY'
oordinals.PMVIOP.50='SEAMLESS32REGISTEROBJECT'
oordinals.PMVIOP.51='SEAMLESS32ACTIVATEWINDOW'
oordinals.PMVIOP.52='NOTIFYALLVDMS'
oordinals.PMVIOP.53='VDMSWAPBUTTONNOTIFY'
oordinals.PMVIOP.54='GET32DISPLAYTYPE'
oordinals.PMVIOP.55='SEAMLESS32REGISTERASSOCOBJ'
oordinals.NLS.1='DOSCASEMAP'
oordinals.NLS.2='DOSGETCOLLATE'
oordinals.NLS.3='DOSGETCTRYINFO'
oordinals.NLS.4='DOSGETDBCSEV'
oordinals.NLS.5='DOS32QUERYCTRYINFO'
oordinals.NLS.6='DOS32QUERYDBCSENV'
oordinals.NLS.7='DOS32MAPCASE'
oordinals.NLS.8='DOS32QUERYCOLLATE'
oordinals.MSG.1='DOSPUTMESSAGE'
oordinals.MSG.2='DOSTRUEGETMESSAGE'
oordinals.MSG.3='DOSINSMESSAGE'
oordinals.MSG.4='DOS32INSERTMESSAGE'
oordinals.MSG.5='DOS32PUTMESSAGE'
oordinals.MSG.6='DOS32TRUEGETMESSAGE'
oordinals.MSG.7='DOSIQUERYMESSAGECP'
oordinals.MSG.8='DOS32IQUERYMESSAGECP'
oordinals.MSG.9='DOSCLOSEMESSAGEFILE'
oordinals.PMSTDDLG.2='WINFONTDLG'2
oordinals.PMSTDDLG.3='WINDEFFONTDLGPROC'3
oordinals.PMSTDDLG.4='WINFILEDLG'4
oordinals.PMSTDDLG.5='WINDEFFILEDLGPROC'5
oordinals.PMSTDDLG.6='WINFREEFILEDLGLIST'6
oordinals.PMSTDDLG.24='WINREGISTERCIRCULARSLIDER'24
oordinals.SESMGR.1='DOSSMSGDOPOPUP'
oordinals.SESMGR.2='DOSSMSWITCH'
oordinals.SESMGR.3='DOSSMSERVEAPPREQ'
oordinals.SESMGR.4='DOSGETTIMES'
oordinals.SESMGR.5='DOSSMSETTITLE'
oordinals.SESMGR.6='DOSSCRUNLOCK'
oordinals.SESMGR.7='DOSSMDOAPPREQ'
oordinals.SESMGR.8='DOSSTOPSESSION'
oordinals.SESMGR.9='DOSSELECTSESSION'
oordinals.SESMGR.10='DOSSCRLOCK'
oordinals.SESMGR.11='DOSSAVREDRAWWAIT'
oordinals.SESMGR.12='DOSSAVREDRAWUNDO'
oordinals.SESMGR.13='DOSSMSGENDPOPUP'
oordinals.SESMGR.14='DOSSETSESSION'
oordinals.SESMGR.15='DOSSETMNLOCKTIME'
oordinals.SESMGR.16='DOSMODEUNDO'
oordinals.SESMGR.17='DOSSTARTSESSION'
oordinals.SESMGR.18='DOSSMGETSTATUS'
oordinals.SESMGR.19='DOSMODEWAIT'
oordinals.SESMGR.20='DOSSMTERMINATE'
oordinals.SESMGR.21='DOSSMGETAPPREQ'
oordinals.SESMGR.22='DOSSMREALPRTSC'
oordinals.SESMGR.23='DOSSMINITIALIZE'
oordinals.SESMGR.24='DOSSMSTART'
oordinals.SESMGR.25='DOSSMPARENTSWITCH'
oordinals.SESMGR.26='DOSSMPAUSE'
oordinals.SESMGR.27='DOSSMHDEINIT'
oordinals.SESMGR.28='DOSSMPMPRESENT'
oordinals.SESMGR.29='DOSSMREGISTERDD'
oordinals.SESMGR.30='DOSSMSYSINIT'
oordinals.SESMGR.31='DOSSMNOTIFYDD'
oordinals.SESMGR.32='DOSSMNOTIFYDD2'
oordinals.SESMGR.33='DOSSMOPENDD'
oordinals.SESMGR.34='QHKEYBDHANDLE'
oordinals.SESMGR.35='QHMOUSEHANDLE'
oordinals.SESMGR.36='DOSSMSETSESSIONTYPE'
oordinals.SESMGR.37='DOS32STARTSESSION'
oordinals.SESMGR.38='DOS32SELECTSESSION'
oordinals.SESMGR.39='DOS32SETSESSION'
oordinals.SESMGR.40='DOS32STOPSESSION'
oordinals.SESMGR.41='DOSREGISTERNOTIFICATION'
oordinals.QUECALLS.1='DOSREADQUEUE'
oordinals.QUECALLS.2='DOSPURGEQUEUE'
oordinals.QUECALLS.3='DOSCLOSEQUEUE'
oordinals.QUECALLS.4='DOSQUERYQUEUE'
oordinals.QUECALLS.5='DOSPEEKQUEUE'
oordinals.QUECALLS.6='DOSWRITEQUEUE'
oordinals.QUECALLS.7='DOSOPENQUEUE'
oordinals.QUECALLS.8='DOSCREATEQUEUE'
oordinals.QUECALLS.9='DOS32READQUEUE'
oordinals.QUECALLS.10='DOS32PURGEQUEUE'
oordinals.QUECALLS.11='DOS32CLOSEQUEUE'
oordinals.QUECALLS.12='DOS32QUERYQUEUE'
oordinals.QUECALLS.13='DOS32PEEKQUEUE'
oordinals.QUECALLS.14='DOS32WRITEQUEUE'
oordinals.QUECALLS.15='DOS32OPENQUEUE'
oordinals.QUECALLS.16='DOS32CREATEQUEUE'
oordinals.PMTKT.20='WTIITOA'
oordinals.PMTKT.21='WTIALERTBOX'
oordinals.PMTKT.22='WTIMERGESTRINGS'
oordinals.PMTKT.23='WTILSTRLEN'
oordinals.PMTKT.24='WTILSTRCAT'
oordinals.PMTKT.25='WTILSTRCPY'
oordinals.PMTKT.26='WTILSTRCMP'
oordinals.PMTKT.27='WTIMULTDIV'
oordinals.PMTKT.28='WTIBITBLT'
oordinals.PMTKT.29='WTISTRETCHBLT'
oordinals.PMTKT.30='WTIPATBLT'
oordinals.PMTKT.31='WTISETEASTRING'
oordinals.PMTKT.32='WTICREATEMEMORYPS'
oordinals.PMTKT.33='WTIGETTEXTEXTENT'
oordinals.PMTKT.35='WTISETBITMAPBITS'
oordinals.PMTKT.36='WTIGETBITMAPBITS'
oordinals.PMTKT.37='WTICREATECOMPATIBLEBITMAP'
oordinals.PMTKT.38='WTIDEVQUERYCAPS'
oordinals.PMTKT.39='WTIDLGFILE'
oordinals.PMTKT.40='WTIOPENFILE'
oordinals.PMTKT.41='WTILCOPYSTRUCT'
oordinals.PMTKT.42='WTILFILLSTRUCT'
oordinals.PMTKT.43='WTIADDEXT'
oordinals.PMTKT.44='WTIFILEINPATH'
oordinals.PMTKT.45='WTILOGO'
oordinals.PMTKT.90='HLPINIT'
oordinals.PMTKT.91='HLPDESTROY'
oordinals.PMTKT.92='HLPREQUEST'
oordinals.PMTKT.93='HLPQUERYSTATUS'
oordinals.PMTKT.94='HLPHIDE'
oordinals.PMTKT.95='HLPREGISTERCONTEXT'
oordinals.PMTKT.96='DLGOPENWNDPROC'
oordinals.PMTKT.97='DLGSAVEASWNDPROC'
oordinals.PMSPL.1='SPLQMOPEN'
oordinals.PMSPL.2='SPLQMSTARTDOC'
oordinals.PMSPL.3='SPLQMENDDOC'
oordinals.PMSPL.4='SPLQMWRITE'
oordinals.PMSPL.5='SPLQMABORT'
oordinals.PMSPL.6='SPLQMCLOSE'
oordinals.PMSPL.7='SPLMESSAGEBOX'
oordinals.PMSPL.8='SPLQMABORTDOC'
oordinals.PMSPL.10='SPLQMSPOOLERPRESENT'
oordinals.PMSPL.11='SPLQMCHOOSELOGADDR'
oordinals.PMSPL.12='SPLQMINITIALIZE'
oordinals.PMSPL.13='SPLQMTERMINATE'
oordinals.PMSPL.15='SPLPRMSPOOL'
oordinals.PMSPL.16='SPLQMCANCELWAITINGJOBS'
oordinals.PMSPL.17='SPLQMCANCELPRINTINGJOB'
oordinals.PMSPL.19='SPLVQIFINIT'
oordinals.PMSPL.20='SPLINIT'
oordinals.PMSPL.21='SPLQMLISTQUEUES'
oordinals.PMSPL.22='SPLQMQUERYQINFO'
oordinals.PMSPL.23='SPLQMLISTJOBS'
oordinals.PMSPL.24='SPLQMQUERYJINFO'
oordinals.PMSPL.25='SPLQMHOLDQUEUE'
oordinals.PMSPL.26='SPLQMRELEASEQUEUE'
oordinals.PMSPL.27='SPLQMHOLDJOB'
oordinals.PMSPL.28='SPLQMRELEASEJOB'
oordinals.PMSPL.29='SPLQMCANCELJOB'
oordinals.PMSPL.30='SPLQMRESTARTJOB'
oordinals.PMSPL.31='SPLQMREPEATJOB'
oordinals.PMSPL.32='SPLQMPRINTJOBNEXT'
oordinals.PMSPL.33='SPLQMQUERYPINFO'
oordinals.PMSPL.34='SPLQMCHANGEJOBPRTY'
oordinals.PMSPL.35='SPLQMWRITEFILE'
oordinals.PMSPL.36='SPLQMSETSTATUS'
oordinals.PMSPL.50='SPLSTDOPEN'
oordinals.PMSPL.51='SPLSTDCLOSE'
oordinals.PMSPL.52='SPLSTDSTART'
oordinals.PMSPL.53='SPLSTDSTOP'
oordinals.PMSPL.54='SPLSTDDELETE'
oordinals.PMSPL.55='SPLSTDGETBITS'
oordinals.PMSPL.56='SPLSTDQUERYLENGTH'
oordinals.PMSPL.69='PROFILEVALIDATIONHOOK'
oordinals.PMSPL.70='PRTOPEN'
oordinals.PMSPL.71='PRTWRITE'
oordinals.PMSPL.72='PRTDEVIOCTL'
oordinals.PMSPL.73='PRTCLOSE'
oordinals.PMSPL.75='PRTABORT'
oordinals.PMSPL.80='DOSPRINTDESTCONTROL'
oordinals.PMSPL.81='DOSPRINTDESTGETINFO'
oordinals.PMSPL.82='DOSPRINTDESTENUM'
oordinals.PMSPL.84='DOSPRINTJOBCONTINUE'
oordinals.PMSPL.85='DOSPRINTJOBPAUSE'
oordinals.PMSPL.86='DOSPRINTJOBDEL'
oordinals.PMSPL.87='DOSPRINTJOBSCHEDULE'
oordinals.PMSPL.88='DOSPRINTJOBADD'
oordinals.PMSPL.89='DOSPRINTJOBADD2'
oordinals.PMSPL.90='DOSPRINTJOBGETINFO'
oordinals.PMSPL.91='DOSPRINTJOBSETINFO'
oordinals.PMSPL.92='DOSPRINTJOBENUM'
oordinals.PMSPL.93='DOSPRINTQADD'
oordinals.PMSPL.94='DOSPRINTQPAUSE'
oordinals.PMSPL.95='DOSPRINTQCONTINUE'
oordinals.PMSPL.96='DOSPRINTQDEL'
oordinals.PMSPL.97='DOSPRINTQGETINFO'
oordinals.PMSPL.98='DOSPRINTQSETINFO'
oordinals.PMSPL.99='DOSPRINTQENUM'
oordinals.PMSPL.101='DOSPRINTDESTADD'
oordinals.PMSPL.102='DOSPRINTDESTSETINFO'
oordinals.PMSPL.103='DOSPRINTDESTDEL'
oordinals.PMSPL.104='DOSPRINTQPURGE'
oordinals.PMSPL.105='DOSPRINTJOBGETID'
oordinals.PMSPL.106='DOSPRINTDRIVERENUM'
oordinals.PMSPL.107='DOSPRINTQPROCESSORENUM'
oordinals.PMSPL.108='DOSPRINTPORTENUM'
oordinals.PMSPL.110='WPRINTDESTCONTROL'
oordinals.PMSPL.111='WPRINTDESTGETINFO'
oordinals.PMSPL.112='WPRINTDESTENUM'
oordinals.PMSPL.113='WPRINTJOBCONTINUE'
oordinals.PMSPL.114='WPRINTJOBPAUSE'
oordinals.PMSPL.115='WPRINTJOBDEL'
oordinals.PMSPL.116='WPRINTJOBGETINFO'
oordinals.PMSPL.117='WPRINTJOBSETINFO'
oordinals.PMSPL.118='WPRINTJOBENUM'
oordinals.PMSPL.119='WPRINTQADD'
oordinals.PMSPL.120='WPRINTQPAUSE'
oordinals.PMSPL.121='WPRINTQCONTINUE'
oordinals.PMSPL.122='WPRINTQDEL'
oordinals.PMSPL.123='WPRINTQGETINFO'
oordinals.PMSPL.124='WPRINTQSETINFO'
oordinals.PMSPL.125='WPRINTQENUM'
oordinals.PMSPL.126='WPRINTDESTADD'
oordinals.PMSPL.127='WPRINTDESTSETINFO'
oordinals.PMSPL.128='WPRINTDESTDEL'
oordinals.PMSPL.129='WPRINTQPURGE'
oordinals.PMSPL.130='WPRINTDRIVERENUM'
oordinals.PMSPL.131='WPRINTQPROCESSORENUM'
oordinals.PMSPL.132='WPRINTPORTENUM'
oordinals.PMSPL.140='SPLQMQUERYPRINTRES'
oordinals.PMSPL.141='SPL16ENUMPRINTER'
oordinals.PMSPL.142='SPL16COPYJOB'
oordinals.PMSPL.200='NETSPLQMOPEN'
oordinals.PMSPL.201='NETSPLQMSTARTDOC'
oordinals.PMSPL.202='NETSPLQMWRITE'
oordinals.PMSPL.203='NETSPLQMENDDOC'
oordinals.PMSPL.204='NETSPLQMCLOSE'
oordinals.PMSPL.205='NETSPLQMABORT'
oordinals.PMSPL.206='NETSPLQMABORTDOC'
oordinals.PMSPL.301='SPL32QMOPEN'
oordinals.PMSPL.302='SPL32QMSTARTDOC'
oordinals.PMSPL.303='SPL32QMENDDOC'
oordinals.PMSPL.304='SPL32QMWRITE'
oordinals.PMSPL.305='SPL32QMABORT'
oordinals.PMSPL.306='SPL32QMCLOSE'
oordinals.PMSPL.307='SPL32MESSAGEBOX'
oordinals.PMSPL.308='SPL32QMABORTDOC'
oordinals.PMSPL.310='SPL32QMSPOOLERPRESENT'
oordinals.PMSPL.311='SPL32QMCHOOSELOGADDR'
oordinals.PMSPL.312='SPL32QMINITIALIZE'
oordinals.PMSPL.313='SPL32QMTERMINATE'
oordinals.PMSPL.315='SPL32PRMSPOOL'
oordinals.PMSPL.316='SPL32QMCANCELWAITINGJOBS'
oordinals.PMSPL.317='SPL32QMCANCELPRINTINGJOB'
oordinals.PMSPL.319='SPL32VQIFINIT'
oordinals.PMSPL.320='SPL32INIT'
oordinals.PMSPL.350='SPL32STDOPEN'
oordinals.PMSPL.351='SPL32STDCLOSE'
oordinals.PMSPL.352='SPL32STDSTART'
oordinals.PMSPL.353='SPL32STDSTOP'
oordinals.PMSPL.354='SPL32STDDELETE'
oordinals.PMSPL.355='SPL32STDGETBITS'
oordinals.PMSPL.356='SPL32STDQUERYLENGTH'
oordinals.PMSPL.370='PRT32OPEN'
oordinals.PMSPL.371='PRT32WRITE'
oordinals.PMSPL.372='PRT32DEVIOCTL'
oordinals.PMSPL.373='PRT32CLOSE'
oordinals.PMSPL.375='PRT32ABORT'
oordinals.PMSPL.380='SPLCONTROLDEVICE'
oordinals.PMSPL.380='SPL32CONTROLDEVICE'
oordinals.PMSPL.381='SPLQUERYDEVICE'
oordinals.PMSPL.381='SPL32QUERYDEVICE'
oordinals.PMSPL.382='SPLENUMDEVICE'
oordinals.PMSPL.382='SPL32ENUMDEVICE'
oordinals.PMSPL.384='SPLRELEASEJOB'
oordinals.PMSPL.384='SPL32RELEASEJOB'
oordinals.PMSPL.385='SPLHOLDJOB'
oordinals.PMSPL.385='SPL32HOLDJOB'
oordinals.PMSPL.386='SPLDELETEJOB'
oordinals.PMSPL.386='SPL32DELETEJOB'
oordinals.PMSPL.390='SPLQUERYJOB'
oordinals.PMSPL.390='SPL32QUERYJOB'
oordinals.PMSPL.391='SPLSETJOB'
oordinals.PMSPL.391='SPL32SETJOB'
oordinals.PMSPL.392='SPLENUMJOB'
oordinals.PMSPL.392='SPL32ENUMJOB'
oordinals.PMSPL.393='SPLCREATEQUEUE'
oordinals.PMSPL.393='SPL32CREATEQUEUE'
oordinals.PMSPL.394='SPLHOLDQUEUE'
oordinals.PMSPL.394='SPL32HOLDQUEUE'
oordinals.PMSPL.395='SPLRELEASEQUEUE'
oordinals.PMSPL.395='SPL32RELEASEQUEUE'
oordinals.PMSPL.396='SPLDELETEQUEUE'
oordinals.PMSPL.396='SPL32DELETEQUEUE'
oordinals.PMSPL.397='SPLQUERYQUEUE'
oordinals.PMSPL.397='SPL32QUERYQUEUE'
oordinals.PMSPL.398='SPLSETQUEUE'
oordinals.PMSPL.398='SPL32SETQUEUE'
oordinals.PMSPL.399='SPLENUMQUEUE'
oordinals.PMSPL.399='SPL32ENUMQUEUE'
oordinals.PMSPL.401='SPLCREATEDEVICE'
oordinals.PMSPL.401='SPL32CREATEDEVICE'
oordinals.PMSPL.402='SPLSETDEVICE'
oordinals.PMSPL.402='SPL32SETDEVICE'
oordinals.PMSPL.403='SPLDELETEDEVICE'
oordinals.PMSPL.403='SPL32DELETEDEVICE'
oordinals.PMSPL.404='SPLPURGEQUEUE'
oordinals.PMSPL.404='SPL32PURGEQUEUE'
oordinals.PMSPL.405='SPLQUERYJOBID'
oordinals.PMSPL.405='SPL32QUERYJOBID'
oordinals.PMSPL.406='SPLENUMDRIVER'
oordinals.PMSPL.406='SPL32ENUMDRIVER'
oordinals.PMSPL.407='SPLENUMQUEUEPROCESSOR'
oordinals.PMSPL.407='SPL32ENUMQUEUEPROCESSOR'
oordinals.PMSPL.408='SPLENUMPORT'
oordinals.PMSPL.408='SPL32ENUMPORT'
oordinals.PMSPL.440='SPL32QMQUERYPRINTRES'
oordinals.PMSPL.441='SPLENUMPRINTER'
oordinals.PMSPL.442='SPLCOPYJOB'
oordinals.PMSPL.443='SPLQMSETUP'
oordinals.PMSPL.444='SPLQUERYJOBFILE'
oordinals.PMPRF.1='PROFINIT'
oordinals.PMPRF.2='PROFCLEAR'
oordinals.PMPRF.3='PROFON'
oordinals.PMPRF.4='PROFOFF'
oordinals.PMPRF.5='PROFDUMP'
oordinals.PMPRF.6='PROFFREE'
oordinals.PMPRF.10='APROFINIT'
oordinals.PMPRF.11='APROFCLEAR'
oordinals.PMPRF.12='APROFON'
oordinals.PMPRF.13='APROFOFF'
oordinals.PMPRF.14='APROFDUMP'
oordinals.PMPRF.15='APROFFREE'
oordinals.PMPRF.16='APROFCALL'
oordinals.PMPRF.17='APROFCALLALT'
oordinals.PMPRF.18='APROFRET'
oordinals.PMPRF.20='STARTTEFTI'
oordinals.PMPRF.21='STOPTEFTI'
oordinals.PMPRF.22='STARTAUSTIN'
oordinals.PMPRF.23='STOPAUSTIN'
oordinals.PMPRF.24='START8253'
oordinals.PMPRF.25='STOP8253'
oordinals.PMPIC.1='PICPRINT'
oordinals.PMPIC.2='PICICHG'
oordinals.PMPIC.3='PIF2MET'
oordinals.PMPIC.4='PRFPIF2MET'
oordinals.PMPIC.5='PICFILEOPENDIALOG'
oordinals.PMPIC.11='PIC32PRINT'
oordinals.PMPIC.12='PIC32ICHG'
oordinals.PMPIC.13='PRF32PIF2MET'
oordinals.PMWIN.1='WINQUERYDESKTOPWINDOW'
oordinals.PMWIN.2='WINQUERYOBJECTWINDOW'
oordinals.PMWIN.3='WINREGISTERCLASS'
oordinals.PMWIN.4='WINQUERYCLASSNAME'
oordinals.PMWIN.5='WINQUERYCLASSINFO'
oordinals.PMWIN.6='WINCREATEWINDOW'
oordinals.PMWIN.7='WINDESTROYWINDOW'
oordinals.PMWIN.8='WINSETWINDOWPOS'
oordinals.PMWIN.9='WINSETMULTWINDOWPOS'
oordinals.PMWIN.10='WINQUERYWINDOWPOS'
oordinals.PMWIN.11='WINENABLEWINDOW'
oordinals.PMWIN.12='WINISWINDOWENABLED'
oordinals.PMWIN.13='WINSHOWWINDOW'
oordinals.PMWIN.14='WINENABLEWINDOWUPDATE'
oordinals.PMWIN.15='WINISWINDOWVISIBLE'
oordinals.PMWIN.16='WINSETWINDOWTEXT'
oordinals.PMWIN.17='WINQUERYWINDOWTEXT'
oordinals.PMWIN.18='WINQUERYWINDOWTEXTLENGTH'
oordinals.PMWIN.19='WINWINDOWFROMID'
oordinals.PMWIN.20='WINMULTWINDOWFROMIDS'
oordinals.PMWIN.21='WINISWINDOW'
oordinals.PMWIN.22='WINISCHILD'
oordinals.PMWIN.23='WINSETPARENT'
oordinals.PMWIN.24='WINSETOWNER'
oordinals.PMWIN.25='WINQUERYWINDOW'
oordinals.PMWIN.26='WINQUERYWINDOWRECT'
oordinals.PMWIN.27='WINQUERYWINDOWPROCESS'
oordinals.PMWIN.28='WINSETWINDOWUSHORT'
oordinals.PMWIN.29='WINQUERYWINDOWUSHORT'
oordinals.PMWIN.30='WINSETWINDOWULONG'
oordinals.PMWIN.31='WINQUERYWINDOWULONG'
oordinals.PMWIN.32='WINBEGINENUMWINDOWS'
oordinals.PMWIN.33='WINGETNEXTWINDOW'
oordinals.PMWIN.34='WINENDENUMWINDOWS'
oordinals.PMWIN.35='WINWINDOWFROMPOINT'
oordinals.PMWIN.36='WINMAPWINDOWPOINTS'
oordinals.PMWIN.37='WINSUBCLASSWINDOW'
oordinals.PMWIN.38='WINLOCKWINDOW'
oordinals.PMWIN.39='WINQUERYWINDOWLOCKCOUNT'
oordinals.PMWIN.40='WINREGISTERWINDOWDESTROY'
oordinals.PMWIN.41='WINOPENWINDOWDC'
oordinals.PMWIN.42='WINGETSCREENPS'
oordinals.PMWIN.43='WINGETPS'
oordinals.PMWIN.44='WINRELEASEPS'
oordinals.PMWIN.45='WINBEGINPAINT'
oordinals.PMWIN.46='WINENDPAINT'
oordinals.PMWIN.47='WININVALIDATERECT'
oordinals.PMWIN.48='WININVALIDATEREGION'
oordinals.PMWIN.49='WINVALIDATERECT'
oordinals.PMWIN.50='WINVALIDATEREGION'
oordinals.PMWIN.51='WINQUERYUPDATERECT'
oordinals.PMWIN.52='WINQUERYUPDATEREGION'
oordinals.PMWIN.53='WINUPDATEWINDOW'
oordinals.PMWIN.54='WINEXCLUDEUPDATEREGION'
oordinals.PMWIN.55='WINLOCKWINDOWUPDATE'
oordinals.PMWIN.56='WINLOCKVISREGIONS'
oordinals.PMWIN.57='WINWINDOWFROMDC'
oordinals.PMWIN.58='WINCREATEMSGQUEUE'
oordinals.PMWIN.59='WINDESTROYMSGQUEUE'
oordinals.PMWIN.60='WINQUERYQUEUESTATUS'
oordinals.PMWIN.61='WINSENDMSG'
oordinals.PMWIN.62='WINTimeoutSendMsg'
oordinals.PMWIN.63='WINBROADCASTMSG'
oordinals.PMWIN.64='WININSENDMSG'
oordinals.PMWIN.65='WINGETMSG'
oordinals.PMWIN.66='WINPEEKMSG'
oordinals.PMWIN.67='WINWAITMSG'
oordinals.PMWIN.68='WINDISPATCHMSG'
oordinals.PMWIN.69='WINPOSTMSG'
oordinals.PMWIN.70='WINPOSTQUEUEMSG'
oordinals.PMWIN.71='WINQUERYMSGPOS'
oordinals.PMWIN.72='WINQUERYMSGTIME'
oordinals.PMWIN.73='WINCALLMSGFILTER'
oordinals.PMWIN.74='WINSETMSGINTEREST'
oordinals.PMWIN.75='WINSETCAPTURE'
oordinals.PMWIN.76='WINQUERYCAPTURE'
oordinals.PMWIN.77='WINSETFOCUS'
oordinals.PMWIN.78='WINQUERYFOCUS'
oordinals.PMWIN.79='WINSETACTIVEWINDOW'
oordinals.PMWIN.80='WINQUERYACTIVEWINDOW'
oordinals.PMWIN.81='WINSETSYSMODALWINDOW'
oordinals.PMWIN.82='WINQUERYSYSMODALWINDOW'
oordinals.PMWIN.83='WINISTHREADACTIVE'
oordinals.PMWIN.84='WINSTARTTIMER'
oordinals.PMWIN.85='WINSTOPTIMER'
oordinals.PMWIN.86='WINGETCURRENTTIME'
oordinals.PMWIN.87='WINLOADPOINTER'
oordinals.PMWIN.88='WINCREATEPOINTER'
oordinals.PMWIN.89='WINDESTROYPOINTER'
oordinals.PMWIN.90='OLDWINQUERYPOINTERINFO'
oordinals.PMWIN.91='WINQUERYSYSPOINTER'
oordinals.PMWIN.92='WINSETPOINTER'
oordinals.PMWIN.93='WINQUERYPOINTER'
oordinals.PMWIN.94='WINSHOWPOINTER'
oordinals.PMWIN.95='WINSETPOINTERPOS'
oordinals.PMWIN.96='WINQUERYPOINTERPOS'
oordinals.PMWIN.97='WINGETSYSBITMAP'
oordinals.PMWIN.98='WINCREATECURSOR'
oordinals.PMWIN.99='WINDESTROYCURSOR'
oordinals.PMWIN.100='WINSHOWCURSOR'
oordinals.PMWIN.101='WINQUERYCURSORINFO'
oordinals.PMWIN.102='WINLOADACCELTABLE'
oordinals.PMWIN.103='WINCREATEACCELTABLE'
oordinals.PMWIN.104='WINDESTROYACCELTABLE'
oordinals.PMWIN.105='WINTRANSLATEACCEL'
oordinals.PMWIN.106='WINSETACCELTABLE'
oordinals.PMWIN.107='WINQUERYACCELTABLE'
oordinals.PMWIN.108='WINCOPYACCELTABLE'
oordinals.PMWIN.109='WINSETHOOK'
oordinals.PMWIN.110='WINRELEASEHOOK'
oordinals.PMWIN.111='WINOPENCLIPBRD'
oordinals.PMWIN.112='WINCLOSECLIPBRD'
oordinals.PMWIN.113='WINEMPTYCLIPBRD'
oordinals.PMWIN.114='WINSETCLIPBRDOWNER'
oordinals.PMWIN.115='WINQUERYCLIPBRDOWNER'
oordinals.PMWIN.116='WINSETCLIPBRDDATA'
oordinals.PMWIN.117='WINQUERYCLIPBRDDATA'
oordinals.PMWIN.118='WINENUMCLIPBRDFMTS'
oordinals.PMWIN.119='WINQUERYCLIPBRDFMTINFO'
oordinals.PMWIN.120='WINSETCLIPBRDVIEWER'
oordinals.PMWIN.121='WINQUERYCLIPBRDVIEWER'
oordinals.PMWIN.122='WINLOADDLG'
oordinals.PMWIN.123='WINCREATEDLG'
oordinals.PMWIN.124='WINPROCESSDLG'
oordinals.PMWIN.125='WINDLGBOX'
oordinals.PMWIN.126='WINDISMISSDLG'
oordinals.PMWIN.127='WINSENDDLGITEMMSG'
oordinals.PMWIN.128='WINSETDLGITEMSHORT'
oordinals.PMWIN.129='WINQUERYDLGITEMSHORT'
oordinals.PMWIN.130='WINMAPDLGPOINTS'
oordinals.PMWIN.132='WINSUBSTITUTESTRINGS'
oordinals.PMWIN.133='WINENUMDLGITEM'
oordinals.PMWIN.134='WINSETDLGITEMTEXT'
oordinals.PMWIN.135='WINQUERYDLGITEMTEXT'
oordinals.PMWIN.136='WINLOADMENU'
oordinals.PMWIN.137='WINCREATEMENU'
oordinals.PMWIN.138='WINALARM'
oordinals.PMWIN.139='WINMESSAGEBOX'
oordinals.PMWIN.140='WINCREATESTDWINDOW'
oordinals.PMWIN.141='WINCREATEFRAMECONTROLS'
oordinals.PMWIN.142='WINFORMATFRAME'
oordinals.PMWIN.143='WINCALCFRAMERECT'
oordinals.PMWIN.144='WINFLASHWINDOW'
oordinals.PMWIN.146='WINGETMINPOSITION'
oordinals.PMWIN.147='WINGETMAXPOSITION'
oordinals.PMWIN.149='WINQUERYSYSVALUE'
oordinals.PMWIN.150='WINSETSYSVALUE'
oordinals.PMWIN.151='WINSETSYSCOLORS'
oordinals.PMWIN.152='WINQUERYSYSCOLOR'
oordinals.PMWIN.153='WINSCROLLWINDOW'
oordinals.PMWIN.154='WINTRACKRECT'
oordinals.PMWIN.155='WINSHOWTRACKRECT'
oordinals.PMWIN.156='GPILOADBITMAP'
oordinals.PMWIN.157='WINLOADSTRING'
oordinals.PMWIN.158='WINLOADMESSAGE'
oordinals.PMWIN.159='WINSETRECTEMPTY'
oordinals.PMWIN.160='WINSETRECT'
oordinals.PMWIN.161='WINCOPYRECT'
oordinals.PMWIN.162='WINISRECTEMPTY'
oordinals.PMWIN.163='WINEQUALRECT'
oordinals.PMWIN.164='WINPTINRECT'
oordinals.PMWIN.165='WINOFFSETRECT'
oordinals.PMWIN.166='WININFLATERECT'
oordinals.PMWIN.167='WININTERSECTRECT'
oordinals.PMWIN.168='WINUNIONRECT'
oordinals.PMWIN.169='WINSUBTRACTRECT'
oordinals.PMWIN.170='WINMAKERECT'
oordinals.PMWIN.171='WINMAKEPOINTS'
oordinals.PMWIN.172='WININVERTRECT'
oordinals.PMWIN.173='WINFILLRECT'
oordinals.PMWIN.174='KBDPACKET'
oordinals.PMWIN.177='WINDRAWPOINTER'
oordinals.PMWIN.178='WINDEFWINDOWPROC'
oordinals.PMWIN.179='WINDEFDLGPROC'
oordinals.PMWIN.180='WINFRAMEWNDPROC'
oordinals.PMWIN.181='WINSTATICWNDPROC'
oordinals.PMWIN.182='WINBUTTONWNDPROC'
oordinals.PMWIN.183='WINEDITWNDPROC'
oordinals.PMWIN.184='WINSCROLLBARWNDPROC'
oordinals.PMWIN.185='MUWNDPROC'
oordinals.PMWIN.186='WINDESKTOPWNDPROC'
oordinals.PMWIN.187='WINMESSAGEBOXWNDPROC'
oordinals.PMWIN.188='WINTITLEBARWNDPROC'
oordinals.PMWIN.191='WINLISTBOXWNDPROC'
oordinals.PMWIN.192='WINSTATICWNDPROC'
oordinals.PMWIN.193='WINBUTTONWNDPROC'
oordinals.PMWIN.194='WINSCROLLBARWNDPROC'
oordinals.PMWIN.195='WINDESKTOPWNDPROC'
oordinals.PMWIN.196='WINICONTEXTWNDPROC'
oordinals.PMWIN.197='WINSYNCSTARTPGM'
oordinals.PMWIN.198='WINSCREENSWITCH'
oordinals.PMWIN.199='WINRESETSYSTEM'
oordinals.PMWIN.200='WINQUERYHUNGPROCESS'
oordinals.PMWIN.201='WINLOADSTRINGTABLE'
oordinals.PMWIN.202='WINLOADVKEYGLYPHXLATETBL'
oordinals.PMWIN.203='WINLOADCHARXLATETBL'
oordinals.PMWIN.204='WINSETVKEYGLYPHXLATETBL'
oordinals.PMWIN.205='WINSETCHARXLATETBL'
oordinals.PMWIN.206='WINQUERYVKEYGLYPHXLATETBL'
oordinals.PMWIN.207='WINQUERYCHARXLATETBL'
oordinals.PMWIN.208='WINVKEYGLYPHCHARXLATE'
oordinals.PMWIN.209='WINVKEYTOSCANID'
oordinals.PMWIN.210='WINQUERYPROCESSCP'
oordinals.PMWIN.211='WINGETKEYSTATE'
oordinals.PMWIN.212='WINGETPHYSKEYSTATE'
oordinals.PMWIN.213='WINSETKEYBOARDSTATETABLE'
oordinals.PMWIN.214='WINENABLEPHYSINPUT'
oordinals.PMWIN.215='WINSETCP'
oordinals.PMWIN.216='WINQUERYCP'
oordinals.PMWIN.217='WINQUERYCPLIST'
oordinals.PMWIN.218='WINCPTRANSLATESTRING'
oordinals.PMWIN.219='WINCPTRANSLATECHAR'
oordinals.PMWIN.220='WINCOMPARESTRINGS'
oordinals.PMWIN.221='WINUPPER'
oordinals.PMWIN.222='WINUPPERCHAR'
oordinals.PMWIN.223='WINNEXTCHAR'
oordinals.PMWIN.224='WINPREVCHAR'
oordinals.PMWIN.225='WINCREATEHEAP'
oordinals.PMWIN.226='WINDESTROYHEAP'
oordinals.PMWIN.227='WINAVAILMEM'
oordinals.PMWIN.228='WINALLOCMEM'
oordinals.PMWIN.229='WINREALLOCMEM'
oordinals.PMWIN.230='WINFREEMEM'
oordinals.PMWIN.231='WINLOCKHEAP'
oordinals.PMWIN.233='WINCREATEATOMTABLE'
oordinals.PMWIN.234='WINDESTROYATOMTABLE'
oordinals.PMWIN.235='WINADDATOM'
oordinals.PMWIN.236='WINFINDATOM'
oordinals.PMWIN.237='WINDELETEATOM'
oordinals.PMWIN.238='WINQUERYATOMUSAGE'
oordinals.PMWIN.239='WINQUERYATOMLENGTH'
oordinals.PMWIN.240='WINQUERYATOMNAME'
oordinals.PMWIN.241='WINQUERYSYSTEMATOMTABLE'
oordinals.PMWIN.242='WINSETLASTERROR'
oordinals.PMWIN.243='WINGETLASTERROR'
oordinals.PMWIN.244='WINGETERRORINFO'
oordinals.PMWIN.245='WINFREEERRORINFO'
oordinals.PMWIN.246='WININITIALIZE'
oordinals.PMWIN.247='WINTERMINATE'
oordinals.PMWIN.248='WINCATCH'
oordinals.PMWIN.249='WINTHROW'
oordinals.PMWIN.250='WINQUERYVERSION'
oordinals.PMWIN.251='FSRSEMENTER'
oordinals.PMWIN.252='FSRSEMLEAVE'
oordinals.PMWIN.253='FSRSEMEXIT'
oordinals.PMWIN.254='FSRSEMCHECK'
oordinals.PMWIN.255='FSRSEMENTERP'
oordinals.PMWIN.255='AABALLOCREG'
oordinals.PMWIN.256='AABGETREG'
oordinals.PMWIN.257='AABSETREG'
oordinals.PMWIN.258='VALIDATESELECTOR'
oordinals.PMWIN.259='LOADMODULEHANDLE'
oordinals.PMWIN.260='GETSCREENSELECTOR'
oordinals.PMWIN.261='IDENTIFYCODESELECTOR'
oordinals.PMWIN.262='WINQUERYWINDOWSGID'
oordinals.PMWIN.263='_WINSETERRORINFO'
oordinals.PMWIN.264='WINISPHYSINPUTENABLED'
oordinals.PMWIN.265='WINQUERYWINDOWDC'
oordinals.PMWIN.266='WINDRAWBORDER'
oordinals.PMWIN.267='WINDRAWTEXT'
oordinals.PMWIN.268='WINDRAWBITMAP'
oordinals.PMWIN.269='WINQUERYWINDOWPTR'
oordinals.PMWIN.270='WINSETWINDOWPTR'
oordinals.PMWIN.271='WININITIALIZESYSTEM'
oordinals.PMWIN.272='WINTERMINATESYSTEM'
oordinals.PMWIN.273='WINLOCKSTARTINPUT'
oordinals.PMWIN.274='WINMSGSEMWAIT'
oordinals.PMWIN.275='WINMSGMUXSEMWAIT'
oordinals.PMWIN.276='WINSYSTEMSHUTDOWN'
oordinals.PMWIN.277='WINCANCELSHUTDOWN'
oordinals.PMWIN.278='WINSETWINDOWBITS'
oordinals.PMWIN.279='WINGETCLIPPS'
oordinals.PMWIN.280='WINQUEUEWNDPROC'
oordinals.PMWIN.281='WINSENDQUEUEMSG'
oordinals.PMWIN.282='WINSETQUEUEPROC'
oordinals.PMWIN.283='WINDEFQUEUEPROC'
oordinals.PMWIN.285='WINSAVEWINDOWPOS'
oordinals.PMWIN.286='WINFOCUSCHANGE'
oordinals.PMWIN.287='WINQUERYQUEUEINFO'
oordinals.PMWIN.288='WINCALLHELPHOOK'
oordinals.PMWIN.289='WINSETATOMTABLEOWNER'
oordinals.PMWIN.290='WINISSHUTTINGDOWN'
oordinals.PMWIN.291='WINTERMINATESHUTDOWN'
oordinals.PMWIN.292='WINSETCLASSMSGINTEREST'
oordinals.PMWIN.293='VISREGIONCALLBACK'
oordinals.PMWIN.294='WINQUERYDLGITEMTEXTLENGTH'
oordinals.PMWIN.295='WINQUERYKBDLAYOUT'
oordinals.PMWIN.296='WINSETKBDLAYOUT'
oordinals.PMWIN.297='WINDDEINITIATE'
oordinals.PMWIN.298='WINDDERESPOND'
oordinals.PMWIN.299='WINDDEPOSTMSG'
oordinals.PMWIN.300='WINCANCELMODE'
oordinals.PMWIN.301='WINSETPRESPARAM'
oordinals.PMWIN.302='WINQUERYPRESPARAM'
oordinals.PMWIN.303='WINREMOVEPRESPARAM'
oordinals.PMWIN.304='WINTHREADASSOCQUEUE'
oordinals.PMWIN.305='WINQUEUEFROMID'
oordinals.PMWIN.306='WINQUERYSENDMSG'
oordinals.PMWIN.307='WINREPLYMSG'
oordinals.PMWIN.308='WINWAKETHREAD'
oordinals.PMWIN.309='WINLOCKINPUT'
oordinals.PMWIN.310='WINBUILDPTRHANDLE'
oordinals.PMWIN.311='DUMWINCREATEHELPINSTANCE'
oordinals.PMWIN.312='DUMWINDESTROYHELPINSTANCE'
oordinals.PMWIN.313='DUMWINASSOCIATEHELPINSTANCE'
oordinals.PMWIN.314='DUMWINCREATEHELPTABLE'
oordinals.PMWIN.315='DUMWINLOADHELPTABLE'
oordinals.PMWIN.316='DUMWINQUERYHELPINSTANCE'
oordinals.PMWIN.322='DUMMYHELPENTRY'
oordinals.PMWIN.959='WINSETCLASSTHUNKPROC'
oordinals.PMWIN.960='WINQUERYCLASSTHUNKPROC'
oordinals.PMWIN.961='WINSETWINDOWTHUNKPROC'
oordinals.PMWIN.962='WINQUERYWINDOWTHUNKPROC'
oordinals.PMWIN.317='WINQUERYWINDOWMODEL'
oordinals.PMWIN.318='WINSETDESKTOPBKGND'
oordinals.PMWIN.319='WINQUERYDESKTOPBKGND'
oordinals.PMWIN.320='WINPOPUPMENU'
oordinals.PMWIN.321='WINREALIZEPALETTE'
oordinals.PMWIN.325='GETPMDDCODESELECTOR'
oordinals.PMWIN.326='WINSEMENTER'
oordinals.PMWIN.327='WINSEMLEAVE'
oordinals.PMWIN.328='WINQUERYPWND'
oordinals.PMWIN.329='WINQUERYSTATE'
oordinals.PMWIN.330='WINLOADANIPOINTER'
oordinals.PMWIN.331='WINDESTROYANIPOINTER'
oordinals.PMWIN.332='WINSETANIPOINTER'
oordinals.PMWIN.333='WINENUMVKEYSCANIDS'
oordinals.PMWIN.334='WINSEMQUERY'
oordinals.PMWIN.400='WINLOADTRANSLATIONTABLE'
oordinals.PMWIN.401='WINSETKBDLAYOUT2'
oordinals.PMWIN.495='WINSEAMLESSBOX'
oordinals.PMWIN.496='WINISWINDOWOVERLAPPED'
oordinals.PMWIN.497='WINJIGGLEMOUSE'
oordinals.PMWIN.498='WINTRACKSEAMLESS'
oordinals.PMWIN.499='WINREGISTERSEAMLESSPROC'
oordinals.PMWIN.602='WINDELETELIBRARY'
oordinals.PMWIN.603='WINLOADPROCEDURE'
oordinals.PMWIN.604='WINDELETEPROCEDURE'
oordinals.PMWIN.605='WINSETMSGMODE'
oordinals.PMWIN.606='WINSETSYNCHROMODE'
oordinals.PMWIN.607='WINGETDLGMSG'
oordinals.PMWIN.608='WINREGISTERUSERMSG'
oordinals.PMWIN.609='WINQUERYANCHORBLOCK'
oordinals.PMWIN.610='WINLANGSUPWINDOWPROC'
oordinals.PMWIN.611='WINLANGSUPDLGPROC'
oordinals.PMWIN.612='WINREGISTERUSERDATATYPE'
oordinals.PMWIN.613='FARCALLHOOK'
oordinals.PMWIN.614='WINISWINDOWSHOWING'
oordinals.PMWIN.615='WINLOADLIBRARY'
oordinals.PMWIN.616='WINCREATEPOINTERINDIRECT'
oordinals.PMWIN.617='WINQUERYPOINTERINFO'
oordinals.PMWIN.618='WINSETMENUDATa'
oordinals.PMWIN.619='WINQUERYMENUDATa'
oordinals.PMWIN.620='WINMENUINDEXFROMID'
oordinals.PMWIN.621='WINFORCEMENUREDRAW'
oordinals.PMWIN.622='WINGETSCANSTATE'
oordinals.PMWIN.623='WINSETSCANSTATETABLE'
oordinals.PMWIN.624='WINGETERASEPS'
oordinals.PMWIN.625='WINRELEASEERASEPS'
oordinals.PMWIN.626='WINSETWINDOWDC'
oordinals.PMWIN.627='WINTRANSLATECHAR'
oordinals.PMWIN.628='WINPORTHOLEUTIL'
oordinals.PMWIN.500='ABNORMALPROCESSEXIT'
oordinals.PMWIN.508='WINPROFCONTROL'
oordinals.PMWIN.509='DEBUGINPUTENABLE'
oordinals.PMWIN.510='DEBUGINPUT'
oordinals.PMWIN.511='DEBUGOUTPUT'
oordinals.PMWIN.512='DEBUGCURPOS'
oordinals.PMWIN.513='DEBUGCLS'
oordinals.PMWIN.514='WINDEBUGBREAK'
oordinals.PMWIN.515='DEBUGREDIRECT'
oordinals.PMWIN.590='INPUTGETDEVICEINFO'
oordinals.PMWIN.600='STARTTIMER'
oordinals.PMWIN.601='DESTROYTIMERS'
oordinals.PMWIN.629='WINEXPLODEWINDOW'
oordinals.PMWIN.630='WINSETACCELTABLEVALUE'
oordinals.PMWIN.631='WINQUERYACCELTABLEVALUE'
oordinals.PMWIN.632='WINSTRETCHPOINTER'
oordinals.PMWIN.633='WINSETPOINTEROWNER'
oordinals.PMWIN.634='WINGETFRAMETREEPPSIZE'
oordinals.PMWIN.635='WINGETFRAMETREEPPS'
oordinals.PMWIN.636='WINSETFRAMETREEPPS'
oordinals.PMWIN.637='WINGETMINWINDOWVIEWER'
oordinals.PMWIN.638='WINQUERYWORKPLACEWINDOW'
oordinals.PMWIN.639='WINLOCKPOINTERUPDATE'
oordinals.PMWIN.640='WINCHECKINPUT'
oordinals.PMWIN.641='FARFLUSHBUFHOOK'
oordinals.PMWIN.700='WIN32ADDATOM'
oordinals.PMWIN.701='WIN32ALARM'
oordinals.PMWIN.702='WIN32BEGINENUMWINDOWS'
oordinals.PMWIN.703='WIN32BEGINPAINT'
oordinals.PMWIN.704='WIN32CALCFRAMERECT'
oordinals.PMWIN.705='WIN32CANCELSHUTDOWN'
oordinals.PMWIN.707='WIN32CLOSECLIPBRD'
oordinals.PMWIN.708='WIN32COMPARESTRINGS'
oordinals.PMWIN.709='WIN32COPYACCELTABLE'
oordinals.PMWIN.710='WIN32COPYRECT'
oordinals.PMWIN.711='WIN32CPTRANSLATECHAR'
oordinals.PMWIN.712='WIN32CPTRANSLATESTRING'
oordinals.PMWIN.713='WIN32CREATEACCELTABLE'
oordinals.PMWIN.714='WIN32CREATEATOMTABLE'
oordinals.PMWIN.715='WIN32CREATECURSOR'
oordinals.PMWIN.716='WIN32CREATEMSGQUEUE'
oordinals.PMWIN.717='WIN32CREATEPOINTER'
oordinals.PMWIN.718='WIN32DDEINITIATE'
oordinals.PMWIN.719='WIN32DDEPOSTMSG'
oordinals.PMWIN.720='WIN32DDERESPOND'
oordinals.PMWIN.721='WIN32DELETEATOM'
oordinals.PMWIN.722='WIN32DELETELIBRARY'
oordinals.PMWIN.723='WIN32DESTROYACCELTABLE'
oordinals.PMWIN.724='WIN32DESTROYATOMTABLE'
oordinals.PMWIN.725='WIN32DESTROYCURSOR'
oordinals.PMWIN.726='WIN32DESTROYMSGQUEUE'
oordinals.PMWIN.727='WIN32DESTROYPOINTER'
oordinals.PMWIN.728='WIN32DESTROYWINDOW'
oordinals.PMWIN.729='WIN32DISMISSDLG'
oordinals.PMWIN.730='WIN32DRAWBITMAP'
oordinals.PMWIN.731='WIN32DRAWBORDER'
oordinals.PMWIN.732='WIN32DRAWPOINTER'
oordinals.PMWIN.733='WIN32EMPTYCLIPBRD'
oordinals.PMWIN.734='WIN32ENABLEPHYSINPUT'
oordinals.PMWIN.735='WIN32ENABLEWINDOW'
oordinals.PMWIN.736='WIN32ENABLEWINDOWUPDATE'
oordinals.PMWIN.737='WIN32ENDENUMWINDOWS'
oordinals.PMWIN.738='WIN32ENDPAINT'
oordinals.PMWIN.739='WIN32ENUMCLIPBRDFMTS'
oordinals.PMWIN.740='WIN32ENUMDLGITEM'
oordinals.PMWIN.741='WIN32EQUALRECT'
oordinals.PMWIN.742='WIN32EXCLUDEUPDATEREGION'
oordinals.PMWIN.743='WIN32FILLRECT'
oordinals.PMWIN.744='WIN32FINDATOM'
oordinals.PMWIN.745='WIN32FLASHWINDOW'
oordinals.PMWIN.746='WIN32FOCUSCHANGE'
oordinals.PMWIN.748='WIN32FREEERRORINFO'
oordinals.PMWIN.749='WIN32GETCLIPPS'
oordinals.PMWIN.750='WIN32GETCURRENTTIME'
oordinals.PMWIN.751='WIN32GETERRORINFO'
oordinals.PMWIN.752='WIN32GETKEYSTATE'
oordinals.PMWIN.753='WIN32GETLASTERROR'
oordinals.PMWIN.754='WIN32GETMAXPOSITION'
oordinals.PMWIN.755='WIN32GETMINPOSITION'
oordinals.PMWIN.756='WIN32GETNEXTWINDOW'
oordinals.PMWIN.757='WIN32GETPS'
oordinals.PMWIN.758='WIN32GETPHYSKEYSTATE'
oordinals.PMWIN.759='WIN32GETSCREENPS'
oordinals.PMWIN.760='WIN32GETSYSBITMAP'
oordinals.PMWIN.761='WIN32INSENDMSG'
oordinals.PMWIN.762='WIN32INFLATERECT'
oordinals.PMWIN.763='WIN32INITIALIZE'
oordinals.PMWIN.764='WIN32INTERSECTRECT'
oordinals.PMWIN.765='WIN32INVALIDATERECT'
oordinals.PMWIN.766='WIN32INVALIDATEREGION'
oordinals.PMWIN.767='WIN32INVERTRECT'
oordinals.PMWIN.768='WIN32ISCHILD'
oordinals.PMWIN.769='WIN32ISPHYSINPUTENABLED'
oordinals.PMWIN.770='WIN32ISRECTEMPTY'
oordinals.PMWIN.771='WIN32ISTHREADACTIVE'
oordinals.PMWIN.772='WIN32ISWINDOW'
oordinals.PMWIN.773='WIN32ISWINDOWENABLED'
oordinals.PMWIN.774='WIN32ISWINDOWSHOWING'
oordinals.PMWIN.775='WIN32ISWINDOWVISIBLE'
oordinals.PMWIN.776='WIN32LOADACCELTABLE'
oordinals.PMWIN.777='WIN32LOADLIBRARY'
oordinals.PMWIN.778='WIN32LOADMENU'
oordinals.PMWIN.779='WIN32LOADMESSAGE'
oordinals.PMWIN.780='WIN32LOADPOINTER'
oordinals.PMWIN.781='WIN32LOADSTRING'
oordinals.PMWIN.782='WIN32LOCKVISREGIONS'
oordinals.PMWIN.784='WIN32LOCKWINDOWUPDATE'
oordinals.PMWIN.785='WIN32MAKEPOINTS'
oordinals.PMWIN.786='WIN32MAKERECT'
oordinals.PMWIN.787='WIN32MAPDLGPOINTS'
oordinals.PMWIN.788='WIN32MAPWINDOWPOINTS'
oordinals.PMWIN.789='WIN32MESSAGEBOX'
oordinals.PMWIN.790='WIN32MSGSEMWAIT'
oordinals.PMWIN.791='WIN32NEXTCHAR'
oordinals.PMWIN.792='WIN32OFFSETRECT'
oordinals.PMWIN.793='WIN32OPENCLIPBRD'
oordinals.PMWIN.794='WIN32OPENWINDOWDC'
oordinals.PMWIN.795='WIN32PREVCHAR'
oordinals.PMWIN.796='WIN32PROCESSDLG'
oordinals.PMWIN.797='WIN32PTINRECT'
oordinals.PMWIN.798='WIN32QUERYACCELTABLE'
oordinals.PMWIN.799='WIN32QUERYACTIVEWINDOW'
oordinals.PMWIN.800='WIN32QUERYANCHORBLOCK'
oordinals.PMWIN.801='WIN32QUERYATOMLENGTH'
oordinals.PMWIN.802='WIN32QUERYATOMNAME'
oordinals.PMWIN.803='WIN32QUERYATOMUSAGE'
oordinals.PMWIN.804='WIN32QUERYCAPTURE'
oordinals.PMWIN.805='WIN32QUERYCLASSNAME'
oordinals.PMWIN.806='WIN32QUERYCLIPBRDDATA'
oordinals.PMWIN.807='WIN32QUERYCLIPBRDFMTINFO'
oordinals.PMWIN.808='WIN32QUERYCLIPBRDOWNER'
oordinals.PMWIN.809='WIN32QUERYCLIPBRDVIEWER'
oordinals.PMWIN.810='WIN32QUERYCP'
oordinals.PMWIN.811='WIN32QUERYCPLIST'
oordinals.PMWIN.812='WIN32QUERYCURSORINFO'
oordinals.PMWIN.813='WIN32QUERYDESKTOPWINDOW'
oordinals.PMWIN.814='WIN32QUERYDLGITEMSHORT'
oordinals.PMWIN.815='WIN32QUERYDLGITEMTEXT'
oordinals.PMWIN.816='WIN32QUERYDLGITEMTEXTLENGTH'
oordinals.PMWIN.817='WIN32QUERYFOCUS'
oordinals.PMWIN.818='WIN32QUERYMSGPOS'
oordinals.PMWIN.819='WIN32QUERYMSGTIME'
oordinals.PMWIN.820='WIN32QUERYOBJECTWINDOW'
oordinals.PMWIN.821='WIN32QUERYPOINTER'
oordinals.PMWIN.822='WIN32QUERYPOINTERINFO'
oordinals.PMWIN.823='WIN32QUERYPOINTERPOS'
oordinals.PMWIN.824='WIN32QUERYQUEUEINFO'
oordinals.PMWIN.825='WIN32QUERYQUEUESTATUS'
oordinals.PMWIN.826='WIN32QUERYSYSCOLOR'
oordinals.PMWIN.827='WIN32QUERYSYSMODALWINDOW'
oordinals.PMWIN.828='WIN32QUERYSYSPOINTER'
oordinals.PMWIN.829='WIN32QUERYSYSVALUE'
oordinals.PMWIN.830='WIN32QUERYSYSTEMATOMTABLE'
oordinals.PMWIN.831='WIN32QUERYUPDATERECT'
oordinals.PMWIN.832='WIN32QUERYUPDATEREGION'
oordinals.PMWIN.833='WIN32QUERYVERSION'
oordinals.PMWIN.834='WIN32QUERYWINDOW'
oordinals.PMWIN.835='WIN32QUERYWINDOWDC'
oordinals.PMWIN.837='WIN32QUERYWINDOWPOS'
oordinals.PMWIN.838='WIN32QUERYWINDOWPROCESS'
oordinals.PMWIN.839='WIN32QUERYWINDOWPTR'
oordinals.PMWIN.840='WIN32QUERYWINDOWRECT'
oordinals.PMWIN.841='WIN32QUERYWINDOWTEXT'
oordinals.PMWIN.842='WIN32QUERYWINDOWTEXTLENGTH'
oordinals.PMWIN.843='WIN32QUERYWINDOWULONG'
oordinals.PMWIN.844='WIN32QUERYWINDOWUSHORT'
oordinals.PMWIN.845='WIN32REGISTERUSERDATATYPE'
oordinals.PMWIN.846='WIN32REGISTERUSERMSG'
oordinals.PMWIN.848='WIN32RELEASEPS'
oordinals.PMWIN.849='WIN32SCROLLWINDOW'
oordinals.PMWIN.850='WIN32SETACCELTABLE'
oordinals.PMWIN.851='WIN32SETACTIVEWINDOW'
oordinals.PMWIN.852='WIN32SETCAPTURE'
oordinals.PMWIN.853='WIN32SETCLASSMSGINTEREST'
oordinals.PMWIN.854='WIN32SETCLIPBRDDATA'
oordinals.PMWIN.855='WIN32SETCLIPBRDOWNER'
oordinals.PMWIN.856='WIN32SETCLIPBRDVIEWER'
oordinals.PMWIN.857='WIN32SETCP'
oordinals.PMWIN.858='WIN32SETDLGITEMSHORT'
oordinals.PMWIN.859='WIN32SETDLGITEMTEXT'
oordinals.PMWIN.860='WIN32SETFOCUS'
oordinals.PMWIN.861='WIN32SETMSGINTEREST'
oordinals.PMWIN.862='WIN32SETMSGMODE'
oordinals.PMWIN.863='WIN32SETMULTWINDOWPOS'
oordinals.PMWIN.864='WIN32SETOWNER'
oordinals.PMWIN.865='WIN32SETPARENT'
oordinals.PMWIN.866='WIN32SETPOINTER'
oordinals.PMWIN.867='WIN32SETPOINTERPOS'
oordinals.PMWIN.868='WIN32SETRECT'
oordinals.PMWIN.869='WIN32SETRECTEMPTY'
oordinals.PMWIN.870='WIN32SETSYNCHROMODE'
oordinals.PMWIN.871='WIN32SETSYSCOLORS'
oordinals.PMWIN.872='WIN32SETSYSMODALWINDOW'
oordinals.PMWIN.873='WIN32SETSYSVALUE'
oordinals.PMWIN.874='WIN32SETWINDOWBITS'
oordinals.PMWIN.875='WIN32SETWINDOWPOS'
oordinals.PMWIN.876='WIN32SETWINDOWPTR'
oordinals.PMWIN.877='WIN32SETWINDOWTEXT'
oordinals.PMWIN.878='WIN32SETWINDOWULONG'
oordinals.PMWIN.879='WIN32SETWINDOWUSHORT'
oordinals.PMWIN.880='WIN32SHOWCURSOR'
oordinals.PMWIN.881='WIN32SHOWPOINTER'
oordinals.PMWIN.882='WIN32SHOWTRACKRECT'
oordinals.PMWIN.883='WIN32SHOWWINDOW'
oordinals.PMWIN.884='WIN32STARTTIMER'
oordinals.PMWIN.885='WIN32STOPTIMER'
oordinals.PMWIN.886='WIN32SUBSTITUTESTRINGS'
oordinals.PMWIN.887='WIN32SUBTRACTRECT'
oordinals.PMWIN.888='WIN32TERMINATE'
oordinals.PMWIN.890='WIN32TRACKRECT'
oordinals.PMWIN.891='WIN32UNIONRECT'
oordinals.PMWIN.892='WIN32UPDATEWINDOW'
oordinals.PMWIN.893='WIN32UPPER'
oordinals.PMWIN.894='WIN32UPPERCHAR'
oordinals.PMWIN.895='WIN32VALIDATERECT'
oordinals.PMWIN.896='WIN32VALIDATEREGION'
oordinals.PMWIN.897='WIN32WAITMSG'
oordinals.PMWIN.898='WIN32WINDOWFROMDC'
oordinals.PMWIN.899='WIN32WINDOWFROMID'
oordinals.PMWIN.900='WIN32WINDOWFROMPOINT'
oordinals.PMWIN.901='WIN32BROADCASTMSG'
oordinals.PMWIN.902='WIN32POSTQUEUEMSG'
oordinals.PMWIN.903='WIN32SENDDLGITEMMSG'
oordinals.PMWIN.904='WIN32TRANSLATEACCEL'
oordinals.PMWIN.905='WIN32CALLMSGFILTER'
oordinals.PMWIN.906='WIN32CREATEFRAMECONTROLS'
oordinals.PMWIN.907='WIN32CREATEMENU'
oordinals.PMWIN.908='WIN32CREATESTDWINDOW'
oordinals.PMWIN.909='WIN32CREATEWINDOW'
oordinals.PMWIN.910='WIN32DEFDLGPROC'
oordinals.PMWIN.911='WIN32DEFWINDOWPROC'
oordinals.PMWIN.912='WIN32DISPATCHMSG'
oordinals.PMWIN.913='WIN32DRAWTEXT'
oordinals.PMWIN.914='WIN32GETDLGMSG'
oordinals.PMWIN.915='WIN32GETMSG'
oordinals.PMWIN.916='WIN32MSGMUXSEMWAIT'
oordinals.PMWIN.917='WIN32MULTWINDOWFROMIDS'
oordinals.PMWIN.918='WIN32PEEKMSG'
oordinals.PMWIN.919='WIN32POSTMSG'
oordinals.PMWIN.920='WIN32SENDMSG'
oordinals.PMWIN.921='WIN32SETKEYBOARDSTATETABLE'
oordinals.PMWIN.922='WIN32CREATEDLG'
oordinals.PMWIN.923='WIN32DLGBOX'
oordinals.PMWIN.924='WIN32LOADDLG'
oordinals.PMWIN.925='WIN32QUERYCLASSINFO'
oordinals.PMWIN.926='WIN32REGISTERCLASS'
oordinals.PMWIN.927='WIN32RELEASEHOOK'
oordinals.PMWIN.928='WIN32SETHOOK'
oordinals.PMWIN.929='WIN32SUBCLASSWINDOW'
oordinals.PMWIN.930='WIN32SETCLASSTHUNKPROC'
oordinals.PMWIN.931='WIN32QUERYCLASSTHUNKPROC'
oordinals.PMWIN.932='WIN32SETWINDOWTHUNKPROC'
oordinals.PMWIN.933='WIN32QUERYWINDOWTHUNKPROC'
oordinals.PMWIN.934='WIN32QUERYWINDOWMODEL'
oordinals.PMWIN.935='WIN32SETDESKTOPBKGND'
oordinals.PMWIN.936='WIN32QUERYDESKTOPBKGND'
oordinals.PMWIN.937='WIN32POPUPMENU'
oordinals.PMWIN.938='WIN32SETPRESPARAM'
oordinals.PMWIN.939='WIN32QUERYPRESPARAM'
oordinals.PMWIN.940='WIN32REMOVEPRESPARAM'
oordinals.PMWIN.941='WIN32REALIZEPALETTE'
oordinals.PMWIN.942='WIN32CREATEPOINTERINDIRECT'
oordinals.PMWIN.943='WIN32SAVEWINDOWPOS'
oordinals.PMWIN.947='WINCREATEFARHEAP'
oordinals.PMWIN.948='WINDESTROYFARHEAP'
oordinals.PMWIN.949='WINALLOCFARMEM'
oordinals.PMWIN.950='WINFREEFARMEM'
oordinals.PMWIN.951='WINREALLOCFARMEM'
oordinals.PMWIN.952='WIN32GETERASEPS'
oordinals.PMWIN.953='WIN32RELEASEERASEPS'
oordinals.PMWIN.954='DEBUG32INPUT'
oordinals.PMWIN.955='DEBUG32OUTPUT'
oordinals.PMWIN.956='DEBUG32CURPOS'
oordinals.PMWIN.957='DEBUG32CLS'
oordinals.PMWIN.958='WIN32DEBUGBREAK'
oordinals.PMWIN.969='AAB32GETREG'
oordinals.PMWIN.970='AAB32SETREG'
oordinals.PMWIN.971='WIN32SETPOINTEROWNER'
oordinals.PMWIN.963='WIN32SYSTEMSHUTDOWN'
oordinals.PMWIN.964='WIN32BUILDPTRHANDLE'
oordinals.PMWIN.965='WIN32EXPLODEWINDOW'
oordinals.PMWIN.966='WIN32SETACCELTABLEVALUE'
oordinals.PMWIN.967='WIN32QUERYACCELTABLEVALUE'
oordinals.PMWIN.968='WIN32STRETCHPOINTER'
oordinals.PMWIN.972='WIN32GETFRAMETREEPPSIZE'
oordinals.PMWIN.973='WIN32GETFRAMETREEPPS'
oordinals.PMWIN.974='WIN32SETFRAMETREEPPS'
oordinals.PMWIN.975='WIN32QUERYPROCESSCP'
oordinals.PMWIN.976='WIN32VISREGIONNOTIFY'
oordinals.PMWIN.977='WIN32SETERRORINFO'
oordinals.PMWIN.978='WIN32WAITEVENTSEM'
oordinals.PMWIN.979='WIN32REQUESTMUTEXSEM'
oordinals.PMWIN.980='WIN32WAITMUXWAITSEM'
oordinals.PMWIN.981='WINSETSYSCLIPBRDVIEWER'
oordinals.PMWIN.982='WIN32SETSYSCLIPBRDVIEWER'
oordinals.PMWIN.983='WIN32SEMQUERY'
oordinals.PMWIN.984='WIN32SEMENTER'
oordinals.PMWIN.985='WIN32SEMLEAVE'
oordinals.PMWIN.986='WIN32LOADPROCEDURE'
oordinals.PMWIN.987='WIN32DELETEPROCEDURE'
oordinals.PMWIN.988='WIN32MOVECURSOR'
oordinals.PMWIN.990='WIN32QUERYSENDMSG'
oordinals.PMWIN.991='WIN32REPLYMSG'
oordinals.PMWIN.992='WIN32WAKETHREAD'
oordinals.PMWIN.993='WIN32QUEUEFROMID'
oordinals.PMWIN.994='WIN32THREADASSOCQUEUE'
oordinals.PMWIN.995='WIN32LOCKINPUT'
oordinals.PMWIN.996='WIN32SETSYSFONT'
oordinals.PMWIN.997='WIN32LOCKPOINTERUPDATE'
oordinals.PMWIN.998='WIN32CHECKINPUT'
oordinals.PMWIN.999='FAR32LOCKUPHOOK'
oordinals.PMWIN.1000='WIN32QUERYVISIBLEREGION'
oordinals.PMWIN.1001='WIN32SETVISIBLEREGIONNOTIFY'
oordinals.PMWIN.1002='WIN32SETSYSPOINTERDATA'
oordinals.PMWIN.1003='WIN32QUERYSYSPOINTERDATA'
oordinals.PMGRE.3='INNERGREENTRY'
oordinals.PMGRE.4='GREINITIALIZE'
oordinals.PMGRE.6='GREINITIALIZE32'
oordinals.PMGRE.12='GREENTRY2'
oordinals.PMGRE.13='GREENTRY3'
oordinals.PMGRE.14='GREENTRY4'
oordinals.PMGRE.15='GREENTRY5'
oordinals.PMGRE.16='GREENTRY6'
oordinals.PMGRE.17='GREENTRY7'
oordinals.PMGRE.18='GREENTRY8'
oordinals.PMGRE.19='GREENTRY9'
oordinals.PMGRE.20='GREENTRY10'
oordinals.PMGRE.30='GETDRIVERINFOTH'
oordinals.PMGRE.30='GETDRIVERINFO'
oordinals.PMGRE.31='SETDRIVERINFOTH'
oordinals.PMGRE.31='SETDRIVERINFO'
oordinals.PMGRE.32='POSTDEVICEMODES'
oordinals.PMGRE.33='INITMOVECURSOR'
oordinals.PMGRE.34='BITMAPLIMITWARNING'
oordinals.PMGRE.37='GETDRIVERINFO32'
oordinals.PMGRE.38='SETDRIVERINFO32'
oordinals.PMGRE.39='POSTDEVICEMODES32'
oordinals.PMGRE.42='PMWINGREENTRY2'
oordinals.PMGRE.43='PMWINGREENTRY3'
oordinals.PMGRE.44='PMWINGREENTRY4'
oordinals.PMGRE.45='PMWINGREENTRY5'
oordinals.PMGRE.46='PMWINGREENTRY6'
oordinals.PMGRE.47='PMWINGREENTRY7'
oordinals.PMGRE.48='PMWINGREENTRY8'
oordinals.PMGRE.49='PMWINGREENTRY9'
oordinals.PMGRE.50='PMWINGREENTRY10'
oordinals.PMGRE.62='GRE32ENTRY2'
oordinals.PMGRE.63='GRE32ENTRY3'
oordinals.PMGRE.64='GRE32ENTRY4'
oordinals.PMGRE.65='GRE32ENTRY5'
oordinals.PMGRE.66='GRE32ENTRY6'
oordinals.PMGRE.67='GRE32ENTRY7'
oordinals.PMGRE.68='GRE32ENTRY8'
oordinals.PMGRE.69='GRE32ENTRY9'
oordinals.PMGRE.70='GRE32ENTRY10'
oordinals.PMGRE.72='INNERGRE32ENTRY2'
oordinals.PMGRE.73='INNERGRE32ENTRY3'
oordinals.PMGRE.74='INNERGRE32ENTRY4'
oordinals.PMGRE.75='INNERGRE32ENTRY5'
oordinals.PMGRE.76='INNERGRE32ENTRY6'
oordinals.PMGRE.77='INNERGRE32ENTRY7'
oordinals.PMGRE.78='INNERGRE32ENTRY8'
oordinals.PMGRE.79='INNERGRE32ENTRY9'
oordinals.PMGRE.80='INNERGRE32ENTRY10'
oordinals.PMGRE.100='SSALLOCSEG'
oordinals.PMGRE.101='SSALLOCHUGE'
oordinals.PMGRE.102='SSFREESEG'
oordinals.PMGRE.103='SSFLUSHSEGS'
oordinals.PMGRE.105='SSINIT'
oordinals.PMGRE.106='SSALLOCMEM'
oordinals.PMGRE.107='SSFREEMEM'
oordinals.PMGRE.108='SSFLUSHMEM'
oordinals.PMGRE.110='FPROCESS'
oordinals.PMGRE.111='HSINGLEQ'
oordinals.PMGRE.112='HMOUSE'
oordinals.PMGRE.113='UPROCESSCP'
oordinals.PMGRE.114='UPROCESSCC'
oordinals.PMGRE.115='CMQPROCESS'
oordinals.PMGRE.116='UQUEUECP'
oordinals.PMGRE.117='FISDBCS'
oordinals.PMGRE.118='NRPTERRLEVEL'
oordinals.PMGRE.119='FDEBUGBREAK'
oordinals.PMGRE.120='HDBGINFILE'
oordinals.PMGRE.121='HDBGOUTFILE'
oordinals.PMGRE.122='BMHMODSLOADED'
oordinals.PMGRE.123='SEMINSTANCE'
oordinals.PMGRE.124='WINSEL'
oordinals.PMGRE.125='CBTHREADS'
oordinals.PMGRE.126='PFNSEAMLESSPROC'
oordinals.PMGRE.127='PFNEXT'
oordinals.PMGRE.128='FMLELOADED'
oordinals.PMGRE.130='CLEANUPINSTALLED'
oordinals.PMGRE.131='COUNTOFHINI'
oordinals.PMGRE.132='SELCLEANUPLST'
oordinals.PMGRE.141='SSINIT32'
oordinals.PMGRE.300='GREREQUESTMUTEXSEM'
oordinals.PMGRE.301='GRERELEASEMUTEXSEM'
oordinals.PMGRE.400='RAMSEMREQUEST32'
oordinals.PMGRE.401='RAMSEMCLEAR32'
oordinals.PMGRE.402='RAMSEMREQUEST'
oordinals.PMGRE.403='RAMSEMCLEAR'
oordinals.PMGPI.1='DEVOPENDC'
oordinals.PMGPI.2='DEVCLOSEDC'
oordinals.PMGPI.3='DEVPOSTDEVICEMODES'
oordinals.PMGPI.4='DEVESCAPE'
oordinals.PMGPI.5='DEVQUERYHARDCOPYCAPS'
oordinals.PMGPI.6='DEVQUERYCAPS'
oordinals.PMGPI.7='GPICREATEPS'
oordinals.PMGPI.9='GPIQUERYPS'
oordinals.PMGPI.10='GPIDESTROYPS'
oordinals.PMGPI.11='GPIRESETPS'
oordinals.PMGPI.12='GPISAVEPS'
oordinals.PMGPI.13='GPIRESTOREPS'
oordinals.PMGPI.14='GPIASSOCIATE'
oordinals.PMGPI.15='GPIERRORSEGMENTDATA'
oordinals.PMGPI.16='GPIERASE'
oordinals.PMGPI.17='GPISETDRAWCONTROL'
oordinals.PMGPI.18='GPIQUERYDRAWCONTROL'
oordinals.PMGPI.19='GPIDRAWCHAIN'
oordinals.PMGPI.20='GPIDRAWFROM'
oordinals.PMGPI.21='GPIDRAWSEGMENT'
oordinals.PMGPI.22='GPISETSTOPDRAW'
oordinals.PMGPI.23='GPIQUERYSTOPDRAW'
oordinals.PMGPI.24='GPIREMOVEDYNAMICS'
oordinals.PMGPI.25='GPIDRAWDYNAMICS'
oordinals.PMGPI.26='GPISETDRAWINGMODE'
oordinals.PMGPI.27='GPIQUERYDRAWINGMODE'
oordinals.PMGPI.28='GPIGETDATA'
oordinals.PMGPI.29='GPIPUTDATA'
oordinals.PMGPI.30='GPISETPICKAPERTURESIZE'
oordinals.PMGPI.31='GPIQUERYPICKAPERTURESIZE'
oordinals.PMGPI.32='GPISETPICKAPERTUREPOSITION'
oordinals.PMGPI.33='GPIQUERYPICKAPERTUREPOSITION'
oordinals.PMGPI.34='GPISETTAG'
oordinals.PMGPI.35='GPIQUERYTAG'
oordinals.PMGPI.36='GPICORRELATECHAIN'
oordinals.PMGPI.37='GPICORRELATEFROM'
oordinals.PMGPI.38='GPICORRELATESEGMENT'
oordinals.PMGPI.42='GPIRESETBOUNDARYDATA'
oordinals.PMGPI.43='GPIQUERYBOUNDARYDATA'
oordinals.PMGPI.44='GPIOPENSEGMENT'
oordinals.PMGPI.46='GPICLOSESEGMENT'
oordinals.PMGPI.47='GPIDELETESEGMENT'
oordinals.PMGPI.48='GPIDELETESEGMENTS'
oordinals.PMGPI.49='GPIQUERYSEGMENTNAMES'
oordinals.PMGPI.51='GPISETINITIALSEGMENTATTRS'
oordinals.PMGPI.52='GPIQUERYINITIALSEGMENTATTRS'
oordinals.PMGPI.53='GPISETSEGMENTATTRS'
oordinals.PMGPI.54='GPIQUERYSEGMENTATTRS'
oordinals.PMGPI.55='GPISETSEGMENTPRIORITY'
oordinals.PMGPI.56='GPIQUERYSEGMENTPRIORITY'
oordinals.PMGPI.57='GPISETEDITMODE'
oordinals.PMGPI.58='GPIQUERYEDITMODE'
oordinals.PMGPI.59='GPISETELEMENTPOINTER'
oordinals.PMGPI.60='GPIQUERYELEMENTPOINTER'
oordinals.PMGPI.61='GPIOFFSETELEMENTPOINTER'
oordinals.PMGPI.62='GPIDELETEELEMENT'
oordinals.PMGPI.63='GPIDELETEELEMENTRANGE'
oordinals.PMGPI.64='GPILABEL'
oordinals.PMGPI.65='GPISETELEMENTPOINTERATLABEL'
oordinals.PMGPI.66='GPIDELETEELEMENTSBETWEENLABELS'
oordinals.PMGPI.67='GPIQUERYELEMENTTYPE'
oordinals.PMGPI.68='GPIQUERYELEMENT'
oordinals.PMGPI.69='GPIELEMENT'
oordinals.PMGPI.70='GPIBEGINELEMENT'
oordinals.PMGPI.71='GPIENDELEMENT'
oordinals.PMGPI.78='GPISETSEGMENTTRANSFORMMATRIX'
oordinals.PMGPI.79='GPIQUERYSEGMENTTRANSFORMMATRIX'
oordinals.PMGPI.80='GPISETMODELTRANSFORMMATRIX'
oordinals.PMGPI.81='GPIQUERYMODELTRANSFORMMATRIX'
oordinals.PMGPI.82='GPICALLSEGMENTMATRIX'
oordinals.PMGPI.83='GPISETDEFAULTVIEWMATRIX'
oordinals.PMGPI.84='GPIQUERYDEFAULTVIEWMATRIX'
oordinals.PMGPI.85='GPISETPAGEVIEWPORT'
oordinals.PMGPI.86='GPIQUERYPAGEVIEWPORT'
oordinals.PMGPI.87='GPISETVIEWINGTRANSFORMMATRIX'
oordinals.PMGPI.88='GPIQUERYVIEWINGTRANSFORMMATRIX'
oordinals.PMGPI.89='GPISETGRAPHICSFIELD'
oordinals.PMGPI.90='GPIQUERYGRAPHICSFIELD'
oordinals.PMGPI.91='GPISETVIEWINGLIMITS'
oordinals.PMGPI.92='GPIQUERYVIEWINGLIMITS'
oordinals.PMGPI.93='GPICONVERT'
oordinals.PMGPI.94='GPISETATTRMODE'
oordinals.PMGPI.95='GPIQUERYATTRMODE'
oordinals.PMGPI.96='GPIPOP'
oordinals.PMGPI.97='GPISETATTRS'
oordinals.PMGPI.98='GPIQUERYATTRS'
oordinals.PMGPI.99='GPICREATELOGCOLORTABLE'
oordinals.PMGPI.100='GPIREALIZECOLORTABLE'
oordinals.PMGPI.101='GPIUNREALIZECOLORTABLE'
oordinals.PMGPI.102='GPIQUERYCOLORDATA'
oordinals.PMGPI.103='GPIQUERYLOGCOLORTABLE'
oordinals.PMGPI.104='GPIQUERYREALCOLORS'
oordinals.PMGPI.105='GPIQUERYNEARESTCOLOR'
oordinals.PMGPI.106='GPIQUERYCOLORINDEX'
oordinals.PMGPI.107='GPIQUERYRGBCOLOR'
oordinals.PMGPI.108='GPISETCOLOR'
oordinals.PMGPI.109='GPIQUERYCOLOR'
oordinals.PMGPI.110='GPISETBACKCOLOR'
oordinals.PMGPI.111='GPIQUERYBACKCOLOR'
oordinals.PMGPI.112='GPISETMIX'
oordinals.PMGPI.113='GPIQUERYMIX'
oordinals.PMGPI.114='GPISETBACKMIX'
oordinals.PMGPI.115='GPIQUERYBACKMIX'
oordinals.PMGPI.116='GPISETLINETYPE'
oordinals.PMGPI.117='GPIQUERYLINETYPE'
oordinals.PMGPI.118='GPISETLINEWIDTH'
oordinals.PMGPI.119='GPIQUERYLINEWIDTH'
oordinals.PMGPI.120='GPISETLINEWIDTHGEOM'
oordinals.PMGPI.121='GPIQUERYLINEWIDTHGEOM'
oordinals.PMGPI.122='GPISETLINEEND'
oordinals.PMGPI.123='GPIQUERYLINEEND'
oordinals.PMGPI.124='GPISETLINEJOIN'
oordinals.PMGPI.125='GPIQUERYLINEJOIN'
oordinals.PMGPI.126='GPISETCURRENTPOSITION'
oordinals.PMGPI.127='GPIQUERYCURRENTPOSITION'
oordinals.PMGPI.128='GPIMOVE'
oordinals.PMGPI.129='GPILINE'
oordinals.PMGPI.130='GPIPOLYLINE'
oordinals.PMGPI.131='GPIBOX'
oordinals.PMGPI.132='GPIPTVISIBLE'
oordinals.PMGPI.133='GPIRECTVISIBLE'
oordinals.PMGPI.134='GPISETARCPARAMS'
oordinals.PMGPI.135='GPIQUERYARCPARAMS'
oordinals.PMGPI.136='GPIPOINTARC'
oordinals.PMGPI.137='GPIFULLARC'
oordinals.PMGPI.138='GPIPARTIALARC'
oordinals.PMGPI.139='GPIPOLYFILLET'
oordinals.PMGPI.140='GPIPOLYFILLETSHARP'
oordinals.PMGPI.141='GPIPOLYSPLINE'
oordinals.PMGPI.142='GPISETBITMAPID'
oordinals.PMGPI.143='GPIQUERYBITMAPHANDLE'
oordinals.PMGPI.144='GPISETPATTERNSET'
oordinals.PMGPI.145='GPIQUERYPATTERNSET'
oordinals.PMGPI.146='GPISETPATTERN'
oordinals.PMGPI.147='GPIQUERYPATTERN'
oordinals.PMGPI.148='GPISETPATTERNREFPOINT'
oordinals.PMGPI.149='GPIQUERYPATTERNREFPOINT'
oordinals.PMGPI.150='GPIBEGINAREA'
oordinals.PMGPI.151='GPIENDAREA'
oordinals.PMGPI.152='GPILOADFONTS'
oordinals.PMGPI.153='GPIUNLOADFONTS'
oordinals.PMGPI.154='GPICREATELOGFONT'
oordinals.PMGPI.155='GPIDELETESETID'
oordinals.PMGPI.156='GPIQUERYNUMBERSETIDS'
oordinals.PMGPI.157='GPIQUERYSETIDS'
oordinals.PMGPI.158='GPIQUERYFONTS'
oordinals.PMGPI.159='GPIQUERYFONTMETRICS'
oordinals.PMGPI.160='GPIQUERYKERNINGPAIRS'
oordinals.PMGPI.161='GPIQUERYWIDTHTABLE'
oordinals.PMGPI.162='GPISETCP'
oordinals.PMGPI.163='GPIQUERYCP'
oordinals.PMGPI.164='GPIQUERYTEXTBOX'
oordinals.PMGPI.165='DEVQUERYDEVICENAMES'
oordinals.PMGPI.166='GPIQUERYDEFCHARBOX'
oordinals.PMGPI.167='GPIQUERYFONTFILEDESCRIPTIONS'
oordinals.PMGPI.168='GPISETCHARSET'
oordinals.PMGPI.169='GPIQUERYCHARSET'
oordinals.PMGPI.170='GPISETCHARBOX'
oordinals.PMGPI.171='GPIQUERYCHARBOX'
oordinals.PMGPI.172='GPISETCHARANGLE'
oordinals.PMGPI.173='GPIQUERYCHARANGLE'
oordinals.PMGPI.174='GPISETCHARSHEAR'
oordinals.PMGPI.175='GPIQUERYCHARSHEAR'
oordinals.PMGPI.176='GPISETCHARDIRECTION'
oordinals.PMGPI.177='GPIQUERYCHARDIRECTION'
oordinals.PMGPI.178='GPISETCHARMODE'
oordinals.PMGPI.179='GPIQUERYCHARMODE'
oordinals.PMGPI.180='GPICHARSTRING'
oordinals.PMGPI.181='GPICHARSTRINGAT'
oordinals.PMGPI.182='GPICHARSTRINGPOS'
oordinals.PMGPI.183='GPICHARSTRINGPOSAT'
oordinals.PMGPI.184='GPISETMARKERSET'
oordinals.PMGPI.185='GPIQUERYMARKERSET'
oordinals.PMGPI.186='GPISETMARKER'
oordinals.PMGPI.187='GPIQUERYMARKER'
oordinals.PMGPI.188='GPISETMARKERBOX'
oordinals.PMGPI.189='GPIQUERYMARKERBOX'
oordinals.PMGPI.190='GPIMARKER'
oordinals.PMGPI.191='GPIPOLYMARKER'
oordinals.PMGPI.192='GPIIMAGE'
oordinals.PMGPI.196='GPICREATEBITMAP'
oordinals.PMGPI.197='GPIDELETEBITMAP'
oordinals.PMGPI.198='GPISETBITMAP'
oordinals.PMGPI.199='GPISETBITMAPDIMENSION'
oordinals.PMGPI.200='GPIQUERYBITMAPDIMENSION'
oordinals.PMGPI.201='GPIQUERYDEVICEBITMAPFORMATS'
oordinals.PMGPI.202='GPIQUERYBITMAPPARAMETERS'
oordinals.PMGPI.203='GPISETBITMAPBITS'
oordinals.PMGPI.204='GPIQUERYBITMAPBITS'
oordinals.PMGPI.205='GPIBITBLT'
oordinals.PMGPI.206='GPISETPEL'
oordinals.PMGPI.207='GPIQUERYPEL'
oordinals.PMGPI.208='GPICREATEREGION'
oordinals.PMGPI.209='GPISETREGION'
oordinals.PMGPI.210='GPIDESTROYREGION'
oordinals.PMGPI.211='GPICOMBINEREGION'
oordinals.PMGPI.212='GPIEQUALREGION'
oordinals.PMGPI.213='GPIOFFSETREGION'
oordinals.PMGPI.214='GPIPTINREGION'
oordinals.PMGPI.215='GPIRECTINREGION'
oordinals.PMGPI.216='GPIQUERYREGIONBOX'
oordinals.PMGPI.217='GPIQUERYREGIONRECTS'
oordinals.PMGPI.218='GPISETCLIPREGION'
oordinals.PMGPI.219='GPIQUERYCLIPREGION'
oordinals.PMGPI.220='GPIQUERYCLIPBOX'
oordinals.PMGPI.221='GPIINTERSECTCLIPRECTANGLE'
oordinals.PMGPI.222='GPIEXCLUDECLIPRECTANGLE'
oordinals.PMGPI.223='GPIOFFSETCLIPREGION'
oordinals.PMGPI.224='GPIPAINTREGION'
oordinals.PMGPI.225='GPILOADMETAFILE'
oordinals.PMGPI.226='GPICOPYMETAFILE'
oordinals.PMGPI.227='GPIPLAYMETAFILE'
oordinals.PMGPI.228='GPISAVEMETAFILE'
oordinals.PMGPI.229='GPIDELETEMETAFILE'
oordinals.PMGPI.230='GPIQUERYMETAFILEBITS'
oordinals.PMGPI.231='GPISETMETAFILEBITS'
oordinals.PMGPI.232='GPIQUERYMETAFILELENGTH'
oordinals.PMGPI.233='GPISETCLIPPATH'
oordinals.PMGPI.234='GPIBEGINPATH'
oordinals.PMGPI.235='GPIENDPATH'
oordinals.PMGPI.236='GPICLOSEFIGURE'
oordinals.PMGPI.237='GPIMODIFYPATH'
oordinals.PMGPI.238='GPIFILLPATH'
oordinals.PMGPI.239='GPISTARTREQUEST'
oordinals.PMGPI.240='GPIQUERYDEVICE'
oordinals.PMGPI.241='GPIVECTORSYMBOL'
oordinals.PMGPI.242='GPIOPENMETAFILE'
oordinals.PMGPI.243='GPICLOSEMETAFILE'
oordinals.PMGPI.244='DEVSTDOPEN'
oordinals.PMGPI.245='GPIQUERYCHARSTRINGPOS'
oordinals.PMGPI.246='GPIQUERYCHARSTRINGPOSAT'
oordinals.PMGPI.247='GPICONVPSH'
oordinals.PMGPI.248='GPISETPS'
oordinals.PMGPI.249='SEGSGWOPENSEGMENTWINDOW'
oordinals.PMGPI.250='MTENDREADREQUEST'
oordinals.PMGPI.251='MTGETDESCRIPTION'
oordinals.PMGPI.252='FMTORDERTABLE'
oordinals.PMGPI.253='MTGETCODEPAGE'
oordinals.PMGPI.254='MTGETLCT'
oordinals.PMGPI.255='MTGETGDDINFO'
oordinals.PMGPI.256='FMTCONVERTGOCAPOLY'
oordinals.PMGPI.257='MTGETFIRSTFONT'
oordinals.PMGPI.258='SEGSGWNEWPARTDATA'
oordinals.PMGPI.259='MTSTARTREADREQUEST'
oordinals.PMGPI.260='MTGETFIRSTGRAPHICSDATA'
oordinals.PMGPI.261='MTGETNEXTFONT'
oordinals.PMGPI.262='MTGETNEXTGRAPHICSDATA'
oordinals.PMGPI.263='GPILOADPUBLICFONTS'
oordinals.PMGPI.264='GPIUNLOADPUBLICFONTS'
oordinals.PMGPI.265='GPIACCESSMETAFILE'
oordinals.PMGPI.266='GPIMTASSOCIATE'
oordinals.PMGPI.267='GPIMTDISASSOCIATE'
oordinals.PMGPI.268='GPICOMMENT'
oordinals.PMGPI.269='GPIWCBITBLT'
oordinals.PMGPI.270='GPISTROKEPATH'
oordinals.PMGPI.271='SEGSGWNEXTORDERF'
oordinals.PMGPI.272='GPISUSPENDPLAY'
oordinals.PMGPI.273='GPIRESUMEPLAY'
oordinals.PMGPI.274='GPIOUTLINEPATH'
oordinals.PMGPI.275='GPISETDEFTAG'
oordinals.PMGPI.276='GPIQUERYDEFTAG'
oordinals.PMGPI.277='GPISETDEFATTRS'
oordinals.PMGPI.278='GPIQUERYDEFATTRS'
oordinals.PMGPI.279='GPISETDEFVIEWINGLIMITS'
oordinals.PMGPI.280='GPIQUERYDEFVIEWINGLIMITS'
oordinals.PMGPI.281='GPISETDEFARCPARAMS'
oordinals.PMGPI.282='GPIQUERYDEFARCPARAMS'
oordinals.PMGPI.283='GPITRANSLATE'
oordinals.PMGPI.284='GPISCALE'
oordinals.PMGPI.285='GPIROTATE'
oordinals.PMGPI.286='GPIPOLYLINEDISJOINT'
oordinals.PMGPI.287='GPIPATHTOREGION'
oordinals.PMGPI.289='GPIFLOODFILL'
oordinals.PMGPI.290='GPIDRAWBITS'
oordinals.PMGPI.291='GPIQUERYBITMAPINFOHEADER'
oordinals.PMGPI.292='GPIQUERYLOGICALFONT'
oordinals.PMGPI.293='GPIQUERYFACESTRING'
oordinals.PMGPI.294='GPIQUERYFONTACTION'
oordinals.PMGPI.295='GPICREATEPALETTE'
oordinals.PMGPI.296='GPIDELETEPALETTE'
oordinals.PMGPI.297='GPISELECTPALETTE'
oordinals.PMGPI.298='GPIANIMATEPALETTE'
oordinals.PMGPI.299='GPISETPALETTEENTRIES'
oordinals.PMGPI.300='GPIQUERYPALETTE'
oordinals.PMGPI.301='GPIQUERYPALETTEINFO'
oordinals.PMGPI.302='GPIQUERYCHAREXTRA'
oordinals.PMGPI.303='GPISETCHAREXTRA'
oordinals.PMGPI.304='GPIQUERYCHARBREAKEXTRA'
oordinals.PMGPI.305='GPISETCHARBREAKEXTRA'
oordinals.PMGPI.306='GPIFRAMEREGION'
oordinals.PMGPI.307='GPICONVERTWITHMATRIX'
oordinals.PMGPI.308='GPISETDCOWNER'
oordinals.PMGPI.309='GPISETBITMAPOWNER'
oordinals.PMGPI.310='GPISETREGIONOWNER'
oordinals.PMGPI.311='GPIINSTALLIFIFONT'
oordinals.PMGPI.312='DSPINITSYSTEMDRIVERNAME'
oordinals.PMGPI.351='GPI32ASSOCIATE'
oordinals.PMGPI.352='GPI32BEGINAREA'
oordinals.PMGPI.353='GPI32BEGINELEMENT'
oordinals.PMGPI.354='GPI32BEGINPATH'
oordinals.PMGPI.355='GPI32BITBLT'
oordinals.PMGPI.356='GPI32BOX'
oordinals.PMGPI.357='GPI32CALLSEGMENTMATRIX'
oordinals.PMGPI.358='GPI32CHARSTRING'
oordinals.PMGPI.359='GPI32CHARSTRINGAT'
oordinals.PMGPI.360='GPI32CLOSEFIGURE'
oordinals.PMGPI.361='GPI32CLOSESEGMENT'
oordinals.PMGPI.362='GPI32COMBINEREGION'
oordinals.PMGPI.363='GPI32COMMENT'
oordinals.PMGPI.364='GPI32CONVERT'
oordinals.PMGPI.365='GPI32COPYMETAFILE'
oordinals.PMGPI.366='GPI32CORRELATECHAIN'
oordinals.PMGPI.367='GPI32CORRELATEFROM'
oordinals.PMGPI.368='GPI32CREATELOGFONT'
oordinals.PMGPI.369='GPI32CREATEPS'
oordinals.PMGPI.370='GPI32CREATEREGION'
oordinals.PMGPI.371='GPI32DELETEBITMAP'
oordinals.PMGPI.372='GPI32DELETEELEMENT'
oordinals.PMGPI.373='GPI32DELETEELEMENTRANGE'
oordinals.PMGPI.374='GPI32DELETEELEMENTSBETWEENLABE'
oordinals.PMGPI.375='GPI32DELETEMETAFILE'
oordinals.PMGPI.376='GPI32DELETESEGMENT'
oordinals.PMGPI.377='GPI32DELETESEGMENTS'
oordinals.PMGPI.378='GPI32DELETESETID'
oordinals.PMGPI.379='GPI32DESTROYPS'
oordinals.PMGPI.380='GPI32DRAWCHAIN'
oordinals.PMGPI.381='GPI32DRAWDYNAMICS'
oordinals.PMGPI.382='GPI32DRAWFROM'
oordinals.PMGPI.383='GPI32DRAWSEGMENT'
oordinals.PMGPI.384='GPI32ELEMENT'
oordinals.PMGPI.385='GPI32ENDAREA'
oordinals.PMGPI.386='GPI32ENDELEMENT'
oordinals.PMGPI.387='GPI32ENDPATH'
oordinals.PMGPI.388='GPI32EQUALREGION'
oordinals.PMGPI.389='GPI32ERASE'
oordinals.PMGPI.390='GPI32ERRORSEGMENTDATA'
oordinals.PMGPI.391='GPI32EXCLUDECLIPRECTANGLE'
oordinals.PMGPI.392='GPI32FILLPATH'
oordinals.PMGPI.393='GPI32FULLARC'
oordinals.PMGPI.394='GPI32GETDATA'
oordinals.PMGPI.395='GPI32IMAGE'
oordinals.PMGPI.396='GPI32INTERSECTCLIPRECTANGLE'
oordinals.PMGPI.397='GPI32LABEL'
oordinals.PMGPI.398='GPI32LINE'
oordinals.PMGPI.399='GPI32LOADBITMAP'
oordinals.PMGPI.400='GPI32LOADFONTS'
oordinals.PMGPI.401='GPI32LOADMETAFILE'
oordinals.PMGPI.402='GPI32MARKER'
oordinals.PMGPI.403='GPI32MODIFYPATH'
oordinals.PMGPI.404='GPI32MOVE'
oordinals.PMGPI.405='GPI32OFFSETCLIPREGION'
oordinals.PMGPI.406='GPI32OFFSETELEMENTPOINTER'
oordinals.PMGPI.407='GPI32OFFSETREGION'
oordinals.PMGPI.408='GPI32OPENSEGMENT'
oordinals.PMGPI.409='GPI32PAINTREGION'
oordinals.PMGPI.411='GPI32PLAYMETAFILE'
oordinals.PMGPI.412='GPI32POINTARC'
oordinals.PMGPI.413='GPI32POLYFILLET'
oordinals.PMGPI.414='GPI32POLYFILLETSHARP'
oordinals.PMGPI.415='GPI32POLYLINE'
oordinals.PMGPI.416='GPI32POLYMARKER'
oordinals.PMGPI.417='GPI32POLYSPLINE'
oordinals.PMGPI.418='GPI32POP'
oordinals.PMGPI.419='GPI32PTINREGION'
oordinals.PMGPI.420='GPI32PTVISIBLE'
oordinals.PMGPI.421='GPI32PUTDATA'
oordinals.PMGPI.422='GPI32QUERYARCPARAMS'
oordinals.PMGPI.423='GPI32QUERYATTRMODE'
oordinals.PMGPI.424='GPI32QUERYBACKCOLOR'
oordinals.PMGPI.425='GPI32QUERYBACKMIX'
oordinals.PMGPI.426='GPI32QUERYBITMAPDIMENSION'
oordinals.PMGPI.427='GPI32QUERYBITMAPHANDLE'
oordinals.PMGPI.428='GPI32QUERYBOUNDARYDATA'
oordinals.PMGPI.429='GPI32QUERYCHARANGLE'
oordinals.PMGPI.430='GPI32QUERYCHARBOX'
oordinals.PMGPI.431='GPI32QUERYCHARDIRECTION'
oordinals.PMGPI.432='GPI32QUERYCHARMODE'
oordinals.PMGPI.433='GPI32QUERYCHARSET'
oordinals.PMGPI.434='GPI32QUERYCHARSHEAR'
oordinals.PMGPI.435='GPI32QUERYCLIPBOX'
oordinals.PMGPI.436='GPI32QUERYCLIPREGION'
oordinals.PMGPI.437='GPI32QUERYCOLOR'
oordinals.PMGPI.438='GPI32QUERYCOLORDATA'
oordinals.PMGPI.439='GPI32QUERYCOLORINDEX'
oordinals.PMGPI.440='GPI32QUERYCP'
oordinals.PMGPI.441='GPI32QUERYCURRENTPOSITION'
oordinals.PMGPI.442='GPI32QUERYDEFCHARBOX'
oordinals.PMGPI.443='GPI32QUERYDEFAULTVIEWMATRIX'
oordinals.PMGPI.444='GPI32QUERYDEVICE'
oordinals.PMGPI.445='GPI32QUERYDEVICEBITMAPFORMATS'
oordinals.PMGPI.446='GPI32QUERYDRAWCONTROL'
oordinals.PMGPI.447='GPI32QUERYDRAWINGMODE'
oordinals.PMGPI.448='GPI32QUERYEDITMODE'
oordinals.PMGPI.449='GPI32QUERYELEMENT'
oordinals.PMGPI.450='GPI32QUERYELEMENTPOINTER'
oordinals.PMGPI.451='GPI32QUERYELEMENTTYPE'
oordinals.PMGPI.452='GPI32QUERYFONTFILEDESCRIPTIONS'
oordinals.PMGPI.453='GPI32QUERYFONTMETRICS'
oordinals.PMGPI.454='GPI32QUERYGRAPHICSFIELD'
oordinals.PMGPI.455='GPI32QUERYINITIALSEGMENTATTRS'
oordinals.PMGPI.456='GPI32QUERYKERNINGPAIRS'
oordinals.PMGPI.457='GPI32QUERYLINEEND'
oordinals.PMGPI.458='GPI32QUERYLINEJOIN'
oordinals.PMGPI.459='GPI32QUERYLINETYPE'
oordinals.PMGPI.460='GPI32QUERYLINEWIDTH'
oordinals.PMGPI.461='GPI32QUERYLINEWIDTHGEOM'
oordinals.PMGPI.462='GPI32QUERYMARKER'
oordinals.PMGPI.463='GPI32QUERYMARKERBOX'
oordinals.PMGPI.464='GPI32QUERYMARKERSET'
oordinals.PMGPI.465='GPI32QUERYMETAFILEBITS'
oordinals.PMGPI.466='GPI32QUERYMETAFILELENGTH'
oordinals.PMGPI.467='GPI32QUERYMIX'
oordinals.PMGPI.468='GPI32QUERYMODELTRANSFORMMATRIX'
oordinals.PMGPI.469='GPI32QUERYNEARESTCOLOR'
oordinals.PMGPI.470='GPI32QUERYNUMBERSETIDS'
oordinals.PMGPI.471='GPI32QUERYPS'
oordinals.PMGPI.472='GPI32QUERYPAGEVIEWPORT'
oordinals.PMGPI.473='GPI32QUERYPATTERN'
oordinals.PMGPI.474='GPI32QUERYPATTERNREFPOINT'
oordinals.PMGPI.475='GPI32QUERYPATTERNSET'
oordinals.PMGPI.476='GPI32QUERYPEL'
oordinals.PMGPI.477='GPI32QUERYPICKAPERTUREPOSITION'
oordinals.PMGPI.478='GPI32QUERYPICKAPERTURESIZE'
oordinals.PMGPI.479='GPI32QUERYRGBCOLOR'
oordinals.PMGPI.480='GPI32QUERYREALCOLORS'
oordinals.PMGPI.481='GPI32QUERYREGIONBOX'
oordinals.PMGPI.482='GPI32QUERYSEGMENTATTRS'
oordinals.PMGPI.483='GPI32QUERYSEGMENTNAMES'
oordinals.PMGPI.484='GPI32QUERYSEGMENTPRIORITY'
oordinals.PMGPI.485='GPI32QUERYSEGMENTTRANSFORMMATR'
oordinals.PMGPI.486='GPI32QUERYSETIDS'
oordinals.PMGPI.487='GPI32QUERYSTOPDRAW'
oordinals.PMGPI.488='GPI32QUERYTAG'
oordinals.PMGPI.489='GPI32QUERYTEXTBOX'
oordinals.PMGPI.490='GPI32QUERYVIEWINGLIMITS'
oordinals.PMGPI.491='GPI32QUERYVIEWINGTRANSFORMMATR'
oordinals.PMGPI.492='GPI32QUERYWIDTHTABLE'
oordinals.PMGPI.494='GPI32RECTINREGION'
oordinals.PMGPI.495='GPI32RECTVISIBLE'
oordinals.PMGPI.496='GPI32REMOVEDYNAMICS'
oordinals.PMGPI.497='GPI32RESETBOUNDARYDATA'
oordinals.PMGPI.498='GPI32RESETPS'
oordinals.PMGPI.499='GPI32RESTOREPS'
oordinals.PMGPI.500='GPI32SAVEMETAFILE'
oordinals.PMGPI.501='GPI32SAVEPS'
oordinals.PMGPI.502='GPI32SETARCPARAMS'
oordinals.PMGPI.503='GPI32SETATTRMODE'
oordinals.PMGPI.504='GPI32SETBACKCOLOR'
oordinals.PMGPI.505='GPI32SETBACKMIX'
oordinals.PMGPI.506='GPI32SETBITMAP'
oordinals.PMGPI.507='GPI32SETBITMAPDIMENSION'
oordinals.PMGPI.508='GPI32SETBITMAPID'
oordinals.PMGPI.509='GPI32SETCHARANGLE'
oordinals.PMGPI.510='GPI32SETCHARBOX'
oordinals.PMGPI.511='GPI32SETCHARDIRECTION'
oordinals.PMGPI.512='GPI32SETCHARMODE'
oordinals.PMGPI.513='GPI32SETCHARSET'
oordinals.PMGPI.514='GPI32SETCHARSHEAR'
oordinals.PMGPI.515='GPI32SETCLIPPATH'
oordinals.PMGPI.516='GPI32SETCLIPREGION'
oordinals.PMGPI.517='GPI32SETCOLOR'
oordinals.PMGPI.518='GPI32SETCP'
oordinals.PMGPI.519='GPI32SETCURRENTPOSITION'
oordinals.PMGPI.520='GPI32SETDEFAULTVIEWMATRIX'
oordinals.PMGPI.521='GPI32SETDRAWCONTROL'
oordinals.PMGPI.522='GPI32SETDRAWINGMODE'
oordinals.PMGPI.523='GPI32SETEDITMODE'
oordinals.PMGPI.524='GPI32SETELEMENTPOINTER'
oordinals.PMGPI.525='GPI32SETELEMENTPOINTERATLABEL'
oordinals.PMGPI.526='GPI32SETGRAPHICSFIELD'
oordinals.PMGPI.527='GPI32SETINITIALSEGMENTATTRS'
oordinals.PMGPI.528='GPI32SETLINEEND'
oordinals.PMGPI.529='GPI32SETLINEJOIN'
oordinals.PMGPI.530='GPI32SETLINETYPE'
oordinals.PMGPI.531='GPI32SETLINEWIDTH'
oordinals.PMGPI.532='GPI32SETLINEWIDTHGEOM'
oordinals.PMGPI.533='GPI32SETMARKER'
oordinals.PMGPI.534='GPI32SETMARKERBOX'
oordinals.PMGPI.535='GPI32SETMARKERSET'
oordinals.PMGPI.536='GPI32SETMETAFILEBITS'
oordinals.PMGPI.537='GPI32SETMIX'
oordinals.PMGPI.538='GPI32SETMODELTRANSFORMMATRIX'
oordinals.PMGPI.539='GPI32SETPS'
oordinals.PMGPI.540='GPI32SETPAGEVIEWPORT'
oordinals.PMGPI.541='GPI32SETPATTERN'
oordinals.PMGPI.542='GPI32SETPATTERNREFPOINT'
oordinals.PMGPI.543='GPI32SETPATTERNSET'
oordinals.PMGPI.544='GPI32SETPEL'
oordinals.PMGPI.545='GPI32SETPICKAPERTUREPOSITION'
oordinals.PMGPI.546='GPI32SETREGION'
oordinals.PMGPI.547='GPI32SETSEGMENTATTRS'
oordinals.PMGPI.548='GPI32SETSEGMENTPRIORITY'
oordinals.PMGPI.549='GPI32SETSEGMENTTRANSFORMMATRIX'
oordinals.PMGPI.550='GPI32SETSTOPDRAW'
oordinals.PMGPI.551='GPI32SETTAG'
oordinals.PMGPI.552='GPI32SETVIEWINGLIMITS'
oordinals.PMGPI.553='GPI32SETVIEWINGTRANSFORMMATRIX'
oordinals.PMGPI.554='GPI32STROKEPATH'
oordinals.PMGPI.555='GPI32UNLOADFONTS'
oordinals.PMGPI.557='GPI32WCBITBLT'
oordinals.PMGPI.558='GPI32POLYLINEDISJOINT'
oordinals.PMGPI.559='GPI32PATHTOREGION'
oordinals.PMGPI.560='GPI32FLOODFILL'
oordinals.PMGPI.561='GPI32SUSPENDPLAY'
oordinals.PMGPI.562='GPI32RESUMEPLAY'
oordinals.PMGPI.563='GPI32OUTLINEPATH'
oordinals.PMGPI.564='GPI32TRANSLATE'
oordinals.PMGPI.565='GPI32SCALE'
oordinals.PMGPI.566='GPI32ROTATE'
oordinals.PMGPI.567='GPI32QUERYDEFARCPARAMS'
oordinals.PMGPI.568='GPI32QUERYDEFTAG'
oordinals.PMGPI.569='GPI32QUERYDEFVIEWINGLIMITS'
oordinals.PMGPI.570='GPI32SETDEFARCPARAMS'
oordinals.PMGPI.571='GPI32SETDEFTAG'
oordinals.PMGPI.572='GPI32SETDEFVIEWINGLIMITS'
oordinals.PMGPI.573='GPI32QUERYBITMAPPARAMETERS'
oordinals.PMGPI.574='GPI32QUERYLOGICALFONT'
oordinals.PMGPI.575='GPI32QUERYFACESTRING'
oordinals.PMGPI.576='GPI32QUERYFONTACTION'
oordinals.PMGPI.577='GPI32DELETEPALETTE'
oordinals.PMGPI.578='GPI32SELECTPALETTE'
oordinals.PMGPI.579='GPI32QUERYPALETTE'
oordinals.PMGPI.580='GPI32CHARSTRINGPOS'
oordinals.PMGPI.581='GPI32CHARSTRINGPOSAT'
oordinals.PMGPI.582='GPI32CORRELATESEGMENT'
oordinals.PMGPI.583='GPI32QUERYATTRS'
oordinals.PMGPI.584='GPI32QUERYCHARSTRINGPOS'
oordinals.PMGPI.585='GPI32QUERYCHARSTRINGPOSAT'
oordinals.PMGPI.586='GPI32QUERYFONTS'
oordinals.PMGPI.587='GPI32QUERYREGIONRECTS'
oordinals.PMGPI.588='GPI32SETATTRS'
oordinals.PMGPI.589='GPI32SETPICKAPERTURESIZE'
oordinals.PMGPI.590='GPI32QUERYDEFATTRS'
oordinals.PMGPI.591='GPI32SETDEFATTRS'
oordinals.PMGPI.592='GPI32CREATELOGCOLORTABLE'
oordinals.PMGPI.593='GPI32QUERYLOGCOLORTABLE'
oordinals.PMGPI.594='GPI32CREATEPALETTE'
oordinals.PMGPI.595='GPI32ANIMATEPALETTE'
oordinals.PMGPI.596='GPI32SETPALETTEENTRIES'
oordinals.PMGPI.597='GPI32QUERYPALETTEINFO'
oordinals.PMGPI.598='GPI32CREATEBITMAP'
oordinals.PMGPI.599='GPI32QUERYBITMAPBITS'
oordinals.PMGPI.601='GPI32QUERYBITMAPINFOHEADER'
oordinals.PMGPI.602='GPI32SETBITMAPBITS'
oordinals.PMGPI.603='GPI32DRAWBITS'
oordinals.PMGPI.604='DEV32CLOSEDC'
oordinals.PMGPI.605='DEV32ESCAPE'
oordinals.PMGPI.606='DEV32QUERYCAPS'
oordinals.PMGPI.607='DEV32QUERYDEVICENAMES'
oordinals.PMGPI.608='DEV32QUERYHARDCOPYCAPS'
oordinals.PMGPI.609='DEV32POSTDEVICEMODES'
oordinals.PMGPI.610='DEV32OPENDC'
oordinals.PMGPI.611='GPI32DESTROYREGION'
oordinals.PMGPI.612='GPI32PARTIALARC'
oordinals.PMGPI.613='GPI32QUERYCHAREXTRA'
oordinals.PMGPI.614='GPI32SETCHAREXTRA'
oordinals.PMGPI.615='GPI32QUERYCHARBREAKEXTRA'
oordinals.PMGPI.616='GPI32SETCHARBREAKEXTRA'
oordinals.PMGPI.617='GPI32FRAMEREGION'
oordinals.PMGPI.618='GPI32CONVERTWITHMATRIX'
oordinals.PMGPI.619='GPI32SETDCOWNER'
oordinals.PMGPI.620='GPI32SETBITMAPOWNER'
oordinals.PMGPI.621='GPI32SETREGIONOWNER'
oordinals.PMGPI.622='GPI32LOADPUBLICFONTS'
oordinals.PMGPI.623='GPI32UNLOADPUBLICFONTS'
oordinals.PMGPI.624='GPI32INSTALLIFIFONT'
oordinals.PMGPI.625='DEV32STDOPEN'
oordinals.PMGPI.627='GPI32OPENMETAFILE'
oordinals.PMGPI.628='GPI32CLOSEMETAFILE'
oordinals.PMGPI.629='GPI32CONVPSH'
oordinals.PMGPI.644='GPI32MTASSOCIATE'
oordinals.PMGPI.645='GPI32MTDISASSOCIATE'
oordinals.PMGPI.648='GPI32QUERYTEXTALIGNMENT'
oordinals.PMGPI.649='GPI32SETTEXTALIGNMENT'
oordinals.PMGPI.650='GPI32POLYGONS'
oordinals.PMGPI.654='DSP32DEFAULTRESOLUTION'
oordinals.PMGPI.655='DEV32QUERYDISPLAYRESOLUTIONS'
oordinals.PMGPI.656='DSP32INITSYSTEMDRIVERNAME'
oordinals.PMGPI.657='GPI32QUERYFULLFONTFILEDESCS'
oordinals.OS2CHAR.1='SMGETMEM'
oordinals.OS2CHAR.2='SMFREEMEM'
oordinals.OS2CHAR.3='SMGETSGCB'
oordinals.OS2CHAR.4='SMINITSGCB'
oordinals.OS2CHAR.5='SMQUEUERAMSEM'
oordinals.OS2CHAR.6='SMARRAY'
oordinals.OS2CHAR.7='SMPIDARRAY'
oordinals.OS2CHAR.99='SMINITIALIZED'
oordinals.OS2CHAR.8='SMARRAYSIZE'
oordinals.OS2CHAR.9='SMGINSTANCE'
oordinals.OS2CHAR.148='BVHINSTANCE'
oordinals.OS2CHAR.149='BVSGLOBAL'
oordinals.OS2CHAR.152='OS2BASEINIT'
oordinals.NAMPIPES.1='DOSMAKENMPIPE'
oordinals.NAMPIPES.2='DOSQNMPIPEINFO'
oordinals.NAMPIPES.3='DOSCONNECTNMPIPE'
oordinals.NAMPIPES.4='DOSDISCONNECTNMPIPE'
oordinals.NAMPIPES.5='DOSQNMPHANDSTATE'
oordinals.NAMPIPES.6='DOSSETNMPHANDSTATE'
oordinals.NAMPIPES.7='DOSPEEKNMPIPE'
oordinals.NAMPIPES.8='DOSWAITNMPIPE'
oordinals.NAMPIPES.9='DOSTRANSACTNMPIPE'
oordinals.NAMPIPES.10='DOSCALLNMPIPE'
oordinals.NAMPIPES.11='DOSRAWREADNMPIPE'
oordinals.NAMPIPES.12='DOSRAWWRITENMPIPE'
oordinals.NAMPIPES.13='DOSSETNMPIPESEM'
oordinals.NAMPIPES.14='DOSQNMPIPESEMSTATE'
oordinals.MOUCALLS.1='MOUGETPTRSHAPE'
oordinals.MOUCALLS.2='MOUSETPTRSHAPE'
oordinals.MOUCALLS.3='MOUGETNUMMICKEYS'
oordinals.MOUCALLS.4='MOUGETHOTKEY'
oordinals.MOUCALLS.5='MOUSHELLINIT'
oordinals.MOUCALLS.6='MOUGETSCALEFACT'
oordinals.MOUCALLS.7='MOUFLUSHQUE'
oordinals.MOUCALLS.8='MOUGETNUMBUTTONS'
oordinals.MOUCALLS.9='MOUCLOSE'
oordinals.MOUCALLS.10='MOUSETHOTKEY'
oordinals.MOUCALLS.11='MOUSETSCALEFACT'
oordinals.MOUCALLS.13='MOUGETNUMQUEEL'
oordinals.MOUCALLS.14='MOUDEREGISTER'
oordinals.MOUCALLS.15='MOUGETEVENTMASK'
oordinals.MOUCALLS.16='MOUSETEVENTMASK'
oordinals.MOUCALLS.17='MOUOPEN'
oordinals.MOUCALLS.18='MOUREMOVEPTR'
oordinals.MOUCALLS.19='MOUGETPTRPOS'
oordinals.MOUCALLS.20='MOUREADEVENTQUE'
oordinals.MOUCALLS.21='MOUSETPTRPOS'
oordinals.MOUCALLS.22='MOUGETDEVSTATUS'
oordinals.MOUCALLS.23='MOUSYNCH'
oordinals.MOUCALLS.24='MOUREGISTER'
oordinals.MOUCALLS.25='MOUSETDEVSTATUS'
oordinals.MOUCALLS.26='MOUDRAWPTR'
oordinals.MOUCALLS.27='MOUINITREAL'
oordinals.MOUCALLS.29='MOUGETTHRESHOLD'
oordinals.MOUCALLS.30='MOUSETTHRESHOLD'
oordinals.MONCALLS.1='DOSMONWRITE'1
oordinals.MONCALLS.2='DOSMONREAD'2
oordinals.MONCALLS.3='DOSMONCLOSE'3
oordinals.MONCALLS.4='DOSMONOPEN'4
oordinals.MONCALLS.5='DOSMONREG'5
oordinals.PMMERGE.1006='GREINITIALIZE32'
oordinals.PMMERGE.1033='INITMOVECURSOR'
oordinals.PMMERGE.2000='SHEPIINITIALISE'
oordinals.PMMERGE.2001='WINQUERYPROFILEINT'
oordinals.PMMERGE.2002='WINQUERYPROFILESTRING'
oordinals.PMMERGE.2003='WINWRITEPROFILESTRING'
oordinals.PMMERGE.2004='WINQUERYPROFILESIZE'
oordinals.PMMERGE.2005='WINQUERYPROFILEDATA'
oordinals.PMMERGE.2006='WINWRITEPROFILEDATA'
oordinals.PMMERGE.2007='PRFCHANGEWRITETHRU'
oordinals.PMMERGE.2008='PMEXECREGISTER'
oordinals.PMMERGE.2009='SHEPIINITINIFILES'
oordinals.PMMERGE.2010='SHECONVERT190PROGRAMLISTTO300'
oordinals.PMMERGE.2011='PRFQUERYPROFILEINT'
oordinals.PMMERGE.2012='PRFQUERYPROFILESTRING'
oordinals.PMMERGE.2013='PRFWRITEPROFILESTRING'
oordinals.PMMERGE.2014='PRFQUERYPROFILESIZE'
oordinals.PMMERGE.2015='PRFQUERYPROFILEDATA'
oordinals.PMMERGE.2016='PRFWRITEPROFILEDATA'
oordinals.PMMERGE.2017='PRFOPENPROFILE'
oordinals.PMMERGE.2018='PRFCLOSEPROFILE'
oordinals.PMMERGE.2019='PRFRESET'
oordinals.PMMERGE.2020='PRFQUERYPROFILE'
oordinals.PMMERGE.2021='PRFADDPROGRAM'
oordinals.PMMERGE.2022='PRFREMOVEPROGRAM'
oordinals.PMMERGE.2023='PRFCHANGEPROGRAM'
oordinals.PMMERGE.2024='PRFQUERYDEFINITION'
oordinals.PMMERGE.2025='PRFQUERYPROGRAMTITLES'
oordinals.PMMERGE.2026='PRFCREATEGROUP'
oordinals.PMMERGE.2027='PRFQUERYPROGRAMHANDLE'
oordinals.PMMERGE.2028='PRFQUERYPROGRAMCATEGORY'
oordinals.PMMERGE.2029='PRFDESTROYGROUP'
oordinals.PMMERGE.2030='SHEPROFILEHOOK'
oordinals.PMMERGE.2031='SHEINITIALIZEINIFILE'
oordinals.PMMERGE.2032='SHPPI16LOCKINIFILE'
oordinals.PMMERGE.2033='SHPPI16SHUTDOWN'
oordinals.PMMERGE.2035='INNERGREENTRY'
oordinals.PMMERGE.2036='GREINITIALIZE'
oordinals.PMMERGE.2037='GREENTRY2'
oordinals.PMMERGE.2038='GREENTRY3'
oordinals.PMMERGE.2039='GREENTRY4'
oordinals.PMMERGE.2040='GREENTRY5'
oordinals.PMMERGE.2041='GREENTRY6'
oordinals.PMMERGE.2042='GREENTRY7'
oordinals.PMMERGE.2043='GREENTRY8'
oordinals.PMMERGE.2044='GREENTRY9'
oordinals.PMMERGE.2045='GREENTRY10'
oordinals.PMMERGE.2046='GETDRIVERINFO'
oordinals.PMMERGE.2046='GETDRIVERINFOTH'
oordinals.PMMERGE.2047='SETDRIVERINFO'
oordinals.PMMERGE.2047='SETDRIVERINFOTH'
oordinals.PMMERGE.2048='POSTDEVICEMODES'
oordinals.PMMERGE.2049='BITMAPLIMITWARNING'
oordinals.PMMERGE.2050='PMWINGREENTRY2'
oordinals.PMMERGE.2051='PMWINGREENTRY3'
oordinals.PMMERGE.2052='PMWINGREENTRY4'
oordinals.PMMERGE.2053='PMWINGREENTRY5'
oordinals.PMMERGE.2054='PMWINGREENTRY6'
oordinals.PMMERGE.2055='PMWINGREENTRY7'
oordinals.PMMERGE.2056='PMWINGREENTRY8'
oordinals.PMMERGE.2057='PMWINGREENTRY9'
oordinals.PMMERGE.2058='PMWINGREENTRY10'
oordinals.PMMERGE.2059='SSALLOCSEG'
oordinals.PMMERGE.2060='SSALLOCHUGE'
oordinals.PMMERGE.2061='SSFREESEG'
oordinals.PMMERGE.2062='SSFLUSHSEGS'
oordinals.PMMERGE.2063='RAMSEMREQUEST'
oordinals.PMMERGE.2064='RAMSEMCLEAR'
oordinals.PMMERGE.2065='WINQUERYCLASSINFO'
oordinals.PMMERGE.2066='WINMULTWINDOWFROMIDS'
oordinals.PMMERGE.2067='WINLOCKWINDOW'
oordinals.PMMERGE.2068='WINQUERYWINDOWLOCKCOUNT'
oordinals.PMMERGE.2069='WINLOADPOINTER'
oordinals.PMMERGE.2070='WINCREATEPOINTER'
oordinals.PMMERGE.2071='WINDESTROYPOINTER'
oordinals.PMMERGE.2072='OLDWINQUERYPOINTERINFO'
oordinals.PMMERGE.2073='WINQUERYSYSPOINTER'
oordinals.PMMERGE.2074='WINGETSYSBITMAP'
oordinals.PMMERGE.2075='WINQUERYCURSORINFO'
oordinals.PMMERGE.2076='WINLOADACCELTABLE'
oordinals.PMMERGE.2077='WINCREATEACCELTABLE'
oordinals.PMMERGE.2078='WINDESTROYACCELTABLE'
oordinals.PMMERGE.2079='WINCOPYACCELTABLE'
oordinals.PMMERGE.2080='WINSETCLIPBRDDATA'
oordinals.PMMERGE.2081='WINQUERYCLIPBRDFMTINFO'
oordinals.PMMERGE.2082='GPILOADBITMAP'
oordinals.PMMERGE.2083='WINLOADSTRING'
oordinals.PMMERGE.2084='WINLOADMESSAGE'
oordinals.PMMERGE.2085='WINSETRECTEMPTY'
oordinals.PMMERGE.2086='WINSETRECT'
oordinals.PMMERGE.2087='WINCOPYRECT'
oordinals.PMMERGE.2088='WINISRECTEMPTY'
oordinals.PMMERGE.2089='WINPTINRECT'
oordinals.PMMERGE.2090='WINOFFSETRECT'
oordinals.PMMERGE.2091='WININFLATERECT'
oordinals.PMMERGE.2092='WINMAKERECT'
oordinals.PMMERGE.2093='WINMAKEPOINTS'
oordinals.PMMERGE.2094='WINDEFWINDOWPROC'
oordinals.PMMERGE.2095='WINDEFDLGPROC'
oordinals.PMMERGE.2096='WINQUERYHUNGPROCESS'
oordinals.PMMERGE.2097='WINLOADSTRINGTABLE'
oordinals.PMMERGE.2098='WINLOADVKEYGLYPHXLATETBL'
oordinals.PMMERGE.2099='WINLOADCHARXLATETBL'
oordinals.PMMERGE.2100='WINSETVKEYGLYPHXLATETBL'
oordinals.PMMERGE.2101='WINQUERYVKEYGLYPHXLATETBL'
oordinals.PMMERGE.2102='WINVKEYTOSCANID'
oordinals.PMMERGE.2103='WINQUERYPROCESSCP'
oordinals.PMMERGE.2104='WINGETKEYSTATE'
oordinals.PMMERGE.2105='WINSETCP'
oordinals.PMMERGE.2106='WINQUERYCP'
oordinals.PMMERGE.2107='WINQUERYCPLIST'
oordinals.PMMERGE.2108='WINCPTRANSLATESTRING'
oordinals.PMMERGE.2109='WINCPTRANSLATECHAR'
oordinals.PMMERGE.2110='WINCOMPARESTRINGS'
oordinals.PMMERGE.2111='WINUPPER'
oordinals.PMMERGE.2112='WINUPPERCHAR'
oordinals.PMMERGE.2113='WINNEXTCHAR'
oordinals.PMMERGE.2114='WINPREVCHAR'
oordinals.PMMERGE.2115='WINCREATEHEAP'
oordinals.PMMERGE.2116='WINDESTROYHEAP'
oordinals.PMMERGE.2117='WINAVAILMEM'
oordinals.PMMERGE.2118='WINALLOCMEM'
oordinals.PMMERGE.2119='WINREALLOCMEM'
oordinals.PMMERGE.2120='WINFREEMEM'
oordinals.PMMERGE.2121='WINLOCKHEAP'
oordinals.PMMERGE.2122='WINCREATEATOMTABLE'
oordinals.PMMERGE.2123='WINDESTROYATOMTABLE'
oordinals.PMMERGE.2124='WINADDATOM'
oordinals.PMMERGE.2125='WINFINDATOM'
oordinals.PMMERGE.2126='WINDELETEATOM'
oordinals.PMMERGE.2127='WINQUERYATOMUSAGE'
oordinals.PMMERGE.2128='WINQUERYATOMLENGTH'
oordinals.PMMERGE.2129='WINQUERYATOMNAME'
oordinals.PMMERGE.2130='WINQUERYSYSTEMATOMTABLE'
oordinals.PMMERGE.2131='WINSETLASTERROR'
oordinals.PMMERGE.2132='WINGETLASTERROR'
oordinals.PMMERGE.2133='WINGETERRORINFO'
oordinals.PMMERGE.2134='WINFREEERRORINFO'
oordinals.PMMERGE.2135='WININITIALIZE'
oordinals.PMMERGE.2136='WINTERMINATE'
oordinals.PMMERGE.2137='WINCATCH'
oordinals.PMMERGE.2138='WINTHROW'
oordinals.PMMERGE.2139='WINQUERYVERSION'
oordinals.PMMERGE.2140='FSRSEMEXIT'
oordinals.PMMERGE.2141='FSRSEMCHECK'
oordinals.PMMERGE.2142='AABGETREG'
oordinals.PMMERGE.2143='AABSETREG'
oordinals.PMMERGE.2144='VALIDATESELECTOR'
oordinals.PMMERGE.2145='LOADMODULEHANDLE'
oordinals.PMMERGE.2146='GETSCREENSELECTOR'
oordinals.PMMERGE.2147='IDENTIFYCODESELECTOR'
oordinals.PMMERGE.2148='_WINSETERRORINFO'
oordinals.PMMERGE.2149='WINTERMINATESYSTEM'
oordinals.PMMERGE.2150='WINDEFQUEUEPROC'
oordinals.PMMERGE.2151='VISREGIONCALLBACK'
oordinals.PMMERGE.2152='WINQUERYKBDLAYOUT'
oordinals.PMMERGE.2153='WINSETKBDLAYOUT'
oordinals.PMMERGE.2154='WINBUILDPTRHANDLE'
oordinals.PMMERGE.2155='DUMWINCREATEHELPINSTANCE'
oordinals.PMMERGE.2156='DUMWINDESTROYHELPINSTANCE'
oordinals.PMMERGE.2157='DUMWINASSOCIATEHELPINSTANCE'
oordinals.PMMERGE.2158='DUMWINCREATEHELPTABLE'
oordinals.PMMERGE.2159='DUMWINLOADHELPTABLE'
oordinals.PMMERGE.2160='DUMWINQUERYHELPINSTANCE'
oordinals.PMMERGE.2161='DUMMYHELPENTRY'
oordinals.PMMERGE.2162='GETPMDDCODESELECTOR'
oordinals.PMMERGE.2163='WINQUERYPWND'
oordinals.PMMERGE.2164='WINENUMVKEYSCANIDS'
oordinals.PMMERGE.2165='WINLOADTRANSLATIONTABLE'
oordinals.PMMERGE.2166='WINSETKBDLAYOUT2'
oordinals.PMMERGE.2167='DEBUGINPUTENABLE'
oordinals.PMMERGE.2168='DEBUGINPUT'
oordinals.PMMERGE.2169='DEBUGOUTPUT'
oordinals.PMMERGE.2170='DEBUGCURPOS'
oordinals.PMMERGE.2171='DEBUGCLS'
oordinals.PMMERGE.2172='DEBUGREDIRECT'
oordinals.PMMERGE.2173='WINLANGSUPWINDOWPROC'
oordinals.PMMERGE.2174='WINLANGSUPDLGPROC'
oordinals.PMMERGE.2175='WINCREATEPOINTERINDIRECT'
oordinals.PMMERGE.2176='WINQUERYPOINTERINFO'
oordinals.PMMERGE.2177='WINPORTHOLEUTIL'
oordinals.PMMERGE.2178='WINCREATEFARHEAP'
oordinals.PMMERGE.2179='WINDESTROYFARHEAP'
oordinals.PMMERGE.2180='WINALLOCFARMEM'
oordinals.PMMERGE.2181='WINFREEFARMEM'
oordinals.PMMERGE.2182='WINREALLOCFARMEM'
oordinals.PMMERGE.2183='WINSETQUEUEPROC'
oordinals.PMMERGE.2496='WINISWINDOWOVERLAPPED'
oordinals.PMMERGE.3000='FARFLUSHBUFHOOK'
oordinals.PMMERGE.3001='FNBADAPPDLGPROC'
oordinals.PMMERGE.3002='INPUTGETDEVICEINFO'
oordinals.PMMERGE.3003='LPFNICONWNDPROC'
oordinals.PMMERGE.3004='LPFNSHELLWNDPROC'
oordinals.PMMERGE.3005='SHESTARTLONGPROGRAM'
oordinals.PMMERGE.3006='SHESYSTEMSHUTDOWN'
oordinals.PMMERGE.3007='SHEUPDATEINIFILE'
oordinals.PMMERGE.3008='SHLLOADPUBLICFONTS'
oordinals.PMMERGE.3009='SHLUNLOADPUBLICFONTS'
oordinals.PMMERGE.3010='SHPLOCKPROGRAMLIST'
oordinals.PMMERGE.3011='SHPUNLOCKPROGRAMLIST'
oordinals.PMMERGE.3012='STARTSTARTUPDOTCMD'
oordinals.PMMERGE.3013='STARTSYSTEMEXECUTABLES'
oordinals.PMMERGE.3014='WINALARM'
oordinals.PMMERGE.3015='WINBEGINENUMWINDOWS'
oordinals.PMMERGE.3016='WINBEGINPAINT'
oordinals.PMMERGE.3017='WINBROADCASTMSG'
oordinals.PMMERGE.3018='WINCANCELMODE'
oordinals.PMMERGE.3019='WINCANCELSHUTDOWN'
oordinals.PMMERGE.3020='WINCREATEMSGQUEUE'
oordinals.PMMERGE.3021='WINCREATESTDWINDOW'
oordinals.PMMERGE.3022='WINCREATEWINDOW'
oordinals.PMMERGE.3023='WINDESTROYMSGQUEUE'
oordinals.PMMERGE.3024='WINDESTROYWINDOW'
oordinals.PMMERGE.3025='WINDISPATCHMSG'
oordinals.PMMERGE.3026='WINDRAWTEXT'
oordinals.PMMERGE.3027='WINENDPAINT'
oordinals.PMMERGE.3028='WINFILLRECT'
oordinals.PMMERGE.3029='WINGETMINWINDOWVIEWER'
oordinals.PMMERGE.3030='WINGETMSG'
oordinals.PMMERGE.3031='WINGETNEXTWINDOW'
oordinals.PMMERGE.3032='WININITIALIZESYSTEM'
oordinals.PMMERGE.3033='WININVALIDATERECT'
oordinals.PMMERGE.3034='WINISCHILD'
oordinals.PMMERGE.3035='WINISWINDOW'
oordinals.PMMERGE.3036='WINISWINDOWVISIBLE'
oordinals.PMMERGE.3037='WINLOADDLG'
oordinals.PMMERGE.3038='WINLOCKSTARTINPUT'
oordinals.PMMERGE.3039='WINMESSAGEBOX'
oordinals.PMMERGE.3040='WINMSGSEMWAIT'
oordinals.PMMERGE.3041='WINOPENWINDOWDC'
oordinals.PMMERGE.3042='WINPEEKMSG'
oordinals.PMMERGE.3043='WINPOSTMSG'
oordinals.PMMERGE.3044='WINPROCESSDLG'
oordinals.PMMERGE.3045='WINQUERYACTIVEWINDOW'
oordinals.PMMERGE.3046='WINQUERYANCHORBLOCK'
oordinals.PMMERGE.3047='WINQUERYDESKTOPWINDOW'
oordinals.PMMERGE.3048='WINQUERYFOCUS'
oordinals.PMMERGE.3049='WINQUERYQUEUEINFO'
oordinals.PMMERGE.3050='WINQUERYSYSMODALWINDOW'
oordinals.PMMERGE.3051='WINQUERYSYSVALUE'
oordinals.PMMERGE.3052='WINQUERYWINDOW'
oordinals.PMMERGE.3053='WINQUERYWINDOWPOS'
oordinals.PMMERGE.3054='WINQUERYWINDOWPROCESS'
oordinals.PMMERGE.3055='WINQUERYWINDOWRECT'
oordinals.PMMERGE.3056='WINQUERYWINDOWULONG'
oordinals.PMMERGE.3057='WINQUERYWINDOWUSHORT'
oordinals.PMMERGE.3058='WINREGISTERCLASS'
oordinals.PMMERGE.3059='WINRESETSYSTEM'
oordinals.PMMERGE.3060='WINSCREENSWITCH'
oordinals.PMMERGE.3061='WINSENDDLGITEMMSG'
oordinals.PMMERGE.3062='WINSENDMSG'
oordinals.PMMERGE.3063='WINSETACTIVEWINDOW'
oordinals.PMMERGE.3064='WINSETDLGITEMTEXT'
oordinals.PMMERGE.3065='WINSETFOCUS'
oordinals.PMMERGE.3066='WINSETMULTWINDOWPOS'
oordinals.PMMERGE.3067='WINSETPARENT'
oordinals.PMMERGE.3068='WINSETPRESPARAM'
oordinals.PMMERGE.3069='WINSETSYSMODALWINDOW'
oordinals.PMMERGE.3070='WINSETSYSVALUE'
oordinals.PMMERGE.3071='WINSETWINDOWBITS'
oordinals.PMMERGE.3072='WINSETWINDOWPOS'
oordinals.PMMERGE.3073='WINSETWINDOWTEXT'
oordinals.PMMERGE.3074='WINSHOWWINDOW'
oordinals.PMMERGE.3075='WINSUBCLASSWINDOW'
oordinals.PMMERGE.3076='WINTERMINATESHUTDOWN'
oordinals.PMMERGE.3077='WINTRACKRECT'
oordinals.PMMERGE.3078='WINWINDOWFROMID'
oordinals.PMMERGE.3079='WINADDPROGRAM'
oordinals.PMMERGE.3080='WINADDSWITCHENTRY'
oordinals.PMMERGE.3081='WINADDTOGROUP'
oordinals.PMMERGE.3082='WINCALCFRAMERECT'
oordinals.PMMERGE.3083='WINCALLHELPHOOK'
oordinals.PMMERGE.3084='WINCALLMSGFILTER'
oordinals.PMMERGE.3085='WINCANTERMINATE'
oordinals.PMMERGE.3086='WINCHANGEPROGRAM'
oordinals.PMMERGE.3087='WINCHANGESWITCHENTRY'
oordinals.PMMERGE.3088='WINCHECKINPUT'
oordinals.PMMERGE.3089='WINCLOSECLIPBRD'
oordinals.PMMERGE.3090='WINCPLREGISTER'
oordinals.PMMERGE.3091='WINCREATECURSOR'
oordinals.PMMERGE.3092='WINCREATEDLG'
oordinals.PMMERGE.3093='WINCREATEFRAMECONTROLS'
oordinals.PMMERGE.3094='WINCREATEGROUP'
oordinals.PMMERGE.3095='WINCREATEMENU'
oordinals.PMMERGE.3096='WINCREATESWITCHENTRY'
oordinals.PMMERGE.3097='WINDDEINITIATE'
oordinals.PMMERGE.3098='WINDDEPOSTMSG'
oordinals.PMMERGE.3099='WINDDERESPOND'
oordinals.PMMERGE.3100='WINDEBUGBREAK'
oordinals.PMMERGE.3101='WINDELETELIBRARY'
oordinals.PMMERGE.3102='WINDELETEPROCEDURE'
oordinals.PMMERGE.3103='WINDESTROYANIPOINTER'
oordinals.PMMERGE.3104='WINDESTROYCURSOR'
oordinals.PMMERGE.3105='WINDESTROYGROUP'
oordinals.PMMERGE.3106='WINDISMISSDLG'
oordinals.PMMERGE.3107='WINDLGBOX'
oordinals.PMMERGE.3108='WINDRAWBITMAP'
oordinals.PMMERGE.3109='WINDRAWBORDER'
oordinals.PMMERGE.3110='WINDRAWPOINTER'
oordinals.PMMERGE.3111='WINEMPTYCLIPBRD'
oordinals.PMMERGE.3112='WINENABLEPHYSINPUT'
oordinals.PMMERGE.3113='WINENABLEWINDOW'
oordinals.PMMERGE.3114='WINENABLEWINDOWUPDATE'
oordinals.PMMERGE.3115='WINENDENUMWINDOWS'
oordinals.PMMERGE.3116='WINENDPROGRAM'
oordinals.PMMERGE.3117='WINENDSESSION'
oordinals.PMMERGE.3118='WINENDWINDOWSESSION'
oordinals.PMMERGE.3119='WINENUMCLIPBRDFMTS'
oordinals.PMMERGE.3120='WINENUMDLGITEM'
oordinals.PMMERGE.3121='WINEQUALRECT'
oordinals.PMMERGE.3122='WINEXCLUDEUPDATEREGION'
oordinals.PMMERGE.3123='WINEXPLODEWINDOW'
oordinals.PMMERGE.3124='WINFLASHWINDOW'
oordinals.PMMERGE.3125='WINFOCUSCHANGE'
oordinals.PMMERGE.3126='WINFORCEMENUREDRAW'
oordinals.PMMERGE.3127='WINFORMATFRAME'
oordinals.PMMERGE.3128='WINGETCLIPPS'
oordinals.PMMERGE.3129='WINGETCURRENTTIME'
oordinals.PMMERGE.3130='WINGETDLGMSG'
oordinals.PMMERGE.3131='WINGETERASEPS'
oordinals.PMMERGE.3132='WINGETFRAMETREEPPS'
oordinals.PMMERGE.3133='WINGETFRAMETREEPPSIZE'
oordinals.PMMERGE.3134='WINGETMAXPOSITION'
oordinals.PMMERGE.3135='WINGETMINPOSITION'
oordinals.PMMERGE.3136='WINGETPHYSKEYSTATE'
oordinals.PMMERGE.3137='WINGETPS'
oordinals.PMMERGE.3138='WINGETSCANSTATE'
oordinals.PMMERGE.3139='WINGETSCREENPS'
oordinals.PMMERGE.3140='WINHAPPFROMPID'
oordinals.PMMERGE.3141='WINHSWITCHFROMHAPP'
oordinals.PMMERGE.3142='WININITIALIZEPL'
oordinals.PMMERGE.3143='WININITSESSION'
oordinals.PMMERGE.3144='WININITSESSIONMGR'
oordinals.PMMERGE.3145='WININITSWENTRY'
oordinals.PMMERGE.3146='WININSENDMSG'
oordinals.PMMERGE.3147='WININSTSTARTAPP'
oordinals.PMMERGE.3148='WININTERSECTRECT'
oordinals.PMMERGE.3149='WININVALIDATEREGION'
oordinals.PMMERGE.3150='WININVERTRECT'
oordinals.PMMERGE.3151='WINISPHYSINPUTENABLED'
oordinals.PMMERGE.3152='WINISSHUTTINGDOWN'
oordinals.PMMERGE.3153='WINISTHREADACTIVE'
oordinals.PMMERGE.3154='WINISWINDOWENABLED'
oordinals.PMMERGE.3155='WINISWINDOWSHOWING'
oordinals.PMMERGE.3156='WINJIGGLEMOUSE'
oordinals.PMMERGE.3157='WINLOADANIPOINTER'
oordinals.PMMERGE.3158='WINLOADLIBRARY'
oordinals.PMMERGE.3159='WINLOADMENU'
oordinals.PMMERGE.3160='WINLOADPROCEDURE'
oordinals.PMMERGE.3161='WINLOCKINPUT'
oordinals.PMMERGE.3162='WINLOCKPOINTERUPDATE'
oordinals.PMMERGE.3163='WINLOCKVISREGIONS'
oordinals.PMMERGE.3164='WINLOCKWINDOWUPDATE'
oordinals.PMMERGE.3165='WINMAPDLGPOINTS'
oordinals.PMMERGE.3166='WINMAPWINDOWPOINTS'
oordinals.PMMERGE.3167='WINMENUINDEXFROMID'
oordinals.PMMERGE.3168='WINMSGMUXSEMWAIT'
oordinals.PMMERGE.3169='WINNOSHUTDOWN'
oordinals.PMMERGE.3170='WINOPENCLIPBRD'
oordinals.PMMERGE.3171='WINPMFILEREGISTER'
oordinals.PMMERGE.3172='WINPOPUPMENU'
oordinals.PMMERGE.3173='WINPOSTQUEUEMSG'
oordinals.PMMERGE.3174='WINQUERYACCELTABLE'
oordinals.PMMERGE.3175='WINQUERYACCELTABLEVALUE'
oordinals.PMMERGE.3176='WINQUERYCAPTURE'
oordinals.PMMERGE.3177='WINQUERYCHARXLATETBL'
oordinals.PMMERGE.3178='WINQUERYCLASSNAME'
oordinals.PMMERGE.3179='WINQUERYCLASSTHUNKPROC'
oordinals.PMMERGE.3180='WINQUERYCLIPBRDDATA'
oordinals.PMMERGE.3181='WINQUERYCLIPBRDOWNER'
oordinals.PMMERGE.3182='WINQUERYCLIPBRDVIEWER'
oordinals.PMMERGE.3183='WINQUERYDEFINITION'
oordinals.PMMERGE.3184='WINQUERYDESKTOPBKGND'
oordinals.PMMERGE.3185='WINQUERYDLGITEMSHORT'
oordinals.PMMERGE.3186='WINQUERYDLGITEMTEXT'
oordinals.PMMERGE.3187='WINQUERYDLGITEMTEXTLENGTH'
oordinals.PMMERGE.3188='WINQUERYEXTIDFOCUS'
oordinals.PMMERGE.3189='WINQUERYFILEEXTOPTS'
oordinals.PMMERGE.3190='WINQUERYMENUDATA'
oordinals.PMMERGE.3191='WINQUERYMSGPOS'
oordinals.PMMERGE.3192='WINQUERYMSGTIME'
oordinals.PMMERGE.3193='WINQUERYOBJECTWINDOW'
oordinals.PMMERGE.3194='WINQUERYPOINTER'
oordinals.PMMERGE.3195='WINQUERYPOINTERPOS'
oordinals.PMMERGE.3196='WINQUERYPRESPARAM'
oordinals.PMMERGE.3197='WINQUERYPROGRAMTITLES'
oordinals.PMMERGE.3198='WINQUERYPROGRAMTYPE'
oordinals.PMMERGE.3199='WINQUERYPROGRAMUSE'
oordinals.PMMERGE.3200='WINQUERYQUEUESTATUS'
oordinals.PMMERGE.3201='WINQUERYSENDMSG'
oordinals.PMMERGE.3202='WINQUERYSESSIONTITLE'
oordinals.PMMERGE.3203='WINQUERYSTATE'
oordinals.PMMERGE.3204='WINQUERYSWITCHENTRY'
oordinals.PMMERGE.3205='WINQUERYSWITCHHANDLE'
oordinals.PMMERGE.3206='WINQUERYSWITCHLIST'
oordinals.PMMERGE.3207='WINQUERYSYSCOLOR'
oordinals.PMMERGE.3208='WINQUERYTASKSIZEPOS'
oordinals.PMMERGE.3209='WINQUERYTASKTITLE'
oordinals.PMMERGE.3210='WINQUERYUPDATERECT'
oordinals.PMMERGE.3211='WINQUERYUPDATEREGION'
oordinals.PMMERGE.3212='WINQUERYWINDOWDC'
oordinals.PMMERGE.3213='WINQUERYWINDOWMODEL'
oordinals.PMMERGE.3214='WINQUERYWINDOWPTR'
oordinals.PMMERGE.3215='WINQUERYWINDOWSGID'
oordinals.PMMERGE.3216='WINQUERYWINDOWTEXT'
oordinals.PMMERGE.3217='WINQUERYWINDOWTEXTLENGTH'
oordinals.PMMERGE.3218='WINQUERYWINDOWTHUNKPROC'
oordinals.PMMERGE.3219='WINQUERYWORKPLACEWINDOW'
oordinals.PMMERGE.3220='WINQUEUEFROMID'
oordinals.PMMERGE.3221='WINREALIZEPALETTE'
oordinals.PMMERGE.3222='WINREGISTERSEAMLESSPROC'
oordinals.PMMERGE.3223='WINREGISTERUSERDATATYPE'
oordinals.PMMERGE.3224='WINREGISTERUSERMSG'
oordinals.PMMERGE.3225='WINREGISTERWINDOWDESTROY'
oordinals.PMMERGE.3226='WINRELEASEERASEPS'
oordinals.PMMERGE.3227='WINRELEASEHOOK'
oordinals.PMMERGE.3228='WINRELEASEPS'
oordinals.PMMERGE.3229='WINREMOVEFROMGROUP'
oordinals.PMMERGE.3230='WINREMOVEPRESPARAM'
oordinals.PMMERGE.3231='WINREMOVEPROGRAM'
oordinals.PMMERGE.3232='WINREMOVESWITCHENTRY'
oordinals.PMMERGE.3233='WINREPLYMSG'
oordinals.PMMERGE.3234='WINSAVEWINDOWPOS'
oordinals.PMMERGE.3235='WINSCROLLWINDOW'
oordinals.PMMERGE.3236='WINSEAMLESSBOX'
oordinals.PMMERGE.3237='WINSEMENTER'
oordinals.PMMERGE.3238='WINSEMLEAVE'
oordinals.PMMERGE.3239='WINSEMQUERY'
oordinals.PMMERGE.3240='WINSENDQUEUEMSG'
oordinals.PMMERGE.3241='WINSETACCELTABLE'
oordinals.PMMERGE.3242='WINSETACCELTABLEVALUE'
oordinals.PMMERGE.3243='WINSETANIPOINTER'
oordinals.PMMERGE.3244='WINSETATOMTABLEOWNER'
oordinals.PMMERGE.3245='WINSETCAPTURE'
oordinals.PMMERGE.3246='WINSETCHARXLATETBL'
oordinals.PMMERGE.3247='WINSETCLASSMSGINTEREST'
oordinals.PMMERGE.3248='WINSETCLASSTHUNKPROC'
oordinals.PMMERGE.3249='WINSETCLIPBRDOWNER'
oordinals.PMMERGE.3250='WINSETCLIPBRDVIEWER'
oordinals.PMMERGE.3251='WINSETDESKTOPBKGND'
oordinals.PMMERGE.3252='WINSETDLGITEMSHORT'
oordinals.PMMERGE.3253='WINSETEXTIDFOCUS'
oordinals.PMMERGE.3254='WINSETFGNDWINDOW'
oordinals.PMMERGE.3255='WINSETFILEEXTOPTS'
oordinals.PMMERGE.3256='WINSETFRAMETREEPPS'
oordinals.PMMERGE.3257='WINSETHOOK'
oordinals.PMMERGE.3258='WINSETKEYBOARDSTATETABLE'
oordinals.PMMERGE.3259='WINSETMENUDATA'
oordinals.PMMERGE.3260='WINSETMSGINTEREST'
oordinals.PMMERGE.3261='WINSETMSGMODE'
oordinals.PMMERGE.3262='WINSETOWNER'
oordinals.PMMERGE.3263='WINSETPOINTER'
oordinals.PMMERGE.3264='WINSETPOINTEROWNER'
oordinals.PMMERGE.3265='WINSETPOINTERPOS'
oordinals.PMMERGE.3266='WINSETSCANSTATETABLE'
oordinals.PMMERGE.3267='WINSETSWENTRY'
oordinals.PMMERGE.3268='WINSETSYNCHROMODE'
oordinals.PMMERGE.3269='WINSETSYSCLIPBRDVIEWER'
oordinals.PMMERGE.3270='WINSETSYSCOLORS'
oordinals.PMMERGE.3271='WINSETTITLE'
oordinals.PMMERGE.3272='WINSETTITLEANDICON'
oordinals.PMMERGE.3273='WINSETWINDOWDC'
oordinals.PMMERGE.3274='WINSETWINDOWPTR'
oordinals.PMMERGE.3275='WINSETWINDOWTHUNKPROC'
oordinals.PMMERGE.3276='WINSETWINDOWULONG'
oordinals.PMMERGE.3277='WINSETWINDOWUSHORT'
oordinals.PMMERGE.3278='WINSHOWCURSOR'
oordinals.PMMERGE.3279='WINSHOWPOINTER'
oordinals.PMMERGE.3280='WINSHOWTRACKRECT'
oordinals.PMMERGE.3281='WINSTARTAPP'
oordinals.PMMERGE.3282='WINSTARTTIMER'
oordinals.PMMERGE.3283='WINSTOPPROGRAM'
oordinals.PMMERGE.3284='WINSTOPTIMER'
oordinals.PMMERGE.3285='WINSTPREGISTER'
oordinals.PMMERGE.3286='WINSTRETCHPOINTER'
oordinals.PMMERGE.3287='WINSUBSTITUTESTRINGS'
oordinals.PMMERGE.3288='WINSUBTRACTRECT'
oordinals.PMMERGE.3289='WINSWITCHPROGRAMREGISTER'
oordinals.PMMERGE.3290='WINSWITCHTOPROGRAM2'
oordinals.PMMERGE.3291='WINSWITCHTOPROGRAM'
oordinals.PMMERGE.3292='SWITCHTOTASKWINDOW'
oordinals.PMMERGE.3292='WINSWITCHTOTASKMANAGER'
oordinals.PMMERGE.3293='WINSYNCSTARTPGM'
oordinals.PMMERGE.3294='WINSYSTEMSHUTDOWN'
oordinals.PMMERGE.3295='WINTERMINATEAPP'
oordinals.PMMERGE.3296='WINTHREADASSOCQUEUE'
oordinals.PMMERGE.3297='WINTRACKSEAMLESS'
oordinals.PMMERGE.3298='WINTRANSLATEACCEL'
oordinals.PMMERGE.3299='WINTRANSLATECHAR'
oordinals.PMMERGE.3300='WINUNIONRECT'
oordinals.PMMERGE.3301='WINUPDATEWINDOW'
oordinals.PMMERGE.3302='WINVALIDATERECT'
oordinals.PMMERGE.3303='WINVALIDATEREGION'
oordinals.PMMERGE.3304='WINVKEYGLYPHCHARXLATE'
oordinals.PMMERGE.3305='WINWAITMSG'
oordinals.PMMERGE.3306='WINWAKETHREAD'
oordinals.PMMERGE.3307='WINWINDOWFROMDC'
oordinals.PMMERGE.3308='WINWINDOWFROMPOINT'
oordinals.PMMERGE.3309='WINSETTITLEANDHWNDICON'
oordinals.PMMERGE.4011='FSRSEMENTER'
oordinals.PMMERGE.4012='FSRSEMENTERP'
oordinals.PMMERGE.4013='FSRSEMLEAVE'
oordinals.PMMERGE.5000='AAB32GETREG'
oordinals.PMMERGE.5001='AAB32SETREG'
oordinals.PMMERGE.5002='ABNORMALPROCESSEXIT'
oordinals.PMMERGE.5003='DEBUG32CLS'
oordinals.PMMERGE.5004='DEBUG32CURPOS'
oordinals.PMMERGE.5005='DEBUG32INPUT'
oordinals.PMMERGE.5006='DEBUG32OUTPUT'
oordinals.PMMERGE.5007='DESTROYTIMERS'
oordinals.PMMERGE.5008='EDITALLOCSPACE'
oordinals.PMMERGE.5009='EDITAUTOSIZE'
oordinals.PMMERGE.5010='EDITBACKSPACE'
oordinals.PMMERGE.5011='EDITCHANGEFOCUS'
oordinals.PMMERGE.5012='EDITCHANGESELECTION'
oordinals.PMMERGE.5013='EDITCHAR'
oordinals.PMMERGE.5014='EDITCHECKSCROLL'
oordinals.PMMERGE.5015='EDITCLEAR'
oordinals.PMMERGE.5016='EDITCOPY'
oordinals.PMMERGE.5017='EDITCREATE'
oordinals.PMMERGE.5018='EDITCREATECURSOR'
oordinals.PMMERGE.5019='EDITCREATEPASSWORD'
oordinals.PMMERGE.5020='EDITCUT'
oordinals.PMMERGE.5021='EDITCXFROMICH'
oordinals.PMMERGE.5022='EDITDRAWSUBSTRING'
oordinals.PMMERGE.5023='EDITGETFLAGS'
oordinals.PMMERGE.5024='EDITGETWINDOWRECT'
oordinals.PMMERGE.5025='EDITICHFROMPT'
oordinals.PMMERGE.5026='EDITNOTIFY'
oordinals.PMMERGE.5027='EDITPAINT'
oordinals.PMMERGE.5028='EDITPASTE'
oordinals.PMMERGE.5029='EDITPTFROMICH'
oordinals.PMMERGE.5030='EDITQUERYPRESPARAMS'
oordinals.PMMERGE.5031='EDITREPLACE'
oordinals.PMMERGE.5032='EDITSETCURSORPOS'
oordinals.PMMERGE.5033='EDITSETFIRSTINDEX'
oordinals.PMMERGE.5034='EDITSETINSERTMODE'
oordinals.PMMERGE.5035='EDITSETSELECTION'
oordinals.PMMERGE.5036='EDITSETTEXT'
oordinals.PMMERGE.5037='EDITSETWINDOWPARAMS'
oordinals.PMMERGE.5038='EDITSHOWCHANGE'
oordinals.PMMERGE.5039='EDITSTOPMOUSETRACKING'
oordinals.PMMERGE.5040='EDITTIMERSCROLL'
oordinals.PMMERGE.5041='EDITTRACKMOUSE'
oordinals.PMMERGE.5042='EDITVIRTUALKEY'
oordinals.PMMERGE.5043='EDITWMCHAR'
oordinals.PMMERGE.5044='FAR32LOCKUPHOOK'
oordinals.PMMERGE.5045='FARCALLHOOK'
oordinals.PMMERGE.5046='GETDRIVERINFO32'
oordinals.PMMERGE.5047='GPI32LOADBITMAP'
oordinals.PMMERGE.5048='GRE32ENTRY10'
oordinals.PMMERGE.5049='GRE32ENTRY2'
oordinals.PMMERGE.5050='GRE32ENTRY3'
oordinals.PMMERGE.5051='GRE32ENTRY4'
oordinals.PMMERGE.5052='GRE32ENTRY5'
oordinals.PMMERGE.5053='GRE32ENTRY6'
oordinals.PMMERGE.5054='GRE32ENTRY7'
oordinals.PMMERGE.5055='GRE32ENTRY8'
oordinals.PMMERGE.5056='GRE32ENTRY9'
oordinals.PMMERGE.5057='GETICONWINDOWSEXE'
oordinals.PMMERGE.5058='GETICONWINDOWSICO'
oordinals.PMMERGE.5059='INNERGRE32ENTRY10'
oordinals.PMMERGE.5060='INNERGRE32ENTRY2'
oordinals.PMMERGE.5061='INNERGRE32ENTRY3'
oordinals.PMMERGE.5062='INNERGRE32ENTRY4'
oordinals.PMMERGE.5063='INNERGRE32ENTRY5'
oordinals.PMMERGE.5064='INNERGRE32ENTRY6'
oordinals.PMMERGE.5065='INNERGRE32ENTRY7'
oordinals.PMMERGE.5066='INNERGRE32ENTRY8'
oordinals.PMMERGE.5067='INNERGRE32ENTRY9'
oordinals.PMMERGE.5069='PM32EXECREGISTER'
oordinals.PMMERGE.5073='POSTDEVICEMODES32'
oordinals.PMMERGE.5074='PRF32ADDPROGRAM'
oordinals.PMMERGE.5075='PRF32CHANGEPROGRAM'
oordinals.PMMERGE.5076='PRF32CHANGEWRITETHRU'
oordinals.PMMERGE.5077='PRF32CLOSEPROFILE'
oordinals.PMMERGE.5078='PRF32CREATEGROUP'
oordinals.PMMERGE.5079='PRF32DESTROYGROUP'
oordinals.PMMERGE.5080='PRF32OPENPROFILE'
oordinals.PMMERGE.5081='PRF32QUERYDEFINITION'
oordinals.PMMERGE.5082='PRF32QUERYPROFILE'
oordinals.PMMERGE.5083='PRF32QUERYPROFILEDATA'
oordinals.PMMERGE.5084='PRF32QUERYPROFILEINT'
oordinals.PMMERGE.5085='PRF32QUERYPROFILESIZE'
oordinals.PMMERGE.5086='PRF32QUERYPROFILESTRING'
oordinals.PMMERGE.5087='PRF32QUERYPROGRAMCATEGORY'
oordinals.PMMERGE.5088='PRF32QUERYPROGRAMHANDLE'
oordinals.PMMERGE.5089='PRF32QUERYPROGRAMTITLES'
oordinals.PMMERGE.5090='PRF32REMOVEPROGRAM'
oordinals.PMMERGE.5091='PRF32RESET'
oordinals.PMMERGE.5092='PRF32WRITEPROFILEDATA'
oordinals.PMMERGE.5093='PRF32WRITEPROFILESTRING'
oordinals.PMMERGE.5094='PRFSUSPENDWRITETODISK'
oordinals.PMMERGE.5095='PRFWRITETODISK'
oordinals.PMMERGE.5096='RAMSEMCLEAR32'
oordinals.PMMERGE.5097='RAMSEMREQUEST32'
oordinals.PMMERGE.5098='SETDRIVERINFO32'
oordinals.PMMERGE.5099='SHE32PIINITINIFILES'
oordinals.PMMERGE.5100='SHE32SYSTEMSHUTDOWN'
oordinals.PMMERGE.5101='SHPPI32LOCKINIFILE'
oordinals.PMMERGE.5102='SHPPI32SHUTDOWN'
oordinals.PMMERGE.5103='SLEC_INITPEN'
oordinals.PMMERGE.5104='SSALLOCMEM'
oordinals.PMMERGE.5105='SSFREEMEM'
oordinals.PMMERGE.5106='START32SYSTEMEXECUTABLES'
oordinals.PMMERGE.5107='STARTTIMER'
oordinals.PMMERGE.5108='SETDEVICESURFACE'
oordinals.PMMERGE.5109='THKDOS16SETFGND'
oordinals.PMMERGE.5111='WIN32ADDATOM'
oordinals.PMMERGE.5112='WIN32ADDSWITCHENTRY'
oordinals.PMMERGE.5113='WIN32ALARM'
oordinals.PMMERGE.5114='WIN32BEGINENUMWINDOWS'
oordinals.PMMERGE.5115='WIN32BEGINPAINT'
oordinals.PMMERGE.5116='WIN32BROADCASTMSG'
oordinals.PMMERGE.5117='WIN32BUILDPTRHANDLE'
oordinals.PMMERGE.5118='WIN32CALCFRAMERECT'
oordinals.PMMERGE.5119='WIN32CALLHELPHOOK'
oordinals.PMMERGE.5120='WIN32CALLMSGFILTER'
oordinals.PMMERGE.5121='WIN32CANCELSHUTDOWN'
oordinals.PMMERGE.5122='WIN32CHANGESWITCHENTRY'
oordinals.PMMERGE.5123='WIN32CHECKINPUT'
oordinals.PMMERGE.5124='WIN32CLOSECLIPBRD'
oordinals.PMMERGE.5125='WIN32COMPARESTRINGS'
oordinals.PMMERGE.5126='WIN32COPYACCELTABLE'
oordinals.PMMERGE.5127='WIN32COPYRECT'
oordinals.PMMERGE.5128='WIN32CPTRANSLATECHAR'
oordinals.PMMERGE.5129='WIN32CPTRANSLATESTRING'
oordinals.PMMERGE.5130='WIN32CREATEACCELTABLE'
oordinals.PMMERGE.5131='WIN32CREATEATOMTABLE'
oordinals.PMMERGE.5132='WIN32CREATECURSOR'
oordinals.PMMERGE.5133='WIN32CREATEDLG'
oordinals.PMMERGE.5134='WIN32CREATEFRAMECONTROLS'
oordinals.PMMERGE.5135='WIN32CREATEMENU'
oordinals.PMMERGE.5136='WIN32CREATEMSGQUEUE'
oordinals.PMMERGE.5137='WIN32CREATEPOINTER'
oordinals.PMMERGE.5138='WIN32CREATEPOINTERINDIRECT'
oordinals.PMMERGE.5139='WIN32CREATESTDWINDOW'
oordinals.PMMERGE.5140='WIN32CREATESWITCHENTRY'
oordinals.PMMERGE.5141='WIN32CREATEWINDOW'
oordinals.PMMERGE.5142='WIN32DDEINITIATE'
oordinals.PMMERGE.5143='WIN32DDEPOSTMSG'
oordinals.PMMERGE.5144='WIN32DDERESPOND'
oordinals.PMMERGE.5145='WIN32DEBUGBREAK'
oordinals.PMMERGE.5146='WIN32DEFDLGPROC'
oordinals.PMMERGE.5147='WIN32DEFWINDOWPROC'
oordinals.PMMERGE.5148='WIN32DELETEATOM'
oordinals.PMMERGE.5149='WIN32DELETELIBRARY'
oordinals.PMMERGE.5150='WIN32DELETEPROCEDURE'
oordinals.PMMERGE.5151='WIN32DESTROYACCELTABLE'
oordinals.PMMERGE.5152='WIN32DESTROYATOMTABLE'
oordinals.PMMERGE.5153='WIN32DESTROYCURSOR'
oordinals.PMMERGE.5154='WIN32DESTROYMSGQUEUE'
oordinals.PMMERGE.5155='WIN32DESTROYPOINTER'
oordinals.PMMERGE.5156='WIN32DESTROYWINDOW'
oordinals.PMMERGE.5157='WIN32DISMISSDLG'
oordinals.PMMERGE.5158='WIN32DISPATCHMSG'
oordinals.PMMERGE.5159='WIN32DLGBOX'
oordinals.PMMERGE.5160='WIN32DRAWBITMAP'
oordinals.PMMERGE.5161='WIN32DRAWBORDER'
oordinals.PMMERGE.5162='WIN32DRAWPOINTER'
oordinals.PMMERGE.5163='WIN32DRAWTEXT'
oordinals.PMMERGE.5164='WIN32EMPTYCLIPBRD'
oordinals.PMMERGE.5165='WIN32ENABLEPHYSINPUT'
oordinals.PMMERGE.5166='WIN32ENABLEWINDOW'
oordinals.PMMERGE.5167='WIN32ENABLEWINDOWUPDATE'
oordinals.PMMERGE.5168='WIN32ENDENUMWINDOWS'
oordinals.PMMERGE.5169='WIN32ENDPAINT'
oordinals.PMMERGE.5170='WIN32ENDPROGRAM'
oordinals.PMMERGE.5171='WIN32ENUMCLIPBRDFMTS'
oordinals.PMMERGE.5172='WIN32ENUMDLGITEM'
oordinals.PMMERGE.5173='WIN32EQUALRECT'
oordinals.PMMERGE.5174='WIN32EXCLUDEUPDATEREGION'
oordinals.PMMERGE.5175='WIN32EXPLODEWINDOW'
oordinals.PMMERGE.5176='WIN32FILLRECT'
oordinals.PMMERGE.5177='WIN32FINDATOM'
oordinals.PMMERGE.5178='WIN32FLASHWINDOW'
oordinals.PMMERGE.5179='WIN32FOCUSCHANGE'
oordinals.PMMERGE.5180='WIN32FREEERRORINFO'
oordinals.PMMERGE.5181='WIN32GETCLIPPS'
oordinals.PMMERGE.5182='WIN32GETCURRENTTIME'
oordinals.PMMERGE.5183='WIN32GETDLGMSG'
oordinals.PMMERGE.5184='WIN32GETERASEPS'
oordinals.PMMERGE.5185='WIN32GETERRORINFO'
oordinals.PMMERGE.5186='WIN32GETFRAMETREEPPS'
oordinals.PMMERGE.5187='WIN32GETFRAMETREEPPSIZE'
oordinals.PMMERGE.5188='WIN32GETKEYSTATE'
oordinals.PMMERGE.5189='WIN32GETLASTERROR'
oordinals.PMMERGE.5190='WIN32GETMAXPOSITION'
oordinals.PMMERGE.5191='WIN32GETMINPOSITION'
oordinals.PMMERGE.5192='WIN32GETMSG'
oordinals.PMMERGE.5193='WIN32GETNEXTWINDOW'
oordinals.PMMERGE.5194='WIN32GETPHYSKEYSTATE'
oordinals.PMMERGE.5195='WIN32GETPS'
oordinals.PMMERGE.5196='WIN32GETSCREENPS'
oordinals.PMMERGE.5197='WIN32GETSYSBITMAP'
oordinals.PMMERGE.5198='WIN32HAPPFROMPID'
oordinals.PMMERGE.5199='WIN32HSWITCHFROMHAPP'
oordinals.PMMERGE.5200='WIN32INFLATERECT'
oordinals.PMMERGE.5201='WIN32INITIALIZE'
oordinals.PMMERGE.5202='WIN32INSENDMSG'
oordinals.PMMERGE.5203='WIN32INTERSECTRECT'
oordinals.PMMERGE.5204='WIN32INVALIDATERECT'
oordinals.PMMERGE.5205='WIN32INVALIDATEREGION'
oordinals.PMMERGE.5206='WIN32INVERTRECT'
oordinals.PMMERGE.5207='WIN32ISCHILD'
oordinals.PMMERGE.5208='WIN32ISPHYSINPUTENABLED'
oordinals.PMMERGE.5209='WIN32ISRECTEMPTY'
oordinals.PMMERGE.5210='WIN32ISTHREADACTIVE'
oordinals.PMMERGE.5211='WIN32ISWINDOW'
oordinals.PMMERGE.5212='WIN32ISWINDOWENABLED'
oordinals.PMMERGE.5213='WIN32ISWINDOWSHOWING'
oordinals.PMMERGE.5214='WIN32ISWINDOWVISIBLE'
oordinals.PMMERGE.5215='WIN32JIGGLEMOUSE'
oordinals.PMMERGE.5216='WIN32LOADACCELTABLE'
oordinals.PMMERGE.5218='WIN32LOADDLG'
oordinals.PMMERGE.5219='WIN32LOADLIBRARY'
oordinals.PMMERGE.5220='WIN32LOADMENU'
oordinals.PMMERGE.5221='WIN32LOADMESSAGE'
oordinals.PMMERGE.5222='WIN32LOADPOINTER'
oordinals.PMMERGE.5223='WIN32LOADPROCEDURE'
oordinals.PMMERGE.5224='WIN32LOADSTRING'
oordinals.PMMERGE.5225='WIN32LOCKINPUT'
oordinals.PMMERGE.5226='WIN32LOCKPOINTERUPDATE'
oordinals.PMMERGE.5227='WIN32LOCKVISREGIONS'
oordinals.PMMERGE.5228='WIN32LOCKWINDOWUPDATE'
oordinals.PMMERGE.5229='WIN32MAKEPOINTS'
oordinals.PMMERGE.5230='WIN32MAKERECT'
oordinals.PMMERGE.5231='WIN32MAPDLGPOINTS'
oordinals.PMMERGE.5232='WIN32MAPWINDOWPOINTS'
oordinals.PMMERGE.5233='WIN32MESSAGEBOX'
oordinals.PMMERGE.5234='WIN32MOVECURSOR'
oordinals.PMMERGE.5235='WIN32MSGMUXSEMWAIT'
oordinals.PMMERGE.5236='WIN32MSGSEMWAIT'
oordinals.PMMERGE.5237='WIN32MULTWINDOWFROMIDS'
oordinals.PMMERGE.5238='WIN32NEXTCHAR'
oordinals.PMMERGE.5239='WIN32OFFSETRECT'
oordinals.PMMERGE.5240='WIN32OPENCLIPBRD'
oordinals.PMMERGE.5241='WIN32OPENWINDOWDC'
oordinals.PMMERGE.5242='WIN32PEEKMSG'
oordinals.PMMERGE.5243='WIN32POPUPMENU'
oordinals.PMMERGE.5244='WIN32POSTMSG'
oordinals.PMMERGE.5245='WIN32POSTQUEUEMSG'
oordinals.PMMERGE.5246='WIN32PREVCHAR'
oordinals.PMMERGE.5247='WIN32PROCESSDLG'
oordinals.PMMERGE.5248='WIN32PTINRECT'
oordinals.PMMERGE.5249='WIN32QUERYACCELTABLE'
oordinals.PMMERGE.5250='WIN32QUERYACCELTABLEVALUE'
oordinals.PMMERGE.5251='WIN32QUERYACTIVEWINDOW'
oordinals.PMMERGE.5252='WIN32QUERYANCHORBLOCK'
oordinals.PMMERGE.5253='WIN32QUERYATOMLENGTH'
oordinals.PMMERGE.5254='WIN32QUERYATOMNAME'
oordinals.PMMERGE.5255='WIN32QUERYATOMUSAGE'
oordinals.PMMERGE.5256='WIN32QUERYCAPTURE'
oordinals.PMMERGE.5257='WIN32QUERYCLASSINFO'
oordinals.PMMERGE.5258='WIN32QUERYCLASSNAME'
oordinals.PMMERGE.5259='WIN32QUERYCLASSTHUNKPROC'
oordinals.PMMERGE.5260='WIN32QUERYCLIPBRDDATA'
oordinals.PMMERGE.5261='WIN32QUERYCLIPBRDFMTINFO'
oordinals.PMMERGE.5262='WIN32QUERYCLIPBRDOWNER'
oordinals.PMMERGE.5263='WIN32QUERYCLIPBRDVIEWER'
oordinals.PMMERGE.5264='WIN32QUERYCP'
oordinals.PMMERGE.5265='WIN32QUERYCPLIST'
oordinals.PMMERGE.5266='WIN32QUERYCURSORINFO'
oordinals.PMMERGE.5267='WIN32QUERYDESKTOPBKGND'
oordinals.PMMERGE.5268='WIN32QUERYDESKTOPWINDOW'
oordinals.PMMERGE.5269='WIN32QUERYDLGITEMSHORT'
oordinals.PMMERGE.5270='WIN32QUERYDLGITEMTEXT'
oordinals.PMMERGE.5271='WIN32QUERYDLGITEMTEXTLENGTH'
oordinals.PMMERGE.5272='WIN32QUERYFOCUS'
oordinals.PMMERGE.5273='WIN32QUERYMSGPOS'
oordinals.PMMERGE.5274='WIN32QUERYMSGTIME'
oordinals.PMMERGE.5275='WIN32QUERYOBJECTWINDOW'
oordinals.PMMERGE.5276='WIN32QUERYPALETTEMODE'
oordinals.PMMERGE.5277='WIN32QUERYPOINTER'
oordinals.PMMERGE.5278='WIN32QUERYPOINTERINFO'
oordinals.PMMERGE.5279='WIN32QUERYPOINTERPOS'
oordinals.PMMERGE.5280='WIN32QUERYPRESPARAM'
oordinals.PMMERGE.5281='WIN32QUERYPROCESSCP'
oordinals.PMMERGE.5282='WIN32QUERYQUEUEINFO'
oordinals.PMMERGE.5283='WIN32QUERYQUEUESTATUS'
oordinals.PMMERGE.5284='WIN32QUERYSENDMSG'
oordinals.PMMERGE.5285='WIN32QUERYSESSIONTITLE'
oordinals.PMMERGE.5286='WIN32QUERYSWITCHENTRY'
oordinals.PMMERGE.5287='WIN32QUERYSWITCHHANDLE'
oordinals.PMMERGE.5288='WIN32QUERYSWITCHLIST'
oordinals.PMMERGE.5289='WIN32QUERYSYSCOLOR'
oordinals.PMMERGE.5290='WIN32QUERYSYSMODALWINDOW'
oordinals.PMMERGE.5291='WIN32QUERYSYSPOINTER'
oordinals.PMMERGE.5292='WIN32QUERYSYSPOINTERDATA'
oordinals.PMMERGE.5293='WIN32QUERYSYSTEMATOMTABLE'
oordinals.PMMERGE.5294='WIN32QUERYSYSVALUE'
oordinals.PMMERGE.5295='WIN32QUERYTASKSIZEPOS'
oordinals.PMMERGE.5296='WIN32QUERYTASKTITLE'
oordinals.PMMERGE.5297='WIN32QUERYUPDATERECT'
oordinals.PMMERGE.5298='WIN32QUERYUPDATEREGION'
oordinals.PMMERGE.5299='WIN32QUERYVERSION'
oordinals.PMMERGE.5300='WIN32QUERYVISIBLEREGION'
oordinals.PMMERGE.5301='WIN32QUERYWINDOW'
oordinals.PMMERGE.5302='WIN32QUERYWINDOWDC'
oordinals.PMMERGE.5303='WIN32QUERYWINDOWMODEL'
oordinals.PMMERGE.5304='WIN32QUERYWINDOWPOS'
oordinals.PMMERGE.5305='WIN32QUERYWINDOWPROCESS'
oordinals.PMMERGE.5306='WIN32QUERYWINDOWPTR'
oordinals.PMMERGE.5307='WIN32QUERYWINDOWRECT'
oordinals.PMMERGE.5308='WIN32QUERYWINDOWTEXT'
oordinals.PMMERGE.5309='WIN32QUERYWINDOWTEXTLENGTH'
oordinals.PMMERGE.5310='WIN32QUERYWINDOWTHUNKPROC'
oordinals.PMMERGE.5311='WIN32QUERYWINDOWULONG'
oordinals.PMMERGE.5312='WIN32QUERYWINDOWUSHORT'
oordinals.PMMERGE.5313='WIN32QUEUEFROMID'
oordinals.PMMERGE.5314='WIN32REALIZEPALETTE'
oordinals.PMMERGE.5315='WIN32REGISTERCLASS'
oordinals.PMMERGE.5316='WIN32REGISTERPEN'
oordinals.PMMERGE.5317='WIN32REGISTERSEAMLESSPROC'
oordinals.PMMERGE.5318='WIN32REGISTERUSERDATATYPE'
oordinals.PMMERGE.5319='WIN32REGISTERUSERMSG'
oordinals.PMMERGE.5320='WIN32RELEASEERASEPS'
oordinals.PMMERGE.5321='WIN32RELEASEHOOK'
oordinals.PMMERGE.5322='WIN32RELEASEPS'
oordinals.PMMERGE.5323='WIN32REMOVEPRESPARAM'
oordinals.PMMERGE.5324='WIN32REMOVESWITCHENTRY'
oordinals.PMMERGE.5325='WIN32REPLYMSG'
oordinals.PMMERGE.5326='WIN32REQUESTMUTEXSEM'
oordinals.PMMERGE.5327='WIN32SAVEWINDOWPOS'
oordinals.PMMERGE.5328='WIN32SCROLLWINDOW'
oordinals.PMMERGE.5329='WIN32SEAMLESSBOX'
oordinals.PMMERGE.5330='WIN32SEMENTER'
oordinals.PMMERGE.5331='WIN32SEMLEAVE'
oordinals.PMMERGE.5332='WIN32SEMQUERY'
oordinals.PMMERGE.5333='WIN32SENDDLGITEMMSG'
oordinals.PMMERGE.5334='WIN32SENDMSG'
oordinals.PMMERGE.5335='WIN32SETACCELTABLE'
oordinals.PMMERGE.5336='WIN32SETACCELTABLEVALUE'
oordinals.PMMERGE.5337='WIN32SETACTIVEWINDOW'
oordinals.PMMERGE.5338='WIN32SETCAPTURE'
oordinals.PMMERGE.5339='WIN32SETCHARXLATETBL'
oordinals.PMMERGE.5340='WIN32SETCLASSMSGINTEREST'
oordinals.PMMERGE.5341='WIN32SETCLASSTHUNKPROC'
oordinals.PMMERGE.5342='WIN32SETCLIPBRDDATA'
oordinals.PMMERGE.5343='WIN32SETCLIPBRDOWNER'
oordinals.PMMERGE.5344='WIN32SETCLIPBRDVIEWER'
oordinals.PMMERGE.5345='WIN32SETCP'
oordinals.PMMERGE.5346='WIN32SETDESKTOPBKGND'
oordinals.PMMERGE.5347='WIN32SETDLGITEMSHORT'
oordinals.PMMERGE.5348='WIN32SETDLGITEMTEXT'
oordinals.PMMERGE.5349='WIN32SETERRORINFO'
oordinals.PMMERGE.5349='WINSETERRORINFO32'
oordinals.PMMERGE.5350='WIN32SETFOCUS'
oordinals.PMMERGE.5351='WIN32SETFRAMETREEPPS'
oordinals.PMMERGE.5352='WIN32SETHOOK'
oordinals.PMMERGE.5353='WIN32SETKEYBOARDSTATETABLE'
oordinals.PMMERGE.5354='WIN32SETMSGINTEREST'
oordinals.PMMERGE.5355='WIN32SETMSGMODE'
oordinals.PMMERGE.5356='WIN32SETMULTWINDOWPOS'
oordinals.PMMERGE.5357='WIN32SETOWNER'
oordinals.PMMERGE.5358='WIN32SETPALETTEMODE'
oordinals.PMMERGE.5359='WIN32SETPARENT'
oordinals.PMMERGE.5360='WIN32SETPOINTER'
oordinals.PMMERGE.5361='WIN32SETPOINTEROWNER'
oordinals.PMMERGE.5362='WIN32SETPOINTERPOS'
oordinals.PMMERGE.5363='WIN32SETPRESPARAM'
oordinals.PMMERGE.5364='WIN32SETRECT'
oordinals.PMMERGE.5365='WIN32SETRECTEMPTY'
oordinals.PMMERGE.5366='WIN32SETSYNCHROMODE'
oordinals.PMMERGE.5367='WIN32SETSYSCLIPBRDVIEWER'
oordinals.PMMERGE.5368='WIN32SETSYSCOLORS'
oordinals.PMMERGE.5369='WIN32SETSYSFONT'
oordinals.PMMERGE.5370='WIN32SETSYSMODALWINDOW'
oordinals.PMMERGE.5371='WIN32SETSYSPOINTERDATA'
oordinals.PMMERGE.5372='WIN32SETSYSVALUE'
oordinals.PMMERGE.5373='WIN32SETVISIBLEREGIONNOTIFY'
oordinals.PMMERGE.5374='WIN32SETWINDOWBITS'
oordinals.PMMERGE.5375='WIN32SETWINDOWPOS'
oordinals.PMMERGE.5376='WIN32SETWINDOWPTR'
oordinals.PMMERGE.5377='WIN32SETWINDOWTEXT'
oordinals.PMMERGE.5378='WIN32SETWINDOWTHUNKPROC'
oordinals.PMMERGE.5379='WIN32SETWINDOWULONG'
oordinals.PMMERGE.5380='WIN32SETWINDOWUSHORT'
oordinals.PMMERGE.5381='WIN32SHOWCURSOR'
oordinals.PMMERGE.5382='WIN32SHOWPOINTER'
oordinals.PMMERGE.5383='WIN32SHOWTRACKRECT'
oordinals.PMMERGE.5384='WIN32SHOWWINDOW'
oordinals.PMMERGE.5385='WIN32STARTAPP'
oordinals.PMMERGE.5386='WIN32STARTTIMER'
oordinals.PMMERGE.5387='WIN32STOPTIMER'
oordinals.PMMERGE.5388='WIN32STRETCHPOINTER'
oordinals.PMMERGE.5389='WIN32SUBCLASSWINDOW'
oordinals.PMMERGE.5390='WIN32SUBSTITUTESTRINGS'
oordinals.PMMERGE.5391='WIN32SUBTRACTRECT'
oordinals.PMMERGE.5392='WIN32SWITCHPROGRAMREGISTER'
oordinals.PMMERGE.5393='WIN32SWITCHTOPROGRAM'
oordinals.PMMERGE.5394='WIN32SWITCHTOPROGRAM2'
oordinals.PMMERGE.5395='WIN32SYSTEMSHUTDOWN'
oordinals.PMMERGE.5396='WIN32TERMINATE'
oordinals.PMMERGE.5397='WIN32TERMINATEAPP'
oordinals.PMMERGE.5398='WIN32THREADASSOCQUEUE'
oordinals.PMMERGE.5399='WIN32TRACKRECT'
oordinals.PMMERGE.5400='WIN32TRACKSEAMLESS'
oordinals.PMMERGE.5401='WIN32TRANSLATEACCEL'
oordinals.PMMERGE.5402='WIN32UNIONRECT'
oordinals.PMMERGE.5403='WIN32UPDATEWINDOW'
oordinals.PMMERGE.5404='WIN32UPPER'
oordinals.PMMERGE.5405='WIN32UPPERCHAR'
oordinals.PMMERGE.5406='WIN32VALIDATERECT'
oordinals.PMMERGE.5407='WIN32VALIDATEREGION'
oordinals.PMMERGE.5408='WIN32VISREGIONNOTIFY'
oordinals.PMMERGE.5409='WIN32WAITEVENTSEM'
oordinals.PMMERGE.5410='WIN32WAITMSG'
oordinals.PMMERGE.5411='WIN32WAITMUXWAITSEM'
oordinals.PMMERGE.5412='WIN32WAKETHREAD'
oordinals.PMMERGE.5413='WIN32WINDOWFROMDC'
oordinals.PMMERGE.5414='WIN32WINDOWFROMID'
oordinals.PMMERGE.5415='WIN32WINDOWFROMPOINT'
oordinals.PMMERGE.5416='WINAUGMENTPOINTER'
oordinals.PMMERGE.5417='WINMESSAGEBOX2'
oordinals.PMMERGE.5418='WINMSPALLOC'
oordinals.PMMERGE.5419='WINMSPFREE'
oordinals.PMMERGE.5420='WINMSPINIT'
oordinals.PMMERGE.5421='WINPROCESSHOTKEY'
oordinals.PMMERGE.5422='WINPROFCONTROL'
oordinals.PMMERGE.5423='WINXXALLOCFILL'
oordinals.PMMERGE.5424='WINXXALLOCMEM'
oordinals.PMMERGE.5425='WINXXCREATEHEAP'
oordinals.PMMERGE.5426='WINXXDESTROYHEAP'
oordinals.PMMERGE.5427='WINXXFREEMEM'
oordinals.PMMERGE.5428='WINXXISMEMINHEAP'
oordinals.PMMERGE.5429='WINXXREALLOCMEM'
oordinals.PMMERGE.5430='PMHEAPISMEMINCHAIN'
oordinals.PMMERGE.5431='WIN32NOSHUTDOWN'
oordinals.PMMERGE.6000='KBDPACKET'
oordinals.PMMERGE.6100='GRENLS'
oordinals.PMMERGE.6200='GREMEMPTRS'
oordinals.PMMERGE.6201='FPEN'
oordinals.PMMERGE.6202='SHELLWINDOW'
oordinals.PMMERGE.6202='HWNDSHELL'
oordinals.KBDCALLS.1='KBDSETCUSTXT'
oordinals.KBDCALLS.2='KBDPROCESSINIT'
oordinals.KBDCALLS.3='KBDGETCP'
oordinals.KBDCALLS.4='KBDCHARIN'
oordinals.KBDCALLS.5='KBDSETCP'
oordinals.KBDCALLS.6='KBDLOADINSTANCE'
oordinals.KBDCALLS.7='KBDSYNCH'
oordinals.KBDCALLS.8='KBDREGISTER'
oordinals.KBDCALLS.9='KBDSTRINGIN'
oordinals.KBDCALLS.10='KBDGETSTATUS'
oordinals.KBDCALLS.11='KBDSETSTATUS'
oordinals.KBDCALLS.12='KBDGETFOCUS'
oordinals.KBDCALLS.13='KBDFLUSHBUFFER'
oordinals.KBDCALLS.14='KBDXLATE'
oordinals.KBDCALLS.15='KBDSWITCHFGND'
oordinals.KBDCALLS.16='KBDSHELLINIT'
oordinals.KBDCALLS.17='KBDCLOSE'
oordinals.KBDCALLS.18='KBDFREEFOCUS'
oordinals.KBDCALLS.19='KBDFREE'
oordinals.KBDCALLS.20='KBDDEREGISTER'
oordinals.KBDCALLS.21='KBDSETFGND'
oordinals.KBDCALLS.22='KBDPEEK'
oordinals.KBDCALLS.23='KBDOPEN'
oordinals.KBDCALLS.24='KBDGETHWID'
oordinals.KBDCALLS.25='KBDSETHWID'
oordinals.HELPMGR.1='WINCREATEHELPINSTANCE'
oordinals.HELPMGR.2='WINDESTROYHELPINSTANCE'
oordinals.HELPMGR.3='WINQUERYHELPINSTANCE'
oordinals.HELPMGR.4='WINASSOCIATEHELPINSTANCE'
oordinals.HELPMGR.5='WINLOADHELPTABLE'
oordinals.HELPMGR.6='WINCREATEHELPTABLE'
oordinals.HELPMGR.51='WIN32CREATEHELPINSTANCE'
oordinals.HELPMGR.52='WIN32DESTROYHELPINSTANCE'
oordinals.HELPMGR.53='WIN32QUERYHELPINSTANCE'
oordinals.HELPMGR.54='WIN32ASSOCIATEHELPINSTANCE'
oordinals.HELPMGR.55='WIN32LOADHELPTABLE'
oordinals.HELPMGR.56='WIN32CREATEHELPTABLE'
oordinals.HELPMGR.74='DDFINITIALIZE'
oordinals.HELPMGR.75='DDFPARA'
oordinals.HELPMGR.76='DDFSETFORMAT'
oordinals.HELPMGR.77='DDFSETTEXTALIGN'
oordinals.HELPMGR.78='DDFSETCOLOR'
oordinals.HELPMGR.79='DDFINFORM'
oordinals.HELPMGR.80='DDFSETFONTSTYLE'
oordinals.HELPMGR.81='DDFHYPERTEXT'
oordinals.HELPMGR.82='DDFBEGINLIST'
oordinals.HELPMGR.83='DDFLISTITEM'
oordinals.HELPMGR.84='DDFENDLIST'
oordinals.HELPMGR.85='DDFTEXT'
oordinals.HELPMGR.86='DDFMETAFILE'
oordinals.HELPMGR.87='DDFSETFONT'
oordinals.HELPMGR.88='DDFBITMAP'
oordinals.FKA.64='FKAINIT'
oordinals.FKA.65='QUERYFKADISPLAYDETAILS'
oordinals.FKA.66='WINFKAWNDPROC'
oordinals.FKA.67='WINLOADFKA'
oordinals.FKA.68='WINCREATEFKA'
oordinals.FKA.69='WINSETFKAFORM'
oordinals.FKA.70='WINQUERYFKAFORM'
oordinals.FKA.71='WINGOTOFKA'
oordinals.FKA.72='WINGOFROMFKA'
oordinals.PMDRAG.1='DRGACCESSDRAGINFO'
oordinals.PMDRAG.2='DRGADDSTRHANDLE'
oordinals.PMDRAG.3='DRGALLOCDRAGINFO'
oordinals.PMDRAG.4='DRGALLOCDRAGTRANSFER'
oordinals.PMDRAG.5='DRGDELETEDRAGINFOSTRHANDLES'
oordinals.PMDRAG.6='DRGDELETESTRHANDLE'
oordinals.PMDRAG.7='DRGDRAG'
oordinals.PMDRAG.8='DRGFREEDRAGINFO'
oordinals.PMDRAG.9='DRGFREEDRAGTRANSFER'
oordinals.PMDRAG.10='DRGGETPS'
oordinals.PMDRAG.11='DRGPOSTTRANSFERMSG'
oordinals.PMDRAG.12='DRGPUSHDRAGINFO'
oordinals.PMDRAG.13='DRGQUERYDRAGITEM'
oordinals.PMDRAG.14='DRGQUERYDRAGITEMCOUNT'
oordinals.PMDRAG.15='DRGQUERYDRAGITEMPTR'
oordinals.PMDRAG.16='DRGQUERYNATIVERMF'
oordinals.PMDRAG.17='DRGQUERYNATIVERMFLEN'
oordinals.PMDRAG.18='DRGQUERYSTRNAME'
oordinals.PMDRAG.19='DRGQUERYSTRNAMELEN'
oordinals.PMDRAG.20='DRGQUERYTRUETYPE'
oordinals.PMDRAG.21='DRGQUERYTRUETYPELEN'
oordinals.PMDRAG.22='DRGRELEASEPS'
oordinals.PMDRAG.23='DRGSENDTRANSFERMSG'
oordinals.PMDRAG.24='DRGSETDRAGPOINTER'
oordinals.PMDRAG.25='DRGSETDRAGIMAGE'
oordinals.PMDRAG.26='DRGSETDRAGITEM'
oordinals.PMDRAG.27='DRGVERIFYNATIVERMF'
oordinals.PMDRAG.28='DRGVERIFYRMF'
oordinals.PMDRAG.29='DRGVERIFYTRUETYPE'
oordinals.PMDRAG.30='DRGVERIFYTYPE'
oordinals.PMDRAG.31='DRGVERIFYTYPESET'
oordinals.PMDRAG.63='DRGDRAGFILES'
oordinals.PMDRAG.64='DRGACCEPTDROPPEDFILES'
oordinals.PMDRAG.32='DRG32ACCESSDRAGINFO'
oordinals.PMDRAG.33='DRG32ADDSTRHANDLE'
oordinals.PMDRAG.34='DRG32ALLOCDRAGINFO'
oordinals.PMDRAG.35='DRG32ALLOCDRAGTRANSFER'
oordinals.PMDRAG.36='DRG32DELETEDRAGINFOSTRHANDLES'
oordinals.PMDRAG.37='DRG32DELETESTRHANDLE'
oordinals.PMDRAG.38='DRG32DRAG'
oordinals.PMDRAG.39='DRG32FREEDRAGINFO'
oordinals.PMDRAG.40='DRG32FREEDRAGTRANSFER'
oordinals.PMDRAG.41='DRG32GETPS'
oordinals.PMDRAG.42='DRG32POSTTRANSFERMSG'
oordinals.PMDRAG.43='DRG32PUSHDRAGINFO'
oordinals.PMDRAG.44='DRG32QUERYDRAGITEM'
oordinals.PMDRAG.45='DRG32QUERYDRAGITEMCOUNT'
oordinals.PMDRAG.46='DRG32QUERYDRAGITEMPTR'
oordinals.PMDRAG.47='DRG32QUERYNATIVERMF'
oordinals.PMDRAG.48='DRG32QUERYNATIVERMFLEN'
oordinals.PMDRAG.49='DRG32QUERYSTRNAME'
oordinals.PMDRAG.50='DRG32QUERYSTRNAMELEN'
oordinals.PMDRAG.51='DRG32QUERYTRUETYPE'
oordinals.PMDRAG.52='DRG32QUERYTRUETYPELEN'
oordinals.PMDRAG.53='DRG32RELEASEPS'
oordinals.PMDRAG.54='DRG32SENDTRANSFERMSG'
oordinals.PMDRAG.55='DRG32SETDRAGPOINTER'
oordinals.PMDRAG.56='DRG32SETDRAGIMAGE'
oordinals.PMDRAG.57='DRG32SETDRAGITEM'
oordinals.PMDRAG.58='DRG32VERIFYNATIVERMF'
oordinals.PMDRAG.59='DRG32VERIFYRMF'
oordinals.PMDRAG.60='DRG32VERIFYTRUETYPE'
oordinals.PMDRAG.61='DRG32VERIFYTYPE'
oordinals.PMDRAG.62='DRG32VERIFYTYPESET'
oordinals.PMDRAG.65='DRG32DRAGFILES'
oordinals.PMDRAG.66='DRG32ACCEPTDROPPEDFILES'
oordinals.PMDRAG.67='DRG32LAZYDRAG'
oordinals.PMDRAG.68='DRG32CANCELLAZYDRAG'
oordinals.PMDRAG.69='DRG32LAZYDROP'
oordinals.PMDRAG.70='DRG32QUERYDRAGINFOPTR'
oordinals.PMDRAG.71='DRG32QUERYDRAGINFOPTRFROMHWND'
oordinals.PMDRAG.72='DRG32QUERYDRAGINFOPTRFROMDRAGITEM'
oordinals.PMDRAG.73='DRG32QUERYDRAGSTATUS'
oordinals.PMDRAG.74='DRG32REALLOCDRAGINFO'
oordinals.BVSCALLS.1='BVSGETPTRDRAWNAME'
oordinals.BVSCALLS.3='BVSMAIN'
oordinals.BVSCALLS.4='BVSREDRAWSIZE'
oordinals.BMSCALLS.1='BMSMAIN'
oordinals.BKSCALLS.1='BKSMAIN'
oordinals.BDCALLS.1='NLSCONVERTBIDINUMERICS'
oordinals.BDCALLS.2='NLSCONVERTBIDISTRING'
oordinals.BDCALLS.3='NLSINTSETBIDIATT'
oordinals.BDCALLS.4='NLSINTQUERYBIDIATT'
oordinals.BDCALLS.5='NLSSETBIDIATT'
oordinals.BDCALLS.6='NLSQUERYBIDIATT'
oordinals.BDCALLS.7='NLSINVERSESTRING'
oordinals.BDCALLS.8='NLSSETBIDIPRINT'
oordinals.BDCALLS.9='NLSEDITSHAPE'
oordinals.BDCALLS.10='NLSSHAPEBIDISTRING'
oordinals.BDCALLS.11='NLPOPUP'
oordinals.BDCALLS.1='DEVENABLE'
oordinals.BDCALLS.2='BDBVHSETORIENTATION'
oordinals.BDCALLS.3='BDBVHQUERYORIENTATION'
oordinals.BDCALLS.4='BDBVHSETCSD'
oordinals.BDCALLS.5='BDBVHQUERYCSD'
oordinals.BDCALLS.6='BDBVHSETHOTKEYFLAG'
oordinals.BDCALLS.7='BDBVHQUERYHOTKEYFLAG'
oordinals.BDCALLS.8='BDBVHSETFIELDREV'
oordinals.BDCALLS.9='BDBVHQUERYFIELDREV'
oordinals.BDCALLS.10='BDBVHSETNL'
oordinals.BDCALLS.11='BDBVHQUERYNL'
oordinals.BDCALLS.12='BDBVHSETPUSHLEVEL'
oordinals.BDCALLS.13='BDBVHQUERYPUSHLEVEL'
oordinals.BDCALLS.14='BDBVHSETAUTOPUSHLTR'
oordinals.BDCALLS.15='BDBVHQUERYAUTOPUSHLTR'
oordinals.BDCALLS.16='BDBVHSETAUTOPUSHRTL'
oordinals.BDCALLS.17='BDBVHQUERYAUTOPUSHRTL'
oordinals.BDCALLS.18='BDBVHSETAUTOSHAPECTR'
oordinals.BDCALLS.19='BDBVHGETCURPOS'
oordinals.BDCALLS.20='ENDPOPUPHANDLING'
oordinals.BDCALLS.21='NLSQUERYBIDISEGADDRESS'
oordinals.BDCALLS.22='NLSRECORDBDDSEG'
oordinals.VIOCALLS.1='VIOENDPOPUP'
oordinals.VIOCALLS.10='VIOWRTCELLSTR'
oordinals.VIOCALLS.11='VIOPOPUP'
oordinals.VIOCALLS.12='VIOSCROLLRT'
oordinals.VIOCALLS.13='VIOWRTCHARSTR'
oordinals.VIOCALLS.14='AVS_PRTSC'
oordinals.VIOCALLS.15='VIOSETCURPOS'
oordinals.VIOCALLS.16='VIOSRFUNBLOCK'
oordinals.VIOCALLS.17='VIOSRFBLOCK'
oordinals.VIOCALLS.18='VIOSCRUNLOCK'
oordinals.VIOCALLS.19='VIOWRTTTY'
oordinals.VIOCALLS.2='VIOGETPHYSBUF'
oordinals.VIOCALLS.20='VIOSAVE'
oordinals.VIOCALLS.21='VIOGETMODE'
oordinals.VIOCALLS.22='VIOSETMODE'
oordinals.VIOCALLS.23='VIOSCRLOCK'
oordinals.VIOCALLS.24='VIOREADCELLSTR'
oordinals.VIOCALLS.25='VIOSAVREDRAWWAIT'
oordinals.VIOCALLS.26='VIOWRTNATTR'
oordinals.VIOCALLS.27='VIOGETCURTYPE'
oordinals.VIOCALLS.28='VIOSAVREDRAWUNDO'
oordinals.VIOCALLS.29='VIOGETFONT'
oordinals.VIOCALLS.3='VIOGETANSI'
oordinals.VIOCALLS.30='VIOREADCHARSTR'
oordinals.VIOCALLS.31='VIOGETBUF'
oordinals.VIOCALLS.32='VIOSETCURTYPE'
oordinals.VIOCALLS.33='VIOSETFONT'
oordinals.VIOCALLS.34='VIOHETINIT'
oordinals.VIOCALLS.35='VIOMODEUNDO'
oordinals.VIOCALLS.36='VIOSSWSWITCH'
oordinals.VIOCALLS.37='VIOMODEWAIT'
oordinals.VIOCALLS.38='AVS_PRTSCTOGGLE'
oordinals.VIOCALLS.4='VIOFREE'
oordinals.VIOCALLS.40='VIOGETCP'
oordinals.VIOCALLS.41='VIORESTORE'
oordinals.VIOCALLS.42='VIOSETCP'
oordinals.VIOCALLS.43='VIOSHOWBUF'
oordinals.VIOCALLS.44='VIOSCROLLLF'
oordinals.VIOCALLS.45='VIOREGISTER'
oordinals.VIOCALLS.46='VIOGETCONFIG'
oordinals.VIOCALLS.47='VIOSCROLLDN'
oordinals.VIOCALLS.48='VIOWRTCHARSTRATT'
oordinals.VIOCALLS.49='VIOGETSTATE'
oordinals.VIOCALLS.5='VIOSETANSI'
oordinals.VIOCALLS.50='VIOPRTSCTOGGLE'
oordinals.VIOCALLS.51='VIOSETSTATE'
oordinals.VIOCALLS.52='VIOWRTNCELL'
oordinals.VIOCALLS.53='VIOWRTNCHAR'
oordinals.VIOCALLS.54='VIOSHELLINIT'
oordinals.VIOCALLS.55='VIOASSOCIATE'
oordinals.VIOCALLS.56='VIOCREATEPS'
oordinals.VIOCALLS.57='VIODELETESETID'
oordinals.VIOCALLS.58='VIOGETDEVICECELLSIZE'
oordinals.VIOCALLS.59='VIOGETORG'
oordinals.VIOCALLS.6='VIODEREGISTER'
oordinals.VIOCALLS.60='VIOCREATELOGFONT'
oordinals.VIOCALLS.61='VIODESTROYPS'
oordinals.VIOCALLS.62='VIOQUERYSETIDS'
oordinals.VIOCALLS.63='VIOSETORG'
oordinals.VIOCALLS.64='VIOQUERYFONTS'
oordinals.VIOCALLS.65='VIOSETDEVICECELLSIZE'
oordinals.VIOCALLS.66='VIOSHOWPS'
oordinals.VIOCALLS.67='VIOGETPSADDRESS'
oordinals.VIOCALLS.68='VIOQUERYCONSOLE'
oordinals.VIOCALLS.69='VIOREDRAWSIZE'
oordinals.VIOCALLS.7='VIOSCROLLUP'
oordinals.VIOCALLS.70='VIOGLOBALREG'
oordinals.VIOCALLS.71='XVIOSETCASTATE'
oordinals.VIOCALLS.72='XVIOCHECKCHARTYPE'
oordinals.VIOCALLS.73='XVIODESTROYCA'
oordinals.VIOCALLS.74='XVIOCREATECA'
oordinals.VIOCALLS.75='VIOCHECKCHARTYPE'
oordinals.VIOCALLS.76='XVIOGETCASTATE'
oordinals.VIOCALLS.8='VIOPRTSC'
oordinals.VIOCALLS.9='VIOGETCURPOS'
oordinals.ANSI.1='ANSIINJECT'
oordinals.ANSI.2='ANSIKEYDEF'
oordinals.ANSI.3='ANSIINTERP'
oordinals.WPPRINT.101='WPPMSpoolInit'
oordinals.WPPRINT.102='WPPMInitPrinterObjects'
oordinals.WPPRINT.103='SOMInitModule'
oordinals.WPPRINT.105='WPPrinterCClassData'
oordinals.WPPRINT.106='WPPrinterClassData'
oordinals.WPPRINT.107='WPPrinterNewClass'
oordinals.WPPRINT.108='WPJobCClassData'
oordinals.WPPRINT.109='WPJobClassData'
oordinals.WPPRINT.110='WPJobNewClass'
oordinals.WPPRINT.111='WPDevCClassData'
oordinals.WPPRINT.112='WPDevClassData'
oordinals.WPPRINT.113='WPDevNewClass'
oordinals.WPPRINT.114='WPPdrCClassData'
oordinals.WPPRINT.115='WPPdrClassData'
oordinals.WPPRINT.116='WPPdrNewClass'
oordinals.WPPRINT.117='WPLmCClassData'
oordinals.WPPRINT.118='WPLmClassData'
oordinals.WPPRINT.119='WPLmNewClass'
oordinals.WPPRINT.120='WPPortCClassData'
oordinals.WPPRINT.121='WPPortClassData'
oordinals.WPPRINT.122='WPPortNewClass'
oordinals.WPPRINT.123='WPQdrCClassData'
oordinals.WPPRINT.124='WPQdrClassData'
oordinals.WPPRINT.125='WPQdrNewClass'
oordinals.WPPRINT.126='WPQueueCClassData'
oordinals.WPPRINT.127='WPQueueClassData'
oordinals.WPPRINT.128='WPQueueNewClass'
oordinals.WPPRINT.129='WPSpoolCClassData'
oordinals.WPPRINT.130='WPSpoolClassData'
oordinals.WPPRINT.131='WPSpoolNewClass'
oordinals.WPPRINT.132='WPPrinterDriverCClassData'
oordinals.WPPRINT.133='WPPrinterDriverClassData'
oordinals.WPPRINT.134='WPPrinterDriverNewClass'
oordinals.WPPRINT.135='WPRPrinterCClassData'
oordinals.WPPRINT.136='WPRPrinterClassData'
oordinals.WPPRINT.137='WPRPrinterNewClass'
oordinals.WPPRINT.138='QueryNetworkPath'
oordinals.WPPRINT.139='DlgBeforePrint'
oordinals.WPPRINT.140='WPPrinterDriverPackedCClassData'
oordinals.WPPRINT.141='WPPrinterDriverPackedClassData'
oordinals.WPPRINT.142='WPPrinterDriverPackedNewClass'
oordinals.WPPRINT.143='M_WPPrinterCClassData'
oordinals.WPPRINT.144='M_WPPrinterClassData'
oordinals.WPPRINT.145='M_WPPrinterNewClass'
oordinals.WPPRINT.146='M_WPJobCClassData'
oordinals.WPPRINT.147='M_WPJobClassData'
oordinals.WPPRINT.148='M_WPJobNewClass'
oordinals.WPPRINT.149='M_WPPdrCClassData'
oordinals.WPPRINT.150='M_WPPdrClassData'
oordinals.WPPRINT.151='M_WPPdrNewClass'
oordinals.WPPRINT.152='M_WPPortCClassData'
oordinals.WPPRINT.153='M_WPPortClassData'
oordinals.WPPRINT.154='M_WPPortNewClass'
oordinals.WPPRINT.155='M_WPQdrCClassData'
oordinals.WPPRINT.156='M_WPQdrClassData'
oordinals.WPPRINT.157='M_WPQdrNewClass'
oordinals.WPPRINT.158='M_WPSpoolCClassData'
oordinals.WPPRINT.159='M_WPSpoolClassData'
oordinals.WPPRINT.160='M_WPSpoolNewClass'
oordinals.WPPRINT.161='M_WPRPrinterCClassData'
oordinals.WPPRINT.162='M_WPRPrinterClassData'
oordinals.WPPRINT.163='M_WPRPrinterNewClass'
return

