/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a VDM PDB */

signal on halt name haltexit

arg pdb .

if pdb='' then do
   address df 'cmd output .p#'
   o=output.0-1
   if word(output.o,13)<>'*vdm' then do
      say 'Current Process not a VDM'
      exit 0
   end /* do */
   pptda=word(output.o,9)
   pdb=getwords('%'pptda'+currentpdb-ptda_start',1)
   if datatype(pdb,'x') then do
      say 'Unable to locate CurrentPDB - please load kernel symbols'
      exit 0
   end /* do */
   pdb='&'pdb':0000'
end /* do */
if pos(':',pdb)=0 then pdb=pdb':0000'

say ' '
address df 'cmd output db' pdb
o=output.0-8
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+00 Exit_call (int 20)          ' p0||p1
say '+02 Block Length                ' p3||p2
say '+05 CPM_Call                    ' p5||p6||p7||p8||p9
say '+0a Exit                        ' pd||pc||pb||pa
cc=pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+0e Ctrl-C                      ' p1||p0||cc
say '+12 Fatal_Abort                 ' p5||p4||p3||p2
say '+16 Parent_PID                  ' p7||p6
jfn=p8 p9 pa pb pc pd pe pf
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+1a JFN_Table:                   '
say '    'jfn p0 p1 p2 p3 p4 p5 p6 p7 p8 p9 pa pb
say '+2c Environ                     ' pd||pc
say '+2e User_Stack SP               ' pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+30 User_Stack SS               ' p1||p0
say '+32 JFN_Length                  ' p3||p2
say '+34 JFN_Pointer                 ' '&'p7||p6':'p5||p4
say '+38 Next_PDB                    ' '&'pb||pa':'p9||p8
say '+3c InterCon                    ' pc
say '+3e Novell_used                 ' pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+40 Version                     ' p1||p0
say '+42 Chain                       ' p3||p2
say '+44 Partition                   ' p5||p4
say '+46 NextPDB                     ' p7||p6
say '+4c Entry_stack                 ' pf||pe||pd||pc
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+50 Call_system (int 21, retf)  ' p0 p1 p2 p3 p4
fcb=pc pd pe pf
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+5c 5C_FCB                      ' fcb p0 p1
fcb=pc pd pe pf
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+6c 6C_FCB:'
say '    'fcb p0 p1 p2 p3 p4 p5 p6 p7 p8 p9 pa pb pc pd pe pf
say '+80 Default DTA:'
address df 'cmd output db' pdb'+80'
o=output.0-8
do i=1 to 8
   say '   ' output.o
end /* do */

haltexit: exit 0



getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
