/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a RMP                                                      */
/* Change Log:                                                       */
/* 28/10/96 Version 1 created.                                       */
/* 09/05/97 ver 1.1 fixed possible acidental exponential comparison  */
/*                                                                   */

arg rmp .

signal on halt name haltexit
trace 'o'
numeric digits 12

if rmp='?' | rmp='' then do
   say 'Format a RMP header and records'
   say ''
   say 'Syntax: %rmp <rpmsel> | <rmphdl> | <rmpaddr> | <rmp>'
   say ''
   say '  where:  rmpsel  - is the selector for the rmp segment'
   say '          rmphdl  - is the dword rmp handle value'
   say '          rmpaddr - is the address of the rmp segment'
   say '          rmp     - specifies one of the following system RMPs:'
   say '                    DEV - Character Device Driver RMP'
   say '                    SPL - Spooler Device Driver RMP'
   say '                    SEG - Lockable/Discardable 16-bit Segment RMP'
   say '                    CDS - Current Directory Structure RMP'
   say '                    SEM - System Semaphore Names RMP'
   say '                    NPN - Named Pipe Names RMP'
   say '                    MEM - Named Shared Memory RMP'
   say ''
   exit 0
end /* do */

warning=0=0
dver=sysver()
parse var dver major minor rev kver krnl
if minor>=40 then do
   allstrict=(krnl='KNLD')
   /* we can use the anchor block to determine where various RMPs are */
   warning=0=1
   if rmp='NPN' then rmp=rmphdl('%(dw(%(dw(b0:28))+40))')
   else if rmp='DEV' then rmp=rmphdl('poi(b0:c)+bc')
   else if rmp='SPL' & allstrict then rmp=rmphdl('poi(b0:c)+e4')
   else if rmp='SPL' then rmp=rmphdl('poi(b0:c)+d8')
   else if rmp='SEG' then rmp=rmphdl('poi(b0:18)+8dc')
   else if rmp='CDS' then rmp=rmphdl('poi(b0:c)+78')
   else if rmp='SEM' then rmp=rmphdl('poi(b0:18)+629')
   else if rmp='MEM' then rmp=rmphdl('poi(b0:18)+8ea')
end /* do */
else do
   if rmp='NPN' then rmp=rmphdl('nmprmphand')
   else if rmp='DEV' then rmp=rmphdl('chardevrmprec')
   else if rmp='SPL' then rmp=rmphdl('spooldevrmprec')
   else if rmp='SEG' then rmp=rmphdl('hdiscsegrmpstruc')
   else if rmp='CDS' then rmp=rmphdl('cdsaddr')
   else if rmp='SEM' then rmp=rmphdl('syssemrmphdl')
   else if rmp='MEM' then rmp=rmphdl('sharermpstruc')
   else warning=0=1 /* warn if mnemonic used */
end /* do */

if warning then do
   say 'Warning: OS2KRNL Symbols assumed'
   say ''
end /* do */


parse var rmp rmp ':' .
if length(rmp)>4 then rmp=left(rmp,4)

say 'RMP Segment:             ' rmp
address df 'cmd output dw #'rmp':0 l0a'
o=output.0-2
if words(output.o)<9 then do
   say 'Unable to locate RMP'
   exit 0
end /* do */
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
sz=w0
fr=w1
fst=w2
lst=w3
hkh=w5||w4
pgf=w7||w6
o=o+1
parse var output.o . w0 w1 w2 w3 w4 w5 w6 w7 .
hobown=w0
hobmte=w1
if '#'hobown<>'#0000' then do
   address df 'cmd output .mo' hobown
   o=output.0-1
   owner=word(output.o,2)
end /* do */
else owner=''
if '#'hobmte<>'#0000' then do
   address df 'cmd output .mo' hobmte
   o=output.0-1
   module=word(output.o,2)
end /* do */
else module=''

say '+0000 RMP size:          ' sz
say '+0002 free space:        ' fr
say '+0004 First free record: ' fst
say '+0006 Last free record:  ' lst
say '+0008 Heap handle:       ' hkh
say '+000c Allocation flags:  ' pgf
say '+0010 RMP hob:           ' hobown owner
say '+0012 RMP hmte:          ' hobmte module

rec=20
say ' '
select
   when owner='mshrmp' then say 'Named Shared RMP records follow'
   when owner='syssemrmp' then say 'System Semaphore RMP records follow'
   when owner='chardevrmp' then say 'Character Device RMP records follow'
   when owner='spldevrmp' then say 'Spooler Device RMP records follow'
   when owner='cdsrmp' then say 'Current Directory Structure RMP records follow'
   when owner='discard' then say '16-bit Discardable/Lockable Segment RMP records follow'
   when owner='npipenpn' then say 'Named Pipe NPN RMP records follow'
otherwise
say 'RMP records follow'
end  /* select */
do i=1 by 1 while rec<x2d(sz)
   address df 'cmd output dw #'rmp':'rec't l1'
   o=output.0-1
   rlen=x2c(word(output.o,2))
   rfree=(bitand(rlen,'8000'x)='8000'x)
   if rfree then status='free'
   else status='in-use'
   rlen=c2x(bitand(rlen,'7fff'x))
   say ' '
   if rfree then do
      say '+'lower(d2x(rec,4)) 'Record:'i 'length=0x'lower(rlen) status
      select
         when owner='mshrmp' then call mshrmp rmp,rec,rlen
         when owner='syssemrmp' then call syssem rmp,rec,rlen
         when owner='chardevrmp' then call chardev rmp,rec,rlen
         when owner='spldevrmp' then call spooldev rmp,rec,rlen
         when owner='cdsrmp' then call cdsrmp rmp,rec,rlen
         when owner='discard' then call discard rmp,rec,rlen
         when owner='npipenpn' then call npipenpn rmp,rec,rlen
      otherwise
      call rmprec rmp,rec,rlen
      end  /* select */
   end /* do */
   else do
      address df 'cmd output dw #'rmp':'rec't+2 l2'
      o=output.0-1
      parse var output.o . prev next .
      say '+'lower(d2x(rec,4)) 'Record:'i 'length=0x'lower(rlen) status 'prev='prev 'next='next
   end /* do */
   rec=rec+x2d(rlen)
end /* do */

haltexit:

exit 0

mshrmp: procedure
parse arg rmp,rec,rlen
if '#'rlen='#0008' then do
   address df 'cmd output dw #'rmp':'rec't+2 l3'
   o=output.0-1
   parse var output.o . hptda hob refc .
   say '  local record: hptda='hptda 'hob='hob 'ref='refc
end /* do */
else do
   address df 'cmd output dw #'rmp':'rec't+2 l3'
   o=output.0-1
   parse var output.o . hob sel refc .
   address df 'cmd output da #'rmp':'rec't+8'
   o=output.0-1
   name = word(output.o,2)
   say '  global record: hob='hob 'sel='sel 'ref='refc name
end /* do */
return

syssem: procedure
parse arg rmp,rec,rlen
address df 'cmd output dw #'rmp':'rec't+2 l1'
o=output.0-1
off=word(output.o,2)
address df 'cmd output da #'rmp':'rec't+6'
o=output.0-1
name = word(output.o,2)
say '  Syssem table offset='off 'name=SEM'name
address df 'cmd output db #400:'off 'l6'
o=output.0-1
parse var output.o . s1 s2 fl rf rq .
flags=''
xfl=x2c(fl)
if bitand(xfl,'02'x)='02'x then flags= flags'mux waiting, '
if bitand(xfl,'01'x)='01'x then flags= flags'waiting, '
if bitand(xfl,'04'x)='04'x then flags= flags'pid/tid owner died, '
if bitand(xfl,'08'x)='08'x then flags= flags'exclusive, '
if bitand(xfl,'10'x)='10'x then flags= flags'remove, '
if bitand(xfl,'20'x)='20'x then flags= flags'tid owner dies, '
if bitand(xfl,'40'x)='40'x then flags= flags'exitlist owner, '
if length(flags)>2 then flags=left(flags,length(flags)-2)

say '  owing slot='s2||s1 'flag='fl 'ref='rf 'req='rq flags
return

chardev: procedure
parse arg rmp,rec,rlen
address df 'cmd output db #'rmp':'rec't+2 l0a'
o=output.0-1
parse var output.o . b1 b2 b3 b4 b5 b6 b7 b8 '-' b9 ba .
dsel=b4||b3
doff=b2||b1
dfsd=b8||b7||b6||b5
flg=b9
xf=x2c(flg)
if bitand(xf,'01'x)='01'x then flg=flg 'overlap,'
if bitand(xf,'02'x)='02'x then flg=flg 'attaching,'
if bitand(xf,'04'x)='04'x then flg=flg 'spooler dev,'
typ=ba
xt=x2c(typ)
if bitand(xt,'01'x)='01'x then typ=typ 'bimodal,'
if bitand(xt,'02'x)='02'x then typ=typ 'pseudo-dev,'
if bitand(xt,'04'x)='04'x then typ=typ 'real mode, '
if bitand(xt,'08'x)='04'x then typ=typ 'invisible,'
flg=strip(flg,'t',',')

address df 'cmd output da #'rmp':'rec't+2+0a'
o=output.0-1
name = word(output.o,2)
address df 'cmd output da #'rmp':'rec't+2+0a+'length(name)'t+1'
o=output.0-1
uname = word(output.o,2)

say '  dev='dsel':'doff 'fsd area='dfsd 'type='typ 'flags='flg
say '  search name='name
say '  attach name='uname
return

spooldev: procedure
parse arg rmp,rec,rlen
address df 'cmd output db #'rmp':'rec't+2 l7'
o=output.0-1
parse var output.o . b1 b2 b3 b4 b5 b6 b7 .
sfn=b2||b1
key=b6||b5||b4||b3
cb=b7

address df 'cmd output da #'rmp':'rec't+2+7'
o=output.0-1
name = word(output.o,2)

say '  npipe sfn='sfn 'attach key='key 'name len='cb name
return

cdsrmp: procedure
parse arg rmp,rec,rlen
address df 'cmd output .d cds #'rmp':'rec't+2'
do i=1 to output.0-1
   say '  'output.i
end /* do */
return

discard: procedure
parse arg rmp,rec,rlen
address df 'cmd output dw #'rmp':'rec't+2 l2'
o=output.0-1
parse var output.o . sel lc .
say '  selector='sel 'lock count='lc
return

npipenpn: procedure
parse arg rmp,rec,rlen
address df 'cmd output dw #'rmp':'rec't+2 l4'
o=output.0-1
parse var output.o . loff lsel key len .
address df 'cmd output da #'rmp':'rec't+2+8'
o=output.0-1
name=word(output.o,2)
say '  link='lsel':'loff 'key='key 'npnlen='len name
return

rmprec: procedure
parse arg rmp,rec,rlen
address df 'cmd output db #'rmp':'rec't+2 l'rlen'-2'
do j=1 to output.0-1
   say output.j
end /* do */
return

rmphdl: procedure
arg rh

address df 'cmd output dw' rh 'l2'
o=output.0-1
return word(output.o,3)

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')


sysver: procedure

segoff=getwords("#70:14",1)
iseg=getwords("#70:"segoff,1)
iseg="#"iseg":15"

address df 'cmd output db' iseg 'l10'
o=output.0-1
parse var output.o . major minor revision .
major=x2d(major)
minor=x2d(minor)
revision=x2d(revision)
if x2d(minor)>=40 then do
   address df 'cmd output db #b0:0 l0c'
   o=output.0-1
   parse var output.o . . . . . . . . .'-'h1 h2 h3 h4 . krnl .
   krnl=left(krnl,4)
   hdr=h4||h3':'h2||h1
   address df 'cmd output da #'hdr
   o=output.0-1
   parse var output.o . . krev',' .
end /* do */
else do
   krev=''
   krnl=''
end /* do */

return major minor revision krev krnl
getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor
