

trace 'o'
numeric digits 12

arg ptda


if (ptda='?' |,
   ptda='/?' |,
   ptda='/h' |,
   ptda='/H') then do
   say "Open Semaphores for ptda"
   say " "
   say 'Syntax: %sem ptda'
   say ' '
   say 'make sure OS2KRNL symbols are properly loaded '
   say ' '
   exit 0
end  /* Do */

if substr(ptda,1,1) <> '%' then ptda='%'||ptda
say '------------- ptda KSEM''s ------------------'
say
address df 'cmd output db ' ptda' + ptda_ptdasem -ptda_Start l8'
o=output.0-1
ptdasem  = word(output.o,1)
if ptdasem ='Expression' then do
      say 'Unable to locate ptda_ptdasem - please load kernel symbols'
      exit 0
   end /* do */

flags    = word(output.o,2)
type     = word(output.o,3)
owner    = word(output.o,5) || word(output.o,4)
pwriters = word(output.o,7) || word(output.o,6)
nest     = word(output.o,9) || word(output.o,8)
flagstr=''
if BITAND(flags,'01')='01' then flagstr='no interrupt '
if BITAND(flags,'02')='02' then flagstr='writer       '
if BITAND(flags,'04')='04' then flagstr='display id   '
if BITAND(flags,'08')='08' then flagstr='no block     '
typestr=''
if BITAND(type,'01')='00' then typestr='Event  KSEM '
if BITAND(type,'01')='01' then typestr='Mutex  KSEM '
if BITAND(type,'02')='02' then typestr='Shared KSEM '



say 'lin addr of intra thread ksem : ' || ptdasem
say 'Flags : ' || flags || '  ' || flagstr
say 'Type  : ' || type  || '  ' || typestr
say 'Owner          : ' || owner
say 'Pending writers: ' || pwriters
say 'Nested count   : ' || nest
say ' '

address df 'cmd output db ' ptda' + ptda_DLMsem -ptda_Start l8'
o=output.0-1
ptdasem  = word(output.o,1)
flags    = word(output.o,2)
type     = word(output.o,3)
owner    = word(output.o,5) || word(output.o,4)
pwriters = word(output.o,7) || word(output.o,6)
nest     = word(output.o,9) || word(output.o,8)
flagstr=''
if BITAND(flags,'01')='01' then flagstr='no interrupt '
if BITAND(flags,'02')='02' then flagstr='writer       '
if BITAND(flags,'04')='04' then flagstr='display id   '
if BITAND(flags,'08')='08' then flagstr='no block     '
typestr=''
if BITAND(type,'01')='00' then typestr='Event  KSEM '
if BITAND(type,'01')='01' then typestr='Mutex  KSEM '
if BITAND(type,'02')='02' then typestr='Shared KSEM '

say 'lin addr of inter thread ksem : ' || ptdasem
say 'Flags : ' || flags || '  ' || flagstr
say 'Type  : ' || type  || '  ' || typestr
say 'Owner          : ' || owner
say 'Pending writers: ' || pwriters
say 'Nested count   : ' || nest
say ' '


/*    getting all sys sems for that process */
say '----------- 16Bit-System Semaphores ---------------'
say
address df 'cmd output ln syssemdatatable'
o=output.0-1
syssemdatatable=word(output.o,1)
sel=substr(syssemdatatable,1,4)
offs=substr(syssemdatatable,6,8)
tempval=x2d(offs)
say 'SemHandle     SemAddr    slot  flags                refcnt    reqcnt '
do i= 0 to 255
  address df 'cmd output db ' ptda' + syssemptdatbl +'d2x(i)'-ptda_start l1'
  o=output.0-1
  byteVal=word(output.o,2)
  if x2d(byteval) = 1 then
  do
    offs= d2x(tempval+(6*i),4)
    address df 'cmd output db ' sel ':'offs' l6'
    o=output.0-1
    slot=word(output.o,3) ||word(output.o,2)
    slot=x2d(slot)
    slot=d2x(slot,4)
    sflag=word(output.o,4)
    srefcnt=word(output.o,5)
    reqcnt=word(output.o,6)
    semstatus=''
    if BITAND(sflag,'01')='00' then semstatus='unowned           '
    if BITAND(sflag,'01')='01' then semstatus='WAITING           '
    if BITAND(sflag,'02')='02' then semstatus='MUXWAITING        '
    if BITAND(sflag,'04')='04' then semstatus='OWNER DIED        '
    if BITAND(sflag,'08')='08' then semstatus='EXCLUSIVE         '
    if BITAND(sflag,'10')='10' then semstatus='REMOVE            '
    if BITAND(sflag,'20')='20' then semstatus='THREAD OWNER DIED '
    if BITAND(sflag,'40')='40' then semstatus='EXITLIST OWNER    '
    if BITAND(sflag,'40')> '40' then semstatus='unknown          '
    say   '0002'|| d2x(i,4) || '      '  ||  sel||':' || offs || '  ' || slot || '  ' || semstatus || '  ' srefcnt '      ' reqcnt
  end
end

say

/*    Getting all private 32 bit semaphores for that process  */
address df 'cmd output dd ' ptda' +pprsemtbl-ptda_start  l4'
o=output.0-1
pPrSemTbl    = word(output.o,2)
ulPrTblSize  = word(output.o,3)
ulPrTotUsed  = word(output.o,4)
ulPrNextFree = word(output.o,5)
address df 'cmd output dd ' ptda' +hksPrTbl-ptda_start l1'
o=output.0-1
hksPrTbl     = word(output.o,2)

say '---------------- Private 32Bit-Semaphores --------------------'
say
say 'ptr to private sem table     (pPrSemTbl)   : %'|| pPrSemTbl
say 'length table in dwords       (ulPrTblSize) : ' || ulPrTblSize
say 'number of entries in table   (ulPrTotUsed) : ' || ulPrTotUsed
say 'next free slot in table      (ulPrNextFree): ' || ulPrNextFree
say 'krnl sem handle for this table (hksPrTbl)  : ' || hksPrTbl
say

if (x2d(pPrSemtbl) > 0) & (x2d(ulPrTotUsed) > 0) then
do
  say 'SemHandle      SemAddr      SemType '
  do x=0 to x2d(ulPrTotUsed)-1
      address df 'cmd output dd %' pPrSemTbl '+4*'d2x(x) ' l1'
      o=output.0-1
      semaddr=word(output.o,2)
      name='Private '
      address df 'cmd output db %' semaddr 'l1'
      o=output.0-1
      ulattrib=word(output.o,2)
      if BITAND(ulattrib,'10')='10' then name = name || 'Event Sem  '
      if BiTAND(ulattrib,'08')='08' then name = name || 'Mutex Sem  '
      if BITAND(ulattrib,'20')='20' then name = name || 'MuxWait Sem'
      say d2x(x,8) || '   ' ||  semaddr || '   ' name
  end
end
say
say

address df 'cmd output dd ' ptda' +pshsembmp-ptda_start l4'
o=output.0-1
pshsembmp= word(output.o,2)
bitlength=word(output.o,3)
hksshbmp = word(output.o,4)
ulMtxOwned = word(output.o,5)
DwordCnt=x2d(bitlength) /32
bitlength =x2d(bitlength)

address df 'cmd output dd _pshsemtbl l1'
o=output.0-1
pshsemtbl=word(output.o,2)


binstr=''
if bitlength > 0 then
  do
      do x=0 to dwordcnt-1
      address df 'cmd output dd %' pshsembmp '+4*'d2x(x) ' l1'
      o=output.0-1
      tempval=word(output.o,2)
      tempstr=x2b(tempval)
      tempstr=reverse(tempstr)
      binstr=binstr||tempstr
    end

    say '---------------- Shared 32Bit-Semaphores --------------------'
    say
    say 'ptda ptr to process bitmap       (pShSembmp)  : %'|| pshsembmp
    say 'length of process bitmap in Bits (ulShBmpSize): ' || bitlength  || '(0x'd2x(bitlength,4)|| ')'
    say 'ptr to global shared sem table   (_pshsemtbl) : %'|| pshsemtbl
    say 'kernel sem handle for this table (hKsShBmp)   : ' || hksshbmp
    say 'Mutex Sem owned by this ptda     (ulMtxOwned) : ' || ulMtxOwned
    say
    say 'SemHandle    SemAddr     SemType       Name '

   do i= 1 to bitlength
      binchar =substr(binstr,i,1)


      if binchar='1'  then do


        address df 'cmd output dd %' pshsemtbl '+4*'d2x(i-1 ) 'l1'
        o=output.0-1
        semaddr=word(output.o,2)

        /* now getting type of sem */

        name='anonymous'
        address df 'cmd output db %' semaddr 'l1'
        o=output.0-1
        ulattrib=word(output.o,2)
        flagstr='   '
        if BITAND(ulattrib,'01')='01' then do
           if BITAND(ulattrib,'40')='40' then flagstr=flagstr || 'PM '
           if BITAND(ulattrib,'10')='10' then
           do
             flagstr=flagstr || 'Event Sem  '
             address df 'cmd output dd %' semaddr '+ 0c l1'
             o=output.0-1
             nameptr=word(output.o,2)
            if x2d(nameptr) <> 0 then
             do
               address df 'cmd output da %' nameptr
               o=output.0-1
               name=word(output.o,2)
             end
           end /* do */

           if BiTAND(ulattrib,'08')='08' then
            do
              flagstr=flagstr || 'Mutex Sem  '
              address df 'cmd output dd %' semaddr '+ 10 l1'
             o=output.0-1
             nameptr=word(output.o,2)
            if x2d(nameptr) <> 0 then
             do
               address df 'cmd output da %' nameptr
               o=output.0-1
               name=word(output.o,2)
             end
           end /* do */

           if BITAND(ulattrib,'20')='20' then
           do
             flagstr=flagstr || 'MuxWait Sem'
             address df 'cmd output dd %' semaddr '+ 0e l1'
             o=output.0-1
             nameptr=word(output.o,2)
            if x2d(nameptr) <> 0 then
             do
               address df 'cmd output da %' nameptr
               o=output.0-1
               name=word(output.o,2)
             end
           end /* do */

        end /* do */
        else flagstr='Not a shared sem!!'
        say '8001'||d2x(i-1,4) || '  ' || semaddr || '    ' || flagstr || '  ' || name
      end
   end
end
say






exit






