/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a WIN TDB */
signal on halt name haltexit

arg tdb .

if wininit()<>0 then exit 8

if tdb='' then tdb=value('DF_WDEFTDB',,'OS2ENVIRONMENT')
if pos(':',tdb)=0 then tdb=tdb':0000'

say ' '
address df 'cmd output db' tdb 'L100'
o=output.0-16
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+00 Next Task                   ' p1||p0
say '+02 Task SS:SP                  ' p5||p4':'p3||p2
say '+06 Number of Event             ' p7||p6
say '+08 Priority                    ' p8
say '+09 Thread Ordinal              ' p9
say '+0a Next Thread                 ' pb||pa
say '+0c Real TDB                    ' pd||pc
say '+0e Allocated thread list       ' pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+10 Free thread list            ' p1||p0
say '+12 Total thread structures     ' p3||p2
say '+14 FCW                         ' p5||p4
say '+16 Flags                       ' p6
say '+18 Error Mode                  ' p9||p8
say '+1a Window Version              ' pb||pa
say '+1c hInstance Data              ' pd||pc
say '+1e hExe                        ' pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+20 hQ                          ' p1||p0
say '+22 Parent TDB                  ' p3||p2
say '+24 Signal Action               ' p5||p4
say '+26 App Signal Proc             ' p9||p8':'p7||p6
say '+26 User Signal Proc            ' pd||pc':'pb||pa
gn=pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+2e Global Notify Discard Proc  ' p1||p0':'gn
say '+32 Task Interrup Vectors:      '
say '    Int  0:' p5||p4':'p3||p2
say '    Int  2:' p9||p8':'p7||p6
say '    Int  4:' pd||pc':'pb||pa
in=pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '    Int  6:' p1||p0':'in
say '    Int  7:' p5||p4':'p3||p2
say '    Int 3e:' p9||p8':'p7||p6
say '    Int 75:' pd||pc':'pb||pa
cf=pf||pe
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+4e Compatibility Flags         ' p1||p0||cf
say '+5b Library Add/Del             ' pb
say '+5c Private Handle Table        ' pf||pe':'pd||pc
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+60 PDB                         ' p1||p0
say '+65 DTA                         ' p5||p4':'p3||p2
say '+66 Current Drive               ' p6
address df 'cmd dir da' tdb'+67 l65'
x=dir.0-1
parse var dir.x . dir
say '+67 Current Directory:          ' dir
o=o+4
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+a8 Initial AX                  ' p9||p8
say '+aa Yield to                    ' pb||pa
say '+ac Addr of Libraries to init   ' pf||pe||pd||pc
o=o+1
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
say '+b0 Proc Instance Thunk selector' pb||p0
say '+b2 Proc Instance Thunks:       '
o=o+4
parse var output.o addr p0 p1 p2 p3 p4 p5 p6 p7'-'p8 p9 pa pb pc pd pe pf .
sig=pa pb
address df 'cmd output dw' tdb'+b2 L20'
o=output.0-4
do i=o to o+4
   parse var output.o . t
   say '   't
end /* do */
address df 'cmd output da' tdb'+f2 L9'
o=output.0-1
parse var output.o . mod
say '+f2 Module                      ' mod
say '+fa Signature (TD)              ' sig

haltexit: exit 0


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor


