/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format a WIN WND */
signal on halt name haltexit

arg wnd .

if wnd='' then do
   say 'WWND <pwnd>|<hwnd>'
   exit 0
end /* do */

if wininit()<>0 then exit 8

parse var wnd seg ':' off .

if off<>'' then call wfmtwnd(wnd)
else call wfmtwnd('#'userheap()':'wnd)

haltexit: exit 0


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor



wfmtwnd: procedure
arg pwnd

say ' '
address df 'cmd output dw' pwnd 'L1e'
o=output.0-4
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+00 Next                        ' w0
say '+02 Child                       ' w1
say '+04 Parent                      ' w2
say '+06 Owner                       ' w3
say '+08 Window Rectangle            ' '('w4','w5') ('w6','w7')'
o=o+1
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+10 Client Rectangle            ' '('w0','w1') ('w2','w3')'
say '+18 HQ                          ' w4
say '+1a HRGN Accumulated Paint Rgn  ' w5
say '+1c pCLS                        ' w6
say '+1e hInstance Data              ' w7
o=o+1
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+20 Window Procedure            ' w1':'w0
say '+24 State                       ' w3||w2
say '+28 Style                       ' w5||w4
say '+28 Extended style              ' w7||w6
o=o+1
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+30 hMenu                       ' w0
say '+32 hName                       ' w1
say '+34 Scroll                      ' w2
say '+36 hProgram Properties         ' w3
say '+38 hwnd Last Active Owner/ee   ' w4
say '+3a hSystem Menu                ' w5

return


userheap: procedure
huser=value('DF_WHUSER',,'OS2ENVIRONMENT')
segs=getwords('#'huser':1c',1)
segtab=getwords('#'huser':22',1)
hoff=((x2d(segs)-1)*10)+8+x2d(segtab)
return c2x(bitor(x2c(getwords('#'huser':'hoff't',1)),'0001'x))

