/**INTERNAL_ONLY**/
/*
 *  Change History:
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f00 F02359 MBB   93Nov11
 *   Add Net32 prototypes and internal-only structs; make all 'char' UCHAR
 *  @d01 D06991 MBB   94Apr09
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f02 F05438 MBB   94Aug08                                LS 4.0
 *   Make .h files compatible with C++
 */
/**END_INTERNAL**/

/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1993 **/
/** Copyright (c) Microsoft Corp., 1987-1990                       **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  MAILSLOT.H                                 *
 *                                                                  *
 *  This file contains information about the Mailslot APIs.         *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETMAILSLOT_INCLUDED

#define NETMAILSLOT_INCLUDED

#ifdef ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *               Function prototypes - Mailslot                 *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  DosMakeMailslot ( const unsigned char LSFAR * pszName,
                    unsigned short              cbMessageSize,
                    unsigned short              cbMailslotSize,
                    unsigned LSINT LSFAR *      phMailslot );

extern API_FUNCTION
  DosDeleteMailslot ( unsigned LSINT hMailslot );

extern API_FUNCTION
  DosMailslotInfo ( unsigned LSINT         hMailslot,
                    unsigned short LSFAR * pcbMessageSize,
                    unsigned short LSFAR * pcbMailslotSize,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority,
                    unsigned short LSFAR * pcMessages);

extern API_FUNCTION
  DosPeekMailslot ( unsigned  LSINT        hMailslot,
                    unsigned char LSFAR *  pbBuffer,
                    unsigned short LSFAR * pcbReturned,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority );

extern API_FUNCTION
  DosReadMailslot ( unsigned  LSINT        hMailslot,
                    unsigned char LSFAR *  pbBuffer,
                    unsigned short LSFAR * pcbReturned,
                    unsigned short LSFAR * pcbNextSize,
                    unsigned short LSFAR * pusNextPriority,
                    long                   cTimeout );

extern API_FUNCTION
  DosWriteMailslot ( const unsigned char LSFAR * pszName,
                     const unsigned char LSFAR * pbBuffer,
                     unsigned short              cbBuffer,
                     unsigned short              usPriority,
                     unsigned short              usClass,
                     long                        cTimeout );


/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *               Function prototypes - Mailslot                 *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
Dos32MakeMailslot ( const unsigned char * pszName,
                    unsigned long         ulMessageSize,  /* was USHORT*/
                    unsigned long         ulMailslotSize, /* was USHORT*/
                    unsigned long       * phMailslot );  /* was unsigned LSINT*/

extern API32_FUNCTION
Dos32DeleteMailslot ( unsigned long  hMailslot );

extern API32_FUNCTION
Dos32MailslotInfo ( unsigned long    hMailslot,        /* was unsigned LSINT */
                    unsigned long  * pulMessageSize,   /* was USHORT */
                    unsigned long  * pulMailslotSize,  /* was USHORT */
                    unsigned long  * pulNextSize,      /* was USHORT */
                    unsigned long  * pulNextPriority,  /* was USHORT */
                    unsigned long  * pulMessages);     /* was USHORT */

extern API32_FUNCTION
Dos32PeekMailslot ( unsigned long    hMailslot,        /* was unsigned LSINT */
                    unsigned char  * pbBuffer,
                    unsigned long  * pulReturned,      /* was USHORT */
                    unsigned long  * pulNextSize,      /* was USHORT */
                    unsigned long  * pulNextPriority); /* was USHORT */

extern API32_FUNCTION
Dos32ReadMailslot ( unsigned long    hMailslot,        /* was unsigned LSINT */
                    unsigned char  * pbBuffer,
                    unsigned long  * pulReturned,      /* was USHORT */
                    unsigned long  * pulNextSize,      /* was USHORT */
                    unsigned long  * pulNextPriority,  /* was USHORT */
                    long             lTimeout );

extern API32_FUNCTION
Dos32WriteMailslot ( const unsigned char * pszName,
                     const unsigned char * pbBuffer,
                     unsigned long         ulBuffer,     /* was USHORT */
                     unsigned long         ulPriority,   /* was USHORT */
                     unsigned long         ulClass,      /* was USHORT */
                     long                  lTimeout );
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32; no data structures to pick up */
#undef PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants - Mailslot         *
 *                                                              *
 ****************************************************************/

#define MAILSLOT_NO_TIMEOUT     -1

/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif

#endif /* NETMAILSLOT_INCLUDED */

/*INC*/
