/**INTERNAL_ONLY**/
#ifdef DEKKO

extern unsigned far pascal  DOSSYSTRACE(unsigned short, unsigned short, unsigned short, char far *);
extern unsigned short far *dekko_addr;
extern unsigned char far *pmm_systrace;

#define PDEKKO 0x4A
#define PSYSTRACEBUF 0x26
#define MMFLAG 0x40u
#define DEKKO_DATA 4

/*---------------------------------------------------------------------------*/
/*         Macros to test SYSTRACE flag.                                     */
/*---------------------------------------------------------------------------*/

#define SYSTRACE_FLAG_BYTE(mh) (mh / 8)
#define SYSTRACE_FLAG_BIT(mh)   (0x80u >> (mh % 8))
#define SYSTRACE_ON(mh)   \
  SYSTRACE_FLAG_BIT(mh) & *(pmm_systrace+SYSTRACE_FLAG_BYTE(mh))

/*---------------------------------------------------------------------------*/
/*    Pointer to Global Info Segment (global variable in DLL init routine).  */
/*---------------------------------------------------------------------------*/

#define PTRACEVARIABLES                    \
        unsigned short  far *dekko_addr;    \
        unsigned char  far *pmm_systrace;   \
        unsigned char  far  dummy_tracebuf[32];

/*---------------------------------------------------------------------------*/
/*                                                                           */
/*         Macro definitions for systrace and performance hooks              */
/*                                                                           */
/*---------------------------------------------------------------------------*/

#define INITTRACEVARIABLES                                    \
        SEL global_seg, local_seg ;                           \
        if (!DosGetInfoSeg( &global_seg, &local_seg))         \
        {                                                     \
           pmm_systrace = MAKEP(global_seg, PSYSTRACEBUF);    \
           dekko_addr = (MAKEP(global_seg, PDEKKO));          \
            /* use the dekko offset in globalinfoseg */       \
           dekko_addr = (MAKEP(*dekko_addr, 4));              \
        } else                                                \
        {                                                     \
          pmm_systrace = dummy_tracebuf;                      \
        }

#define DEK_D0(mh,mn)                                     \
        if (SYSTRACE_ON(mh))                              \
         { if (*pmm_systrace & MMFLAG)                    \
            {  *(dekko_addr) = ((mh) << 8) | (mn);        \
               *(dekko_addr+DEKKO_DATA) = 0x0000;  }      \
           else                                           \
            { DOSSYSTRACE((mh), 0, (mn), 0l); } }

#define DEK_D0_ENTRY(mh,mn)  DEK_D0((mh),(mn))
#define DEK_D0_EXIT(mh,mn)   DEK_D0((mh),((mn)|0x80u))

/*---------------------------------------------------------------------------*/
/*         Net API label definitions.                                        */
/*---------------------------------------------------------------------------*/

  #define DEK_NET_API                      0x9c     /* LS netapi major code */

/* LS net api's                                                             */

  #define DEK_NETACCESSADD                 1
  #define DEK_NETACCESSCHECK               2
  #define DEK_NETACCESSDEL                 3
  #define DEK_NETACCESSENUM                4
  #define DEK_NETACCESSGETINFO             5
  #define DEK_NETACCESSGETUSERPERMS        6
  #define DEK_NETACCESSSETINFO             7
  #define DEK_NETALERTRAISE                8
  #define DEK_NETALERTENTRY                9
  #define DEK_NETALERTSTOP                10
  #define DEK_NETAUDITCLEAR               11
  #define DEK_NETAUDITREAD                12
  #define DEK_NETAUDITWRITE               13
  #define DEK_NETCONFIGGET2               14
  #define DEK_NETCONFIGGETALL2            15
  #define DEK_NETCONNECTIONENUM           16
  #define DEK_NETGETDCNAME                17
  #define DEK_NETLOGONENUM                18
  #define DEK_NETERRORLOGCLEAR            19
  #define DEK_NETERRORLOGREAD             20
  #define DEK_NETERRORLOGWRITE            21
  #define DEK_NETFILECLOSE2               22
  #define DEK_NETFILEENUM2                23
  #define DEK_NETFILEGETINFO2             24
  #define DEK_NETGROUPADD                 25
  #define DEK_NETGROUPADDUSER             26
  #define DEK_NETGROUPDEL                 27
  #define DEK_NETGROUPDELUSER             28
  #define DEK_NETGROUPENUM                29
  #define DEK_NETGROUPGETINFO             30
  #define DEK_NETGROUPGETUSERS            31
  #define DEK_NETGROUPSETINFO             32
  #define DEK_NETGROUPSETUSERS            33
  #define DEK_NETHANDLEGETINFO            34
  #define DEK_NETHANDLESETINFO            35
  #define DEK_NETMESSAGEBUFFERSEND        36
  #define DEK_NETMESSAGEFILESEND          37
  #define DEK_NETMESSAGELOGFILEGET        38
  #define DEK_NETMESSAGELOGFILESET        39
  #define DEK_NETMESSAGENAMEADD           40
  #define DEK_NETMESSAGENAMEDEL           41
  #define DEK_NETMESSAGENAMEENUM          42
  #define DEK_NETMESSAGENAMEFWD           43
  #define DEK_NETMESSAGENAMEGETINFO       44
  #define DEK_NETMESSAGENAMEUNFWD         45
  #define DEK_NETREMOTECOPY               46
  #define DEK_NETREMOTEEXEC               47
  #define DEK_NETREMOTEMOVE               48
  #define DEK_NETREMOTETOD                49
  #define DEK_NETWKSTAGETINFO             50
  #define DEK_NETWKSTASETINFO             51
  #define DEK_NETWKSTASETUID2             52
  #define DEK_NETCHARDEVCONTROL           53
  #define DEK_NETCHARDEVENUM              54
  #define DEK_NETCHARDEVGETINFO           55
  #define DEK_NETCHARDEVQENUM             56
  #define DEK_NETCHARDEVQGETINFO          57
  #define DEK_NETCHARDEVQPURGE            58
  #define DEK_NETCHARDEVQPURGESELF        59
  #define DEK_NETCHARDEVQSETINFO          60
  #define DEK_NETSERVERADMINCOMMAND       61
  #define DEK_NETSERVERDISKENUM           62
  #define DEK_NETSERVERENUM2              63
  #define DEK_NETSERVERGETINFO            64
  #define DEK_NETSERVERSETINFO            65
  #define DEK_NETSERVICECONTROL           66
  #define DEK_NETSERVICEENUM              67
  #define DEK_NETSERVICEGETINFO           68
  #define DEK_NETSERVICEINSTALL           69
  #define DEK_NETSERVICESTATUS            70
  #define DEK_NETSESSIONDEL               71
  #define DEK_NETSESSIONENUM              72
  #define DEK_NETSESSIONGETINFO           73
  #define DEK_NETSHAREADD                 74
  #define DEK_NETSHARECHECK               75
  #define DEK_NETSHAREDEL                 76
  #define DEK_NETSHAREENUM                77
  #define DEK_NETSHAREGETINFO             78
  #define DEK_NETSHARESETINFO             79
  #define DEK_NETSTATISTICSGET2           80
  #define DEK_NETUSEADD                   81
  #define DEK_NETUSEDEL                   82
  #define DEK_NETUSEENUM                  83
  #define DEK_NETUSEGETINFO               84
  #define DEK_NETUSERADD                  85
  #define DEK_NETUSERDEL                  86
  #define DEK_NETUSERENUM                 87
  #define DEK_NETUSERGETGROUPS            88
  #define DEK_NETUSERGETINFO              89
  #define DEK_NETUSERINIT                 90
  #define DEK_NETUSERMODALSGET            91
  #define DEK_NETUSERMODALSSET            92
  #define DEK_NETUSERPASSWORDSET          93
  #define DEK_NETUSERSETGROUPS            94
  #define DEK_NETUSERSETINFO              95
  #define DEK_NETUSERVALIDATE2            96
  #define DEK_NETALERTSTART               97
  #define DEK_NETUSERVALIDATE             98
  #define DEK_NETWKSTAUSERLOGON           99
  #define DEK_NETWKSTAUSERLOGOFF         100
  #define DEK_NETWKSTAUSERLOGON2         101
  #define DEK_NETWKSTAUSERLOGOFF2        102
  #define DEK_NETACCESSAPPLY             103


  #define  DEK_ENTRY_NETACCESSADD       DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSADD)
  #define  DEK_ENTRY_NETACCESSCHECK     DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSCHECK)
  #define  DEK_ENTRY_NETACCESSDEL       DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSDEL)
  #define  DEK_ENTRY_NETACCESSENUM      DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSENUM)
  #define  DEK_ENTRY_NETACCESSGETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSGETINFO)
  #define  DEK_ENTRY_NETACCESSGETUSERPERMS DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSGETUSERPERMS)
  #define  DEK_ENTRY_NETACCESSSETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSSETINFO)
  #define  DEK_ENTRY_NETALERTRAISE      DEK_D0_ENTRY(DEK_NET_API, DEK_NETALERTRAISE)
  #define  DEK_ENTRY_NETALERTENTRY      DEK_D0_ENTRY(DEK_NET_API, DEK_NETALERTENTRY)
  #define  DEK_ENTRY_NETALERTSTOP       DEK_D0_ENTRY(DEK_NET_API, DEK_NETALERTSTOP)
  #define  DEK_ENTRY_NETALERTSTART      DEK_D0_ENTRY(DEK_NET_API, DEK_NETALERTSTART)
  #define  DEK_ENTRY_NETAUDITCLEAR      DEK_D0_ENTRY(DEK_NET_API, DEK_NETAUDITCLEAR)
  #define  DEK_ENTRY_NETAUDITREAD       DEK_D0_ENTRY(DEK_NET_API, DEK_NETAUDITREAD)
  #define  DEK_ENTRY_NETAUDITWRITE      DEK_D0_ENTRY(DEK_NET_API, DEK_NETAUDITWRITE)
  #define  DEK_ENTRY_NETCONFIGGET2      DEK_D0_ENTRY(DEK_NET_API, DEK_NETCONFIGGET2)
  #define  DEK_ENTRY_NETCONFIGGETALL2   DEK_D0_ENTRY(DEK_NET_API, DEK_NETCONFIGGETALL2)
  #define  DEK_ENTRY_NETCONNECTIONENUM  DEK_D0_ENTRY(DEK_NET_API, DEK_NETCONNECTIONENUM)
  #define  DEK_ENTRY_NETGETDCNAME       DEK_D0_ENTRY(DEK_NET_API, DEK_NETGETDCNAME)
  #define  DEK_ENTRY_NETLOGONENUM       DEK_D0_ENTRY(DEK_NET_API, DEK_NETLOGONENUM)
  #define  DEK_ENTRY_NETERRORLOGCLEAR   DEK_D0_ENTRY(DEK_NET_API, DEK_NETERRORLOGCLEAR)
  #define  DEK_ENTRY_NETERRORLOGREAD    DEK_D0_ENTRY(DEK_NET_API, DEK_NETERRORLOGREAD)
  #define  DEK_ENTRY_NETERRORLOGWRITE   DEK_D0_ENTRY(DEK_NET_API, DEK_NETERRORLOGWRITE)
  #define  DEK_ENTRY_NETFILECLOSE2      DEK_D0_ENTRY(DEK_NET_API, DEK_NETFILECLOSE2)
  #define  DEK_ENTRY_NETFILEENUM2       DEK_D0_ENTRY(DEK_NET_API, DEK_NETFILEENUM2)
  #define  DEK_ENTRY_NETFILEGETINFO2    DEK_D0_ENTRY(DEK_NET_API, DEK_NETFILEGETINFO2)
  #define  DEK_ENTRY_NETGROUPADD        DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPADD)
  #define  DEK_ENTRY_NETGROUPADDUSER    DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPADDUSER)
  #define  DEK_ENTRY_NETGROUPDEL        DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPDEL)
  #define  DEK_ENTRY_NETGROUPDELUSER    DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPDELUSER)
  #define  DEK_ENTRY_NETGROUPENUM       DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPENUM)
  #define  DEK_ENTRY_NETGROUPGETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPGETINFO)
  #define  DEK_ENTRY_NETGROUPGETUSERS   DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPGETUSERS)
  #define  DEK_ENTRY_NETGROUPSETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPSETINFO)
  #define  DEK_ENTRY_NETGROUPSETUSERS   DEK_D0_ENTRY(DEK_NET_API, DEK_NETGROUPSETUSERS)
  #define  DEK_ENTRY_NETHANDLEGETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETHANDLEGETINFO)
  #define  DEK_ENTRY_NETHANDLESETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETHANDLESETINFO)
  #define  DEK_ENTRY_NETMESSAGEBUFFERSEND DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGEBUFFERSEND)
  #define  DEK_ENTRY_NETMESSAGEFILESEND DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGEFILESEND)
  #define  DEK_ENTRY_NETMESSAGELOGFILEGET DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGELOGFILEGET)
  #define  DEK_ENTRY_NETMESSAGELOGFILESET DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGELOGFILESET)
  #define  DEK_ENTRY_NETMESSAGENAMEADD  DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEADD)
  #define  DEK_ENTRY_NETMESSAGENAMEDEL  DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEDEL)
  #define  DEK_ENTRY_NETMESSAGENAMEENUM DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEENUM)
  #define  DEK_ENTRY_NETMESSAGENAMEFWD  DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEFWD)
  #define  DEK_ENTRY_NETMESSAGENAMEGETINFO DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEGETINFO)
  #define  DEK_ENTRY_NETMESSAGENAMEUNFWD DEK_D0_ENTRY(DEK_NET_API, DEK_NETMESSAGENAMEUNFWD)
  #define  DEK_ENTRY_NETREMOTECOPY      DEK_D0_ENTRY(DEK_NET_API, DEK_NETREMOTECOPY)
  #define  DEK_ENTRY_NETREMOTEEXEC      DEK_D0_ENTRY(DEK_NET_API, DEK_NETREMOTEEXEC)
  #define  DEK_ENTRY_NETREMOTEMOVE      DEK_D0_ENTRY(DEK_NET_API, DEK_NETREMOTEMOVE)
  #define  DEK_ENTRY_NETREMOTETOD       DEK_D0_ENTRY(DEK_NET_API, DEK_NETREMOTETOD)
  #define  DEK_ENTRY_NETWKSTAGETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTAGETINFO)
  #define  DEK_ENTRY_NETWKSTASETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTASETINFO)
  #define  DEK_ENTRY_NETWKSTASETUID2    DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTASETUID2)
  #define  DEK_ENTRY_NETCHARDEVCONTROL  DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVCONTROL)
  #define  DEK_ENTRY_NETCHARDEVENUM     DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVENUM)
  #define  DEK_ENTRY_NETCHARDEVGETINFO  DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVGETINFO)
  #define  DEK_ENTRY_NETCHARDEVQENUM    DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVQENUM)
  #define  DEK_ENTRY_NETCHARDEVQGETINFO DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVQGETINFO)
  #define  DEK_ENTRY_NETCHARDEVQPURGE   DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVQPURGE)
  #define  DEK_ENTRY_NETCHARDEVQPURGESELF DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVQPURGESELF)
  #define  DEK_ENTRY_NETCHARDEVQSETINFO DEK_D0_ENTRY(DEK_NET_API, DEK_NETCHARDEVQSETINFO)
  #define  DEK_ENTRY_NETSERVERADMINCOMMAND DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVERADMINCOMMAND)
  #define  DEK_ENTRY_NETSERVERDISKENUM  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVERDISKENUM)
  #define  DEK_ENTRY_NETSERVERENUM2     DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVERENUM2)
  #define  DEK_ENTRY_NETSERVERGETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVERGETINFO)
  #define  DEK_ENTRY_NETSERVERSETINFO   DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVERSETINFO)
  #define  DEK_ENTRY_NETSERVICECONTROL  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVICECONTROL)
  #define  DEK_ENTRY_NETSERVICEENUM     DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVICEENUM)
  #define  DEK_ENTRY_NETSERVICEGETINFO  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVICEGETINFO)
  #define  DEK_ENTRY_NETSERVICEINSTALL  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVICEINSTALL)
  #define  DEK_ENTRY_NETSERVICESTATUS   DEK_D0_ENTRY(DEK_NET_API, DEK_NETSERVICESTATUS)
  #define  DEK_ENTRY_NETSESSIONDEL      DEK_D0_ENTRY(DEK_NET_API, DEK_NETSESSIONDEL)
  #define  DEK_ENTRY_NETSESSIONENUM     DEK_D0_ENTRY(DEK_NET_API, DEK_NETSESSIONENUM)
  #define  DEK_ENTRY_NETSESSIONGETINFO  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSESSIONGETINFO)
  #define  DEK_ENTRY_NETSHAREADD        DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHAREADD)
  #define  DEK_ENTRY_NETSHARECHECK      DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHARECHECK)
  #define  DEK_ENTRY_NETSHAREDEL        DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHAREDEL)
  #define  DEK_ENTRY_NETSHAREENUM       DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHAREENUM)
  #define  DEK_ENTRY_NETSHAREGETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHAREGETINFO)
  #define  DEK_ENTRY_NETSHARESETINFO    DEK_D0_ENTRY(DEK_NET_API, DEK_NETSHARESETINFO)
  #define  DEK_ENTRY_NETSTATISTICSGET2  DEK_D0_ENTRY(DEK_NET_API, DEK_NETSTATISTICSGET2)
  #define  DEK_ENTRY_NETUSEADD          DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSEADD)
  #define  DEK_ENTRY_NETUSEDEL          DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSEDEL)
  #define  DEK_ENTRY_NETUSEENUM         DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSEENUM)
  #define  DEK_ENTRY_NETUSEGETINFO      DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSEGETINFO)
  #define  DEK_ENTRY_NETUSERADD         DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERADD)
  #define  DEK_ENTRY_NETUSERDEL         DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERDEL)
  #define  DEK_ENTRY_NETUSERENUM        DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERENUM)
  #define  DEK_ENTRY_NETUSERGETGROUPS   DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERGETGROUPS)
  #define  DEK_ENTRY_NETUSERGETINFO     DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERGETINFO)
  #define  DEK_ENTRY_NETUSERINIT        DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERINIT)
  #define  DEK_ENTRY_NETUSERMODALSGET   DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERMODALSGET)
  #define  DEK_ENTRY_NETUSERMODALSSET   DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERMODALSSET)
  #define  DEK_ENTRY_NETUSERPASSWORDSET DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERPASSWORDSET)
  #define  DEK_ENTRY_NETUSERSETGROUPS   DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERSETGROUPS)
  #define  DEK_ENTRY_NETUSERSETINFO     DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERSETINFO)
  #define  DEK_ENTRY_NETUSERVALIDATE2   DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERVALIDATE2)
  #define  DEK_ENTRY_NETUSERVALIDATE    DEK_D0_ENTRY(DEK_NET_API, DEK_NETUSERVALIDATE)
  #define  DEK_ENTRY_NETWKSTAUSERLOGON        DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTAUSERLOGON)
  #define  DEK_ENTRY_NETWKSTAUSERLOGOFF       DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTAUSERLOGOFF)
  #define  DEK_ENTRY_NETWKSTAUSERLOGON2       DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTAUSERLOGON2)
  #define  DEK_ENTRY_NETWKSTAUSERLOGOFF2      DEK_D0_ENTRY(DEK_NET_API, DEK_NETWKSTAUSERLOGOFF2)
  #define  DEK_ENTRY_NETACCESSAPPLY           DEK_D0_ENTRY(DEK_NET_API, DEK_NETACCESSAPPLY)



  #define  DEK_EXIT_NETACCESSADD       DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSADD)
  #define  DEK_EXIT_NETACCESSCHECK     DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSCHECK)
  #define  DEK_EXIT_NETACCESSDEL       DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSDEL)
  #define  DEK_EXIT_NETACCESSENUM      DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSENUM)
  #define  DEK_EXIT_NETACCESSGETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSGETINFO)
  #define  DEK_EXIT_NETACCESSGETUSERPERMS DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSGETUSERPERMS)
  #define  DEK_EXIT_NETACCESSSETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSSETINFO)
  #define  DEK_EXIT_NETALERTRAISE      DEK_D0_EXIT(DEK_NET_API, DEK_NETALERTRAISE)
  #define  DEK_EXIT_NETALERTENTRY     DEK_D0_EXIT(DEK_NET_API, DEK_NETALERTENTRY)
  #define  DEK_EXIT_NETALERTSTOP      DEK_D0_EXIT(DEK_NET_API, DEK_NETALERTSTOP)
  #define  DEK_EXIT_NETALERTSTART     DEK_D0_EXIT(DEK_NET_API, DEK_NETALERTSTART)
  #define  DEK_EXIT_NETAUDITCLEAR      DEK_D0_EXIT(DEK_NET_API, DEK_NETAUDITCLEAR)
  #define  DEK_EXIT_NETAUDITREAD       DEK_D0_EXIT(DEK_NET_API, DEK_NETAUDITREAD)
  #define  DEK_EXIT_NETAUDITWRITE      DEK_D0_EXIT(DEK_NET_API, DEK_NETAUDITWRITE)
  #define  DEK_EXIT_NETCONFIGGET2      DEK_D0_EXIT(DEK_NET_API, DEK_NETCONFIGGET2)
  #define  DEK_EXIT_NETCONFIGGETALL2   DEK_D0_EXIT(DEK_NET_API, DEK_NETCONFIGGETALL2)
  #define  DEK_EXIT_NETCONNECTIONENUM  DEK_D0_EXIT(DEK_NET_API, DEK_NETCONNECTIONENUM)
  #define  DEK_EXIT_NETGETDCNAME       DEK_D0_EXIT(DEK_NET_API, DEK_NETGETDCNAME)
  #define  DEK_EXIT_NETLOGONENUM       DEK_D0_EXIT(DEK_NET_API, DEK_NETLOGONENUM)
  #define  DEK_EXIT_NETERRORLOGCLEAR   DEK_D0_EXIT(DEK_NET_API, DEK_NETERRORLOGCLEAR)
  #define  DEK_EXIT_NETERRORLOGREAD    DEK_D0_EXIT(DEK_NET_API, DEK_NETERRORLOGREAD)
  #define  DEK_EXIT_NETERRORLOGWRITE   DEK_D0_EXIT(DEK_NET_API, DEK_NETERRORLOGWRITE)
  #define  DEK_EXIT_NETFILECLOSE2      DEK_D0_EXIT(DEK_NET_API, DEK_NETFILECLOSE2)
  #define  DEK_EXIT_NETFILEENUM2       DEK_D0_EXIT(DEK_NET_API, DEK_NETFILEENUM2)
  #define  DEK_EXIT_NETFILEGETINFO2    DEK_D0_EXIT(DEK_NET_API, DEK_NETFILEGETINFO2)
  #define  DEK_EXIT_NETGROUPADD        DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPADD)
  #define  DEK_EXIT_NETGROUPADDUSER    DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPADDUSER)
  #define  DEK_EXIT_NETGROUPDEL        DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPDEL)
  #define  DEK_EXIT_NETGROUPDELUSER    DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPDELUSER)
  #define  DEK_EXIT_NETGROUPENUM       DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPENUM)
  #define  DEK_EXIT_NETGROUPGETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPGETINFO)
  #define  DEK_EXIT_NETGROUPGETUSERS   DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPGETUSERS)
  #define  DEK_EXIT_NETGROUPSETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPSETINFO)
  #define  DEK_EXIT_NETGROUPSETUSERS   DEK_D0_EXIT(DEK_NET_API, DEK_NETGROUPSETUSERS)
  #define  DEK_EXIT_NETHANDLEGETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETHANDLEGETINFO)
  #define  DEK_EXIT_NETHANDLESETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETHANDLESETINFO)
  #define  DEK_EXIT_NETMESSAGEBUFFERSEND DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGEBUFFERSEND)
  #define  DEK_EXIT_NETMESSAGEFILESEND DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGEFILESEND)
  #define  DEK_EXIT_NETMESSAGELOGFILEGET DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGELOGFILEGET)
  #define  DEK_EXIT_NETMESSAGELOGFILESET DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGELOGFILESET)
  #define  DEK_EXIT_NETMESSAGENAMEADD  DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEADD)
  #define  DEK_EXIT_NETMESSAGENAMEDEL  DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEDEL)
  #define  DEK_EXIT_NETMESSAGENAMEENUM DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEENUM)
  #define  DEK_EXIT_NETMESSAGENAMEFWD  DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEFWD)
  #define  DEK_EXIT_NETMESSAGENAMEGETINFO DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEGETINFO)
  #define  DEK_EXIT_NETMESSAGENAMEUNFWD DEK_D0_EXIT(DEK_NET_API, DEK_NETMESSAGENAMEUNFWD)
  #define  DEK_EXIT_NETREMOTECOPY      DEK_D0_EXIT(DEK_NET_API, DEK_NETREMOTECOPY)
  #define  DEK_EXIT_NETREMOTEEXEC      DEK_D0_EXIT(DEK_NET_API, DEK_NETREMOTEEXEC)
  #define  DEK_EXIT_NETREMOTEMOVE      DEK_D0_EXIT(DEK_NET_API, DEK_NETREMOTEMOVE)
  #define  DEK_EXIT_NETREMOTETOD       DEK_D0_EXIT(DEK_NET_API, DEK_NETREMOTETOD)
  #define  DEK_EXIT_NETWKSTAGETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTAGETINFO)
  #define  DEK_EXIT_NETWKSTASETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTASETINFO)
  #define  DEK_EXIT_NETWKSTASETUID2    DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTASETUID2)
  #define  DEK_EXIT_NETCHARDEVCONTROL  DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVCONTROL)
  #define  DEK_EXIT_NETCHARDEVENUM     DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVENUM)
  #define  DEK_EXIT_NETCHARDEVGETINFO  DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVGETINFO)
  #define  DEK_EXIT_NETCHARDEVQENUM    DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVQENUM)
  #define  DEK_EXIT_NETCHARDEVQGETINFO DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVQGETINFO)
  #define  DEK_EXIT_NETCHARDEVQPURGE   DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVQPURGE)
  #define  DEK_EXIT_NETCHARDEVQPURGESELF DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVQPURGESELF)
  #define  DEK_EXIT_NETCHARDEVQSETINFO DEK_D0_EXIT(DEK_NET_API, DEK_NETCHARDEVQSETINFO)
  #define  DEK_EXIT_NETSERVERADMINCOMMAND DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVERADMINCOMMAND)
  #define  DEK_EXIT_NETSERVERDISKENUM  DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVERDISKENUM)
  #define  DEK_EXIT_NETSERVERENUM2     DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVERENUM2)
  #define  DEK_EXIT_NETSERVERGETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVERGETINFO)
  #define  DEK_EXIT_NETSERVERSETINFO   DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVERSETINFO)
  #define  DEK_EXIT_NETSERVICECONTROL  DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVICECONTROL)
  #define  DEK_EXIT_NETSERVICEENUM     DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVICEENUM)
  #define  DEK_EXIT_NETSERVICEGETINFO  DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVICEGETINFO)
  #define  DEK_EXIT_NETSERVICEINSTALL  DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVICEINSTALL)
  #define  DEK_EXIT_NETSERVICESTATUS   DEK_D0_EXIT(DEK_NET_API, DEK_NETSERVICESTATUS)
  #define  DEK_EXIT_NETSESSIONDEL      DEK_D0_EXIT(DEK_NET_API, DEK_NETSESSIONDEL)
  #define  DEK_EXIT_NETSESSIONENUM     DEK_D0_EXIT(DEK_NET_API, DEK_NETSESSIONENUM)
  #define  DEK_EXIT_NETSESSIONGETINFO  DEK_D0_EXIT(DEK_NET_API, DEK_NETSESSIONGETINFO)
  #define  DEK_EXIT_NETSHAREADD        DEK_D0_EXIT(DEK_NET_API, DEK_NETSHAREADD)
  #define  DEK_EXIT_NETSHARECHECK      DEK_D0_EXIT(DEK_NET_API, DEK_NETSHARECHECK)
  #define  DEK_EXIT_NETSHAREDEL        DEK_D0_EXIT(DEK_NET_API, DEK_NETSHAREDEL)
  #define  DEK_EXIT_NETSHAREENUM       DEK_D0_EXIT(DEK_NET_API, DEK_NETSHAREENUM)
  #define  DEK_EXIT_NETSHAREGETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETSHAREGETINFO)
  #define  DEK_EXIT_NETSHARESETINFO    DEK_D0_EXIT(DEK_NET_API, DEK_NETSHARESETINFO)
  #define  DEK_EXIT_NETSTATISTICSGET2  DEK_D0_EXIT(DEK_NET_API, DEK_NETSTATISTICSGET2)
  #define  DEK_EXIT_NETUSEADD          DEK_D0_EXIT(DEK_NET_API, DEK_NETUSEADD)
  #define  DEK_EXIT_NETUSEDEL          DEK_D0_EXIT(DEK_NET_API, DEK_NETUSEDEL)
  #define  DEK_EXIT_NETUSEENUM         DEK_D0_EXIT(DEK_NET_API, DEK_NETUSEENUM)
  #define  DEK_EXIT_NETUSEGETINFO      DEK_D0_EXIT(DEK_NET_API, DEK_NETUSEGETINFO)
  #define  DEK_EXIT_NETUSERADD         DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERADD)
  #define  DEK_EXIT_NETUSERDEL         DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERDEL)
  #define  DEK_EXIT_NETUSERENUM        DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERENUM)
  #define  DEK_EXIT_NETUSERGETGROUPS   DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERGETGROUPS)
  #define  DEK_EXIT_NETUSERGETINFO     DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERGETINFO)
  #define  DEK_EXIT_NETUSERINIT        DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERINIT)
  #define  DEK_EXIT_NETUSERMODALSGET   DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERMODALSGET)
  #define  DEK_EXIT_NETUSERMODALSSET   DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERMODALSSET)
  #define  DEK_EXIT_NETUSERPASSWORDSET DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERPASSWORDSET)
  #define  DEK_EXIT_NETUSERSETGROUPS   DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERSETGROUPS)
  #define  DEK_EXIT_NETUSERSETINFO     DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERSETINFO)
  #define  DEK_EXIT_NETUSERVALIDATE2   DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERVALIDATE2)
  #define  DEK_EXIT_NETUSERVALIDATE    DEK_D0_EXIT(DEK_NET_API, DEK_NETUSERVALIDATE)
  #define  DEK_EXIT_NETWKSTAUSERLOGON   DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTAUSERLOGON)
  #define  DEK_EXIT_NETWKSTAUSERLOGOFF  DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTAUSERLOGOFF)
  #define  DEK_EXIT_NETWKSTAUSERLOGON2  DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTAUSERLOGON2)
  #define  DEK_EXIT_NETWKSTAUSERLOGOFF2 DEK_D0_EXIT(DEK_NET_API, DEK_NETWKSTAUSERLOGOFF2)
  #define  DEK_EXIT_NETACCESSAPPLY     DEK_D0_EXIT(DEK_NET_API, DEK_NETACCESSAPPLY)

#else   /* NULL dekko macros if DEKKO flag is not define  */

  #define  DEK_ENTRY_NETACCESSADD
  #define  DEK_ENTRY_NETACCESSCHECK
  #define  DEK_ENTRY_NETACCESSDEL
  #define  DEK_ENTRY_NETACCESSENUM
  #define  DEK_ENTRY_NETACCESSGETINFO
  #define  DEK_ENTRY_NETACCESSGETUSERPERMS
  #define  DEK_ENTRY_NETACCESSSETINFO
  #define  DEK_ENTRY_NETALERTRAISE
  #define  DEK_ENTRY_NETALERTENTRY
  #define  DEK_ENTRY_NETALERTSTOP
  #define  DEK_ENTRY_NETALERTSTART
  #define  DEK_ENTRY_NETAUDITCLEAR
  #define  DEK_ENTRY_NETAUDITREAD
  #define  DEK_ENTRY_NETAUDITWRITE
  #define  DEK_ENTRY_NETCONFIGGET2
  #define  DEK_ENTRY_NETCONFIGGETALL2
  #define  DEK_ENTRY_NETCONNECTIONENUM
  #define  DEK_ENTRY_NETGETDCNAME
  #define  DEK_ENTRY_NETLOGONENUM
  #define  DEK_ENTRY_NETERRORLOGCLEAR
  #define  DEK_ENTRY_NETERRORLOGREAD
  #define  DEK_ENTRY_NETERRORLOGWRITE
  #define  DEK_ENTRY_NETFILECLOSE2
  #define  DEK_ENTRY_NETFILEENUM2
  #define  DEK_ENTRY_NETFILEGETINFO2
  #define  DEK_ENTRY_NETGROUPADD
  #define  DEK_ENTRY_NETGROUPADDUSER
  #define  DEK_ENTRY_NETGROUPDEL
  #define  DEK_ENTRY_NETGROUPDELUSER
  #define  DEK_ENTRY_NETGROUPENUM
  #define  DEK_ENTRY_NETGROUPGETINFO
  #define  DEK_ENTRY_NETGROUPGETUSERS
  #define  DEK_ENTRY_NETGROUPSETINFO
  #define  DEK_ENTRY_NETGROUPSETUSERS
  #define  DEK_ENTRY_NETHANDLEGETINFO
  #define  DEK_ENTRY_NETHANDLESETINFO
  #define  DEK_ENTRY_NETMESSAGEBUFFERSEND
  #define  DEK_ENTRY_NETMESSAGEFILESEND
  #define  DEK_ENTRY_NETMESSAGELOGFILEGET
  #define  DEK_ENTRY_NETMESSAGELOGFILESET
  #define  DEK_ENTRY_NETMESSAGENAMEADD
  #define  DEK_ENTRY_NETMESSAGENAMEDEL
  #define  DEK_ENTRY_NETMESSAGENAMEENUM
  #define  DEK_ENTRY_NETMESSAGENAMEFWD
  #define  DEK_ENTRY_NETMESSAGENAMEGETINFO
  #define  DEK_ENTRY_NETMESSAGENAMEUNFWD
  #define  DEK_ENTRY_NETREMOTECOPY
  #define  DEK_ENTRY_NETREMOTEEXEC
  #define  DEK_ENTRY_NETREMOTEMOVE
  #define  DEK_ENTRY_NETREMOTETOD
  #define  DEK_ENTRY_NETWKSTAGETINFO
  #define  DEK_ENTRY_NETWKSTASETINFO
  #define  DEK_ENTRY_NETWKSTASETUID2
  #define  DEK_ENTRY_NETCHARDEVCONTROL
  #define  DEK_ENTRY_NETCHARDEVENUM
  #define  DEK_ENTRY_NETCHARDEVGETINFO
  #define  DEK_ENTRY_NETCHARDEVQENUM
  #define  DEK_ENTRY_NETCHARDEVQGETINFO
  #define  DEK_ENTRY_NETCHARDEVQPURGE
  #define  DEK_ENTRY_NETCHARDEVQPURGESELF
  #define  DEK_ENTRY_NETCHARDEVQSETINFO
  #define  DEK_ENTRY_NETSERVERADMINCOMMAND
  #define  DEK_ENTRY_NETSERVERDISKENUM
  #define  DEK_ENTRY_NETSERVERENUM2
  #define  DEK_ENTRY_NETSERVERGETINFO
  #define  DEK_ENTRY_NETSERVERSETINFO
  #define  DEK_ENTRY_NETSERVICECONTROL
  #define  DEK_ENTRY_NETSERVICEENUM
  #define  DEK_ENTRY_NETSERVICEGETINFO
  #define  DEK_ENTRY_NETSERVICEINSTALL
  #define  DEK_ENTRY_NETSERVICESTATUS
  #define  DEK_ENTRY_NETSESSIONDEL
  #define  DEK_ENTRY_NETSESSIONENUM
  #define  DEK_ENTRY_NETSESSIONGETINFO
  #define  DEK_ENTRY_NETSHAREADD
  #define  DEK_ENTRY_NETSHARECHECK
  #define  DEK_ENTRY_NETSHAREDEL
  #define  DEK_ENTRY_NETSHAREENUM
  #define  DEK_ENTRY_NETSHAREGETINFO
  #define  DEK_ENTRY_NETSHARESETINFO
  #define  DEK_ENTRY_NETSTATISTICSGET2
  #define  DEK_ENTRY_NETUSEADD
  #define  DEK_ENTRY_NETUSEDEL
  #define  DEK_ENTRY_NETUSEENUM
  #define  DEK_ENTRY_NETUSEGETINFO
  #define  DEK_ENTRY_NETUSERADD
  #define  DEK_ENTRY_NETUSERDEL
  #define  DEK_ENTRY_NETUSERENUM
  #define  DEK_ENTRY_NETUSERGETGROUPS
  #define  DEK_ENTRY_NETUSERGETINFO
  #define  DEK_ENTRY_NETUSERINIT
  #define  DEK_ENTRY_NETUSERMODALSGET
  #define  DEK_ENTRY_NETUSERMODALSSET
  #define  DEK_ENTRY_NETUSERPASSWORDSET
  #define  DEK_ENTRY_NETUSERSETGROUPS
  #define  DEK_ENTRY_NETUSERSETINFO
  #define  DEK_ENTRY_NETUSERVALIDATE2
  #define  DEK_ENTRY_NETUSERVALIDATE
  #define  DEK_ENTRY_NETWKSTAUSERLOGON
  #define  DEK_ENTRY_NETWKSTAUSERLOGOFF
  #define  DEK_ENTRY_NETWKSTAUSERLOGON2
  #define  DEK_ENTRY_NETWKSTAUSERLOGOFF2
  #define  DEK_ENTRY_NETACCESSAPPLY

  #define  DEK_EXIT_NETACCESSADD
  #define  DEK_EXIT_NETACCESSCHECK
  #define  DEK_EXIT_NETACCESSDEL
  #define  DEK_EXIT_NETACCESSENUM
  #define  DEK_EXIT_NETACCESSGETINFO
  #define  DEK_EXIT_NETACCESSGETUSERPERMS
  #define  DEK_EXIT_NETACCESSSETINFO
  #define  DEK_EXIT_NETALERTRAISE
  #define  DEK_EXIT_NETALERTENTRY
  #define  DEK_EXIT_NETALERTSTOP
  #define  DEK_EXIT_NETALERTSTART
  #define  DEK_EXIT_NETAUDITCLEAR
  #define  DEK_EXIT_NETAUDITREAD
  #define  DEK_EXIT_NETAUDITWRITE
  #define  DEK_EXIT_NETCONFIGGET2
  #define  DEK_EXIT_NETCONFIGGETALL2
  #define  DEK_EXIT_NETCONNECTIONENUM
  #define  DEK_EXIT_NETGETDCNAME
  #define  DEK_EXIT_NETLOGONENUM
  #define  DEK_EXIT_NETERRORLOGCLEAR
  #define  DEK_EXIT_NETERRORLOGREAD
  #define  DEK_EXIT_NETERRORLOGWRITE
  #define  DEK_EXIT_NETFILECLOSE2
  #define  DEK_EXIT_NETFILEENUM2
  #define  DEK_EXIT_NETFILEGETINFO2
  #define  DEK_EXIT_NETGROUPADD
  #define  DEK_EXIT_NETGROUPADDUSER
  #define  DEK_EXIT_NETGROUPDEL
  #define  DEK_EXIT_NETGROUPDELUSER
  #define  DEK_EXIT_NETGROUPENUM
  #define  DEK_EXIT_NETGROUPGETINFO
  #define  DEK_EXIT_NETGROUPGETUSERS
  #define  DEK_EXIT_NETGROUPSETINFO
  #define  DEK_EXIT_NETGROUPSETUSERS
  #define  DEK_EXIT_NETHANDLEGETINFO
  #define  DEK_EXIT_NETHANDLESETINFO
  #define  DEK_EXIT_NETMESSAGEBUFFERSEND
  #define  DEK_EXIT_NETMESSAGEFILESEND
  #define  DEK_EXIT_NETMESSAGELOGFILEGET
  #define  DEK_EXIT_NETMESSAGELOGFILESET
  #define  DEK_EXIT_NETMESSAGENAMEADD
  #define  DEK_EXIT_NETMESSAGENAMEDEL
  #define  DEK_EXIT_NETMESSAGENAMEENUM
  #define  DEK_EXIT_NETMESSAGENAMEFWD
  #define  DEK_EXIT_NETMESSAGENAMEGETINFO
  #define  DEK_EXIT_NETMESSAGENAMEUNFWD
  #define  DEK_EXIT_NETREMOTECOPY
  #define  DEK_EXIT_NETREMOTEEXEC
  #define  DEK_EXIT_NETREMOTEMOVE
  #define  DEK_EXIT_NETREMOTETOD
  #define  DEK_EXIT_NETWKSTAGETINFO
  #define  DEK_EXIT_NETWKSTASETINFO
  #define  DEK_EXIT_NETWKSTASETUID2
  #define  DEK_EXIT_NETCHARDEVCONTROL
  #define  DEK_EXIT_NETCHARDEVENUM
  #define  DEK_EXIT_NETCHARDEVGETINFO
  #define  DEK_EXIT_NETCHARDEVQENUM
  #define  DEK_EXIT_NETCHARDEVQGETINFO
  #define  DEK_EXIT_NETCHARDEVQPURGE
  #define  DEK_EXIT_NETCHARDEVQPURGESELF
  #define  DEK_EXIT_NETCHARDEVQSETINFO
  #define  DEK_EXIT_NETSERVERADMINCOMMAND
  #define  DEK_EXIT_NETSERVERDISKENUM
  #define  DEK_EXIT_NETSERVERENUM2
  #define  DEK_EXIT_NETSERVERGETINFO
  #define  DEK_EXIT_NETSERVERSETINFO
  #define  DEK_EXIT_NETSERVICECONTROL
  #define  DEK_EXIT_NETSERVICEENUM
  #define  DEK_EXIT_NETSERVICEGETINFO
  #define  DEK_EXIT_NETSERVICEINSTALL
  #define  DEK_EXIT_NETSERVICESTATUS
  #define  DEK_EXIT_NETSESSIONDEL
  #define  DEK_EXIT_NETSESSIONENUM
  #define  DEK_EXIT_NETSESSIONGETINFO
  #define  DEK_EXIT_NETSHAREADD
  #define  DEK_EXIT_NETSHARECHECK
  #define  DEK_EXIT_NETSHAREDEL
  #define  DEK_EXIT_NETSHAREENUM
  #define  DEK_EXIT_NETSHAREGETINFO
  #define  DEK_EXIT_NETSHARESETINFO
  #define  DEK_EXIT_NETSTATISTICSGET2
  #define  DEK_EXIT_NETUSEADD
  #define  DEK_EXIT_NETUSEDEL
  #define  DEK_EXIT_NETUSEENUM
  #define  DEK_EXIT_NETUSEGETINFO
  #define  DEK_EXIT_NETUSERADD
  #define  DEK_EXIT_NETUSERDEL
  #define  DEK_EXIT_NETUSERENUM
  #define  DEK_EXIT_NETUSERGETGROUPS
  #define  DEK_EXIT_NETUSERGETINFO
  #define  DEK_EXIT_NETUSERINIT
  #define  DEK_EXIT_NETUSERMODALSGET
  #define  DEK_EXIT_NETUSERMODALSSET
  #define  DEK_EXIT_NETUSERPASSWORDSET
  #define  DEK_EXIT_NETUSERSETGROUPS
  #define  DEK_EXIT_NETUSERSETINFO
  #define  DEK_EXIT_NETUSERVALIDATE2
  #define  DEK_EXIT_NETUSERVALIDATE
  #define  DEK_EXIT_NETWKSTAUSERLOGON
  #define  DEK_EXIT_NETWKSTAUSERLOGOFF
  #define  DEK_EXIT_NETWKSTAUSERLOGON2
  #define  DEK_EXIT_NETWKSTAUSERLOGOFF2
  #define  DEK_EXIT_NETACCESSAPPLY

#endif /* DEKKO */
/**END_INTERNAL**/
