/* Include HllApi definitions */

#define WM_ZHLL_SCREEN_1 WM_USER+6000   /* ID for first screen in .PRM file   */
                                        /* Used in PM-GUIDE/2                 */

/**************************************************************************/
/* Send/Recieve file Structure                                            */
/**************************************************************************/
#define LEN_FILE 40
#define LEN_PARMS 30

/* Width of Host screen */
#define HST_LINWDTH  80

typedef struct _FILEXFER
         {
          char  pcname[LEN_FILE];    /* PC filename to be sent/received  */
          char  hostname[LEN_FILE];  /* Host filename to be sent/recvd.  */
          char  parms[LEN_PARMS];    /* Send/Receive parameters          */
         } FILEXFER;
typedef FILEXFER FAR * PFILEXFER;


/* Default Timeout length */
#define TIMEOUT      200
/**************************************************************************/
/* Message Definitions                                                    */
/**************************************************************************/
#define HLL_CONNECT  4001         /* Connect to Host Session              */
                                  /* MP1 : NULL                           */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT  0 - Successful     */
                                  /*         :         else Error value   */

#define HLL_COPYPS   4002         /* Copy Host Presentation Space (PS)    */
                                  /* MP1 : PCHAR pstring (Fill with PS)   */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT  0 - Successful     */
                                  /*         :         else Error value   */

#define HLL_COPYSTR  4003         /* Copy string from line 'n' of host    */
                                  /* MP1 : USHORT Line_Number             */
                                  /* MP2 : PCHAR  pstring (Fill with line)*/
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_DISCONN  4004         /* Disconnect from Host Session         */
                                  /* MP1 : NULL                           */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT  0 - Successful     */
                                  /*         :         else Error value   */

#define HLL_LINCHCK  4006         /* Check for existance of string on Host*/
                                  /* MP1 : Screen number (For PRM array)  */
                                  /* MP2 : NULL                           */
                                  /* Returns : TRUE - String found        */
                                  /*         : FALSE- String not found    */

#define HLL_QRYCUR   4007         /* Query Cursor position                */
                                  /* MP1 : NULL                           */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT cursor_position     */

#define HLL_RCVEFIL  4008         /* Receive file to PC from Host session */
                                  /* MP1 : Pointer to FILEXFER struct     */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error code     */

#define HLL_SCRCHCK  4011         /* Find current host screen displayed   */
                                  /* MP1 : hwnd of parent window          */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT  0 - Successful     */
                                  /*         :         else Error value   */

#define HLL_SCRCHNG  4012         /* Wait for host screen to change       */
                                  /* MP1 : hwnd of calling window         */
                                  /* MP2 : Pointer to string to be sent   */
                                  /*       to the host                    */
                                  /* Returns : USHORT  0 - Successful     */
                                  /*         :         else Error value   */

#define HLL_SEARCH   4013         /* Search for string on host            */
                                  /* MP1 : USHORT Offset to start search  */
                                  /*              from                    */
                                  /* MP2 : Pointer to string to search for*/
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SENDKEY  4014         /* Send string to host                  */
                                  /* MP1 : String to send to host         */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SENDFIL  4015         /* Send file from PC to HOST session    */
                                  /* MP1 : Pointer to FILEXFER struct     */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SETPRMS  4016         /* Set host parameters                  */
                                  /* MP1 : Pointer to parameter string    */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_VMCHNG   4017         /* Wait for host screen to change       */
                                  /* MP1 : Pointer to Control string to   */
                                  /*       send to host (eg ENTER, PF3...)*/
                                  /* MP2 : Line Number om which to check  */
                                  /*       if host change                 */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*           else   TIMERROR (96)       */

#define HLL_CHANGED  4019         /* Message sent when screen has changed */
                                  /* MP1 : USHORT return code             */
                                  /* MP2 : NULL                           */
                                  /* Returns : None                       */

#define HLL_SCREEN   4020         /* Message sent to notify what screen   */
                                  /* is currently displayed               */
                                  /* MP1 : USHORT screen id               */
                                  /* MP2 : Pointer to error text          */
                                  /* Returns : None                       */

#define HLL_SENDWAIT 4021         /* Send string to host and wait for     */
                                  /* screen to change                     */
                                  /* MP1 : hwnd of parent window          */
                                  /* MP2 : Pointer to string to send      */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SETCURSOR 4022        /* Set cursor on Host Presentation Space*/
                                  /* MP1 : USHORT Offset position         */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SENDSCRCHNG  4023     /* Wait for host screen to change       */
                                  /* MP1 : Pointer to string to be sent   */
                                  /*       to the host                    */
                                  /* MP2 : NULL                           */
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_FINDTEXT 4024         /* Check for existance of string on Host*/
                                  /* MP1 : Line Number to search on       */
                                  /* MP2 : Pointer to text to search for  */
                                  /* Returns : TRUE - String found        */
                                  /*         : FALSE- String not found    */

#define HLL_COPYSTR_OS 4025       /* Copy string from offset n of host    */
                                  /* MP1 : USHORT Offset                  */
                                  /* MP2 : PCHAR  pstring (Fill with line)*/
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_COPYSTR_OS_LEN  4026  /* Copy string from offset n of host    */
                                  /* for length of n                      */
                                  /* MP1 : USHORT Offset and Length       */
                                  /* MP2 : PCHAR  pstring (Fill with line)*/
                                  /* Returns : USHORT 0 - Successful      */
                                  /*                  else error value    */

#define HLL_SET_CURRENT_SESS 4027 /* Set Current Host Session, In shared */
                                  /* memory                              */
                                  /* MP1: new host session ID e.g. B     */
                                  /* MP2: NULL                           */
                                  /* Returns : USHORT 0 - Successful     */
                                  /*                  else error value   */


/******************************************************************************/
/* HLLAPI key definitions                                                     */
/******************************************************************************/
#define HLLK_ALT         0
#define HLLK_BACKTAB     1
#define HLLK_CLEAR       2
#define HLLK_DELCHAR     3
#define HLLK_ENTER       4
#define HLLK_ERASE       5
#define HLLK_HELP        6
#define HLLK_INSERT      7
#define HLLK_JUMP        8
#define HLLK_COPY        9
#define HLLK_LEFT       10
#define HLLK_ENLARGE    11
#define HLLK_NEW_LINE   12
#define HLLK_PRINT      13
#define HLLK_FINISH     14
#define HLLK_RESET      15
#define HLLK_SHIFT      16
#define HLLK_TAB        17
#define HLLK_UP         18
#define HLLK_DOWN       19
#define HLLK_RIGHT      20
#define HLLK_HOME       21
#define HLLK_PF1        22
#define HLLK_PF2        23
#define HLLK_PF3        24
#define HLLK_PF4        25
#define HLLK_PF5        26
#define HLLK_PF6        27
#define HLLK_PF7        28
#define HLLK_PF8        29
#define HLLK_PF9        30
#define HLLK_PF10       31
#define HLLK_PF11       32
#define HLLK_PF12       33
#define HLLK_PF13       34
#define HLLK_PF14       35
#define HLLK_PF15       36
#define HLLK_PF16       37
#define HLLK_PF17       38
#define HLLK_PF18       39
#define HLLK_PF19       40
#define HLLK_PF20       41
#define HLLK_PF21       42
#define HLLK_PF22       43
#define HLLK_PF23       44
#define HLLK_PF24       45
#define HLLK_PA1        46
#define HLLK_PA2        47
#define HLLK_PA3        48

#define ALT      "@A"
#define BACKTAB  "@B"
#define CLEAR    "@C"
#define DELCHAR  "@D"
#define ENTER    "@E"
#define ERASE    "@F"
#define HELP     "@H"
#define INSERT   "@I"
#define JUMP     "@J"
#define COPY     "@K"
#define LEFT     "@L"
#define ENLARGE  "@M"
#define NEW_LINE "@N"
#define PRINT    "@P"
#define FINISH   "@Q"
#define RESET    "@R"
#define SHIFT    "@S"
#define TAB      "@T"
#define UP       "@U"
#define DOWN     "@V"
#define RIGHT    "@Z"
#define HOME     "@0"
#define PF1      "@1"
#define PF2      "@2"
#define PF3      "@3"
#define PF4      "@4"
#define PF5      "@5"
#define PF6      "@6"
#define PF7      "@7"
#define PF8      "@8"
#define PF9      "@9"
#define PF10     "@a"
#define PF11     "@b"
#define PF12     "@c"
#define PF13     "@d"
#define PF14     "@e"
#define PF15     "@f"
#define PF16     "@g"
#define PF17     "@h"
#define PF18     "@i"
#define PF19     "@j"
#define PF20     "@k"
#define PF21     "@l"
#define PF22     "@m"
#define PF23     "@n"
#define PF24     "@o"
#define PA1      "@x"
#define PA2      "@y"
#define PA3      "@z"

PCHAR hllapi_keys[]={
       ALT      , BACKTAB , CLEAR  , DELCHAR ,
       ENTER    , ERASE   , HELP   , INSERT  ,
       JUMP     , COPY    , LEFT   , ENLARGE ,
       NEW_LINE , PRINT   , FINISH , RESET   ,
       SHIFT    , TAB     , UP     , DOWN    ,
       RIGHT    , HOME    , PF1    , PF2     ,
       PF3      , PF4     , PF5    , PF6     ,
       PF7      , PF8     , PF9    , PF10    ,
       PF11     , PF12    , PF13   , PF14    ,
       PF15     , PF16    , PF17   , PF18    ,
       PF19     , PF20    , PF21   , PF22    ,
       PF23     , PF24    , PA1    , PA2     ,
       PA3 };

/******************************************************************************/
/* User Defined HLLAPI screens                                                */
/******************************************************************************/
#define WM_ZHLL_SCREEN_01  WM_USER+6000
#define WM_ZHLL_SCREEN_02  WM_USER+6001
#define WM_ZHLL_SCREEN_03  WM_USER+6002
#define WM_ZHLL_SCREEN_04  WM_USER+6003
#define WM_ZHLL_SCREEN_05  WM_USER+6004
#define WM_ZHLL_SCREEN_06  WM_USER+6005
#define WM_ZHLL_SCREEN_07  WM_USER+6006
#define WM_ZHLL_SCREEN_08  WM_USER+6007
#define WM_ZHLL_SCREEN_09  WM_USER+6008
#define WM_ZHLL_SCREEN_10  WM_USER+6009
#define WM_ZHLL_SCREEN_11  WM_USER+6010
#define WM_ZHLL_SCREEN_12  WM_USER+6011
#define WM_ZHLL_SCREEN_13  WM_USER+6012
#define WM_ZHLL_SCREEN_14  WM_USER+6013
#define WM_ZHLL_SCREEN_15  WM_USER+6014
#define WM_ZHLL_SCREEN_16  WM_USER+6015
#define WM_ZHLL_SCREEN_17  WM_USER+6016
#define WM_ZHLL_SCREEN_18  WM_USER+6017
#define WM_ZHLL_SCREEN_19  WM_USER+6018
#define WM_ZHLL_SCREEN_20  WM_USER+6019
#define WM_ZHLL_SCREEN_21  WM_USER+6020
#define WM_ZHLL_SCREEN_22  WM_USER+6021
#define WM_ZHLL_SCREEN_23  WM_USER+6022
#define WM_ZHLL_SCREEN_24  WM_USER+6023
#define WM_ZHLL_SCREEN_25  WM_USER+6024
#define WM_ZHLL_SCREEN_26  WM_USER+6025
#define WM_ZHLL_SCREEN_27  WM_USER+6026
#define WM_ZHLL_SCREEN_28  WM_USER+6027
#define WM_ZHLL_SCREEN_29  WM_USER+6028
#define WM_ZHLL_SCREEN_30  WM_USER+6029

#define WM_ZHLL_ERROR_1    WM_USER+6500
#define WM_ZHLL_ERROR_2    WM_USER+6501
#define WM_ZHLL_ERROR_3    WM_USER+6502
#define WM_ZHLL_ERROR_4    WM_USER+6503
#define WM_ZHLL_ERROR_5    WM_USER+6504
